/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria.additional;

import java.util.Map;
import java.util.Set;
import org.cpsolver.coursett.criteria.TimetablingCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;

public class RoomSizePenalty
extends TimetablingCriterion {
    private double iRoomSizeFactor = 1.0;

    @Override
    public boolean init(Solver<Lecture, Placement> solver) {
        super.init(solver);
        this.iRoomSizeFactor = solver.getProperties().getPropertyDouble("Comparator.RoomSizeFactor", 1.05);
        return true;
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.RoomSizeWeight", 0.001);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.RoomSizeWeight";
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        if (((Lecture)value.variable()).getNrRooms() <= 0) {
            return 0.0;
        }
        double size = 0.0;
        if (value.getRoomLocation() != null) {
            size = value.getRoomLocation().getRoomSize();
        } else if (value.getRoomLocations() != null) {
            for (RoomLocation room : value.getRoomLocations()) {
                size += (double)room.getRoomSize();
            }
            size /= (double)value.getNrRooms();
        }
        double diff = size - (double)((Lecture)value.variable()).minRoomSize();
        return diff < 0.0 ? 0.0 : Math.pow(diff, this.iRoomSizeFactor);
    }

    @Override
    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info) {
        if (this.getValue(assignment) != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(Math.pow(this.getValue(assignment) / (double)this.getModel().nrAssignedVariables(assignment), 1.0 / this.iRoomSizeFactor)));
        }
    }
}

