/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria.additional;

import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.criteria.TimetablingCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.solver.Solver;

public class InstructorLunchBreak
extends TimetablingCriterion {
    private double iMultiplier;
    private int iLunchStart;
    private int iLunchEnd;
    private int iLunchLength;
    private boolean iFullInfo;
    private List<BitSet> iWeeks = null;

    public InstructorLunchBreak() {
        this.setValueUpdateType(AbstractCriterion.ValueUpdateType.AfterUnassignedAfterAssigned);
    }

    @Override
    public boolean init(Solver<Lecture, Placement> solver) {
        super.init(solver);
        this.iWeight = solver.getProperties().getPropertyDouble("InstructorLunch.Weight", 0.3);
        this.iLunchStart = solver.getProperties().getPropertyInt("InstructorLunch.StartSlot", 132);
        this.iLunchEnd = solver.getProperties().getPropertyInt("InstructorLunch.EndSlot", 162);
        this.iLunchLength = solver.getProperties().getPropertyInt("InstructorLunch.Length", 6);
        this.iMultiplier = solver.getProperties().getPropertyDouble("InstructorLunch.Multiplier", 1.2);
        this.iFullInfo = solver.getProperties().getPropertyBoolean("InstructorLunch.InfoShowViolations", false);
        return true;
    }

    protected List<BitSet> getWeeks() {
        if (this.iWeeks == null) {
            TimetableModel model = (TimetableModel)this.getModel();
            this.iWeeks = model.getWeeks();
        }
        return this.iWeeks;
    }

    private boolean isEmpty(InstructorConstraint.InstructorConstraintContext ic, int slot, BitSet week, Placement p) {
        if (p.getTimeLocation().getStartSlot() <= slot && slot < p.getTimeLocation().getStartSlot() + p.getTimeLocation().getLength() && p.getTimeLocation().shareWeeks(week)) {
            return false;
        }
        List<Placement> placements = ic.getPlacements(slot, week);
        return placements.isEmpty() || placements.size() == 1 && ((Lecture)placements.get(0).variable()).equals(p.variable());
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        double ret = 0.0;
        if (value.getTimeLocation().getStartSlot() <= this.iLunchEnd && value.getTimeLocation().getStartSlot() + value.getTimeLocation().getLength() > this.iLunchStart) {
            InstructorLunchBreakContext context = (InstructorLunchBreakContext)this.getContext((Assignment)assignment);
            for (InstructorConstraint constraint : ((Lecture)value.variable()).getInstructorConstraints()) {
                InstructorConstraint.InstructorConstraintContext icx = (InstructorConstraint.InstructorConstraintContext)constraint.getContext((Assignment)assignment);
                CompactInfo compactInfo = context.getCompactInfo(constraint);
                for (int i = 0; i < Constants.NR_DAYS; ++i) {
                    if ((value.getTimeLocation().getDayCode() & Constants.DAY_CODES[i]) == 0) continue;
                    int currentLunchStartSlot = 288 * i + this.iLunchStart;
                    int currentLunchEndSlot = 288 * i + this.iLunchEnd;
                    int semesterViolations = 0;
                    for (BitSet week : this.getWeeks()) {
                        int maxBreak = 0;
                        int currentBreak = 0;
                        for (int slot = currentLunchStartSlot; slot < currentLunchEndSlot; ++slot) {
                            if (this.isEmpty(icx, slot, week, value)) {
                                if (maxBreak >= ++currentBreak) continue;
                                maxBreak = currentBreak;
                                continue;
                            }
                            currentBreak = 0;
                        }
                        if (maxBreak >= this.iLunchLength) continue;
                        ++semesterViolations;
                    }
                    ret += (double)(semesterViolations - compactInfo.getLunchDayViolations()[i]);
                }
            }
        }
        return ret;
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        double lunchValue = 0.0;
        HashSet<InstructorConstraint> constraints = new HashSet<InstructorConstraint>();
        for (Lecture lecture : variables) {
            constraints.addAll(lecture.getInstructorConstraints());
        }
        for (InstructorConstraint instructor : constraints) {
            lunchValue += ((InstructorLunchBreakContext)this.getContext((Assignment)assignment)).getLunchPreference(assignment, instructor);
        }
        return lunchValue;
    }

    @Override
    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info) {
        TreeSet<String> violatedLunchBreaks = new TreeSet<String>();
        int lunchViolations = 0;
        for (InstructorConstraint c : ((TimetableModel)this.getModel()).getInstructorConstraints()) {
            String days = "";
            CompactInfo compactInfo = ((InstructorLunchBreakContext)this.getContext((Assignment)assignment)).getCompactInfo(c);
            for (int i = 0; i < Constants.NR_DAYS; ++i) {
                if (compactInfo.getLunchDayViolations()[i] <= 0) continue;
                if (this.iFullInfo) {
                    days = days + (days.isEmpty() ? "" : ", ") + compactInfo.getLunchDayViolations()[i] + " &times; " + Constants.DAY_NAMES_SHORT[i];
                }
                lunchViolations += compactInfo.getLunchDayViolations()[i];
            }
            if (!this.iFullInfo || days.isEmpty()) continue;
            violatedLunchBreaks.add(c.getName() + ": " + days);
        }
        if (lunchViolations > 0) {
            info.put("Lunch breaks", this.getPerc(lunchViolations, 0.0, ((TimetableModel)this.getModel()).getInstructorConstraints().size() * Constants.NR_DAYS * this.getWeeks().size()) + "% (" + lunchViolations + ")");
            if (this.iFullInfo && !violatedLunchBreaks.isEmpty()) {
                String message = "";
                for (String s : violatedLunchBreaks) {
                    message = message + (message.isEmpty() ? "" : "<br>") + s;
                }
                info.put("Lunch break violations", message);
            }
        }
    }

    @Override
    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info, Collection<Lecture> variables) {
        HashSet<InstructorConstraint> constraints = new HashSet<InstructorConstraint>();
        for (Lecture lecture : variables) {
            for (InstructorConstraint c : lecture.getInstructorConstraints()) {
                constraints.add(c);
            }
        }
        TreeSet<String> violatedLunchBreaks = new TreeSet<String>();
        int lunchViolations = 0;
        for (InstructorConstraint c : constraints) {
            String days = "";
            CompactInfo compactInfo = ((InstructorLunchBreakContext)this.getContext((Assignment)assignment)).getCompactInfo(c);
            for (int i = 0; i < Constants.NR_DAYS; ++i) {
                if (compactInfo.getLunchDayViolations()[i] <= 0) continue;
                if (this.iFullInfo) {
                    days = days + (days.isEmpty() ? "" : ", ") + compactInfo.getLunchDayViolations()[i] + " &times; " + Constants.DAY_NAMES_SHORT[i];
                }
                lunchViolations += compactInfo.getLunchDayViolations()[i];
            }
            if (!this.iFullInfo || days.isEmpty()) continue;
            violatedLunchBreaks.add(c.getName() + ": " + days);
        }
        if (lunchViolations > 0) {
            info.put("Lunch breaks", this.getPerc(lunchViolations, 0.0, constraints.size() * Constants.NR_DAYS * this.getWeeks().size()) + "% (" + lunchViolations + ")");
            if (this.iFullInfo && !violatedLunchBreaks.isEmpty()) {
                String message = "";
                for (String s : violatedLunchBreaks) {
                    message = message + (message.isEmpty() ? "" : "; ") + s;
                }
                info.put("Lunch break violations", message);
            }
        }
    }

    @Override
    public AbstractCriterion.ValueContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new InstructorLunchBreakContext(assignment);
    }

    public class InstructorLunchBreakContext
    extends AbstractCriterion.ValueContext {
        private Map<InstructorConstraint, CompactInfo> iCompactInfos;

        protected InstructorLunchBreakContext(Assignment<Lecture, Placement> assignment) {
            super(InstructorLunchBreak.this);
            this.iCompactInfos = new HashMap<InstructorConstraint, CompactInfo>();
            for (InstructorConstraint constraint : ((TimetableModel)InstructorLunchBreak.this.getModel()).getInstructorConstraints()) {
                this.iTotal += this.computeLunchPenalty(assignment, constraint);
            }
        }

        protected void unassigned(Assignment<Lecture, Placement> assignment, Placement value) {
            for (InstructorConstraint constraint : ((Lecture)value.variable()).getInstructorConstraints()) {
                this.updateCriterion(assignment, constraint, value);
            }
        }

        protected void assigned(Assignment<Lecture, Placement> assignment, Placement value) {
            for (InstructorConstraint constraint : ((Lecture)value.variable()).getInstructorConstraints()) {
                this.updateCriterion(assignment, constraint, value);
            }
        }

        public void updateCriterion(Assignment<Lecture, Placement> assignment, InstructorConstraint instructorConstraint, Placement placement) {
            this.iTotal -= this.getLunchPreference(assignment, instructorConstraint);
            this.updateLunchPenalty(assignment, instructorConstraint, placement);
            this.iTotal += this.getLunchPreference(assignment, instructorConstraint);
        }

        protected CompactInfo getCompactInfo(InstructorConstraint constraint) {
            CompactInfo info = this.iCompactInfos.get(constraint);
            if (info == null) {
                info = new CompactInfo();
                this.iCompactInfos.put(constraint, info);
            }
            return info;
        }

        public void updateLunchPenalty(Assignment<Lecture, Placement> assignment, InstructorConstraint constraint, Placement p) {
            if (p.getTimeLocation().getStartSlot() <= InstructorLunchBreak.this.iLunchEnd && p.getTimeLocation().getStartSlot() + p.getTimeLocation().getLength() > InstructorLunchBreak.this.iLunchStart) {
                CompactInfo compactInfo = this.getCompactInfo(constraint);
                for (int i = 0; i < Constants.NR_DAYS; ++i) {
                    if ((p.getTimeLocation().getDayCode() & Constants.DAY_CODES[i]) == 0) continue;
                    int currentLunchStartSlot = 288 * i + InstructorLunchBreak.this.iLunchStart;
                    int currentLunchEndSlot = 288 * i + InstructorLunchBreak.this.iLunchEnd;
                    int semesterViolations = 0;
                    for (BitSet week : InstructorLunchBreak.this.getWeeks()) {
                        int maxBreak = 0;
                        int currentBreak = 0;
                        for (int slot = currentLunchStartSlot; slot < currentLunchEndSlot; ++slot) {
                            if (((InstructorConstraint.InstructorConstraintContext)constraint.getContext((Assignment)assignment)).getPlacements(slot, week).isEmpty()) {
                                if (maxBreak >= ++currentBreak) continue;
                                maxBreak = currentBreak;
                                continue;
                            }
                            currentBreak = 0;
                        }
                        if (maxBreak >= InstructorLunchBreak.this.iLunchLength) continue;
                        ++semesterViolations;
                    }
                    compactInfo.getLunchDayViolations()[i] = semesterViolations;
                }
            }
        }

        public double computeLunchPenalty(Assignment<Lecture, Placement> assignment, InstructorConstraint constraint) {
            double violations = 0.0;
            CompactInfo compactInfo = this.getCompactInfo(constraint);
            for (int i = 0; i < Constants.NR_DAYS; ++i) {
                int currentLunchStartSlot = 288 * i + InstructorLunchBreak.this.iLunchStart;
                int currentLunchEndSlot = 288 * i + InstructorLunchBreak.this.iLunchEnd;
                int semesterViolations = 0;
                for (BitSet week : InstructorLunchBreak.this.getWeeks()) {
                    int maxBreak = 0;
                    int currentBreak = 0;
                    for (int slot = currentLunchStartSlot; slot < currentLunchEndSlot; ++slot) {
                        if (((InstructorConstraint.InstructorConstraintContext)constraint.getContext((Assignment)assignment)).getPlacements(slot, week).isEmpty()) {
                            if (maxBreak >= ++currentBreak) continue;
                            maxBreak = currentBreak;
                            continue;
                        }
                        currentBreak = 0;
                    }
                    if (maxBreak >= InstructorLunchBreak.this.iLunchLength) continue;
                    ++semesterViolations;
                }
                compactInfo.getLunchDayViolations()[i] = semesterViolations;
                violations += (double)semesterViolations;
            }
            return Math.pow(violations, InstructorLunchBreak.this.iMultiplier);
        }

        private double getLunchPreference(Assignment<Lecture, Placement> assignment, InstructorConstraint instructorConstraint) {
            double violations = 0.0;
            CompactInfo info = this.getCompactInfo(instructorConstraint);
            for (int i = 0; i < Constants.NR_DAYS; ++i) {
                violations += (double)info.getLunchDayViolations()[i];
            }
            return Math.pow(violations, InstructorLunchBreak.this.iMultiplier);
        }
    }

    public static class CompactInfo {
        private int[] iLunchDayViolations = new int[Constants.NR_DAYS];

        public int[] getLunchDayViolations() {
            return this.iLunchDayViolations;
        }
    }
}

