/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.criteria.TimetablingCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.solver.Solver;

public class FlexibleConstraintCriterion
extends TimetablingCriterion {
    private boolean iDebug;

    public FlexibleConstraintCriterion() {
        this.setValueUpdateType(AbstractCriterion.ValueUpdateType.NoUpdate);
    }

    @Override
    public boolean init(Solver<Lecture, Placement> solver) {
        super.init(solver);
        this.iWeight = solver.getProperties().getPropertyDouble("FlexibleConstraint.Weight", 1.0);
        this.iDebug = solver.getProperties().getPropertyBoolean("FlexibleConstraint.Debug", true);
        return true;
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.FlexibleConstrPreferenceWeight";
    }

    @Override
    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info) {
        TimetableModel m = (TimetableModel)this.getModel();
        if (m.getFlexibleConstraints().isEmpty()) {
            return;
        }
        for (FlexibleConstraint.FlexibleConstraintType type : FlexibleConstraint.FlexibleConstraintType.values()) {
            StringBuilder debug = null;
            int violated = 0;
            int constraints = 0;
            for (FlexibleConstraint c : m.getFlexibleConstraints()) {
                if (!type.equals((Object)c.getType())) continue;
                ++constraints;
                if (!(((FlexibleConstraint.FlexibleConstraintContext)c.getContext((Assignment)assignment)).getPreference() > 0.0)) continue;
                ++violated;
                if (!this.iDebug) continue;
                if (debug == null) {
                    debug = new StringBuilder(c.getOwner() + " (" + sDoubleFormat.format(c.getNrViolations(assignment, new HashSet<Placement>(), null)) + ")");
                    continue;
                }
                debug.append("; " + c.getOwner() + " (" + sDoubleFormat.format(c.getNrViolations(assignment, new HashSet<Placement>(), null)) + ")");
            }
            if (constraints <= 0) continue;
            info.put(type.getName() + " Constraints", this.getPerc(violated, 0.0, constraints) + "% (" + violated + ")");
            if (!this.iDebug || violated <= 0) continue;
            info.put(type.getName() + " Violations", debug.toString());
        }
    }

    @Override
    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info, Collection<Lecture> variables) {
        for (FlexibleConstraint.FlexibleConstraintType type : FlexibleConstraint.FlexibleConstraintType.values()) {
            HashSet<FlexibleConstraint> constraints = new HashSet<FlexibleConstraint>();
            for (Lecture lecture : variables) {
                for (FlexibleConstraint c : lecture.getFlexibleGroupConstraints()) {
                    if (!type.equals((Object)c.getType())) continue;
                    constraints.add(c);
                }
            }
            if (constraints.isEmpty()) continue;
            int violated = 0;
            StringBuilder debug = null;
            for (FlexibleConstraint c : constraints) {
                if (!(((FlexibleConstraint.FlexibleConstraintContext)c.getContext((Assignment)assignment)).getPreference() > 0.0)) continue;
                ++violated;
                if (!this.iDebug) continue;
                if (debug == null) {
                    debug = new StringBuilder(c.getOwner());
                    continue;
                }
                debug.append("; " + c.getOwner());
            }
            info.put(type.getName() + " Constraints", this.getPerc(violated, 0.0, constraints.size()) + "% (" + violated + ")");
            if (!this.iDebug || violated <= 0) continue;
            info.put(type.getName() + " Violations", debug.toString());
        }
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        HashSet<FlexibleConstraint> flexibleConstraints = new HashSet<FlexibleConstraint>();
        for (Lecture lecture : variables) {
            flexibleConstraints.addAll(lecture.getFlexibleGroupConstraints());
        }
        int ret = 0;
        for (FlexibleConstraint gc : flexibleConstraints) {
            ret = (int)((double)ret + ((FlexibleConstraint.FlexibleConstraintContext)gc.getContext((Assignment)assignment)).getPreference());
        }
        return ret;
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        HashMap<Lecture, Placement> assignments = new HashMap<Lecture, Placement>();
        assignments.put((Lecture)value.variable(), value);
        double ret = 0.0;
        for (FlexibleConstraint gc : ((Lecture)value.variable()).getFlexibleGroupConstraints()) {
            ret += gc.getCurrentPreference(assignment, conflicts, assignments);
        }
        assignments.put((Lecture)value.variable(), (Placement)null);
        for (FlexibleConstraint gc : ((Lecture)value.variable()).getFlexibleGroupConstraints()) {
            ret -= gc.getCurrentPreference(assignment, conflicts, assignments);
        }
        return ret;
    }
}

