/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util;

import biweekly.property.DateStart;
import biweekly.util.DateTimeComponents;
import biweekly.util.ICalDate;
import biweekly.util.Recurrence;
import com.google.ical.values.DateTimeValue;
import com.google.ical.values.DateTimeValueImpl;
import com.google.ical.values.DateValue;
import com.google.ical.values.Frequency;
import com.google.ical.values.RRule;
import com.google.ical.values.Weekday;
import com.google.ical.values.WeekdayNum;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Google2445Utils {
    public static DateTimeValue convert(DateStart dtstart) {
        ICalDate value = (ICalDate)dtstart.getValue();
        if (value == null) {
            return null;
        }
        DateTimeComponents raw = value.getRawComponents();
        if (raw == null) {
            raw = new DateTimeComponents(value);
        }
        return new DateTimeValueImpl(raw.getYear(), raw.getMonth(), raw.getDate(), raw.getHour(), raw.getMinute(), raw.getSecond());
    }

    public static RRule convert(Recurrence recur) {
        Recurrence.DayOfWeek workweekStarts;
        ICalDate until;
        Integer interval;
        Recurrence.Frequency freq;
        RRule googleRRule = new RRule();
        ArrayList<WeekdayNum> weekdayNums = new ArrayList<WeekdayNum>();
        for (Recurrence.ByDay byDay : recur.getByDay()) {
            Integer prefix = byDay.getNum();
            if (prefix == null) {
                prefix = 0;
            }
            weekdayNums.add(new WeekdayNum(prefix, Google2445Utils.convert(byDay.getDay())));
        }
        googleRRule.setByDay(weekdayNums);
        googleRRule.setByYearDay(Google2445Utils.toArray(recur.getByYearDay()));
        googleRRule.setByMonth(Google2445Utils.toArray(recur.getByMonth()));
        googleRRule.setByWeekNo(Google2445Utils.toArray(recur.getByWeekNo()));
        googleRRule.setByMonthDay(Google2445Utils.toArray(recur.getByMonthDay()));
        googleRRule.setByHour(Google2445Utils.toArray(recur.getByHour()));
        googleRRule.setByMinute(Google2445Utils.toArray(recur.getByMinute()));
        googleRRule.setBySecond(Google2445Utils.toArray(recur.getBySecond()));
        googleRRule.setBySetPos(Google2445Utils.toArray(recur.getBySetPos()));
        Integer count = recur.getCount();
        if (count != null) {
            googleRRule.setCount(count);
        }
        if ((freq = recur.getFrequency()) != null) {
            googleRRule.setFreq(Google2445Utils.convert(freq));
        }
        if ((interval = recur.getInterval()) != null) {
            googleRRule.setInterval(interval);
        }
        if ((until = recur.getUntil()) != null) {
            googleRRule.setUntil(Google2445Utils.convert(until));
        }
        if ((workweekStarts = recur.getWorkweekStarts()) != null) {
            googleRRule.setWkSt(Google2445Utils.convert(workweekStarts));
        }
        return googleRRule;
    }

    public static Weekday convert(Recurrence.DayOfWeek day) {
        switch (day) {
            case SUNDAY: {
                return Weekday.SU;
            }
            case MONDAY: {
                return Weekday.MO;
            }
            case TUESDAY: {
                return Weekday.TU;
            }
            case WEDNESDAY: {
                return Weekday.WE;
            }
            case THURSDAY: {
                return Weekday.TH;
            }
            case FRIDAY: {
                return Weekday.FR;
            }
            case SATURDAY: {
                return Weekday.SA;
            }
        }
        return null;
    }

    public static Frequency convert(Recurrence.Frequency freq) {
        switch (freq) {
            case YEARLY: {
                return Frequency.YEARLY;
            }
            case MONTHLY: {
                return Frequency.MONTHLY;
            }
            case WEEKLY: {
                return Frequency.WEEKLY;
            }
            case DAILY: {
                return Frequency.DAILY;
            }
            case HOURLY: {
                return Frequency.HOURLY;
            }
            case MINUTELY: {
                return Frequency.MINUTELY;
            }
            case SECONDLY: {
                return Frequency.SECONDLY;
            }
        }
        return null;
    }

    public static DateValue convert(ICalDate date) {
        DateTimeComponents raw = date.getRawComponents();
        if (raw == null) {
            raw = new DateTimeComponents(date);
        }
        return new DateTimeValueImpl(raw.getYear(), raw.getMonth(), raw.getDate(), raw.getHour(), raw.getMinute(), raw.getSecond());
    }

    private static int[] toArray(List<Integer> list) {
        int[] array = new int[list.size()];
        int i = 0;
        for (Integer intObj : list) {
            array[i++] = intObj == null ? 0 : intObj;
        }
        return array;
    }

    private Google2445Utils() {
    }
}

