/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil.timegrid;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.unitime.commons.NaturalOrderComparator;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;

public class TimetableGridCell
implements Serializable,
Comparable {
    private static final long serialVersionUID = 2L;
    private String iName;
    private String iShortComment;
    private String iShortCommentNoColors;
    private String iInstructor;
    private String iOnClick;
    private String iTitle;
    private String iBackground;
    private int iLength;
    private int iNrMeetings;
    private int iMeetingNumber;
    private long iAssignmentId;
    private long iRoomId;
    private String iRoomName;
    private BitSet iWeekCode;
    private String iDatePatternName;
    private int iDay;
    private int iSlot;
    private String iTime;
    public static String sBgColorEmpty = "rgb(255,255,255)";
    public static String sBgColorRequired = "rgb(80,80,200)";
    public static String sBgColorStronglyPreferred = "rgb(40,180,60)";
    public static String sBgColorPreferred = "rgb(170,240,60)";
    public static String sBgColorNeutral = "rgb(240,240,240)";
    public static String sBgColorDiscouraged = "rgb(240,210,60)";
    public static String sBgColorStronglyDiscouraged = "rgb(240,120,60)";
    public static String sBgColorProhibited = "rgb(220,50,40)";
    public static String sBgColorNotAvailable = "rgb(200,200,200)";
    public static String sBgColorNotAvailableButAssigned = sBgColorProhibited;
    private TimetableGridCell iParent = null;

    public TimetableGridCell(int day, int slot, long assignmentId, long roomId, String roomName, String name, String shortComment, String shortCommentNoColors, String onClick, String title, String background, int length, int meetingNumber, int nrMeetings, String datePatternName, BitSet weekCode, String instructor, String time) {
        this.iDay = day;
        this.iSlot = slot;
        this.iAssignmentId = assignmentId;
        this.iName = name;
        this.iShortComment = shortComment;
        this.iShortCommentNoColors = shortCommentNoColors;
        this.iOnClick = onClick;
        this.iTitle = title;
        this.iBackground = background;
        this.iLength = length;
        this.iMeetingNumber = meetingNumber;
        this.iNrMeetings = nrMeetings;
        this.iRoomName = roomName;
        this.iRoomId = roomId;
        this.iWeekCode = weekCode;
        this.iDatePatternName = datePatternName;
        this.iInstructor = instructor;
        this.iTime = time;
    }

    public TimetableGridCell copyCell(int day, int mtgNumber) {
        TimetableGridCell cell = new TimetableGridCell(day, this.iSlot, this.iAssignmentId, this.iRoomId, this.iRoomName, this.iName, this.iShortComment, this.iShortCommentNoColors, this.iOnClick, this.iTitle, this.iBackground, this.iLength, mtgNumber, this.iNrMeetings, this.iDatePatternName, this.iWeekCode, this.iInstructor, this.iTime);
        cell.iParent = this;
        return cell;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getShortComment() {
        return this.iShortComment;
    }

    public String getShortCommentNoColors() {
        return this.iShortCommentNoColors;
    }

    public String getOnClick() {
        return this.iOnClick;
    }

    public String getTitle() {
        return this.iTitle;
    }

    public String getBackground() {
        return this.iBackground == null ? sBgColorEmpty : this.iBackground;
    }

    public int getLength() {
        return this.iLength;
    }

    public int getNrMeetings() {
        return this.iNrMeetings;
    }

    public int getMeetingNumber() {
        return this.iMeetingNumber;
    }

    public long getAssignmentId() {
        return this.iAssignmentId;
    }

    public long getRoomId() {
        return this.iRoomId;
    }

    public String getRoomName() {
        return this.iRoomName;
    }

    public void setRoomName(String roomName) {
        this.iRoomName = roomName;
    }

    public String getInstructor() {
        return this.iInstructor == null ? "" : this.iInstructor;
    }

    public String getTime() {
        return this.iTime;
    }

    public static String pref2color(String pref) {
        return PreferenceLevel.prolog2bgColor(pref);
    }

    public static String pref2color(int pref) {
        return PreferenceLevel.prolog2bgColor(PreferenceLevel.int2prolog(pref));
    }

    public static String conflicts2color(int nrConflicts) {
        if (nrConflicts > 15) {
            nrConflicts = 15;
        }
        String color = null;
        color = nrConflicts == 0 ? "rgb(240,240,240)" : (nrConflicts < 5 ? "rgb(240," + (240 - 30 * nrConflicts / 5) + "," + (240 - 180 * nrConflicts / 5) + ")" : (nrConflicts < 10 ? "rgb(240," + (210 - 90 * (nrConflicts - 5) / 5) + ",60)" : "rgb(" + (240 - 20 * (nrConflicts - 10) / 5) + "," + (120 - 70 * (nrConflicts - 10) / 5) + "," + (60 - 20 * (nrConflicts - 10) / 5) + ")"));
        return color;
    }

    public static String conflicts2colorFast(int nrConflicts) {
        if (nrConflicts == 0) {
            return "rgb(240,240,240)";
        }
        if (nrConflicts == 1) {
            return "rgb(240,210,60)";
        }
        if (nrConflicts == 2) {
            return "rgb(240,120,60)";
        }
        return "rgb(220,50,40)";
    }

    public BitSet getWeekCode() {
        return this.iWeekCode;
    }

    public int compareTo(Object o) {
        int cmp;
        if (o == null || !(o instanceof TimetableGridCell)) {
            return -1;
        }
        TimetableGridCell c = (TimetableGridCell)o;
        int n = cmp = this.iWeekCode == null || c.iWeekCode == null ? 0 : Double.compare(this.iWeekCode.nextSetBit(0), c.iWeekCode.nextSetBit(0));
        if (cmp != 0) {
            return cmp;
        }
        int n2 = cmp = this.iWeekCode == null || c.iWeekCode == null ? 0 : Double.compare(this.iWeekCode.length(), c.iWeekCode.length());
        if (cmp != 0) {
            return cmp;
        }
        return new NaturalOrderComparator().compare(this.iName, c.iName);
    }

    public boolean hasDays() {
        return this.iWeekCode != null && this.iDatePatternName != null;
    }

    public String getDays() {
        return this.iDatePatternName;
    }

    public void setDays(String days) {
        this.iDatePatternName = days;
    }

    public int getDay() {
        return this.iDay;
    }

    public int getSlot() {
        return this.iSlot;
    }

    public static String formatDatePattern(DatePattern dp, int dayCode) {
        int idx;
        if (dp == null || dp.isDefault()) {
            return null;
        }
        String format = ApplicationProperty.DatePatternFormatUseDates.value();
        if ("never".equals(format)) {
            return dp.getName();
        }
        if ("extended".equals(format) && dp.getType() != 3) {
            return dp.getName();
        }
        if ("alternate".equals(format) && dp.getType() == 1) {
            return dp.getName();
        }
        BitSet weekCode = dp.getPatternBitSet();
        if (weekCode.isEmpty()) {
            return dp.getName();
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setLenient(true);
        Date dpFirstDate = DateUtils.getDate(1, dp.getSession().getPatternStartMonth(), dp.getSession().getSessionStartYear());
        cal.setTime(dpFirstDate);
        cal.add(6, idx);
        Date first = null;
        for (idx = weekCode.nextSetBit(0); idx < weekCode.size() && first == null; ++idx) {
            if (weekCode.get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if ((dayCode & DayCode.MON.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 3: {
                        if ((dayCode & DayCode.TUE.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 4: {
                        if ((dayCode & DayCode.WED.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 5: {
                        if ((dayCode & DayCode.THU.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 6: {
                        if ((dayCode & DayCode.FRI.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 7: {
                        if ((dayCode & DayCode.SAT.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 1: {
                        if ((dayCode & DayCode.SUN.getCode()) == 0) break;
                        first = cal.getTime();
                    }
                }
            }
            cal.add(6, 1);
        }
        if (first == null) {
            return dp.getName();
        }
        cal.setTime(dpFirstDate);
        cal.add(6, idx);
        Date last = null;
        for (idx = weekCode.length() - 1; idx >= 0 && last == null; --idx) {
            if (weekCode.get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if ((dayCode & DayCode.MON.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 3: {
                        if ((dayCode & DayCode.TUE.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 4: {
                        if ((dayCode & DayCode.WED.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 5: {
                        if ((dayCode & DayCode.THU.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 6: {
                        if ((dayCode & DayCode.FRI.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 7: {
                        if ((dayCode & DayCode.SAT.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 1: {
                        if ((dayCode & DayCode.SUN.getCode()) == 0) break;
                        last = cal.getTime();
                    }
                }
            }
            cal.add(6, -1);
        }
        if (last == null) {
            return dp.getName();
        }
        Formats.Format<Date> dpf = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
        return dpf.format(first) + (first.equals(last) ? "" : " - " + dpf.format(last));
    }

    public TimetableGridCell getParent() {
        return this.iParent;
    }
}

