/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil.csv;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.TreeSet;
import org.cpsolver.ifs.util.CSVFile;
import org.unitime.timetable.form.ClassListForm;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.CachedClassAssignmentProxy;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamAssignmentProxy;
import org.unitime.timetable.webutil.csv.CsvInstructionalOfferingTableBuilder;

public class CsvClassListTableBuilder
extends CsvInstructionalOfferingTableBuilder {
    protected String additionalNote() {
        return new String();
    }

    protected String labelForTable(SubjectArea subjectArea) {
        StringBuffer sb = new StringBuffer();
        sb.append(subjectArea.getSubjectAreaAbbreviation());
        sb.append(" - ");
        sb.append(subjectArea.getSession().getLabel());
        sb.append(this.additionalNote());
        return sb.toString();
    }

    public void csvTableForClasses(PrintWriter out, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, ClassListForm form, SessionContext context) throws Exception {
        this.setVisibleColumns(form);
        TreeSet classes = (TreeSet)form.getClasses();
        if (this.isShowTimetable()) {
            boolean hasTimetable = false;
            if (context.hasPermission(Right.ClassAssignments) && classAssignment != null) {
                if (classAssignment instanceof CachedClassAssignmentProxy) {
                    ((CachedClassAssignmentProxy)classAssignment).setCache(classes);
                }
                for (Object[] o : classes) {
                    Class_ clazz = (Class_)o[0];
                    if (classAssignment.getAssignment(clazz) == null) continue;
                    hasTimetable = true;
                    break;
                }
            }
            this.setDisplayTimetable(hasTimetable);
        }
        this.setUserSettings(context.getUser());
        if (this.isShowExam()) {
            this.setShowExamTimetable(examAssignment != null || Exam.hasTimetable(context.getUser().getCurrentAcademicSessionId()));
        }
        this.iFile = new CSVFile();
        this.csvBuildTableHeader(context.getUser().getCurrentAcademicSessionId());
        int ct = 0;
        Iterator it = classes.iterator();
        String prevLabel = null;
        while (it.hasNext()) {
            Object[] o = (Object[])it.next();
            Class_ c = (Class_)o[0];
            CourseOffering co = (CourseOffering)o[1];
            this.csvBuildClassRow(classAssignment, examAssignment, ++ct, co, c, "", context, prevLabel);
            prevLabel = c.getClassLabel(co);
        }
        this.save(out);
    }

    protected CSVFile.CSVField csvBuildPrefGroupLabel(CourseOffering co, PreferenceGroup prefGroup, String indentSpaces, boolean isEditable, String prevLabel) {
        if (prefGroup instanceof Class_) {
            String label = prefGroup.toString();
            Class_ aClass = (Class_)prefGroup;
            label = aClass.getClassLabel(co);
            if (prevLabel != null && label.equals(prevLabel)) {
                label = "";
            }
            CSVFile.CSVField cell = this.createCell();
            this.addText(cell, indentSpaces + label, true);
            InstructionalMethod im = aClass.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod();
            if (aClass.isCancelled().booleanValue()) {
                if (im != null) {
                    this.addText(cell, " (" + MSG.statusCancelled() + ", " + im.getReference() + ")", false);
                } else {
                    this.addText(cell, " (" + MSG.statusCancelled() + ")", false);
                }
            } else if (im != null) {
                this.addText(cell, " (" + im.getReference() + ")", false);
            }
            return cell;
        }
        return super.csvBuildPrefGroupLabel(co, prefGroup, indentSpaces, isEditable, null);
    }

    protected TreeSet getExams(Class_ clazz) {
        TreeSet ret = new TreeSet(Exam.findAll(3, clazz.getUniqueId()));
        SchedulingSubpart subpart = clazz.getSchedulingSubpart();
        if (subpart.getParentSubpart() != null) {
            return ret;
        }
        InstrOfferingConfig config = subpart.getInstrOfferingConfig();
        SchedulingSubpartComparator cmp = new SchedulingSubpartComparator();
        for (SchedulingSubpart s : config.getSchedulingSubparts()) {
            if (cmp.compare(s, subpart) >= 0) continue;
            return ret;
        }
        InstructionalOffering offering = config.getInstructionalOffering();
        ret.addAll(Exam.findAll(2, config.getUniqueId()));
        ret.addAll(Exam.findAll(0, offering.getUniqueId()));
        for (CourseOffering co : offering.getCourseOfferings()) {
            ret.addAll(Exam.findAll(1, co.getUniqueId()));
        }
        return ret;
    }
}

