/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util.duration;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.util.duration.MeetingCountingDuration;

public class MeetingHours
extends MeetingCountingDuration {
    protected int iMinutesPerHour = 50;
    protected double iLowerBound = 0.95;
    protected double iUpperBound = 1.1;

    public MeetingHours(String parameter) {
        Matcher matcher;
        if (parameter != null && !parameter.isEmpty() && (matcher = Pattern.compile(this.getParamterFormat()).matcher(parameter)).find()) {
            this.iMinutesPerHour = Integer.parseInt(matcher.group(1));
            this.iLowerBound = Double.parseDouble(matcher.group(2));
            this.iUpperBound = Double.parseDouble(matcher.group(3));
        }
    }

    public boolean check(int hours, int semesterMinutes) {
        return this.iLowerBound * (double)hours * (double)this.iMinutesPerHour <= (double)semesterMinutes && (double)semesterMinutes <= this.iUpperBound * (double)hours * (double)this.iMinutesPerHour;
    }

    public Integer getMaxMeetings(int hours, int minutesPerMeeting) {
        return (int)Math.ceil((double)hours * (double)this.iMinutesPerHour / (double)minutesPerMeeting);
    }

    public String getParamterFormat() {
        return "([0-9]+),([0-9]*\\.?[0-9]+),([0-9]*\\.?[0-9]+)";
    }

    public int getExactTimeMinutesPerMeeting(int hours, DatePattern datePattern, int dayCode) {
        Iterator<DatePattern> iterator;
        if (datePattern == null) {
            return 0;
        }
        if (datePattern.getType() != null && datePattern.getType() == 4 && (iterator = datePattern.findChildren().iterator()).hasNext()) {
            DatePattern child = iterator.next();
            return this.iMinutesPerHour * hours / this.nbrMeetings(child, dayCode);
        }
        return this.iMinutesPerHour * hours / this.nbrMeetings(datePattern, dayCode);
    }

    public Integer getArrangedHours(int hours, DatePattern datePattern) {
        Iterator<DatePattern> iterator;
        if (hours <= 0 || datePattern == null) {
            return null;
        }
        if (datePattern.getType() != null && datePattern.getType() == 4 && (iterator = datePattern.findChildren().iterator()).hasNext()) {
            DatePattern child = iterator.next();
            return new Integer(Math.round((float)hours / child.getEffectiveNumberOfWeeks()));
        }
        return new Integer(Math.round((float)hours / datePattern.getEffectiveNumberOfWeeks()));
    }
}

