/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.hibernate.Transaction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.ArrangeCreditUnitConfig;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseCatalog;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseSubpartCredit;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.OfferingConsentType;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.VariableFixedCreditUnitConfig;
import org.unitime.timetable.model.VariableRangeCreditUnitConfig;
import org.unitime.timetable.model.base.BaseCourseOffering;
import org.unitime.timetable.model.base.BaseCourseSubpartCredit;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.ItypeDescDAO;
import org.unitime.timetable.util.SessionRollForward;

public class InstructionalOfferingRollForward
extends SessionRollForward {
    public InstructionalOfferingRollForward(Log log) {
        super(log);
    }

    public void rollForwardInstructionalOfferingsForASubjectArea(String subjectAreaAbbreviation, Session fromSession, Session toSession) {
        CourseOfferingDAO coDao = new CourseOfferingDAO();
        String query = "from CourseOffering as co where co.subjectArea.subjectAreaAbbreviation = '" + subjectAreaAbbreviation + "' and co.isControl = 1" + " and co.subjectArea.session.uniqueId = " + fromSession.getUniqueId();
        List l = coDao.getQuery(query).list();
        if (l != null) {
            CourseOffering co2 = null;
            for (CourseOffering co2 : l) {
                this.rollForwardInstructionalOffering(co2.getInstructionalOffering(), fromSession, toSession);
            }
        }
    }

    public void rollForwardExpiredInstructionalOfferingsForASubjectArea(String subjectAreaAbbreviation, Session fromSession, Session toSession) {
        CourseOfferingDAO coDao = new CourseOfferingDAO();
        String query = "select co from CourseOffering co where co.subjectArea.subjectAreaAbbreviation = '" + subjectAreaAbbreviation + "'" + "  and co.subjectArea.session.uniqueId = " + fromSession.getUniqueId() + "  and co.isControl = 1" + "  and co.instructionalOffering.notOffered = false" + "  and 0 = (select count(cc) from CourseCatalog cc" + " where cc.session.uniqueId = " + toSession.getUniqueId() + "  and cc.subject = co.subjectArea.subjectAreaAbbreviation" + "  and (cc.courseNumber = co.courseNbr or cc.previousCourseNumber= co.courseNbr))" + " and 0 = (select count(co2) from CourseOffering co2" + "  where co2.subjectArea.session.uniqueId = " + toSession.getUniqueId() + "   and co2.subjectArea.subjectAreaAbbreviation = co.subjectArea.subjectAreaAbbreviation" + "   and co2.courseNbr = co.courseNbr)";
        List l = coDao.getQuery(query).list();
        if (l != null) {
            CourseOffering co2 = null;
            for (CourseOffering co2 : l) {
                if (co2.getSubjectArea().getSubjectAreaAbbreviation().equals("ECE") && co2.getCourseNbr().equals("495E") || co2.getSubjectArea().getSubjectAreaAbbreviation().equals("AMST") && co2.getCourseNbr().equals("650A") || co2.getSubjectArea().getSubjectAreaAbbreviation().equals("FLL") && co2.getCourseNbr().equals("650T")) continue;
                this.rollForwardInstructionalOffering(co2.getInstructionalOffering(), fromSession, toSession);
            }
        }
        coDao.getSession().clear();
    }

    public void rollForwardInstructionalOfferingForACourseOffering(CourseOffering co, Session fromSession, Session toSession) {
        CourseOfferingDAO coDao = new CourseOfferingDAO();
        if (co != null) {
            this.rollForwardInstructionalOffering(co.getInstructionalOffering(), fromSession, toSession);
        }
        coDao.getSession().clear();
    }

    public void addNewInstructionalOfferingsForASubjectArea(String subjectAreaAbbreviation, Session toSession) {
        CourseOfferingDAO coDao = new CourseOfferingDAO();
        if (this.sessionHasCourseCatalog(toSession)) {
            String query = "select cc2 from CourseCatalog cc2";
            query = query + " where cc2.session.uniqueId=:sessionId";
            query = query + "  and cc2.subject = :subjectAbbv";
            query = query + "  and cc2.uniqueId not in ";
            query = query + " (select distinct cc.uniqueId from CourseCatalog cc, CourseOffering co";
            query = query + "  where co.subjectArea.session.uniqueId=:sessionId";
            query = query + "  and co.subjectArea.subjectAreaAbbreviation=:subjectAbbv";
            query = query + "  and cc.session.uniqueId=:sessionId";
            query = query + "  and cc.subject=:subjectAbbv";
            List l = coDao.getQuery(query = query + "  and cc.courseNumber = co.courseNbr)").setString("subjectAbbv", subjectAreaAbbreviation).setLong("sessionId", toSession.getUniqueId().longValue()).list();
            if (l != null) {
                CourseCatalog cc2 = null;
                for (CourseCatalog cc2 : l) {
                    this.addInstructionalOffering(cc2, toSession);
                }
            }
        }
        coDao.getSession().clear();
    }

    private void addInstructionalOffering(CourseCatalog courseCatalogEntry, Session toSession) {
        this.iLog.info((Object)("Creating " + courseCatalogEntry.getSubject() + " " + courseCatalogEntry.getCourseNumber()));
        InstructionalOffering instructionalOffering = this.createToInstructionalOfferingFromCourseCatalog(courseCatalogEntry, toSession);
        if (instructionalOffering != null) {
            CourseOffering courseOffering = this.createToCourseOfferingFromCourseCatalog(courseCatalogEntry, toSession);
            courseOffering.setInstructionalOffering(instructionalOffering);
            instructionalOffering.setNotOffered(new Boolean(true));
            instructionalOffering.addTocourseOfferings(courseOffering);
            InstrOfferingConfig instrOffrConfig = this.createToInstrOfferingConfigFromCourseCatalog(courseCatalogEntry, toSession);
            if (instrOffrConfig != null) {
                instructionalOffering.addToinstrOfferingConfigs(instrOffrConfig);
                instrOffrConfig.setInstructionalOffering(instructionalOffering);
            }
            if (instructionalOffering.getInstrOfferingPermId() == null) {
                instructionalOffering.generateInstrOfferingPermId();
            }
            InstructionalOfferingDAO ioDao = new InstructionalOfferingDAO();
            ioDao.saveOrUpdate(instructionalOffering);
            ioDao.getSession().flush();
            ioDao.getSession().evict((Object)instructionalOffering);
        }
    }

    public void rollForwardInstructionalOfferingsForACourseOffering(String subjectAreaAbbreviation, String courseNumber, Session fromSession, Session toSession) {
        CourseOfferingDAO coDao = new CourseOfferingDAO();
        String query = "from CourseOffering as co where co.subjectArea.subjectAreaAbbreviation = '" + subjectAreaAbbreviation + "' and co.getCourseNbr = '" + courseNumber + "' and co.isControl = 1" + " and co.subjectArea.session.uniqueId = " + fromSession.getUniqueId();
        List l = coDao.getQuery(query).list();
        if (l != null && l.size() > 0) {
            CourseOffering co2 = null;
            for (CourseOffering co2 : l) {
                this.rollForwardInstructionalOffering(co2.getInstructionalOffering(), fromSession, toSession);
            }
        }
    }

    public void rollForwardInstructionalOffering(InstructionalOffering fromInstructionalOffering, Session fromSession, Session toSession) {
        block8: {
            InstructionalOfferingDAO ioDao = new InstructionalOfferingDAO();
            org.hibernate.Session hibSession = ioDao.getSession();
            this.iLog.info((Object)("Rolling " + fromInstructionalOffering.getCourseNameWithTitle()));
            Transaction trns = null;
            try {
                InstructionalOffering toInstructionalOffering;
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    trns = hibSession.beginTransaction();
                }
                if ((toInstructionalOffering = this.findToInstructionalOffering(fromInstructionalOffering, toSession, hibSession)) == null) {
                    return;
                }
                if (toInstructionalOffering.getInstrOfferingConfigs() != null && toInstructionalOffering.getInstrOfferingConfigs().size() > 0) {
                    toInstructionalOffering.getInstrOfferingConfigs().clear();
                }
                toInstructionalOffering.setNotOffered(fromInstructionalOffering.isNotOffered());
                toInstructionalOffering.setUniqueIdRolledForwardFrom(fromInstructionalOffering.getUniqueId());
                InstrOfferingConfig fromInstrOffrConfig2 = null;
                InstrOfferingConfig toInstrOffrConfig = null;
                if (fromInstructionalOffering.getInstrOfferingConfigs() != null && fromInstructionalOffering.getInstrOfferingConfigs().size() > 0) {
                    for (InstrOfferingConfig fromInstrOffrConfig2 : fromInstructionalOffering.getInstrOfferingConfigs()) {
                        toInstrOffrConfig = new InstrOfferingConfig();
                        toInstrOffrConfig.setLimit(fromInstrOffrConfig2.getLimit());
                        toInstrOffrConfig.setInstructionalOffering(toInstructionalOffering);
                        toInstrOffrConfig.setName(fromInstrOffrConfig2.getName());
                        toInstrOffrConfig.setUnlimitedEnrollment(fromInstrOffrConfig2.isUnlimitedEnrollment());
                        toInstrOffrConfig.setUniqueIdRolledForwardFrom(fromInstrOffrConfig2.getUniqueId());
                        toInstrOffrConfig.setClassDurationType(fromInstrOffrConfig2.getClassDurationType());
                        toInstrOffrConfig.setInstructionalMethod(fromInstrOffrConfig2.getInstructionalMethod());
                        toInstructionalOffering.addToinstrOfferingConfigs(toInstrOffrConfig);
                        hibSession.saveOrUpdate((Object)toInstrOffrConfig);
                        hibSession.update((Object)toInstructionalOffering);
                        this.rollForwardSchedSubpartsForAConfig(fromInstrOffrConfig2, toInstrOffrConfig, hibSession, toSession);
                        hibSession.update((Object)toInstructionalOffering);
                    }
                }
                if (trns != null && trns.isActive()) {
                    trns.commit();
                }
                hibSession.flush();
                hibSession.evict((Object)toInstructionalOffering);
                hibSession.evict((Object)fromInstructionalOffering);
            }
            catch (Exception e) {
                this.iLog.error((Object)("Failed to roll " + fromInstructionalOffering.getCourseName()), (Throwable)e);
                if (trns == null || !trns.isActive()) break block8;
                trns.rollback();
            }
        }
    }

    private void rollForwardCourseCreditUnitConfigForSchedSubpart(SchedulingSubpart fromSubpart, SchedulingSubpart toSubpart) {
        if (this.sessionHasCourseCatalog(toSubpart.getSession())) {
            CourseCatalog courseCatalogEntry;
            if (fromSubpart.getParentSubpart() != null && !fromSubpart.getParentSubpart().getItype().getItype().equals(fromSubpart.getItype().getItype()) && (courseCatalogEntry = CourseCatalog.findCourseInCatalogForSession(toSubpart.getControllingCourseOffering(), toSubpart.getSession())) != null && courseCatalogEntry.getSubparts() != null) {
                BaseCourseSubpartCredit csc = null;
                boolean found = false;
                Iterator<CourseSubpartCredit> cscIt = courseCatalogEntry.getSubparts().iterator();
                while (cscIt.hasNext() && !found) {
                    csc = cscIt.next();
                    if (!csc.getSubpartId().equals(toSubpart.getItype().getItype().toString())) continue;
                    found = true;
                }
                if (found) {
                    CourseCreditUnitConfig ccuc = CourseCreditUnitConfig.createCreditUnitConfigOfFormat(csc.getCreditFormat(), csc.getCreditType(), csc.getCreditUnitType(), csc.getFixedMinimumCredit(), csc.getMaximumCredit(), csc.isFractionalCreditAllowed(), new Boolean(true));
                    ccuc.setOwner(toSubpart);
                    toSubpart.setCredit(ccuc);
                }
            }
        } else if (fromSubpart.getCredit() != null) {
            Float units = null;
            Float maxUnits = null;
            Boolean fractionalIncrementsAllowed = null;
            if (fromSubpart.getCredit() instanceof FixedCreditUnitConfig) {
                FixedCreditUnitConfig fcuc = (FixedCreditUnitConfig)fromSubpart.getCredit();
                units = fcuc.getFixedUnits();
            } else if (fromSubpart.getCredit() instanceof VariableFixedCreditUnitConfig) {
                VariableFixedCreditUnitConfig vfcuc = (VariableFixedCreditUnitConfig)fromSubpart.getCredit();
                units = vfcuc.getMinUnits();
                maxUnits = vfcuc.getMaxUnits();
            } else if (fromSubpart.getCredit() instanceof VariableRangeCreditUnitConfig) {
                VariableRangeCreditUnitConfig vrcuc = (VariableRangeCreditUnitConfig)fromSubpart.getCredit();
                units = vrcuc.getMinUnits();
                maxUnits = vrcuc.getMaxUnits();
                fractionalIncrementsAllowed = vrcuc.isFractionalIncrementsAllowed();
            }
            CourseCreditUnitConfig ccuc = CourseCreditUnitConfig.createCreditUnitConfigOfFormat(fromSubpart.getCredit().getCreditFormat(), fromSubpart.getCredit().getCreditType(), fromSubpart.getCredit().getCreditUnitType(), units, maxUnits, fractionalIncrementsAllowed, new Boolean(false));
            ccuc.setOwner(toSubpart);
            toSubpart.setCredit(ccuc);
        }
    }

    private Class_ rollForwardClass(Class_ fromClass, SchedulingSubpart toSubpart, Session toSession, org.hibernate.Session hibSession) throws Exception {
        Class_ toClass = new Class_();
        toClass.setEnabledForStudentScheduling(fromClass.isEnabledForStudentScheduling());
        toClass.setDisplayInstructor(fromClass.isDisplayInstructor());
        toClass.setExpectedCapacity(fromClass.getExpectedCapacity());
        toClass.setMaxExpectedCapacity(fromClass.getMaxExpectedCapacity());
        toClass.setNbrRooms(fromClass.getNbrRooms());
        toClass.setNotes(fromClass.getNotes());
        toClass.setRoomRatio(fromClass.getRoomRatio());
        toClass.setSchedulePrintNote(fromClass.getSchedulePrintNote());
        toClass.setSchedulingSubpart(toSubpart);
        toClass.setUniqueIdRolledForwardFrom(fromClass.getUniqueId());
        if (SessionRollForward.CancelledClassAction.KEEP == this.getCancelledClassAction()) {
            toClass.setCancelled(fromClass.isCancelled());
        } else {
            toClass.setCancelled(false);
        }
        toSubpart.addToclasses(toClass);
        if (fromClass.getManagingDept() != null && !fromClass.getManagingDept().equals(fromClass.getControllingDept())) {
            toClass.setManagingDept(Department.findByDeptCode(fromClass.getManagingDept().getDeptCode(), toSession.getUniqueId()));
        }
        if (fromClass.getDatePattern() != null) {
            DatePattern toDp = DatePattern.findByName(toSession, fromClass.getDatePattern().getName());
            if (toDp == null) {
                toDp = fromClass.getDatePattern().findCloseMatchDatePatternInSession(toSession);
            }
            toClass.setDatePattern(toDp);
        }
        if (this.isClassRollForward()) {
            this.rollForwardTimePrefs(fromClass, toClass, toSession);
            this.rollForwardBuildingPrefs(fromClass, toClass, toSession);
            this.rollForwardRoomPrefs(fromClass, toClass, toSession);
            this.rollForwardRoomGroupPrefs(fromClass, toClass, toSession);
            this.rollForwardRoomFeaturePrefs(fromClass, toClass, toSession);
            this.rollForwardDistributionPrefs(fromClass, toClass, toSession, hibSession);
        }
        return toClass;
    }

    private void rollForwardSchedulingSubpart(InstrOfferingConfig toInstrOffrConfig, SchedulingSubpart fromSubpart, RollForwardSchedSubpart parentSubpart, org.hibernate.Session hibSession, Session toSession) throws Exception {
        SchedulingSubpart toSubpart = new SchedulingSubpart();
        toSubpart.setAutoSpreadInTime(fromSubpart.isAutoSpreadInTime());
        toSubpart.setStudentAllowOverlap(fromSubpart.isStudentAllowOverlap());
        toSubpart.setInstrOfferingConfig(toInstrOffrConfig);
        toInstrOffrConfig.addToschedulingSubparts(toSubpart);
        toSubpart.setMinutesPerWk(fromSubpart.getMinutesPerWk());
        toSubpart.setItype(fromSubpart.getItype());
        toSubpart.setUniqueIdRolledForwardFrom(fromSubpart.getUniqueId());
        this.rollForwardCourseCreditUnitConfigForSchedSubpart(fromSubpart, toSubpart);
        if (fromSubpart.getDatePattern() != null) {
            DatePattern toDp = null;
            toDp = DatePattern.findByName(toSession, fromSubpart.getDatePattern().getName());
            if (toDp == null) {
                toDp = fromSubpart.getDatePattern().findCloseMatchDatePatternInSession(toSession);
            }
            toSubpart.setDatePattern(toDp);
        }
        RollForwardSchedSubpart rfSs = new RollForwardSchedSubpart();
        rfSs.setFromSubpart(fromSubpart);
        rfSs.setToSubpart(toSubpart);
        if (parentSubpart != null) {
            rfSs.setFromParentSubpart(parentSubpart.getFromSubpart());
            parentSubpart.addToFromChildSubparts(fromSubpart);
            rfSs.setToParentSubpart(parentSubpart.getToSubpart());
            parentSubpart.addToToChildSubparts(toSubpart);
            toSubpart.setParentSubpart(parentSubpart.getToSubpart());
            parentSubpart.getToSubpart().addTochildSubparts(toSubpart);
        }
        hibSession.update((Object)toInstrOffrConfig);
        if (fromSubpart.getClasses() != null && fromSubpart.getClasses().size() > 0) {
            Class_ fromClass2 = null;
            Class_ toClass = null;
            for (Class_ fromClass2 : fromSubpart.getClasses()) {
                if (SessionRollForward.CancelledClassAction.SKIP == this.getCancelledClassAction() && fromClass2.isCancelled().booleanValue()) continue;
                toClass = this.rollForwardClass(fromClass2, toSubpart, toSession, hibSession);
                RollForwardClass rfc = new RollForwardClass();
                rfc.setToClass(toClass);
                rfc.setFromClass(fromClass2);
                rfc.setFromParentClass(fromClass2.getParentClass());
                rfc.setParentSubpart(rfSs);
                rfSs.addToRollForwardClasses(rfc);
                if (fromClass2.getChildClasses() != null && fromClass2.getChildClasses().size() > 0) {
                    Iterator<Class_> ccIt = fromClass2.getChildClasses().iterator();
                    while (ccIt.hasNext()) {
                        rfc.addToLastLikeChildClasses(ccIt.next());
                    }
                }
                if (parentSubpart == null) continue;
                Class_ parentClass = parentSubpart.findParentClassMatchingFromParentClass(fromClass2.getParentClass());
                toClass.setParentClass(parentClass);
                parentClass.addTochildClasses(toClass);
            }
        }
        hibSession.update((Object)toInstrOffrConfig);
        this.rollForwardTimePrefs(fromSubpart, toSubpart, toSession);
        this.rollForwardBuildingPrefs(fromSubpart, toSubpart, toSession);
        this.rollForwardRoomPrefs(fromSubpart, toSubpart, toSession);
        this.rollForwardRoomGroupPrefs(fromSubpart, toSubpart, toSession);
        this.rollForwardRoomFeaturePrefs(fromSubpart, toSubpart, toSession);
        this.rollForwardDistributionPrefs(fromSubpart, toSubpart, toSession, hibSession);
        if (fromSubpart.getChildSubparts() != null && fromSubpart.getChildSubparts().size() > 0) {
            SchedulingSubpart childSubpart2 = null;
            for (SchedulingSubpart childSubpart2 : fromSubpart.getChildSubparts()) {
                this.rollForwardSchedulingSubpart(toInstrOffrConfig, childSubpart2, rfSs, hibSession, toSession);
            }
        }
        hibSession.update((Object)toInstrOffrConfig);
    }

    private void rollForwardSchedSubpartsForAConfig(InstrOfferingConfig ioc, InstrOfferingConfig newIoc, org.hibernate.Session hibSession, Session toSession) throws Exception {
        if (ioc.getSchedulingSubparts() != null && ioc.getSchedulingSubparts().size() > 0) {
            SchedulingSubpart ss2 = null;
            for (SchedulingSubpart ss2 : ioc.getSchedulingSubparts()) {
                if (ss2.getParentSubpart() != null) continue;
                this.rollForwardSchedulingSubpart(newIoc, ss2, null, hibSession, toSession);
            }
        }
    }

    private InstructionalOffering createToInstructionalOfferingFromFromInstructionalOffering(InstructionalOffering fromInstructionalOffering, Session toSession, org.hibernate.Session hibSession) {
        if (fromInstructionalOffering == null) {
            return null;
        }
        InstructionalOffering toInstructionalOffering = new InstructionalOffering();
        toInstructionalOffering.setNotOffered(fromInstructionalOffering.isNotOffered());
        toInstructionalOffering.setSession(toSession);
        toInstructionalOffering.setUniqueIdRolledForwardFrom(fromInstructionalOffering.getUniqueId());
        toInstructionalOffering.setInstrOfferingPermId(fromInstructionalOffering.getInstrOfferingPermId());
        toInstructionalOffering.setByReservationOnly(fromInstructionalOffering.isByReservationOnly());
        toInstructionalOffering.setLastWeekToEnroll(fromInstructionalOffering.getLastWeekToEnroll());
        toInstructionalOffering.setLastWeekToChange(fromInstructionalOffering.getLastWeekToChange());
        toInstructionalOffering.setLastWeekToDrop(toInstructionalOffering.getLastWeekToDrop());
        CourseOffering fromCourseOffering2 = null;
        CourseOffering toCourseOffering = null;
        for (CourseOffering fromCourseOffering2 : fromInstructionalOffering.getCourseOfferings()) {
            toCourseOffering = new CourseOffering();
            toCourseOffering.setSubjectArea(fromCourseOffering2.getSubjectArea().findSameSubjectAreaInSession(toSession));
            toCourseOffering.setCourseNbr(fromCourseOffering2.getCourseNbr());
            if (fromInstructionalOffering.getCourseOfferings().size() == 1) {
                toCourseOffering.setIsControl(new Boolean(true));
            } else {
                toCourseOffering.setIsControl(fromCourseOffering2.isIsControl());
            }
            toCourseOffering.setExternalUniqueId(fromCourseOffering2.getExternalUniqueId());
            toCourseOffering.setNbrExpectedStudents(fromCourseOffering2.getNbrExpectedStudents());
            toCourseOffering.setDemand(fromCourseOffering2.getDemand());
            toCourseOffering.setPermId(fromCourseOffering2.getPermId());
            toCourseOffering.setScheduleBookNote(fromCourseOffering2.getScheduleBookNote());
            toCourseOffering.setTitle(fromCourseOffering2.getTitle());
            toCourseOffering.setUniqueIdRolledForwardFrom(fromCourseOffering2.getUniqueId());
            toCourseOffering.setInstructionalOffering(toInstructionalOffering);
            toCourseOffering.setReservation(fromCourseOffering2.getReservation());
            toCourseOffering.setConsentType(fromCourseOffering2.getConsentType());
            toCourseOffering.setCourseType(fromCourseOffering2.getCourseType());
            toInstructionalOffering.addTocourseOfferings(toCourseOffering);
            if (fromCourseOffering2.getCreditConfigs() == null || fromCourseOffering2.getCreditConfigs().isEmpty()) continue;
            CourseCreditUnitConfig ccuc2 = null;
            for (CourseCreditUnitConfig ccuc2 : fromCourseOffering2.getCreditConfigs()) {
                if (ccuc2 instanceof ArrangeCreditUnitConfig) {
                    ArrangeCreditUnitConfig fromAcuc = (ArrangeCreditUnitConfig)ccuc2;
                    ArrangeCreditUnitConfig toAcuc = (ArrangeCreditUnitConfig)fromAcuc.clone();
                    toAcuc.setOwner(toCourseOffering);
                    toCourseOffering.addTocreditConfigs(toAcuc);
                    continue;
                }
                if (ccuc2 instanceof FixedCreditUnitConfig) {
                    FixedCreditUnitConfig fromFcuc = (FixedCreditUnitConfig)ccuc2;
                    FixedCreditUnitConfig toFcuc = (FixedCreditUnitConfig)fromFcuc.clone();
                    toFcuc.setOwner(toCourseOffering);
                    toCourseOffering.addTocreditConfigs(toFcuc);
                    continue;
                }
                if (ccuc2 instanceof VariableRangeCreditUnitConfig) {
                    VariableRangeCreditUnitConfig fromVrcuc = (VariableRangeCreditUnitConfig)ccuc2;
                    VariableRangeCreditUnitConfig toVrcuc = (VariableRangeCreditUnitConfig)fromVrcuc.clone();
                    toVrcuc.setOwner(toCourseOffering);
                    toCourseOffering.addTocreditConfigs(toVrcuc);
                    continue;
                }
                if (!(ccuc2 instanceof VariableFixedCreditUnitConfig)) continue;
                VariableFixedCreditUnitConfig fromVfcuc = (VariableFixedCreditUnitConfig)ccuc2;
                VariableFixedCreditUnitConfig toVfcuc = (VariableFixedCreditUnitConfig)fromVfcuc.clone();
                toVfcuc.setOwner(toCourseOffering);
                toCourseOffering.addTocreditConfigs(toVfcuc);
            }
        }
        if (toInstructionalOffering.getInstrOfferingPermId() == null) {
            toInstructionalOffering.generateInstrOfferingPermId();
        }
        hibSession.saveOrUpdate((Object)toInstructionalOffering);
        return toInstructionalOffering;
    }

    private InstructionalOffering createToInstructionalOfferingFromCourseCatalog(CourseCatalog courseCatalogEntry, Session session) {
        if (courseCatalogEntry == null || session == null) {
            return null;
        }
        InstructionalOffering toInstructionalOffering = new InstructionalOffering();
        toInstructionalOffering.setNotOffered(new Boolean(false));
        toInstructionalOffering.setSession(session);
        toInstructionalOffering.setByReservationOnly(false);
        return toInstructionalOffering;
    }

    private InstrOfferingConfig createToInstrOfferingConfigFromCourseCatalog(CourseCatalog courseCatalogEntry, Session session) {
        if (courseCatalogEntry == null || session == null) {
            return null;
        }
        InstrOfferingConfig toInstrOfferingConfig = new InstrOfferingConfig();
        toInstrOfferingConfig.setName("1");
        toInstrOfferingConfig.setLimit(new Integer(0));
        toInstrOfferingConfig.setUnlimitedEnrollment(new Boolean(false));
        if (courseCatalogEntry.getSubparts() != null && !courseCatalogEntry.getSubparts().isEmpty()) {
            CourseSubpartCredit courseSubpartCredit2 = null;
            SchedulingSubpart schedSupart = null;
            ItypeDescDAO itDao = new ItypeDescDAO();
            for (CourseSubpartCredit courseSubpartCredit2 : courseCatalogEntry.getSubparts()) {
                schedSupart = new SchedulingSubpart();
                schedSupart.setInstrOfferingConfig(toInstrOfferingConfig);
                toInstrOfferingConfig.addToschedulingSubparts(schedSupart);
                schedSupart.setMinutesPerWk(new Integer(0));
                schedSupart.setAutoSpreadInTime(ApplicationProperty.SchedulingSubpartAutoSpreadInTimeDefault.isTrue());
                schedSupart.setStudentAllowOverlap(ApplicationProperty.SchedulingSubpartStudentOverlapsDefault.isTrue());
                schedSupart.setItype((ItypeDesc)itDao.get(new Integer(Integer.parseInt(courseSubpartCredit2.getSubpartId()))));
                CourseCreditUnitConfig ccuc = CourseCreditUnitConfig.createCreditUnitConfigOfFormat(courseSubpartCredit2.getCreditFormat(), courseSubpartCredit2.getCreditType(), courseSubpartCredit2.getCreditUnitType(), courseSubpartCredit2.getFixedMinimumCredit(), courseSubpartCredit2.getMaximumCredit(), courseSubpartCredit2.isFractionalCreditAllowed(), new Boolean(false));
                if (ccuc instanceof ArrangeCreditUnitConfig) {
                    ArrangeCreditUnitConfig toAcuc = (ArrangeCreditUnitConfig)ccuc;
                    toAcuc.setOwner(schedSupart);
                    schedSupart.addTocreditConfigs(toAcuc);
                    continue;
                }
                if (ccuc instanceof FixedCreditUnitConfig) {
                    FixedCreditUnitConfig toFcuc = (FixedCreditUnitConfig)ccuc;
                    toFcuc.setOwner(schedSupart);
                    schedSupart.addTocreditConfigs(toFcuc);
                    continue;
                }
                if (ccuc instanceof VariableRangeCreditUnitConfig) {
                    VariableRangeCreditUnitConfig toVrcuc = (VariableRangeCreditUnitConfig)ccuc;
                    toVrcuc.setOwner(schedSupart);
                    schedSupart.addTocreditConfigs(toVrcuc);
                    continue;
                }
                if (!(ccuc instanceof VariableFixedCreditUnitConfig)) continue;
                VariableFixedCreditUnitConfig toVfcuc = (VariableFixedCreditUnitConfig)ccuc;
                toVfcuc.setOwner(schedSupart);
                schedSupart.addTocreditConfigs(toVfcuc);
            }
        }
        return toInstrOfferingConfig;
    }

    private CourseOffering createToCourseOfferingFromCourseCatalog(CourseCatalog courseCatalogEntry, Session session) {
        if (courseCatalogEntry == null || session == null) {
            return null;
        }
        CourseOffering toCourseOffering = new CourseOffering();
        toCourseOffering.setSubjectArea(SubjectArea.findByAbbv(session.getUniqueId(), courseCatalogEntry.getSubject()));
        toCourseOffering.setCourseNbr(courseCatalogEntry.getCourseNumber());
        toCourseOffering.setIsControl(new Boolean(true));
        toCourseOffering.setExternalUniqueId(courseCatalogEntry.getExternalUniqueId());
        toCourseOffering.setPermId(courseCatalogEntry.getPermanentId());
        toCourseOffering.setTitle(courseCatalogEntry.getTitle());
        toCourseOffering.setNbrExpectedStudents(new Integer(0));
        toCourseOffering.setDemand(new Integer(0));
        toCourseOffering.setConsentType(OfferingConsentType.getOfferingConsentTypeForReference(courseCatalogEntry.getApprovalType()));
        if (courseCatalogEntry.getCreditFormat() != null) {
            CourseCreditUnitConfig ccuc = CourseCreditUnitConfig.createCreditUnitConfigOfFormat(courseCatalogEntry.getCreditFormat(), courseCatalogEntry.getCreditType(), courseCatalogEntry.getCreditUnitType(), courseCatalogEntry.getFixedMinimumCredit(), courseCatalogEntry.getMaximumCredit(), courseCatalogEntry.isFractionalCreditAllowed(), new Boolean(true));
            if (ccuc instanceof ArrangeCreditUnitConfig) {
                ArrangeCreditUnitConfig toAcuc = (ArrangeCreditUnitConfig)ccuc;
                toAcuc.setOwner(toCourseOffering);
                toCourseOffering.addTocreditConfigs(toAcuc);
            } else if (ccuc instanceof FixedCreditUnitConfig) {
                FixedCreditUnitConfig toFcuc = (FixedCreditUnitConfig)ccuc;
                toFcuc.setOwner(toCourseOffering);
                toCourseOffering.addTocreditConfigs(toFcuc);
            } else if (ccuc instanceof VariableRangeCreditUnitConfig) {
                VariableRangeCreditUnitConfig toVrcuc = (VariableRangeCreditUnitConfig)ccuc;
                toVrcuc.setOwner(toCourseOffering);
                toCourseOffering.addTocreditConfigs(toVrcuc);
            } else if (ccuc instanceof VariableFixedCreditUnitConfig) {
                VariableFixedCreditUnitConfig toVfcuc = (VariableFixedCreditUnitConfig)ccuc;
                toVfcuc.setOwner(toCourseOffering);
                toCourseOffering.addTocreditConfigs(toVfcuc);
            }
        }
        return toCourseOffering;
    }

    private InstructionalOffering createToInstructionalOfferingBasedOnCourseCatalog(InstructionalOffering fromInstructionalOffering, Session toSession, org.hibernate.Session hibSession) {
        if (fromInstructionalOffering == null) {
            return null;
        }
        CourseCatalog controllingCourseCatalogEntry = CourseCatalog.findCourseFromPreviousSessionInCatalogForSession(fromInstructionalOffering.getControllingCourseOffering(), toSession);
        if (controllingCourseCatalogEntry == null) {
            return null;
        }
        InstructionalOffering toInstructionalOffering = this.createToInstructionalOfferingFromCourseCatalog(controllingCourseCatalogEntry, toSession);
        toInstructionalOffering.setUniqueIdRolledForwardFrom(fromInstructionalOffering.getUniqueId());
        toInstructionalOffering.setInstrOfferingPermId(fromInstructionalOffering.getInstrOfferingPermId());
        CourseOffering fromCourseOffering2 = null;
        BaseCourseOffering toCourseOffering = null;
        CourseCatalog courseCatalogEntry = null;
        for (CourseOffering fromCourseOffering2 : fromInstructionalOffering.getCourseOfferings()) {
            courseCatalogEntry = CourseCatalog.findCourseFromPreviousSessionInCatalogForSession(fromCourseOffering2, toSession);
            if (courseCatalogEntry == null) continue;
            toCourseOffering = this.createToCourseOfferingFromCourseCatalog(courseCatalogEntry, toSession);
            toCourseOffering.setIsControl(fromCourseOffering2.isIsControl());
            toCourseOffering.setScheduleBookNote(fromCourseOffering2.getScheduleBookNote());
            toCourseOffering.setUniqueIdRolledForwardFrom(fromCourseOffering2.getUniqueId());
            toCourseOffering.setNbrExpectedStudents(fromCourseOffering2.getNbrExpectedStudents());
            toCourseOffering.setDemand(fromCourseOffering2.getDemand());
            toCourseOffering.setInstructionalOffering(toInstructionalOffering);
            toCourseOffering.setUniqueIdRolledForwardFrom(fromCourseOffering2.getUniqueId());
            toInstructionalOffering.addTocourseOfferings((CourseOffering)toCourseOffering);
            if (courseCatalogEntry.getCreditType() == null) continue;
            CourseCreditUnitConfig ccuc = CourseCreditUnitConfig.createCreditUnitConfigOfFormat(courseCatalogEntry.getCreditFormat(), courseCatalogEntry.getCreditType(), courseCatalogEntry.getCreditUnitType(), courseCatalogEntry.getFixedMinimumCredit(), courseCatalogEntry.getMaximumCredit(), courseCatalogEntry.isFractionalCreditAllowed(), new Boolean(true));
            if (ccuc instanceof ArrangeCreditUnitConfig) {
                ArrangeCreditUnitConfig toAcuc = (ArrangeCreditUnitConfig)ccuc;
                toAcuc.setOwner((CourseOffering)toCourseOffering);
                toCourseOffering.addTocreditConfigs(toAcuc);
                continue;
            }
            if (ccuc instanceof FixedCreditUnitConfig) {
                FixedCreditUnitConfig toFcuc = (FixedCreditUnitConfig)ccuc;
                toFcuc.setOwner((CourseOffering)toCourseOffering);
                toCourseOffering.addTocreditConfigs(toFcuc);
                continue;
            }
            if (ccuc instanceof VariableRangeCreditUnitConfig) {
                VariableRangeCreditUnitConfig toVrcuc = (VariableRangeCreditUnitConfig)ccuc;
                toVrcuc.setOwner((CourseOffering)toCourseOffering);
                toCourseOffering.addTocreditConfigs(toVrcuc);
                continue;
            }
            if (!(ccuc instanceof VariableFixedCreditUnitConfig)) continue;
            VariableFixedCreditUnitConfig toVfcuc = (VariableFixedCreditUnitConfig)ccuc;
            toVfcuc.setOwner((CourseOffering)toCourseOffering);
            toCourseOffering.addTocreditConfigs(toVfcuc);
        }
        if (toInstructionalOffering.getCourseOfferings().size() == 1) {
            toCourseOffering.setIsControl(new Boolean(true));
        }
        if (toInstructionalOffering.getInstrOfferingPermId() == null) {
            toInstructionalOffering.generateInstrOfferingPermId();
        }
        hibSession.saveOrUpdate((Object)toInstructionalOffering);
        return toInstructionalOffering;
    }

    private InstructionalOffering findToInstructionalOffering(InstructionalOffering fromInstructionalOffering, Session toSession, org.hibernate.Session hibSession) {
        InstructionalOffering toInstructionalOffering;
        if (fromInstructionalOffering == null) {
            return null;
        }
        CourseOffering co = CourseOffering.findByIdRolledForwardFrom(toSession.getUniqueId(), fromInstructionalOffering.getControllingCourseOffering().getUniqueId());
        if (co == null && ApplicationProperty.CourseOfferingNumberMustBeUnique.isTrue()) {
            co = CourseOffering.findBySessionSubjAreaAbbvCourseNbr(toSession.getUniqueId(), fromInstructionalOffering.getControllingCourseOffering().getSubjectArea().getSubjectAreaAbbreviation(), fromInstructionalOffering.getControllingCourseOffering().getCourseNbr());
        }
        if (co != null && (toInstructionalOffering = co.getInstructionalOffering()) != null) {
            toInstructionalOffering.deleteAllClasses(hibSession);
            toInstructionalOffering.deleteAllDistributionPreferences(hibSession);
            toInstructionalOffering.getInstrOfferingConfigs().clear();
            return toInstructionalOffering;
        }
        if (this.sessionHasCourseCatalog(toSession)) {
            return this.createToInstructionalOfferingBasedOnCourseCatalog(fromInstructionalOffering, toSession, hibSession);
        }
        return this.createToInstructionalOfferingFromFromInstructionalOffering(fromInstructionalOffering, toSession, hibSession);
    }

    private class RollForwardClass {
        private Class_ fromParentClass;
        private Class_ toParentClass;
        private Class_ fromClass;
        private Class_ toClass;
        private List fromChildClasses;
        private List toChildClasses;
        private RollForwardSchedSubpart parentSubpart;

        private RollForwardClass() {
        }

        public List getFromChildClasses() {
            return this.fromChildClasses;
        }

        public void setFromChildClasses(List lastLikeChildClasses) {
            this.fromChildClasses = lastLikeChildClasses;
        }

        public void addToLastLikeChildClasses(Object fromChildClass) {
            if (this.fromChildClasses == null) {
                this.fromChildClasses = new ArrayList();
            }
            this.fromChildClasses.add(fromChildClass);
        }

        public Class_ getFromClass() {
            return this.fromClass;
        }

        public void setFromClass(Class_ fromClass) {
            this.fromClass = fromClass;
        }

        public Class_ getFromParentClass() {
            return this.fromParentClass;
        }

        public void setFromParentClass(Class_ fromParentClass) {
            this.fromParentClass = fromParentClass;
        }

        public List getToChildClasses() {
            return this.toChildClasses;
        }

        public void setToChildClasses(List newChildClasses) {
            this.toChildClasses = newChildClasses;
        }

        public void addToNewChildClasses(Class_ toChildClass) {
            if (this.toChildClasses == null) {
                this.toChildClasses = new ArrayList();
            }
            this.toChildClasses.add(toChildClass);
        }

        public Class_ getToClass() {
            return this.toClass;
        }

        public void setToClass(Class_ toClass) {
            this.toClass = toClass;
        }

        public Class_ getToParentClass() {
            return this.toParentClass;
        }

        public void setToParentClass(Class_ toParentClass) {
            this.toParentClass = toParentClass;
        }

        public RollForwardSchedSubpart getParentSubpart() {
            return this.parentSubpart;
        }

        public void setParentSubpart(RollForwardSchedSubpart parentSubpart) {
            this.parentSubpart = parentSubpart;
        }
    }

    private class RollForwardSchedSubpart {
        private SchedulingSubpart fromParentSubpart;
        private SchedulingSubpart toParentSubpart;
        private SchedulingSubpart fromSubpart;
        private SchedulingSubpart toSubpart;
        private List fromChildSubparts;
        private List toChildSubparts;
        private List rollForwardClasses;

        private RollForwardSchedSubpart() {
        }

        public List getFromChildSubparts() {
            return this.fromChildSubparts;
        }

        public Class_ findParentClassMatchingFromParentClass(Class_ fromParentClass) {
            if (this.getRollForwardClasses() != null && this.getRollForwardClasses().size() > 0) {
                RollForwardClass rfc2 = null;
                for (RollForwardClass rfc2 : this.getRollForwardClasses()) {
                    if (!rfc2.getFromClass().equals(fromParentClass)) continue;
                    return rfc2.getToClass();
                }
            }
            return null;
        }

        public void setFromChildSubparts(List fromChildSubparts) {
            this.fromChildSubparts = fromChildSubparts;
        }

        public void addToFromChildSubparts(SchedulingSubpart fromChildSubpart) {
            if (this.fromChildSubparts == null) {
                this.fromChildSubparts = new ArrayList();
            }
            this.fromChildSubparts.add(fromChildSubpart);
        }

        public SchedulingSubpart getFromParentSubpart() {
            return this.fromParentSubpart;
        }

        public void setFromParentSubpart(SchedulingSubpart fromParentSubpart) {
            this.fromParentSubpart = fromParentSubpart;
        }

        public SchedulingSubpart getFromSubpart() {
            return this.fromSubpart;
        }

        public void setFromSubpart(SchedulingSubpart fromSubpart) {
            this.fromSubpart = fromSubpart;
        }

        public List getToChildSubparts() {
            return this.toChildSubparts;
        }

        public void setToChildSubparts(List toChildSubparts) {
            this.toChildSubparts = toChildSubparts;
        }

        public void addToToChildSubparts(SchedulingSubpart toChildSubpart) {
            if (this.toChildSubparts == null) {
                this.toChildSubparts = new ArrayList();
            }
            this.toChildSubparts.add(toChildSubpart);
        }

        public SchedulingSubpart getToParentSubpart() {
            return this.toParentSubpart;
        }

        public void setToParentSubpart(SchedulingSubpart toParentSubpart) {
            this.toParentSubpart = toParentSubpart;
        }

        public SchedulingSubpart getToSubpart() {
            return this.toSubpart;
        }

        public void setToSubpart(SchedulingSubpart toSubpart) {
            this.toSubpart = toSubpart;
        }

        public List getRollForwardClasses() {
            return this.rollForwardClasses;
        }

        public void setRollForwardClasses(List rollForwardClasses) {
            this.rollForwardClasses = rollForwardClasses;
        }

        public void addToRollForwardClasses(RollForwardClass rollForwardClass) {
            if (this.rollForwardClasses == null) {
                this.rollForwardClasses = new ArrayList();
            }
            this.rollForwardClasses.add(rollForwardClass);
        }
    }
}

