/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.ui;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.SpreadConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.solver.Solver;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;

public class SameSubpartBalancingReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashSet iGroups = new HashSet();
    private int iFirstDaySlot;
    private int iLastDaySlot;
    private int iFirstWorkDay;
    private int iLastWorkDay;

    public SameSubpartBalancingReport(Solver solver) {
        TimetableModel model = (TimetableModel)solver.currentSolution().getModel();
        this.iFirstDaySlot = model.getProperties().getPropertyInt("General.FirstDaySlot", Constants.DAY_SLOTS_FIRST);
        this.iLastDaySlot = model.getProperties().getPropertyInt("General.LastDaySlot", Constants.DAY_SLOTS_LAST);
        this.iFirstWorkDay = model.getProperties().getPropertyInt("General.FirstWorkDay", 0);
        this.iLastWorkDay = model.getProperties().getPropertyInt("General.LastWorkDay", Constants.NR_DAYS_WEEK - 1);
        Assignment assignment = solver.currentSolution().getAssignment();
        for (SpreadConstraint spread : model.getSpreadConstraints()) {
            if (spread.getPenalty(assignment) == 0) continue;
            this.iGroups.add(new SameSubpartBalancingGroup(solver, spread));
        }
    }

    public Set getGroups() {
        return this.iGroups;
    }

    public int getFirstDaySlot() {
        return this.iFirstDaySlot;
    }

    public int getLastDaySlot() {
        return this.iLastDaySlot;
    }

    public int getFirstWorkDay() {
        return this.iFirstWorkDay;
    }

    public int getLastWorkDay() {
        return this.iLastWorkDay;
    }

    public int getSlotsPerDayNoEvening() {
        return this.iLastDaySlot - this.iFirstDaySlot + 1;
    }

    public int getNrWorkDays() {
        return this.iLastWorkDay - this.iFirstWorkDay + 1;
    }

    public class SameSubpartBalancingGroup
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String iName = null;
        private int[][] iLimit;
        private int[][] iUsage;
        private HashSet[][] iCourses;

        public SameSubpartBalancingGroup(Solver solver, SpreadConstraint spread) {
            Assignment assignment = solver.currentSolution().getAssignment();
            SpreadConstraint.SpreadConstraintContext context = (SpreadConstraint.SpreadConstraintContext)spread.getContext(assignment);
            this.iName = spread.getName();
            this.iLimit = new int[SameSubpartBalancingReport.this.iLastDaySlot - SameSubpartBalancingReport.this.iFirstDaySlot + 1][SameSubpartBalancingReport.this.iLastWorkDay - SameSubpartBalancingReport.this.iFirstWorkDay + 1];
            this.iUsage = new int[SameSubpartBalancingReport.this.iLastDaySlot - SameSubpartBalancingReport.this.iFirstDaySlot + 1][SameSubpartBalancingReport.this.iLastWorkDay - SameSubpartBalancingReport.this.iFirstWorkDay + 1];
            this.iCourses = new HashSet[SameSubpartBalancingReport.this.iLastDaySlot - SameSubpartBalancingReport.this.iFirstDaySlot + 1][SameSubpartBalancingReport.this.iLastWorkDay - SameSubpartBalancingReport.this.iFirstWorkDay + 1];
            Hashtable<Long, ClassAssignmentDetails> detailCache = new Hashtable<Long, ClassAssignmentDetails>();
            for (int i = 0; i < SameSubpartBalancingReport.this.iLastDaySlot - SameSubpartBalancingReport.this.iFirstDaySlot + 1; ++i) {
                for (int j = 0; j < SameSubpartBalancingReport.this.iLastWorkDay - SameSubpartBalancingReport.this.iFirstWorkDay + 1; ++j) {
                    this.iLimit[i][j] = context.getMaxCourses(i + SameSubpartBalancingReport.this.iFirstDaySlot, j + SameSubpartBalancingReport.this.iFirstWorkDay);
                    this.iUsage[i][j] = context.getCourses(i + SameSubpartBalancingReport.this.iFirstDaySlot, j + SameSubpartBalancingReport.this.iFirstWorkDay).size();
                    this.iCourses[i][j] = new HashSet(context.getCourses(i + SameSubpartBalancingReport.this.iFirstDaySlot, j + SameSubpartBalancingReport.this.iFirstWorkDay).size());
                    for (Placement placement : context.getCourses(i + SameSubpartBalancingReport.this.iFirstDaySlot, j + SameSubpartBalancingReport.this.iFirstWorkDay)) {
                        Lecture lecture = (Lecture)placement.variable();
                        ClassAssignmentDetails ca = (ClassAssignmentDetails)detailCache.get(lecture.getClassId());
                        if (ca == null) {
                            ca = new ClassAssignmentDetails(solver, lecture, false);
                            detailCache.put(lecture.getClassId(), ca);
                        }
                        this.iCourses[i][j].add(ca);
                    }
                }
            }
        }

        public String getName() {
            return this.iName;
        }

        public int getLimit(int slot, int day) {
            if (slot < SameSubpartBalancingReport.this.iFirstDaySlot || slot > SameSubpartBalancingReport.this.iLastDaySlot) {
                return 0;
            }
            if (day >= SameSubpartBalancingReport.this.iLastWorkDay - SameSubpartBalancingReport.this.iFirstWorkDay + 1) {
                return 0;
            }
            return this.iLimit[slot - SameSubpartBalancingReport.this.iFirstDaySlot][day - SameSubpartBalancingReport.this.iFirstWorkDay];
        }

        public int getUsage(int slot, int day) {
            if (slot < SameSubpartBalancingReport.this.iFirstDaySlot || slot > SameSubpartBalancingReport.this.iLastDaySlot) {
                return 0;
            }
            if (day >= SameSubpartBalancingReport.this.iLastWorkDay - SameSubpartBalancingReport.this.iFirstWorkDay + 1) {
                return 0;
            }
            return this.iUsage[slot - SameSubpartBalancingReport.this.iFirstDaySlot][day - SameSubpartBalancingReport.this.iFirstWorkDay];
        }

        public Collection getClasses(int slot, int day) {
            if (slot < SameSubpartBalancingReport.this.iFirstDaySlot || slot > SameSubpartBalancingReport.this.iLastDaySlot) {
                return new HashSet(0);
            }
            if (day >= SameSubpartBalancingReport.this.iLastWorkDay - SameSubpartBalancingReport.this.iFirstWorkDay + 1) {
                return new HashSet(0);
            }
            return this.iCourses[slot - SameSubpartBalancingReport.this.iFirstDaySlot][day - SameSubpartBalancingReport.this.iFirstWorkDay];
        }

        public int getLimit(int slot) {
            if (slot < SameSubpartBalancingReport.this.iFirstDaySlot || slot > SameSubpartBalancingReport.this.iLastDaySlot) {
                return 0;
            }
            int ret = 0;
            for (int day = 0; day < SameSubpartBalancingReport.this.iLastWorkDay - SameSubpartBalancingReport.this.iFirstWorkDay + 1; ++day) {
                ret += this.iLimit[slot - SameSubpartBalancingReport.this.iFirstDaySlot][day - SameSubpartBalancingReport.this.iFirstWorkDay];
            }
            return ret;
        }

        public int getUsage(int slot) {
            if (slot < SameSubpartBalancingReport.this.iFirstDaySlot || slot > SameSubpartBalancingReport.this.iLastDaySlot) {
                return 0;
            }
            int ret = 0;
            for (int day = 0; day < SameSubpartBalancingReport.this.iLastWorkDay - SameSubpartBalancingReport.this.iFirstWorkDay + 1; ++day) {
                ret += this.iUsage[slot - SameSubpartBalancingReport.this.iFirstDaySlot][day - SameSubpartBalancingReport.this.iFirstWorkDay];
            }
            return ret;
        }

        public Collection getClasses(int slot) {
            if (slot < SameSubpartBalancingReport.this.iFirstDaySlot || slot > SameSubpartBalancingReport.this.iLastDaySlot) {
                return new HashSet(0);
            }
            HashSet ret = new HashSet();
            for (int day = 0; day < SameSubpartBalancingReport.this.iLastWorkDay - SameSubpartBalancingReport.this.iFirstWorkDay + 1; ++day) {
                ret.addAll(this.iCourses[slot - SameSubpartBalancingReport.this.iFirstDaySlot][day - SameSubpartBalancingReport.this.iFirstWorkDay]);
            }
            return ret;
        }

        public int getExcess(int slot) {
            if (slot < SameSubpartBalancingReport.this.iFirstDaySlot || slot > SameSubpartBalancingReport.this.iLastDaySlot) {
                return 0;
            }
            int ret = 0;
            for (int day = 0; day < SameSubpartBalancingReport.this.iLastWorkDay - SameSubpartBalancingReport.this.iFirstWorkDay + 1; ++day) {
                ret += Math.max(0, this.iUsage[slot - SameSubpartBalancingReport.this.iFirstDaySlot][day - SameSubpartBalancingReport.this.iFirstWorkDay] - this.iLimit[slot - SameSubpartBalancingReport.this.iFirstDaySlot][day - SameSubpartBalancingReport.this.iFirstWorkDay]);
            }
            return ret;
        }
    }
}

