/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.util.Progress;
import org.unitime.timetable.model.AcademicAreaClassification;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.dao.CourseOfferingDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface StudentCourseDemands {
    public void init(org.hibernate.Session var1, Progress var2, Session var3, Collection<InstructionalOffering> var4);

    public Set<WeightedStudentId> getDemands(CourseOffering var1);

    public Double getEnrollmentPriority(Long var1, Long var2);

    public boolean isMakingUpStudents();

    public boolean canUseStudentClassEnrollmentsAsSolution();

    public boolean isWeightStudentsToFillUpOffering();

    public Set<WeightedCourseOffering> getCourses(Long var1);

    public static interface ProjectionsProvider {
        public float getProjection(String var1, String var2, String var3);
    }

    public static class WeightedCourseOffering {
        private transient CourseOffering iCourseOffering = null;
        private long iCourseOfferingId;
        private float iWeight = 1.0f;

        public WeightedCourseOffering(CourseOffering courseOffering) {
            this.iCourseOffering = courseOffering;
            this.iCourseOfferingId = courseOffering.getUniqueId();
        }

        public WeightedCourseOffering(Long courseOfferingId) {
            this.iCourseOfferingId = courseOfferingId;
        }

        public WeightedCourseOffering(CourseOffering courseOffering, float weight) {
            this(courseOffering);
            this.iWeight = weight;
        }

        public WeightedCourseOffering(Long courseOfferingId, float weight) {
            this(courseOfferingId);
            this.iWeight = weight;
        }

        public Long getCourseOfferingId() {
            return this.iCourseOfferingId;
        }

        public CourseOffering getCourseOffering() {
            if (this.iCourseOffering == null) {
                this.iCourseOffering = (CourseOffering)CourseOfferingDAO.getInstance().get(this.iCourseOfferingId);
            }
            return this.iCourseOffering;
        }

        public float getWeight() {
            return this.iWeight;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WeightedStudentId {
        private long iStudentId;
        private float iWeight;
        private Set<AreaCode> iAreas = new TreeSet<AreaCode>();
        private Set<AreaCode> iMajors = new TreeSet<AreaCode>();
        private Set<String> iCurricula = new TreeSet<String>();

        public WeightedStudentId(Student student, ProjectionsProvider projections) {
            this.iStudentId = student.getUniqueId();
            this.iWeight = 1.0f;
            float rule = 1.0f;
            int cnt = 0;
            for (AcademicAreaClassification aac : student.getAcademicAreaClassifications()) {
                this.iAreas.add(new AreaCode(aac.getAcademicArea().getAcademicAreaAbbreviation(), aac.getAcademicClassification().getCode()));
                boolean hasMajor = false;
                for (PosMajor major : student.getPosMajors()) {
                    if (!major.getAcademicAreas().contains(aac.getAcademicArea())) continue;
                    if (projections != null) {
                        rule *= projections.getProjection(aac.getAcademicArea().getAcademicAreaAbbreviation(), aac.getAcademicClassification().getCode(), major.getCode());
                        ++cnt;
                        hasMajor = true;
                    }
                    this.iMajors.add(new AreaCode(aac.getAcademicArea().getAcademicAreaAbbreviation(), major.getCode()));
                }
                if (hasMajor || projections == null) continue;
                rule *= projections.getProjection(aac.getAcademicArea().getAcademicAreaAbbreviation(), aac.getAcademicClassification().getCode(), "");
                ++cnt;
            }
            if (cnt == 1) {
                this.iWeight = rule;
            } else if (cnt > 1) {
                this.iWeight = (float)Math.pow(rule, 1.0 / (double)cnt);
            }
        }

        public WeightedStudentId(Long studentId, CurriculumClassification cc, ProjectionsProvider projections) {
            this.iStudentId = studentId;
            Curriculum curriculum = cc.getCurriculum();
            this.iWeight = 1.0f;
            if (projections != null) {
                if (curriculum.getMajors().isEmpty()) {
                    this.iWeight = projections.getProjection(curriculum.getAcademicArea().getAcademicAreaAbbreviation(), cc.getAcademicClassification().getCode(), "");
                } else if (curriculum.getMajors().size() == 1) {
                    for (PosMajor m : curriculum.getMajors()) {
                        this.iWeight = projections.getProjection(curriculum.getAcademicArea().getAcademicAreaAbbreviation(), cc.getAcademicClassification().getCode(), m.getCode());
                    }
                } else {
                    double rule = 1.0;
                    for (PosMajor m : curriculum.getMajors()) {
                        rule *= (double)projections.getProjection(curriculum.getAcademicArea().getAcademicAreaAbbreviation(), cc.getAcademicClassification().getCode(), m.getCode());
                    }
                    this.iWeight = (float)Math.pow(rule, 1.0 / (double)curriculum.getMajors().size());
                }
            }
            this.iAreas.add(new AreaCode(curriculum.getAcademicArea().getAcademicAreaAbbreviation(), cc.getAcademicClassification().getCode()));
            for (PosMajor major : curriculum.getMajors()) {
                this.iMajors.add(new AreaCode(curriculum.getAcademicArea().getAcademicAreaAbbreviation(), major.getCode()));
            }
            this.iCurricula.add(curriculum.getAbbv());
        }

        public WeightedStudentId(Student student) {
            this(student, null);
        }

        public WeightedStudentId(Long studentId, CurriculumClassification cc) {
            this(studentId, cc, null);
        }

        public long getStudentId() {
            return this.iStudentId;
        }

        public float getWeight() {
            return this.iWeight;
        }

        public void setWeight(float weight) {
            this.iWeight = weight;
        }

        public void setCurriculum(String curriculum) {
            this.iCurricula.clear();
            this.iCurricula.add(curriculum);
        }

        public boolean hasArea(String areaAbbv) {
            for (AreaCode a : this.iAreas) {
                if (!a.getArea().equals(areaAbbv)) continue;
                return true;
            }
            return false;
        }

        public boolean hasClassification(String areaAbbv, String clasfCode) {
            for (AreaCode a : this.iAreas) {
                if (!a.getArea().equals(areaAbbv) || !a.getCode().equals(clasfCode)) continue;
                return true;
            }
            return false;
        }

        public boolean hasMajor(String areaAbbv, String majorCode) {
            for (AreaCode a : this.iMajors) {
                if (!a.getArea().equals(areaAbbv) || !a.getCode().equals(majorCode)) continue;
                return true;
            }
            return false;
        }

        public Set<AreaCode> getAreas() {
            return this.iAreas;
        }

        public Set<String> getMajors(String area) {
            TreeSet<String> ret = new TreeSet<String>();
            for (AreaCode m : this.iMajors) {
                if (!m.getArea().equals(area)) continue;
                ret.add(m.getCode());
            }
            return ret;
        }

        public String getArea() {
            return WeightedStudentId.toString(this.iAreas, true, ",");
        }

        public String getClasf() {
            return WeightedStudentId.toString(this.iAreas, false, ",");
        }

        public String getMajor() {
            return WeightedStudentId.toString(this.iMajors, false, ",");
        }

        public String getCurriculum() {
            StringBuffer ret = new StringBuffer();
            if (this.iCurricula.isEmpty()) {
                for (AreaCode a : this.iAreas) {
                    StringBuffer majors = new StringBuffer();
                    for (AreaCode m : this.iMajors) {
                        if (!a.getArea().equals(m.getArea())) continue;
                        if (majors.length() > 0) {
                            majors.append(",");
                        }
                        majors.append(m.getCode());
                    }
                    if (ret.length() > 0) {
                        ret.append(", ");
                    }
                    ret.append(a.getArea());
                    if (majors.length() <= 0) continue;
                    ret.append("/");
                    ret.append(majors);
                }
            } else {
                for (String curriculum : this.iCurricula) {
                    if (ret.length() > 0) {
                        ret.append(", ");
                    }
                    ret.append(curriculum);
                }
            }
            return ret.toString();
        }

        private static String toString(Set<AreaCode> set, boolean area, String delim) {
            if (set == null || set.isEmpty()) {
                return null;
            }
            StringBuffer ret = new StringBuffer();
            for (AreaCode s : set) {
                if (ret.length() > 0) {
                    ret.append(delim);
                }
                ret.append(area ? s.getArea() : s.getCode());
            }
            return ret.toString();
        }

        public boolean match(String areaAbbv, Set<String> majors) {
            for (AreaCode a : this.iAreas) {
                if (!a.getArea().equals(areaAbbv)) continue;
                for (AreaCode m : this.iMajors) {
                    if (!m.getArea().equals(areaAbbv) || !majors.contains(m.getCode())) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean match(CurriculumClassification clasf) {
            for (AreaCode a : this.iAreas) {
                if (!a.getArea().equals(clasf.getCurriculum().getAcademicArea().getAcademicAreaAbbreviation()) || !a.getCode().equals(clasf.getAcademicClassification().getCode())) continue;
                if (clasf.getCurriculum().isMultipleMajors().booleanValue()) {
                    for (PosMajor major : clasf.getCurriculum().getMajors()) {
                        boolean found = false;
                        for (AreaCode m : this.iMajors) {
                            if (!m.getArea().equals(a.getArea()) || !m.getCode().equals(major.getCode())) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        return true;
                    }
                    continue;
                }
                for (PosMajor major : clasf.getCurriculum().getMajors()) {
                    for (AreaCode m : this.iMajors) {
                        if (!m.getArea().equals(a.getArea()) || !m.getCode().equals(major.getCode())) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public int hashCode() {
            return new Long(this.getStudentId()).hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof WeightedStudentId)) {
                return false;
            }
            return this.getStudentId() == ((WeightedStudentId)o).getStudentId();
        }

        public String toString() {
            return String.valueOf(this.getStudentId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AreaCode
    implements Comparable<AreaCode> {
        String iArea;
        String iCode;

        public AreaCode(String area, String code) {
            this.iArea = area;
            this.iCode = code;
        }

        public String getArea() {
            return this.iArea;
        }

        public String getCode() {
            return this.iCode;
        }

        public String toString() {
            return this.getArea() + (this.getCode().isEmpty() ? "" : " " + this.getCode());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof AreaCode)) {
                return false;
            }
            return this.toString().equals(o.toString());
        }

        @Override
        public int compareTo(AreaCode ac) {
            return this.toString().compareTo(ac.toString());
        }
    }
}

