/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.hql;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SavedHQLInterface;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.Navigation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=SavedHQLInterface.HQLSetBackRpcRequest.class)
public class HQLSetBackBackend
implements GwtRpcImplementation<SavedHQLInterface.HQLSetBackRpcRequest, GwtRpcResponseNull> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    private SessionContext sessionContext;

    @Override
    @PreAuthorize(value="checkPermission('HQLReports')")
    public GwtRpcResponseNull execute(SavedHQLInterface.HQLSetBackRpcRequest request, SessionContext context) {
        String title = MESSAGES.pageCourseReports();
        switch (this.getAppearanceFlag(request.getAppearance())) {
            case APPEARANCE_COURSES: {
                title = MESSAGES.pageCourseReports();
                break;
            }
            case APPEARANCE_EXAMS: {
                title = MESSAGES.pageExaminationReports();
                break;
            }
            case APPEARANCE_SECTIONING: {
                title = MESSAGES.pageStudentSectioningReports();
                break;
            }
            case APPEARANCE_EVENTS: {
                title = MESSAGES.pageEventReports();
                break;
            }
            case APPEARANCE_ADMINISTRATION: {
                title = MESSAGES.pageAdministrationReports();
            }
        }
        BackTracker.markForBack(this.sessionContext, "gwt.jsp?page=hql&appearance=" + request.getAppearance() + "#" + request.getHistory(), title, true, true);
        if ("__Class".equals(request.getType())) {
            Navigation.set(this.sessionContext, Navigation.sClassLevel, request.getIds());
        } else if ("__Offering".equals(request.getType())) {
            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, request.getIds());
        } else if ("__Subpart".equals(request.getType())) {
            Navigation.set(this.sessionContext, Navigation.sSchedulingSubpartLevel, request.getIds());
        } else if ("__Room".equals(request.getType())) {
            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, request.getIds());
        } else if ("__Instructor".equals(request.getType())) {
            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, request.getIds());
        } else if ("__Exam".equals(request.getType())) {
            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, request.getIds());
        } else if ("__Event".equals(request.getType())) {
            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, request.getIds());
        }
        return null;
    }

    private SavedHQL.Flag getAppearanceFlag(String appearance) {
        for (SavedHQL.Flag flag : SavedHQL.Flag.values()) {
            if (flag.getAppearance() == null || !flag.getAppearance().equalsIgnoreCase(appearance)) continue;
            return flag;
        }
        return SavedHQL.Flag.APPEARANCE_COURSES;
    }
}

