/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.HashSet;
import java.util.List;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.CourseTypeDAO;
import org.unitime.timetable.model.dao.StudentSectioningStatusDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=sectioning]")
public class StudentSchedulingStatusTypes
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageStudentSchedulingStatusType(), MESSAGES.pageStudentSchedulingStatusTypes());
    }

    @PreAuthorize(value="checkPermission('StudentSchedulingStatusTypes')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        List courseTypes = CourseTypeDAO.getInstance().findAll(Order.asc((String)"reference"));
        SimpleEditInterface.Field[] fields = new SimpleEditInterface.Field[courseTypes.isEmpty() ? 3 + StatusOption.values().length : 4 + StatusOption.values().length + courseTypes.size()];
        int idx = 0;
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldAbbreviation(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.UNIQUE);
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 60, SimpleEditInterface.Flag.UNIQUE);
        for (StatusOption t : StatusOption.values()) {
            fields[idx++] = new SimpleEditInterface.Field(t.getLabel(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]);
        }
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldMessage(), SimpleEditInterface.FieldType.text, 400, 200, new SimpleEditInterface.Flag[0]);
        if (!courseTypes.isEmpty()) {
            for (int i = 0; i < courseTypes.size(); ++i) {
                fields[idx++] = new SimpleEditInterface.Field(((CourseType)courseTypes.get(i)).getReference(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]);
            }
            fields[idx++] = new SimpleEditInterface.Field(MESSAGES.toggleNoCourseType(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]);
        }
        SimpleEditInterface data = new SimpleEditInterface(fields);
        data.setSortBy(0, 1);
        for (StudentSectioningStatus status : StudentSectioningStatusDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.addRecord(status.getUniqueId());
            idx = 0;
            r.setField(idx++, status.getReference());
            r.setField(idx++, status.getLabel());
            for (StatusOption t : StatusOption.values()) {
                r.setField(idx++, status.hasOption(t.getOption()) ? "true" : "false");
            }
            r.setField(idx++, status.getMessage());
            if (courseTypes.isEmpty()) continue;
            for (int i = 0; i < courseTypes.size(); ++i) {
                r.setField(idx++, status.getTypes().contains(courseTypes.get(i)) ? "true" : "false");
            }
            r.setField(idx++, status.hasOption(StudentSectioningStatus.Option.notype) ? "false" : "true");
        }
        data.setEditable(context.hasPermission(Right.StudentSchedulingStatusTypeEdit));
        return data;
    }

    @PreAuthorize(value="checkPermission('StudentSchedulingStatusTypeEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (StudentSectioningStatus status : StudentSectioningStatusDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.getRecord(status.getUniqueId());
            if (r == null) {
                this.delete(status, context, hibSession);
                continue;
            }
            this.update(status, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @PreAuthorize(value="checkPermission('StudentSchedulingStatusTypeEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        StudentSectioningStatus status = new StudentSectioningStatus();
        int value = 0;
        for (int i = 0; i < StatusOption.values().length; ++i) {
            if (!"true".equals(record.getField(2 + i))) continue;
            value += StatusOption.values()[i].getOption().toggle();
        }
        status.setTypes(new HashSet<CourseType>());
        List courseTypes = CourseTypeDAO.getInstance().findAll(Order.asc((String)"reference"));
        if (!courseTypes.isEmpty()) {
            for (int i = 0; i < courseTypes.size(); ++i) {
                if (!"true".equals(record.getField(3 + StatusOption.values().length + i))) continue;
                status.getTypes().add((CourseType)courseTypes.get(i));
            }
            if (!"true".equals(record.getField(3 + StatusOption.values().length + courseTypes.size()))) {
                value += StudentSectioningStatus.Option.notype.toggle();
            }
        }
        status.setReference(record.getField(0));
        status.setLabel(record.getField(1));
        status.setStatus(value);
        status.setMessage(record.getField(2 + StatusOption.values().length));
        record.setUniqueId((Long)hibSession.save((Object)status));
        ChangeLog.addChange(hibSession, context, status, status.getReference() + " " + status.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(StudentSectioningStatus status, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (status == null) {
            return;
        }
        int value = 0;
        for (int i = 0; i < StatusOption.values().length; ++i) {
            if (!"true".equals(record.getField(2 + i))) continue;
            value += StatusOption.values()[i].getOption().toggle();
        }
        HashSet<CourseType> types = new HashSet<CourseType>();
        List courseTypes = CourseTypeDAO.getInstance().findAll(Order.asc((String)"reference"));
        if (!courseTypes.isEmpty()) {
            for (int i = 0; i < courseTypes.size(); ++i) {
                if (!"true".equals(record.getField(3 + StatusOption.values().length + i))) continue;
                types.add((CourseType)courseTypes.get(i));
            }
            if (!"true".equals(record.getField(3 + StatusOption.values().length + courseTypes.size()))) {
                value += StudentSectioningStatus.Option.notype.toggle();
            }
        }
        boolean changed = !ToolBox.equals((Object)status.getReference(), (Object)record.getField(0)) || !ToolBox.equals((Object)status.getLabel(), (Object)record.getField(1)) || !ToolBox.equals((Object)status.getStatus(), (Object)value) || !ToolBox.equals(status.getTypes(), types) || !ToolBox.equals((Object)status.getMessage(), (Object)record.getField(2 + StatusOption.values().length));
        status.setReference(record.getField(0));
        status.setLabel(record.getField(1));
        status.setStatus(value);
        status.setTypes(types);
        status.setMessage(record.getField(2 + StatusOption.values().length));
        hibSession.saveOrUpdate((Object)status);
        if (changed) {
            ChangeLog.addChange(hibSession, context, status, status.getReference() + " " + status.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
    }

    @PreAuthorize(value="checkPermission('StudentSchedulingStatusTypeEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((StudentSectioningStatus)StudentSectioningStatusDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(StudentSectioningStatus status, SessionContext context, Session hibSession) {
        if (status == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, status, status.getReference() + " " + status.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)status);
    }

    @PreAuthorize(value="checkPermission('StudentSchedulingStatusTypeEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((StudentSectioningStatus)StudentSectioningStatusDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum StatusOption {
        Access(MESSAGES.toggleAccess(), StudentSectioningStatus.Option.enabled),
        Enrollment(MESSAGES.toggleEnrollment(), StudentSectioningStatus.Option.enrollment),
        Advisor(MESSAGES.toggleAdvisor(), StudentSectioningStatus.Option.advisor),
        Admin(MESSAGES.toggleAdmin(), StudentSectioningStatus.Option.admin),
        Email(MESSAGES.toggleEmail(), StudentSectioningStatus.Option.email),
        WaitListing(MESSAGES.toggleWaitList(), StudentSectioningStatus.Option.waitlist),
        NoBatch(MESSAGES.toggleNoBatch(), StudentSectioningStatus.Option.nobatch);

        private StudentSectioningStatus.Option iOption;
        private String iLabel;

        private StatusOption(String label, StudentSectioningStatus.Option option) {
            this.iLabel = label;
            this.iOption = option;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public StudentSectioningStatus.Option getOption() {
            return this.iOption;
        }
    }
}

