/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseChangeLog;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.reports.exam.InstructorExamReport;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentExamReport
extends PdfLegacyExamReport {
    protected static Logger sLog = Logger.getLogger(StudentExamReport.class);
    Hashtable<Long, Student> iStudents = null;
    Hashtable<Long, ClassEvent> iClass2event = null;
    Hashtable<Long, Location> iLocations = null;

    public StudentExamReport(int mode, File file, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, file, "STUDENT EXAMINATION SCHEDULE", session, examType, subjectAreas, exams);
    }

    public StudentExamReport(int mode, OutputStream out, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, out, "STUDENT EXAMINATION SCHEDULE", session, examType, subjectAreas, exams);
    }

    private void generateCache() {
        if (this.iStudents == null) {
            sLog.info((Object)"  Loading students...");
            this.iStudents = new Hashtable();
            for (Student s : new StudentDAO().getSession().createQuery("select s from Student s where s.session.uniqueId=:sessionId").setLong("sessionId", this.getSession().getUniqueId().longValue()).setCacheable(true).list()) {
                this.iStudents.put(s.getUniqueId(), s);
            }
        }
        if (this.iClass2event == null) {
            sLog.info((Object)"  Loading class events...");
            this.iClass2event = new Hashtable();
            if (this.hasSubjectAreas()) {
                for (SubjectArea subject : this.getSubjectAreas()) {
                    for (Object[] o : new SessionDAO().getSession().createQuery("select c.uniqueId, e from ClassEvent e inner join e.clazz c left join fetch e.meetings m inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.subjectArea.uniqueId=:subjectAreaId").setLong("subjectAreaId", subject.getUniqueId().longValue()).setCacheable(true).list()) {
                        this.iClass2event.put((Long)o[0], (ClassEvent)o[1]);
                    }
                }
            } else {
                for (Object[] o : new SessionDAO().getSession().createQuery("select c.uniqueId, e from ClassEvent e inner join e.clazz c left join fetch e.meetings m inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.subjectArea.session.uniqueId=:sessionId").setLong("sessionId", this.getSession().getUniqueId().longValue()).setCacheable(true).list()) {
                    this.iClass2event.put((Long)o[0], (ClassEvent)o[1]);
                }
            }
        }
        if (this.iLocations == null) {
            sLog.info((Object)"  Loading locations...");
            this.iLocations = new Hashtable();
            for (Location location : new SessionDAO().getSession().createQuery("select r from Room r where r.session.uniqueId=:sessionId and r.permanentId!=null").setLong("sessionId", this.getSession().getUniqueId().longValue()).setCacheable(true).list()) {
                this.iLocations.put(location.getPermanentId(), location);
            }
            for (Location location : new SessionDAO().getSession().createQuery("select r from NonUniversityLocation r where r.session.uniqueId=:sessionId and r.permanentId!=null").setLong("sessionId", this.getSession().getUniqueId().longValue()).setCacheable(true).list()) {
                this.iLocations.put(location.getPermanentId(), location);
            }
        }
    }

    public boolean isOfSubjectArea(TreeSet<ExamInfo.ExamSectionInfo> sections) {
        for (ExamInfo.ExamSectionInfo section : sections) {
            if (!this.hasSubjectArea(section)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void printReport() throws DocumentException {
        this.generateCache();
        sLog.info((Object)"  Printing report...");
        Hashtable<Student, TreeSet<ExamInfo.ExamSectionInfo>> sections = new Hashtable<Student, TreeSet<ExamInfo.ExamSectionInfo>>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            if (exam.getPeriod() == null) continue;
            for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                for (Long studentId : section.getStudentIds()) {
                    Student student = this.iStudents.get(studentId);
                    TreeSet<ExamInfo.ExamSectionInfo> sectionsThisStudent = (TreeSet<ExamInfo.ExamSectionInfo>)sections.get(student);
                    if (sectionsThisStudent == null) {
                        sectionsThisStudent = new TreeSet<ExamInfo.ExamSectionInfo>();
                        sections.put(student, sectionsThisStudent);
                    }
                    sectionsThisStudent.add(section);
                }
            }
        }
        this.printHeader();
        int index = 0;
        for (Student student : new TreeSet(sections.keySet())) {
            ChangeLog last;
            TreeSet sectionsThisStudent = (TreeSet)sections.get(student);
            if (!this.isOfSubjectArea(sectionsThisStudent)) continue;
            if (this.iSince != null && ((last = this.getLastChange(sectionsThisStudent)) == null || this.iSince.compareTo(last.getTimeStamp()) > 0)) {
                sLog.debug((Object)("No change found for " + student.getName(DepartmentalInstructor.sNameFormatLastFist)));
                continue;
            }
            if (index > 0) {
                this.newPage();
            }
            this.printReport(student, sectionsThisStudent);
            if (++index % 100 != 0) continue;
            sLog.debug((Object)("  " + index + " students printed"));
        }
        this.lastPage();
    }

    public void printReport(Long studentId) throws DocumentException {
        TreeSet<ExamInfo.ExamSectionInfo> sections = new TreeSet<ExamInfo.ExamSectionInfo>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            if (exam.getPeriod() == null) continue;
            for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                if (!section.getStudentIds().contains(studentId)) continue;
                sections.add(section);
            }
        }
        if (sections.isEmpty()) {
            return;
        }
        Student student = (Student)new StudentDAO().get(studentId);
        this.printHeader();
        this.printReport(student, sections);
        this.lastPage();
    }

    public void printReport(Student student, TreeSet<ExamInfo.ExamSectionInfo> sections) throws DocumentException {
        String name = student.getName(DepartmentalInstructor.sNameFormatLastFist);
        String shortName = student.getName(DepartmentalInstructor.sNameFormatLastInitial).toUpperCase();
        this.setPageName(shortName);
        this.setCont(shortName);
        this.println("Name:  " + name);
        if (student.getEmail() != null) {
            this.println("Email:       " + student.getEmail());
        }
        if (this.iClassSchedule) {
            StudentClassComparator scc = new StudentClassComparator(student);
            TreeSet<Class_> allClasses = new TreeSet<Class_>(scc);
            for (StudentClassEnrollment sce : student.getClassEnrollments()) {
                allClasses.add(sce.getClazz());
            }
            if (!allClasses.isEmpty()) {
                this.println("");
                String[] stringArray = new String[2];
                stringArray[0] = "Subject Course   " + (this.iItype ? (this.iExternal ? "ExtnID " : "Type   ") : "") + "Section   Dates                     Time            Room        Instructor";
                stringArray[1] = "------- -------- " + (this.iItype ? "------ " : "") + "--------- ------------------------- --------------- ----------- -------------------------";
                this.setHeader(stringArray);
                this.println(this.mpad("~ ~ ~ ~ ~ CLASS SCHEDULE ~ ~ ~ ~ ~", this.iNrChars));
                for (int i = 0; i < this.getHeader().length; ++i) {
                    this.println(this.getHeader()[i]);
                }
                for (Class_ clazz : allClasses) {
                    ClassEvent event;
                    Object instructor = "";
                    if (clazz.isDisplayInstructor().booleanValue()) {
                        for (ClassInstructor ci : new TreeSet<ClassInstructor>(clazz.getClassInstructors())) {
                            if (((String)instructor).length() > 0) {
                                instructor = (String)instructor + ", ";
                            }
                            instructor = (String)instructor + ci.getInstructor().getName(DepartmentalInstructor.sNameFormatLastInitial);
                        }
                    }
                    CourseOffering correctedCourse = scc.getCourse(clazz);
                    String subject = correctedCourse.getSubjectAreaAbbv();
                    String course = correctedCourse.getCourseNbr();
                    String itype = this.getItype(correctedCourse, clazz);
                    String string = this.iUseClassSuffix && clazz.getClassSuffix() != null ? clazz.getClassSuffix() : clazz.getSectionNumberString();
                    ClassEvent classEvent = event = this.iClass2event == null ? clazz.getEvent() : this.iClass2event.get(clazz.getUniqueId());
                    if (event == null && this.iClass2event != null && !this.hasSubjectArea(subject)) {
                        event = clazz.getEvent();
                    }
                    if (event == null || event.getMeetings().isEmpty()) {
                        this.println(this.rpad(subject, 7) + " " + this.rpad(course, 8) + " " + (this.iItype ? this.rpad(itype, 6) + " " : "") + this.lpad(string, 9) + " " + this.rpad("ARRANGED HOURS", 54) + this.rpad((String)instructor, 55));
                        continue;
                    }
                    Event.MultiMeeting last = null;
                    String lastTime = null;
                    String lastDate = null;
                    String lastLoc = null;
                    for (Event.MultiMeeting meeting : event.getMultiMeetings()) {
                        Location location;
                        String line = last == null ? this.rpad(subject, 7) + " " + this.rpad(course, 8) + " " + (this.iItype ? this.rpad(itype, 6) + " " : "") + this.lpad(string, 9) + " " : this.rpad("", 27 + (this.iItype ? 7 : 0));
                        String date = this.getMeetingDate(meeting);
                        String time = this.getMeetingTime(meeting.getMeetings().first());
                        line = last == null || !time.equals(lastTime) || !date.equals(lastDate) ? line + this.rpad(date.equals(lastDate) ? "" : date, 25) + " " + this.rpad(time.equals(lastTime) ? "" : time, 15) + " " : line + this.rpad("", 42);
                        Long permId = meeting.getMeetings().first().getLocationPermanentId();
                        Location location2 = permId == null ? null : (location = this.iLocations == null ? meeting.getMeetings().first().getLocation() : this.iLocations.get(permId));
                        if (location == null && this.iLocations != null && !this.hasSubjectArea(subject)) {
                            location = meeting.getMeetings().first().getLocation();
                        }
                        String loc = location == null ? this.rpad("", 11) : this.formatRoom(location.getLabel());
                        line = last == null || !loc.equals(lastLoc) ? line + loc + " " : line + this.rpad("", 12);
                        if (last == null) {
                            line = line + (String)instructor;
                        }
                        lastLoc = loc;
                        lastTime = time;
                        lastDate = date;
                        last = meeting;
                        this.println(line);
                        if (!this.iNewPage) continue;
                        last = null;
                        lastTime = null;
                        lastDate = null;
                        lastLoc = null;
                    }
                }
            }
        }
        this.println("");
        String[] stringArray = new String[2];
        stringArray[0] = "Subject Course   " + (this.iItype ? (this.iExternal ? "ExtnID " : "Type   ") : "") + "Section   Meeting Times                        Date And Time                  Room       ";
        stringArray[1] = "------- -------- " + (this.iItype ? "------ " : "") + "--------- ------------------------------------ ------------------------------ -----------";
        this.setHeader(stringArray);
        this.println(this.mpad("~ ~ ~ ~ ~ EXAMINATION SCHEDULE ~ ~ ~ ~ ~", this.iNrChars));
        for (int i = 0; i < this.getHeader().length; ++i) {
            this.println(this.getHeader()[i]);
        }
        this.iSubjectPrinted = false;
        String lastSubject = null;
        this.iCoursePrinted = false;
        String lastCourse = null;
        this.iITypePrinted = false;
        String lastItype = null;
        this.iPeriodPrinted = false;
        String lastSection = null;
        for (ExamInfo.ExamSectionInfo section : sections) {
            if (this.iSubjectPrinted && !section.getSubject().equals(lastSubject)) {
                this.iSubjectPrinted = false;
                this.iCoursePrinted = false;
                this.iITypePrinted = false;
                this.iPeriodPrinted = false;
            }
            if (this.iCoursePrinted && !section.getCourseNbr().equals(lastCourse)) {
                this.iCoursePrinted = false;
                this.iITypePrinted = false;
                this.iPeriodPrinted = false;
            }
            if (this.iITypePrinted && !section.getItype().equals(lastItype)) {
                this.iITypePrinted = false;
                this.iPeriodPrinted = false;
            }
            if (this.iPeriodPrinted && !section.getSection().equals(lastSection)) {
                this.iPeriodPrinted = false;
            }
            if (section.getExamAssignment().getRooms() == null || section.getExamAssignment().getRooms().isEmpty()) {
                this.println(this.rpad(this.iSubjectPrinted ? "" : section.getSubject(), 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iITypePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(this.iPeriodPrinted ? "" : section.getSection(), 9) + " " + this.rpad(this.getMeetingTime(section), 36) + " " + this.rpad(section.getExamAssignment() == null ? "" : section.getExamAssignment().getPeriodNameFixedLength(), 30) + " " + (section.getExamAssignment() == null ? "" : this.iNoRoom));
            } else {
                if (this.getLineNumber() + section.getExamAssignment().getRooms().size() > this.iNrLines) {
                    this.newPage();
                }
                boolean firstRoom = true;
                for (ExamRoomInfo room : section.getExamAssignment().getRooms()) {
                    this.println(this.rpad(!firstRoom || this.iSubjectPrinted ? "" : section.getSubject(), 7) + " " + this.rpad(!firstRoom || this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(!firstRoom || this.iITypePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(!firstRoom || this.iPeriodPrinted ? "" : section.getSection(), 9) + " " + this.rpad(!firstRoom ? "" : this.getMeetingTime(section), 36) + " " + this.rpad(!firstRoom ? "" : (section.getExamAssignment() == null ? "" : section.getExamAssignment().getPeriodNameFixedLength()), 30) + " " + this.formatRoom(room.getName()));
                    firstRoom = false;
                }
            }
            if (this.iNewPage) {
                this.iPeriodPrinted = false;
                this.iCoursePrinted = false;
                this.iITypePrinted = false;
                this.iSubjectPrinted = false;
                lastSection = null;
                lastCourse = null;
                lastItype = null;
                lastSubject = null;
                continue;
            }
            this.iPeriodPrinted = true;
            this.iCoursePrinted = true;
            this.iITypePrinted = true;
            this.iSubjectPrinted = true;
            lastSubject = section.getSubject();
            lastItype = section.getItype();
            lastCourse = section.getCourseNbr();
            lastSection = section.getSection();
        }
        boolean headerPrinted = false;
        lastSubject = null;
        for (ExamInfo.ExamSectionInfo section : sections) {
            boolean bl = this.iSubjectPrinted = !this.iNewPage && lastSubject != null && lastSubject.equals(section.getSubject());
            ExamAssignmentInfo exam = section.getExamAssignmentInfo();
            if (exam == null || exam.getPeriod() == null) continue;
            this.iCoursePrinted = false;
            if (this.iDirect) {
                for (ExamAssignmentInfo.DirectConflict directConflict : exam.getDirectConflicts()) {
                    if (!directConflict.getStudents().contains(student.getUniqueId())) continue;
                    this.iPeriodPrinted = false;
                    if (directConflict.getOtherExam() != null) {
                        for (ExamInfo.ExamSectionInfo other : directConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                            if (!other.getStudentIds().contains(student.getUniqueId())) continue;
                            if (!headerPrinted) {
                                if (!this.iNewPage) {
                                    this.println("");
                                }
                                this.setHeader(null);
                                if (this.getLineNumber() + 5 >= this.iNrLines) {
                                    this.newPage();
                                }
                                String[] stringArray2 = new String[2];
                                stringArray2[0] = "Subject Course   " + (this.iItype ? (this.iExternal ? "ExtnID " : "Type   ") : "") + "Section   Date And Time             Type   Subject Course   " + (this.iItype ? (this.iExternal ? "ExtnID " : "Type   ") : "") + "Section   Time           ";
                                stringArray2[1] = "------- -------- " + (this.iItype ? "------ " : "") + "--------- ------------------------- ------ ------- -------- " + (this.iItype ? "------ " : "") + "--------- ---------------";
                                this.setHeader(stringArray2);
                                this.println(this.mpad("~ ~ ~ ~ ~ EXAMINATION CONFLICTS AND/OR BACK-TO-BACK EXAMINATIONS ~ ~ ~ ~ ~", this.iNrChars));
                                for (int i = 0; i < this.getHeader().length; ++i) {
                                    this.println(this.getHeader()[i]);
                                }
                                this.setCont(shortName + "  EXAMINATION CONFLICTS");
                                headerPrinted = true;
                            }
                            this.println(this.rpad(this.iSubjectPrinted ? "" : section.getSubject(), 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(this.iCoursePrinted ? "" : section.getSection(), 9) + " " + this.rpad(this.iCoursePrinted ? "" : exam.getPeriodNameFixedLength(), 25) + " " + this.rpad(this.iPeriodPrinted ? "" : "DIRECT", 6) + " " + this.rpad(other.getSubject(), 7) + " " + this.rpad(other.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(other.getItype(), 6) + " " : "") + this.lpad(other.getSection(), 9) + " " + other.getExamAssignment().getTimeFixedLength());
                            this.iPeriodPrinted = !this.iNewPage;
                            this.iStudentPrinted = this.iPeriodPrinted;
                            this.iCoursePrinted = this.iPeriodPrinted;
                            this.iSubjectPrinted = this.iPeriodPrinted;
                            lastSubject = section.getSubject();
                        }
                        continue;
                    }
                    if (directConflict.getOtherEventId() == null) continue;
                    if (!headerPrinted) {
                        if (!this.iNewPage) {
                            this.println("");
                        }
                        this.setHeader(null);
                        if (this.getLineNumber() + 5 >= this.iNrLines) {
                            this.newPage();
                        }
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = "Subject Course   " + (this.iItype ? (this.iExternal ? "ExtnID " : "Type   ") : "") + "Section   Date And Time             Type   Subject Course   " + (this.iItype ? (this.iExternal ? "ExtnID " : "Type   ") : "") + "Section   Time           ";
                        stringArray3[1] = "------- -------- " + (this.iItype ? "------ " : "") + "--------- ------------------------- ------ ------- -------- " + (this.iItype ? "------ " : "") + "--------- ---------------";
                        this.setHeader(stringArray3);
                        this.println(this.mpad("~ ~ ~ ~ ~ EXAMINATION CONFLICTS AND/OR BACK-TO-BACK EXAMINATIONS ~ ~ ~ ~ ~", this.iNrChars));
                        for (int i = 0; i < this.getHeader().length; ++i) {
                            this.println(this.getHeader()[i]);
                        }
                        this.setCont(shortName + "  EXAMINATION CONFLICTS");
                        headerPrinted = true;
                    }
                    if (directConflict.isOtherClass()) {
                        this.println(this.rpad(this.iSubjectPrinted ? "" : section.getSubject(), 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(this.iCoursePrinted ? "" : section.getSection(), 9) + " " + this.rpad(this.iCoursePrinted ? "" : exam.getPeriodNameFixedLength(), 25) + " " + this.rpad(this.iPeriodPrinted ? "" : "CLASS", 6) + " " + this.rpad(directConflict.getOtherClass().getSchedulingSubpart().getControllingCourseOffering().getSubjectAreaAbbv(), 7) + " " + this.rpad(directConflict.getOtherClass().getSchedulingSubpart().getControllingCourseOffering().getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iExternal ? directConflict.getOtherClass().getExternalUniqueId() : directConflict.getOtherClass().getSchedulingSubpart().getItypeDesc(), 6) + " " : "") + this.lpad(this.iUseClassSuffix && directConflict.getOtherClass().getClassSuffix() != null ? directConflict.getOtherClass().getClassSuffix() : directConflict.getOtherClass().getSectionNumberString(), 9) + " " + this.getMeetingTime(directConflict.getOtherEventTime()));
                    } else {
                        this.println(this.rpad(this.iSubjectPrinted ? "" : section.getSubject(), 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(this.iCoursePrinted ? "" : section.getSection(), 9) + " " + this.rpad(this.iCoursePrinted ? "" : exam.getPeriodNameFixedLength(), 25) + " " + this.rpad(this.iPeriodPrinted ? "" : "EVENT", 6) + " " + this.rpad(directConflict.getOtherEventName(), this.iItype ? 33 : 26) + " " + this.getMeetingTime(directConflict.getOtherEventTime()));
                    }
                    this.iPeriodPrinted = !this.iNewPage;
                    this.iStudentPrinted = this.iPeriodPrinted;
                    this.iCoursePrinted = this.iPeriodPrinted;
                    this.iSubjectPrinted = this.iPeriodPrinted;
                    lastSubject = section.getSubject();
                }
            }
            if (this.iM2d) {
                for (ExamAssignmentInfo.MoreThanTwoADayConflict moreThanTwoADayConflict : exam.getMoreThanTwoADaysConflicts()) {
                    if (!moreThanTwoADayConflict.getStudents().contains(student.getUniqueId())) continue;
                    this.iPeriodPrinted = false;
                    for (ExamAssignment otherExam : moreThanTwoADayConflict.getOtherExams()) {
                        for (ExamInfo.ExamSectionInfo other : otherExam.getSectionsIncludeCrosslistedDummies()) {
                            if (!other.getStudentIds().contains(student.getUniqueId())) continue;
                            if (!headerPrinted) {
                                if (!this.iNewPage) {
                                    this.println("");
                                }
                                this.setHeader(null);
                                if (this.getLineNumber() + 5 >= this.iNrLines) {
                                    this.newPage();
                                }
                                String[] stringArray4 = new String[2];
                                stringArray4[0] = "Subject Course   " + (this.iItype ? (this.iExternal ? "ExtnID " : "Type   ") : "") + "Section   Date And Time             Type   Subject Course   " + (this.iItype ? (this.iExternal ? "ExtnID " : "Type   ") : "") + "Section   Time           ";
                                stringArray4[1] = "------- -------- " + (this.iItype ? "------ " : "") + "--------- ------------------------- ------ ------- -------- " + (this.iItype ? "------ " : "") + "--------- ---------------";
                                this.setHeader(stringArray4);
                                this.println(this.mpad("~ ~ ~ ~ ~ EXAMINATION CONFLICTS AND/OR BACK-TO-BACK EXAMINATIONS ~ ~ ~ ~ ~", this.iNrChars));
                                for (int i = 0; i < this.getHeader().length; ++i) {
                                    this.println(this.getHeader()[i]);
                                }
                                this.setCont(shortName + "  EXAMINATION CONFLICTS");
                                headerPrinted = true;
                            }
                            this.println(this.rpad(this.iSubjectPrinted ? "" : section.getSubject(), 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(this.iCoursePrinted ? "" : section.getSection(), 9) + " " + this.rpad(this.iCoursePrinted ? "" : exam.getPeriodNameFixedLength(), 25) + " " + this.rpad(this.iPeriodPrinted ? "" : ">2-DAY", 6) + " " + this.rpad(other.getSubject(), 7) + " " + this.rpad(other.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(other.getItype(), 6) + " " : "") + this.lpad(other.getSection(), 9) + " " + other.getExamAssignment().getTimeFixedLength());
                            this.iPeriodPrinted = !this.iNewPage;
                            this.iStudentPrinted = this.iPeriodPrinted;
                            this.iCoursePrinted = this.iPeriodPrinted;
                            this.iSubjectPrinted = this.iPeriodPrinted;
                            lastSubject = section.getSubject();
                        }
                    }
                }
            }
            if (!this.iBtb) continue;
            for (ExamAssignmentInfo.BackToBackConflict backToBackConflict : exam.getBackToBackConflicts()) {
                if (!backToBackConflict.getStudents().contains(student.getUniqueId())) continue;
                this.iPeriodPrinted = false;
                for (ExamInfo.ExamSectionInfo other : backToBackConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                    if (!other.getStudentIds().contains(student.getUniqueId())) continue;
                    if (!headerPrinted) {
                        if (!this.iNewPage) {
                            this.println("");
                        }
                        this.setHeader(null);
                        if (this.getLineNumber() + 5 >= this.iNrLines) {
                            this.newPage();
                        }
                        String[] stringArray5 = new String[2];
                        stringArray5[0] = "Subject Course   " + (this.iItype ? (this.iExternal ? "ExtnID " : "Type   ") : "") + "Section   Date And Time             Type   Subject Course   " + (this.iItype ? (this.iExternal ? "ExtnID " : "Type   ") : "") + "Section   Time           ";
                        stringArray5[1] = "------- -------- " + (this.iItype ? "------ " : "") + "--------- ------------------------- ------ ------- -------- " + (this.iItype ? "------ " : "") + "--------- ---------------";
                        this.setHeader(stringArray5);
                        this.println(this.mpad("~ ~ ~ ~ ~ EXAMINATION CONFLICTS AND/OR BACK-TO-BACK EXAMINATIONS ~ ~ ~ ~ ~", this.iNrChars));
                        for (int i = 0; i < this.getHeader().length; ++i) {
                            this.println(this.getHeader()[i]);
                        }
                        this.setCont(shortName + "  EXAMINATION CONFLICTS");
                        headerPrinted = true;
                    }
                    this.println(this.rpad(this.iSubjectPrinted ? "" : section.getSubject(), 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(this.iCoursePrinted ? "" : section.getSection(), 9) + " " + this.rpad(this.iCoursePrinted ? "" : exam.getPeriodNameFixedLength(), 25) + " " + this.rpad(this.iPeriodPrinted ? "" : "BTB", 6) + " " + this.rpad(other.getSubject(), 7) + " " + this.rpad(other.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(other.getItype(), 6) + " " : "") + this.lpad(other.getSection(), 9) + " " + other.getExamAssignment().getTimeFixedLength());
                    this.iPeriodPrinted = !this.iNewPage;
                    this.iStudentPrinted = this.iPeriodPrinted;
                    this.iCoursePrinted = this.iPeriodPrinted;
                    this.iSubjectPrinted = this.iPeriodPrinted;
                    lastSubject = section.getSubject();
                }
            }
        }
        this.setHeader(null);
        this.setCont(null);
    }

    public ChangeLog getLastChange(TreeSet<ExamInfo.ExamSectionInfo> sections) {
        BaseChangeLog lastChange = null;
        for (ExamInfo.ExamSectionInfo section : sections) {
            ChangeLog c = ChangeLog.findLastChange(section.getExam().getExam());
            if (c == null || lastChange != null && lastChange.getTimeStamp().compareTo(c.getTimeStamp()) >= 0) continue;
            lastChange = c;
        }
        return lastChange;
    }

    public Hashtable<Student, File> printStudentReports(int mode, String filePrefix, InstructorExamReport.FileGenerator gen) throws DocumentException, IOException {
        this.generateCache();
        sLog.info((Object)"Printing individual student reports...");
        Hashtable<Student, File> files = new Hashtable<Student, File>();
        Hashtable<Student, TreeSet<ExamInfo.ExamSectionInfo>> sections = new Hashtable<Student, TreeSet<ExamInfo.ExamSectionInfo>>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                for (Long studentId : section.getStudentIds()) {
                    Student student = this.iStudents.get(studentId);
                    TreeSet<ExamInfo.ExamSectionInfo> sectionsThisStudent = (TreeSet<ExamInfo.ExamSectionInfo>)sections.get(student);
                    if (sectionsThisStudent == null) {
                        sectionsThisStudent = new TreeSet<ExamInfo.ExamSectionInfo>();
                        sections.put(student, sectionsThisStudent);
                    }
                    sectionsThisStudent.add(section);
                }
            }
        }
        for (Student student : new TreeSet(sections.keySet())) {
            ChangeLog last;
            TreeSet sectionsThisStudent = (TreeSet)sections.get(student);
            if (!this.isOfSubjectArea(sectionsThisStudent)) continue;
            if (this.iSince != null && ((last = this.getLastChange(sectionsThisStudent)) == null || this.iSince.compareTo(last.getTimeStamp()) > 0)) {
                sLog.debug((Object)("No change found for " + student.getName(DepartmentalInstructor.sNameFormatLastFist)));
                continue;
            }
            sLog.debug((Object)("  Generating file for " + student.getName(DepartmentalInstructor.sNameFormatLastFist)));
            File file = gen.generate(filePrefix + "_" + (student.getExternalUniqueId() != null ? student.getExternalUniqueId() : student.getLastName()), mode == 2 ? "txt" : "pdf");
            this.open(file, mode);
            this.printHeader();
            this.printReport(student, sectionsThisStudent);
            this.lastPage();
            this.close();
            files.put(student, file);
        }
        return files;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StudentClassComparator
    implements Comparator<Class_> {
        private Student iStudent;

        public StudentClassComparator(Student student) {
            this.iStudent = student;
        }

        public CourseOffering getCourse(Class_ clazz) {
            CourseOffering correctedCourse = clazz.getSchedulingSubpart().getControllingCourseOffering();
            for (StudentClassEnrollment sce : this.iStudent.getClassEnrollments()) {
                if (!sce.getCourseOffering().getInstructionalOffering().equals(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering())) continue;
                correctedCourse = sce.getCourseOffering();
                break;
            }
            return correctedCourse;
        }

        @Override
        public int compare(Class_ c1, Class_ c2) {
            CourseOffering co1 = this.getCourse(c1);
            CourseOffering co2 = this.getCourse(c2);
            int cmp = co1.getSubjectAreaAbbv().compareTo(co2.getSubjectAreaAbbv());
            if (cmp != 0) {
                return cmp;
            }
            cmp = co1.getCourseNbr().compareTo(co2.getCourseNbr());
            if (cmp != 0) {
                return cmp;
            }
            if (this.isParentOf(c1, c2)) {
                return -1;
            }
            if (this.isParentOf(c2, c1)) {
                return 1;
            }
            if (cmp != 0) {
                return cmp;
            }
            cmp = c1.getSchedulingSubpart().getItype().compareTo(c2.getSchedulingSubpart().getItype());
            if (cmp != 0) {
                return cmp;
            }
            return c1.getUniqueId().compareTo(c2.getUniqueId());
        }

        public boolean isParentOf(Class_ c1, Class_ c2) {
            if (c2.getParentClass() != null) {
                if (c2.getParentClass().equals(c1)) {
                    return true;
                }
                return this.isParentOf(c1, c2.getParentClass());
            }
            return false;
        }
    }
}

