/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.model.AcademicAreaClassification;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.base.BaseCourseRequest;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.status.FindStudentInfoAction;
import org.unitime.timetable.onlinesectioning.status.SectioningStatusFilterAction;
import org.unitime.timetable.onlinesectioning.status.db.DbFindEnrollmentInfoAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbFindStudentInfoAction
extends FindStudentInfoAction {
    private static final long serialVersionUID = 1L;

    @Override
    public List<ClassAssignmentInterface.StudentInfo> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (this.iFilter == null) {
            return super.execute(server, helper);
        }
        HashMap<Long, ClassAssignmentInterface.StudentInfo> students = new HashMap<Long, ClassAssignmentInterface.StudentInfo>();
        int gEnrl = 0;
        int gWait = 0;
        int gRes = 0;
        int gUnasg = 0;
        int gtEnrl = 0;
        int gtWait = 0;
        int gtRes = 0;
        int gtUnasg = 0;
        int gConNeed = 0;
        int gtConNeed = 0;
        HashSet<Long> unassigned = new HashSet<Long>();
        AcademicSessionInfo session = server.getAcademicSession();
        DbFindEnrollmentInfoAction.DbFindStudentInfoMatcher sm = new DbFindEnrollmentInfoAction.DbFindStudentInfoMatcher(session, this.iQuery, helper.getStudentNameFormat());
        HashMap<CourseOffering, ArrayList<CourseRequest>> requests = new HashMap<CourseOffering, ArrayList<CourseRequest>>();
        for (CourseRequest courseRequest : SectioningStatusFilterAction.getCourseQuery(this.iFilter, server).select("distinct cr").query(helper.getHibSession()).list()) {
            if (!this.query().match(new DbFindEnrollmentInfoAction.DbCourseRequestMatcher(session, courseRequest, this.isConsentToDoCourse(courseRequest.getCourseOffering()), helper.getStudentNameFormat()))) continue;
            ArrayList<CourseRequest> list = (ArrayList<CourseRequest>)requests.get(courseRequest.getCourseOffering());
            if (list == null) {
                list = new ArrayList<CourseRequest>();
                requests.put(courseRequest.getCourseOffering(), list);
            }
            list.add(courseRequest);
        }
        for (Map.Entry entry : requests.entrySet()) {
            CourseOffering course = (CourseOffering)entry.getKey();
            boolean bl = this.isConsentToDoCourse(course);
            for (CourseRequest request : (List)entry.getValue()) {
                DbFindEnrollmentInfoAction.DbCourseRequestMatcher crm;
                Student student = request.getCourseDemand().getStudent();
                ClassAssignmentInterface.StudentInfo s = (ClassAssignmentInterface.StudentInfo)students.get(student.getUniqueId());
                if (s == null) {
                    s = new ClassAssignmentInterface.StudentInfo();
                    students.put(student.getUniqueId(), s);
                    ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                    s.setStudent(st);
                    st.setId(student.getUniqueId());
                    st.setSessionId(session.getUniqueId());
                    st.setExternalId(student.getExternalUniqueId());
                    st.setCanShowExternalId(this.iCanShowExtIds);
                    st.setCanRegister(this.iCanRegister);
                    st.setCanUseAssistant(this.iCanUseAssistant);
                    st.setName(helper.getStudentNameFormat().format(student));
                    for (AcademicAreaClassification ac : student.getAcademicAreaClassifications()) {
                        st.addArea(ac.getAcademicArea().getAcademicAreaAbbreviation());
                        st.addClassification(ac.getAcademicClassification().getCode());
                    }
                    for (PosMajor mj : student.getPosMajors()) {
                        st.addMajor(mj.getCode());
                    }
                    for (StudentAccomodation acc : student.getAccomodations()) {
                        st.addAccommodation(acc.getAbbreviation());
                    }
                    for (StudentGroup gr : student.getGroups()) {
                        st.addGroup(gr.getGroupAbbreviation());
                    }
                    int tEnrl = 0;
                    int tWait = 0;
                    int tRes = 0;
                    int tConNeed = 0;
                    int tReq = 0;
                    int tUnasg = 0;
                    float tCred = 0.0f;
                    for (CourseDemand demand : student.getCourseDemands()) {
                        if (demand.getCourseRequests().isEmpty()) continue;
                        if (!demand.isAlternative().booleanValue()) {
                            ++tReq;
                        }
                        List<StudentClassEnrollment> enrollment = null;
                        CourseRequest assigned = null;
                        for (CourseRequest courseRequest : demand.getCourseRequests()) {
                            enrollment = courseRequest.getClassEnrollments();
                            if (enrollment.isEmpty()) continue;
                            assigned = courseRequest;
                            break;
                        }
                        if (enrollment.isEmpty()) {
                            BaseCourseRequest first = null;
                            for (CourseRequest r2 : demand.getCourseRequests()) {
                                if (first != null && r2.getOrder() >= first.getOrder()) continue;
                                first = r2;
                            }
                            DbFindEnrollmentInfoAction.DbCourseRequestMatcher dbCourseRequestMatcher = new DbFindEnrollmentInfoAction.DbCourseRequestMatcher(session, (CourseRequest)first, this.isConsentToDoCourse(first.getCourseOffering()), helper.getStudentNameFormat());
                            if (!dbCourseRequestMatcher.canAssign()) continue;
                            ++tUnasg;
                            ++gtUnasg;
                            if (!demand.isWaitlist().booleanValue()) continue;
                            ++tWait;
                            ++gtWait;
                            continue;
                        }
                        ++tEnrl;
                        ++gtEnrl;
                        DbFindEnrollmentInfoAction.DbCourseRequestMatcher crm3 = new DbFindEnrollmentInfoAction.DbCourseRequestMatcher(session, assigned, this.isConsentToDoCourse(assigned.getCourseOffering()), helper.getStudentNameFormat());
                        if (crm3.reservation() != null) {
                            ++tRes;
                            ++gtRes;
                        }
                        if (assigned.getCourseOffering().getConsentType() != null && crm3.approval() == null) {
                            ++tConNeed;
                            ++gtConNeed;
                        }
                        if (assigned.getCourseOffering().getCredit() != null) {
                            tCred += this.guessCredit(assigned.getCourseOffering().getCredit().creditAbbv());
                            continue;
                        }
                        for (StudentClassEnrollment e : enrollment) {
                            if (e.getClazz().getSchedulingSubpart().getCredit() == null) continue;
                            tCred += this.guessCredit(e.getClazz().getSchedulingSubpart().getCredit().creditAbbv());
                        }
                    }
                    s.setTotalEnrollment(tEnrl);
                    s.setTotalReservation(tRes);
                    s.setTotalWaitlist(tWait);
                    s.setTotalUnassigned(tUnasg);
                    s.setTotalConsentNeeded(tConNeed);
                    s.setEnrollment(0);
                    s.setReservation(0);
                    s.setWaitlist(0);
                    s.setUnassigned(0);
                    s.setConsentNeeded(0);
                    s.setRequested(tReq);
                    s.setStatus(student.getSectioningStatus() == null ? session.getDefaultSectioningStatus() : student.getSectioningStatus().getReference());
                    s.setEmailDate(student.getScheduleEmailedDate() == null ? null : student.getScheduleEmailedDate());
                    s.setCredit(Float.valueOf(0.0f));
                    s.setTotalCredit(Float.valueOf(tCred));
                }
                if (!(crm = new DbFindEnrollmentInfoAction.DbCourseRequestMatcher(session, request, bl, helper.getStudentNameFormat())).enrollment().isEmpty()) {
                    s.setEnrollment(s.getEnrollment() + 1);
                    ++gEnrl;
                    if (crm.reservation() != null) {
                        s.setReservation(s.getReservation() + 1);
                        ++gRes;
                    }
                    if (course.getConsentType() != null && crm.approval() == null) {
                        s.setConsentNeeded(s.getConsentNeeded() + 1);
                        ++gConNeed;
                    }
                    for (StudentClassEnrollment e : crm.enrollment()) {
                        if (e.getTimestamp() == null) continue;
                        if (s.getEnrolledDate() == null) {
                            s.setEnrolledDate(e.getTimestamp());
                            continue;
                        }
                        if (!e.getTimestamp().after(s.getEnrolledDate())) continue;
                        s.setEnrolledDate(e.getTimestamp());
                    }
                    if (crm.approval() != null) {
                        for (StudentClassEnrollment e : crm.enrollment()) {
                            if (e.getApprovedDate() == null) continue;
                            if (s.getApprovedDate() == null) {
                                s.setApprovedDate(e.getApprovedDate());
                                continue;
                            }
                            if (!e.getApprovedDate().after(s.getApprovedDate())) continue;
                            s.setApprovedDate(e.getApprovedDate());
                        }
                    }
                    if (course.getCredit() != null) {
                        s.setCredit(Float.valueOf(s.getCredit().floatValue() + this.guessCredit(course.getCredit().creditAbbv())));
                    } else {
                        for (StudentClassEnrollment e : crm.enrollment()) {
                            if (e.getClazz().getSchedulingSubpart().getCredit() == null) continue;
                            s.setCredit(Float.valueOf(s.getCredit().floatValue() + this.guessCredit(e.getClazz().getSchedulingSubpart().getCredit().creditAbbv())));
                        }
                    }
                } else if (crm.canAssign() && unassigned.add(crm.request().getUniqueId())) {
                    if (crm.request().getCourseDemand().isWaitlist().booleanValue()) {
                        s.setWaitlist(s.getWaitlist() + 1);
                        ++gWait;
                        if (s.getTopWaitingPriority() == null) {
                            s.setTopWaitingPriority(1 + crm.request().getCourseDemand().getPriority());
                        } else {
                            s.setTopWaitingPriority(Math.min(1 + crm.request().getCourseDemand().getPriority(), s.getTopWaitingPriority()));
                        }
                    }
                    s.setUnassigned(s.getUnassigned() + 1);
                    ++gUnasg;
                }
                if (crm.request().getCourseDemand().getTimestamp() == null) continue;
                if (s.getRequestedDate() == null) {
                    s.setRequestedDate(crm.request().getCourseDemand().getTimestamp());
                    continue;
                }
                if (!crm.request().getCourseDemand().getTimestamp().after(s.getRequestedDate())) continue;
                s.setRequestedDate(crm.request().getCourseDemand().getTimestamp());
            }
        }
        ArrayList<Object> ret = new ArrayList(students.values());
        for (Student student : SectioningStatusFilterAction.getQuery(this.iFilter, server).select("distinct s").query(helper.getHibSession()).list()) {
            if (students.containsKey(student.getUniqueId()) || !sm.match(student)) continue;
            ClassAssignmentInterface.StudentInfo studentInfo = new ClassAssignmentInterface.StudentInfo();
            ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
            studentInfo.setStudent(st);
            st.setId(student.getUniqueId());
            st.setSessionId(session.getUniqueId());
            st.setExternalId(student.getExternalUniqueId());
            st.setCanShowExternalId(this.iCanShowExtIds);
            st.setCanRegister(this.iCanRegister);
            st.setCanUseAssistant(this.iCanUseAssistant);
            st.setName(helper.getStudentNameFormat().format(student));
            for (AcademicAreaClassification ac : student.getAcademicAreaClassifications()) {
                st.addArea(ac.getAcademicArea().getAcademicAreaAbbreviation());
                st.addClassification(ac.getAcademicClassification().getCode());
            }
            for (PosMajor mj : student.getPosMajors()) {
                st.addMajor(mj.getCode());
            }
            for (StudentAccomodation acc : student.getAccomodations()) {
                st.addAccommodation(acc.getAbbreviation());
            }
            for (StudentGroup gr : student.getGroups()) {
                st.addGroup(gr.getGroupAbbreviation());
            }
            studentInfo.setStatus(student.getSectioningStatus() == null ? session.getDefaultSectioningStatus() : student.getSectioningStatus().getReference());
            studentInfo.setEmailDate(student.getScheduleEmailedDate() == null ? null : student.getScheduleEmailedDate());
            ret.add(studentInfo);
        }
        Collections.sort(ret, new Comparator<ClassAssignmentInterface.StudentInfo>(){

            @Override
            public int compare(ClassAssignmentInterface.StudentInfo s1, ClassAssignmentInterface.StudentInfo s2) {
                int cmp = s1.getStudent().getName().compareTo(s2.getStudent().getName());
                if (cmp != 0) {
                    return cmp;
                }
                return new Long(s1.getStudent().getId()).compareTo(s2.getStudent().getId());
            }
        });
        if (this.limit() != null && ret.size() >= this.limit()) {
            ArrayList<ClassAssignmentInterface.StudentInfo> arrayList = new ArrayList<ClassAssignmentInterface.StudentInfo>(this.limit());
            for (ClassAssignmentInterface.StudentInfo studentInfo : ret) {
                arrayList.add(studentInfo);
                if (arrayList.size() != this.limit().intValue()) continue;
                break;
            }
            ret = arrayList;
        }
        ClassAssignmentInterface.StudentInfo studentInfo = new ClassAssignmentInterface.StudentInfo();
        studentInfo.setEnrollment(gEnrl);
        studentInfo.setReservation(gRes);
        studentInfo.setWaitlist(gWait);
        studentInfo.setUnassigned(gUnasg);
        studentInfo.setTotalEnrollment(gtEnrl);
        studentInfo.setTotalReservation(gtRes);
        studentInfo.setTotalWaitlist(gtWait);
        studentInfo.setTotalUnassigned(gtUnasg);
        studentInfo.setConsentNeeded(gConNeed);
        studentInfo.setTotalConsentNeeded(gtConNeed);
        ret.add(studentInfo);
        return ret;
    }

    public boolean isConsentToDoCourse(CourseOffering course) {
        return this.iCoursesIcanApprove != null && course.getConsentType() != null && this.iCoursesIcanApprove.contains(course.getUniqueId());
    }
}

