/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.MultiLock;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServerContext;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.AbstractServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLockingServer
extends AbstractServer {
    private ReentrantReadWriteLock iLock = new ReentrantReadWriteLock();
    private MultiLock iMultiLock;
    private Map<Long, OnlineSectioningServer.Lock> iOfferingLocks = new Hashtable<Long, OnlineSectioningServer.Lock>();

    public AbstractLockingServer(OnlineSectioningServerContext context) throws SectioningException {
        super(context);
    }

    protected AbstractLockingServer(AcademicSessionInfo session, boolean allowAsyncCalls) {
        super(session, allowAsyncCalls);
        this.iMultiLock = new MultiLock(this.getAcademicSession());
    }

    @Override
    protected void load(OnlineSectioningServerContext context) {
        this.iMultiLock = new MultiLock(this.getAcademicSession());
        super.load(context);
    }

    @Override
    public OnlineSectioningServer.Lock readLock() {
        if (this.iLock == null) {
            return new OnlineSectioningServer.Lock(){

                public void release() {
                }
            };
        }
        this.iLock.readLock().lock();
        return new OnlineSectioningServer.Lock(){

            public void release() {
                AbstractLockingServer.this.iLock.readLock().unlock();
            }
        };
    }

    public OnlineSectioningServer.Lock writeLockIfNotHeld() {
        if (this.iLock == null || this.iLock.isWriteLockedByCurrentThread()) {
            return null;
        }
        this.iLock.writeLock().lock();
        return new OnlineSectioningServer.Lock(){

            public void release() {
                AbstractLockingServer.this.iLock.writeLock().unlock();
            }
        };
    }

    @Override
    public OnlineSectioningServer.Lock writeLock() {
        if (this.iLock == null) {
            return new OnlineSectioningServer.Lock(){

                public void release() {
                }
            };
        }
        this.iLock.writeLock().lock();
        return new OnlineSectioningServer.Lock(){

            public void release() {
                AbstractLockingServer.this.iLock.writeLock().unlock();
            }
        };
    }

    @Override
    public OnlineSectioningServer.Lock lockAll() {
        if (this.iLock == null) {
            return new OnlineSectioningServer.Lock(){

                public void release() {
                }
            };
        }
        this.iLock.writeLock().lock();
        return new OnlineSectioningServer.Lock(){

            public void release() {
                AbstractLockingServer.this.iLock.writeLock().unlock();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OnlineSectioningServer.Lock lockStudent(Long studentId, Collection<Long> offeringIds, String actionName) {
        HashSet<Long> ids = new HashSet<Long>();
        boolean lockStudents = this.getConfig().getPropertyBoolean(actionName + ".LockStudents", true);
        boolean lockOfferings = this.getConfig().getPropertyBoolean(actionName + ".LockOfferings", true);
        boolean excludeLockedOfferings = lockOfferings && this.getConfig().getPropertyBoolean(actionName + ".ExcludeLockedOfferings", true);
        this.iLock.readLock().lock();
        try {
            if (lockStudents) {
                ids.add(-studentId.longValue());
            }
            if (lockOfferings) {
                XStudent student;
                if (offeringIds != null) {
                    for (Long offeringId : offeringIds) {
                        if (excludeLockedOfferings && this.isOfferingLocked(offeringId)) continue;
                        ids.add(offeringId);
                    }
                }
                if ((student = this.getStudent(studentId)) != null) {
                    for (XRequest r : student.getRequests()) {
                        if (!(r instanceof XCourseRequest) || ((XCourseRequest)r).getEnrollment() == null) continue;
                        Long offeringId = ((XCourseRequest)r).getEnrollment().getOfferingId();
                        if (excludeLockedOfferings && this.isOfferingLocked(offeringId)) continue;
                        ids.add(offeringId);
                    }
                }
            }
            Object var13_12 = null;
            this.iLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.iLock.readLock().unlock();
            throw throwable;
        }
        return this.iMultiLock.lock(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OnlineSectioningServer.Lock lockOffering(Long offeringId, Collection<Long> studentIds, String actionName) {
        HashSet<Long> ids = new HashSet<Long>();
        boolean lockStudents = this.getConfig().getPropertyBoolean(actionName + ".LockStudents", true);
        boolean lockOfferings = this.getConfig().getPropertyBoolean(actionName + ".LockOfferings", true);
        boolean excludeLockedOffering = lockOfferings && this.getConfig().getPropertyBoolean(actionName + ".ExcludeLockedOfferings", true);
        this.iLock.readLock().lock();
        try {
            if (!(!lockOfferings || excludeLockedOffering && this.isOfferingLocked(offeringId))) {
                ids.add(offeringId);
            }
            if (lockStudents) {
                Collection<XCourseRequest> requests;
                if (studentIds != null) {
                    for (Long studentId : studentIds) {
                        ids.add(-studentId.longValue());
                    }
                }
                if ((requests = this.getRequests(offeringId)) != null) {
                    for (XCourseRequest request : requests) {
                        ids.add(-request.getStudentId().longValue());
                    }
                }
            }
            Object var12_11 = null;
            this.iLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.iLock.readLock().unlock();
            throw throwable;
        }
        return this.iMultiLock.lock(ids);
    }

    private Long getOfferingIdFromCourseName(String courseName) {
        if (courseName == null) {
            return null;
        }
        XCourseId c = this.getCourse(courseName);
        return c == null ? null : c.getOfferingId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OnlineSectioningServer.Lock lockRequest(CourseRequestInterface request, String actionName) {
        HashSet<Long> ids = new HashSet<Long>();
        boolean lockStudents = this.getConfig().getPropertyBoolean(actionName + ".LockStudents", true);
        boolean lockOfferings = this.getConfig().getPropertyBoolean(actionName + ".LockOfferings", true);
        boolean excludeLockedOffering = lockOfferings && this.getConfig().getPropertyBoolean(actionName + ".ExcludeLockedOfferings", true);
        this.iLock.readLock().lock();
        try {
            if (lockStudents && request.getStudentId() != null) {
                ids.add(-request.getStudentId().longValue());
            }
            if (lockOfferings) {
                Long id;
                for (CourseRequestInterface.Request r : request.getCourses()) {
                    if (!(!r.hasRequestedCourse() || (id = this.getOfferingIdFromCourseName(r.getRequestedCourse())) == null || excludeLockedOffering && this.isOfferingLocked(id))) {
                        ids.add(id);
                    }
                    if (!(!r.hasFirstAlternative() || (id = this.getOfferingIdFromCourseName(r.getFirstAlternative())) == null || excludeLockedOffering && this.isOfferingLocked(id))) {
                        ids.add(id);
                    }
                    if (!r.hasSecondAlternative() || (id = this.getOfferingIdFromCourseName(r.getSecondAlternative())) == null || excludeLockedOffering && this.isOfferingLocked(id)) continue;
                    ids.add(id);
                }
                for (CourseRequestInterface.Request r : request.getAlternatives()) {
                    if (!(!r.hasRequestedCourse() || (id = this.getOfferingIdFromCourseName(r.getRequestedCourse())) == null || excludeLockedOffering && this.isOfferingLocked(id))) {
                        ids.add(id);
                    }
                    if (!(!r.hasFirstAlternative() || (id = this.getOfferingIdFromCourseName(r.getFirstAlternative())) == null || excludeLockedOffering && this.isOfferingLocked(id))) {
                        ids.add(id);
                    }
                    if (!r.hasSecondAlternative() || (id = this.getOfferingIdFromCourseName(r.getSecondAlternative())) == null || excludeLockedOffering && this.isOfferingLocked(id)) continue;
                    ids.add(id);
                }
            }
            Object var11_10 = null;
            this.iLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.iLock.readLock().unlock();
            throw throwable;
        }
        return this.iMultiLock.lock(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOfferingLocked(Long offeringId) {
        Map<Long, OnlineSectioningServer.Lock> map = this.iOfferingLocks;
        synchronized (map) {
            return this.iOfferingLocks.containsKey(offeringId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockOffering(Long offeringId) {
        Map<Long, OnlineSectioningServer.Lock> map = this.iOfferingLocks;
        synchronized (map) {
            if (this.iOfferingLocks.containsKey(offeringId)) {
                return;
            }
        }
        MultiLock.Unlock lock = this.iMultiLock.lock(offeringId);
        Map<Long, OnlineSectioningServer.Lock> map2 = this.iOfferingLocks;
        synchronized (map2) {
            if (this.iOfferingLocks.containsKey(offeringId)) {
                lock.release();
            } else {
                this.iOfferingLocks.put(offeringId, lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockOffering(Long offeringId) {
        Map<Long, OnlineSectioningServer.Lock> map = this.iOfferingLocks;
        synchronized (map) {
            OnlineSectioningServer.Lock lock = this.iOfferingLocks.remove(offeringId);
            if (lock != null) {
                lock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Long> getLockedOfferings() {
        Map<Long, OnlineSectioningServer.Lock> map = this.iOfferingLocks;
        synchronized (map) {
            return new ArrayList<Long>(this.iOfferingLocks.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseAllOfferingLocks() {
        Map<Long, OnlineSectioningServer.Lock> map = this.iOfferingLocks;
        synchronized (map) {
            for (OnlineSectioningServer.Lock lock : this.iOfferingLocks.values()) {
                lock.release();
            }
            this.iOfferingLocks.clear();
        }
    }
}

