/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.restlet.Client;
import org.restlet.Uniform;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.StudentEnrollmentProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.GsonRepresentation;
import org.unitime.timetable.onlinesectioning.custom.purdue.XEInterface;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XEStudentEnrollment
implements StudentEnrollmentProvider {
    private static Logger sLog = Logger.getLogger(XEStudentEnrollment.class);
    private static StudentSectioningMessages MESSAGES = Localization.create(StudentSectioningMessages.class);
    protected static Formats.Format<Number> sCreditFormat = Formats.getNumberFormat("0.##");
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;

    public XEStudentEnrollment() {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
    }

    protected String getBannerSite() {
        return ApplicationProperties.getProperty("banner.xe.site");
    }

    protected String getBannerUser(boolean admin) {
        String user;
        if (admin && (user = ApplicationProperties.getProperty("banner.xe.admin.user")) != null) {
            return user;
        }
        return ApplicationProperties.getProperty("banner.xe.user");
    }

    protected String getBannerPassword(boolean admin) {
        String pwd;
        if (admin && (pwd = ApplicationProperties.getProperty("banner.xe.admin.password")) != null) {
            return pwd;
        }
        return ApplicationProperties.getProperty("banner.xe.password");
    }

    protected String getBannerRecheck() {
        return ApplicationProperties.getProperty("banner.xe.recheck");
    }

    protected boolean isBannerAdmin() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.admin", "false"));
    }

    protected boolean isBannerWaitlist() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.waitlist", "false"));
    }

    protected float getMaxCredit(boolean admin) {
        String maxCredit;
        if (admin && (maxCredit = ApplicationProperties.getProperty("banner.xe.admin.maxCredit")) != null) {
            return Float.parseFloat(maxCredit);
        }
        return Float.parseFloat(ApplicationProperties.getProperty("banner.xe.maxCredit", "-1"));
    }

    protected boolean isCheckMaxHours(boolean admin) {
        String checkMaxHours;
        if (admin && (checkMaxHours = ApplicationProperties.getProperty("banner.xe.admin.checkMaxHours")) != null) {
            return "true".equalsIgnoreCase(checkMaxHours);
        }
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.checkMaxHours", "false"));
    }

    protected ConditionalDropType getConditionalAddDrop(boolean admin) {
        String conditionalAddDrop;
        if (admin && (conditionalAddDrop = ApplicationProperties.getProperty("banner.xe.admin.conditionalAddDrop")) != null) {
            return ConditionalDropType.parseType(conditionalAddDrop);
        }
        return ConditionalDropType.parseType(ApplicationProperties.getProperty("banner.xe.conditionalAddDrop"));
    }

    protected boolean throwExceptionWhenNoChange(boolean admin) {
        String conditionalAddDrop;
        if (admin && (conditionalAddDrop = ApplicationProperties.getProperty("banner.xe.admin.errorWhenNoChange")) != null) {
            return "true".equalsIgnoreCase(conditionalAddDrop);
        }
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.errorWhenNoChange", "false"));
    }

    protected float getMaxHoursDefault() {
        return Float.parseFloat(ApplicationProperties.getProperty("banner.xe.maxHoursDefault", "18"));
    }

    protected String getAdminParameter() {
        return ApplicationProperties.getProperty("banner.xe.adminParameter", "persona");
    }

    protected String getBannerId(XStudent student) {
        String id = student.getExternalId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected String getBannerTerm(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalTerm(session);
    }

    protected String getBannerCampus(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalCampus(session);
    }

    protected Gson getGson(OnlineSectioningHelper helper) {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

            public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
        }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new DateTime((Object)json.getAsJsonPrimitive().getAsString(), DateTimeZone.UTC);
            }
        });
        if (helper.isDebugEnabled()) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkEligibility(OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.EligibilityCheck check, XStudent student) throws SectioningException {
        ClientResource resource;
        block42: {
            if (!check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL) && student.getStudentId() != null) {
                return;
            }
            resource = null;
            try {
                block41: {
                    try {
                        String pin = helper.getPin();
                        AcademicSessionInfo session = server.getAcademicSession();
                        String term = this.getBannerTerm(session);
                        String campus = this.getBannerCampus(session);
                        boolean manager = helper.getUser().getType() == OnlineSectioningLog.Entity.EntityType.MANAGER;
                        boolean admin = manager & this.isBannerAdmin();
                        if (helper.isDebugEnabled()) {
                            helper.debug("Checking eligility for " + student.getName() + " (term: " + term + ", id:" + this.getBannerId(student) + (admin ? ", admin" : (pin != null ? ", pin:" + pin : "")) + ")");
                        }
                        resource = new ClientResource(this.getBannerSite());
                        resource.setNext((Uniform)this.iClient);
                        resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.getBannerUser(manager), this.getBannerPassword(manager));
                        Gson gson = this.getGson(helper);
                        XEInterface.RegisterResponse original = null;
                        resource.addQueryParameter("term", term);
                        resource.addQueryParameter("bannerId", this.getBannerId(student));
                        helper.getAction().addOptionBuilder().setKey("term").setValue(term);
                        helper.getAction().addOptionBuilder().setKey("bannerId").setValue(this.getBannerId(student));
                        if (admin) {
                            String param = this.getAdminParameter();
                            resource.addQueryParameter(param, "SB");
                            helper.getAction().addOptionBuilder().setKey(param).setValue("SB");
                        } else if (pin != null && !pin.isEmpty()) {
                            resource.addQueryParameter("altPin", pin);
                            helper.getAction().addOptionBuilder().setKey("pin").setValue(pin);
                        }
                        try {
                            resource.get(MediaType.APPLICATION_JSON);
                        }
                        catch (ResourceException exception) {
                            try {
                                XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                                helper.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                                XEInterface.Error error = response.getError();
                                if (error != null && error.message != null) {
                                    throw new SectioningException(error.message);
                                }
                                if (error != null && error.description != null) {
                                    throw new SectioningException(error.description);
                                }
                                if (error == null) throw exception;
                                if (error.errorMessage == null) throw exception;
                                throw new SectioningException(error.errorMessage);
                            }
                            catch (SectioningException e) {
                                throw e;
                            }
                            catch (Throwable t) {
                                throw exception;
                            }
                        }
                        List current = (List)new GsonRepresentation(resource.getResponseEntity(), XEInterface.RegisterResponse.TYPE_LIST).getObject();
                        helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)current));
                        if (current != null && !current.isEmpty()) {
                            original = (XEInterface.RegisterResponse)current.get(0);
                        }
                        if (original != null && helper.isDebugEnabled()) {
                            helper.debug("Current registration: " + gson.toJson((Object)original));
                        }
                        if (original == null || !original.validStudent.booleanValue()) {
                            String bannerRecheck = this.getBannerRecheck();
                            String reason = null;
                            boolean noreason = true;
                            boolean recheck = true;
                            if (original != null && original.failureReasons != null) {
                                for (String string : original.failureReasons) {
                                    if (bannerRecheck == null || !string.matches(bannerRecheck)) {
                                        recheck = false;
                                    }
                                    noreason = false;
                                    if ("Your PIN is invalid.".equals(string)) {
                                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.PIN_REQUIRED, true);
                                        if (pin == null || pin.isEmpty()) continue;
                                    }
                                    if (reason == null) {
                                        reason = string;
                                        continue;
                                    }
                                    reason = reason + "<br>" + string;
                                }
                            }
                            if (noreason) {
                                reason = "Failed to check student registration eligility.";
                                if (bannerRecheck == null || !reason.matches(bannerRecheck)) {
                                    recheck = false;
                                }
                            }
                            if (recheck) {
                                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.RECHECK_BEFORE_ENROLLMENT, true);
                            } else {
                                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, false);
                            }
                            check.setMessage(reason);
                            break block41;
                        }
                        if (student.getStudentId() == null) {
                            check.setMessage("UniTime enrollment data are not synchronized with Banner enrollment data, please try again later.");
                            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, false);
                            if (this.isCanRequestUpdates()) {
                                ArrayList<XStudent> students = new ArrayList<XStudent>(1);
                                students.add(student);
                                this.requestUpdate(server, helper, students);
                            }
                            break block41;
                        }
                        OnlineSectioningLog.Enrollment.Builder stored = OnlineSectioningLog.Enrollment.newBuilder();
                        stored.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
                        HashSet<String> sectionExternalIds = new HashSet<String>();
                        for (XRequest request : student.getRequests()) {
                            Object r;
                            XEnrollment xEnrollment;
                            helper.getAction().addRequest(OnlineSectioningHelper.toProto(request));
                            if (!(request instanceof XCourseRequest) || (xEnrollment = ((XCourseRequest)(r = (XCourseRequest)request)).getEnrollment()) == null) continue;
                            XOffering offering = server.getOffering(xEnrollment.getOfferingId());
                            for (XSection section : offering.getSections(xEnrollment)) {
                                stored.addSection(OnlineSectioningHelper.toProto(section, xEnrollment));
                                String extId = section.getExternalId(xEnrollment.getCourseId());
                                if (extId == null) continue;
                                sectionExternalIds.add(extId);
                            }
                        }
                        helper.getAction().addEnrollment(stored);
                        OnlineSectioningLog.Enrollment.Builder external = OnlineSectioningLog.Enrollment.newBuilder();
                        external.setType(OnlineSectioningLog.Enrollment.EnrollmentType.EXTERNAL);
                        String added = "";
                        if (original.registrations != null) {
                            for (XEInterface.Registration registration : original.registrations) {
                                if (!registration.isRegistered()) continue;
                                if (!sectionExternalIds.remove(registration.courseReferenceNumber) && campus.equals(registration.campus) && !this.eligibilityIgnoreBannerRegistration(server, helper, student, registration)) {
                                    added = added + (added.isEmpty() ? "" : ", ") + registration.courseReferenceNumber;
                                }
                                OnlineSectioningLog.Section.Builder section = external.addSectionBuilder().setClazz(OnlineSectioningLog.Entity.newBuilder().setName(registration.courseReferenceNumber)).setCourse(OnlineSectioningLog.Entity.newBuilder().setName(registration.subject + " " + registration.courseNumber)).setSubpart(OnlineSectioningLog.Entity.newBuilder().setName(registration.scheduleType));
                                if (registration.registrationStatusDate == null) continue;
                                section.setTimeStamp(registration.registrationStatusDate.getMillis());
                            }
                        }
                        helper.getAction().addEnrollment(external);
                        String removed = "";
                        for (String s : sectionExternalIds) {
                            removed = removed + (removed.isEmpty() ? "" : ", ") + s;
                        }
                        if (added.isEmpty() && removed.isEmpty()) break block41;
                        if (this.updateStudentRegistration(server, helper, student, original.registrations)) {
                            Object var26_43 = null;
                            if (resource == null) return;
                            break block42;
                        }
                        check.setMessage("UniTime enrollment data are not synchronized with Banner enrollment data, please try again later (" + (removed.isEmpty() ? "added " + added : (added.isEmpty() ? "dropped " + removed : "added " + added + ", dropped " + removed)) + ")");
                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, false);
                        if (!this.isCanRequestUpdates()) break block41;
                        ArrayList<XStudent> arrayList = new ArrayList<XStudent>(1);
                        arrayList.add(student);
                        this.requestUpdate(server, helper, arrayList);
                    }
                    catch (SectioningException e) {
                        helper.info("Banner eligibility failed: " + e.getMessage());
                        throw e;
                    }
                    catch (Exception e) {
                        helper.warn("Banner eligibility failed: " + e.getMessage(), e);
                        throw new SectioningException(e.getMessage());
                    }
                }
                Object var26_44 = null;
                if (resource == null) return;
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
                return;
            }
            catch (Throwable throwable) {
                Object var26_45 = null;
                if (resource == null) throw throwable;
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
                throw throwable;
            }
        }
        if (resource.getResponse() != null) {
            resource.getResponse().release();
        }
        resource.release();
    }

    protected boolean eligibilityIgnoreBannerRegistration(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, XEInterface.Registration reg) {
        return false;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<StudentEnrollmentProvider.EnrollmentFailure> enroll(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, List<StudentEnrollmentProvider.EnrollmentRequest> enrollments, Set<Long> lockedCourses) throws SectioningException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void dispose() {
        try {
            this.iClient.stop();
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isAllowWaitListing() {
        return this.isBannerAdmin() && this.isBannerWaitlist();
    }

    @Override
    public boolean requestUpdate(OnlineSectioningServer server, OnlineSectioningHelper helper, Collection<XStudent> students) throws SectioningException {
        return false;
    }

    protected boolean updateStudentRegistration(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, List<XEInterface.Registration> registration) throws SectioningException {
        return false;
    }

    @Override
    public boolean isCanRequestUpdates() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public XEnrollment resection(OnlineSectioningServer server, OnlineSectioningHelper helper, SectioningRequest sectioningRequest, XEnrollment enrollment) throws SectioningException {
        XEnrollment xEnrollment;
        ClientResource resource;
        block62: {
            XEnrollment xEnrollment2;
            block61: {
                Object i;
                block60: {
                    resource = null;
                    try {
                        try {
                            XEInterface.RegisterResponse original;
                            XStudent student = sectioningRequest.getStudent();
                            XCourseId course = sectioningRequest.getRequest().getCourseIdByOfferingId(sectioningRequest.getOffering().getOfferingId());
                            TreeSet<String> idsToAdd = new TreeSet<String>();
                            TreeSet<String> idsToDrop = new TreeSet<String>();
                            if (sectioningRequest.getLastEnrollment() != null) {
                                for (XSection section : sectioningRequest.getOldOffering().getSections(sectioningRequest.getLastEnrollment())) {
                                    idsToDrop.add(section.getExternalId(course.getCourseId()));
                                }
                            }
                            if (enrollment != null) {
                                for (XSection section : sectioningRequest.getOffering().getSections(enrollment)) {
                                    idsToAdd.add(section.getExternalId(course.getCourseId()));
                                }
                            }
                            i = idsToDrop.iterator();
                            while (i.hasNext()) {
                                if (!idsToAdd.remove(i.next())) continue;
                                i.remove();
                            }
                            if (idsToAdd.isEmpty() && idsToDrop.isEmpty()) {
                                i = enrollment;
                                Object var29_14 = null;
                                if (resource == null) return i;
                                break block60;
                            }
                            AcademicSessionInfo session = server.getAcademicSession();
                            String term = this.getBannerTerm(session);
                            if (helper.isDebugEnabled()) {
                                if (!idsToAdd.isEmpty()) {
                                    helper.debug("Enrolling " + student.getName() + " to " + course.getCourseName() + " (term: " + term + ", id:" + this.getBannerId(student) + (idsToDrop.isEmpty() ? "" : ", drop: " + idsToDrop) + ", add: " + idsToAdd + ")");
                                } else {
                                    helper.debug("Dropping " + student.getName() + " from " + course.getCourseName() + " (term: " + term + ", id:" + this.getBannerId(student) + ", drop: " + idsToDrop + ")");
                                }
                            }
                            resource = new ClientResource(this.getBannerSite());
                            resource.setNext((Uniform)this.iClient);
                            resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.getBannerUser(true), this.getBannerPassword(true));
                            resource.addQueryParameter("term", term);
                            resource.addQueryParameter("bannerId", this.getBannerId(student));
                            resource.addQueryParameter(this.getAdminParameter(), "SB");
                            sectioningRequest.getAction().addOptionBuilder().setKey("term").setValue(term);
                            sectioningRequest.getAction().addOptionBuilder().setKey("bannerId").setValue(this.getBannerId(student));
                            Gson gson = this.getGson(helper);
                            try {
                                resource.get(MediaType.APPLICATION_JSON);
                            }
                            catch (ResourceException exception) {
                                try {
                                    XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                                    sectioningRequest.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                                    XEInterface.Error error = response.getError();
                                    if (error != null && error.message != null) {
                                        throw new SectioningException(error.message);
                                    }
                                    if (error != null && error.description != null) {
                                        throw new SectioningException(error.description);
                                    }
                                    if (error == null) throw exception;
                                    if (error.errorMessage == null) throw exception;
                                    throw new SectioningException(error.errorMessage);
                                }
                                catch (SectioningException e) {
                                    throw e;
                                }
                                catch (Throwable t) {
                                    throw exception;
                                }
                            }
                            List current = (List)new GsonRepresentation(resource.getResponseEntity(), XEInterface.RegisterResponse.TYPE_LIST).getObject();
                            sectioningRequest.getAction().addOptionBuilder().setKey("original").setValue(gson.toJson((Object)current));
                            XEInterface.RegisterResponse registerResponse = original = current != null && !current.isEmpty() ? (XEInterface.RegisterResponse)current.get(0) : null;
                            if (original != null && helper.isDebugEnabled()) {
                                helper.debug("Current registration: " + gson.toJson((Object)original));
                            }
                            if (original == null || !original.validStudent.booleanValue()) {
                                String string;
                                String reason = null;
                                if (original != null && original.failureReasons != null) {
                                    for (String m : original.failureReasons) {
                                        if (reason == null) {
                                            reason = m;
                                            continue;
                                        }
                                        reason = reason + "\n" + m;
                                    }
                                }
                                if (reason == null) {
                                    string = "Failed to check student registration status.";
                                    throw new SectioningException(string);
                                }
                                string = reason;
                                throw new SectioningException(string);
                            }
                            XEInterface.RegisterRequest req = new XEInterface.RegisterRequest(term, this.getBannerId(student), null, true);
                            if (this.getConditionalAddDrop(true) != ConditionalDropType.NEVER) {
                                req.setConditionalAddDrop(true);
                            }
                            boolean changed = false;
                            HashMap<String, String> actions = new HashMap<String, String>();
                            if (original.registrations != null) {
                                for (XEInterface.Registration reg : original.registrations) {
                                    if (reg.isRegistered()) {
                                        if (idsToDrop.contains(reg.courseReferenceNumber)) {
                                            if (!reg.canDrop(true, actions)) {
                                                throw new SectioningException("Section " + reg.courseReferenceNumber + " is not available for student scheduling.");
                                            }
                                            req.drop(reg.courseReferenceNumber, actions);
                                            changed = true;
                                            continue;
                                        }
                                        req.keep(reg.courseReferenceNumber);
                                        continue;
                                    }
                                    if (!idsToAdd.remove(reg.courseReferenceNumber)) continue;
                                    if (!reg.canAdd(true)) {
                                        throw new SectioningException("Section " + reg.courseReferenceNumber + " is not available for student scheduling.");
                                    }
                                    req.add(reg.courseReferenceNumber, true);
                                }
                            }
                            for (String id : idsToAdd) {
                                req.add(id, false);
                                changed = true;
                            }
                            if (helper.isDebugEnabled()) {
                                helper.debug("Request: " + gson.toJson((Object)req));
                            }
                            sectioningRequest.getAction().addOptionBuilder().setKey("request").setValue(gson.toJson((Object)req));
                            if (req.isEmpty() || !changed) {
                                xEnrollment2 = enrollment;
                                break block61;
                            }
                            try {
                                resource.post(new GsonRepresentation<XEInterface.RegisterRequest>(req));
                            }
                            catch (ResourceException exception) {
                                try {
                                    XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                                    sectioningRequest.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                                    XEInterface.Error error = response.getError();
                                    if (error != null && error.message != null) {
                                        throw new SectioningException(error.message);
                                    }
                                    if (error != null && error.description != null) {
                                        throw new SectioningException(error.description);
                                    }
                                    if (error == null) throw exception;
                                    if (error.errorMessage == null) throw exception;
                                    throw new SectioningException(error.errorMessage);
                                }
                                catch (SectioningException e) {
                                    throw e;
                                }
                                catch (Throwable t) {
                                    throw exception;
                                }
                            }
                            XEInterface.RegisterResponse response = new GsonRepresentation<XEInterface.RegisterResponse>(resource.getResponseEntity(), XEInterface.RegisterResponse.class).getObject();
                            if (helper.isDebugEnabled()) {
                                helper.debug("Response: " + gson.toJson((Object)response));
                            }
                            sectioningRequest.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)response));
                            if (response == null || !response.validStudent.booleanValue()) {
                                String string;
                                String reason = null;
                                if (response != null && response.failureReasons != null) {
                                    for (String m : response.failureReasons) {
                                        if (reason == null) {
                                            reason = m;
                                            continue;
                                        }
                                        reason = reason + "\n" + m;
                                    }
                                }
                                if (reason == null) {
                                    string = "Failed to enroll student.";
                                    throw new SectioningException(string);
                                }
                                string = reason;
                                throw new SectioningException(string);
                            }
                            XEnrollment ret = new XEnrollment(enrollment == null ? sectioningRequest.getLastEnrollment() : enrollment);
                            ret.getSectionIds().clear();
                            TreeSet<String> registered = new TreeSet<String>();
                            if (response.registrations != null) {
                                OnlineSectioningLog.Enrollment.Builder external = OnlineSectioningLog.Enrollment.newBuilder();
                                external.setType(OnlineSectioningLog.Enrollment.EnrollmentType.EXTERNAL);
                                for (XEInterface.Registration reg : response.registrations) {
                                    String id = reg.courseReferenceNumber;
                                    List<XSection> sections = sectioningRequest.getOffering().getSections(course.getCourseId(), id);
                                    if (!sections.isEmpty() && "Registered".equals(reg.statusDescription)) {
                                        for (XSection section : sections) {
                                            ret.getSectionIds().add(section.getSectionId());
                                        }
                                        registered.add(id);
                                    }
                                    if (!"Registered".equals(reg.statusDescription)) continue;
                                    external.addSectionBuilder().setClazz(OnlineSectioningLog.Entity.newBuilder().setName(reg.courseReferenceNumber)).setCourse(OnlineSectioningLog.Entity.newBuilder().setName(reg.subject + " " + reg.courseNumber)).setSubpart(OnlineSectioningLog.Entity.newBuilder().setName(reg.scheduleType));
                                }
                                sectioningRequest.getAction().addEnrollment(external);
                            }
                            if (helper.isDebugEnabled()) {
                                helper.debug("Return: " + registered);
                            }
                            xEnrollment = ret.getSectionIds().isEmpty() ? null : ret;
                            break block62;
                        }
                        catch (SectioningException e) {
                            helper.info("Banner enrollment failed: " + e.getMessage());
                            throw e;
                        }
                        catch (Exception e) {
                            helper.warn("Banner enrollment failed: " + e.getMessage(), e);
                            throw new SectioningException(e.getMessage());
                        }
                    }
                    catch (Throwable throwable) {
                        Object var29_17 = null;
                        if (resource == null) throw throwable;
                        if (resource.getResponse() != null) {
                            resource.getResponse().release();
                        }
                        resource.release();
                        throw throwable;
                    }
                }
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
                return i;
            }
            Object var29_15 = null;
            if (resource == null) return xEnrollment2;
            if (resource.getResponse() != null) {
                resource.getResponse().release();
            }
            resource.release();
            return xEnrollment2;
        }
        Object var29_16 = null;
        if (resource == null) return xEnrollment;
        if (resource.getResponse() != null) {
            resource.getResponse().release();
        }
        resource.release();
        return xEnrollment;
    }

    static class 3 {
        static final /* synthetic */ int[] $SwitchMap$org$unitime$timetable$onlinesectioning$custom$purdue$XEStudentEnrollment$ConditionalDropType;

        static {
            $SwitchMap$org$unitime$timetable$onlinesectioning$custom$purdue$XEStudentEnrollment$ConditionalDropType = new int[ConditionalDropType.values().length];
            try {
                3.$SwitchMap$org$unitime$timetable$onlinesectioning$custom$purdue$XEStudentEnrollment$ConditionalDropType[ConditionalDropType.ALWAYS.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$unitime$timetable$onlinesectioning$custom$purdue$XEStudentEnrollment$ConditionalDropType[ConditionalDropType.HAS_DROP.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$unitime$timetable$onlinesectioning$custom$purdue$XEStudentEnrollment$ConditionalDropType[ConditionalDropType.IS_REGISTERED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConditionalDropType {
        NEVER,
        HAS_DROP,
        IS_REGISTERED,
        RESECTION,
        ALWAYS;


        public static ConditionalDropType parseType(String value) {
            if (value == null) {
                return NEVER;
            }
            try {
                return ConditionalDropType.valueOf(value);
            }
            catch (Exception e) {
                return "true".equalsIgnoreCase(value) ? HAS_DROP : NEVER;
            }
        }
    }
}

