/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListCourseOfferings
implements OnlineSectioningAction<Collection<ClassAssignmentInterface.CourseAssignment>> {
    private static final long serialVersionUID = 1L;
    protected String iQuery = null;
    protected Integer iLimit = null;
    protected CourseMatcher iMatcher = null;

    public ListCourseOfferings forQuery(String query) {
        this.iQuery = query;
        return this;
    }

    public ListCourseOfferings withLimit(Integer limit) {
        this.iLimit = limit;
        return this;
    }

    public ListCourseOfferings withMatcher(CourseMatcher matcher) {
        this.iMatcher = matcher;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ClassAssignmentInterface.CourseAssignment> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        OnlineSectioningServer.Lock lock = server.readLock();
        try {
            List<ClassAssignmentInterface.CourseAssignment> list = this.listCourses(server, helper);
            Object var6_5 = null;
            lock.release();
            return list;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.release();
            throw throwable;
        }
    }

    protected List<ClassAssignmentInterface.CourseAssignment> listCourses(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        ArrayList<ClassAssignmentInterface.CourseAssignment> ret = new ArrayList<ClassAssignmentInterface.CourseAssignment>();
        for (XCourseId xCourseId : server.findCourses(this.iQuery, this.iLimit, this.iMatcher)) {
            XCourse course = server.getCourse(xCourseId.getCourseId());
            if (course == null) continue;
            ret.add(this.convert(course, server));
        }
        return ret;
    }

    protected ClassAssignmentInterface.CourseAssignment convert(XCourse c, OnlineSectioningServer server) {
        ClassAssignmentInterface.CourseAssignment course = new ClassAssignmentInterface.CourseAssignment();
        course.setCourseId(c.getCourseId());
        course.setSubject(c.getSubjectArea());
        course.setCourseNbr(c.getCourseNumber());
        course.setTitle(c.getTitle());
        course.setNote(c.getNote());
        course.setCreditAbbv(c.getCreditAbbv());
        course.setCreditText(c.getCreditText());
        course.setTitle(c.getTitle());
        course.setHasUniqueName(c.hasUniqueName());
        course.setLimit(c.getLimit());
        Collection<XCourseRequest> requests = server.getRequests(c.getOfferingId());
        int enrl = 0;
        if (requests != null) {
            for (XCourseRequest r : requests) {
                if (r.getEnrollment() == null || !r.getEnrollment().getCourseId().equals(course.getCourseId())) continue;
                ++enrl;
            }
        }
        course.setEnrollment(enrl);
        return course;
    }

    @Override
    public String name() {
        return "list-courses";
    }
}

