/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.CacheMode;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.OnlineSectioningLog;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.dao.OnlineSectioningLogDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;

public class OnlineSectioningLogger
extends Thread {
    private static Log sLog = LogFactory.getLog(OnlineSectioningLogger.class);
    private List<OnlineSectioningLog.Action> iActions = new Vector<OnlineSectioningLog.Action>();
    private boolean iActive = false;
    private boolean iEnabled = false;
    private int iLogLimit = -1;
    private PrintWriter iOut = null;
    private static OnlineSectioningLogger sInstance = null;

    public static OnlineSectioningLogger getInstance() {
        if (sInstance == null) {
            OnlineSectioningLogger.startLogger();
        }
        return sInstance;
    }

    public static void startLogger() {
        if (sInstance == null) {
            sInstance = new OnlineSectioningLogger();
            sInstance.start();
        }
    }

    public static void stopLogger() {
        if (sInstance != null) {
            OnlineSectioningLogger.sInstance.iActive = false;
            sInstance.interrupt();
            try {
                sInstance.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            sInstance = null;
        }
    }

    private OnlineSectioningLogger() {
        super("OnlineSectioningLogger");
        this.setDaemon(true);
        this.iEnabled = ApplicationProperty.OnlineSchedulingLoggingEnabled.isTrue();
        this.iLogLimit = ApplicationProperty.OnlineSchedulingLogLimit.intValue();
        try {
            if (ApplicationProperty.OnlineSchedulingLogFile.value() != null) {
                this.iOut = new PrintWriter(new FileWriter(new File(ApplicationProperty.OnlineSchedulingLogFile.value()), true));
            }
        }
        catch (IOException e) {
            sLog.warn((Object)("Unable to create sectioning log: " + e.getMessage()), (Throwable)e);
        }
    }

    public boolean isEnabled() {
        return this.iEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.iEnabled = enabled;
    }

    public boolean isActive() {
        return this.iActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(OnlineSectioningLog.Log log) {
        if (log == null || !this.isEnabled() || !this.isActive()) {
            return;
        }
        for (OnlineSectioningLog.Action action : log.getActionList()) {
            if (!action.hasStartTime() || !action.hasStudent() || !action.hasOperation() || !action.hasSession()) continue;
            Object object = this.iActions;
            synchronized (object) {
                if (this.iLogLimit <= 0 || this.iActions.size() < this.iLogLimit) {
                    this.iActions.add(action);
                }
            }
            if (this.iOut == null) continue;
            object = this.iOut;
            synchronized (object) {
                this.iOut.print(OnlineSectioningLog.Log.newBuilder().addAction(action).build().toString());
                this.iOut.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        sLog.info((Object)"Online Sectioning Logger is up.");
        try {
            try {
                this.iActive = true;
                do {
                    try {
                        OnlineSectioningLogger.sleep(60000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    ArrayList<OnlineSectioningLog.Action> actionsToSave = null;
                    List<OnlineSectioningLog.Action> list = this.iActions;
                    synchronized (list) {
                        if (!this.iActions.isEmpty()) {
                            actionsToSave = new ArrayList<OnlineSectioningLog.Action>(this.iActions);
                            this.iActions.clear();
                        }
                    }
                    try {
                        Object var11_14;
                        if (actionsToSave == null) continue;
                        sLog.debug((Object)("Persisting " + actionsToSave.size() + " actions..."));
                        if (this.iLogLimit > 0 && actionsToSave.size() >= this.iLogLimit) {
                            sLog.warn((Object)("The limit of " + this.iLogLimit + " unpersisted log messages was reached, some messages have been dropped."));
                        }
                        org.hibernate.Session hibSession = OnlineSectioningLogDAO.getInstance().createNewSession();
                        hibSession.setCacheMode(CacheMode.IGNORE);
                        try {
                            Hashtable<Long, Session> sessions = new Hashtable<Long, Session>();
                            for (OnlineSectioningLog.Action q : actionsToSave) {
                                Long sessionId;
                                Session session;
                                String studentExternalId;
                                OnlineSectioningLog log = new OnlineSectioningLog();
                                log.setAction(q.toByteArray());
                                log.setOperation(q.getOperation());
                                String string = studentExternalId = q.getStudent().hasExternalId() ? q.getStudent().getExternalId() : null;
                                if (studentExternalId == null || studentExternalId.isEmpty()) {
                                    Student student = (Student)StudentDAO.getInstance().get(q.getStudent().getUniqueId(), hibSession);
                                    if (student == null) continue;
                                    studentExternalId = student.getExternalUniqueId();
                                }
                                log.setStudent(studentExternalId);
                                log.setTimeStamp(new Date(q.getStartTime()));
                                if (q.hasResult()) {
                                    log.setResult(q.getResult().getNumber());
                                }
                                if (q.hasUser() && q.getUser().hasExternalId()) {
                                    log.setUser(q.getUser().getExternalId());
                                }
                                if ((session = (Session)sessions.get(sessionId = Long.valueOf(q.getSession().getUniqueId()))) == null) {
                                    session = (Session)SessionDAO.getInstance().get(sessionId, hibSession);
                                    sessions.put(sessionId, session);
                                }
                                log.setSession(session);
                                hibSession.save((Object)log);
                            }
                            hibSession.flush();
                            var11_14 = null;
                        }
                        catch (Throwable throwable) {
                            var11_14 = null;
                            hibSession.close();
                            throw throwable;
                        }
                        hibSession.close();
                        {
                        }
                    }
                    catch (Throwable t) {
                        sLog.warn((Object)("Failed to save " + actionsToSave.size() + " log actions: " + t.getMessage()), t);
                    }
                } while (this.iActive);
                Object var13_16 = null;
                this.iActive = false;
                if (this.iOut != null) {
                    this.iOut.flush();
                    this.iOut.close();
                }
            }
            catch (Throwable t) {
                sLog.error((Object)("Online Sectioning Logger failed: " + t.getMessage()), t);
                Object var13_17 = null;
                this.iActive = false;
                if (this.iOut != null) {
                    this.iOut.flush();
                    this.iOut.close();
                }
            }
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            this.iActive = false;
            if (this.iOut != null) {
                this.iOut.flush();
                this.iOut.close();
            }
            throw throwable;
        }
        sLog.info((Object)"Online Sectioning Logger is down.");
    }
}

