/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.TimetableManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSolverGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iName;
    private String iAbbv;
    private Session iSession;
    private Set<TimetableManager> iTimetableManagers;
    private Set<Department> iDepartments;
    private Set<Solution> iSolutions;
    public static String PROP_UNIQUEID = "uniqueId";
    public static String PROP_NAME = "name";
    public static String PROP_ABBV = "abbv";

    public BaseSolverGroup() {
        this.initialize();
    }

    public BaseSolverGroup(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    protected void initialize() {
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getAbbv() {
        return this.iAbbv;
    }

    public void setAbbv(String abbv) {
        this.iAbbv = abbv;
    }

    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    public Set<TimetableManager> getTimetableManagers() {
        return this.iTimetableManagers;
    }

    public void setTimetableManagers(Set<TimetableManager> timetableManagers) {
        this.iTimetableManagers = timetableManagers;
    }

    public void addTotimetableManagers(TimetableManager timetableManager) {
        if (this.iTimetableManagers == null) {
            this.iTimetableManagers = new HashSet<TimetableManager>();
        }
        this.iTimetableManagers.add(timetableManager);
    }

    public Set<Department> getDepartments() {
        return this.iDepartments;
    }

    public void setDepartments(Set<Department> departments) {
        this.iDepartments = departments;
    }

    public void addTodepartments(Department department) {
        if (this.iDepartments == null) {
            this.iDepartments = new HashSet<Department>();
        }
        this.iDepartments.add(department);
    }

    public Set<Solution> getSolutions() {
        return this.iSolutions;
    }

    public void setSolutions(Set<Solution> solutions) {
        this.iSolutions = solutions;
    }

    public void addTosolutions(Solution solution) {
        if (this.iSolutions == null) {
            this.iSolutions = new HashSet<Solution>();
        }
        this.iSolutions.add(solution);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SolverGroup)) {
            return false;
        }
        if (this.getUniqueId() == null || ((SolverGroup)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((SolverGroup)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "SolverGroup[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "SolverGroup[\n\tAbbv: " + this.getAbbv() + "\n\tName: " + this.getName() + "\n\tSession: " + this.getSession() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

