/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.unitime.commons.Debug;
import org.unitime.timetable.model.base.BaseUserData;
import org.unitime.timetable.model.dao.UserDataDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserData
extends BaseUserData {
    private static final long serialVersionUID = 1L;

    public UserData() {
    }

    public UserData(String externalUniqueId, String name) {
        this.setExternalUniqueId(externalUniqueId);
        this.setName(name);
        this.initialize();
    }

    public static void setProperty(String externalUniqueId, String name, String value) {
        try {
            UserDataDAO dao = new UserDataDAO();
            UserData userData = (UserData)dao.get(new UserData(externalUniqueId, name));
            if (value != null && value.length() == 0) {
                value = null;
            }
            if (userData == null && value == null) {
                return;
            }
            if (userData != null && value != null && value.equals(userData.getValue())) {
                return;
            }
            if (userData == null) {
                userData = new UserData(externalUniqueId, name);
            }
            userData.setValue(value);
            if (value == null) {
                dao.delete(userData);
            } else {
                dao.saveOrUpdate(userData);
            }
        }
        catch (Exception e) {
            Debug.warning("Failed to set user property " + name + ":=" + value + " (" + e.getMessage() + ")");
        }
    }

    public static String getProperty(String externalUniqueId, String name) {
        UserDataDAO dao = new UserDataDAO();
        UserData userData = (UserData)dao.get(new UserData(externalUniqueId, name));
        return userData == null ? null : userData.getValue();
    }

    public static String getProperty(String externalUniqueId, String name, String defaultValue) {
        String value = UserData.getProperty(externalUniqueId, name);
        return value != null ? value : defaultValue;
    }

    public static void removeProperty(String externalUniqueId, String name) {
        UserData.setProperty(externalUniqueId, name, null);
    }

    public static HashMap<String, String> getProperties(String externalUniqueId, Collection<String> names) {
        String q = "select u from UserData u where u.externalUniqueId = :externalUniqueId and u.name in (";
        Iterator<String> i = names.iterator();
        while (i.hasNext()) {
            q = q + "'" + i.next() + "'";
            if (!i.hasNext()) continue;
            q = q + ",";
        }
        q = q + ")";
        HashMap<String, String> ret = new HashMap<String, String>();
        for (UserData u : UserDataDAO.getInstance().getSession().createQuery(q).setString("externalUniqueId", externalUniqueId).setCacheable(true).list()) {
            ret.put(u.getName(), u.getValue());
        }
        return ret;
    }

    public static HashMap<String, String> getProperties(String externalUniqueId) {
        String q = "select u from UserData u where u.externalUniqueId = :externalUniqueId";
        HashMap<String, String> ret = new HashMap<String, String>();
        for (UserData u : UserDataDAO.getInstance().getSession().createQuery(q).setString("externalUniqueId", externalUniqueId).setCacheable(true).list()) {
            ret.put(u.getName(), u.getValue());
        }
        return ret;
    }

    public static boolean getPropertyBoolean(String externalUniqueId, String name, boolean defaultValue) {
        String value = UserData.getProperty(externalUniqueId, name);
        return value != null ? "1".equals(value) : defaultValue;
    }
}

