/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusFilterBox;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.server.UniTimePrincipal;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.DegreePlanInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.AcademicAreaClassification;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseClass_;
import org.unitime.timetable.model.base.BaseCourseDemand;
import org.unitime.timetable.model.base.BaseCourseRequest;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.CurriculumDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.model.dao.StudentSectioningStatusDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.CheckCourses;
import org.unitime.timetable.onlinesectioning.basic.CheckEligibility;
import org.unitime.timetable.onlinesectioning.basic.GetAssignment;
import org.unitime.timetable.onlinesectioning.basic.GetDegreePlans;
import org.unitime.timetable.onlinesectioning.basic.GetRequest;
import org.unitime.timetable.onlinesectioning.basic.ListClasses;
import org.unitime.timetable.onlinesectioning.basic.ListCourseOfferings;
import org.unitime.timetable.onlinesectioning.basic.ListEnrollments;
import org.unitime.timetable.onlinesectioning.custom.CourseDetailsProvider;
import org.unitime.timetable.onlinesectioning.custom.CourseMatcherProvider;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseRequestsHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomDegreePlansHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;
import org.unitime.timetable.onlinesectioning.custom.DefaultCourseDetailsProvider;
import org.unitime.timetable.onlinesectioning.custom.RequestStudentUpdates;
import org.unitime.timetable.onlinesectioning.match.AbstractCourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.onlinesectioning.solver.ComputeSuggestionsAction;
import org.unitime.timetable.onlinesectioning.solver.FindAssignmentAction;
import org.unitime.timetable.onlinesectioning.status.FindEnrollmentAction;
import org.unitime.timetable.onlinesectioning.status.FindEnrollmentInfoAction;
import org.unitime.timetable.onlinesectioning.status.FindOnlineSectioningLogAction;
import org.unitime.timetable.onlinesectioning.status.FindStudentInfoAction;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;
import org.unitime.timetable.onlinesectioning.status.db.DbFindEnrollmentAction;
import org.unitime.timetable.onlinesectioning.status.db.DbFindEnrollmentInfoAction;
import org.unitime.timetable.onlinesectioning.status.db.DbFindStudentInfoAction;
import org.unitime.timetable.onlinesectioning.updates.ApproveEnrollmentsAction;
import org.unitime.timetable.onlinesectioning.updates.ChangeStudentStatus;
import org.unitime.timetable.onlinesectioning.updates.EnrollStudent;
import org.unitime.timetable.onlinesectioning.updates.MassCancelAction;
import org.unitime.timetable.onlinesectioning.updates.RejectEnrollmentsAction;
import org.unitime.timetable.onlinesectioning.updates.SaveStudentRequests;
import org.unitime.timetable.onlinesectioning.updates.StudentEmail;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.context.AnonymousUserContext;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.service.ProxyHolder;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.studentsct.BatchEnrollStudent;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;
import org.unitime.timetable.util.LoginManager;
import org.unitime.timetable.util.NameFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="sectioning.gwt")
public class SectioningServlet
implements SectioningService,
DisposableBean {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    private static Logger sLog = Logger.getLogger(SectioningServlet.class);
    private CourseDetailsProvider iCourseDetailsProvider;
    private CourseMatcherProvider iCourseMatcherProvider;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private SessionContext sessionContext;
    @Autowired
    private SolverService<StudentSolverProxy> studentSectioningSolverService;
    @Autowired
    private SolverServerService solverServerService;

    private CourseDetailsProvider getCourseDetailsProvider() {
        if (this.iCourseDetailsProvider == null) {
            try {
                String providerClass = ApplicationProperty.CustomizationCourseDetails.value();
                if (providerClass != null) {
                    this.iCourseDetailsProvider = (CourseDetailsProvider)Class.forName(providerClass).newInstance();
                }
            }
            catch (Exception e) {
                sLog.warn((Object)("Failed to initialize course detail provider: " + e.getMessage()));
                this.iCourseDetailsProvider = new DefaultCourseDetailsProvider();
            }
        }
        return this.iCourseDetailsProvider;
    }

    private CourseMatcherProvider getCourseMatcherProvider() {
        if (this.iCourseMatcherProvider == null) {
            try {
                String providerClass = ApplicationProperty.CustomizationCourseMatcher.value();
                if (providerClass != null) {
                    this.iCourseMatcherProvider = (CourseMatcherProvider)Class.forName(providerClass).newInstance();
                }
            }
            catch (Exception e) {
                sLog.warn((Object)("Failed to initialize course matcher provider: " + e.getMessage()));
            }
        }
        return this.iCourseMatcherProvider;
    }

    private AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    private SessionContext getSessionContext() {
        return this.sessionContext;
    }

    private StudentSolverProxy getStudentSolver() {
        return this.studentSectioningSolverService.getSolver();
    }

    private OnlineSectioningServer getServerInstance(Long academicSessionId, boolean canReturnDummy) {
        if (academicSessionId == null) {
            return null;
        }
        OnlineSectioningServer server = this.solverServerService.getOnlineStudentSchedulingContainer().getSolver(academicSessionId.toString());
        if (server != null || !canReturnDummy) {
            return server;
        }
        ProxyHolder h = (ProxyHolder)this.sessionContext.getAttribute("OnlineSectioning.DummyServer");
        if (h != null && h.isValid(academicSessionId)) {
            return (OnlineSectioningServer)h.getProxy();
        }
        Session session = (Session)SessionDAO.getInstance().get(academicSessionId);
        if (session == null) {
            throw new SectioningException(MSG.exceptionBadSession());
        }
        server = new DatabaseServer(new AcademicSessionInfo(session), false);
        this.sessionContext.setAttribute("OnlineSectioning.DummyServer", new ProxyHolder<Long, OnlineSectioningServer>(academicSessionId, server));
        return server;
    }

    @Override
    public Collection<ClassAssignmentInterface.CourseAssignment> listCourseOfferings(Long sessionId, String query, Integer limit) throws SectioningException, PageAccessException {
        if (sessionId == null) {
            throw new SectioningException(MSG.exceptionNoAcademicSession());
        }
        this.setLastSessionId(sessionId);
        CourseMatcher matcher = this.getCourseMatcher(sessionId);
        OnlineSectioningServer server = this.getServerInstance(sessionId, false);
        if (server == null) {
            String types = "";
            for (String ref : matcher.getAllowedCourseTypes()) {
                types = types + (types.isEmpty() ? "" : ", ") + "'" + ref + "'";
            }
            if (!matcher.isAllCourseTypes() && !matcher.isNoCourseType() && types.isEmpty()) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(query));
            }
            ArrayList<ClassAssignmentInterface.CourseAssignment> results = new ArrayList<ClassAssignmentInterface.CourseAssignment>();
            org.hibernate.Session hibSession = CurriculumDAO.getInstance().getSession();
            org.unitime.timetable.onlinesectioning.match.CourseMatcher parent = matcher.getParentCourseMatcher();
            for (CourseOffering c : hibSession.createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId and c.subjectArea.department.allowStudentScheduling = true and ((lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) like :q || '%' or lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr || ' - ' || c.title) like :q || '%') " + (query.length() > 2 ? "or lower(c.title) like '%' || :q || '%'" : "") + ") " + (matcher.isAllCourseTypes() ? "" : (matcher.isNoCourseType() ? (types.isEmpty() ? " and c.courseType is null " : " and (c.courseType is null or c.courseType.reference in (" + types + ")) ") : " and c.courseType.reference in (" + types + ") ")) + "order by case " + "when lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) like :q || '%' then 0 else 1 end," + "c.subjectArea.subjectAreaAbbreviation, c.courseNbr").setString("q", query.toLowerCase()).setLong("sessionId", sessionId.longValue()).setCacheable(true).setMaxResults(limit == null || limit <= 0 || parent != null ? Integer.MAX_VALUE : limit).list()) {
                if (parent != null && !parent.match(new XCourseId(c))) continue;
                ClassAssignmentInterface.CourseAssignment course = new ClassAssignmentInterface.CourseAssignment();
                course.setCourseId(c.getUniqueId());
                course.setSubject(c.getSubjectAreaAbbv());
                course.setCourseNbr(c.getCourseNbr());
                course.setTitle(c.getTitle());
                course.setNote(c.getScheduleBookNote());
                if (c.getCredit() != null) {
                    course.setCreditText(c.getCredit().creditText());
                    course.setCreditAbbv(c.getCredit().creditAbbv());
                }
                course.setTitle(c.getTitle());
                course.setHasUniqueName(true);
                boolean unlimited = false;
                int courseLimit = 0;
                for (InstrOfferingConfig cfg : c.getInstructionalOffering().getInstrOfferingConfigs()) {
                    if (cfg.isUnlimitedEnrollment().booleanValue()) {
                        unlimited = true;
                    }
                    if (cfg.getLimit() == null) continue;
                    courseLimit += cfg.getLimit().intValue();
                }
                if (c.getReservation() != null) {
                    courseLimit = c.getReservation();
                }
                if (courseLimit >= 9999) {
                    unlimited = true;
                }
                course.setLimit(unlimited ? -1 : courseLimit);
                course.setProjected(c.getProjectedDemand());
                course.setEnrollment(c.getEnrollment());
                course.setLastLike(c.getDemand());
                results.add(course);
                if (parent == null || limit == null || limit <= 0 || results.size() < limit) continue;
                break;
            }
            if (results.isEmpty()) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(query));
            }
            return results;
        }
        Collection<ClassAssignmentInterface.CourseAssignment> results = null;
        try {
            results = server.execute(server.createAction(ListCourseOfferings.class).forQuery(query).withLimit(limit).withMatcher(matcher), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
        if (results == null || results.isEmpty()) {
            throw new SectioningException(MSG.exceptionCourseDoesNotExist(query));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CourseMatcher getCourseMatcher(Long sessionId) {
        CourseMatcherProvider provider;
        boolean noCourseType = true;
        boolean allCourseTypes = false;
        HashSet<String> allowedCourseTypes = new HashSet<String>();
        Long studentId = this.getStudentId(sessionId);
        if (this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisor)) {
            allCourseTypes = true;
        } else {
            org.hibernate.Session hibSession = SessionDAO.getInstance().createNewSession();
            try {
                StudentSectioningStatus status;
                Student student = studentId == null ? null : (Student)StudentDAO.getInstance().get(studentId, hibSession);
                StudentSectioningStatus studentSectioningStatus = status = student == null ? null : student.getSectioningStatus();
                if (status == null) {
                    status = ((Session)SessionDAO.getInstance().get(sessionId, hibSession)).getDefaultSectioningStatus();
                }
                if (status != null) {
                    for (CourseType type : status.getTypes()) {
                        allowedCourseTypes.add(type.getReference());
                    }
                    noCourseType = !status.hasOption(StudentSectioningStatus.Option.notype);
                }
                Object var12_11 = null;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            {
            }
        }
        CourseMatcher matcher = new CourseMatcher(allCourseTypes, noCourseType, allowedCourseTypes);
        if (studentId != null && (provider = this.getCourseMatcherProvider()) != null) {
            matcher.setParentCourseMatcher(provider.getCourseMatcher(this.getSessionContext(), studentId));
        }
        return matcher;
    }

    @Override
    public Collection<ClassAssignmentInterface.ClassAssignment> listClasses(Long sessionId, String course) throws SectioningException, PageAccessException {
        if (sessionId == null) {
            throw new SectioningException(MSG.exceptionNoAcademicSession());
        }
        this.setLastSessionId(sessionId);
        OnlineSectioningServer server = this.getServerInstance(sessionId, false);
        if (server == null) {
            ArrayList<ClassAssignmentInterface.ClassAssignment> results = new ArrayList<ClassAssignmentInterface.ClassAssignment>();
            org.hibernate.Session hibSession = CurriculumDAO.getInstance().getSession();
            CourseOffering courseOffering = null;
            Iterator iterator = hibSession.createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId and c.subjectArea.department.allowStudentScheduling = true and (lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) = :course or lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr || ' - ' || c.title) = :course)").setString("course", course.toLowerCase()).setLong("sessionId", sessionId.longValue()).setCacheable(true).setMaxResults(1).list().iterator();
            if (iterator.hasNext()) {
                CourseOffering c;
                courseOffering = c = (CourseOffering)iterator.next();
            }
            if (courseOffering == null) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(course));
            }
            ArrayList<Class_> classes = new ArrayList<Class_>();
            for (InstrOfferingConfig config : courseOffering.getInstructionalOffering().getInstrOfferingConfigs()) {
                for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                    classes.addAll(subpart.getClasses());
                }
            }
            Collections.sort(classes, new ClassComparator(5));
            NameFormat nameFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingInstructorNameFormat.value());
            for (Class_ clazz : classes) {
                int maxLimit;
                if (!clazz.isEnabledForStudentScheduling().booleanValue()) continue;
                ClassAssignmentInterface.ClassAssignment a = new ClassAssignmentInterface.ClassAssignment();
                a.setClassId(clazz.getUniqueId());
                a.setSubpart(clazz.getSchedulingSubpart().getItypeDesc());
                a.setSection(clazz.getClassSuffix(courseOffering));
                a.setClassNumber(clazz.getSectionNumberString(hibSession));
                a.addNote(clazz.getSchedulePrintNote());
                Assignment ass = clazz.getCommittedAssignment();
                Placement p = ass == null ? null : ass.getPlacement();
                int minLimit = clazz.getExpectedCapacity();
                int limit = maxLimit = clazz.getMaxExpectedCapacity().intValue();
                if (minLimit < maxLimit && p != null) {
                    int roomLimit = (int)Math.floor((float)p.getRoomSize() / (clazz.getRoomRatio() == null ? 1.0f : clazz.getRoomRatio().floatValue()));
                    limit = Math.min(Math.max(minLimit, roomLimit), maxLimit);
                }
                if (clazz.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue() || limit >= 9999) {
                    limit = -1;
                }
                a.setCancelled(clazz.isCancelled());
                a.setLimit(new int[]{clazz.getEnrollment() == 0 ? -1 : clazz.getEnrollment(), limit});
                if (p != null && p.getTimeLocation() != null) {
                    for (DayCode d : DayCode.toDayCodes(p.getTimeLocation().getDayCode())) {
                        a.addDay(d.getIndex());
                    }
                    a.setStart(p.getTimeLocation().getStartSlot());
                    a.setLength(p.getTimeLocation().getLength());
                    a.setBreakTime(p.getTimeLocation().getBreakTime());
                    a.setDatePattern(p.getTimeLocation().getDatePatternName());
                }
                if (p != null && p.getRoomLocations() != null) {
                    for (RoomLocation rm : p.getRoomLocations()) {
                        a.addRoom(rm.getId(), rm.getName());
                    }
                }
                if (p != null && p.getRoomLocation() != null) {
                    a.addRoom(p.getRoomLocation().getId(), p.getRoomLocation().getName());
                }
                if (!clazz.getClassInstructors().isEmpty()) {
                    for (ClassInstructor instr : clazz.getClassInstructors()) {
                        a.addInstructor(nameFormat.format(instr.getInstructor()));
                        a.addInstructoEmail(instr.getInstructor().getEmail());
                    }
                }
                if (clazz.getParentClass() != null) {
                    a.setParentSection(clazz.getParentClass().getClassSuffix(courseOffering));
                }
                a.setSubpartId(clazz.getSchedulingSubpart().getUniqueId());
                if (a.getParentSection() == null) {
                    a.setParentSection(courseOffering.getConsentType() == null ? null : courseOffering.getConsentType().getLabel());
                }
                results.add(a);
            }
            return results;
        }
        try {
            return server.execute(server.createAction(ListClasses.class).forCourseAndStudent(course, this.getStudentId(sessionId)), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public Collection<AcademicSessionProvider.AcademicSessionInfo> listAcademicSessions(boolean sectioning) throws SectioningException, PageAccessException {
        ArrayList<AcademicSessionProvider.AcademicSessionInfo> ret = new ArrayList<AcademicSessionProvider.AcademicSessionInfo>();
        if (sectioning) {
            for (String s : this.solverServerService.getOnlineStudentSchedulingContainer().getSolvers()) {
                OnlineSectioningServer server = this.solverServerService.getOnlineStudentSchedulingContainer().getSolver(s);
                if (server == null || !server.isReady()) continue;
                Session session = (Session)SessionDAO.getInstance().get(Long.valueOf(s));
                ret.add(new AcademicSessionProvider.AcademicSessionInfo(session.getUniqueId(), session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative(), MSG.sessionName(session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative())));
            }
        } else {
            for (Session session : SessionDAO.getInstance().findAll()) {
                if (session.getStatusType().isTestSession() || !session.getStatusType().canPreRegisterStudents() || session.getStatusType().canSectionAssistStudents() || session.getStatusType().canOnlineSectionStudents()) continue;
                ret.add(new AcademicSessionProvider.AcademicSessionInfo(session.getUniqueId(), session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative(), MSG.sessionName(session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative())));
            }
        }
        if (ret.isEmpty()) {
            throw new SectioningException(MSG.exceptionNoSuitableAcademicSessions());
        }
        return ret;
    }

    @Override
    public String retrieveCourseDetails(Long sessionId, String course) throws SectioningException, PageAccessException {
        this.setLastSessionId(sessionId);
        OnlineSectioningServer server = this.getServerInstance(sessionId, false);
        if (server == null) {
            CourseOffering courseOffering = SectioningServlet.lookupCourse(CourseOfferingDAO.getInstance().getSession(), sessionId, null, course, null);
            if (courseOffering == null) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(course));
            }
            return this.getCourseDetailsProvider().getDetails(new AcademicSessionInfo(courseOffering.getSubjectArea().getSession()), courseOffering.getSubjectAreaAbbv(), courseOffering.getCourseNbr());
        }
        XCourseId c = server.getCourse(course);
        if (c == null) {
            throw new SectioningException(MSG.exceptionCourseDoesNotExist(course));
        }
        return server.getCourseDetails(c.getCourseId(), this.getCourseDetailsProvider());
    }

    @Override
    public Long retrieveCourseOfferingId(Long sessionId, String course) throws SectioningException, PageAccessException {
        this.setLastSessionId(sessionId);
        OnlineSectioningServer server = this.getServerInstance(sessionId, false);
        if (server == null) {
            CourseOffering courseOffering = SectioningServlet.lookupCourse(CourseOfferingDAO.getInstance().getSession(), sessionId, null, course, null);
            if (courseOffering == null) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(course));
            }
            return courseOffering.getUniqueId();
        }
        XCourseId c = server.getCourse(course);
        if (c == null) {
            throw new SectioningException(MSG.exceptionCourseDoesNotExist(course));
        }
        return c.getCourseId();
    }

    @Override
    public ClassAssignmentInterface section(boolean online, CourseRequestInterface request, ArrayList<ClassAssignmentInterface.ClassAssignment> currentAssignment) throws SectioningException, PageAccessException {
        try {
            if (!online) {
                StudentSolverProxy server = this.getStudentSolver();
                if (server == null) {
                    throw new SectioningException(MSG.exceptionNoSolver());
                }
                request.setStudentId(this.getStudentId(request.getAcademicSessionId()));
                ClassAssignmentInterface ret = server.execute(server.createAction(FindAssignmentAction.class).forRequest(request).withAssignment(currentAssignment), this.currentUser()).get(0);
                if (ret != null) {
                    ret.setCanEnroll(this.getStudentId(request.getAcademicSessionId()) != null);
                }
                return ret;
            }
            this.setLastSessionId(request.getAcademicSessionId());
            this.setLastRequest(request);
            request.setStudentId(this.getStudentId(request.getAcademicSessionId()));
            OnlineSectioningServer server = this.getServerInstance(request.getAcademicSessionId(), true);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            ClassAssignmentInterface ret = server.execute(server.createAction(FindAssignmentAction.class).forRequest(request).withAssignment(currentAssignment), this.currentUser()).get(0);
            if (ret != null) {
                ret.setCanEnroll(server.getAcademicSession().isSectioningEnabled());
                if (ret.isCanEnroll() && this.getStudentId(request.getAcademicSessionId()) == null) {
                    ret.setCanEnroll(false);
                }
            }
            return ret;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionSectioningFailed(e.getMessage()), e);
        }
    }

    @Override
    public Collection<String> checkCourses(boolean online, CourseRequestInterface request) throws SectioningException, PageAccessException {
        try {
            if (request.getAcademicSessionId() == null) {
                throw new SectioningException(MSG.exceptionNoAcademicSession());
            }
            if (request.getStudentId() == null) {
                request.setStudentId(this.getStudentId(request.getAcademicSessionId()));
            }
            if (!online) {
                StudentSolverProxy server = this.getStudentSolver();
                if (server == null) {
                    throw new SectioningException(MSG.exceptionNoSolver());
                }
                return server.execute(server.createAction(CheckCourses.class).forRequest(request), this.currentUser());
            }
            this.setLastSessionId(request.getAcademicSessionId());
            this.setLastRequest(request);
            OnlineSectioningServer server = this.getServerInstance(request.getAcademicSessionId(), false);
            if (server == null) {
                org.hibernate.Session hibSession = CurriculumDAO.getInstance().getSession();
                ArrayList<String> notFound = new ArrayList<String>();
                CourseMatcher matcher = this.getCourseMatcher(request.getAcademicSessionId());
                Long studentId = this.getStudentId(request.getAcademicSessionId());
                for (CourseRequestInterface.Request cr : request.getCourses()) {
                    if (!cr.hasRequestedFreeTime() && cr.hasRequestedCourse() && SectioningServlet.lookupCourse(hibSession, request.getAcademicSessionId(), studentId, cr.getRequestedCourse(), matcher) == null) {
                        notFound.add(cr.getRequestedCourse());
                    }
                    if (cr.hasFirstAlternative() && SectioningServlet.lookupCourse(hibSession, request.getAcademicSessionId(), studentId, cr.getFirstAlternative(), matcher) == null) {
                        notFound.add(cr.getFirstAlternative());
                    }
                    if (!cr.hasSecondAlternative() || SectioningServlet.lookupCourse(hibSession, request.getAcademicSessionId(), studentId, cr.getSecondAlternative(), matcher) != null) continue;
                    notFound.add(cr.getSecondAlternative());
                }
                for (CourseRequestInterface.Request cr : request.getAlternatives()) {
                    if (cr.hasRequestedCourse() && SectioningServlet.lookupCourse(hibSession, request.getAcademicSessionId(), studentId, cr.getRequestedCourse(), matcher) == null) {
                        notFound.add(cr.getRequestedCourse());
                    }
                    if (cr.hasFirstAlternative() && SectioningServlet.lookupCourse(hibSession, request.getAcademicSessionId(), studentId, cr.getFirstAlternative(), matcher) == null) {
                        notFound.add(cr.getFirstAlternative());
                    }
                    if (!cr.hasSecondAlternative() || SectioningServlet.lookupCourse(hibSession, request.getAcademicSessionId(), studentId, cr.getSecondAlternative(), matcher) != null) continue;
                    notFound.add(cr.getSecondAlternative());
                }
                return notFound;
            }
            return server.execute(server.createAction(CheckCourses.class).forRequest(request).withMatcher(this.getCourseMatcher(request.getAcademicSessionId())), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionSectioningFailed(e.getMessage()), e);
        }
    }

    public static CourseOffering lookupCourse(org.hibernate.Session hibSession, Long sessionId, Long studentId, String courseName, CourseMatcher courseMatcher) {
        Iterator iterator;
        if (studentId != null && (iterator = hibSession.createQuery("select cr.courseOffering from CourseRequest cr where cr.courseDemand.student.uniqueId = :studentId and (lower(cr.courseOffering.subjectArea.subjectAreaAbbreviation || ' ' || cr.courseOffering.courseNbr) = :course or lower(cr.courseOffering.subjectArea.subjectAreaAbbreviation || ' ' || cr.courseOffering.courseNbr || ' - ' || cr.courseOffering.title) = :course)").setString("course", courseName.toLowerCase()).setLong("studentId", studentId.longValue()).setCacheable(true).setMaxResults(1).list().iterator()).hasNext()) {
            CourseOffering co = (CourseOffering)iterator.next();
            return co;
        }
        for (CourseOffering co : hibSession.createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId and c.subjectArea.department.allowStudentScheduling = true and (lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) = :course or lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr || ' - ' || c.title) = :course)").setString("course", courseName.toLowerCase()).setLong("sessionId", sessionId.longValue()).setCacheable(true).setMaxResults(1).list()) {
            if (courseMatcher != null && !courseMatcher.match(new XCourse(co))) continue;
            return co;
        }
        return null;
    }

    @Override
    public Collection<ClassAssignmentInterface> computeSuggestions(boolean online, CourseRequestInterface request, Collection<ClassAssignmentInterface.ClassAssignment> currentAssignment, int selectedAssignmentIndex, String filter) throws SectioningException, PageAccessException {
        try {
            if (!online) {
                StudentSolverProxy server = this.getStudentSolver();
                if (server == null) {
                    throw new SectioningException(MSG.exceptionNoSolver());
                }
                request.setStudentId(this.getStudentId(request.getAcademicSessionId()));
                ClassAssignmentInterface.ClassAssignment selectedAssignment = null;
                if (selectedAssignmentIndex >= 0) {
                    selectedAssignment = (ClassAssignmentInterface.ClassAssignment)((List)currentAssignment).get(selectedAssignmentIndex);
                } else {
                    XCourseId course = server.getCourse(request.getLastCourse());
                    if (course == null) {
                        throw new SectioningException(MSG.exceptionCourseDoesNotExist(request.getLastCourse()));
                    }
                    selectedAssignment = new ClassAssignmentInterface.ClassAssignment();
                    selectedAssignment.setCourseId(course.getCourseId());
                }
                Collection ret = server.execute(((ComputeSuggestionsAction)server.createAction(ComputeSuggestionsAction.class).forRequest(request).withAssignment((Collection)currentAssignment)).withSelection(selectedAssignment).withFilter(filter), this.currentUser());
                if (ret != null) {
                    boolean canEnroll = this.getStudentId(request.getAcademicSessionId()) != null;
                    for (ClassAssignmentInterface ca : ret) {
                        ca.setCanEnroll(canEnroll);
                    }
                }
                return ret;
            }
            this.setLastSessionId(request.getAcademicSessionId());
            if (selectedAssignmentIndex >= 0) {
                this.setLastRequest(request);
            }
            request.setStudentId(this.getStudentId(request.getAcademicSessionId()));
            OnlineSectioningServer server = this.getServerInstance(request.getAcademicSessionId(), true);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            ClassAssignmentInterface.ClassAssignment selectedAssignment = null;
            if (selectedAssignmentIndex >= 0) {
                selectedAssignment = (ClassAssignmentInterface.ClassAssignment)((List)currentAssignment).get(selectedAssignmentIndex);
            } else {
                XCourseId course = server.getCourse(request.getLastCourse());
                if (course == null) {
                    throw new SectioningException(MSG.exceptionCourseDoesNotExist(request.getLastCourse()));
                }
                selectedAssignment = new ClassAssignmentInterface.ClassAssignment();
                selectedAssignment.setCourseId(course.getCourseId());
            }
            Collection ret = server.execute(((ComputeSuggestionsAction)server.createAction(ComputeSuggestionsAction.class).forRequest(request).withAssignment((Collection)currentAssignment)).withSelection(selectedAssignment).withFilter(filter), this.currentUser());
            if (ret != null) {
                boolean canEnroll = server.getAcademicSession().isSectioningEnabled();
                if (canEnroll && this.getStudentId(request.getAcademicSessionId()) == null) {
                    canEnroll = false;
                }
                for (ClassAssignmentInterface ca : ret) {
                    ca.setCanEnroll(canEnroll);
                }
            }
            return ret;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionSectioningFailed(e.getMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String logIn(String userName, String password, String pin) throws SectioningException, PageAccessException {
        if (pin != null && !pin.isEmpty()) {
            this.getSessionContext().setAttribute("pin", (Object)pin);
        } else {
            this.getSessionContext().removeAttribute("pin");
        }
        if ("LOOKUP".equals(userName)) {
            org.hibernate.Session hibSession;
            block16: {
                String string;
                this.getSessionContext().checkPermission(Right.StudentSchedulingAdvisor);
                hibSession = StudentDAO.getInstance().createNewSession();
                try {
                    List student = hibSession.createQuery("select m from Student m where m.externalUniqueId = :uid").setString("uid", password).list();
                    if (student.isEmpty()) break block16;
                    UserContext user = this.getSessionContext().getUser();
                    UniTimePrincipal principal = new UniTimePrincipal(user.getTrueExternalUserId(), password, user.getTrueName());
                    for (Student s : student) {
                        principal.addStudentId(s.getSession().getUniqueId(), s.getUniqueId());
                        principal.setName(NameFormat.defaultFormat().format(s));
                    }
                    this.getSessionContext().setAttribute("user", (Object)principal);
                    this.getSessionContext().removeAttribute("request");
                    string = principal.getName();
                    Object var11_19 = null;
                }
                catch (Throwable throwable) {
                    Object var11_21 = null;
                    hibSession.close();
                    throw throwable;
                }
                hibSession.close();
                return string;
            }
            Object var11_20 = null;
            hibSession.close();
            {
            }
        }
        if ("BATCH".equals(userName)) {
            String string;
            this.getSessionContext().checkPermission(Right.StudentSectioningSolver);
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            org.hibernate.Session hibSession = StudentDAO.getInstance().createNewSession();
            try {
                Student student = (Student)StudentDAO.getInstance().get(Long.valueOf(password), hibSession);
                if (student == null) {
                    throw new SectioningException(MSG.exceptionLoginFailed());
                }
                UserContext user = this.getSessionContext().getUser();
                UniTimePrincipal uniTimePrincipal = new UniTimePrincipal(user.getTrueExternalUserId(), student.getExternalUniqueId(), user.getTrueName());
                uniTimePrincipal.addStudentId(student.getSession().getUniqueId(), student.getUniqueId());
                uniTimePrincipal.setName(NameFormat.defaultFormat().format(student));
                this.getSessionContext().setAttribute("user", (Object)uniTimePrincipal);
                this.getSessionContext().removeAttribute("request");
                string = uniTimePrincipal.getName();
                Object var13_23 = null;
            }
            catch (Throwable throwable) {
                Object var13_24 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            return string;
        }
        try {
            UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)userName, (Object)password);
            Authentication authResult = this.getAuthenticationManager().authenticate((Authentication)authRequest);
            SecurityContextHolder.getContext().setAuthentication(authResult);
            UserContext user = (UserContext)authResult.getPrincipal();
            if (user.getCurrentAuthority() == null) {
                for (UserAuthority userAuthority : user.getAuthorities("Student", new Qualifiable[0])) {
                    if (this.getLastSessionId() != null && !userAuthority.getAcademicSession().getQualifierId().equals(this.getLastSessionId())) continue;
                    user.setCurrentAuthority(userAuthority);
                    break;
                }
            }
            LoginManager.loginSuceeded(authResult.getName());
            return user.getName() == null ? user.getUsername() : user.getName();
        }
        catch (Exception e) {
            LoginManager.addFailedLoginAttempt(userName, new Date());
            throw new PageAccessException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean logOut() throws SectioningException, PageAccessException {
        this.getSessionContext().removeAttribute("user");
        this.getSessionContext().removeAttribute("pin");
        this.getSessionContext().removeAttribute("sessionId");
        this.getSessionContext().removeAttribute("request");
        this.getSessionContext().removeAttribute("eligibility");
        if (this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisor)) {
            return false;
        }
        SecurityContextHolder.getContext().setAuthentication(null);
        return true;
    }

    @Override
    public String whoAmI() throws SectioningException, PageAccessException {
        UniTimePrincipal principal = (UniTimePrincipal)this.getSessionContext().getAttribute("user");
        if (principal != null) {
            return principal.getName();
        }
        UserContext user = this.getSessionContext().getUser();
        if (user == null || user instanceof AnonymousUserContext) {
            return null;
        }
        return user.getName() == null ? user.getUsername() : user.getName();
    }

    public Long getStudentId(Long sessionId) {
        UniTimePrincipal principal = (UniTimePrincipal)this.getSessionContext().getAttribute("user");
        if (principal != null) {
            return principal.getStudentId(sessionId);
        }
        UserContext user = this.getSessionContext().getUser();
        if (user == null) {
            return null;
        }
        Iterator<? extends UserAuthority> iterator = user.getAuthorities("Student", new SimpleQualifier("Session", sessionId)).iterator();
        if (iterator.hasNext()) {
            UserAuthority a = iterator.next();
            return a.getUniqueId();
        }
        return null;
    }

    public Long getLastSessionId() {
        Long sessionId;
        UserContext user;
        Long lastSessionId = (Long)this.getSessionContext().getAttribute("sessionId");
        if (lastSessionId == null && (user = this.getSessionContext().getUser()) != null && (sessionId = user.getCurrentAcademicSessionId()) != null) {
            lastSessionId = sessionId;
        }
        return lastSessionId;
    }

    public void setLastSessionId(Long sessionId) {
        this.getSessionContext().setAttribute("sessionId", (Object)sessionId);
    }

    public CourseRequestInterface getLastRequest() {
        return (CourseRequestInterface)this.getSessionContext().getAttribute("request");
    }

    public void setLastRequest(CourseRequestInterface request) {
        if (request == null || request.getAcademicSessionId() == null) {
            this.getSessionContext().removeAttribute("request");
        } else if (request.isUpdateLastRequest()) {
            this.getSessionContext().setAttribute("request", (Object)request);
        }
    }

    @Override
    public AcademicSessionProvider.AcademicSessionInfo lastAcademicSession(boolean sectioning) throws SectioningException, PageAccessException {
        if (this.getSessionContext().isHttpSessionNew()) {
            throw new PageAccessException(MSG.exceptionUserNotLoggedIn());
        }
        Long sessionId = this.getLastSessionId();
        if (sessionId == null) {
            throw new SectioningException(MSG.exceptionNoAcademicSession());
        }
        if (sectioning) {
            OnlineSectioningServer server = this.getServerInstance(sessionId, false);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            AcademicSessionInfo s = server.getAcademicSession();
            if (s == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            return new AcademicSessionProvider.AcademicSessionInfo(s.getUniqueId(), s.getYear(), s.getTerm(), s.getCampus(), MSG.sessionName(s.getYear(), s.getTerm(), s.getCampus()));
        }
        Session session = (Session)SessionDAO.getInstance().get(sessionId);
        if (session == null || session.getStatusType().isTestSession()) {
            throw new SectioningException(MSG.exceptionNoSuitableAcademicSessions());
        }
        if (!session.getStatusType().canPreRegisterStudents() || session.getStatusType().canSectionAssistStudents() || session.getStatusType().canOnlineSectionStudents()) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        return new AcademicSessionProvider.AcademicSessionInfo(session.getUniqueId(), session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative(), MSG.sessionName(session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative()));
    }

    @Override
    public CourseRequestInterface lastRequest(boolean online, Long sessionId) throws SectioningException, PageAccessException {
        Long studentId;
        CourseRequestInterface request = this.getLastRequest();
        if (request != null && !request.getAcademicSessionId().equals(sessionId)) {
            request = null;
        }
        if (request != null && request.getCourses().isEmpty() && request.getAlternatives().isEmpty()) {
            request = null;
        }
        if (request == null && (request = this.savedRequest(online, sessionId, studentId = this.getStudentId(sessionId))) == null && studentId == null) {
            throw new SectioningException(MSG.exceptionNoStudent());
        }
        if (request == null) {
            throw new SectioningException(MSG.exceptionBadStudentId());
        }
        if (!request.getAcademicSessionId().equals(sessionId)) {
            throw new SectioningException(MSG.exceptionBadSession());
        }
        if (request.getCourses().isEmpty() && request.getAlternatives().isEmpty()) {
            throw new SectioningException(MSG.exceptionNoRequests());
        }
        return request;
    }

    @Override
    public ClassAssignmentInterface lastResult(boolean online, Long sessionId) throws SectioningException, PageAccessException {
        Long studentId = this.getStudentId(sessionId);
        if (studentId == null) {
            throw new SectioningException(MSG.exceptionNoStudent());
        }
        if (!online) {
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            ClassAssignmentInterface ret = server.execute(server.createAction(GetAssignment.class).forStudent(studentId), this.currentUser());
            if (ret != null) {
                ret.setCanEnroll(this.getStudentId(sessionId) != null);
            }
            return ret;
        }
        try {
            OnlineSectioningServer server = this.getServerInstance(sessionId, false);
            if (server == null) {
                throw new SectioningException(MSG.exceptionBadSession());
            }
            ClassAssignmentInterface ret = server.execute(server.createAction(GetAssignment.class).forStudent(studentId), this.currentUser());
            if (ret == null) {
                throw new SectioningException(MSG.exceptionBadStudentId());
            }
            ret.setCanEnroll(server.getAcademicSession().isSectioningEnabled());
            if (ret.isCanEnroll() && this.getStudentId(sessionId) == null) {
                ret.setCanEnroll(false);
            }
            if (!ret.getCourseAssignments().isEmpty()) {
                return ret;
            }
            throw new SectioningException(MSG.exceptionNoSchedule());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean saveRequest(CourseRequestInterface request) throws SectioningException, PageAccessException {
        Boolean bl;
        Long studentId;
        OnlineSectioningServer server = this.getServerInstance(request.getAcademicSessionId(), false);
        if (server != null) {
            if (server.getAcademicSession().isSectioningEnabled()) {
                return false;
            }
            if (ApplicationProperty.OnlineSchedulingSaveRequests.isFalse()) {
                return false;
            }
        }
        if ((studentId = this.getStudentId(request.getAcademicSessionId())) == null && this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisor)) {
            studentId = request.getStudentId();
        }
        if (server != null) {
            if (studentId == null) {
                throw new SectioningException(MSG.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
            }
            server.execute(server.createAction(SaveStudentRequests.class).forStudent(studentId).withRequest(request), this.currentUser());
            return true;
        }
        if (studentId == null) {
            throw new SectioningException(MSG.exceptionEnrollNotStudent(((Session)SessionDAO.getInstance().get(request.getAcademicSessionId())).getLabel()));
        }
        org.hibernate.Session hibSession = StudentDAO.getInstance().getSession();
        try {
            try {
                Student student = (Student)StudentDAO.getInstance().get(studentId, hibSession);
                if (student == null) {
                    throw new SectioningException(MSG.exceptionBadStudentId());
                }
                SaveStudentRequests.saveRequest(null, new OnlineSectioningHelper(hibSession, this.currentUser()), student, request, true);
                hibSession.save((Object)student);
                hibSession.flush();
                bl = true;
                Object var8_10 = null;
            }
            catch (PageAccessException e) {
                throw e;
            }
            catch (SectioningException e) {
                throw e;
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            hibSession.close();
            throw throwable;
        }
        hibSession.close();
        return bl;
    }

    @Override
    public ClassAssignmentInterface enroll(boolean online, CourseRequestInterface request, ArrayList<ClassAssignmentInterface.ClassAssignment> currentAssignment) throws SectioningException, PageAccessException {
        Long sessionId;
        if (request.getStudentId() == null) {
            sessionId = request.getAcademicSessionId();
            if (sessionId == null) {
                sessionId = this.getLastSessionId();
            }
            if (sessionId != null) {
                request.setStudentId(this.getStudentId(sessionId));
            }
        }
        sessionId = this.canEnroll(online, request.getAcademicSessionId(), request.getStudentId());
        if (!request.getAcademicSessionId().equals(sessionId)) {
            throw new SectioningException(MSG.exceptionBadSession());
        }
        if (!online) {
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            return server.execute(server.createAction(BatchEnrollStudent.class).forStudent(request.getStudentId()).withRequest(request).withAssignment(currentAssignment), this.currentUser());
        }
        OnlineSectioningServer server = this.getServerInstance(request.getAcademicSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionBadStudentId());
        }
        if (!server.getAcademicSession().isSectioningEnabled()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        this.setLastSessionId(request.getAcademicSessionId());
        this.setLastRequest(request);
        return server.execute(server.createAction(EnrollStudent.class).forStudent(request.getStudentId()).withRequest(request).withAssignment(currentAssignment), this.currentUser());
    }

    @Override
    public List<Long> canApprove(Long classOrOfferingId) throws SectioningException, PageAccessException {
        try {
            OnlineSectioningServer server;
            InstructionalOffering offering;
            UserContext user = this.getSessionContext().getUser();
            if (user == null) {
                throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired());
            }
            org.hibernate.Session hibSession = SessionDAO.getInstance().getSession();
            InstructionalOffering instructionalOffering = offering = classOrOfferingId >= 0L ? (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(classOrOfferingId, hibSession) : null;
            if (offering == null) {
                BaseClass_ clazz;
                BaseClass_ baseClass_ = clazz = classOrOfferingId < 0L ? (Class_)Class_DAO.getInstance().get(-classOrOfferingId.longValue(), hibSession) : null;
                if (clazz == null) {
                    throw new SectioningException(MSG.exceptionBadClassOrOffering());
                }
                offering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering();
            }
            if ((server = this.getServerInstance(offering.getControllingCourseOffering().getSubjectArea().getSessionId(), false)) == null) {
                return null;
            }
            ArrayList<Long> coursesToApprove = new ArrayList<Long>();
            for (CourseOffering course : offering.getCourseOfferings()) {
                if (!this.getSessionContext().hasPermissionAnyAuthority((Object)course, Right.ConsentApproval, new Qualifiable[0])) continue;
                coursesToApprove.add(course.getUniqueId());
            }
            return coursesToApprove;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ClassAssignmentInterface.Enrollment> listEnrollments(Long classOrOfferingId) throws SectioningException, PageAccessException {
        Iterator iterator;
        Hashtable<Long, ClassAssignmentInterface.Enrollment> student2enrollment;
        org.hibernate.Session hibSession;
        block43: {
            BaseCourseRequest alt;
            Comparable first;
            Object c;
            ClassAssignmentInterface.Student st;
            ClassAssignmentInterface.Enrollment e;
            boolean canUseAssistant;
            boolean canRegister;
            boolean canShowExtIds;
            Hashtable<String, String> approvedBy2name;
            NameFormat nameFormat;
            block42: {
                try {
                    List<ClassAssignmentInterface.Enrollment> list;
                    UserContext user = this.getSessionContext().getUser();
                    if (user == null) {
                        String string;
                        if (this.getSessionContext().isHttpSessionNew()) {
                            string = MSG.exceptionHttpSessionExpired();
                            throw new PageAccessException(string);
                        }
                        string = MSG.exceptionLoginRequired();
                        throw new PageAccessException(string);
                    }
                    hibSession = SessionDAO.getInstance().getSession();
                    try {
                        Class_ clazz;
                        InstructionalOffering offering = classOrOfferingId >= 0L ? (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(classOrOfferingId, hibSession) : null;
                        Class_ class_ = clazz = classOrOfferingId < 0L ? (Class_)Class_DAO.getInstance().get(-classOrOfferingId.longValue(), hibSession) : null;
                        if (offering == null && clazz == null) {
                            throw new SectioningException(MSG.exceptionBadClassOrOffering());
                        }
                        if (offering == null) {
                            offering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering();
                        }
                        Long offeringId = offering.getUniqueId();
                        this.getSessionContext().checkPermission(offering, Right.OfferingEnrollments);
                        OnlineSectioningServer server = this.getServerInstance(offering.getControllingCourseOffering().getSubjectArea().getSessionId(), false);
                        if (server == null || !offering.isAllowStudentScheduling()) {
                            nameFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingStudentNameFormat.value());
                            approvedBy2name = new Hashtable<String, String>();
                            student2enrollment = new Hashtable<Long, ClassAssignmentInterface.Enrollment>();
                            canShowExtIds = this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId);
                            canRegister = this.sessionContext.hasPermission(Right.CourseRequests);
                            canUseAssistant = this.sessionContext.hasPermission(Right.SchedulingAssistant);
                            iterator = hibSession.createQuery(clazz == null ? "from StudentClassEnrollment e where e.courseOffering.instructionalOffering.uniqueId = :offeringId" : "select e from StudentClassEnrollment e where e.courseOffering.instructionalOffering.uniqueId = :offeringId and e.student.uniqueId in (select f.student.uniqueId from StudentClassEnrollment f where f.clazz.uniqueId = " + clazz.getUniqueId() + ")").setLong("offeringId", offeringId.longValue()).list().iterator();
                            break block42;
                        }
                        list = server.execute(server.createAction(ListEnrollments.class).forOffering(offeringId).withSection(clazz == null ? null : clazz.getUniqueId()).canShowExternalIds(this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId)).canRegister(this.sessionContext.hasPermission(Right.CourseRequests)).canUseAssistant(this.sessionContext.hasPermission(Right.SchedulingAssistant)), this.currentUser());
                    }
                    catch (Throwable throwable) {
                        Object var25_45 = null;
                        hibSession.close();
                        throw throwable;
                    }
                    Object var25_44 = null;
                    hibSession.close();
                    return list;
                }
                catch (PageAccessException e2) {
                    throw e2;
                }
                catch (SectioningException e3) {
                    throw e3;
                }
                catch (Exception e4) {
                    sLog.error((Object)e4.getMessage(), (Throwable)e4);
                    throw new SectioningException(MSG.exceptionUnknown(e4.getMessage()), e4);
                }
            }
            while (true) {
                StudentClassEnrollment enrollment;
                block45: {
                    block47: {
                        Iterator<Comparable> iterator2;
                        block48: {
                            block44: {
                                block46: {
                                    if (!iterator.hasNext()) break block44;
                                    enrollment = (StudentClassEnrollment)iterator.next();
                                    e = (ClassAssignmentInterface.Enrollment)student2enrollment.get(enrollment.getStudent().getUniqueId());
                                    if (e != null) break block45;
                                    st = new ClassAssignmentInterface.Student();
                                    st.setId(enrollment.getStudent().getUniqueId());
                                    st.setSessionId(enrollment.getStudent().getSession().getUniqueId());
                                    st.setExternalId(enrollment.getStudent().getExternalUniqueId());
                                    st.setCanShowExternalId(canShowExtIds);
                                    st.setCanRegister(canRegister);
                                    st.setCanUseAssistant(canUseAssistant);
                                    st.setName(nameFormat.format(enrollment.getStudent()));
                                    for (AcademicAreaClassification ac : enrollment.getStudent().getAcademicAreaClassifications()) {
                                        st.addArea(ac.getAcademicArea().getAcademicAreaAbbreviation());
                                        st.addClassification(ac.getAcademicClassification().getCode());
                                    }
                                    for (PosMajor m : enrollment.getStudent().getPosMajors()) {
                                        st.addMajor(m.getCode());
                                    }
                                    for (StudentGroup g : enrollment.getStudent().getGroups()) {
                                        st.addGroup(g.getGroupAbbreviation());
                                    }
                                    for (StudentAccomodation a : enrollment.getStudent().getAccomodations()) {
                                        st.addAccommodation(a.getAbbreviation());
                                    }
                                    e = new ClassAssignmentInterface.Enrollment();
                                    e.setStudent(st);
                                    e.setEnrolledDate(enrollment.getTimestamp());
                                    c = new ClassAssignmentInterface.CourseAssignment();
                                    ((ClassAssignmentInterface.CourseAssignment)c).setCourseId(enrollment.getCourseOffering().getUniqueId());
                                    ((ClassAssignmentInterface.CourseAssignment)c).setSubject(enrollment.getCourseOffering().getSubjectAreaAbbv());
                                    ((ClassAssignmentInterface.CourseAssignment)c).setCourseNbr(enrollment.getCourseOffering().getCourseNbr());
                                    ((ClassAssignmentInterface.CourseAssignment)c).setTitle(enrollment.getCourseOffering().getTitle());
                                    e.setCourse((ClassAssignmentInterface.CourseAssignment)c);
                                    student2enrollment.put(enrollment.getStudent().getUniqueId(), e);
                                    if (enrollment.getCourseRequest() == null) break block46;
                                    e.setPriority(1 + enrollment.getCourseRequest().getCourseDemand().getPriority());
                                    if (enrollment.getCourseRequest().getCourseDemand().getCourseRequests().size() > 1) {
                                        first = null;
                                        for (CourseRequest courseRequest : enrollment.getCourseRequest().getCourseDemand().getCourseRequests()) {
                                            if (first != null && courseRequest.getOrder().compareTo(((BaseCourseRequest)((Object)first)).getOrder()) >= 0) continue;
                                            first = courseRequest;
                                        }
                                        if (!((BaseCourseRequest)((Object)first)).equals(enrollment.getCourseRequest())) {
                                            e.setAlternative(((BaseCourseRequest)((Object)first)).getCourseOffering().getCourseName());
                                        }
                                    }
                                    if (!enrollment.getCourseRequest().getCourseDemand().isAlternative().booleanValue()) break block47;
                                    first = enrollment.getCourseRequest().getCourseDemand();
                                    iterator2 = enrollment.getStudent().getCourseDemands().iterator();
                                    break block48;
                                }
                                e.setPriority(-1);
                                break block45;
                            }
                            if (classOrOfferingId >= 0L) {
                                iterator = hibSession.createQuery("from CourseRequest r where r.courseOffering.instructionalOffering.uniqueId = :offeringId").setLong("offeringId", classOrOfferingId.longValue()).list().iterator();
                                break;
                            }
                            break block43;
                        }
                        block12: while (iterator2.hasNext()) {
                            CourseDemand courseDemand = (CourseDemand)iterator2.next();
                            if (courseDemand.isAlternative().booleanValue() || courseDemand.getPriority().compareTo(((BaseCourseDemand)((Object)first)).getPriority()) >= 0 || courseDemand.getCourseRequests().isEmpty()) continue;
                            for (CourseRequest cr : courseDemand.getCourseRequests()) {
                                if (!cr.getClassEnrollments().isEmpty()) continue;
                                continue block12;
                            }
                            first = courseDemand;
                        }
                        alt = null;
                        for (CourseRequest courseRequest : ((BaseCourseDemand)((Object)first)).getCourseRequests()) {
                            if (alt != null && courseRequest.getOrder().compareTo(alt.getOrder()) >= 0) continue;
                            alt = courseRequest;
                        }
                        e.setAlternative(alt.getCourseOffering().getCourseName());
                    }
                    e.setRequestedDate(enrollment.getCourseRequest().getCourseDemand().getTimestamp());
                    e.setApprovedDate(enrollment.getApprovedDate());
                    if (enrollment.getApprovedBy() != null) {
                        String name = (String)approvedBy2name.get(enrollment.getApprovedBy());
                        if (name == null) {
                            TimetableManager mgr = (TimetableManager)hibSession.createQuery("from TimetableManager where externalUniqueId = :externalId").setString("externalId", enrollment.getApprovedBy()).setMaxResults(1).uniqueResult();
                            if (mgr != null) {
                                name = mgr.getName();
                            } else {
                                DepartmentalInstructor departmentalInstructor = (DepartmentalInstructor)hibSession.createQuery("from DepartmentalInstructor where externalUniqueId = :externalId and department.session.uniqueId = :sessionId").setString("externalId", enrollment.getApprovedBy()).setLong("sessionId", enrollment.getStudent().getSession().getUniqueId().longValue()).setMaxResults(1).uniqueResult();
                                if (departmentalInstructor != null) {
                                    name = departmentalInstructor.nameLastNameFirst();
                                }
                            }
                            if (name != null) {
                                approvedBy2name.put(enrollment.getApprovedBy(), name);
                            }
                        }
                        e.setApprovedBy(name == null ? enrollment.getApprovedBy() : name);
                    }
                    e.setWaitList(enrollment.getCourseRequest().getCourseDemand().isWaitlist());
                }
                ClassAssignmentInterface.ClassAssignment c2 = e.getCourse().addClassAssignment();
                c2.setClassId(enrollment.getClazz().getUniqueId());
                c2.setSection(enrollment.getClazz().getClassSuffix(enrollment.getCourseOffering()));
                if (c2.getSection() == null) {
                    c2.setSection(enrollment.getClazz().getSectionNumberString(hibSession));
                }
                c2.setClassNumber(enrollment.getClazz().getSectionNumberString(hibSession));
                c2.setSubpart(enrollment.getClazz().getSchedulingSubpart().getItypeDesc());
            }
            while (iterator.hasNext()) {
                CourseRequest request = (CourseRequest)iterator.next();
                e = (ClassAssignmentInterface.Enrollment)student2enrollment.get(request.getCourseDemand().getStudent().getUniqueId());
                if (e != null) continue;
                st = new ClassAssignmentInterface.Student();
                st.setId(request.getCourseDemand().getStudent().getUniqueId());
                st.setSessionId(request.getCourseDemand().getStudent().getSession().getUniqueId());
                st.setExternalId(request.getCourseDemand().getStudent().getExternalUniqueId());
                st.setCanShowExternalId(canShowExtIds);
                st.setCanRegister(canRegister);
                st.setCanUseAssistant(canUseAssistant);
                st.setName(nameFormat.format(request.getCourseDemand().getStudent()));
                for (AcademicAreaClassification ac : request.getCourseDemand().getStudent().getAcademicAreaClassifications()) {
                    st.addArea(ac.getAcademicArea().getAcademicAreaAbbreviation());
                    st.addClassification(ac.getAcademicClassification().getCode());
                }
                for (PosMajor m : request.getCourseDemand().getStudent().getPosMajors()) {
                    st.addMajor(m.getCode());
                }
                for (StudentGroup g : request.getCourseDemand().getStudent().getGroups()) {
                    st.addGroup(g.getGroupAbbreviation());
                }
                for (StudentAccomodation a : request.getCourseDemand().getStudent().getAccomodations()) {
                    st.addAccommodation(a.getAbbreviation());
                }
                e = new ClassAssignmentInterface.Enrollment();
                e.setStudent(st);
                c = new ClassAssignmentInterface.CourseAssignment();
                ((ClassAssignmentInterface.CourseAssignment)c).setCourseId(request.getCourseOffering().getUniqueId());
                ((ClassAssignmentInterface.CourseAssignment)c).setSubject(request.getCourseOffering().getSubjectAreaAbbv());
                ((ClassAssignmentInterface.CourseAssignment)c).setCourseNbr(request.getCourseOffering().getCourseNbr());
                ((ClassAssignmentInterface.CourseAssignment)c).setTitle(request.getCourseOffering().getTitle());
                e.setCourse((ClassAssignmentInterface.CourseAssignment)c);
                e.setWaitList(request.getCourseDemand().isWaitlist());
                student2enrollment.put(request.getCourseDemand().getStudent().getUniqueId(), e);
                e.setPriority(1 + request.getCourseDemand().getPriority());
                if (request.getCourseDemand().getCourseRequests().size() > 1) {
                    first = null;
                    for (CourseRequest courseRequest : request.getCourseDemand().getCourseRequests()) {
                        if (first != null && courseRequest.getOrder().compareTo(((BaseCourseRequest)((Object)first)).getOrder()) >= 0) continue;
                        first = courseRequest;
                    }
                    if (!((BaseCourseRequest)((Object)first)).equals(request)) {
                        e.setAlternative(((BaseCourseRequest)((Object)first)).getCourseOffering().getCourseName());
                    }
                }
                if (request.getCourseDemand().isAlternative().booleanValue()) {
                    first = request.getCourseDemand();
                    block21: for (CourseDemand courseDemand : request.getCourseDemand().getStudent().getCourseDemands()) {
                        if (courseDemand.isAlternative().booleanValue() || courseDemand.getPriority().compareTo(((BaseCourseDemand)((Object)first)).getPriority()) >= 0 || courseDemand.getCourseRequests().isEmpty()) continue;
                        for (CourseRequest cr : courseDemand.getCourseRequests()) {
                            if (!cr.getClassEnrollments().isEmpty()) continue;
                            continue block21;
                        }
                        first = courseDemand;
                    }
                    alt = null;
                    for (CourseRequest courseRequest : ((BaseCourseDemand)((Object)first)).getCourseRequests()) {
                        if (alt != null && courseRequest.getOrder().compareTo(alt.getOrder()) >= 0) continue;
                        alt = courseRequest;
                    }
                    e.setAlternative(alt.getCourseOffering().getCourseName());
                }
                e.setRequestedDate(request.getCourseDemand().getTimestamp());
            }
        }
        iterator = new ArrayList(student2enrollment.values());
        Object var25_43 = null;
        hibSession.close();
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClassAssignmentInterface getEnrollment(boolean online, Long studentId) throws SectioningException, PageAccessException {
        try {
            if (online) {
                ClassAssignmentInterface classAssignmentInterface;
                this.getSessionContext().checkPermission(studentId, "Student", Right.StudentEnrollments);
                org.hibernate.Session hibSession = SessionDAO.getInstance().getSession();
                try {
                    Student student = (Student)StudentDAO.getInstance().get(studentId, hibSession);
                    if (student == null) {
                        throw new SectioningException(MSG.exceptionBadStudentId());
                    }
                    OnlineSectioningServer server = this.getServerInstance(student.getSession().getUniqueId(), false);
                    if (server == null) {
                        Object clazz;
                        ClassAssignmentInterface.CourseAssignment course;
                        Comparator<StudentClassEnrollment> cmp = new Comparator<StudentClassEnrollment>(){

                            public boolean isParent(SchedulingSubpart s1, SchedulingSubpart s2) {
                                SchedulingSubpart p1 = s1.getParentSubpart();
                                if (p1 == null) {
                                    return false;
                                }
                                if (p1.equals(s2)) {
                                    return true;
                                }
                                return this.isParent(p1, s2);
                            }

                            @Override
                            public int compare(StudentClassEnrollment a, StudentClassEnrollment b) {
                                SchedulingSubpart s2;
                                SchedulingSubpart s1 = a.getClazz().getSchedulingSubpart();
                                if (this.isParent(s1, s2 = b.getClazz().getSchedulingSubpart())) {
                                    return 1;
                                }
                                if (this.isParent(s2, s1)) {
                                    return -1;
                                }
                                int cmp = s1.getItype().compareTo(s2.getItype());
                                if (cmp != 0) {
                                    return cmp;
                                }
                                return Double.compare(s1.getUniqueId().longValue(), s2.getUniqueId().longValue());
                            }
                        };
                        NameFormat nameFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingInstructorNameFormat.value());
                        ClassAssignmentInterface ret = new ClassAssignmentInterface();
                        Hashtable<Long, ClassAssignmentInterface.CourseAssignment> courses = new Hashtable<Long, ClassAssignmentInterface.CourseAssignment>();
                        CourseCreditUnitConfig credit = null;
                        TreeSet<StudentClassEnrollment> enrollments = new TreeSet<StudentClassEnrollment>(cmp);
                        enrollments.addAll(hibSession.createQuery("from StudentClassEnrollment e where e.student.uniqueId = :studentId order by e.courseOffering.subjectAreaAbbv, e.courseOffering.courseNbr").setLong("studentId", studentId.longValue()).list());
                        for (StudentClassEnrollment enrollment : enrollments) {
                            int maxLimit;
                            course = (ClassAssignmentInterface.CourseAssignment)courses.get(enrollment.getCourseOffering().getUniqueId());
                            if (course == null) {
                                course = new ClassAssignmentInterface.CourseAssignment();
                                courses.put(enrollment.getCourseOffering().getUniqueId(), course);
                                ret.add(course);
                                course.setAssigned(true);
                                course.setCourseId(enrollment.getCourseOffering().getUniqueId());
                                course.setCourseNbr(enrollment.getCourseOffering().getCourseNbr());
                                course.setSubject(enrollment.getCourseOffering().getSubjectAreaAbbv());
                                course.setTitle(enrollment.getCourseOffering().getTitle());
                                course.setWaitListed(enrollment.getCourseRequest() != null && enrollment.getCourseRequest().getCourseDemand().getWaitlist() != null && enrollment.getCourseRequest().getCourseDemand().getWaitlist() != false);
                                credit = enrollment.getCourseOffering().getCredit();
                                if (enrollment.getCourseRequest() != null) {
                                    course.setRequestedDate(enrollment.getCourseRequest().getCourseDemand().getTimestamp());
                                }
                            }
                            clazz = course.addClassAssignment();
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setClassId(enrollment.getClazz().getUniqueId());
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setCourseId(enrollment.getCourseOffering().getUniqueId());
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setCourseAssigned(true);
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setCourseNbr(enrollment.getCourseOffering().getCourseNbr());
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setTitle(enrollment.getCourseOffering().getTitle());
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setSubject(enrollment.getCourseOffering().getSubjectAreaAbbv());
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setSection(enrollment.getClazz().getClassSuffix(enrollment.getCourseOffering()));
                            if (((ClassAssignmentInterface.ClassAssignment)clazz).getSection() == null) {
                                ((ClassAssignmentInterface.ClassAssignment)clazz).setSection(enrollment.getClazz().getSectionNumberString(hibSession));
                            }
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setClassNumber(enrollment.getClazz().getSectionNumberString(hibSession));
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setSubpart(enrollment.getClazz().getSchedulingSubpart().getItypeDesc());
                            if (enrollment.getClazz().getParentClass() != null) {
                                ((ClassAssignmentInterface.ClassAssignment)clazz).setParentSection(enrollment.getClazz().getParentClass().getClassSuffix(enrollment.getCourseOffering()));
                                if (((ClassAssignmentInterface.ClassAssignment)clazz).getParentSection() == null) {
                                    ((ClassAssignmentInterface.ClassAssignment)clazz).setParentSection(enrollment.getClazz().getParentClass().getSectionNumberString(hibSession));
                                }
                            }
                            if (enrollment.getClazz().getSchedulePrintNote() != null) {
                                ((ClassAssignmentInterface.ClassAssignment)clazz).addNote(enrollment.getClazz().getSchedulePrintNote());
                            }
                            Iterator<Object> placement = enrollment.getClazz().getCommittedAssignment() == null ? null : enrollment.getClazz().getCommittedAssignment().getPlacement();
                            int minLimit = enrollment.getClazz().getExpectedCapacity();
                            int limit = maxLimit = enrollment.getClazz().getMaxExpectedCapacity().intValue();
                            if (minLimit < maxLimit && placement != null) {
                                int roomLimit = (int)Math.floor((float)placement.getRoomSize() / (enrollment.getClazz().getRoomRatio() == null ? 1.0f : enrollment.getClazz().getRoomRatio().floatValue()));
                                limit = Math.min(Math.max(minLimit, roomLimit), maxLimit);
                            }
                            if (enrollment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue() || limit >= 9999) {
                                limit = -1;
                            }
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setCancelled(enrollment.getClazz().isCancelled());
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setLimit(new int[]{enrollment.getClazz().getEnrollment(), limit});
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setEnrolledDate(enrollment.getTimestamp());
                            if (placement != null) {
                                if (placement.getTimeLocation() != null) {
                                    for (DayCode d : DayCode.toDayCodes(placement.getTimeLocation().getDayCode())) {
                                        ((ClassAssignmentInterface.ClassAssignment)clazz).addDay(d.getIndex());
                                    }
                                    ((ClassAssignmentInterface.ClassAssignment)clazz).setStart(placement.getTimeLocation().getStartSlot());
                                    ((ClassAssignmentInterface.ClassAssignment)clazz).setLength(placement.getTimeLocation().getLength());
                                    ((ClassAssignmentInterface.ClassAssignment)clazz).setBreakTime(placement.getTimeLocation().getBreakTime());
                                    ((ClassAssignmentInterface.ClassAssignment)clazz).setDatePattern(placement.getTimeLocation().getDatePatternName());
                                }
                                if (placement.getNrRooms() == 1) {
                                    ((ClassAssignmentInterface.ClassAssignment)clazz).addRoom(placement.getRoomLocation().getId(), placement.getRoomLocation().getName());
                                } else if (placement.getNrRooms() > 1) {
                                    for (RoomLocation rm : placement.getRoomLocations()) {
                                        ((ClassAssignmentInterface.ClassAssignment)clazz).addRoom(rm.getId(), rm.getName());
                                    }
                                }
                            }
                            if (enrollment.getClazz().getDisplayInstructor().booleanValue()) {
                                for (ClassInstructor ci : enrollment.getClazz().getClassInstructors()) {
                                    if (!ci.isLead().booleanValue()) continue;
                                    ((ClassAssignmentInterface.ClassAssignment)clazz).addInstructor(nameFormat.format(ci.getInstructor()));
                                    ((ClassAssignmentInterface.ClassAssignment)clazz).addInstructoEmail(ci.getInstructor().getEmail() == null ? "" : ci.getInstructor().getEmail());
                                }
                            }
                            if (enrollment.getClazz().getSchedulingSubpart().getCredit() != null) {
                                ((ClassAssignmentInterface.ClassAssignment)clazz).setCredit(enrollment.getClazz().getSchedulingSubpart().getCredit().creditAbbv() + "|" + enrollment.getClazz().getSchedulingSubpart().getCredit().creditText());
                            } else if (credit != null) {
                                ((ClassAssignmentInterface.ClassAssignment)clazz).setCredit(credit.creditAbbv() + "|" + credit.creditText());
                            }
                            credit = null;
                            if (((ClassAssignmentInterface.ClassAssignment)clazz).getParentSection() != null) continue;
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setParentSection(enrollment.getCourseOffering().getConsentType() == null ? null : enrollment.getCourseOffering().getConsentType().getLabel());
                        }
                        block11: for (CourseDemand demand : hibSession.createQuery("from CourseDemand d where d.student.uniqueId = :studentId order by d.priority").setLong("studentId", studentId.longValue()).list()) {
                            if (demand.getFreeTime() != null) {
                                course = new ClassAssignmentInterface.CourseAssignment();
                                course.setAssigned(true);
                                clazz = course.addClassAssignment();
                                ((ClassAssignmentInterface.ClassAssignment)clazz).setLength(demand.getFreeTime().getLength());
                                for (DayCode d : DayCode.toDayCodes(demand.getFreeTime().getDayCode())) {
                                    ((ClassAssignmentInterface.ClassAssignment)clazz).addDay(d.getIndex());
                                }
                                ((ClassAssignmentInterface.ClassAssignment)clazz).setStart(demand.getFreeTime().getStartSlot());
                                block13: for (ClassAssignmentInterface.CourseAssignment ca : ret.getCourseAssignments()) {
                                    for (ClassAssignmentInterface.ClassAssignment c : ca.getClassAssignments()) {
                                        if (!c.isAssigned()) continue;
                                        for (int d : c.getDays()) {
                                            if (!((ClassAssignmentInterface.ClassAssignment)clazz).getDays().contains(d) || c.getStart() + c.getLength() <= ((ClassAssignmentInterface.ClassAssignment)clazz).getStart() || ((ClassAssignmentInterface.ClassAssignment)clazz).getStart() + ((ClassAssignmentInterface.ClassAssignment)clazz).getLength() <= c.getStart()) continue;
                                            course.setAssigned(false);
                                            break block13;
                                        }
                                    }
                                }
                                course.setRequestedDate(demand.getTimestamp());
                                ret.add(course);
                                continue;
                            }
                            BaseCourseRequest request = null;
                            for (CourseRequest r : demand.getCourseRequests()) {
                                if (courses.containsKey(r.getCourseOffering().getUniqueId())) continue block11;
                                if (request != null && r.getOrder().compareTo(request.getOrder()) >= 0) continue;
                                request = r;
                            }
                            if (request == null) continue;
                            ClassAssignmentInterface.CourseAssignment course2 = new ClassAssignmentInterface.CourseAssignment();
                            courses.put(request.getCourseOffering().getUniqueId(), course2);
                            course2.setRequestedDate(demand.getTimestamp());
                            ret.add(course2);
                            course2.setAssigned(false);
                            course2.setWaitListed(demand.getWaitlist() != null && demand.getWaitlist() != false);
                            course2.setCourseId(request.getCourseOffering().getUniqueId());
                            course2.setCourseNbr(request.getCourseOffering().getCourseNbr());
                            course2.setSubject(request.getCourseOffering().getSubjectAreaAbbv());
                            course2.setTitle(request.getCourseOffering().getTitle());
                            ClassAssignmentInterface.ClassAssignment clazz2 = course2.addClassAssignment();
                            clazz2.setCourseId(request.getCourseOffering().getUniqueId());
                            clazz2.setCourseAssigned(false);
                            clazz2.setCourseNbr(request.getCourseOffering().getCourseNbr());
                            clazz2.setTitle(request.getCourseOffering().getTitle());
                            clazz2.setSubject(request.getCourseOffering().getSubjectAreaAbbv());
                        }
                        ClassAssignmentInterface classAssignmentInterface2 = ret;
                        Object var23_38 = null;
                        hibSession.close();
                        return classAssignmentInterface2;
                    }
                    classAssignmentInterface = server.execute(server.createAction(GetAssignment.class).forStudent(studentId), this.currentUser());
                }
                catch (Throwable throwable) {
                    Object var23_40 = null;
                    hibSession.close();
                    throw throwable;
                }
                Object var23_39 = null;
                hibSession.close();
                return classAssignmentInterface;
            }
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            return server.execute(server.createAction(GetAssignment.class).forStudent(studentId), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (AccessDeniedException e) {
            throw new PageAccessException(e.getMessage());
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public String approveEnrollments(Long classOrOfferingId, List<Long> studentIds) throws SectioningException, PageAccessException {
        try {
            InstructionalOffering offering;
            org.hibernate.Session hibSession = SessionDAO.getInstance().getSession();
            List<Long> courseIdsCanApprove = this.canApprove(classOrOfferingId);
            if (courseIdsCanApprove == null || courseIdsCanApprove.isEmpty()) {
                throw new SectioningException(MSG.exceptionInsufficientPrivileges());
            }
            InstructionalOffering instructionalOffering = offering = classOrOfferingId >= 0L ? (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(classOrOfferingId, hibSession) : null;
            if (offering == null) {
                BaseClass_ clazz;
                BaseClass_ baseClass_ = clazz = classOrOfferingId < 0L ? (Class_)Class_DAO.getInstance().get(-classOrOfferingId.longValue(), hibSession) : null;
                if (clazz == null) {
                    throw new SectioningException(MSG.exceptionBadClassOrOffering());
                }
                offering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering();
            }
            OnlineSectioningServer server = this.getServerInstance(offering.getControllingCourseOffering().getSubjectArea().getSessionId(), false);
            UserContext user = this.getSessionContext().getUser();
            String approval = new Date().getTime() + ":" + user.getTrueExternalUserId() + ":" + user.getTrueName();
            server.execute(server.createAction(ApproveEnrollmentsAction.class).withParams(offering.getUniqueId(), studentIds, courseIdsCanApprove, approval), this.currentUser());
            return approval;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public Boolean rejectEnrollments(Long classOrOfferingId, List<Long> studentIds) throws SectioningException, PageAccessException {
        try {
            InstructionalOffering offering;
            org.hibernate.Session hibSession = SessionDAO.getInstance().getSession();
            List<Long> courseIdsCanApprove = this.canApprove(classOrOfferingId);
            if (courseIdsCanApprove == null || courseIdsCanApprove.isEmpty()) {
                throw new SectioningException(MSG.exceptionInsufficientPrivileges());
            }
            InstructionalOffering instructionalOffering = offering = classOrOfferingId >= 0L ? (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(classOrOfferingId, hibSession) : null;
            if (offering == null) {
                BaseClass_ clazz;
                BaseClass_ baseClass_ = clazz = classOrOfferingId < 0L ? (Class_)Class_DAO.getInstance().get(-classOrOfferingId.longValue(), hibSession) : null;
                if (clazz == null) {
                    throw new SectioningException(MSG.exceptionBadClassOrOffering());
                }
                offering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering();
            }
            OnlineSectioningServer server = this.getServerInstance(offering.getControllingCourseOffering().getSubjectArea().getSessionId(), false);
            UserContext user = this.getSessionContext().getUser();
            String approval = new Date().getTime() + ":" + user.getTrueExternalUserId() + ":" + user.getTrueName();
            return server.execute(server.createAction(RejectEnrollmentsAction.class).withParams(offering.getUniqueId(), studentIds, courseIdsCanApprove, approval), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    private Long getStatusPageSessionId() throws SectioningException, PageAccessException {
        UserContext user = this.getSessionContext().getUser();
        if (user == null) {
            throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired());
        }
        if (user.getCurrentAcademicSessionId() == null) {
            Long sessionId = this.getLastSessionId();
            if (sessionId != null) {
                return sessionId;
            }
        } else {
            return user.getCurrentAcademicSessionId();
        }
        throw new SectioningException(MSG.exceptionNoAcademicSession());
    }

    private HashSet<Long> getCoordinatingCourses(Long sessionId) throws SectioningException, PageAccessException {
        UserContext user = this.getSessionContext().getUser();
        if (user == null) {
            throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired());
        }
        if (this.getSessionContext().hasPermission(Right.HasRole)) {
            return null;
        }
        HashSet<Long> courseIds = new HashSet<Long>(CourseOfferingDAO.getInstance().getSession().createQuery("select distinct c.uniqueId from CourseOffering c inner join c.instructionalOffering.coordinators i where c.subjectArea.session.uniqueId = :sessionId and c.subjectArea.department.allowStudentScheduling = true and i.externalUniqueId = :extId").setLong("sessionId", sessionId.longValue()).setString("extId", user.getExternalUserId()).setCacheable(true).list());
        return courseIds;
    }

    private HashSet<Long> getApprovableCourses(Long sessionId) throws SectioningException, PageAccessException {
        UserContext user = this.getSessionContext().getUser();
        if (user == null) {
            throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired());
        }
        HashSet<Long> courseIds = new HashSet<Long>(CourseOfferingDAO.getInstance().getSession().createQuery("select distinct c.uniqueId from CourseOffering c inner join c.instructionalOffering.coordinators i where c.subjectArea.session.uniqueId = :sessionId and c.subjectArea.department.allowStudentScheduling = true and c.consentType.reference = :reference and i.externalUniqueId = :extId").setLong("sessionId", sessionId.longValue()).setString("reference", "IN").setString("extId", user.getExternalUserId()).setCacheable(true).list());
        if (!user.getCurrentAuthority().hasRight(Right.HasRole)) {
            return courseIds;
        }
        if (user.getCurrentAuthority().hasRight(Right.SessionIndependent)) {
            return new HashSet<Long>(CourseOfferingDAO.getInstance().getSession().createQuery("select c.uniqueId from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId and c.subjectArea.department.allowStudentScheduling = true and c.consentType is not null").setLong("sessionId", sessionId.longValue()).setCacheable(true).list());
        }
        for (Department d : Department.getUserDepartments(user)) {
            courseIds.addAll(CourseOfferingDAO.getInstance().getSession().createQuery("select distinct c.uniqueId from CourseOffering c where c.subjectArea.department.uniqueId = :departmentId and c.subjectArea.department.allowStudentScheduling = true and c.consentType is not null").setLong("departmentId", d.getUniqueId().longValue()).setCacheable(true).list());
        }
        return courseIds;
    }

    @Override
    public List<ClassAssignmentInterface.EnrollmentInfo> findEnrollmentInfos(boolean online, String query, SectioningStatusFilterBox.SectioningStatusFilterRpcRequest filter, Long courseId) throws SectioningException, PageAccessException {
        try {
            if (online) {
                Long sessionId = this.getStatusPageSessionId();
                OnlineSectioningServer server = this.getServerInstance(sessionId, true);
                if (server == null) {
                    throw new SectioningException(MSG.exceptionBadSession());
                }
                if (server instanceof DatabaseServer) {
                    return server.execute(server.createAction(DbFindEnrollmentInfoAction.class).withParams(query, courseId, this.getCoordinatingCourses(sessionId), query.matches("(?i:.*consent:[ ]?(todo|\\\"to do\\\").*)") ? this.getApprovableCourses(sessionId) : null).withFilter(filter), this.currentUser());
                }
                return server.execute(server.createAction(FindEnrollmentInfoAction.class).withParams(query, courseId, this.getCoordinatingCourses(sessionId), query.matches("(?i:.*consent:[ ]?(todo|\\\"to do\\\").*)") ? this.getApprovableCourses(sessionId) : null).withFilter(filter), this.currentUser());
            }
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            return server.execute(server.createAction(FindEnrollmentInfoAction.class).withParams(query, courseId, null, null).withFilter(filter), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public List<ClassAssignmentInterface.StudentInfo> findStudentInfos(boolean online, String query, SectioningStatusFilterBox.SectioningStatusFilterRpcRequest filter) throws SectioningException, PageAccessException {
        try {
            if (online) {
                Long sessionId = this.getStatusPageSessionId();
                OnlineSectioningServer server = this.getServerInstance(sessionId, true);
                if (server == null) {
                    throw new SectioningException(MSG.exceptionBadSession());
                }
                if (server instanceof DatabaseServer) {
                    return server.execute(server.createAction(DbFindStudentInfoAction.class).withParams(query, this.getCoordinatingCourses(sessionId), query.matches("(?i:.*consent:[ ]?(todo|\\\"to do\\\").*)") ? this.getApprovableCourses(sessionId) : null, this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId), this.sessionContext.hasPermission(Right.CourseRequests), this.sessionContext.hasPermission(Right.SchedulingAssistant)).withFilter(filter), this.currentUser());
                }
                return server.execute(server.createAction(FindStudentInfoAction.class).withParams(query, this.getCoordinatingCourses(sessionId), query.matches("(?i:.*consent:[ ]?(todo|\\\"to do\\\").*)") ? this.getApprovableCourses(sessionId) : null, this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId), this.sessionContext.hasPermission(Right.CourseRequests), this.sessionContext.hasPermission(Right.SchedulingAssistant)).withFilter(filter), this.currentUser());
            }
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            return server.execute(server.createAction(FindStudentInfoAction.class).withParams(query, null, null, this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId), false, true).withFilter(filter), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public List<String[]> querySuggestions(boolean online, String query, int limit) throws SectioningException, PageAccessException {
        try {
            if (online) {
                Long sessionId = this.getStatusPageSessionId();
                OnlineSectioningServer server = this.getServerInstance(sessionId, true);
                if (server == null) {
                    throw new SectioningException(MSG.exceptionBadSession());
                }
                UserContext user = this.getSessionContext().getUser();
                return server.execute(server.createAction(StatusPageSuggestionsAction.class).withParams(user.getExternalUserId(), user.getName(), query, limit), this.currentUser());
            }
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            UserContext user = this.getSessionContext().getUser();
            return server.execute(server.createAction(StatusPageSuggestionsAction.class).withParams(user.getExternalUserId(), user.getName(), query, limit), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public List<ClassAssignmentInterface.Enrollment> findEnrollments(boolean online, String query, SectioningStatusFilterBox.SectioningStatusFilterRpcRequest filter, Long courseId, Long classId) throws SectioningException, PageAccessException {
        try {
            if (online) {
                Long sessionId = this.getStatusPageSessionId();
                OnlineSectioningServer server = this.getServerInstance(sessionId, true);
                if (server == null) {
                    throw new SectioningException(MSG.exceptionBadSession());
                }
                if (this.getSessionContext().isAuthenticated()) {
                    this.getSessionContext().getUser().setProperty("SectioningStatus.LastStatusQuery", query);
                }
                if (server instanceof DatabaseServer) {
                    return server.execute(server.createAction(DbFindEnrollmentAction.class).withParams(query, courseId, classId, query.matches("(?i:.*consent:[ ]?(todo|\\\"to do\\\").*)") ? this.getApprovableCourses(sessionId).contains(courseId) : false, this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId), this.sessionContext.hasPermission(Right.CourseRequests), this.sessionContext.hasPermission(Right.SchedulingAssistant)).withFilter(filter), this.currentUser());
                }
                return server.execute(server.createAction(FindEnrollmentAction.class).withParams(query, courseId, classId, query.matches("(?i:.*consent:[ ]?(todo|\\\"to do\\\").*)") ? this.getApprovableCourses(sessionId).contains(courseId) : false, this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId), this.sessionContext.hasPermission(Right.CourseRequests), this.sessionContext.hasPermission(Right.SchedulingAssistant)).withFilter(filter), this.currentUser());
            }
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            if (this.getSessionContext().isAuthenticated()) {
                this.getSessionContext().getUser().setProperty("SectioningStatus.LastStatusQuery", query);
            }
            return server.execute(server.createAction(FindEnrollmentAction.class).withParams(query, courseId, classId, false, this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId), false, true).withFilter(filter), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public Long canEnroll(boolean online, Long studentId) throws SectioningException, PageAccessException {
        return this.canEnroll(online, null, studentId);
    }

    protected Long canEnroll(boolean online, Long sessionId, Long studentId) throws SectioningException, PageAccessException {
        try {
            OnlineSectioningInterface.EligibilityCheck check;
            OnlineSectioningInterface.EligibilityCheck last;
            if (!online) {
                StudentSolverProxy server = this.getStudentSolver();
                if (server == null) {
                    throw new SectioningException(MSG.exceptionNoSolver());
                }
                CourseRequestInterface request = server.execute(server.createAction(GetRequest.class).forStudent(studentId), this.currentUser());
                if (request == null) {
                    throw new SectioningException(MSG.exceptionBadStudentId());
                }
                return server.getAcademicSession().getUniqueId();
            }
            boolean recheckCustomEligibility = ApplicationProperty.OnlineSchedulingCustomEligibilityRecheck.isTrue();
            if (!(recheckCustomEligibility || (last = (OnlineSectioningInterface.EligibilityCheck)this.getSessionContext().getAttribute("eligibility")) == null || !last.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.RECHECK_BEFORE_ENROLLMENT) && last.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL))) {
                recheckCustomEligibility = true;
            }
            if ((check = this.checkEligibility(online, true, sessionId, studentId, null, recheckCustomEligibility)) == null || !check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL) || check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.RECHECK_BEFORE_ENROLLMENT)) {
                throw new SectioningException(check.getMessage() == null ? (check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.PIN_REQUIRED) ? MSG.exceptionAuthenticationPinNotProvided() : MSG.exceptionInsufficientPrivileges()) : check.getMessage()).withEligibilityCheck(check);
            }
            if (studentId.equals(this.getStudentId(check.getSessionId()))) {
                return check.getSessionId();
            }
            if (this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisor)) {
                return check.getSessionId();
            }
            OnlineSectioningServer server = this.getServerInstance(check.getSessionId(), false);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            if (this.getStudentId(check.getSessionId()) == null) {
                throw new PageAccessException(MSG.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
            }
            throw new PageAccessException(MSG.exceptionInsufficientPrivileges());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CourseRequestInterface savedRequest(boolean online, Long sessionId, Long studentId) throws SectioningException, PageAccessException {
        HashSet<Long> courseIds;
        CourseRequestInterface request;
        Student student;
        org.hibernate.Session hibSession;
        OnlineSectioningServer server;
        block31: {
            if (studentId == null) {
                studentId = this.getStudentId(sessionId);
                if (studentId == null && sessionId != null && online && CustomCourseRequestsHolder.hasProvider() && (server = this.getServerInstance(sessionId, false)) != null) {
                    return server.execute(server.createAction(GetRequest.class), this.currentUser());
                }
                if (studentId == null) {
                    throw new SectioningException(MSG.exceptionNoStudent());
                }
            }
            if (!online) {
                server = this.getStudentSolver();
                if (server != null) return server.execute(server.createAction(GetRequest.class).forStudent(studentId), this.currentUser());
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            server = this.getServerInstance(sessionId == null ? this.canEnroll(online, studentId) : sessionId, false);
            if (server != null) {
                return server.execute(server.createAction(GetRequest.class).forStudent(studentId), this.currentUser());
            }
            hibSession = StudentDAO.getInstance().getSession();
            try {
                try {
                    student = (Student)StudentDAO.getInstance().get(studentId, hibSession);
                    if (student == null) {
                        throw new SectioningException(MSG.exceptionBadStudentId());
                    }
                    request = new CourseRequestInterface();
                    request.setAcademicSessionId(sessionId);
                    courseIds = new HashSet<Long>();
                    if (student.getCourseDemands().isEmpty()) break block31;
                    TreeSet<CourseDemand> demands = new TreeSet<CourseDemand>(new Comparator<CourseDemand>(){

                        @Override
                        public int compare(CourseDemand d1, CourseDemand d2) {
                            if (d1.isAlternative().booleanValue() && !d2.isAlternative().booleanValue()) {
                                return 1;
                            }
                            if (!d1.isAlternative().booleanValue() && d2.isAlternative().booleanValue()) {
                                return -1;
                            }
                            int cmp = d1.getPriority().compareTo(d2.getPriority());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return d1.getUniqueId().compareTo(d2.getUniqueId());
                        }
                    });
                    demands.addAll(student.getCourseDemands());
                    CourseRequestInterface.Request lastRequest = null;
                    int lastRequestPriority = -1;
                    for (CourseDemand cd : demands) {
                        CourseRequestInterface.Request r;
                        block32: {
                            block33: {
                                r = null;
                                if (cd.getFreeTime() == null) break block33;
                                CourseRequestInterface.FreeTime ft = new CourseRequestInterface.FreeTime();
                                ft.setStart(cd.getFreeTime().getStartSlot());
                                ft.setLength(cd.getFreeTime().getLength());
                                for (DayCode day : DayCode.toDayCodes(cd.getFreeTime().getDayCode())) {
                                    ft.addDay(day.getIndex());
                                }
                                if (lastRequest != null && lastRequestPriority == cd.getPriority()) {
                                    r = lastRequest;
                                    lastRequest.addRequestedFreeTime(ft);
                                    lastRequest.setRequestedCourse(lastRequest.getRequestedCourse() + ", " + ft.toString());
                                    break block32;
                                } else {
                                    r = new CourseRequestInterface.Request();
                                    r.addRequestedFreeTime(ft);
                                    r.setRequestedCourse(ft.toString());
                                    if (cd.isAlternative().booleanValue()) {
                                        request.getAlternatives().add(r);
                                        break block32;
                                    } else {
                                        request.getCourses().add(r);
                                    }
                                }
                                break block32;
                            }
                            if (!cd.getCourseRequests().isEmpty()) {
                                r = new CourseRequestInterface.Request();
                                block13: for (CourseRequest course : cd.getCourseRequests()) {
                                    XCourse c;
                                    courseIds.add(course.getCourseOffering().getUniqueId());
                                    XCourse xCourse = c = server == null ? new XCourse(course.getCourseOffering()) : server.getCourse(course.getCourseOffering().getUniqueId());
                                    if (c == null) continue;
                                    switch (course.getOrder()) {
                                        case 0: {
                                            r.setRequestedCourse(c.getSubjectArea() + " " + c.getCourseNumber() + (c.hasUniqueName() && !CONSTANTS.showCourseTitle() ? "" : " - " + c.getTitle()));
                                            break;
                                        }
                                        case 1: {
                                            r.setFirstAlternative(c.getSubjectArea() + " " + c.getCourseNumber() + (c.hasUniqueName() && !CONSTANTS.showCourseTitle() ? "" : " - " + c.getTitle()));
                                            break;
                                        }
                                        case 2: {
                                            r.setSecondAlternative(c.getSubjectArea() + " " + c.getCourseNumber() + (c.hasUniqueName() && !CONSTANTS.showCourseTitle() ? "" : " - " + c.getTitle()));
                                            continue block13;
                                        }
                                    }
                                }
                                if (r.hasRequestedCourse()) {
                                    if (cd.isAlternative().booleanValue()) {
                                        request.getAlternatives().add(r);
                                    } else {
                                        request.getCourses().add(r);
                                    }
                                }
                            }
                        }
                        r.setWaitList(cd.getWaitlist());
                        lastRequest = r;
                        lastRequestPriority = cd.getPriority();
                    }
                }
                catch (PageAccessException e) {
                    throw e;
                }
                catch (SectioningException e) {
                    throw e;
                }
                catch (Exception e) {
                    sLog.error((Object)e.getMessage(), (Throwable)e);
                    throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                }
            }
            catch (Throwable throwable) {
                Object var19_24 = null;
                hibSession.close();
                throw throwable;
            }
        }
        if (!student.getClassEnrollments().isEmpty()) {
            TreeSet<XCourse> courses = new TreeSet<XCourse>();
            for (StudentClassEnrollment enrl : student.getClassEnrollments()) {
                XCourse c;
                if (courseIds.contains(enrl.getCourseOffering().getUniqueId()) || (c = server == null ? new XCourse(enrl.getCourseOffering()) : server.getCourse(enrl.getCourseOffering().getUniqueId())) == null) continue;
                courses.add(c);
            }
            for (XCourse c : courses) {
                CourseRequestInterface.Request r = new CourseRequestInterface.Request();
                r.setRequestedCourse(c.getSubjectArea() + " " + c.getCourseNumber() + (c.hasUniqueName() && !CONSTANTS.showCourseTitle() ? "" : " - " + c.getTitle()));
                request.getCourses().add(r);
            }
        }
        CourseRequestInterface courseRequestInterface = request;
        Object var19_23 = null;
        hibSession.close();
        return courseRequestInterface;
    }

    @Override
    public ClassAssignmentInterface savedResult(boolean online, Long sessionId, Long studentId) throws SectioningException, PageAccessException {
        if (online) {
            OnlineSectioningServer server = this.getServerInstance(sessionId == null ? this.canEnroll(online, studentId) : sessionId, false);
            return server.execute(server.createAction(GetAssignment.class).forStudent(studentId), this.currentUser());
        }
        StudentSolverProxy server = this.getStudentSolver();
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoSolver());
        }
        ClassAssignmentInterface ret = server.execute(server.createAction(GetAssignment.class).forStudent(studentId), this.currentUser());
        if (ret != null) {
            ret.setCanEnroll(this.getStudentId(sessionId) != null);
        }
        return ret;
    }

    @Override
    public Boolean selectSession(Long sessionId) {
        this.getSessionContext().setAttribute("sessionId", (Object)sessionId);
        UserContext user = this.getSessionContext().getUser();
        if (user != null && user.getCurrentAuthority() != null) {
            List<? extends UserAuthority> authorities = user.getAuthorities(user.getCurrentAuthority().getRole(), new SimpleQualifier("Session", sessionId));
            if (!authorities.isEmpty()) {
                user.setCurrentAuthority(authorities.get(0));
            } else {
                user.setCurrentAuthority(null);
            }
        }
        return true;
    }

    @Override
    public Map<String, String> lookupStudentSectioningStates() throws SectioningException, PageAccessException {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("", "System Default (All Enabled)");
        for (StudentSectioningStatus s : StudentSectioningStatusDAO.getInstance().findAll()) {
            ret.put(s.getReference(), s.getLabel());
        }
        return ret;
    }

    @Override
    public Boolean sendEmail(Long studentId, String subject, String message, String cc) throws SectioningException, PageAccessException {
        try {
            OnlineSectioningServer server = this.getServerInstance(this.getStatusPageSessionId(), true);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            if (ApplicationProperty.OnlineSchedulingEmailConfirmation.isFalse()) {
                throw new SectioningException(MSG.exceptionStudentEmailsDisabled());
            }
            this.getSessionContext().checkPermission(server.getAcademicSession(), Right.StudentSchedulingEmailStudent);
            StudentEmail email = server.createAction(StudentEmail.class).forStudent(studentId);
            email.setCC(cc);
            email.setEmailSubject(subject == null || subject.isEmpty() ? MSG.defaulSubject() : subject);
            email.setMessage(message);
            return server.execute(email, this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public Boolean changeStatus(List<Long> studentIds, String ref) throws SectioningException, PageAccessException {
        try {
            OnlineSectioningServer server = this.getServerInstance(this.getStatusPageSessionId(), true);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            this.getSessionContext().checkPermission(server.getAcademicSession(), Right.StudentSchedulingChangeStudentStatus);
            return server.execute(server.createAction(ChangeStudentStatus.class).forStudents(studentIds).withStatus(ref), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    private OnlineSectioningLog.Entity currentUser() {
        UserContext user = this.getSessionContext().getUser();
        UniTimePrincipal principal = (UniTimePrincipal)this.getSessionContext().getAttribute("user");
        String pin = (String)this.getSessionContext().getAttribute("pin");
        if (user != null) {
            OnlineSectioningLog.Entity.Builder entity = OnlineSectioningLog.Entity.newBuilder().setExternalId(user.getTrueExternalUserId()).setName(user.getTrueName() == null ? user.getUsername() : user.getTrueName()).setType(this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisor) ? OnlineSectioningLog.Entity.EntityType.MANAGER : OnlineSectioningLog.Entity.EntityType.STUDENT);
            if (pin != null) {
                entity.addParameterBuilder().setKey("pin").setValue(pin);
            }
            if (principal != null && principal.getStudentExternalId() != null) {
                entity.addParameterBuilder().setKey("student").setValue(principal.getStudentExternalId());
            }
            return entity.build();
        }
        if (principal != null) {
            OnlineSectioningLog.Entity.Builder entity = OnlineSectioningLog.Entity.newBuilder().setExternalId(principal.getExternalId()).setName(principal.getName()).setType(OnlineSectioningLog.Entity.EntityType.STUDENT);
            if (pin != null) {
                entity.addParameterBuilder().setKey("pin").setValue(pin);
            }
            return entity.build();
        }
        return null;
    }

    @Override
    public List<ClassAssignmentInterface.SectioningAction> changeLog(String query) throws SectioningException, PageAccessException {
        Long sessionId = this.getStatusPageSessionId();
        OnlineSectioningServer server = this.getServerInstance(sessionId, true);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        return server.execute(server.createAction(FindOnlineSectioningLogAction.class).forQuery(query), this.currentUser());
    }

    @Override
    public Boolean massCancel(List<Long> studentIds, String statusRef, String subject, String message, String cc) throws SectioningException, PageAccessException {
        try {
            OnlineSectioningServer server = this.getServerInstance(this.getStatusPageSessionId(), false);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            this.getSessionContext().checkPermission(server.getAcademicSession(), Right.StudentSchedulingMassCancel);
            org.hibernate.Session hibSession = StudentDAO.getInstance().getSession();
            StudentSectioningStatus status = statusRef == null || statusRef.isEmpty() ? null : (StudentSectioningStatus)hibSession.createQuery("from StudentSectioningStatus where reference = :ref").setString("ref", statusRef).uniqueResult();
            return server.execute(server.createAction(MassCancelAction.class).forStudents(studentIds).withStatus(status).withEmail(subject, message, cc), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public OnlineSectioningInterface.EligibilityCheck checkEligibility(boolean online, boolean sectioning, Long sessionId, Long studentId, String pin) throws SectioningException, PageAccessException {
        return this.checkEligibility(online, sectioning, sessionId, studentId, pin, true);
    }

    public OnlineSectioningInterface.EligibilityCheck checkEligibility(boolean online, boolean sectioning, Long sessionId, Long studentId, String pin, boolean includeCustomCheck) throws SectioningException, PageAccessException {
        try {
            Student student;
            if (pin != null && !pin.isEmpty()) {
                this.getSessionContext().setAttribute("pin", (Object)pin);
            }
            if (includeCustomCheck) {
                this.getSessionContext().removeAttribute("eligibility");
            }
            if (!online) {
                StudentSolverProxy server = this.getStudentSolver();
                if (server == null) {
                    return new OnlineSectioningInterface.EligibilityCheck(MSG.exceptionNoSolver(), new OnlineSectioningInterface.EligibilityCheck.EligibilityFlag[0]);
                }
                OnlineSectioningInterface.EligibilityCheck check = new OnlineSectioningInterface.EligibilityCheck();
                check.setSessionId(server.getAcademicSession().getUniqueId());
                check.setStudentId(studentId);
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_USE_ASSISTANT, true);
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, true);
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST, true);
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_RESET, true);
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CONFIRM_DROP, false);
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.QUICK_ADD_DROP, ApplicationProperty.OnlineSchedulingQuickAddDrop.isTrue());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.ALTERNATIVES_DROP, ApplicationProperty.OnlineSchedulingAlternativesDrop.isTrue());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.GWT_CONFIRMATIONS, ApplicationProperty.OnlineSchedulingGWTConfirmations.isTrue());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.DEGREE_PLANS, CustomDegreePlansHolder.hasProvider());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.NO_REQUEST_ARROWS, ApplicationProperty.OnlineSchedulingNoRequestArrows.isTrue());
                return check;
            }
            if (sessionId == null && studentId != null && (student = (Student)StudentDAO.getInstance().get(studentId)) != null) {
                sessionId = student.getSession().getUniqueId();
            }
            if (sessionId == null) {
                sessionId = this.getLastSessionId();
            } else {
                this.setLastSessionId(sessionId);
            }
            if (sessionId == null) {
                return new OnlineSectioningInterface.EligibilityCheck(MSG.exceptionNoAcademicSession(), new OnlineSectioningInterface.EligibilityCheck.EligibilityFlag[0]);
            }
            UserContext user = this.getSessionContext().getUser();
            if (user == null) {
                return new OnlineSectioningInterface.EligibilityCheck(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired(), new OnlineSectioningInterface.EligibilityCheck.EligibilityFlag[0]);
            }
            if (studentId == null) {
                studentId = this.getStudentId(sessionId);
            }
            OnlineSectioningInterface.EligibilityCheck check = new OnlineSectioningInterface.EligibilityCheck();
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN, this.getSessionContext().hasPermission(Right.StudentSchedulingAdmin));
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR, this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisor));
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_GUEST, user instanceof AnonymousUserContext);
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_RESET, ApplicationProperty.OnlineSchedulingAllowScheduleReset.isTrue());
            if (!check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_RESET) && (check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN) || check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR))) {
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_RESET, ApplicationProperty.OnlineSchedulingAllowScheduleResetIfAdmin.isTrue());
            }
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CONFIRM_DROP, ApplicationProperty.OnlineSchedulingConfirmCourseDrop.isTrue());
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.QUICK_ADD_DROP, ApplicationProperty.OnlineSchedulingQuickAddDrop.isTrue());
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.ALTERNATIVES_DROP, ApplicationProperty.OnlineSchedulingAlternativesDrop.isTrue());
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.GWT_CONFIRMATIONS, ApplicationProperty.OnlineSchedulingGWTConfirmations.isTrue());
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.DEGREE_PLANS, CustomDegreePlansHolder.hasProvider());
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.NO_REQUEST_ARROWS, ApplicationProperty.OnlineSchedulingNoRequestArrows.isTrue());
            check.setSessionId(sessionId);
            check.setStudentId(studentId);
            if (!sectioning) {
                Student student2;
                Student student3 = student2 = studentId == null ? null : (Student)StudentDAO.getInstance().get(studentId);
                if (student2 == null) {
                    if (!check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN) && !check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR)) {
                        check.setMessage(MSG.exceptionEnrollNotStudent(((Session)SessionDAO.getInstance().get(sessionId)).getLabel()));
                    }
                    return check;
                }
                StudentSectioningStatus status = student2.getSectioningStatus();
                if (status == null) {
                    status = student2.getSession().getDefaultSectioningStatus();
                }
                if (status == null) {
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_USE_ASSISTANT, true);
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST, true);
                } else {
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_USE_ASSISTANT, status.hasOption(StudentSectioningStatus.Option.enabled));
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER, status.hasOption(StudentSectioningStatus.Option.enrollment) || status.hasOption(StudentSectioningStatus.Option.admin) && check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN) || status.hasOption(StudentSectioningStatus.Option.advisor) && check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR));
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST, status.hasOption(StudentSectioningStatus.Option.waitlist));
                    check.setMessage(status.getMessage());
                }
                return check;
            }
            OnlineSectioningServer server = this.getServerInstance(sessionId, false);
            if (server == null) {
                return new OnlineSectioningInterface.EligibilityCheck(MSG.exceptionNoServerForSession(), new OnlineSectioningInterface.EligibilityCheck.EligibilityFlag[0]);
            }
            OnlineSectioningInterface.EligibilityCheck ret = server.execute(server.createAction(CheckEligibility.class).forStudent(studentId).withCheck(check).includeCustomCheck(includeCustomCheck), this.currentUser());
            if (includeCustomCheck) {
                this.getSessionContext().setAttribute("eligibility", (Object)ret);
            }
            return ret;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            return new OnlineSectioningInterface.EligibilityCheck(MSG.exceptionUnknown(e.getMessage()), new OnlineSectioningInterface.EligibilityCheck.EligibilityFlag[0]);
        }
    }

    public void destroy() throws Exception {
        CustomStudentEnrollmentHolder.release();
        CustomCourseRequestsHolder.release();
        CustomDegreePlansHolder.release();
    }

    @Override
    public OnlineSectioningInterface.SectioningProperties getProperties(Long sessionId) throws SectioningException, PageAccessException {
        OnlineSectioningInterface.SectioningProperties properties = new OnlineSectioningInterface.SectioningProperties();
        properties.setAdmin(this.getSessionContext().hasPermission(Right.StudentSchedulingAdmin));
        properties.setAdvisor(this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisor));
        if (sessionId == null && this.getSessionContext().getUser() != null) {
            sessionId = this.getSessionContext().getUser().getCurrentAcademicSessionId();
        }
        properties.setSessionId(sessionId);
        if (sessionId != null) {
            properties.setChangeLog(properties.isAdmin() && this.getServerInstance(sessionId, false) != null);
            properties.setMassCancel(this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingMassCancel));
            properties.setEmail(this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingEmailStudent));
            properties.setChangeStatus(this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingChangeStudentStatus));
            properties.setRequestUpdate(this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingRequestStudentUpdate));
        }
        return properties;
    }

    @Override
    public Boolean requestStudentUpdate(List<Long> studentIds) throws SectioningException, PageAccessException {
        OnlineSectioningServer server = this.getServerInstance(this.getStatusPageSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        this.getSessionContext().checkPermission(server.getAcademicSession(), Right.StudentSchedulingRequestStudentUpdate);
        return server.execute(server.createAction(RequestStudentUpdates.class).forStudents(studentIds), this.currentUser());
    }

    @Override
    public List<DegreePlanInterface> listDegreePlans(boolean online, Long sessionId, Long studentId) throws SectioningException, PageAccessException {
        if (sessionId == null) {
            sessionId = this.getLastSessionId();
        }
        if (studentId == null) {
            studentId = this.getStudentId(sessionId);
        } else if (!studentId.equals(this.getStudentId(sessionId))) {
            this.getSessionContext().checkPermission(Right.StudentSchedulingAdvisor);
        }
        OnlineSectioningServer server = null;
        if (!online) {
            server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
        } else {
            server = this.getServerInstance(sessionId, true);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
        }
        return server.execute(server.createAction(GetDegreePlans.class).forStudent(studentId), this.currentUser());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CourseMatcher
    extends AbstractCourseMatcher {
        private org.unitime.timetable.onlinesectioning.match.CourseMatcher iParent;
        private static final long serialVersionUID = 1L;
        private boolean iAllCourseTypes;
        private boolean iNoCourseType;
        private Set<String> iAllowedCourseTypes;

        public CourseMatcher(boolean allCourseTypes, boolean noCourseType, Set<String> allowedCourseTypes) {
            this.iAllCourseTypes = allCourseTypes;
            this.iNoCourseType = noCourseType;
            this.iAllowedCourseTypes = allowedCourseTypes;
        }

        public boolean isAllCourseTypes() {
            return this.iAllCourseTypes;
        }

        public boolean isNoCourseType() {
            return this.iNoCourseType;
        }

        public boolean hasAllowedCourseTypes() {
            return this.iAllowedCourseTypes != null && !this.iAllowedCourseTypes.isEmpty();
        }

        public Set<String> getAllowedCourseTypes() {
            return this.iAllowedCourseTypes;
        }

        public org.unitime.timetable.onlinesectioning.match.CourseMatcher getParentCourseMatcher() {
            return this.iParent;
        }

        public void setParentCourseMatcher(org.unitime.timetable.onlinesectioning.match.CourseMatcher parent) {
            this.iParent = parent;
        }

        @Override
        public boolean match(XCourseId course) {
            return course != null && course.matchType(this.iAllCourseTypes, this.iNoCourseType, this.iAllowedCourseTypes) && (this.iParent == null || this.iParent.match(course));
        }
    }
}

