/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.aria.client.Roles;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.aria.HasAriaLabel;

public class ImageLink
extends Widget
implements HasAriaLabel {
    private Image iImage;
    private String iUrl;
    private String iTarget;
    private SpanElement iElement;
    private AnchorElement iAnchor;
    private Element iImageElement = null;
    private SpanElement iTextElement = null;

    public ImageLink(Image img, String url) {
        this.initElements();
        this.setImage(img);
        this.setUrl(url);
    }

    public ImageLink() {
        this(null, "");
    }

    private void initElements() {
        this.iElement = Document.get().createSpanElement();
        this.iAnchor = Document.get().createAnchorElement();
        this.iElement.appendChild((Node)this.iAnchor);
        this.setElement((Element)this.iElement);
        this.sinkEvents(124);
        this.setTarget("_blank");
    }

    public void onBrowserEvent(Event event) {
        if (event.getTypeInt() == 16) {
            this.iAnchor.getStyle().setProperty("cursor", "hand");
        }
        super.onBrowserEvent(event);
    }

    public Image getImage() {
        return this.iImage;
    }

    public void setImage(Image img) {
        if (this.iImageElement != null) {
            this.iAnchor.removeChild((Node)this.iImageElement);
        }
        if (img == null) {
            return;
        }
        this.iImage = img;
        this.iImageElement = img.getElement();
        this.iImageElement.getStyle().setVerticalAlign(Style.VerticalAlign.MIDDLE);
        this.iAnchor.insertFirst((Node)this.iImageElement);
    }

    public String getUrl() {
        return this.iUrl;
    }

    public void setUrl(String url) {
        this.iUrl = url;
        this.iAnchor.setHref(url);
    }

    public String getTarget() {
        return this.iTarget;
    }

    public void setTarget(String target) {
        this.iTarget = target;
        this.iAnchor.setTarget(target);
    }

    public void setText(String text) {
        if (this.iTextElement == null) {
            this.iTextElement = Document.get().createSpanElement();
            this.iAnchor.appendChild((Node)this.iTextElement);
        }
        this.iTextElement.setInnerText(text);
    }

    public String getText() {
        return this.iTextElement == null ? null : this.iTextElement.getInnerText();
    }

    public String getAriaLabel() {
        return Roles.getLinkRole().getAriaLabelProperty((Element)this.iAnchor);
    }

    public void setAriaLabel(String text) {
        if (text == null || text.isEmpty()) {
            Roles.getLinkRole().removeAriaLabelledbyProperty((Element)this.iElement);
        } else {
            Roles.getLinkRole().setAriaLabelProperty((Element)this.iElement, text);
        }
    }
}

