/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;

public class ScheduleStatus
extends P {
    static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    private Level iLevel;
    private Image iImage;
    private P iMessage;

    public ScheduleStatus() {
        super("unitime-ScheduleStatus");
        this.setVisible(false);
        this.iImage = new Image();
        this.iImage.setStyleName("image");
        this.iMessage = new P("message");
        this.add((Widget)this.iImage);
        this.add((Widget)this.iMessage);
    }

    public void setMessage(Level level, String message) {
        if (this.iLevel != null) {
            this.removeStyleName(this.iLevel.getStyleName());
        }
        if (message == null || message.isEmpty()) {
            this.iLevel = null;
            this.iMessage.setHTML("");
            this.setVisible(false);
        } else {
            this.iLevel = level;
            this.addStyleName(this.iLevel.getStyleName());
            this.iMessage.setHTML(message);
            this.iImage.setResource(this.iLevel.getIcon());
            this.iImage.setAltText(message);
            this.setVisible(true);
        }
    }

    public Level getLevel() {
        return this.iLevel;
    }

    public String getMessage() {
        return this.iMessage.getHTML();
    }

    public void info(String message, boolean popup) {
        this.setMessage(Level.INFO, message);
        if (popup) {
            UniTimeNotifications.info(message);
        }
    }

    public void info(String message) {
        this.info(message, true);
    }

    public void warning(String message, boolean popup) {
        this.setMessage(Level.WARNING, message);
        if (popup) {
            UniTimeNotifications.warn(message);
        }
    }

    public void warning(String message) {
        this.warning(message, true);
    }

    public void error(String message, boolean popup) {
        this.setMessage(Level.ERROR, message);
        if (popup) {
            UniTimeNotifications.error(message);
        }
    }

    public void error(String message) {
        this.error(message, true);
    }

    public void error(String message, Throwable t) {
        this.setMessage(Level.ERROR, message);
        UniTimeNotifications.error(message, t);
    }

    public void error(Throwable t) {
        this.error(t.getMessage(), t);
    }

    public void clear() {
        this.setMessage(null, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        INFO("unitime-ScheduleMessage", RESOURCES.statusInfo()),
        WARNING("unitime-ScheduleWarningMessage", RESOURCES.statusWarning()),
        ERROR("unitime-ScheduleErrorMessage", RESOURCES.statusError());

        private String iStyleName;
        private ImageResource iIcon;

        private Level(String styleName, ImageResource icon) {
            this.iStyleName = styleName;
            this.iIcon = icon;
        }

        public String getStyleName() {
            return this.iStyleName;
        }

        public ImageResource getIcon() {
            return this.iIcon;
        }
    }
}

