/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.curricula;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.curricula.CurriculumCookie;
import org.unitime.timetable.gwt.client.curricula.CurriculumEdit;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.services.CurriculaService;
import org.unitime.timetable.gwt.services.CurriculaServiceAsync;
import org.unitime.timetable.gwt.shared.CurriculumInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseCurriculaTable
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    public static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private final CurriculaServiceAsync iCurriculaService = (CurriculaServiceAsync)GWT.create(CurriculaService.class);
    private SimpleForm iCurriculaPanel;
    private MyFlexTable iCurricula;
    private DialogBox iDialog;
    private CurriculumEdit iCurriculumEdit;
    private Label iHint;
    private AsyncCallback<TreeSet<CurriculumInterface>> iCourseCurriculaCallback = null;
    private TreeSet<CurriculumInterface.AcademicClassificationInterface> iClassifications = null;
    private TreeSet<CurriculumInterface.CourseInterface> iCourses = new TreeSet();
    private List<ChainedCommand> iRowClicks = new ArrayList<ChainedCommand>();
    private List<Integer> iRowTypes = new ArrayList<Integer>();
    private List<Long> iRowAreaId = new ArrayList<Long>();
    private Long iOfferingId = null;
    private String iCourseName = null;
    private boolean[] iUsed = null;
    private HashSet<Long> iExpandedAreas = new HashSet();
    private HashSet<Long> iAllAreas = new HashSet();
    private int iSelectedRow = -1;
    private boolean iEditable = true;
    private ClickHandler iMenu;
    private UniTimeHeaderPanel iHeader;
    private static int sRowTypeHeader = 0;
    private static int sRowTypeArea = 1;
    private static int sRowTypeCurriculum = 2;
    private static int sRowTypeOtherArea = 3;
    private static int sRowTypeOther = 4;
    private static int sRowTypeTotal = 5;

    public CourseCurriculaTable(boolean editable, final boolean showHeader) {
        this.iEditable = editable;
        this.iCurriculaPanel = new SimpleForm();
        this.iCurriculaPanel.removeStyleName("unitime-NotPrintableBottomLine");
        this.iMenu = new ClickHandler(){

            public void onClick(ClickEvent event) {
                PopupPanel popup = new PopupPanel(true);
                MenuBar menu = CourseCurriculaTable.this.createMenu(popup, showHeader);
                popup.add((Widget)menu);
                popup.showRelativeTo((UIObject)((Widget)event.getSource()));
                menu.focus();
            }
        };
        this.iHeader = new UniTimeHeaderPanel(showHeader ? MESSAGES.headerCurricula() : "");
        this.iHeader.setCollapsible(showHeader ? Boolean.valueOf(CurriculumCookie.getInstance().getCurriculaCoursesDetails()) : null);
        this.iHeader.setTitleStyleName("unitime3-HeaderTitle");
        if (showHeader) {
            this.iHeader.addButton("operations", MESSAGES.buttonCurriculaOperations(), null, this.iMenu);
            this.iHeader.setEnabled("operations", false);
            this.iHeader.getElement().getStyle().setMarginTop(10.0, Style.Unit.PX);
        }
        this.iHeader.addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                CurriculumCookie.getInstance().setCurriculaCoursesDetails((Boolean)event.getValue());
                if (CourseCurriculaTable.this.iCurricula.getRowCount() == 0) {
                    CourseCurriculaTable.this.refresh();
                } else if (CourseCurriculaTable.this.iCurricula.getRowCount() > 2) {
                    for (int row = 1; row < CourseCurriculaTable.this.iCurricula.getRowCount() - 1; ++row) {
                        int rowType = (Integer)CourseCurriculaTable.this.iRowTypes.get(row);
                        if (CurriculumCookie.getInstance().getCurriculaCoursesDetails() && (rowType == sRowTypeCurriculum || rowType == sRowTypeOtherArea)) continue;
                        CourseCurriculaTable.this.iCurricula.getRowFormatter().setVisible(row, CurriculumCookie.getInstance().getCurriculaCoursesDetails());
                    }
                    for (int col = 0; col < CourseCurriculaTable.this.iClassifications.size() + 2; ++col) {
                        CourseCurriculaTable.this.iCurricula.getCellFormatter().setStyleName(CourseCurriculaTable.this.iCurricula.getRowCount() - 1, col, CurriculumCookie.getInstance().getCurriculaCoursesDetails() ? "unitime-TotalRow" : null);
                    }
                }
            }
        });
        if (showHeader) {
            this.iCurriculaPanel.addHeaderRow((Widget)this.iHeader);
        }
        VerticalPanel tableAndHint = new VerticalPanel();
        this.iCurricula = new MyFlexTable();
        tableAndHint.add((Widget)this.iCurricula);
        this.iHint = new Label(MESSAGES.hintEnrollmentOfType(CurriculumCookie.getInstance().getCourseCurriculaTableType().getName()));
        this.iHint.setStyleName("unitime-Hint");
        this.iHint.setVisible(false);
        tableAndHint.add((Widget)this.iHint);
        tableAndHint.setCellHorizontalAlignment((Widget)this.iHint, HasHorizontalAlignment.ALIGN_RIGHT);
        this.iCurriculaPanel.addRow((Widget)tableAndHint);
        this.iHint.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                for (int i = 1; i < Type.values().length; ++i) {
                    Type type = Type.values()[(CurriculumCookie.getInstance().getCourseCurriculaTableType().ordinal() + i) % Type.values().length];
                    if (!CourseCurriculaTable.this.isAvailable(type)) continue;
                    CurriculumCookie.getInstance().setCourseCurriculaTableType(type);
                    break;
                }
                CourseCurriculaTable.this.iHint.setText(MESSAGES.hintEnrollmentOfType(CurriculumCookie.getInstance().getCourseCurriculaTableType().getName()));
                if (CourseCurriculaTable.this.iCurricula.getRowCount() > 1) {
                    for (int row = 1; row < CourseCurriculaTable.this.iCurricula.getRowCount(); ++row) {
                        for (int col = 0; col <= CourseCurriculaTable.this.iClassifications.size(); ++col) {
                            ((MyLabel)CourseCurriculaTable.this.iCurricula.getWidget(row, CourseCurriculaTable.this.getHeaderCols(row) + col)).refresh();
                        }
                    }
                    ((Label)CourseCurriculaTable.this.iCurricula.getWidget(CourseCurriculaTable.this.iCurricula.getRowCount() - 1, 0)).setText(MESSAGES.totalEnrollmentOfType(CurriculumCookie.getInstance().getCourseCurriculaTableType().getName()));
                }
            }
        });
        if (!showHeader) {
            this.iCurriculaPanel.addRow((Widget)this.iHeader);
        }
        this.initWidget((Widget)this.iCurriculaPanel);
    }

    private MenuBar createMenu(final PopupPanel popup, final boolean showHeader) {
        MenuBar menu = new MenuBar(true);
        MenuItem showHide = new MenuItem(CurriculumCookie.getInstance().getCurriculaCoursesDetails() ? MESSAGES.opHideDetails() : MESSAGES.opShowDetails(), true, (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                popup.hide();
                CurriculumCookie.getInstance().setCurriculaCoursesDetails(!CurriculumCookie.getInstance().getCurriculaCoursesDetails());
                CourseCurriculaTable.this.iHeader.setCollapsible(showHeader ? Boolean.valueOf(CurriculumCookie.getInstance().getCurriculaCoursesDetails()) : null);
                if (CourseCurriculaTable.this.iCurricula.getRowCount() > 2) {
                    for (int row = 1; row < CourseCurriculaTable.this.iCurricula.getRowCount() - 1; ++row) {
                        int rowType = (Integer)CourseCurriculaTable.this.iRowTypes.get(row);
                        if (CurriculumCookie.getInstance().getCurriculaCoursesDetails() && (rowType == sRowTypeCurriculum || rowType == sRowTypeOtherArea)) continue;
                        CourseCurriculaTable.this.iCurricula.getRowFormatter().setVisible(row, CurriculumCookie.getInstance().getCurriculaCoursesDetails());
                    }
                    for (int col = 0; col < CourseCurriculaTable.this.iClassifications.size() + 2; ++col) {
                        CourseCurriculaTable.this.iCurricula.getCellFormatter().setStyleName(CourseCurriculaTable.this.iCurricula.getRowCount() - 1, col, CurriculumCookie.getInstance().getCurriculaCoursesDetails() ? "unitime-TotalRow" : null);
                    }
                }
            }
        });
        showHide.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        menu.addItem(showHide);
        if (this.iCurricula.getRowCount() > 2 && CurriculumCookie.getInstance().getCurriculaCoursesDetails()) {
            boolean canExpand = false;
            int canCollapse = 0;
            for (int row = 1; row < this.iCurricula.getRowCount() - 1; ++row) {
                int rowType = this.iRowTypes.get(row);
                if (rowType != sRowTypeArea && rowType != sRowTypeOther) continue;
                if (this.iCurricula.getRowFormatter().isVisible(row)) {
                    canExpand = true;
                    continue;
                }
                canCollapse = 1;
            }
            if (canExpand) {
                MenuItem expandAll = new MenuItem(MESSAGES.opExpandAll(), true, (Scheduler.ScheduledCommand)new Command(){

                    public void execute() {
                        popup.hide();
                        for (int row = 1; row < CourseCurriculaTable.this.iCurricula.getRowCount() - 1; ++row) {
                            int rowType = (Integer)CourseCurriculaTable.this.iRowTypes.get(row);
                            boolean visible = rowType != sRowTypeArea && rowType != sRowTypeOther;
                            CourseCurriculaTable.this.iCurricula.getRowFormatter().setVisible(row, visible);
                            CourseCurriculaTable.this.iExpandedAreas.clear();
                            CourseCurriculaTable.this.iExpandedAreas.addAll(CourseCurriculaTable.this.iAllAreas);
                        }
                    }
                });
                expandAll.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                menu.addItem(expandAll);
            }
            if (canCollapse != 0) {
                MenuItem collapseAll = new MenuItem(MESSAGES.opCollapseAll(), true, (Scheduler.ScheduledCommand)new Command(){

                    public void execute() {
                        popup.hide();
                        for (int row = 1; row < CourseCurriculaTable.this.iCurricula.getRowCount() - 1; ++row) {
                            int rowType = (Integer)CourseCurriculaTable.this.iRowTypes.get(row);
                            boolean visible = rowType != sRowTypeCurriculum && rowType != sRowTypeOtherArea;
                            CourseCurriculaTable.this.iCurricula.getRowFormatter().setVisible(row, visible);
                            CourseCurriculaTable.this.iExpandedAreas.clear();
                        }
                    }
                });
                collapseAll.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                menu.addItem(collapseAll);
            }
        }
        menu.addSeparator();
        for (final Type t : Type.values()) {
            if (!this.isAvailable(t)) continue;
            MenuItem item = new MenuItem(MESSAGES.opShowEnrollmentByType(t.getName()), true, (Scheduler.ScheduledCommand)new Command(){

                public void execute() {
                    popup.hide();
                    CurriculumCookie.getInstance().setCourseCurriculaTableType(t);
                    CourseCurriculaTable.this.iHint.setText(MESSAGES.hintEnrollmentOfType(t.getName()));
                    if (CourseCurriculaTable.this.iCurricula.getRowCount() > 1) {
                        for (int row = 1; row < CourseCurriculaTable.this.iCurricula.getRowCount(); ++row) {
                            int hc = CourseCurriculaTable.this.getHeaderCols(row);
                            for (int col = 0; col <= CourseCurriculaTable.this.iClassifications.size(); ++col) {
                                ((MyLabel)CourseCurriculaTable.this.iCurricula.getWidget(row, hc + col)).refresh();
                            }
                        }
                        ((Label)CourseCurriculaTable.this.iCurricula.getWidget(CourseCurriculaTable.this.iCurricula.getRowCount() - 1, 0)).setText(MESSAGES.totalEnrollmentOfType(t.getName()));
                    }
                }
            });
            if (t == CurriculumCookie.getInstance().getCourseCurriculaTableType()) {
                item.getElement().getStyle().setColor("#666666");
            }
            item.getElement().getStyle().setCursor(Style.Cursor.POINTER);
            menu.addItem(item);
        }
        menu.addSeparator();
        MenuItem populateProjectedDemands = new MenuItem(MESSAGES.opPopulateCourseProjectedDemands(), true, (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                popup.hide();
                LoadingWidget.getInstance().show(MESSAGES.waitPopulateCourseProjectedDemands());
                CourseCurriculaTable.this.iCurriculaService.populateCourseProjectedDemands(false, CourseCurriculaTable.this.iOfferingId, new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                        CourseCurriculaTable.this.iHeader.setErrorMessage(MESSAGES.failedPopulateCourseProjectedDemands(caught.getMessage()));
                        UniTimeNotifications.error(MESSAGES.failedPopulateCourseProjectedDemands(caught.getMessage()), caught);
                        LoadingWidget.getInstance().hide();
                    }

                    public void onSuccess(Boolean result) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "instructionalOfferingDetail.do?io=" + CourseCurriculaTable.this.iOfferingId);
                    }
                });
            }
        });
        populateProjectedDemands.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        menu.addItem(populateProjectedDemands);
        MenuItem populateProjectedDemands2 = new MenuItem(MESSAGES.opPopulateCourseProjectedDemandsIncludeOther(), true, (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                popup.hide();
                LoadingWidget.getInstance().show(MESSAGES.waitPopulateCourseProjectedDemands());
                CourseCurriculaTable.this.iCurriculaService.populateCourseProjectedDemands(true, CourseCurriculaTable.this.iOfferingId, new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                        CourseCurriculaTable.this.iHeader.setErrorMessage(MESSAGES.failedPopulateCourseProjectedDemands(caught.getMessage()));
                        UniTimeNotifications.error(MESSAGES.failedPopulateCourseProjectedDemands(caught.getMessage()), caught);
                        LoadingWidget.getInstance().hide();
                    }

                    public void onSuccess(Boolean result) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "instructionalOfferingDetail.do?io=" + CourseCurriculaTable.this.iOfferingId);
                    }
                });
            }
        });
        populateProjectedDemands2.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        menu.addItem(populateProjectedDemands2);
        menu.setVisible(true);
        menu.setFocusOnHoverEnabled(true);
        return menu;
    }

    private void openDialog(final CurriculumInterface curriculum, final ConditionalCommand next) {
        if (this.iDialog == null) {
            this.iDialog = new UniTimeDialogBox(true, true);
            this.iCurriculumEdit = new CurriculumEdit(null);
            ScrollPanel panel = new ScrollPanel((Widget)this.iCurriculumEdit);
            panel.setStyleName("unitime-ScrollPanel");
            this.iDialog.setWidget((Widget)panel);
            this.iCurriculumEdit.addEditFinishedHandler(new CurriculumEdit.EditFinishedHandler(){

                public void onSave(CurriculumEdit.EditFinishedEvent evt) {
                    CourseCurriculaTable.this.iDialog.hide();
                    CourseCurriculaTable.this.refresh();
                }

                public void onDelete(CurriculumEdit.EditFinishedEvent evt) {
                    CourseCurriculaTable.this.iDialog.hide();
                    CourseCurriculaTable.this.refresh();
                }

                public void onBack(CurriculumEdit.EditFinishedEvent evt) {
                    if (CourseCurriculaTable.this.iSelectedRow >= 0) {
                        CourseCurriculaTable.this.iCurricula.getRowFormatter().setStyleName(CourseCurriculaTable.this.iSelectedRow, null);
                    }
                    CourseCurriculaTable.this.iDialog.hide();
                }
            });
            this.iCurriculumEdit.setupClassifications(this.iClassifications);
            this.iCurriculaService.loadAcademicAreas(new AsyncCallback<TreeSet<CurriculumInterface.AcademicAreaInterface>>(){

                public void onFailure(Throwable caught) {
                    CourseCurriculaTable.this.iHeader.setErrorMessage(MESSAGES.failedToLoadAcademicAreas(caught.getMessage()));
                    UniTimeNotifications.error(MESSAGES.failedToLoadAcademicAreas(caught.getMessage()), caught);
                    next.executeOnFailure();
                }

                public void onSuccess(TreeSet<CurriculumInterface.AcademicAreaInterface> result) {
                    CourseCurriculaTable.this.iCurriculumEdit.setupAreas(result);
                    CourseCurriculaTable.this.iCurriculaService.loadDepartments(new AsyncCallback<TreeSet<CurriculumInterface.DepartmentInterface>>(){

                        public void onFailure(Throwable caught) {
                            CourseCurriculaTable.this.iHeader.setErrorMessage(MESSAGES.failedToLoadDepartments(caught.getMessage()));
                            UniTimeNotifications.error(MESSAGES.failedToLoadDepartments(caught.getMessage()), caught);
                            next.executeOnFailure();
                        }

                        public void onSuccess(TreeSet<CurriculumInterface.DepartmentInterface> result) {
                            CourseCurriculaTable.this.iCurriculumEdit.setupDepartments(result);
                            CourseCurriculaTable.this.iDialog.setText(curriculum.getName());
                            CourseCurriculaTable.this.iCurriculumEdit.edit(curriculum, false);
                            CourseCurriculaTable.this.iCurriculumEdit.showOnlyCourses(CourseCurriculaTable.this.iCourses);
                            CourseCurriculaTable.this.iDialog.center();
                            next.executeOnSuccess();
                        }
                    });
                }
            });
        } else {
            this.iDialog.setText(curriculum.getName());
            this.iCurriculumEdit.edit(curriculum, false);
            this.iCurriculumEdit.showOnlyCourses(this.iCourses);
            this.iDialog.center();
            next.executeOnSuccess();
        }
        this.iCurriculumEdit.addEditFinishedHandler(new CurriculumEdit.EditFinishedHandler(){

            public void onSave(CurriculumEdit.EditFinishedEvent evt) {
                CourseCurriculaTable.this.refresh();
            }

            public void onDelete(CurriculumEdit.EditFinishedEvent evt) {
            }

            public void onBack(CurriculumEdit.EditFinishedEvent evt) {
            }
        });
    }

    protected void ensureInitialized(final AsyncCallback<Boolean> callback) {
        if (this.iClassifications != null) {
            callback.onSuccess((Object)true);
        }
        this.iCurriculaService.loadAcademicClassifications(new AsyncCallback<TreeSet<CurriculumInterface.AcademicClassificationInterface>>(){

            public void onSuccess(TreeSet<CurriculumInterface.AcademicClassificationInterface> result) {
                CourseCurriculaTable.this.iClassifications = result;
                if (callback != null) {
                    callback.onSuccess((Object)true);
                }
            }

            public void onFailure(Throwable caught) {
                CourseCurriculaTable.this.iHeader.setErrorMessage(MESSAGES.failedToLoadClassifications(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToLoadClassifications(caught.getMessage()), caught);
                if (callback != null) {
                    callback.onFailure(caught);
                }
            }
        });
    }

    public void clear(boolean loading) {
        for (int row = this.iCurricula.getRowCount() - 1; row >= 0; --row) {
            this.iCurricula.removeRow(row);
        }
        this.iCurricula.clear(true);
        if (loading) {
            this.iHeader.showLoading();
        } else {
            this.iHeader.clearMessage();
        }
        this.iHint.setVisible(false);
    }

    protected void populate(TreeSet<CurriculumInterface> curricula) {
        int r;
        int i;
        int tProj;
        int tEnrl;
        int col = 0;
        Label curriculumLabel = new Label(MESSAGES.colCurriculum(), false);
        curriculumLabel.addClickHandler(this.iMenu);
        this.iCurricula.setWidget(0, col, (Widget)curriculumLabel);
        this.iCurricula.getFlexCellFormatter().setStyleName(0, col, "unitime-ClickableTableHeader");
        this.iCurricula.getFlexCellFormatter().setWidth(0, col, "150px");
        Label areaLabel = new Label(MESSAGES.colAcademicArea(), false);
        areaLabel.addClickHandler(this.iMenu);
        this.iCurricula.setWidget(0, ++col, (Widget)areaLabel);
        this.iCurricula.getFlexCellFormatter().setStyleName(0, col, "unitime-ClickableTableHeader");
        this.iCurricula.getFlexCellFormatter().setWidth(0, col, "100px");
        Label majorLabel = new Label(MESSAGES.colMajors(), false);
        majorLabel.addClickHandler(this.iMenu);
        this.iCurricula.setWidget(0, ++col, (Widget)majorLabel);
        this.iCurricula.getFlexCellFormatter().setStyleName(0, col, "unitime-ClickableTableHeader");
        this.iCurricula.getFlexCellFormatter().setWidth(0, col, "100px");
        ++col;
        for (CurriculumInterface.AcademicClassificationInterface clasf : this.iClassifications) {
            Label clasfLabel = new Label(clasf.getCode());
            clasfLabel.addClickHandler(this.iMenu);
            this.iCurricula.setWidget(0, col, (Widget)clasfLabel);
            this.iCurricula.getFlexCellFormatter().setStyleName(0, col, "unitime-ClickableTableHeader");
            this.iCurricula.getFlexCellFormatter().setHorizontalAlignment(0, col, HasHorizontalAlignment.ALIGN_RIGHT);
            this.iCurricula.getFlexCellFormatter().setWidth(0, col, "75px");
            ++col;
        }
        Label totalLabel = new Label(MESSAGES.colTotal(), false);
        totalLabel.addClickHandler(this.iMenu);
        this.iCurricula.setWidget(0, col, (Widget)totalLabel);
        this.iCurricula.getFlexCellFormatter().setStyleName(0, col, "unitime-ClickableTableHeader");
        this.iCurricula.getFlexCellFormatter().setHorizontalAlignment(0, col, HasHorizontalAlignment.ALIGN_RIGHT);
        this.iCurricula.getFlexCellFormatter().setWidth(0, col, "75px");
        ++col;
        this.iCourses.clear();
        this.iRowClicks.clear();
        this.iRowClicks.add(null);
        this.iRowTypes.clear();
        this.iRowTypes.add(sRowTypeHeader);
        this.iRowAreaId.clear();
        this.iRowAreaId.add(-2L);
        int row = 0;
        ArrayList<CurriculumInterface> otherCurricula = new ArrayList<CurriculumInterface>();
        ArrayList<CurriculumInterface> lastArea = new ArrayList<CurriculumInterface>();
        this.iAllAreas.clear();
        this.iUsed = new boolean[this.iClassifications.size()];
        for (int i2 = 0; i2 < this.iUsed.length; ++i2) {
            this.iUsed[i2] = false;
        }
        int[][] total = new int[this.iClassifications.size()][];
        for (int i3 = 0; i3 < total.length; ++i3) {
            total[i3] = new int[]{0, 0, 0, 0, 0};
        }
        int[][] totalThisArea = new int[this.iClassifications.size()][];
        for (int i4 = 0; i4 < totalThisArea.length; ++i4) {
            totalThisArea[i4] = new int[]{0, 0, 0, 0, 0};
        }
        for (final CurriculumInterface curriculum : curricula) {
            for (CurriculumInterface.CourseInterface course : curriculum.getCourses()) {
                CurriculumInterface.CourseInterface cx = new CurriculumInterface.CourseInterface();
                cx.setId(course.getId());
                cx.setCourseName(course.getCourseName());
                this.iCourses.add(cx);
            }
            if (curriculum.getId() == null) {
                otherCurricula.add(curriculum);
                continue;
            }
            this.iAllAreas.add(curriculum.getAcademicArea().getId());
            if (lastArea.isEmpty() || ((CurriculumInterface)lastArea.get(0)).getAcademicArea().equals(curriculum.getAcademicArea())) {
                lastArea.add(curriculum);
            } else if (!lastArea.equals(curriculum.getAcademicArea())) {
                col = 0;
                this.iCurricula.getFlexCellFormatter().setColSpan(++row, col, 3);
                this.iCurricula.setWidget(row, col++, (Widget)new HTML("<i>" + ((CurriculumInterface)lastArea.get(0)).getAcademicArea().getAbbv() + " - " + ((CurriculumInterface)lastArea.get(0)).getAcademicArea().getName() + " (" + lastArea.size() + ")</i>", false));
                int tExp = 0;
                int tLast = 0;
                int tEnrl2 = 0;
                int tProj2 = 0;
                int tReq = 0;
                for (int clasfIdx = 0; clasfIdx < this.iClassifications.size(); ++clasfIdx) {
                    int exp = totalThisArea[clasfIdx][0];
                    int last = totalThisArea[clasfIdx][1];
                    int enrl = totalThisArea[clasfIdx][2];
                    int proj = totalThisArea[clasfIdx][3];
                    int req = totalThisArea[clasfIdx][4];
                    tExp += exp;
                    tLast += last;
                    tEnrl2 += enrl;
                    tProj2 += proj;
                    tReq += req;
                    this.iCurricula.setWidget(row, col, (Widget)new MyLabel(exp, enrl, last, proj, req));
                    this.iCurricula.getCellFormatter().setHorizontalAlignment(row, col, HasHorizontalAlignment.ALIGN_RIGHT);
                    ++col;
                }
                this.iCurricula.setWidget(row, col, (Widget)new MyLabel(tExp, tEnrl2, tLast, tProj2, tReq));
                this.iCurricula.getCellFormatter().setHorizontalAlignment(row, col, HasHorizontalAlignment.ALIGN_RIGHT);
                final int finalRow = row;
                final int lastAreas = lastArea.size();
                final Long lastAreaId = ((CurriculumInterface)lastArea.get(0)).getAcademicArea().getId();
                this.iRowClicks.add(new ChainedCommand(){

                    public void execute(ConditionalCommand next) {
                        CourseCurriculaTable.this.iExpandedAreas.add(lastAreaId);
                        CourseCurriculaTable.this.iCurricula.getRowFormatter().setVisible(finalRow, false);
                        for (int row = 1; row <= lastAreas; ++row) {
                            CourseCurriculaTable.this.iCurricula.getRowFormatter().setVisible(finalRow - row, true);
                        }
                        if (next != null) {
                            next.executeOnSuccess();
                        }
                    }

                    public String getLoadingMessage() {
                        return null;
                    }
                });
                this.iRowTypes.add(sRowTypeArea);
                this.iRowAreaId.add(lastAreaId);
                lastArea.clear();
                for (int i5 = 0; i5 < totalThisArea.length; ++i5) {
                    totalThisArea[i5] = new int[]{0, 0, 0, 0, 0};
                }
                lastArea.add(curriculum);
            }
            col = 0;
            this.iCurricula.setText(++row, col++, curriculum.getAbbv());
            this.iCurricula.setText(row, col++, curriculum.getAcademicArea().getAbbv());
            this.iCurricula.setText(row, col++, curriculum.getMajorCodes(", "));
            int clasfIdx = 0;
            int tExp = 0;
            int tLast = 0;
            tEnrl = 0;
            tProj = 0;
            int tReq = 0;
            for (CurriculumInterface.AcademicClassificationInterface clasf : this.iClassifications) {
                CurriculumInterface.CurriculumClassificationInterface f = null;
                for (CurriculumInterface.CurriculumClassificationInterface x : curriculum.getClassifications()) {
                    if (!x.getAcademicClassification().getId().equals(clasf.getId())) continue;
                    f = x;
                    break;
                }
                int exp = 0;
                int last = 0;
                int enrl = 0;
                int proj = 0;
                int req = 0;
                for (CurriculumInterface.CourseInterface course : curriculum.getCourses()) {
                    CurriculumInterface.CurriculumCourseInterface cx = course.getCurriculumCourse(clasfIdx);
                    if (cx == null) continue;
                    this.iUsed[clasfIdx] = true;
                    exp += f == null || f.getExpected() == null ? 0 : Math.round((float)f.getExpected().intValue() * cx.getDisplayedShare());
                    last += cx.getLastLike() == null ? 0 : cx.getLastLike();
                    enrl += cx.getEnrollment() == null ? 0 : cx.getEnrollment();
                    proj += cx.getProjection() == null ? 0 : cx.getProjection();
                    req += cx.getRequested() == null ? 0 : cx.getRequested();
                }
                int[] nArray = total[clasfIdx];
                nArray[0] = nArray[0] + exp;
                int[] nArray2 = total[clasfIdx];
                nArray2[1] = nArray2[1] + last;
                int[] nArray3 = total[clasfIdx];
                nArray3[2] = nArray3[2] + enrl;
                int[] nArray4 = total[clasfIdx];
                nArray4[3] = nArray4[3] + proj;
                int[] nArray5 = total[clasfIdx];
                nArray5[4] = nArray5[4] + req;
                int[] nArray6 = totalThisArea[clasfIdx];
                nArray6[0] = nArray6[0] + exp;
                int[] nArray7 = totalThisArea[clasfIdx];
                nArray7[1] = nArray7[1] + last;
                int[] nArray8 = totalThisArea[clasfIdx];
                nArray8[2] = nArray8[2] + enrl;
                int[] nArray9 = totalThisArea[clasfIdx];
                nArray9[3] = nArray9[3] + proj;
                int[] nArray10 = totalThisArea[clasfIdx];
                nArray10[4] = nArray10[4] + req;
                tExp += exp;
                tLast += last;
                tEnrl += enrl;
                tProj += proj;
                tReq += req;
                this.iCurricula.setWidget(row, col, (Widget)new MyLabel(exp, enrl, last, proj, req));
                this.iCurricula.getCellFormatter().setHorizontalAlignment(row, col, HasHorizontalAlignment.ALIGN_RIGHT);
                ++col;
                ++clasfIdx;
            }
            this.iCurricula.setWidget(row, col, (Widget)new MyLabel(tExp, tEnrl, tLast, tProj, tReq));
            this.iCurricula.getCellFormatter().setHorizontalAlignment(row, col, HasHorizontalAlignment.ALIGN_RIGHT);
            if (this.iEditable) {
                this.iRowClicks.add(new ChainedCommand(){

                    public void execute(final ConditionalCommand next) {
                        CourseCurriculaTable.this.iCurriculaService.loadCurriculum(curriculum.getId(), new AsyncCallback<CurriculumInterface>(){

                            public void onFailure(Throwable caught) {
                                CourseCurriculaTable.this.iHeader.setErrorMessage(MESSAGES.failedLoadDetails(curriculum.getAbbv(), caught.getMessage()));
                                UniTimeNotifications.error(MESSAGES.failedLoadDetails(curriculum.getAbbv(), caught.getMessage()), caught);
                                next.executeOnFailure();
                            }

                            public void onSuccess(CurriculumInterface result) {
                                CourseCurriculaTable.this.openDialog(result, next);
                            }
                        });
                    }

                    public String getLoadingMessage() {
                        return MESSAGES.waitLoadingDetailsOf(curriculum.getName());
                    }
                });
            } else {
                final Long lastAreaId = curriculum.getAcademicArea().getId();
                final int finalRow = row;
                this.iRowClicks.add(new ChainedCommand(){

                    public void execute(ConditionalCommand next) {
                        int row;
                        for (row = finalRow; row > 0 && (Integer)CourseCurriculaTable.this.iRowTypes.get(row) == sRowTypeCurriculum; --row) {
                            CourseCurriculaTable.this.iCurricula.getRowFormatter().setVisible(row, false);
                        }
                        row = finalRow + 1;
                        while ((Integer)CourseCurriculaTable.this.iRowTypes.get(row) == sRowTypeCurriculum) {
                            CourseCurriculaTable.this.iCurricula.getRowFormatter().setVisible(row, false);
                            ++row;
                        }
                        CourseCurriculaTable.this.iCurricula.getRowFormatter().setVisible(row, true);
                        CourseCurriculaTable.this.iExpandedAreas.remove(lastAreaId);
                        if (next != null) {
                            next.executeOnSuccess();
                        }
                    }

                    public String getLoadingMessage() {
                        return null;
                    }
                });
            }
            this.iRowTypes.add(sRowTypeCurriculum);
            this.iRowAreaId.add(curriculum.getAcademicArea().getId());
        }
        if (!lastArea.isEmpty()) {
            col = 0;
            this.iCurricula.getFlexCellFormatter().setColSpan(++row, col, 3);
            this.iCurricula.setWidget(row, col++, (Widget)new HTML("<i>" + ((CurriculumInterface)lastArea.get(0)).getAcademicArea().getAbbv() + " - " + ((CurriculumInterface)lastArea.get(0)).getAcademicArea().getName() + " (" + lastArea.size() + ")</i>", false));
            int tExp = 0;
            int tLast = 0;
            int tEnrl3 = 0;
            int tProj3 = 0;
            int tReq = 0;
            for (int clasfIdx = 0; clasfIdx < this.iClassifications.size(); ++clasfIdx) {
                int exp = totalThisArea[clasfIdx][0];
                int last = totalThisArea[clasfIdx][1];
                int enrl = totalThisArea[clasfIdx][2];
                int proj = totalThisArea[clasfIdx][3];
                int req = totalThisArea[clasfIdx][4];
                tExp += exp;
                tLast += last;
                tEnrl3 += enrl;
                tProj3 += proj;
                tReq += req;
                this.iCurricula.setWidget(row, col, (Widget)new MyLabel(exp, enrl, last, proj, req));
                this.iCurricula.getCellFormatter().setHorizontalAlignment(row, col, HasHorizontalAlignment.ALIGN_RIGHT);
                ++col;
            }
            this.iCurricula.setWidget(row, col, (Widget)new MyLabel(tExp, tEnrl3, tLast, tProj3, tReq));
            this.iCurricula.getCellFormatter().setHorizontalAlignment(row, col, HasHorizontalAlignment.ALIGN_RIGHT);
            final int finalRow = row;
            final int lastAreas = lastArea.size();
            final Long lastAreaId = ((CurriculumInterface)lastArea.get(0)).getAcademicArea().getId();
            this.iRowClicks.add(new ChainedCommand(){

                public void execute(ConditionalCommand next) {
                    CourseCurriculaTable.this.iExpandedAreas.add(lastAreaId);
                    CourseCurriculaTable.this.iCurricula.getRowFormatter().setVisible(finalRow, false);
                    for (int row = 1; row <= lastAreas; ++row) {
                        CourseCurriculaTable.this.iCurricula.getRowFormatter().setVisible(finalRow - row, true);
                    }
                    if (next != null) {
                        next.executeOnSuccess();
                    }
                }

                public String getLoadingMessage() {
                    return null;
                }
            });
            this.iRowTypes.add(sRowTypeArea);
            this.iRowAreaId.add(lastAreaId);
        }
        if (!otherCurricula.isEmpty()) {
            int[][] totalOther = new int[this.iClassifications.size()][];
            for (int i6 = 0; i6 < totalOther.length; ++i6) {
                totalOther[i6] = new int[]{0, 0, 0, 0, 0};
            }
            for (CurriculumInterface other : otherCurricula) {
                col = 0;
                this.iCurricula.getFlexCellFormatter().setColSpan(++row, col, 3);
                this.iCurricula.setHTML(row, col, "<i>" + other.getAbbv() + " - " + other.getName() + "</i>");
                this.iCurricula.getCellFormatter().setStyleName(row, col, "unitime-OtherRow");
                ++col;
                int tExp = 0;
                int tLast = 0;
                tEnrl = 0;
                tProj = 0;
                int tReq = 0;
                for (int clasfIdx = 0; clasfIdx < this.iClassifications.size(); ++clasfIdx) {
                    int exp = 0;
                    int last = 0;
                    int enrl = 0;
                    int proj = 0;
                    int req = 0;
                    for (CurriculumInterface.CourseInterface course : other.getCourses()) {
                        CurriculumInterface.CurriculumCourseInterface cx = course.getCurriculumCourse(clasfIdx);
                        if (cx == null) continue;
                        this.iUsed[clasfIdx] = true;
                        exp += 0;
                        last += cx.getLastLike() == null ? 0 : cx.getLastLike();
                        enrl += cx.getEnrollment() == null ? 0 : cx.getEnrollment();
                        proj += cx.getProjection() == null ? 0 : cx.getProjection();
                        req += cx.getRequested() == null ? 0 : cx.getRequested();
                    }
                    int[] nArray = total[clasfIdx];
                    nArray[0] = nArray[0] + exp;
                    int[] nArray11 = total[clasfIdx];
                    nArray11[1] = nArray11[1] + last;
                    int[] nArray12 = total[clasfIdx];
                    nArray12[2] = nArray12[2] + enrl;
                    int[] nArray13 = total[clasfIdx];
                    nArray13[3] = nArray13[3] + proj;
                    int[] nArray14 = total[clasfIdx];
                    nArray14[4] = nArray14[4] + req;
                    int[] nArray15 = totalOther[clasfIdx];
                    nArray15[0] = nArray15[0] + exp;
                    int[] nArray16 = totalOther[clasfIdx];
                    nArray16[1] = nArray16[1] + last;
                    int[] nArray17 = totalOther[clasfIdx];
                    nArray17[2] = nArray17[2] + enrl;
                    int[] nArray18 = totalOther[clasfIdx];
                    nArray18[3] = nArray18[3] + proj;
                    int[] nArray19 = totalOther[clasfIdx];
                    nArray19[4] = nArray19[4] + req;
                    tExp += exp;
                    tLast += last;
                    tEnrl += enrl;
                    tProj += proj;
                    tReq += req;
                    this.iCurricula.setWidget(row, col, (Widget)new MyLabel(exp, enrl, last, proj, req));
                    this.iCurricula.getCellFormatter().setHorizontalAlignment(row, col, HasHorizontalAlignment.ALIGN_RIGHT);
                    this.iCurricula.getCellFormatter().setStyleName(row, col, "unitime-OtherRow");
                    ++col;
                }
                this.iCurricula.setWidget(row, col, (Widget)new MyLabel(tExp, tEnrl, tLast, tProj, tReq));
                this.iCurricula.getCellFormatter().setHorizontalAlignment(row, col, HasHorizontalAlignment.ALIGN_RIGHT);
                this.iCurricula.getCellFormatter().setStyleName(row, col, "unitime-OtherRow");
                this.iRowTypes.add(sRowTypeOtherArea);
                this.iRowAreaId.add(-1L);
                final int finalRow = row;
                this.iRowClicks.add(new ChainedCommand(){

                    public void execute(ConditionalCommand next) {
                        int row;
                        for (row = finalRow; row > 0 && (Integer)CourseCurriculaTable.this.iRowTypes.get(row) == sRowTypeOtherArea; --row) {
                            CourseCurriculaTable.this.iCurricula.getRowFormatter().setVisible(row, false);
                        }
                        row = finalRow + 1;
                        while ((Integer)CourseCurriculaTable.this.iRowTypes.get(row) == sRowTypeOtherArea) {
                            CourseCurriculaTable.this.iCurricula.getRowFormatter().setVisible(row, false);
                            ++row;
                        }
                        CourseCurriculaTable.this.iCurricula.getRowFormatter().setVisible(row, true);
                        CourseCurriculaTable.this.iExpandedAreas.remove(-1L);
                        if (next != null) {
                            next.executeOnSuccess();
                        }
                    }

                    public String getLoadingMessage() {
                        return null;
                    }
                });
            }
            col = 0;
            this.iCurricula.getFlexCellFormatter().setColSpan(++row, col, 3);
            this.iCurricula.setWidget(row, col, (Widget)new HTML("<i>" + MESSAGES.colOtherStudents() + "</i>", false));
            this.iCurricula.getCellFormatter().setStyleName(row, col, "unitime-OtherRow");
            ++col;
            int tExp = 0;
            int tLast = 0;
            int tEnrl4 = 0;
            int tProj4 = 0;
            int tReq = 0;
            for (int clasfIdx = 0; clasfIdx < this.iClassifications.size(); ++clasfIdx) {
                int exp = totalOther[clasfIdx][0];
                int last = totalOther[clasfIdx][1];
                int enrl = totalOther[clasfIdx][2];
                int proj = totalOther[clasfIdx][3];
                int req = totalOther[clasfIdx][4];
                tExp += exp;
                tLast += last;
                tEnrl4 += enrl;
                tProj4 += proj;
                tReq += req;
                this.iCurricula.setWidget(row, col, (Widget)new MyLabel(exp, enrl, last, proj, req));
                this.iCurricula.getCellFormatter().setHorizontalAlignment(row, col, HasHorizontalAlignment.ALIGN_RIGHT);
                this.iCurricula.getCellFormatter().setStyleName(row, col, "unitime-OtherRow");
                ++col;
            }
            this.iCurricula.setWidget(row, col, (Widget)new MyLabel(tExp, tEnrl4, tLast, tProj4, tReq));
            this.iCurricula.getCellFormatter().setHorizontalAlignment(row, col, HasHorizontalAlignment.ALIGN_RIGHT);
            this.iCurricula.getCellFormatter().setStyleName(row, col, "unitime-OtherRow");
            final int finalRow = row;
            final int lastAreas = otherCurricula.size();
            this.iAllAreas.add(-1L);
            this.iRowClicks.add(new ChainedCommand(){

                public void execute(ConditionalCommand next) {
                    CourseCurriculaTable.this.iExpandedAreas.add(-1L);
                    CourseCurriculaTable.this.iCurricula.getRowFormatter().setVisible(finalRow, false);
                    for (int row = 1; row <= lastAreas; ++row) {
                        CourseCurriculaTable.this.iCurricula.getRowFormatter().setVisible(finalRow - row, true);
                    }
                    if (next != null) {
                        next.executeOnSuccess();
                    }
                }

                public String getLoadingMessage() {
                    return null;
                }
            });
            this.iRowTypes.add(sRowTypeOther);
            this.iRowAreaId.add(-1L);
        }
        col = 0;
        ++row;
        this.iRowClicks.add(new ChainedCommand(){

            public void execute(ConditionalCommand next) {
                CurriculumCookie.getInstance().setCurriculaCoursesDetails(!CurriculumCookie.getInstance().getCurriculaCoursesDetails());
                if (CourseCurriculaTable.this.iHeader.isCollapsible() != null) {
                    CourseCurriculaTable.this.iHeader.setCollapsible(CurriculumCookie.getInstance().getCurriculaCoursesDetails());
                }
                if (CourseCurriculaTable.this.iCurricula.getRowCount() > 2) {
                    for (int row = 1; row < CourseCurriculaTable.this.iCurricula.getRowCount() - 1; ++row) {
                        int rowType = (Integer)CourseCurriculaTable.this.iRowTypes.get(row);
                        if (CurriculumCookie.getInstance().getCurriculaCoursesDetails() && (rowType == sRowTypeCurriculum || rowType == sRowTypeOtherArea)) continue;
                        CourseCurriculaTable.this.iCurricula.getRowFormatter().setVisible(row, CurriculumCookie.getInstance().getCurriculaCoursesDetails());
                    }
                    for (int col = 0; col < CourseCurriculaTable.this.iClassifications.size() + 2; ++col) {
                        CourseCurriculaTable.this.iCurricula.getCellFormatter().setStyleName(CourseCurriculaTable.this.iCurricula.getRowCount() - 1, col, CurriculumCookie.getInstance().getCurriculaCoursesDetails() ? "unitime-TotalRow" : null);
                    }
                }
                if (next != null) {
                    next.executeOnSuccess();
                }
            }

            public String getLoadingMessage() {
                return null;
            }
        });
        this.iRowTypes.add(sRowTypeTotal);
        this.iRowAreaId.add(-3L);
        this.iCurricula.getFlexCellFormatter().setColSpan(row, col, 3);
        this.iCurricula.setWidget(row, col, (Widget)new Label(MESSAGES.totalEnrollmentOfType(CurriculumCookie.getInstance().getCourseCurriculaTableType().getName()), false));
        this.iCurricula.getCellFormatter().setStyleName(row, col, "unitime-TotalRow");
        ++col;
        for (int clasfIdx = 0; clasfIdx < this.iClassifications.size(); ++clasfIdx) {
            int exp = total[clasfIdx][0];
            int last = total[clasfIdx][1];
            int enrl = total[clasfIdx][2];
            int proj = total[clasfIdx][3];
            int req = total[clasfIdx][4];
            this.iCurricula.setWidget(row, col, (Widget)new MyLabel(exp, enrl, last, proj, req));
            this.iCurricula.getCellFormatter().setHorizontalAlignment(row, col, HasHorizontalAlignment.ALIGN_RIGHT);
            this.iCurricula.getCellFormatter().setStyleName(row, col, "unitime-TotalRow");
            ++col;
        }
        int[] tx = new int[]{0, 0, 0, 0, 0};
        for (i = 0; i < total.length; ++i) {
            for (int j = 0; j < 5; ++j) {
                int n = j;
                tx[n] = tx[n] + total[i][j];
            }
        }
        this.iCurricula.setWidget(row, col, (Widget)new MyLabel(tx[0], tx[2], tx[1], tx[3], tx[4]));
        this.iCurricula.getCellFormatter().setHorizontalAlignment(row, col, HasHorizontalAlignment.ALIGN_RIGHT);
        this.iCurricula.getCellFormatter().setStyleName(row, col, "unitime-TotalRow");
        if (!CurriculumCookie.getInstance().getCurriculaCoursesDetails()) {
            for (r = 1; r < this.iCurricula.getRowCount() - 1; ++r) {
                this.iCurricula.getRowFormatter().setVisible(r, false);
            }
            r = this.iCurricula.getRowCount() - 1;
            int hc = this.getHeaderCols(r);
            for (int c = 0; c < hc + this.iClassifications.size(); ++c) {
                this.iCurricula.getCellFormatter().setStyleName(r, c, null);
            }
        } else {
            for (r = 1; r < this.iCurricula.getRowCount() - 1; ++r) {
                boolean visible;
                int rowType = this.iRowTypes.get(r);
                boolean bl = visible = rowType != sRowTypeCurriculum && rowType != sRowTypeOtherArea;
                if (this.iExpandedAreas.contains(this.iRowAreaId.get(r))) {
                    visible = !visible;
                }
                this.iCurricula.getRowFormatter().setVisible(r, visible);
            }
        }
        for (i = 0; i < this.iUsed.length; ++i) {
            for (int r2 = 0; r2 < this.iCurricula.getRowCount(); ++r2) {
                if (this.iUsed[i]) continue;
                this.iCurricula.getCellFormatter().setVisible(r2, this.getHeaderCols(r2) + i, false);
            }
        }
        boolean typeChanged = false;
        Type type = CurriculumCookie.getInstance().getCourseCurriculaTableType();
        if (type == Type.EXP && tx[0] == 0) {
            if (tx[2] > 0) {
                type = Type.ENRL;
                typeChanged = true;
            } else if (tx[1] > 0) {
                type = Type.LAST;
                typeChanged = true;
            }
        }
        if (type == Type.ENRL && tx[2] == 0) {
            if (tx[0] > 0) {
                type = Type.EXP;
                typeChanged = true;
            } else if (tx[1] > 0) {
                type = Type.LAST;
                typeChanged = true;
            }
        }
        if (type == Type.LAST && tx[1] == 0) {
            if (tx[0] > 0) {
                type = Type.EXP;
                typeChanged = true;
            } else if (tx[2] > 0) {
                type = Type.ENRL;
                typeChanged = true;
            }
        }
        if (type == Type.PROJ && tx[3] == 0) {
            if (tx[0] > 0) {
                type = Type.EXP;
                typeChanged = true;
            } else if (tx[1] > 0) {
                type = Type.ENRL;
                typeChanged = true;
            } else if (tx[2] > 0) {
                type = Type.LAST;
                typeChanged = true;
            }
        }
        if (type == Type.REQ && tx[4] == 0) {
            if (tx[0] > 0) {
                type = Type.EXP;
                typeChanged = true;
            } else if (tx[1] > 0) {
                type = Type.ENRL;
                typeChanged = true;
            } else if (tx[2] > 0) {
                type = Type.LAST;
                typeChanged = true;
            } else if (tx[3] > 0) {
                type = Type.PROJ;
                typeChanged = true;
            }
        }
        if (typeChanged) {
            CurriculumCookie.getInstance().setCourseCurriculaTableType(type);
            this.iHint.setText(MESSAGES.hintEnrollmentOfType(type.getName()));
            if (this.iCurricula.getRowCount() > 1) {
                for (int r3 = 1; r3 < this.iCurricula.getRowCount(); ++r3) {
                    int hc = this.getHeaderCols(r3);
                    for (int c = 0; c <= this.iClassifications.size(); ++c) {
                        ((MyLabel)this.iCurricula.getWidget(r3, hc + c)).refresh();
                    }
                }
                ((Label)this.iCurricula.getWidget(this.iCurricula.getRowCount() - 1, 0)).setText(MESSAGES.totalEnrollmentOfType(type.getName()));
            }
        }
        this.iHeader.clearMessage();
        this.iHeader.setEnabled("operations", true);
        this.iHint.setVisible(true);
    }

    private int getHeaderCols(int row) {
        int col = 0;
        int left = 3;
        while (left > 0) {
            left -= this.iCurricula.getFlexCellFormatter().getColSpan(row, col);
            ++col;
        }
        return col;
    }

    private void initCallbacks() {
        if (this.iCourseCurriculaCallback == null) {
            this.iCourseCurriculaCallback = new AsyncCallback<TreeSet<CurriculumInterface>>(){

                public void onFailure(Throwable caught) {
                    CourseCurriculaTable.this.iHeader.setErrorMessage(MESSAGES.failedToLoadCurricula(caught.getMessage()));
                    UniTimeNotifications.error(MESSAGES.failedToLoadCurricula(caught.getMessage()), caught);
                    CourseCurriculaTable.this.iHeader.setCollapsible(null);
                    CurriculumCookie.getInstance().setCurriculaCoursesDetails(false);
                }

                public void onSuccess(TreeSet<CurriculumInterface> result) {
                    if (result.isEmpty()) {
                        CourseCurriculaTable.this.iHeader.setMessage(MESSAGES.offeringHasNoCurricula());
                        CourseCurriculaTable.this.iHeader.setEnabled("operations", false);
                        CourseCurriculaTable.this.iHeader.setCollapsible(null);
                    } else {
                        CourseCurriculaTable.this.iHeader.clearMessage();
                        CourseCurriculaTable.this.iHeader.setEnabled("operations", true);
                        CourseCurriculaTable.this.populate(result);
                    }
                }
            };
        }
    }

    public void refresh() {
        this.ensureInitialized(new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Boolean result) {
                CourseCurriculaTable.this.clear(true);
                if (CourseCurriculaTable.this.iOfferingId != null) {
                    CourseCurriculaTable.this.iCurriculaService.findCurriculaForAnInstructionalOffering(CourseCurriculaTable.this.iOfferingId, (AsyncCallback<TreeSet<CurriculumInterface>>)CourseCurriculaTable.this.iCourseCurriculaCallback);
                } else {
                    CourseCurriculaTable.this.iCurriculaService.findCurriculaForACourse(CourseCurriculaTable.this.iCourseName, (AsyncCallback<TreeSet<CurriculumInterface>>)CourseCurriculaTable.this.iCourseCurriculaCallback);
                }
            }
        });
    }

    public void insert(RootPanel panel) {
        this.initCallbacks();
        this.iOfferingId = Long.valueOf(panel.getElement().getInnerText());
        this.iCourseName = null;
        if (CurriculumCookie.getInstance().getCurriculaCoursesDetails()) {
            this.refresh();
        } else {
            this.iHeader.clearMessage();
            this.iHeader.setCollapsible(false);
        }
        panel.getElement().setInnerText(null);
        panel.add((Widget)this);
        panel.setVisible(true);
    }

    public void setCourseName(String courseName) {
        this.initCallbacks();
        this.iOfferingId = null;
        this.iCourseName = courseName;
        this.refresh();
    }

    public boolean isAvailable(Type type) {
        MyLabel label = (MyLabel)this.iCurricula.getWidget(this.iCurricula.getRowCount() - 1, this.iCurricula.getCellCount(this.iCurricula.getRowCount() - 1) - 1);
        switch (type) {
            case EXP: {
                return label.getExpected() > 0;
            }
            case ENRL: {
                return label.getEnrolled() > 0;
            }
            case LAST: {
                return label.getLastLike() > 0;
            }
            case PROJ: {
                return label.getProjected() > 0;
            }
            case EXP2LAST: {
                return label.getExpected() > 0 && label.getLastLike() > 0;
            }
            case EXP2ENRL: {
                return label.getExpected() > 0 && label.getEnrolled() > 0;
            }
            case EXP2PROJ: {
                return label.getExpected() > 0 && label.getProjected() > 0;
            }
            case LAST2ENRL: {
                return label.getLastLike() > 0 && label.getEnrolled() > 0;
            }
            case PROJ2ENRL: {
                return label.getProjected() > 0 && label.getEnrolled() > 0;
            }
            case REQ: {
                return label.getRequested() > 0;
            }
            case EXP2REQ: {
                return label.getExpected() > 0 && label.getRequested() > 0;
            }
            case ENRL2REQ: {
                return label.getEnrolled() > 0 && label.getRequested() > 0;
            }
            case LAST2REQ: {
                return label.getLastLike() > 0 && label.getRequested() > 0;
            }
            case PROJ2REQ: {
                return label.getProjected() > 0 && label.getRequested() > 0;
            }
        }
        return false;
    }

    public void setMessage(String message) {
        this.iHeader.setMessage(message);
    }

    public static interface ConditionalCommand {
        public void executeOnSuccess();

        public void executeOnFailure();
    }

    public static interface ChainedCommand {
        public void execute(ConditionalCommand var1);

        public String getLoadingMessage();
    }

    public class MyFlexTable
    extends FlexTable {
        public MyFlexTable() {
            this.sinkEvents(16);
            this.sinkEvents(32);
            this.sinkEvents(1);
            this.setCellPadding(2);
            this.setCellSpacing(0);
        }

        public void onBrowserEvent(Event event) {
            com.google.gwt.user.client.Element td = this.getEventTargetCell(event);
            if (td == null) {
                return;
            }
            com.google.gwt.user.client.Element tr = DOM.getParent((Element)td);
            com.google.gwt.user.client.Element body = DOM.getParent((Element)tr);
            final int row = DOM.getChildIndex((Element)body, (Element)tr);
            final ChainedCommand command = (ChainedCommand)CourseCurriculaTable.this.iRowClicks.get(row);
            switch (DOM.eventGetType((Event)event)) {
                case 16: {
                    this.getRowFormatter().setStyleName(row, "unitime-TableRowHover");
                    if (command != null) break;
                    this.getRowFormatter().getElement(row).getStyle().setCursor(Style.Cursor.AUTO);
                    break;
                }
                case 32: {
                    this.getRowFormatter().setStyleName(row, null);
                    break;
                }
                case 1: {
                    if (command == null) break;
                    if (command.getLoadingMessage() != null) {
                        LoadingWidget.getInstance().show(command.getLoadingMessage());
                    }
                    this.getRowFormatter().setStyleName(row, "unitime-TableRowSelected");
                    CourseCurriculaTable.this.iSelectedRow = row;
                    command.execute(new ConditionalCommand(){

                        public void executeOnSuccess() {
                            if (command.getLoadingMessage() != null) {
                                LoadingWidget.getInstance().hide();
                            }
                        }

                        public void executeOnFailure() {
                            MyFlexTable.this.getRowFormatter().setStyleName(row, "unitime-TableRowHover");
                            if (command.getLoadingMessage() != null) {
                                LoadingWidget.getInstance().hide();
                            }
                        }
                    });
                }
            }
        }
    }

    public class MyLabel
    extends HTML {
        private int iExp;
        private int iLast;
        private int iEnrl;
        private int iProj;
        private int iReq;

        public MyLabel(int exp, int enrl, int last, int proj, int req) {
            super("&nbsp;", false);
            this.iExp = exp;
            this.iLast = last;
            this.iEnrl = enrl;
            this.iProj = proj;
            this.iReq = req;
            this.refresh();
        }

        public int getExpected() {
            return this.iExp;
        }

        public int getLastLike() {
            return this.iLast;
        }

        public int getEnrolled() {
            return this.iEnrl;
        }

        public int getProjected() {
            return this.iProj;
        }

        public int getRequested() {
            return this.iReq;
        }

        public void showExpected() {
            this.setHTML(this.iExp > 0 ? String.valueOf(this.iExp) : "&nbsp;");
        }

        public void showEnrolled() {
            this.setHTML(this.iEnrl > 0 ? String.valueOf(this.iEnrl) : "&nbsp;");
        }

        public void showLastLike() {
            this.setHTML(this.iLast > 0 ? String.valueOf(this.iLast) : "&nbsp;");
        }

        public void showProjected() {
            this.setHTML(this.iProj > 0 ? String.valueOf(this.iProj) : "&nbsp;");
        }

        public void showRequested() {
            this.setHTML(this.iReq > 0 ? String.valueOf(this.iReq) : "&nbsp;");
        }

        public void showExpectedEnrolled() {
            if (this.iExp > 0 || this.iEnrl > 0) {
                this.setHTML((this.iExp > 0 ? String.valueOf(this.iExp) : "-") + " / " + (this.iEnrl > 0 ? String.valueOf(this.iEnrl) : "-"));
            } else {
                this.setHTML("&nbsp;");
            }
        }

        public void showExpectedLastLike() {
            if (this.iExp > 0 || this.iLast > 0) {
                this.setHTML((this.iExp > 0 ? String.valueOf(this.iExp) : "-") + " / " + (this.iLast > 0 ? String.valueOf(this.iLast) : "-"));
            } else {
                this.setHTML("&nbsp;");
            }
        }

        public void showExpectedProjected() {
            if (this.iExp > 0 || this.iProj > 0) {
                this.setHTML((this.iExp > 0 ? String.valueOf(this.iExp) : "-") + " / " + (this.iProj > 0 ? String.valueOf(this.iProj) : "-"));
            } else {
                this.setHTML("&nbsp;");
            }
        }

        public void showLastLikeEnrolled() {
            if (this.iLast > 0 || this.iEnrl > 0) {
                this.setHTML((this.iLast > 0 ? String.valueOf(this.iLast) : "-") + " / " + (this.iEnrl > 0 ? String.valueOf(this.iEnrl) : "-"));
            } else {
                this.setHTML("&nbsp;");
            }
        }

        public void showProjectedEnrolled() {
            if (this.iProj > 0 || this.iEnrl > 0) {
                this.setHTML((this.iProj > 0 ? String.valueOf(this.iProj) : "-") + " / " + (this.iEnrl > 0 ? String.valueOf(this.iEnrl) : "-"));
            } else {
                this.setHTML("&nbsp;");
            }
        }

        public void showExpectedRequested() {
            if (this.iExp > 0 || this.iReq > 0) {
                this.setHTML((this.iExp > 0 ? String.valueOf(this.iExp) : "-") + " / " + (this.iReq > 0 ? String.valueOf(this.iReq) : "-"));
            } else {
                this.setHTML("&nbsp;");
            }
        }

        public void showLastLikeRequested() {
            if (this.iLast > 0 || this.iReq > 0) {
                this.setHTML((this.iLast > 0 ? String.valueOf(this.iLast) : "-") + " / " + (this.iReq > 0 ? String.valueOf(this.iReq) : "-"));
            } else {
                this.setHTML("&nbsp;");
            }
        }

        public void showProjectedRequested() {
            if (this.iProj > 0 || this.iReq > 0) {
                this.setHTML((this.iProj > 0 ? String.valueOf(this.iProj) : "-") + " / " + (this.iReq > 0 ? String.valueOf(this.iReq) : "-"));
            } else {
                this.setHTML("&nbsp;");
            }
        }

        public void showEnrolledRequested() {
            if (this.iEnrl > 0 || this.iReq > 0) {
                this.setHTML((this.iEnrl > 0 ? String.valueOf(this.iEnrl) : "-") + " / " + (this.iReq > 0 ? String.valueOf(this.iReq) : "-"));
            } else {
                this.setHTML("&nbsp;");
            }
        }

        public void refresh() {
            switch (CurriculumCookie.getInstance().getCourseCurriculaTableType()) {
                case EXP: {
                    this.showExpected();
                    break;
                }
                case ENRL: {
                    this.showEnrolled();
                    break;
                }
                case LAST: {
                    this.showLastLike();
                    break;
                }
                case PROJ: {
                    this.showProjected();
                    break;
                }
                case EXP2LAST: {
                    this.showExpectedLastLike();
                    break;
                }
                case EXP2ENRL: {
                    this.showExpectedEnrolled();
                    break;
                }
                case EXP2PROJ: {
                    this.showExpectedProjected();
                    break;
                }
                case LAST2ENRL: {
                    this.showLastLikeEnrolled();
                    break;
                }
                case PROJ2ENRL: {
                    this.showProjectedEnrolled();
                    break;
                }
                case REQ: {
                    this.showRequested();
                    break;
                }
                case EXP2REQ: {
                    this.showExpectedRequested();
                    break;
                }
                case ENRL2REQ: {
                    this.showEnrolledRequested();
                    break;
                }
                case LAST2REQ: {
                    this.showLastLikeRequested();
                    break;
                }
                case PROJ2REQ: {
                    this.showProjectedRequested();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        EXP(MESSAGES.shortRequestedEnrollment()),
        ENRL(MESSAGES.shortCurrentEnrollment()),
        LAST(MESSAGES.shortLastLikeEnrollment()),
        PROJ(MESSAGES.shortProjectedByRule()),
        REQ(MESSAGES.shortCourseRequests()),
        EXP2ENRL(MESSAGES.shortRequestedEnrollment() + " / " + MESSAGES.shortCurrentEnrollment()),
        EXP2LAST(MESSAGES.shortRequestedEnrollment() + " / " + MESSAGES.shortLastLikeEnrollment()),
        EXP2PROJ(MESSAGES.shortRequestedEnrollment() + " / " + MESSAGES.shortProjectedByRule()),
        LAST2ENRL(MESSAGES.shortLastLikeEnrollment() + " / " + MESSAGES.shortCurrentEnrollment()),
        PROJ2ENRL(MESSAGES.shortProjectedByRule() + " / " + MESSAGES.shortCurrentEnrollment()),
        EXP2REQ(MESSAGES.shortRequestedEnrollment() + " / " + MESSAGES.shortCourseRequests()),
        LAST2REQ(MESSAGES.shortLastLikeEnrollment() + " / " + MESSAGES.shortCourseRequests()),
        PROJ2REQ(MESSAGES.shortProjectedByRule() + " / " + MESSAGES.shortCourseRequests()),
        ENRL2REQ(MESSAGES.shortCurrentEnrollment() + " / " + MESSAGES.shortCourseRequests());

        private String iName;

        private Type(String name) {
            this.iName = name;
        }

        public String getName() {
            return this.iName;
        }
    }
}

