/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.Collection;
import java.util.Hashtable;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.reports.enrollment.EnrollmentsViolatingCourseStructureAuditReport;
import org.unitime.timetable.reports.enrollment.MissingCourseEnrollmentsAuditReport;
import org.unitime.timetable.reports.enrollment.MultipleCourseEnrollmentsAuditReport;
import org.unitime.timetable.security.SessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnrollmentAuditPdfReportForm
extends ActionForm {
    private static final long serialVersionUID = -4537752846296511516L;
    protected static Logger sLog = Logger.getLogger(EnrollmentAuditPdfReportForm.class);
    private String iOp = null;
    private Long iSubjectArea = null;
    private Collection iSubjectAreas = null;
    private String[] iReports = null;
    private String iMode = null;
    private boolean iAll = false;
    private String[] iSubjects = null;
    private boolean iExternalId = false;
    private boolean iStudentName = false;
    private boolean iEmail = false;
    private String iAddr;
    private String iCc;
    private String iBcc = null;
    private String iReport = null;
    private String iMessage = null;
    private String iSubject = null;
    public static Hashtable<String, Class> sRegisteredReports = new Hashtable();
    public static String[] sModes = new String[]{"PDF (Letter)", "PDF (Ledger)", "Text"};
    public static int sDeliveryDownload = 0;
    public static int sDeliveryEmail = 1;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.iReports == null || this.iReports.length == 0) {
            errors.add("reports", new ActionMessage("errors.generic", (Object)"No report selected."));
        }
        if (!(this.iAll || this.iSubjects != null && this.iSubjects.length != 0)) {
            errors.add("subjects", new ActionMessage("errors.generic", (Object)"No subject area selected."));
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.iOp = null;
        this.iReports = null;
        this.iMode = sModes[0];
        this.iAll = false;
        this.iEmail = false;
        this.iExternalId = false;
        this.iStudentName = false;
        this.iAddr = null;
        this.iCc = null;
        this.iBcc = null;
        this.iSubject = "Enrollment Audit Report";
        this.iMessage = null;
        this.iReport = null;
    }

    public void load(SessionContext context) {
        this.setSubjectArea(context.getAttribute("EnrollmentAuditPdfReport.subjectArea") == null ? null : (Long)context.getAttribute("EnrollmentAuditPdfReport.subjectArea"));
        try {
            this.iSubjectAreas = new TreeSet(new SubjectAreaDAO().getSession().createQuery("select distinct co.subjectArea from CourseOffering co where co.subjectArea.session.uniqueId=:sessionId").setLong("sessionId", context.getUser().getCurrentAcademicSessionId().longValue()).setCacheable(true).list());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setAll(context.getAttribute("EnrollmentAuditPdfReport.all") == null ? true : (Boolean)context.getAttribute("EnrollmentAuditPdfReport.all"));
        this.setReports((String[])context.getAttribute("EnrollmentAuditPdfReport.reports"));
        this.setMode(context.getAttribute("EnrollmentAuditPdfReport.mode") == null ? sModes[0] : (String)context.getAttribute("EnrollmentAuditPdfReport.mode"));
        this.setSubjects((String[])context.getAttribute("EnrollmentAuditPdfReport.subjects"));
        this.setExternalId("1".equals(context.getUser().getProperty("EnrollmentAuditPdfReport.externalId", "0")));
        this.setStudentName("1".equals(context.getUser().getProperty("EnrollmentAuditPdfReport.studentName", "0")));
        this.setEmail("1".equals(context.getUser().getProperty("EnrollmentAuditPdfReport.email", "0")));
        this.setAddress(context.getUser().getProperty("EnrollmentAuditPdfReport.addr", context.getUser().getEmail()));
        this.setCc(context.getUser().getProperty("EnrollmentAuditPdfReport.cc"));
        this.setBcc(context.getUser().getProperty("EnrollmentAuditPdfReport.bcc"));
        this.setMessage(context.getUser().getProperty("EnrollmentAuditPdfReport.message"));
        this.setSubject(context.getUser().getProperty("EnrollmentAuditPdfReport.subject", "Enrollment Audit"));
    }

    public void save(SessionContext context) {
        context.setAttribute("EnrollmentAuditPdfReport.reports.subjectArea", (Object)this.getSubjectArea());
        context.setAttribute("EnrollmentAuditPdfReport.reports", (Object)this.getReports());
        context.setAttribute("EnrollmentAuditPdfReport.mode", (Object)this.getMode());
        context.setAttribute("EnrollmentAuditPdfReport.all", (Object)this.getAll());
        context.setAttribute("EnrollmentAuditPdfReport.subjects", (Object)this.getSubjects());
        context.getUser().setProperty("EnrollmentAuditPdfReport.externalId", this.getExternalId() ? "1" : "0");
        context.getUser().setProperty("EnrollmentAuditPdfReport.studentName", this.getStudentName() ? "1" : "0");
        context.getUser().setProperty("EnrollmentAuditPdfReport.email", this.getEmail() ? "1" : "0");
        context.getUser().setProperty("EnrollmentAuditPdfReport.addr", this.getAddress());
        context.getUser().setProperty("EnrollmentAuditPdfReport.cc", this.getCc());
        context.getUser().setProperty("EnrollmentAuditPdfReport.bcc", this.getBcc());
        context.getUser().setProperty("EnrollmentAuditPdfReport.message", this.getMessage());
        context.getUser().setProperty("EnrollmentAuditPdfReport.subject", this.getSubject());
    }

    public String[] getReports() {
        return this.iReports;
    }

    public void setReports(String[] reports) {
        this.iReports = reports;
    }

    public String getMode() {
        return this.iMode;
    }

    public void setMode(String mode) {
        this.iMode = mode;
    }

    public int getModeIdx() {
        for (int i = 0; i < sModes.length; ++i) {
            if (!sModes[i].equals(this.iMode)) continue;
            return i;
        }
        return 0;
    }

    public boolean getAll() {
        return this.iAll;
    }

    public void setAll(boolean all) {
        this.iAll = all;
    }

    public String[] getSubjects() {
        return this.iSubjects;
    }

    public void setSubjects(String[] subjects) {
        this.iSubjects = subjects;
    }

    public boolean getEmail() {
        return this.iEmail;
    }

    public void setEmail(boolean email) {
        this.iEmail = email;
    }

    public String getAddress() {
        return this.iAddr;
    }

    public void setAddress(String addr) {
        this.iAddr = addr;
    }

    public String getCc() {
        return this.iCc;
    }

    public void setCc(String cc) {
        this.iCc = cc;
    }

    public String getBcc() {
        return this.iBcc;
    }

    public void setBcc(String bcc) {
        this.iBcc = bcc;
    }

    public boolean getCanEmail() {
        return true;
    }

    public String getReport() {
        return this.iReport;
    }

    public void setReport(String report) {
        this.iReport = report;
    }

    public void log(String message) {
        sLog.info((Object)message);
        this.iReport = this.iReport + message + "<br>";
    }

    public String getMessage() {
        return this.iMessage;
    }

    public void setMessage(String message) {
        this.iMessage = message;
    }

    public String getSubject() {
        return this.iSubject;
    }

    public void setSubject(String subject) {
        this.iSubject = subject;
    }

    public TreeSet<String> getAllReports() {
        return new TreeSet<String>(sRegisteredReports.keySet());
    }

    public String[] getModes() {
        return sModes;
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public Long getSubjectArea() {
        return this.iSubjectArea;
    }

    public void setSubjectArea(Long subjectArea) {
        this.iSubjectArea = subjectArea;
    }

    public Collection getSubjectAreas() {
        return this.iSubjectAreas;
    }

    public void setSubjectAreas(Collection subjectAreas) {
        this.iSubjectAreas = subjectAreas;
    }

    public boolean getExternalId() {
        return this.iExternalId;
    }

    public void setExternalId(boolean externalId) {
        this.iExternalId = externalId;
    }

    public boolean getStudentName() {
        return this.iStudentName;
    }

    public void setStudentName(boolean studentName) {
        this.iStudentName = studentName;
    }

    static {
        sRegisteredReports.put("Enrollments Violating Course Structure", EnrollmentsViolatingCourseStructureAuditReport.class);
        sRegisteredReports.put("Missing Course Enrollments", MissingCourseEnrollmentsAuditReport.class);
        sRegisteredReports.put("Multiple Course Enrollments", MultipleCourseEnrollmentsAuditReport.class);
    }
}

