/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.Session;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.AcademicAreaClassification;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseEvent;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.ExamEvent;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseCourseDemand;
import org.unitime.timetable.model.base.BaseCourseRequest;
import org.unitime.timetable.model.dao.ClassEventDAO;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseEventDAO;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.model.dao.ExamEventDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=EventInterface.EventEnrollmentsRpcRequest.class)
public class EventEnrollmentsBackend
extends EventAction<EventInterface.EventEnrollmentsRpcRequest, GwtRpcResponseList<ClassAssignmentInterface.Enrollment>> {
    @Override
    public GwtRpcResponseList<ClassAssignmentInterface.Enrollment> execute(EventInterface.EventEnrollmentsRpcRequest request, EventAction.EventContext context) {
        if (request.hasRelatedObjects()) {
            context.checkPermission(Right.EventAddCourseRelated);
            HashMap<Long, List<Meeting>> conflicts = null;
            HashSet<StudentClassEnrollment> enrollments = new HashSet<StudentClassEnrollment>();
            for (EventInterface.RelatedObjectInterface related : request.getRelatedObjects()) {
                enrollments.addAll(EventEnrollmentsBackend.getStudentClassEnrollments(related));
                if (!request.hasMeetings()) continue;
                conflicts = new HashMap<Long, List<Meeting>>();
                for (EventInterface.MeetingInterface meeting : request.getMeetings()) {
                    if (meeting.getApprovalStatus() != EventInterface.ApprovalStatus.Approved && meeting.getApprovalStatus() != EventInterface.ApprovalStatus.Pending) continue;
                    EventEnrollmentsBackend.computeConflicts(conflicts, meeting, related, request.getEventId());
                }
            }
            return EventEnrollmentsBackend.convert(enrollments, conflicts, context.hasPermission(Right.EnrollmentsShowExternalId), context.hasPermission(Right.CourseRequests), context.hasPermission(Right.SchedulingAssistant));
        }
        if (request.hasEventId()) {
            Session hibSession = EventDAO.getInstance().getSession();
            Event event = (Event)EventDAO.getInstance().get(request.getEventId());
            if (event == null) {
                Class_ clazz;
                if (request.getEventId() < 0L && (clazz = (Class_)Class_DAO.getInstance().get(-request.getEventId().longValue())) != null) {
                    Set<StudentClassEnrollment> enrollments;
                    if (!context.hasPermission(clazz, Right.ClassDetail)) {
                        context.checkPermission(clazz, Right.EventDetailArrangeHourClass);
                    }
                    if ((enrollments = clazz.getStudentEnrollments()) == null || enrollments.isEmpty()) {
                        return null;
                    }
                    return EventEnrollmentsBackend.convert(enrollments, null, context.hasPermission(Right.EnrollmentsShowExternalId), context.hasPermission(Right.CourseRequests), context.hasPermission(Right.SchedulingAssistant));
                }
                throw new GwtRpcException(MESSAGES.errorBadEventId());
            }
            context.checkPermission(event, Right.EventDetail);
            Collection<StudentClassEnrollment> enrollments = event.getStudentClassEnrollments();
            if (enrollments == null || enrollments.isEmpty()) {
                return null;
            }
            if (0 == event.getEventType()) {
                return EventEnrollmentsBackend.convert(enrollments, this.computeConflicts(event instanceof ClassEvent ? (ClassEvent)event : (ClassEvent)ClassEventDAO.getInstance().get(event.getUniqueId(), hibSession)), context.hasPermission(Right.EnrollmentsShowExternalId), context.hasPermission(Right.CourseRequests), context.hasPermission(Right.SchedulingAssistant));
            }
            if (1 == event.getEventType() || 2 == event.getEventType()) {
                ClassAssignmentInterface.Conflict conf;
                ExamAssignment other;
                ExamEvent examEvent = event instanceof ExamEvent ? (ExamEvent)event : (ExamEvent)ExamEventDAO.getInstance().get(event.getUniqueId(), hibSession);
                GwtRpcResponseList<ClassAssignmentInterface.Enrollment> ret = EventEnrollmentsBackend.convert(enrollments, this.computeConflicts(examEvent), context.hasPermission(Right.EnrollmentsShowExternalId), context.hasPermission(Right.CourseRequests), context.hasPermission(Right.SchedulingAssistant));
                ExamAssignmentInfo assignment = new ExamAssignmentInfo(examEvent.getExam(), false);
                for (ExamAssignmentInfo.DirectConflict directConflict : assignment.getDirectConflicts()) {
                    other = directConflict.getOtherExam();
                    if (other == null) continue;
                    conf = new ClassAssignmentInterface.Conflict();
                    conf.setName(other.getExamName());
                    conf.setType("Direct");
                    conf.setDate(EventEnrollmentsBackend.getDateFormat().format(other.getPeriod().getStartDate()));
                    conf.setTime(other.getTime(false));
                    conf.setRoom(other.getRoomsName(false, ", "));
                    conf.setStyle("dc");
                    for (Long studentId : directConflict.getStudents()) {
                        for (ClassAssignmentInterface.Enrollment enrollment : ret) {
                            if (enrollment.getStudent().getId() != studentId.longValue()) continue;
                            enrollment.addConflict(conf);
                        }
                    }
                }
                if (ApplicationProperty.ExaminationReportsStudentBackToBacks.isTrue()) {
                    for (ExamAssignmentInfo.BackToBackConflict backToBackConflict : assignment.getBackToBackConflicts()) {
                        other = backToBackConflict.getOtherExam();
                        conf = new ClassAssignmentInterface.Conflict();
                        conf.setName(other.getExamName());
                        conf.setType("Back-To-Back");
                        conf.setDate(EventEnrollmentsBackend.getDateFormat().format(other.getPeriod().getStartDate()));
                        conf.setTime(other.getTime(false));
                        conf.setRoom(other.getRoomsName(false, ", "));
                        conf.setStyle("b2b");
                        for (Long studentId : backToBackConflict.getStudents()) {
                            for (ClassAssignmentInterface.Enrollment enrollment : ret) {
                                if (enrollment.getStudent().getId() != studentId.longValue()) continue;
                                enrollment.addConflict(conf);
                            }
                        }
                    }
                }
                for (ExamAssignmentInfo.MoreThanTwoADayConflict moreThanTwoADayConflict : assignment.getMoreThanTwoADaysConflicts()) {
                    String name = null;
                    String date = null;
                    String time = null;
                    String room = null;
                    for (ExamAssignment other2 : moreThanTwoADayConflict.getOtherExams()) {
                        if (name == null) {
                            name = other2.getExamName();
                            date = EventEnrollmentsBackend.getDateFormat().format(other2.getPeriod().getStartDate());
                            time = other2.getTime(false);
                            room = other2.getRoomsName(false, ", ");
                            continue;
                        }
                        name = name + "<br>" + other2.getExamName();
                        date = date + "<br>" + EventEnrollmentsBackend.getDateFormat().format(other2.getPeriod().getStartDate());
                        time = time + "<br>" + other2.getTime(false);
                        room = room + "<br>" + other2.getRoomsName(false, ", ");
                    }
                    ClassAssignmentInterface.Conflict conf2 = new ClassAssignmentInterface.Conflict();
                    conf2.setName(name);
                    conf2.setType("&gt;2 A Day");
                    conf2.setDate(date);
                    conf2.setTime(time);
                    conf2.setRoom(room);
                    conf2.setStyle("m2d");
                    for (Long studentId : moreThanTwoADayConflict.getStudents()) {
                        for (ClassAssignmentInterface.Enrollment enrollment : ret) {
                            if (enrollment.getStudent().getId() != studentId.longValue()) continue;
                            enrollment.addConflict(conf2);
                        }
                    }
                }
                return ret;
            }
            if (3 == event.getEventType()) {
                return EventEnrollmentsBackend.convert(enrollments, this.computeConflicts(event instanceof CourseEvent ? (CourseEvent)event : (CourseEvent)CourseEventDAO.getInstance().get(event.getUniqueId(), hibSession)), context.hasPermission(Right.EnrollmentsShowExternalId), context.hasPermission(Right.CourseRequests), context.hasPermission(Right.SchedulingAssistant));
            }
        }
        return null;
    }

    public static Collection<StudentClassEnrollment> getStudentClassEnrollments(EventInterface.RelatedObjectInterface relatedObject) {
        switch (relatedObject.getType()) {
            case Class: {
                return EventDAO.getInstance().getSession().createQuery("select distinct e from StudentClassEnrollment e, StudentClassEnrollment f where f.clazz.uniqueId = :classId and e.courseOffering.instructionalOffering = f.courseOffering.instructionalOffering and e.student = f.student").setLong("classId", relatedObject.getUniqueId().longValue()).setCacheable(true).list();
            }
            case Config: {
                return EventDAO.getInstance().getSession().createQuery("select distinct e from StudentClassEnrollment e, StudentClassEnrollment f where f.clazz.schedulingSubpart.instrOfferingConfig.uniqueId = :configId and e.courseOffering.instructionalOffering = f.courseOffering.instructionalOffering and e.student = f.student").setLong("configId", relatedObject.getUniqueId().longValue()).setCacheable(true).list();
            }
            case Course: {
                return EventDAO.getInstance().getSession().createQuery("select e from StudentClassEnrollment e where e.courseOffering.uniqueId = :courseId").setLong("courseId", relatedObject.getUniqueId().longValue()).setCacheable(true).list();
            }
            case Offering: {
                return EventDAO.getInstance().getSession().createQuery("select e from StudentClassEnrollment e where e.courseOffering.instructionalOffering.uniqueId = :offeringId").setLong("offeringId", relatedObject.getUniqueId().longValue()).setCacheable(true).list();
            }
        }
        throw new GwtRpcException("Unsupported related object type " + (Object)((Object)relatedObject.getType()));
    }

    public static void computeConflicts(Map<Long, List<Meeting>> conflicts, EventInterface.MeetingInterface meeting, EventInterface.RelatedObjectInterface relatedObject, Long eventId) {
        Session hibSession = EventDAO.getInstance().getSession();
        switch (relatedObject.getType()) {
            case Class: {
                List<Meeting> meetings;
                Meeting conflictingMeeting;
                Long studentId;
                int t1;
                for (Object o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, ClassEvent e1 inner join e1.meetings m1, StudentClassEnrollment s2 where s2.clazz.uniqueId = :classId and e1.clazz = s1.clazz and s1.student = s2.student and m1.meetingDate = :meetingDate and m1.startPeriod < :stopPeriod and :startPeriod < m1.stopPeriod").setDate("meetingDate", meeting.getMeetingDate()).setInteger("startPeriod", meeting.getStartSlot()).setInteger("stopPeriod", meeting.getEndSlot()).setLong("classId", relatedObject.getUniqueId().longValue()).list()) {
                    Long studentId2 = (Long)o[0];
                    Meeting conflictingMeeting2 = (Meeting)o[1];
                    List<Meeting> meetings2 = conflicts.get(studentId2);
                    if (meetings2 == null) {
                        meetings2 = new ArrayList<Meeting>();
                        conflicts.put(studentId2, meetings2);
                    }
                    meetings2.add(conflictingMeeting2);
                }
                for (t1 = 0; t1 < ExamOwner.sOwnerTypes.length; ++t1) {
                    for (Object[] o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, ExamEvent e1 inner join e1.meetings m1 inner join e1.exam.owners o1, StudentClassEnrollment s2 where s2.clazz.uniqueId = :classId and s1.student = s2.student" + EventEnrollmentsBackend.where(t1, 1) + " and m1.meetingDate = :meetingDate and m1.startPeriod < :stopPeriod and :startPeriod < m1.stopPeriod").setDate("meetingDate", meeting.getMeetingDate()).setInteger("startPeriod", meeting.getStartSlot()).setInteger("stopPeriod", meeting.getEndSlot()).setLong("classId", relatedObject.getUniqueId().longValue()).list()) {
                        studentId = (Long)o[0];
                        conflictingMeeting = (Meeting)o[1];
                        meetings = conflicts.get(studentId);
                        if (meetings == null) {
                            meetings = new ArrayList<Meeting>();
                            conflicts.put(studentId, meetings);
                        }
                        meetings.add(conflictingMeeting);
                    }
                }
                for (t1 = 0; t1 < ExamOwner.sOwnerTypes.length; ++t1) {
                    for (Object[] o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, CourseEvent e1 inner join e1.meetings m1 inner join e1.relatedCourses o1, StudentClassEnrollment s2 where s2.clazz.uniqueId = :classId and e1.uniqueId != :eventId and s1.student = s2.student" + EventEnrollmentsBackend.where(t1, 1) + " and m1.meetingDate = :meetingDate and m1.startPeriod < :stopPeriod and :startPeriod < m1.stopPeriod and e1.reqAttendance = true and m1.approvalStatus = 1").setDate("meetingDate", meeting.getMeetingDate()).setInteger("startPeriod", meeting.getStartSlot()).setInteger("stopPeriod", meeting.getEndSlot()).setLong("classId", relatedObject.getUniqueId().longValue()).setLong("eventId", eventId == null ? -1L : eventId).list()) {
                        studentId = (Long)o[0];
                        conflictingMeeting = (Meeting)o[1];
                        meetings = conflicts.get(studentId);
                        if (meetings == null) {
                            meetings = new ArrayList<Meeting>();
                            conflicts.put(studentId, meetings);
                        }
                        meetings.add(conflictingMeeting);
                    }
                }
                break;
            }
            case Config: {
                List<Meeting> meetings;
                Meeting conflictingMeeting;
                Long studentId;
                int t1;
                for (Object o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, ClassEvent e1 inner join e1.meetings m1, StudentClassEnrollment s2 where s2.clazz.schedulingSubpart.instrOfferingConfig.uniqueId = :configId and e1.clazz = s1.clazz and s1.student = s2.student and m1.meetingDate = :meetingDate and m1.startPeriod < :stopPeriod and :startPeriod < m1.stopPeriod").setDate("meetingDate", meeting.getMeetingDate()).setInteger("startPeriod", meeting.getStartSlot()).setInteger("stopPeriod", meeting.getEndSlot()).setLong("configId", relatedObject.getUniqueId().longValue()).list()) {
                    Long studentId3 = (Long)o[0];
                    Meeting conflictingMeeting3 = (Meeting)o[1];
                    List<Meeting> meetings3 = conflicts.get(studentId3);
                    if (meetings3 == null) {
                        meetings3 = new ArrayList<Meeting>();
                        conflicts.put(studentId3, meetings3);
                    }
                    meetings3.add(conflictingMeeting3);
                }
                for (t1 = 0; t1 < ExamOwner.sOwnerTypes.length; ++t1) {
                    for (Object[] o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, ExamEvent e1 inner join e1.meetings m1 inner join e1.exam.owners o1, StudentClassEnrollment s2 where s2.clazz.schedulingSubpart.instrOfferingConfig.uniqueId = :configId and s1.student = s2.student" + EventEnrollmentsBackend.where(t1, 1) + " and m1.meetingDate = :meetingDate and m1.startPeriod < :stopPeriod and :startPeriod < m1.stopPeriod").setDate("meetingDate", meeting.getMeetingDate()).setInteger("startPeriod", meeting.getStartSlot()).setInteger("stopPeriod", meeting.getEndSlot()).setLong("configId", relatedObject.getUniqueId().longValue()).list()) {
                        studentId = (Long)o[0];
                        conflictingMeeting = (Meeting)o[1];
                        meetings = conflicts.get(studentId);
                        if (meetings == null) {
                            meetings = new ArrayList<Meeting>();
                            conflicts.put(studentId, meetings);
                        }
                        meetings.add(conflictingMeeting);
                    }
                }
                for (t1 = 0; t1 < ExamOwner.sOwnerTypes.length; ++t1) {
                    for (Object[] o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, CourseEvent e1 inner join e1.meetings m1 inner join e1.relatedCourses o1, StudentClassEnrollment s2 where s2.clazz.schedulingSubpart.instrOfferingConfig.uniqueId = :configId and e1.uniqueId != :eventId and s1.student = s2.student" + EventEnrollmentsBackend.where(t1, 1) + " and m1.meetingDate = :meetingDate and m1.startPeriod < :stopPeriod and :startPeriod < m1.stopPeriod and e1.reqAttendance = true and m1.approvalStatus = 1").setDate("meetingDate", meeting.getMeetingDate()).setInteger("startPeriod", meeting.getStartSlot()).setInteger("stopPeriod", meeting.getEndSlot()).setLong("configId", relatedObject.getUniqueId().longValue()).setLong("eventId", eventId == null ? -1L : eventId).list()) {
                        studentId = (Long)o[0];
                        conflictingMeeting = (Meeting)o[1];
                        meetings = conflicts.get(studentId);
                        if (meetings == null) {
                            meetings = new ArrayList<Meeting>();
                            conflicts.put(studentId, meetings);
                        }
                        meetings.add(conflictingMeeting);
                    }
                }
                break;
            }
            case Course: {
                List<Meeting> meetings;
                Meeting conflictingMeeting;
                Long studentId;
                int t1;
                for (Object o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, ClassEvent e1 inner join e1.meetings m1, StudentClassEnrollment s2 where s2.courseOffering.uniqueId = :courseId and e1.clazz = s1.clazz and s1.student = s2.student and m1.meetingDate = :meetingDate and m1.startPeriod < :stopPeriod and :startPeriod < m1.stopPeriod").setDate("meetingDate", meeting.getMeetingDate()).setInteger("startPeriod", meeting.getStartSlot()).setInteger("stopPeriod", meeting.getEndSlot()).setLong("courseId", relatedObject.getUniqueId().longValue()).list()) {
                    Long studentId4 = (Long)o[0];
                    Meeting conflictingMeeting4 = (Meeting)o[1];
                    List<Meeting> meetings4 = conflicts.get(studentId4);
                    if (meetings4 == null) {
                        meetings4 = new ArrayList<Meeting>();
                        conflicts.put(studentId4, meetings4);
                    }
                    meetings4.add(conflictingMeeting4);
                }
                for (t1 = 0; t1 < ExamOwner.sOwnerTypes.length; ++t1) {
                    for (Object[] o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, ExamEvent e1 inner join e1.meetings m1 inner join e1.exam.owners o1, StudentClassEnrollment s2 where s2.courseOffering.uniqueId = :courseId and s1.student = s2.student" + EventEnrollmentsBackend.where(t1, 1) + " and m1.meetingDate = :meetingDate and m1.startPeriod < :stopPeriod and :startPeriod < m1.stopPeriod").setDate("meetingDate", meeting.getMeetingDate()).setInteger("startPeriod", meeting.getStartSlot()).setInteger("stopPeriod", meeting.getEndSlot()).setLong("courseId", relatedObject.getUniqueId().longValue()).list()) {
                        studentId = (Long)o[0];
                        conflictingMeeting = (Meeting)o[1];
                        meetings = conflicts.get(studentId);
                        if (meetings == null) {
                            meetings = new ArrayList<Meeting>();
                            conflicts.put(studentId, meetings);
                        }
                        meetings.add(conflictingMeeting);
                    }
                }
                for (t1 = 0; t1 < ExamOwner.sOwnerTypes.length; ++t1) {
                    for (Object[] o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, CourseEvent e1 inner join e1.meetings m1 inner join e1.relatedCourses o1, StudentClassEnrollment s2 where s2.courseOffering.uniqueId = :courseId and e1.uniqueId != :eventId and s1.student = s2.student" + EventEnrollmentsBackend.where(t1, 1) + " and m1.meetingDate = :meetingDate and m1.startPeriod < :stopPeriod and :startPeriod < m1.stopPeriod and e1.reqAttendance = true and m1.approvalStatus = 1").setDate("meetingDate", meeting.getMeetingDate()).setInteger("startPeriod", meeting.getStartSlot()).setInteger("stopPeriod", meeting.getEndSlot()).setLong("courseId", relatedObject.getUniqueId().longValue()).setLong("eventId", eventId == null ? -1L : eventId).list()) {
                        studentId = (Long)o[0];
                        conflictingMeeting = (Meeting)o[1];
                        meetings = conflicts.get(studentId);
                        if (meetings == null) {
                            meetings = new ArrayList<Meeting>();
                            conflicts.put(studentId, meetings);
                        }
                        meetings.add(conflictingMeeting);
                    }
                }
                break;
            }
            case Offering: {
                List<Meeting> meetings;
                Meeting conflictingMeeting;
                Long studentId;
                int t1;
                for (Object[] o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, ClassEvent e1 inner join e1.meetings m1, StudentClassEnrollment s2 where s2.courseOffering.instructionalOffering.uniqueId = :offeringId and e1.clazz = s1.clazz and s1.student = s2.student and m1.meetingDate = :meetingDate and m1.startPeriod < :stopPeriod and :startPeriod < m1.stopPeriod").setDate("meetingDate", meeting.getMeetingDate()).setInteger("startPeriod", meeting.getStartSlot()).setInteger("stopPeriod", meeting.getEndSlot()).setLong("offeringId", relatedObject.getUniqueId().longValue()).list()) {
                    Long studentId5 = (Long)o[0];
                    Meeting conflictingMeeting5 = (Meeting)o[1];
                    List<Meeting> meetings5 = conflicts.get(studentId5);
                    if (meetings5 == null) {
                        meetings5 = new ArrayList<Meeting>();
                        conflicts.put(studentId5, meetings5);
                    }
                    meetings5.add(conflictingMeeting5);
                }
                for (t1 = 0; t1 < ExamOwner.sOwnerTypes.length; ++t1) {
                    for (Object[] o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, ExamEvent e1 inner join e1.meetings m1 inner join e1.exam.owners o1, StudentClassEnrollment s2 where s2.courseOffering.instructionalOffering.uniqueId = :offeringId and s1.student = s2.student" + EventEnrollmentsBackend.where(t1, 1) + " and m1.meetingDate = :meetingDate and m1.startPeriod < :stopPeriod and :startPeriod < m1.stopPeriod").setDate("meetingDate", meeting.getMeetingDate()).setInteger("startPeriod", meeting.getStartSlot()).setInteger("stopPeriod", meeting.getEndSlot()).setLong("offeringId", relatedObject.getUniqueId().longValue()).list()) {
                        studentId = (Long)o[0];
                        conflictingMeeting = (Meeting)o[1];
                        meetings = conflicts.get(studentId);
                        if (meetings == null) {
                            meetings = new ArrayList<Meeting>();
                            conflicts.put(studentId, meetings);
                        }
                        meetings.add(conflictingMeeting);
                    }
                }
                for (t1 = 0; t1 < ExamOwner.sOwnerTypes.length; ++t1) {
                    for (Object[] o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, CourseEvent e1 inner join e1.meetings m1 inner join e1.relatedCourses o1, StudentClassEnrollment s2 where s2.courseOffering.instructionalOffering.uniqueId = :offeringId and e1.uniqueId != :eventId and s1.student = s2.student" + EventEnrollmentsBackend.where(t1, 1) + " and m1.meetingDate = :meetingDate and m1.startPeriod < :stopPeriod and :startPeriod < m1.stopPeriod and e1.reqAttendance = true and m1.approvalStatus = 1").setDate("meetingDate", meeting.getMeetingDate()).setInteger("startPeriod", meeting.getStartSlot()).setInteger("stopPeriod", meeting.getEndSlot()).setLong("offeringId", relatedObject.getUniqueId().longValue()).setLong("eventId", eventId == null ? -1L : eventId).list()) {
                        studentId = (Long)o[0];
                        conflictingMeeting = (Meeting)o[1];
                        meetings = conflicts.get(studentId);
                        if (meetings == null) {
                            meetings = new ArrayList<Meeting>();
                            conflicts.put(studentId, meetings);
                        }
                        meetings.add(conflictingMeeting);
                    }
                }
                break;
            }
        }
    }

    public static GwtRpcResponseList<ClassAssignmentInterface.Enrollment> convert(Collection<StudentClassEnrollment> enrollments, Map<Long, List<Meeting>> conflicts, boolean canShowExtId, boolean canRegister, boolean canUseAssistant) {
        GwtRpcResponseList<ClassAssignmentInterface.Enrollment> converted = new GwtRpcResponseList<ClassAssignmentInterface.Enrollment>();
        Hashtable<String, String> approvedBy2name = new Hashtable<String, String>();
        Hashtable<Long, ClassAssignmentInterface.Enrollment> student2enrollment = new Hashtable<Long, ClassAssignmentInterface.Enrollment>();
        for (StudentClassEnrollment enrollment : enrollments) {
            ClassAssignmentInterface.Enrollment enrl = (ClassAssignmentInterface.Enrollment)student2enrollment.get(enrollment.getStudent().getUniqueId());
            if (enrl == null) {
                List<Meeting> conf;
                ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                st.setId(enrollment.getStudent().getUniqueId());
                st.setExternalId(enrollment.getStudent().getExternalUniqueId());
                st.setCanShowExternalId(canShowExtId);
                st.setCanRegister(canRegister);
                st.setCanUseAssistant(canUseAssistant);
                st.setName(enrollment.getStudent().getName(ApplicationProperty.OnlineSchedulingStudentNameFormat.value()));
                for (AcademicAreaClassification ac : enrollment.getStudent().getAcademicAreaClassifications()) {
                    st.addArea(ac.getAcademicArea().getAcademicAreaAbbreviation());
                    st.addClassification(ac.getAcademicClassification().getCode());
                }
                for (PosMajor m : enrollment.getStudent().getPosMajors()) {
                    st.addMajor(m.getCode());
                }
                for (StudentGroup g : enrollment.getStudent().getGroups()) {
                    st.addGroup(g.getGroupAbbreviation());
                }
                for (StudentAccomodation a : enrollment.getStudent().getAccomodations()) {
                    st.addAccommodation(a.getAbbreviation());
                }
                enrl = new ClassAssignmentInterface.Enrollment();
                enrl.setStudent(st);
                enrl.setEnrolledDate(enrollment.getTimestamp());
                ClassAssignmentInterface.CourseAssignment c = new ClassAssignmentInterface.CourseAssignment();
                c.setCourseId(enrollment.getCourseOffering().getUniqueId());
                c.setSubject(enrollment.getCourseOffering().getSubjectAreaAbbv());
                c.setCourseNbr(enrollment.getCourseOffering().getCourseNbr());
                enrl.setCourse(c);
                student2enrollment.put(enrollment.getStudent().getUniqueId(), enrl);
                if (enrollment.getCourseRequest() != null) {
                    Comparable first;
                    enrl.setPriority(1 + enrollment.getCourseRequest().getCourseDemand().getPriority());
                    if (enrollment.getCourseRequest().getCourseDemand().getCourseRequests().size() > 1) {
                        first = null;
                        for (CourseRequest courseRequest : enrollment.getCourseRequest().getCourseDemand().getCourseRequests()) {
                            if (first != null && courseRequest.getOrder().compareTo(((BaseCourseRequest)((Object)first)).getOrder()) >= 0) continue;
                            first = courseRequest;
                        }
                        if (!((BaseCourseRequest)((Object)first)).equals(enrollment.getCourseRequest())) {
                            enrl.setAlternative(((BaseCourseRequest)((Object)first)).getCourseOffering().getCourseName());
                        }
                    }
                    if (enrollment.getCourseRequest().getCourseDemand().isAlternative().booleanValue()) {
                        first = enrollment.getCourseRequest().getCourseDemand();
                        block6: for (CourseDemand courseDemand : enrollment.getStudent().getCourseDemands()) {
                            if (courseDemand.isAlternative().booleanValue() || courseDemand.getPriority().compareTo(((BaseCourseDemand)((Object)first)).getPriority()) >= 0 || courseDemand.getCourseRequests().isEmpty()) continue;
                            for (CourseRequest cr : courseDemand.getCourseRequests()) {
                                if (!cr.getClassEnrollments().isEmpty()) continue;
                                continue block6;
                            }
                            first = courseDemand;
                        }
                        BaseCourseRequest alt = null;
                        for (CourseRequest r : ((BaseCourseDemand)((Object)first)).getCourseRequests()) {
                            if (alt != null && r.getOrder().compareTo(alt.getOrder()) >= 0) continue;
                            alt = r;
                        }
                        enrl.setAlternative(alt.getCourseOffering().getCourseName());
                    }
                    enrl.setRequestedDate(enrollment.getCourseRequest().getCourseDemand().getTimestamp());
                    enrl.setApprovedDate(enrollment.getApprovedDate());
                    if (enrollment.getApprovedBy() != null) {
                        String name = (String)approvedBy2name.get(enrollment.getApprovedBy());
                        if (name == null) {
                            TimetableManager mgr = (TimetableManager)EventDAO.getInstance().getSession().createQuery("from TimetableManager where externalUniqueId = :externalId").setString("externalId", enrollment.getApprovedBy()).setMaxResults(1).uniqueResult();
                            if (mgr != null) {
                                name = mgr.getName();
                            } else {
                                DepartmentalInstructor departmentalInstructor = (DepartmentalInstructor)EventDAO.getInstance().getSession().createQuery("from DepartmentalInstructor where externalUniqueId = :externalId and department.session.uniqueId = :sessionId").setString("externalId", enrollment.getApprovedBy()).setLong("sessionId", enrollment.getStudent().getSession().getUniqueId().longValue()).setMaxResults(1).uniqueResult();
                                if (departmentalInstructor != null) {
                                    name = departmentalInstructor.nameLastNameFirst();
                                }
                            }
                            if (name != null) {
                                approvedBy2name.put(enrollment.getApprovedBy(), name);
                            }
                        }
                        enrl.setApprovedBy(name == null ? enrollment.getApprovedBy() : name);
                    }
                } else {
                    enrl.setPriority(-1);
                }
                List<Meeting> list = conf = conflicts == null ? null : conflicts.get(enrollment.getStudent().getUniqueId());
                if (conf != null) {
                    HashMap<Event, TreeSet<Meeting>> events = new HashMap<Event, TreeSet<Meeting>>();
                    for (Meeting m : conf) {
                        TreeSet<Meeting> ms = (TreeSet<Meeting>)events.get(m.getEvent());
                        if (ms == null) {
                            ms = new TreeSet<Meeting>();
                            events.put(m.getEvent(), ms);
                        }
                        ms.add(m);
                    }
                    for (Event confEvent : new TreeSet(events.keySet())) {
                        ClassAssignmentInterface.Conflict conflict = new ClassAssignmentInterface.Conflict();
                        conflict.setName(confEvent.getEventName());
                        conflict.setType(confEvent.getEventTypeAbbv());
                        String lastDate = null;
                        String lastTime = null;
                        String lastRoom = null;
                        for (Event.MultiMeeting mm : Event.getMultiMeetings((Collection)events.get(confEvent))) {
                            String room;
                            String date = EventEnrollmentsBackend.getDateFormat().format(mm.getMeetings().first().getMeetingDate()) + (mm.getMeetings().size() == 1 ? "" : " - " + EventEnrollmentsBackend.getDateFormat().format(mm.getMeetings().last().getMeetingDate()));
                            if (lastDate == null) {
                                conflict.setDate(date);
                            } else if (lastDate.equals(date)) {
                                conflict.setDate(conflict.getDate() + "<br>");
                            } else {
                                conflict.setDate(conflict.getDate() + "<br>" + date);
                            }
                            lastDate = date;
                            String time = mm.getDays(CONSTANTS.days(), CONSTANTS.shortDays()) + " " + (mm.getMeetings().first().isAllDay() ? "All Day" : mm.getMeetings().first().startTime() + " - " + mm.getMeetings().first().stopTime());
                            if (lastTime == null) {
                                conflict.setTime(time);
                            } else if (lastTime.equals(time)) {
                                conflict.setTime(conflict.getTime() + "<br>");
                            } else {
                                conflict.setTime(conflict.getTime() + "<br>" + time);
                            }
                            lastTime = time;
                            String string = room = mm.getMeetings().first().getLocation() == null ? "" : mm.getMeetings().first().getLocation().getLabel();
                            if (lastRoom == null) {
                                conflict.setRoom(room);
                            } else if (lastRoom.equals(room)) {
                                conflict.setRoom(conflict.getRoom() + "<br>");
                            } else {
                                conflict.setRoom(conflict.getRoom() + "<br>" + room);
                            }
                            lastRoom = room;
                        }
                        enrl.addConflict(conflict);
                    }
                }
                converted.add(enrl);
            }
            ClassAssignmentInterface.ClassAssignment c = enrl.getCourse().addClassAssignment();
            c.setClassId(enrollment.getClazz().getUniqueId());
            c.setSection(enrollment.getClazz().getClassSuffix(enrollment.getCourseOffering()));
            if (c.getSection() == null) {
                c.setSection(enrollment.getClazz().getSectionNumberString());
            }
            c.setClassNumber(enrollment.getClazz().getSectionNumberString());
            c.setSubpart(enrollment.getClazz().getSchedulingSubpart().getItypeDesc());
        }
        return converted;
    }

    private static String where(int type, int idx) {
        switch (type) {
            case 3: {
                return " and o" + idx + ".ownerType = " + type + " and o" + idx + ".ownerId = s" + idx + ".clazz.uniqueId";
            }
            case 2: {
                return " and o" + idx + ".ownerType = " + type + " and o" + idx + ".ownerId = s" + idx + ".clazz.schedulingSubpart.instrOfferingConfig.uniqueId";
            }
            case 1: {
                return " and o" + idx + ".ownerType = " + type + " and o" + idx + ".ownerId = s" + idx + ".courseOffering.uniqueId";
            }
            case 0: {
                return " and o" + idx + ".ownerType = " + type + " and o" + idx + ".ownerId = s" + idx + ".courseOffering.instructionalOffering.uniqueId";
            }
        }
        return "";
    }

    private Map<Long, List<Meeting>> computeConflicts(ClassEvent event) {
        List<Meeting> meetings;
        Meeting meeting;
        Long studentId;
        int t1;
        HashMap<Long, List<Meeting>> conflicts = new HashMap<Long, List<Meeting>>();
        Session hibSession = EventDAO.getInstance().getSession();
        for (Object[] o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, ClassEvent e1 inner join e1.meetings m1, ClassEvent e2 inner join e2.meetings m2, StudentClassEnrollment s2 where e2.uniqueId = :eventId and e1.uniqueId != e2.uniqueId and e1.clazz = s1.clazz and e2.clazz = s2.clazz and s1.student = s2.student and m1.meetingDate = m2.meetingDate and m1.startPeriod < m2.stopPeriod and m2.startPeriod < m1.stopPeriod").setLong("eventId", event.getUniqueId().longValue()).list()) {
            Long studentId2 = (Long)o[0];
            Meeting meeting2 = (Meeting)o[1];
            ArrayList<Meeting> meetings2 = (ArrayList<Meeting>)conflicts.get(studentId2);
            if (meetings2 == null) {
                meetings2 = new ArrayList<Meeting>();
                conflicts.put(studentId2, meetings2);
            }
            meetings2.add(meeting2);
        }
        for (t1 = 0; t1 < ExamOwner.sOwnerTypes.length; ++t1) {
            for (Object[] o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, ExamEvent e1 inner join e1.meetings m1 inner join e1.exam.owners o1, ClassEvent e2 inner join e2.meetings m2, StudentClassEnrollment s2 where e2.uniqueId = :eventId and e1.uniqueId != e2.uniqueId and e2.clazz = s2.clazz and s1.student = s2.student" + EventEnrollmentsBackend.where(t1, 1) + " and m1.meetingDate = m2.meetingDate and m1.startPeriod < m2.stopPeriod and m2.startPeriod < m1.stopPeriod").setLong("eventId", event.getUniqueId().longValue()).list()) {
                studentId = (Long)o[0];
                meeting = (Meeting)o[1];
                meetings = (ArrayList<Meeting>)conflicts.get(studentId);
                if (meetings == null) {
                    meetings = new ArrayList<Meeting>();
                    conflicts.put(studentId, meetings);
                }
                meetings.add(meeting);
            }
        }
        for (t1 = 0; t1 < ExamOwner.sOwnerTypes.length; ++t1) {
            for (Object[] o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, CourseEvent e1 inner join e1.meetings m1 inner join e1.relatedCourses o1, ClassEvent e2 inner join e2.meetings m2, StudentClassEnrollment s2 where e2.uniqueId = :eventId and e1.uniqueId != e2.uniqueId and e2.clazz = s2.clazz and s1.student = s2.student" + EventEnrollmentsBackend.where(t1, 1) + " and m1.meetingDate = m2.meetingDate and m1.startPeriod < m2.stopPeriod and m2.startPeriod < m1.stopPeriod and e1.reqAttendance = true and m1.approvalStatus = 1").setLong("eventId", event.getUniqueId().longValue()).list()) {
                studentId = (Long)o[0];
                meeting = (Meeting)o[1];
                meetings = (List)conflicts.get(studentId);
                if (meetings == null) {
                    meetings = new ArrayList();
                    conflicts.put(studentId, meetings);
                }
                meetings.add(meeting);
            }
        }
        return conflicts;
    }

    private Map<Long, List<Meeting>> computeConflicts(ExamEvent event) {
        List<Meeting> meetings;
        Meeting meeting;
        Long studentId;
        int t1;
        HashMap<Long, List<Meeting>> conflicts = new HashMap<Long, List<Meeting>>();
        Session hibSession = EventDAO.getInstance().getSession();
        for (int t2 = 0; t2 < ExamOwner.sOwnerTypes.length; ++t2) {
            for (Object[] o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, ClassEvent e1 inner join e1.meetings m1, ExamEvent e2 inner join e2.meetings m2 inner join e2.exam.owners o2, StudentClassEnrollment s2 where e2.uniqueId = :eventId and e1.uniqueId != e2.uniqueId and e1.clazz = s1.clazz and s1.student = s2.student" + EventEnrollmentsBackend.where(t2, 2) + " and m1.meetingDate = m2.meetingDate and m1.startPeriod < m2.stopPeriod and m2.startPeriod < m1.stopPeriod").setLong("eventId", event.getUniqueId().longValue()).list()) {
                Long studentId2 = (Long)o[0];
                Meeting meeting2 = (Meeting)o[1];
                ArrayList<Meeting> meetings2 = (ArrayList<Meeting>)conflicts.get(studentId2);
                if (meetings2 == null) {
                    meetings2 = new ArrayList<Meeting>();
                    conflicts.put(studentId2, meetings2);
                }
                meetings2.add(meeting2);
            }
        }
        for (t1 = 0; t1 < ExamOwner.sOwnerTypes.length; ++t1) {
            for (int t2 = 0; t2 < ExamOwner.sOwnerTypes.length; ++t2) {
                for (Object[] o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, ExamEvent e1 inner join e1.meetings m1 inner join e1.exam.owners o1, ExamEvent e2 inner join e2.meetings m2 inner join e2.exam.owners o2, StudentClassEnrollment s2 where e2.uniqueId = :eventId and e1.uniqueId != e2.uniqueId and s1.student = s2.student and e1.exam.examType != e2.exam.examType" + EventEnrollmentsBackend.where(t1, 1) + EventEnrollmentsBackend.where(t2, 2) + " and m1.meetingDate = m2.meetingDate and m1.startPeriod < m2.stopPeriod and m2.startPeriod < m1.stopPeriod").setLong("eventId", event.getUniqueId().longValue()).list()) {
                    studentId = (Long)o[0];
                    meeting = (Meeting)o[1];
                    meetings = (ArrayList<Meeting>)conflicts.get(studentId);
                    if (meetings == null) {
                        meetings = new ArrayList<Meeting>();
                        conflicts.put(studentId, meetings);
                    }
                    meetings.add(meeting);
                }
            }
        }
        for (t1 = 0; t1 < ExamOwner.sOwnerTypes.length; ++t1) {
            for (int t2 = 0; t2 < ExamOwner.sOwnerTypes.length; ++t2) {
                for (Object[] o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, CourseEvent e1 inner join e1.meetings m1 inner join e1.relatedCourses o1, ExamEvent e2 inner join e2.meetings m2 inner join e2.exam.owners o2, StudentClassEnrollment s2 where e2.uniqueId = :eventId and e1.uniqueId != e2.uniqueId and s1.student = s2.student" + EventEnrollmentsBackend.where(t1, 1) + EventEnrollmentsBackend.where(t2, 2) + " and m1.meetingDate = m2.meetingDate and m1.startPeriod < m2.stopPeriod and m2.startPeriod < m1.stopPeriod and e1.reqAttendance = true and m1.approvalStatus = 1").setLong("eventId", event.getUniqueId().longValue()).list()) {
                    studentId = (Long)o[0];
                    meeting = (Meeting)o[1];
                    meetings = (List)conflicts.get(studentId);
                    if (meetings == null) {
                        meetings = new ArrayList();
                        conflicts.put(studentId, meetings);
                    }
                    meetings.add(meeting);
                }
            }
        }
        return conflicts;
    }

    private Map<Long, List<Meeting>> computeConflicts(CourseEvent event) {
        List<Meeting> meetings;
        Meeting meeting;
        Long studentId;
        int t1;
        HashMap<Long, List<Meeting>> conflicts = new HashMap<Long, List<Meeting>>();
        Session hibSession = EventDAO.getInstance().getSession();
        for (int t2 = 0; t2 < ExamOwner.sOwnerTypes.length; ++t2) {
            for (Object[] o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, ClassEvent e1 inner join e1.meetings m1, CourseEvent e2 inner join e2.meetings m2 inner join e2.relatedCourses o2, StudentClassEnrollment s2 where e2.uniqueId = :eventId and e1.uniqueId != e2.uniqueId and e1.clazz = s1.clazz and s1.student = s2.student" + EventEnrollmentsBackend.where(t2, 2) + " and m1.meetingDate = m2.meetingDate and m1.startPeriod < m2.stopPeriod and m2.startPeriod < m1.stopPeriod and m2.approvalStatus <= 1").setLong("eventId", event.getUniqueId().longValue()).list()) {
                Long studentId2 = (Long)o[0];
                Meeting meeting2 = (Meeting)o[1];
                ArrayList<Meeting> meetings2 = (ArrayList<Meeting>)conflicts.get(studentId2);
                if (meetings2 == null) {
                    meetings2 = new ArrayList<Meeting>();
                    conflicts.put(studentId2, meetings2);
                }
                meetings2.add(meeting2);
            }
        }
        for (t1 = 0; t1 < ExamOwner.sOwnerTypes.length; ++t1) {
            for (int t2 = 0; t2 < ExamOwner.sOwnerTypes.length; ++t2) {
                for (Object[] o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, ExamEvent e1 inner join e1.meetings m1 inner join e1.exam.owners o1, CourseEvent e2 inner join e2.meetings m2 inner join e2.relatedCourses o2, StudentClassEnrollment s2 where e2.uniqueId = :eventId and e1.uniqueId != e2.uniqueId and s1.student = s2.student" + EventEnrollmentsBackend.where(t1, 1) + EventEnrollmentsBackend.where(t2, 2) + " and m1.meetingDate = m2.meetingDate and m1.startPeriod < m2.stopPeriod and m2.startPeriod < m1.stopPeriod and m2.approvalStatus <= 1").setLong("eventId", event.getUniqueId().longValue()).list()) {
                    studentId = (Long)o[0];
                    meeting = (Meeting)o[1];
                    meetings = (ArrayList<Meeting>)conflicts.get(studentId);
                    if (meetings == null) {
                        meetings = new ArrayList<Meeting>();
                        conflicts.put(studentId, meetings);
                    }
                    meetings.add(meeting);
                }
            }
        }
        for (t1 = 0; t1 < ExamOwner.sOwnerTypes.length; ++t1) {
            for (int t2 = 0; t2 < ExamOwner.sOwnerTypes.length; ++t2) {
                for (Object[] o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, CourseEvent e1 inner join e1.meetings m1 inner join e1.relatedCourses o1, CourseEvent e2 inner join e2.meetings m2 inner join e2.relatedCourses o2, StudentClassEnrollment s2 where e2.uniqueId = :eventId and e1.uniqueId != e2.uniqueId and s1.student = s2.student" + EventEnrollmentsBackend.where(t1, 1) + EventEnrollmentsBackend.where(t2, 2) + " and m1.meetingDate = m2.meetingDate and m1.startPeriod < m2.stopPeriod and m2.startPeriod < m1.stopPeriod and e1.reqAttendance = true and m1.approvalStatus = 1 and m2.approvalStatus <= 1").setLong("eventId", event.getUniqueId().longValue()).list()) {
                    studentId = (Long)o[0];
                    meeting = (Meeting)o[1];
                    meetings = (List)conflicts.get(studentId);
                    if (meetings == null) {
                        meetings = new ArrayList();
                        conflicts.put(studentId, meetings);
                    }
                    meetings.add(meeting);
                }
            }
        }
        return conflicts;
    }
}

