/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.backup;

import com.google.protobuf.CodedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ProgressListener;
import org.cpsolver.ifs.util.ProgressWriter;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.NonUniqueResultException;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.BinaryType;
import org.hibernate.type.BooleanType;
import org.hibernate.type.ByteType;
import org.hibernate.type.CharacterType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CustomType;
import org.hibernate.type.DateType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.EntityType;
import org.hibernate.type.FloatType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.ListType;
import org.hibernate.type.LongType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.SetType;
import org.hibernate.type.ShortType;
import org.hibernate.type.StringType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.backup.SessionBackup;
import org.unitime.timetable.backup.SessionRestoreInterface;
import org.unitime.timetable.backup.TableData;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.ManagerRole;
import org.unitime.timetable.model.OfferingConsentType;
import org.unitime.timetable.model.OnlineSectioningLog;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RefTableEntry;
import org.unitime.timetable.model.RelatedCourseInfo;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Settings;
import org.unitime.timetable.model.SolverInfo;
import org.unitime.timetable.model.SolverInfoDef;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.SolverPredefinedSetting;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.TravelTime;
import org.unitime.timetable.model.dao._RootDAO;

public class SessionRestore
implements SessionRestoreInterface {
    private static Log sLog = LogFactory.getLog(SessionBackup.class);
    private SessionFactory iHibSessionFactory = null;
    private org.hibernate.Session iHibSession = null;
    private Progress iProgress = null;
    private boolean iIsClone = false;
    private Map<String, Map<String, Entity>> iEntities = new Hashtable<String, Map<String, Entity>>();
    private List<Entity> iAllEntitites = new ArrayList<Entity>();
    private Map<String, Student> iStudents = new Hashtable<String, Student>();
    private PrintWriter iDebug = null;
    private InputStream iIn;
    Map<String, Set<String>> iMessages = new HashMap<String, Set<String>>();

    public Progress getProgress() {
        return this.iProgress;
    }

    public void debug(PrintWriter pw) {
        this.iDebug = pw;
    }

    private boolean lookup(Entity entity, String property, Object value) {
        try {
            Object object = this.iHibSession.createCriteria(entity.getMetaData().getMappedClass()).add((Criterion)Restrictions.eq((String)property, (Object)value)).uniqueResult();
            if (object != null) {
                entity.setObject(object);
            } else {
                this.message("Lookup " + entity.getAbbv() + "." + property + " failed", value == null ? "null" : value.toString());
            }
            return object != null;
        }
        catch (NonUniqueResultException e) {
            this.message("Lookup " + entity.getAbbv() + "." + property + "=" + value + " is not unique", entity.getId());
            List list = this.iHibSession.createCriteria(entity.getMetaData().getMappedClass()).add((Criterion)Restrictions.eq((String)property, (Object)value)).list();
            if (!list.isEmpty()) {
                Object object = list.get(0);
                entity.setObject(object);
                return true;
            }
            return false;
        }
    }

    protected void add(Entity entity) {
        boolean save = true;
        boolean lookup = true;
        if (entity.getObject() instanceof Session) {
            Session oldSession = (Session)this.iHibSession.get(Session.class, (Serializable)Long.valueOf(entity.getId()));
            if (oldSession != null) {
                this.iIsClone = true;
            }
            Session session = (Session)entity.getObject();
            int attempt = 0;
            while (!this.iHibSession.createCriteria(Session.class).add((Criterion)Restrictions.eq((String)"academicInitiative", (Object)(session.getAcademicInitiative() + (attempt == 0 ? "" : " [" + attempt + "]")))).add((Criterion)Restrictions.eq((String)"academicYear", (Object)session.getAcademicYear())).add((Criterion)Restrictions.eq((String)"academicTerm", (Object)session.getAcademicTerm())).list().isEmpty()) {
                ++attempt;
            }
            if (attempt > 0) {
                session.setAcademicInitiative(session.getAcademicInitiative() + " [" + attempt + "]");
            }
        }
        if (entity.getObject() instanceof PreferenceLevel && this.lookup(entity, "prefProlog", ((PreferenceLevel)entity.getObject()).getPrefProlog())) {
            save = false;
        }
        if (entity.getObject() instanceof RefTableEntry && this.lookup(entity, "reference", ((RefTableEntry)entity.getObject()).getReference())) {
            save = false;
        }
        if (entity.getObject() instanceof TimetableManager && this.lookup(entity, "externalUniqueId", ((TimetableManager)entity.getObject()).getExternalUniqueId())) {
            save = false;
        }
        if (entity.getObject() instanceof ItypeDesc && this.lookup(entity, "itype", Integer.valueOf(entity.getId()))) {
            save = false;
        }
        if (entity.getObject() instanceof SolverInfoDef && this.lookup(entity, "name", ((SolverInfoDef)entity.getObject()).getName())) {
            save = false;
        }
        if (entity.getObject() instanceof SolverParameterGroup && this.lookup(entity, "name", ((SolverParameterGroup)entity.getObject()).getName())) {
            save = false;
        }
        if (entity.getObject() instanceof SolverPredefinedSetting && this.lookup(entity, "name", ((SolverPredefinedSetting)entity.getObject()).getName())) {
            save = false;
        }
        if (entity.getObject() instanceof Roles && this.lookup(entity, "reference", ((Roles)entity.getObject()).getReference())) {
            save = false;
        }
        if (entity.getObject() instanceof OfferingConsentType && this.lookup(entity, "label", ((OfferingConsentType)entity.getObject()).getLabel())) {
            save = false;
        }
        if (entity.getObject() instanceof ChangeLog) {
            save = false;
            lookup = false;
        }
        if (entity.getObject() instanceof OnlineSectioningLog) {
            save = false;
            lookup = false;
        }
        if (entity.getObject() instanceof Settings && this.lookup(entity, "key", ((Settings)entity.getObject()).getKey())) {
            save = false;
        }
        if (entity.getObject() instanceof EventContact && this.lookup(entity, "externalUniqueId", ((EventContact)entity.getObject()).getExternalUniqueId())) {
            save = false;
        }
        if (save) {
            this.iAllEntitites.add(entity);
        }
        if (lookup) {
            Map<String, Entity> entityOfThisType = this.iEntities.get(entity.getName());
            if (entityOfThisType == null) {
                entityOfThisType = new Hashtable<String, Entity>();
                this.iEntities.put(entity.getName(), entityOfThisType);
            }
            entityOfThisType.put(entity.getId(), entity);
        }
        if (entity.getObject() instanceof Student) {
            Student student = (Student)entity.getObject();
            this.iStudents.put(student.getExternalUniqueId(), student);
        }
    }

    public void create(TableData.Table table) throws InstantiationException, IllegalAccessException, DocumentException {
        ClassMetadata metadata = this.iHibSessionFactory.getClassMetadata(table.getName());
        if (metadata == null) {
            return;
        }
        PersistentClass mapping = _RootDAO.getConfiguration().getClassMapping(table.getName());
        HashMap<String, Integer> lengths = new HashMap<String, Integer>();
        for (String property : metadata.getPropertyNames()) {
            Object o;
            Iterator i;
            Type type;
            if ("org.unitime.timetable.model.CurriculumClassification.students".equals(metadata.getEntityName() + "." + property) || !((type = metadata.getPropertyType(property)) instanceof StringType) || !(i = mapping.getProperty(property).getColumnIterator()).hasNext() || !((o = i.next()) instanceof Column)) continue;
            Column column = (Column)o;
            lengths.put(property, column.getLength());
        }
        this.iProgress.setPhase(metadata.getEntityName().substring(metadata.getEntityName().lastIndexOf(46) + 1) + " [" + table.getRecordCount() + "]", (long)table.getRecordCount());
        for (TableData.Record record : table.getRecordList()) {
            this.iProgress.incProgress();
            Object object = metadata.getMappedClass().newInstance();
            for (String property : metadata.getPropertyNames()) {
                TableData.Element element = null;
                for (TableData.Element e : record.getElementList()) {
                    if (!e.getName().equals(property)) continue;
                    element = e;
                    break;
                }
                if (element == null) continue;
                Object value = null;
                Type type = metadata.getPropertyType(property);
                if (type instanceof PrimitiveType) {
                    if (type instanceof BooleanType) {
                        value = new Boolean("true".equals(element.getValue(0)));
                    } else if (type instanceof ByteType) {
                        value = Byte.valueOf(element.getValue(0));
                    } else if (type instanceof CharacterType) {
                        value = Character.valueOf(element.getValue(0).charAt(0));
                    } else if (type instanceof DoubleType) {
                        value = Double.valueOf(element.getValue(0));
                    } else if (type instanceof FloatType) {
                        value = Float.valueOf(element.getValue(0));
                    } else if (type instanceof IntegerType) {
                        value = Integer.valueOf(element.getValue(0));
                    } else if (type instanceof LongType) {
                        value = Long.valueOf(element.getValue(0));
                    } else if (type instanceof ShortType) {
                        value = Short.valueOf(element.getValue(0));
                    }
                } else if (type instanceof DateType) {
                    try {
                        value = new SimpleDateFormat("dd MMMM yyyy", Localization.getJavaLocale()).parse(element.getValue(0));
                    }
                    catch (ParseException e) {
                        value = new DateType().fromStringValue(element.getValue(0));
                    }
                } else if (type instanceof TimestampType) {
                    value = new TimestampType().fromStringValue(element.getValue(0));
                } else if (type instanceof StringType) {
                    value = element.getValue(0);
                    Integer len = (Integer)lengths.get(property);
                    if (len != null && value.toString().length() > len) {
                        this.message("Value is  too long, truncated (property " + metadata.getEntityName() + "." + property + ", length " + len + ")", record.getId());
                        value = value.toString().substring(0, len);
                    }
                } else if (type instanceof BinaryType) {
                    value = element.getValueBytes(0).toByteArray();
                } else if (type instanceof CustomType && type.getReturnedClass().equals(Document.class)) {
                    value = new SAXReader().read((Reader)new StringReader(element.getValue(0)));
                } else if (!(type instanceof EntityType) && !(type instanceof CollectionType)) {
                    this.message("Unknown type " + type.getClass().getName() + " (property " + metadata.getEntityName() + "." + property + ", class " + type.getReturnedClass() + ")", record.getId());
                }
                if (value == null) continue;
                metadata.setPropertyValue(object, property, value);
            }
            this.add(new Entity(metadata, record, object, record.getId()));
        }
    }

    protected void message(String message, String id) {
        Set<String> ids = this.iMessages.get(message);
        if (ids == null) {
            ids = new HashSet<String>();
            this.iMessages.put(message, ids);
        }
        if (ids.add(id) && ids.size() <= 5) {
            this.iProgress.warn(message + (id.isEmpty() ? "" : ": " + id));
        }
    }

    private Object checkUnknown(Class clazz, String id, Object object) {
        if (object == null) {
            this.message("Unknown " + clazz.getName().substring(clazz.getName().lastIndexOf(46) + 1), id);
        }
        return object;
    }

    private void printMessages() {
        for (String message : new TreeSet<String>(this.iMessages.keySet())) {
            TreeSet ids = new TreeSet(this.iMessages.get(message));
            if (ids.isEmpty() || ids.size() == 1 && ids.contains("")) {
                this.iProgress.info(message);
                continue;
            }
            String list = "";
            int size = 0;
            for (String id : ids) {
                if (!list.isEmpty()) {
                    list = list + ", ";
                }
                if (size > 20) {
                    list = list + "... " + (ids.size() - size) + " more";
                    break;
                }
                list = list + id;
                ++size;
            }
            this.iProgress.info(message + ": " + list);
        }
    }

    protected Object get(Class clazz, String id) {
        Entity entity;
        if (clazz.equals(String.class) || clazz.equals(StringType.class)) {
            return id;
        }
        if (clazz.equals(Character.class) || clazz.equals(CharacterType.class)) {
            return id == null || id.isEmpty() ? null : Character.valueOf(id.charAt(0));
        }
        if (clazz.equals(Byte.class) || clazz.equals(ByteType.class)) {
            return Byte.valueOf(id);
        }
        if (clazz.equals(Short.class) || clazz.equals(ShortType.class)) {
            return Short.valueOf(id);
        }
        if (clazz.equals(Integer.class) || clazz.equals(IntegerType.class)) {
            return Integer.valueOf(id);
        }
        if (clazz.equals(Long.class) || clazz.equals(LongType.class)) {
            return Long.valueOf(id);
        }
        if (clazz.equals(Float.class) || clazz.equals(FloatType.class)) {
            return Float.valueOf(id);
        }
        if (clazz.equals(Double.class) || clazz.equals(DoubleType.class)) {
            return Double.valueOf(id);
        }
        if (clazz.equals(Boolean.class) || clazz.equals(BooleanType.class)) {
            return Boolean.valueOf(id);
        }
        Map<String, Entity> entities = this.iEntities.get(clazz.getName());
        if (entities != null && (entity = entities.get(id)) != null) {
            return entity.getObject();
        }
        for (Map.Entry<String, Map<String, Entity>> entry : this.iEntities.entrySet()) {
            Entity o = entry.getValue().get(id);
            if (o == null || !clazz.isInstance(o.getObject())) continue;
            return o.getObject();
        }
        if (clazz.equals(Session.class)) {
            return this.iEntities.get(Session.class.getName()).values().iterator().next().getObject();
        }
        if (clazz.equals(Student.class)) {
            return this.checkUnknown(clazz, id, this.iStudents.get(id));
        }
        if (this.iIsClone) {
            return this.checkUnknown(clazz, id, this.iHibSession.get(clazz, (Serializable)(clazz.equals(ItypeDesc.class) ? (Number)Integer.valueOf(id) : (Number)Long.valueOf(id))));
        }
        return this.checkUnknown(clazz, id, null);
    }

    private boolean fix(Entity entity) {
        Department department;
        if (entity.getObject() instanceof SolverParameterDef) {
            List list;
            SolverParameterDef def = (SolverParameterDef)entity.getObject();
            TableData.Element element = entity.getElement("group");
            SolverParameterGroup group = (SolverParameterGroup)this.get(SolverParameterGroup.class, element.getValue(0));
            if (group != null && group.getUniqueId() != null && !(list = this.iHibSession.createCriteria(SolverParameterDef.class).add((Criterion)Restrictions.eq((String)"name", (Object)def.getName())).add((Criterion)Restrictions.eq((String)"group", (Object)group)).list()).isEmpty()) {
                if (list.size() > 1) {
                    this.message("Multiple results for SolverParameterDef (name=" + def.getName() + ", group=" + group.getName() + ")", "");
                }
                entity.setObject(list.get(0));
                return false;
            }
        }
        if (entity.getObject() instanceof ManagerRole) {
            Object object;
            Roles role = (Roles)this.get(Roles.class, entity.getElement("role").getValue(0));
            TimetableManager manager = (TimetableManager)this.get(TimetableManager.class, entity.getElement("timetableManager").getValue(0));
            if (role.getRoleId() != null && manager.getUniqueId() != null && (object = this.iHibSession.createCriteria(ManagerRole.class).add((Criterion)Restrictions.eq((String)"role", (Object)role)).add((Criterion)Restrictions.eq((String)"timetableManager", (Object)manager)).uniqueResult()) != null) {
                entity.setObject(object);
                return false;
            }
        }
        if (entity.getObject() instanceof Department && (department = (Department)entity.getObject()).isInheritInstructorPreferences() == null) {
            department.setInheritInstructorPreferences(department.isExternalManager() == false);
        }
        if (entity.getObject() instanceof ItypeDesc) {
            ItypeDesc itype = (ItypeDesc)entity.getObject();
            itype.setItype(new Integer(entity.getId()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(InputStream input, Progress progress) throws IOException, InstantiationException, IllegalAccessException, DocumentException {
        this.iIn = input;
        this.iProgress = progress;
        this.iHibSession = new _RootDAO().createNewSession();
        this.iHibSession.setCacheMode(CacheMode.IGNORE);
        this.iHibSessionFactory = this.iHibSession.getSessionFactory();
        try {
            CodedInputStream cin = CodedInputStream.newInstance((InputStream)this.iIn);
            cin.setSizeLimit(0x40000000);
            this.iProgress.setPhase("Loading data", 1L);
            TableData.Table t = null;
            while ((t = SessionRestore.readTable(cin)) != null) {
                if (this.iDebug != null) {
                    this.iDebug.println("## " + t.getName() + " ##");
                    this.iDebug.print(t.toString());
                    this.iDebug.flush();
                }
                this.create(t);
            }
            this.iProgress.incProgress();
            this.iHibSession.setFlushMode(FlushMode.MANUAL);
            this.iProgress.setPhase("Fixing", (long)this.iAllEntitites.size());
            Iterator<Entity> i = this.iAllEntitites.iterator();
            while (i.hasNext()) {
                this.iProgress.incProgress();
                if (this.fix(i.next())) continue;
                i.remove();
            }
            this.iProgress.setPhase("Saving (not-null)", (long)this.iAllEntitites.size());
            ArrayList<Entity> save = new ArrayList<Entity>(this.iAllEntitites);
            boolean saved = true;
            while (!save.isEmpty() && saved) {
                saved = false;
                Iterator i2 = save.iterator();
                while (i2.hasNext()) {
                    Entity e = (Entity)i2.next();
                    if (e.canSave() != null) continue;
                    this.iProgress.incProgress();
                    e.fixRelationsNullOnly();
                    this.iHibSession.save(e.getObject());
                    i2.remove();
                    saved = true;
                }
                this.iHibSession.flush();
            }
            this.iProgress.setPhase("Saving (all)", (long)this.iAllEntitites.size());
            for (Entity e : this.iAllEntitites) {
                this.iProgress.incProgress();
                String property = e.canSave();
                if (property == null) {
                    e.fixRelations();
                    this.iHibSession.update(e.getObject());
                    continue;
                }
                this.message("Skipping " + e.getAbbv() + " (missing not-null relation " + property + ")", e.getId());
            }
            this.iProgress.setPhase("Flush", 1L);
            this.iHibSession.flush();
            this.iProgress.incProgress();
            this.printMessages();
            this.iProgress.setStatus("All done.");
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.iHibSession.close();
            throw throwable;
        }
        this.iHibSession.close();
    }

    public static TableData.Table readTable(CodedInputStream cin) throws IOException {
        if (cin.isAtEnd()) {
            return null;
        }
        int size = cin.readInt32();
        int limit = cin.pushLimit(size);
        TableData.Table ret = TableData.Table.parseFrom(cin);
        cin.popLimit(limit);
        cin.resetSizeCounter();
        return ret;
    }

    public static void main(String[] args) {
        try {
            Properties props = new Properties();
            props.setProperty("log4j.rootLogger", "DEBUG, A1");
            props.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
            props.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
            props.setProperty("log4j.appender.A1.layout.ConversionPattern", "%-5p %m%n");
            props.setProperty("log4j.logger.org.hibernate", "INFO");
            props.setProperty("log4j.logger.org.hibernate.cfg", "WARN");
            props.setProperty("log4j.logger.org.hibernate.cache.EhCacheProvider", "ERROR");
            props.setProperty("log4j.logger.org.unitime.commons.hibernate", "INFO");
            props.setProperty("log4j.logger.net", "INFO");
            PropertyConfigurator.configure((Properties)props);
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            FileInputStream in = new FileInputStream(args[0]);
            SessionRestore restore = new SessionRestore();
            PrintWriter debug = null;
            if (args.length >= 2) {
                debug = new PrintWriter(args[1]);
                restore.debug(debug);
            }
            Progress progress = Progress.getInstance();
            progress.addProgressListener((ProgressListener)new ProgressWriter(System.out));
            restore.restore(in, progress);
            in.close();
            if (debug != null) {
                debug.close();
            }
            HibernateUtil.closeHibernate();
        }
        catch (Exception e) {
            sLog.fatal((Object)("Backup failed: " + e.getMessage()), (Throwable)e);
        }
    }

    protected class Entity {
        private ClassMetadata iMetaData;
        private TableData.Record iRecord;
        private Object iObject;
        private String iId;

        protected Entity(ClassMetadata metadata, TableData.Record record, Object object, String id) {
            this.iMetaData = metadata;
            this.iRecord = record;
            this.iObject = object;
            this.iId = id;
        }

        public ClassMetadata getMetaData() {
            return this.iMetaData;
        }

        public String getName() {
            return this.getMetaData().getEntityName();
        }

        public String getAbbv() {
            return this.getName().substring(this.getName().lastIndexOf(46) + 1);
        }

        public Object getObject() {
            return this.iObject;
        }

        public void setObject(Object object) {
            this.iObject = object;
        }

        public String getId() {
            return this.iId;
        }

        public TableData.Record getRecord() {
            return this.iRecord;
        }

        public TableData.Element getElement(String property) {
            for (TableData.Element e : this.getRecord().getElementList()) {
                if (!e.getName().equals(property)) continue;
                return e;
            }
            return null;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Entity)) {
                return false;
            }
            Entity e = (Entity)o;
            return this.getName().equals(e.getName()) && this.getId().equals(e.getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public String toString() {
            return this.getAbbv() + "@" + this.getId();
        }

        public String canSave() {
            for (int i = 0; i < this.getMetaData().getPropertyNames().length; ++i) {
                Object value;
                TableData.Element element;
                Type type;
                if (this.getMetaData().getPropertyNullability()[i] || !((type = this.getMetaData().getPropertyTypes()[i]) instanceof EntityType) || (element = this.getElement(this.getMetaData().getPropertyNames()[i])) == null || (value = SessionRestore.this.get(type.getReturnedClass(), element.getValue(0))) != null && SessionRestore.this.iHibSession.contains(value)) continue;
                return this.getMetaData().getPropertyNames()[i];
            }
            return null;
        }

        public void fixRelationsNullOnly() {
            Department dept;
            ExamType type;
            Curriculum curriculum;
            Class_ clazz;
            for (int i = 0; i < this.getMetaData().getPropertyNames().length; ++i) {
                Object value;
                TableData.Element element;
                Type type2;
                String property = this.getMetaData().getPropertyNames()[i];
                if (this.getMetaData().getPropertyNullability()[i] || !((type2 = this.getMetaData().getPropertyTypes()[i]) instanceof EntityType) || (element = this.getElement(this.getMetaData().getPropertyNames()[i])) == null || (value = SessionRestore.this.get(type2.getReturnedClass(), element.getValue(0))) == null) continue;
                if (!SessionRestore.this.iHibSession.contains(value)) {
                    SessionRestore.this.message("Required " + this.getAbbv() + "." + property + " has transient value", this.getId() + "-" + element.getValue(0));
                    continue;
                }
                this.getMetaData().setPropertyValue(this.getObject(), this.getMetaData().getPropertyNames()[i], value);
            }
            if (this.getObject() instanceof Class_ && (clazz = (Class_)this.getObject()).getCancelled() == null) {
                clazz.setCancelled(false);
            }
            if (this.getObject() instanceof Curriculum && (curriculum = (Curriculum)this.getObject()).isMultipleMajors() == null) {
                curriculum.setMultipleMajors(false);
            }
            if (this.getObject() instanceof ExamType && (type = (ExamType)this.getObject()).getHighlightInEvents() == null) {
                type.setHighlightInEvents(type.getType() == 0);
            }
            if (this.getObject() instanceof SolverInfo) {
                SolverInfo info = (SolverInfo)this.getObject();
                TableData.Element element = this.getElement("data");
                if (element != null) {
                    info.setData(element.getValueBytes(0).toByteArray());
                } else {
                    element = this.getElement("value");
                    try {
                        Document value = new SAXReader().read((Reader)new StringReader(element.getValue(0)));
                        info.setValue(value);
                    }
                    catch (DocumentException e) {
                        sLog.warn((Object)("Failed to parse solver info for " + this.getId() + ": " + e.getMessage()));
                    }
                }
            }
            if (this.getObject() instanceof Department && (dept = (Department)this.getObject()).isAllowStudentScheduling() == null) {
                dept.setAllowStudentScheduling(true);
            }
        }

        public void fixRelations() {
            Location loc;
            for (int i = 0; i < this.getMetaData().getPropertyNames().length; ++i) {
                Object v;
                AbstractCollection set;
                TableData.Element element;
                String property = this.getMetaData().getPropertyNames()[i];
                if (!this.getMetaData().getPropertyNullability()[i]) continue;
                Type type = this.getMetaData().getPropertyType(property);
                if (type instanceof EntityType) {
                    Object value;
                    element = this.getElement(property);
                    if (element == null || element.getValueCount() == 0 || (value = SessionRestore.this.get(type.getReturnedClass(), element.getValue(0))) == null) continue;
                    if (!SessionRestore.this.iHibSession.contains(value)) {
                        SessionRestore.this.message("Optional " + this.getAbbv() + "." + property + " has transient value", this.getId() + "-" + element.getValue(0));
                        continue;
                    }
                    this.getMetaData().setPropertyValue(this.getObject(), property, value);
                    continue;
                }
                if (!(type instanceof CollectionType) || (element = this.getElement(property)) == null) continue;
                Class clazz = ((CollectionType)type).getElementType((SessionFactoryImplementor)SessionRestore.this.iHibSessionFactory).getReturnedClass();
                if (type instanceof SetType) {
                    set = new HashSet();
                    for (String id : element.getValueList()) {
                        v = SessionRestore.this.get(clazz, id);
                        if (v == null) continue;
                        if (!SessionRestore.this.iHibSession.contains(v)) {
                            SessionRestore.this.message("Collection " + this.getAbbv() + "." + property + " has transient value", this.getId() + "-" + id);
                            continue;
                        }
                        set.add(v);
                    }
                    this.getMetaData().setPropertyValue(this.getObject(), property, set);
                    continue;
                }
                if (type instanceof ListType) {
                    set = new ArrayList();
                    for (String id : element.getValueList()) {
                        v = SessionRestore.this.get(clazz, id);
                        if (v == null) continue;
                        if (!SessionRestore.this.iHibSession.contains(v)) {
                            SessionRestore.this.message("Collection " + this.getAbbv() + "." + property + " has transient value", this.getId() + "-" + id);
                            continue;
                        }
                        set.add(v);
                    }
                    this.getMetaData().setPropertyValue(this.getObject(), property, set);
                    continue;
                }
                SessionRestore.this.message("Unimplemented collection type: " + type.getClass().getName() + " (" + this.getAbbv() + "." + property + ")", "");
            }
            if (this.getObject() instanceof ExamOwner) {
                ExamOwner owner = (ExamOwner)this.getObject();
                switch (owner.getOwnerType()) {
                    case 3: {
                        owner.setOwnerId(((Class_)SessionRestore.this.get(Class_.class, owner.getOwnerId().toString())).getUniqueId());
                        break;
                    }
                    case 2: {
                        owner.setOwnerId(((InstrOfferingConfig)SessionRestore.this.get(InstrOfferingConfig.class, owner.getOwnerId().toString())).getUniqueId());
                        break;
                    }
                    case 1: {
                        owner.setOwnerId(((CourseOffering)SessionRestore.this.get(CourseOffering.class, owner.getOwnerId().toString())).getUniqueId());
                        break;
                    }
                    case 0: {
                        owner.setOwnerId(((InstructionalOffering)SessionRestore.this.get(InstructionalOffering.class, owner.getOwnerId().toString())).getUniqueId());
                    }
                }
            }
            if (this.getObject() instanceof RelatedCourseInfo) {
                RelatedCourseInfo owner = (RelatedCourseInfo)this.getObject();
                switch (owner.getOwnerType()) {
                    case 3: {
                        owner.setOwnerId(((Class_)SessionRestore.this.get(Class_.class, owner.getOwnerId().toString())).getUniqueId());
                        break;
                    }
                    case 2: {
                        owner.setOwnerId(((InstrOfferingConfig)SessionRestore.this.get(InstrOfferingConfig.class, owner.getOwnerId().toString())).getUniqueId());
                        break;
                    }
                    case 1: {
                        owner.setOwnerId(((CourseOffering)SessionRestore.this.get(CourseOffering.class, owner.getOwnerId().toString())).getUniqueId());
                        break;
                    }
                    case 0: {
                        owner.setOwnerId(((InstructionalOffering)SessionRestore.this.get(InstructionalOffering.class, owner.getOwnerId().toString())).getUniqueId());
                    }
                }
            }
            if (this.getObject() instanceof TravelTime) {
                Location l2;
                TravelTime tt = (TravelTime)this.getObject();
                Location l1 = (Location)SessionRestore.this.get(Location.class, tt.getLocation1Id().toString());
                if (l1 != null) {
                    tt.setLocation1Id(l1.getUniqueId());
                }
                if ((l2 = (Location)SessionRestore.this.get(Location.class, tt.getLocation2Id().toString())) != null) {
                    tt.setLocation2Id(l2.getUniqueId());
                }
            }
            if (this.getObject() instanceof Location && (loc = (Location)this.getObject()).getManagerIds() != null) {
                String managerIds = null;
                StringTokenizer stk = new StringTokenizer(loc.getManagerIds(), ",");
                while (stk.hasMoreTokens()) {
                    Department dept = (Department)SessionRestore.this.get(Department.class, stk.nextToken());
                    if (dept == null) continue;
                    if (managerIds == null) {
                        managerIds = dept.getUniqueId().toString();
                        continue;
                    }
                    managerIds = managerIds + "," + dept.getUniqueId();
                }
                loc.setManagerIds(managerIds);
            }
        }
    }
}

