/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api.connectors;

import java.io.IOException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.unitime.timetable.api.ApiConnector;
import org.unitime.timetable.api.ApiHelper;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.rights.Right;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="/api/json")
public class JsonConnector
extends ApiConnector {
    @Autowired
    ApplicationContext applicationContext;

    protected <T extends GwtRpcResponse> void execute(String type, ApiHelper helper) throws IOException {
        try {
            GwtRpcRequest request = (GwtRpcRequest)helper.getRequest(Class.forName(type));
            GwtRpcImplementation implementation = (GwtRpcImplementation)this.applicationContext.getBean(type);
            Object response = implementation.execute(request, helper.getSessionContext());
            helper.setResponse(response);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new IllegalArgumentException("There is no implementation for the given request type.", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Given type was not recognized.", e);
        }
    }

    @Override
    public void doPost(ApiHelper helper) throws IOException {
        helper.getSessionContext().checkPermissionAnyAuthority(Right.ApiJsonConnector, new Qualifiable[0]);
        String type = helper.getParameter("type");
        if (type == null) {
            throw new IllegalArgumentException("TYPE parameter not provided.");
        }
        this.execute(type, helper);
    }

    @Override
    protected String getName() {
        return "json";
    }
}

