/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.cpsolver.ifs.util.DataProperties;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.form.SolverSettingsForm;
import org.unitime.timetable.model.SolverParameter;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.SolverPredefinedSetting;
import org.unitime.timetable.model.dao.SolverParameterDAO;
import org.unitime.timetable.model.dao.SolverParameterDefDAO;
import org.unitime.timetable.model.dao.SolverPredefinedSettingDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;
import org.unitime.timetable.util.ExportUtils;

@Service(value="/solverSettings")
public class SolverSettingsAction
extends Action {
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;
    @Autowired
    SolverService<StudentSolverProxy> studentSectioningSolverService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionMessages errors;
        String id;
        SolverPredefinedSetting setting;
        Session hibSession;
        SolverPredefinedSettingDAO dao;
        String op;
        SolverSettingsForm myForm = (SolverSettingsForm)form;
        this.sessionContext.checkPermission(Right.SolverConfigurations);
        String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        if (op == null) {
            op = request.getParameter("op2");
        }
        boolean list = true;
        if (op == null) {
            myForm.setOp("Add Solver Configuration");
            op = "list";
            myForm.loadDefaults();
        }
        if ("Back".equals(op)) {
            myForm.reset(mapping, request);
            myForm.setOp("Add Solver Configuration");
            myForm.loadDefaults();
        }
        if ("Add Solver Configuration".equals(op)) {
            myForm.setOp("Save");
            myForm.loadDefaults();
            list = false;
        }
        if ("Refresh".equals(op)) {
            myForm.setOp(myForm.getUniqueId() == null || myForm.getUniqueId() <= 0L ? "Save" : "Update");
            myForm.loadDefaults(request);
            list = false;
        }
        if ("Update".equals(op) || "Save".equals(op)) {
            ActionErrors errors2 = myForm.validate(mapping, request);
            if (errors2.size() > 0) {
                list = false;
                this.saveErrors(request, (ActionMessages)errors2);
            } else {
                Transaction tx = null;
                try {
                    dao = new SolverPredefinedSettingDAO();
                    SolverParameterDAO pDao = new SolverParameterDAO();
                    hibSession = dao.getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    setting = null;
                    setting = op.equals("Save") ? new SolverPredefinedSetting() : (SolverPredefinedSetting)dao.get(myForm.getUniqueId(), hibSession);
                    setting.setName(myForm.getName());
                    setting.setDescription(myForm.getDescription());
                    setting.setAppearance(new Integer(myForm.getAppearanceIdx()));
                    Set<SolverParameter> params = setting.getParameters();
                    if (params == null) {
                        params = new HashSet<SolverParameter>();
                        setting.setParameters(params);
                    }
                    for (SolverParameterDef def : new SolverParameterDefDAO().findAll(hibSession)) {
                        SolverParameter param = null;
                        for (SolverParameter solverParameter : params) {
                            if (!solverParameter.getDefinition().equals(def)) continue;
                            param = solverParameter;
                            break;
                        }
                        if (!def.isVisible().booleanValue()) {
                            if (param == null) continue;
                            params.remove(param);
                            pDao.delete(param, hibSession);
                            continue;
                        }
                        String value = myForm.getParameter(def.getUniqueId());
                        boolean bl = myForm.getUseDefault(def.getUniqueId());
                        if (bl) {
                            if (param == null) continue;
                            params.remove(param);
                            pDao.delete(param, hibSession);
                            continue;
                        }
                        if (param == null) {
                            param = new SolverParameter();
                            param.setDefinition(def);
                        }
                        param.setValue(value == null ? def.getDefault() : value);
                        pDao.saveOrUpdate(param, hibSession);
                        params.add(param);
                    }
                    dao.saveOrUpdate(setting, hibSession);
                    if (tx != null) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    Debug.error(e);
                }
                myForm.reset(mapping, request);
                myForm.loadDefaults();
                myForm.setOp("Add Solver Configuration");
            }
        }
        if (op.equals("Edit")) {
            id = request.getParameter("id");
            errors = new ActionMessages();
            if (id == null || id.trim().length() == 0) {
                errors.add("key", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                this.saveErrors(request, errors);
            } else {
                Transaction tx = null;
                try {
                    SolverPredefinedSettingDAO dao2 = new SolverPredefinedSettingDAO();
                    hibSession = dao2.getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    if ((setting = (SolverPredefinedSetting)dao2.get(new Long(id), hibSession)) == null) {
                        errors.add("name", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                        this.saveErrors(request, errors);
                    } else {
                        myForm.reset(mapping, request);
                        myForm.loadDefaults();
                        myForm.setUniqueId(setting.getUniqueId());
                        myForm.setName(setting.getName());
                        myForm.setDescription(setting.getDescription());
                        myForm.setAppearanceIdx(setting.getAppearance());
                        myForm.setOp("Update");
                        for (SolverParameter param : setting.getParameters()) {
                            if (!param.getDefinition().isVisible().booleanValue()) continue;
                            myForm.setParameter(param.getDefinition().getUniqueId(), param.getValue());
                            myForm.setUseDefault(param.getDefinition().getUniqueId(), Boolean.FALSE);
                        }
                    }
                    if (tx != null) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    Debug.error(e);
                }
                list = false;
            }
        }
        if ("Export".equals(op)) {
            id = request.getParameter("id");
            if ((id == null || id.trim().length() == 0) && myForm.getUniqueId() != null) {
                id = myForm.getUniqueId().toString();
            }
            errors = new ActionMessages();
            if (id == null || id.trim().length() == 0) {
                errors.add("key", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                this.saveErrors(request, errors);
            } else {
                dao = new SolverPredefinedSettingDAO();
                Session hibSession2 = dao.getSession();
                SolverPredefinedSetting setting2 = (SolverPredefinedSetting)dao.get(new Long(id), hibSession2);
                if (setting2 != null) {
                    PrintWriter pw = ExportUtils.getPlainTextWriter(response, setting2.getName() + ".txt");
                    DataProperties properties = null;
                    switch (myForm.getAppearanceIdx()) {
                        case 3: {
                            properties = this.studentSectioningSolverService.createConfig(setting2.getUniqueId(), null);
                            break;
                        }
                        case 2: {
                            properties = this.examinationSolverService.createConfig(setting2.getUniqueId(), null);
                            break;
                        }
                        default: {
                            properties = this.courseTimetablingSolverService.createConfig(setting2.getUniqueId(), null);
                        }
                    }
                    pw.println("## Solver Configuration File");
                    pw.println("## Name: " + setting2.getDescription());
                    pw.println("## Date: " + new Date());
                    pw.println("######################################");
                    Iterator i = hibSession2.createQuery("select g from SolverParameterGroup g order by g.order").iterate();
                    while (i.hasNext()) {
                        SolverParameterGroup g = (SolverParameterGroup)i.next();
                        if (myForm.getAppearanceIdx() == 3 ? g.getType() != 2 : (myForm.getAppearanceIdx() == 2 ? g.getType() != 1 : g.getType() != 0)) continue;
                        pw.println();
                        pw.println("## " + g.getDescription().replaceAll("<br>", "\n#"));
                        pw.println("######################################");
                        TreeSet<SolverParameterDef> parameters = new TreeSet<SolverParameterDef>(g.getParameters());
                        for (SolverParameterDef solverParameterDef : parameters) {
                            String value = properties.getProperty(solverParameterDef.getName(), solverParameterDef.getDefault());
                            if (value == null) continue;
                            pw.println("## " + solverParameterDef.getDescription().replaceAll("<br>", "\n#"));
                            pw.println("## Type: " + solverParameterDef.getType());
                            if (value != null && !value.equals(solverParameterDef.getDefault())) {
                                pw.println("## Default: " + solverParameterDef.getDefault());
                            }
                            pw.println(solverParameterDef.getName() + "=" + properties.getProperty(solverParameterDef.getName(), solverParameterDef.getDefault()));
                            properties.remove((Object)solverParameterDef.getName());
                        }
                    }
                    pw.println();
                    pw.println("## Other Properties");
                    pw.println("######################################");
                    Enumeration e = properties.propertyNames();
                    while (e.hasMoreElements()) {
                        String name = (String)e.nextElement();
                        pw.println(name + "=" + properties.getProperty(name));
                    }
                    pw.flush();
                    pw.close();
                    return null;
                }
                errors.add("name", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                this.saveErrors(request, errors);
                list = false;
            }
        }
        if ("Delete".equals(op)) {
            Transaction tx = null;
            try {
                SolverPredefinedSettingDAO dao3 = new SolverPredefinedSettingDAO();
                Session hibSession3 = dao3.getSession();
                if (hibSession3.getTransaction() == null || !hibSession3.getTransaction().isActive()) {
                    tx = hibSession3.beginTransaction();
                }
                SolverPredefinedSetting setting3 = (SolverPredefinedSetting)dao3.get(myForm.getUniqueId(), hibSession3);
                dao3.delete(setting3, hibSession3);
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                Debug.error(e);
            }
            myForm.reset(mapping, request);
            myForm.setOp("Add Solver Configuration");
        }
        if ("Add Solver Configuration".equals(myForm.getOp())) {
            if (list) {
                this.getSolverSettingsTable(request);
            }
            return mapping.findForward("list");
        }
        return mapping.findForward("Save".equals(myForm.getOp()) ? "add" : "edit");
    }

    private void getSolverSettingsTable(HttpServletRequest request) throws Exception {
        Transaction tx = null;
        WebTable.setOrder(this.sessionContext, "solverSettings.ord", request.getParameter("ord"), 1);
        WebTable webTable = new WebTable(4, null, "solverSettings.do?ord=%%", new String[]{"Reference", "Name", "Appearance"}, new String[]{"left", "left", "left"}, null);
        try {
            List list;
            SolverPredefinedSettingDAO dao = new SolverPredefinedSettingDAO();
            Session hibSession = dao.getSession();
            if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                tx = hibSession.beginTransaction();
            }
            if ((list = hibSession.createCriteria(SolverPredefinedSetting.class).list()).isEmpty()) {
                webTable.addLine(null, new String[]{"No solver settings defined."}, null, null);
            } else {
                for (SolverPredefinedSetting setting : list) {
                    String onClick = "onClick=\"document.location='solverSettings.do?op=Edit&id=" + setting.getUniqueId() + "';\"";
                    if (setting.getAppearance() >= SolverPredefinedSetting.sAppearances.length) continue;
                    webTable.addLine(onClick, new String[]{setting.getName(), setting.getDescription(), SolverPredefinedSetting.sAppearances[setting.getAppearance()]}, new Comparable[]{setting.getName(), setting.getDescription(), setting.getAppearance()});
                }
            }
            if (tx != null) {
                tx.commit();
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        request.setAttribute("SolverSettings.table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "solverSettings.ord")));
    }
}

