/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.form.ExamPeriodEditForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamStatus;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.ExamPeriodDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

@Service(value="/examPeriodEdit")
public class ExamPeriodEditAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ExamPeriod ep;
            String op;
            ExamPeriodEditForm myForm = (ExamPeriodEditForm)form;
            this.sessionContext.checkPermission(Right.ExaminationPeriods);
            String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
            if (op == null && request.getParameter("op2") != null) {
                op = request.getParameter("op2");
                myForm.setOp(op);
            }
            if (op == null) {
                myForm.load(null, this.sessionContext);
                myForm.setOp("List");
            }
            List<ExamType> types = ExamType.findAll();
            if (!this.sessionContext.hasPermission(Right.StatusIndependent) && this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.ExaminationSolver)) {
                Iterator<ExamType> i = types.iterator();
                while (i.hasNext()) {
                    ExamType t = i.next();
                    ExamStatus status = ExamStatus.findStatus(this.sessionContext.getUser().getCurrentAcademicSessionId(), t.getUniqueId());
                    if (status == null || status.getManagers().isEmpty()) continue;
                    boolean hasManager = false;
                    for (TimetableManager m : status.getManagers()) {
                        if (!this.sessionContext.getUser().getCurrentAuthority().hasQualifier(m)) continue;
                        hasManager = true;
                        break;
                    }
                    if (hasManager) continue;
                    i.remove();
                }
            }
            request.setAttribute("examTypes", types);
            if ("Back".equals(op)) {
                if (myForm.getUniqueId() != null) {
                    request.setAttribute("hash", (Object)myForm.getUniqueId());
                }
                myForm.load(null, this.sessionContext);
                myForm.setOp("List");
            }
            if ("Add Period".equals(op)) {
                myForm.load(null, this.sessionContext);
                myForm.setOp("Save");
            }
            for (ExamType type : ExamTypeDAO.getInstance().findAll()) {
                if (!(type.getLabel() + " Periods").equals(op) || !myForm.getCanAutoSetup(type.getUniqueId())) continue;
                myForm.setAutoSetup(true);
                myForm.setExamType(type.getUniqueId());
                myForm.setOp("Save");
            }
            if ("Update".equals(op) || "Save".equals(op)) {
                ActionErrors errors = myForm.validate(mapping, request);
                if (errors.size() > 0) {
                    this.saveErrors(request, (ActionMessages)errors);
                    if (myForm.getAutoSetup()) {
                        myForm.setDays(request);
                    }
                    myForm.setOp(myForm.getUniqueId() < 0L ? "Save" : "Update");
                } else {
                    Transaction tx = null;
                    try {
                        ExamPeriod ep2;
                        Session hibSession = new ExamPeriodDAO().getSession();
                        if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                            tx = hibSession.beginTransaction();
                        }
                        if ((ep2 = myForm.saveOrUpdate(request, this.sessionContext, hibSession)) != null) {
                            ChangeLog.addChange(hibSession, this.sessionContext, ep2, ChangeLog.Source.EXAM_PERIOD_EDIT, "Save".equals(op) ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, null, null);
                        }
                        if (tx != null) {
                            tx.commit();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (tx != null) {
                            tx.rollback();
                        }
                        throw e;
                    }
                    myForm.setOp("List");
                    if (myForm.getUniqueId() != null) {
                        request.setAttribute("hash", (Object)myForm.getUniqueId());
                    }
                }
            }
            if ("Edit".equals(op)) {
                String id = request.getParameter("id");
                ActionMessages errors = new ActionMessages();
                if (id == null || id.trim().length() == 0) {
                    errors.add("key", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                    this.saveErrors(request, errors);
                    return mapping.findForward("list");
                }
                ep = (ExamPeriod)new ExamPeriodDAO().get(new Long(id));
                if (ep == null) {
                    errors.add("name", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                    this.saveErrors(request, errors);
                    return mapping.findForward("list");
                }
                myForm.load(ep, this.sessionContext);
            }
            if ("Delete".equals(op)) {
                Transaction tx = null;
                try {
                    Session hibSession = new ExamPeriodDAO().getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    ep = (ExamPeriod)new ExamPeriodDAO().get(myForm.getUniqueId(), hibSession);
                    ChangeLog.addChange(hibSession, this.sessionContext, ep, ChangeLog.Source.EXAM_PERIOD_EDIT, ChangeLog.Operation.DELETE, null, null);
                    myForm.delete(this.sessionContext, hibSession);
                    tx.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                myForm.load(null, this.sessionContext);
                myForm.setOp("List");
            }
            if ("List".equals(myForm.getOp())) {
                this.getExamPeriods(request);
                return mapping.findForward("list");
            }
            if ("Reload".equals(myForm.getOp())) {
                if (myForm.getExamType() != null && myForm.getExamType() >= 0L) {
                    this.sessionContext.setAttribute("Exam.Type", (Object)myForm.getExamType());
                    myForm.load(null, this.sessionContext);
                } else {
                    myForm.reset(mapping, request);
                    myForm.setEditable(true);
                }
                myForm.setOp("Save");
            }
            return mapping.findForward(myForm.getAutoSetup() ? "midterm" : (myForm.getUniqueId() < 0L ? "add" : "edit"));
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    private void getExamPeriods(HttpServletRequest request) throws Exception {
        WebTable.setOrder(this.sessionContext, "examPeriods.ord", request.getParameter("ord"), 1);
        WebTable webTable = new WebTable(8, null, "examPeriodEdit.do?ord=%%", new String[]{"Type", "Date", "Start Time", "End Time", "Length", "Event Start Offset", "Event Stop Offset", "Preference"}, new String[]{"left", "left", "left", "left", "right", "right", "right", "left"}, null);
        TreeSet<ExamPeriod> periods = ExamPeriod.findAll(this.sessionContext.getUser().getCurrentAcademicSessionId(), (Long)null);
        if (periods.isEmpty()) {
            webTable.addLine(null, new String[]{"No examination periods defined for this session."}, null, null);
        }
        Formats.Format<Date> sdf = Formats.getDateFormat(Formats.Pattern.DATE_MEETING);
        Formats.Format<Date> stf = Formats.getDateFormat(Formats.Pattern.TIME_SHORT);
        HashSet<ExamType> types = null;
        if (!this.sessionContext.hasPermission(Right.StatusIndependent) && this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.ExaminationSolver)) {
            types = new HashSet<ExamType>();
            block0: for (ExamType t : ExamType.findAll()) {
                ExamStatus status = ExamStatus.findStatus(this.sessionContext.getUser().getCurrentAcademicSessionId(), t.getUniqueId());
                if (status != null && !status.getManagers().isEmpty()) {
                    for (TimetableManager m : status.getManagers()) {
                        if (!this.sessionContext.getUser().getCurrentAuthority().hasQualifier(m)) continue;
                        types.add(t);
                        continue block0;
                    }
                    continue;
                }
                types.add(t);
            }
        }
        for (ExamPeriod ep : periods) {
            if (types != null && !types.contains(ep.getExamType())) continue;
            String onClick = "onClick=\"document.location='examPeriodEdit.do?op=Edit&id=" + ep.getUniqueId() + "';\"";
            webTable.addLine(onClick, new String[]{ep.getExamType().getLabel(), "<a name='" + ep.getUniqueId() + "'>" + sdf.format(ep.getStartDate()) + "</a>", stf.format(ep.getStartTime()), stf.format(ep.getEndTime()), String.valueOf(Constants.SLOT_LENGTH_MIN * ep.getLength()), String.valueOf(Constants.SLOT_LENGTH_MIN * ep.getEventStartOffset()), String.valueOf(Constants.SLOT_LENGTH_MIN * ep.getEventStopOffset()), PreferenceLevel.sNeutral.equals(ep.getPrefLevel().getPrefProlog()) ? "" : "<font color='" + PreferenceLevel.prolog2color(ep.getPrefLevel().getPrefProlog()) + "'>" + ep.getPrefLevel().getPrefName() + "</font>"}, new Comparable[]{ep.getExamType(), ep.getStartDate(), ep.getStartSlot(), Integer.valueOf(ep.getStartSlot() + ep.getLength()), ep.getLength(), ep.getEventStartOffset(), ep.getEventStopOffset(), ep.getPrefLevel().getPrefId()});
        }
        request.setAttribute("ExamPeriods.table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "examPeriods.ord")));
    }
}

