/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable;

import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.internal.SessionFactoryImpl;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.hibernate.connection.DisposableConnectionProvider;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.events.EventExpirationService;
import org.unitime.timetable.model.ApplicationConfig;
import org.unitime.timetable.model.SolverInfo;
import org.unitime.timetable.model.base._BaseRootDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.LogCleaner;
import org.unitime.timetable.util.MessageLogAppender;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.util.queue.QueueProcessor;

@Service(value="startupService")
public class StartupService
implements InitializingBean,
DisposableBean {
    private Exception iInitializationException = null;
    private MessageLogAppender iMessageLogAppender = null;

    public void afterPropertiesSet() throws Exception {
        Debug.info("******* UniTime " + Constants.getVersion() + " build on " + Constants.getReleaseDate() + " is starting up *******");
        try {
            Debug.info(" - Initializing Logging ... ");
            Debug.init(ApplicationProperties.getProperties());
            Debug.info(" - Initializing Hibernate ... ");
            _RootDAO.initialize();
            ApplicationConfig.configureLogging();
            Debug.info(" - Creating Message Log Appender ... ");
            this.iMessageLogAppender = new MessageLogAppender();
            Logger.getRootLogger().addAppender((Appender)this.iMessageLogAppender);
            if (RoomAvailability.getInstance() != null) {
                Debug.info(" - Initializing Room Availability Service ... ");
                RoomAvailability.getInstance().startService();
            }
            Debug.info(" - Cleaning Logs ...");
            LogCleaner.cleanupLogs();
            Debug.info(" - Starting Event Expiration Service ...");
            EventExpirationService.getInstance().start();
            Debug.info("******* UniTime " + Constants.getVersion() + " build on " + Constants.getReleaseDate() + " initialized successfully *******");
        }
        catch (Exception e) {
            Debug.error("UniTime Initialization Failed : " + e.getMessage(), e);
            this.iInitializationException = e;
        }
        finally {
            _RootDAO.closeCurrentThreadSessions();
        }
    }

    public Exception getInitializationException() {
        return this.iInitializationException;
    }

    public void destroy() throws Exception {
        try {
            Debug.info("******* UniTime " + Constants.getVersion() + " build on " + Constants.getReleaseDate() + " is going down *******");
            Debug.info(" - Stopping Event Expiration Service ...");
            EventExpirationService.getInstance().interrupt();
            SolverInfo.stopInfoCacheCleanup();
            ApplicationProperties.stopListener();
            if (RoomAvailability.getInstance() != null) {
                Debug.info(" - Stopping Room Availability Service ... ");
                RoomAvailability.getInstance().stopService();
            }
            QueueProcessor.stopProcessor();
            Debug.info(" - Removing Message Log Appender ... ");
            Logger.getRootLogger().removeAppender((Appender)this.iMessageLogAppender);
            this.iMessageLogAppender.close();
            Debug.info(" - Closing Hibernate ... ");
            new _BaseRootDAO(){

                void closeHibernate() {
                    SessionFactory sf = sSessionFactory;
                    if (sf != null) {
                        ConnectionProvider cp;
                        sSessionFactory = null;
                        if (sf instanceof SessionFactoryImpl && (cp = ((SessionFactoryImpl)sf).getConnectionProvider()) instanceof DisposableConnectionProvider) {
                            try {
                                ((DisposableConnectionProvider)cp).destroy();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        sf.close();
                    }
                }

                protected Class getReferenceClass() {
                    return null;
                }
            }.closeHibernate();
            Debug.info("******* UniTime " + Constants.getVersion() + " shut down successfully *******");
        }
        catch (Exception e) {
            Debug.error("UniTime Shutdown Failed : " + e.getMessage(), e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("UniTime Shutdown Failed : " + e.getMessage(), e);
        }
    }
}

