/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.localization.impl;

import com.google.gwt.i18n.client.Constants;
import com.google.gwt.i18n.client.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.unitime.localization.impl.ExportTranslations;
import org.unitime.localization.impl.PageNameGenerator;
import org.unitime.localization.messages.PageNames;
import org.unitime.timetable.gwt.resources.Constants;
import org.unitime.timetable.gwt.resources.Messages;

public class ImportTranslations {
    private List<ExportTranslations.Bundle> iBundles = new ArrayList<ExportTranslations.Bundle>();
    private List<ExportTranslations.Locale> iLocales = new ArrayList<ExportTranslations.Locale>();
    private Project iProject;
    private File iBaseDir;
    private File iSource;
    private String iTranslations = "Documentation/Translations";
    private boolean iGeneratePageNames = false;
    private String iEncoding = "UTF-8";
    private static final char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public void setProject(Project project) {
        this.iProject = project;
        this.iBaseDir = project.getBaseDir();
    }

    public void setBaseDir(String baseDir) {
        this.iBaseDir = new File(baseDir);
    }

    public void setSource(String source) {
        this.iSource = new File(source);
    }

    public void setEncoding(String encoding) {
        this.iEncoding = encoding;
    }

    public ExportTranslations.Bundle createBundle() {
        ExportTranslations.Bundle bundle = new ExportTranslations.Bundle();
        this.iBundles.add(bundle);
        return bundle;
    }

    public void addBundle(ExportTranslations.Bundle bundle) {
        this.iBundles.add(bundle);
    }

    public void setBundles(String bundles) {
        for (String name : bundles.split(",")) {
            this.addBundle(new ExportTranslations.Bundle(name));
        }
    }

    public ExportTranslations.Locale createLocale() {
        ExportTranslations.Locale locale = new ExportTranslations.Locale();
        this.iLocales.add(locale);
        return locale;
    }

    public void addLocale(ExportTranslations.Locale locale) {
        this.iLocales.add(locale);
    }

    public void setLocales(String locales) {
        for (String value : locales.split(",")) {
            this.addLocale(new ExportTranslations.Locale(value));
        }
    }

    public void setTranslations(String translations) {
        this.iTranslations = translations;
    }

    public void setGeneratePageNames(boolean generatePageNames) {
        this.iGeneratePageNames = generatePageNames;
    }

    public void info(String message) {
        if (this.iProject != null) {
            this.iProject.log(message);
        } else {
            System.out.println("     [info] " + message);
        }
    }

    public void warn(String message) {
        if (this.iProject != null) {
            this.iProject.log(message, 1);
        } else {
            System.out.println("  [warning] " + message);
        }
    }

    public void debug(String message) {
        if (this.iProject != null) {
            this.iProject.log(message, 4);
        } else {
            System.out.println("    [debug] " + message);
        }
    }

    public void error(String message) {
        if (this.iProject != null) {
            this.iProject.log(message, 0);
        } else {
            System.out.println("    [error] " + message);
        }
    }

    private static String array2string(String[] value) {
        String ret = "";
        for (String s : value) {
            if (!ret.isEmpty()) {
                ret = ret + ",";
            }
            ret = ret + s.replace(",", "\\,");
        }
        return ret;
    }

    private static String unicodeEscape(String s, boolean includeColon) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >> 7 > 0) {
                sb.append("\\u");
                sb.append(hexChar[c >> 12 & 0xF]);
                sb.append(hexChar[c >> 8 & 0xF]);
                sb.append(hexChar[c >> 4 & 0xF]);
                sb.append(hexChar[c & 0xF]);
                continue;
            }
            if (c == ':' && includeColon) {
                sb.append("\\:");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void execute() throws BuildException {
        try {
            File translations = new File(this.iBaseDir, this.iTranslations);
            this.info("Importing translations from: " + translations);
            for (ExportTranslations.Bundle bundle : this.iBundles) {
                this.info("Loading " + bundle);
                Class<?> clazz = null;
                File folder = null;
                if (bundle.hasPackage()) {
                    try {
                        clazz = Class.forName(bundle.getPackage() + "." + bundle.getName());
                        folder = new File(this.iSource, bundle.getPackage().replace('.', File.separatorChar));
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                try {
                    clazz = Class.forName("org.unitime.localization.messages." + bundle);
                    folder = new File(this.iSource, "org.unitime.localization.messages.".replace('.', File.separatorChar));
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                try {
                    if (clazz == null) {
                        clazz = Class.forName("org.unitime.timetable.gwt.resources." + bundle);
                        folder = new File(this.iSource, "org.unitime.timetable.gwt.resources.".replace('.', File.separatorChar));
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                if (clazz == null) {
                    this.error("Bundle " + bundle + " not found.");
                    continue;
                }
                boolean constants = Constants.class.isAssignableFrom(clazz);
                for (ExportTranslations.Locale locale : this.iLocales) {
                    this.debug("Locale " + locale);
                    boolean empty = true;
                    File input = new File(translations, bundle.getName() + "_" + locale.getValue() + ".properties");
                    if (!input.exists()) continue;
                    Properties translation = new Properties();
                    translation.load(new InputStreamReader((InputStream)new FileInputStream(input), this.iEncoding));
                    File output = new File(folder, bundle.getName() + "_" + locale.getValue() + ".properties");
                    Properties old = new Properties();
                    if (output.exists()) {
                        old.load(new FileReader(output));
                    }
                    PrintStream out = new PrintStream(output);
                    out.println("# Licensed to The Apereo Foundation under one or more contributor license");
                    out.println("# agreements. See the NOTICE file distributed with this work for");
                    out.println("# additional information regarding copyright ownership.");
                    out.println("#");
                    out.println("# The Apereo Foundation licenses this file to you under the Apache License,");
                    out.println("# Version 2.0 (the \"License\"); you may not use this file except in");
                    out.println("# compliance with the License. You may obtain a copy of the License at:");
                    out.println("#");
                    out.println("# http://www.apache.org/licenses/LICENSE-2.0");
                    out.println("#");
                    out.println("# Unless required by applicable law or agreed to in writing, software");
                    out.println("# distributed under the License is distributed on an \"AS IS\" BASIS,");
                    out.println("# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
                    out.println("#");
                    out.println("# See the License for the specific language governing permissions and");
                    out.println("# limitations under the License.");
                    out.println("#");
                    if (PageNames.class.equals(clazz) && this.iGeneratePageNames) {
                        TreeSet<String> names = new TreeSet<String>();
                        for (Object e : translation.keySet()) {
                            names.add((String)e);
                        }
                        Properties defaults = new Properties();
                        File file = new File(translations, bundle.getName() + ".properties");
                        if (file.exists()) {
                            defaults.load(new FileReader(file));
                        } else {
                            Iterator gen = new PageNameGenerator();
                            ((PageNameGenerator)((Object)gen)).setSource(this.iSource);
                            ((PageNameGenerator)((Object)gen)).execute();
                            defaults = ((PageNameGenerator)((Object)gen)).getProperties();
                        }
                        for (Object e : defaults.keySet()) {
                            names.add((String)e);
                        }
                        for (String string : names) {
                            String text;
                            String value = defaults.getProperty(string);
                            out.println();
                            if (value != null) {
                                out.println("# Default: " + ImportTranslations.unicodeEscape(value, false).trim());
                            }
                            if ((text = translation.getProperty(string)) == null) {
                                if (value != null) {
                                    out.println("# FIXME: Translate \"" + ImportTranslations.unicodeEscape(value, false) + "\"");
                                } else {
                                    out.println("# FIXME: Translate " + string);
                                }
                                out.println("# " + string + "=");
                                continue;
                            }
                            out.println(string + "=" + ImportTranslations.unicodeEscape(text, true));
                            empty = false;
                        }
                    } else {
                        TreeSet<Method> methods = new TreeSet<Method>(new Comparator<Method>(){

                            @Override
                            public int compare(Method m1, Method m2) {
                                return m1.getName().compareTo(m2.getName());
                            }
                        });
                        for (Method method : clazz.getMethods()) {
                            methods.add(method);
                        }
                        for (Method method : methods) {
                            boolean doNotTranslate;
                            Constants.DefaultStringMapValue dsm;
                            Constants.DefaultStringArrayValue dsa;
                            Constants.DefaultStringValue ds;
                            Constants.DefaultIntValue di;
                            Constants.DefaultFloatValue df;
                            Constants.DefaultDoubleValue dd;
                            Constants.DefaultBooleanValue db;
                            String value = null;
                            Messages.DefaultMessage defaultMessage = method.getAnnotation(Messages.DefaultMessage.class);
                            if (defaultMessage != null) {
                                value = defaultMessage.value();
                            }
                            if ((db = method.getAnnotation(Constants.DefaultBooleanValue.class)) != null) {
                                String string = value = db.value() ? "true" : "false";
                            }
                            if ((dd = method.getAnnotation(Constants.DefaultDoubleValue.class)) != null) {
                                value = String.valueOf(dd.value());
                            }
                            if ((df = method.getAnnotation(Constants.DefaultFloatValue.class)) != null) {
                                value = String.valueOf(df.value());
                            }
                            if ((di = method.getAnnotation(Constants.DefaultIntValue.class)) != null) {
                                value = String.valueOf(di.value());
                            }
                            if ((ds = method.getAnnotation(Constants.DefaultStringValue.class)) != null) {
                                value = ds.value();
                            }
                            if ((dsa = method.getAnnotation(Constants.DefaultStringArrayValue.class)) != null) {
                                value = ImportTranslations.array2string(dsa.value());
                            }
                            if ((dsm = method.getAnnotation(Constants.DefaultStringMapValue.class)) != null) {
                                value = ImportTranslations.array2string(dsm.value());
                            }
                            if ("translateMessage".equals(method.getName())) continue;
                            String text = translation.getProperty(method.getName(), old.getProperty(method.getName()));
                            boolean bl = doNotTranslate = method.getAnnotation(Messages.DoNotTranslate.class) != null || method.getAnnotation(Constants.DoNotTranslate.class) != null;
                            if (text == null && (constants || doNotTranslate)) continue;
                            out.println();
                            if (value != null) {
                                out.println("# Default: " + ImportTranslations.unicodeEscape(value, false).trim());
                            }
                            if (text == null) {
                                if (value != null) {
                                    out.println("# FIXME: Translate \"" + ImportTranslations.unicodeEscape(value, false) + "\"");
                                } else {
                                    out.println("# FIXME: Translate " + method.getName());
                                }
                                out.println("# " + method.getName() + "=");
                                continue;
                            }
                            out.println(method.getName() + "=" + ImportTranslations.unicodeEscape(text, true));
                            empty = false;
                        }
                    }
                    out.flush();
                    out.close();
                    if (!empty) continue;
                    output.delete();
                }
            }
        }
        catch (Exception e) {
            throw new BuildException("Import failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            ImportTranslations task = new ImportTranslations();
            task.setBaseDir(System.getProperty("source", "/Users/muller/git/unitime"));
            task.setSource(System.getProperty("source", "/Users/muller/git/unitime") + File.separator + "JavaSource");
            task.setBundles(System.getProperty("bundle", "CourseMessages,ConstantsMessages,ExaminationMessages,SecurityMessages,GwtConstants,GwtAriaMessages,GwtMessages,StudentSectioningConstants,StudentSectioningMessages"));
            task.setLocales(System.getProperty("locale", "cs"));
            task.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

