/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.store.MemoryStore;

public final class NotifyingMemoryStore
extends MemoryStore {
    private final Ehcache cache;

    private NotifyingMemoryStore(Ehcache cache, Pool pool) {
        super(cache, pool, true, new MemoryStore.BasicBackingFactory());
        this.cache = cache;
    }

    public static NotifyingMemoryStore create(Ehcache cache, Pool pool) {
        NotifyingMemoryStore store = new NotifyingMemoryStore(cache, pool);
        cache.getCacheConfiguration().addConfigurationListener(store);
        return store;
    }

    @Override
    protected boolean evict(Element element) {
        boolean evicted = super.evict(element);
        if (evicted) {
            this.cache.getCacheEventNotificationService().notifyElementEvicted(element, false);
        }
        return evicted;
    }

    @Override
    protected void notifyDirectEviction(Element element) {
        this.cache.getCacheEventNotificationService().notifyElementEvicted(element, false);
    }

    @Override
    public void expireElements() {
        for (Object key : this.keySet()) {
            Element element = this.expireElement(key);
            if (element == null) continue;
            this.cache.getCacheEventNotificationService().notifyElementExpiry(element, false);
        }
    }
}

