/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.log4j.Logger;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.unitime.timetable.solver.jgroups.SolverContainer;

public final class MemoryCounter {
    public static final MemorySizes sSizes = new MemorySizes();
    private final Map iVisited = new IdentityHashMap();
    private final Stack iStack = new Stack();

    public synchronized long estimate(Object obj) {
        assert (this.iVisited.isEmpty());
        assert (this.iStack.isEmpty());
        long result = this._estimate(obj);
        while (!this.iStack.isEmpty()) {
            result += this._estimate(this.iStack.pop());
        }
        this.iVisited.clear();
        return result;
    }

    private boolean skipObject(Object obj) {
        if (obj instanceof String && obj == ((String)obj).intern()) {
            return true;
        }
        if (obj instanceof Marshaller || obj instanceof EmbeddedCacheManager || obj instanceof Thread || obj instanceof Log || obj instanceof Logger || obj instanceof SolverContainer) {
            return true;
        }
        return obj == null || this.iVisited.containsKey(obj);
    }

    private long _estimate(Object obj) {
        Class<?> clazz;
        if (this.skipObject(obj)) {
            return 0L;
        }
        if (obj instanceof Cache) {
            return this._estimate(((Cache)obj).getAdvancedCache().getDataContainer().entrySet().toArray());
        }
        this.iVisited.put(obj, null);
        long result = 0L;
        if (clazz.isArray()) {
            return this._estimateArray(obj);
        }
        for (clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (Modifier.isStatic(fields[i].getModifiers())) continue;
                if (fields[i].getType().isPrimitive()) {
                    result += (long)sSizes.getPrimitiveFieldSize(fields[i].getType());
                    continue;
                }
                result += (long)sSizes.getPointerSize();
                fields[i].setAccessible(true);
                try {
                    Object toBeDone = fields[i].get(obj);
                    if (toBeDone == null) continue;
                    this.iStack.add(toBeDone);
                    continue;
                }
                catch (IllegalAccessException ex) {
                    assert (false);
                    continue;
                }
            }
        }
        return this.roundUpToNearestEightBytes(result += (long)sSizes.getClassSize());
    }

    private long roundUpToNearestEightBytes(long result) {
        if (result % 8L != 0L) {
            result += 8L - result % 8L;
        }
        return result;
    }

    protected long _estimateArray(Object obj) {
        long result = 16L;
        int length = Array.getLength(obj);
        if (length != 0) {
            Class<?> arrayElementClazz = obj.getClass().getComponentType();
            if (arrayElementClazz.isPrimitive()) {
                result += (long)(length * sSizes.getPrimitiveArrayElementSize(arrayElementClazz));
            } else {
                for (int i = 0; i < length; ++i) {
                    result += (long)sSizes.getPointerSize() + this._estimate(Array.get(obj, i));
                }
            }
        }
        return result;
    }

    public static class MemorySizes {
        private final Map primitiveSizes = new IdentityHashMap(){
            private static final long serialVersionUID = 1L;
            {
                this.put(Boolean.TYPE, new Integer(1));
                this.put(Byte.TYPE, new Integer(1));
                this.put(Character.TYPE, new Integer(2));
                this.put(Short.TYPE, new Integer(2));
                this.put(Integer.TYPE, new Integer(4));
                this.put(Float.TYPE, new Integer(4));
                this.put(Double.TYPE, new Integer(8));
                this.put(Long.TYPE, new Integer(8));
            }
        };

        public int getPrimitiveFieldSize(Class clazz) {
            return (Integer)this.primitiveSizes.get(clazz);
        }

        public int getPrimitiveArrayElementSize(Class clazz) {
            return this.getPrimitiveFieldSize(clazz);
        }

        public int getPointerSize() {
            return 4;
        }

        public int getClassSize() {
            return 8;
        }
    }
}

