/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DegreeWorksImportTest {
    protected static Logger sLog = Logger.getLogger(DegreeWorksImportTest.class);

    public static int guessEnrollmentFromLastLike(org.hibernate.Session hibSession, Session session, String area, String major, String classification) {
        return ((Number)hibSession.createQuery("select count(distinct d.student) from LastLikeCourseDemand d inner join d.student.academicAreaClassifications aac inner join d.student.posMajors m where d.subjectArea.session = :sessionId and m.code=:major and aac.academicArea.academicAreaAbbreviation = :area and aac.academicClassification.code = :clasf").setLong("sessionId", session.getUniqueId().longValue()).setString("area", area).setString("major", major).setString("clasf", classification).uniqueResult()).intValue();
    }

    public static int guessEnrollmentFromReal(org.hibernate.Session hibSession, Session session, String area, String major, String classification) {
        return ((Number)hibSession.createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.student.academicAreaClassifications aac inner join e.student.posMajors m where e.student.session = :sessionId and m.code=:major and aac.academicArea.academicAreaAbbreviation = :area and aac.academicClassification.code = :clasf").setLong("sessionId", session.getUniqueId().longValue()).setString("area", area).setString("major", major).setString("clasf", classification).uniqueResult()).intValue();
    }

    public static int guessEnrollmentFromLastLike(org.hibernate.Session hibSession, CourseOffering co, String area, String major, String classification) {
        if (co.getPermId() == null) {
            return ((Number)hibSession.createQuery("select count(distinct d.student) from LastLikeCourseDemand d inner join d.student.academicAreaClassifications aac inner join d.student.posMajors m where d.subjectArea.uniqueId = :subjectId and d.courseNbr = :courseNbr and m.code=:major and aac.academicArea.academicAreaAbbreviation = :area and aac.academicClassification.code = :clasf").setLong("subjectId", co.getSubjectArea().getUniqueId().longValue()).setString("courseNbr", co.getCourseNbr()).setString("area", area).setString("major", major).setString("clasf", classification).uniqueResult()).intValue();
        }
        return ((Number)hibSession.createQuery("select count(distinct d.student) from LastLikeCourseDemand d inner join d.student.academicAreaClassifications aac inner join d.student.posMajors m where d.subjectArea.session.uniqueId = :subjectId and d.coursePermId = :permId and m.code=:major and aac.academicArea.academicAreaAbbreviation = :area and aac.academicClassification.code = :clasf").setLong("sessionId", co.getSubjectArea().getSessionId().longValue()).setString("permId", co.getPermId()).setString("area", area).setString("major", major).setString("clasf", classification).uniqueResult()).intValue();
    }

    public static int guessEnrollmentFromReal(org.hibernate.Session hibSession, CourseOffering co, String area, String major, String classification) {
        return ((Number)hibSession.createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.student.academicAreaClassifications aac inner join e.student.posMajors m where e.courseOffering.uniqueId = :courseId and m.code=:major and aac.academicArea.academicAreaAbbreviation = :area and aac.academicClassification.code = :clasf").setLong("courseId", co.getUniqueId().longValue()).setString("area", area).setString("major", major).setString("clasf", classification).uniqueResult()).intValue();
    }

    public static List<CourseOffering> getCourses(org.hibernate.Session hibSession, Session session, String subject, String courseNbr) {
        List courses = hibSession.createQuery("from CourseOffering co where co.subjectArea.session.uniqueId = :sessionId and co.subjectArea.subjectAreaAbbreviation = :subject and co.courseNbr like :courseNbr || '%' order by co.courseNbr").setLong("sessionId", session.getUniqueId().longValue()).setString("subject", subject).setString("courseNbr", courseNbr).list();
        boolean hasOffered = false;
        for (CourseOffering co : courses) {
            if (co.getInstructionalOffering().getNotOffered().booleanValue()) continue;
            hasOffered = true;
        }
        if (hasOffered) {
            Iterator i = courses.iterator();
            while (i.hasNext()) {
                CourseOffering co;
                co = (CourseOffering)i.next();
                if (!co.getInstructionalOffering().getNotOffered().booleanValue()) continue;
                i.remove();
            }
        }
        return courses;
    }

    public static void main(String[] args) {
        try {
            String line;
            ToolBox.configureLogging();
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            org.hibernate.Session hibSession = new SessionDAO().getSession();
            Session session = Session.getSessionUsingInitiativeYearTerm(ApplicationProperties.getProperty("initiative", "PWL"), ApplicationProperties.getProperty("year", "2015"), ApplicationProperties.getProperty("term", "Spring"));
            if (session == null) {
                sLog.error((Object)"Academic session not found, use properties initiative, year, and term to set academic session.");
                System.exit(0);
            } else {
                sLog.info((Object)("Session: " + session));
            }
            int bannerTerm = Integer.parseInt(new BannerTermProvider().getExternalTerm(new AcademicSessionInfo(session)));
            DecimalFormat clasfFormat = new DecimalFormat("00");
            sLog.info((Object)("Banner term: " + bannerTerm));
            HashMap<String, String> test = new HashMap<String, String>();
            HashMap<String, Integer> counts = new HashMap<String, Integer>();
            BufferedReader in = new BufferedReader(new FileReader("/Users/muller/Test/DegreeWorks/Student_counts_201510.csv"));
            while ((line = in.readLine()) != null) {
                String key;
                int code;
                String[] data = line.split(",");
                if ("SGBSTDN_MAJR_CODE_1".equals(data[0])) continue;
                String major = data[0];
                int term = Integer.parseInt(data[2]);
                if (term > bannerTerm) continue;
                int n = code = "Fall".equals(session.getAcademicTerm()) ? 1 : 2;
                while (term <= bannerTerm - 100) {
                    code += 2;
                    term += 100;
                }
                Integer count = (Integer)counts.get(key = major + ":" + clasfFormat.format(code));
                counts.put(key, count == null ? Integer.parseInt(data[4]) : Integer.parseInt(data[4]) + count);
                test.put(data[2], clasfFormat.format(code));
            }
            in.close();
            sLog.info((Object)("Mapping " + ToolBox.dict2string(test, (int)2)));
            in = new BufferedReader(new FileReader("/Users/muller/Test/DegreeWorks/template_data.txt"));
            ArrayList<Template> templates = new ArrayList<Template>();
            Template template = null;
            Pattern termPattern = Pattern.compile(session.getAcademicTerm() + " Term ([1-9]+)");
            while ((line = in.readLine()) != null) {
                Course course;
                Group g;
                Classification c;
                String[] data = line.split("!");
                String recordType = data[0].split(":")[0];
                if ("MST".equals(recordType)) {
                    template = new Template(data[0].split(":")[1]);
                    templates.add(template);
                    sLog.info((Object)("Processing template " + template.getId() + " (description: " + data[1] + ", active:" + data[2] + ")"));
                    continue;
                }
                if ("TERM".equals(recordType)) {
                    Matcher m = termPattern.matcher(data[3]);
                    if (!m.matches()) continue;
                    int code = 2 * (Integer.parseInt(m.group(1)) - 1) + ("Fall".equals(session.getAcademicTerm()) ? 1 : 2);
                    Classification c2 = new Classification(template, data[1], clasfFormat.format(code));
                    template.addClassification(c2);
                    sLog.info((Object)("  added classification " + c2.getCode()));
                    continue;
                }
                if ("TAG".equals(recordType)) {
                    String code = data[1];
                    String value = data[2];
                    if ("COLLEGE".equals(code)) {
                        sLog.info((Object)("    -- academic area " + value));
                        template.setArea(value);
                    }
                    if (!"MAJOR".equals(code)) continue;
                    sLog.info((Object)("    -- major " + value));
                    template.setMajor(value);
                    continue;
                }
                if ("GROUPMST".equals(recordType)) {
                    c = template.getClassification(data[3]);
                    if (c == null) continue;
                    Group g2 = new Group(c, data[1], "R" + c.getCode(), "REQ");
                    c.addGroup(g2);
                    sLog.info((Object)("  select all of (" + c + ")"));
                    continue;
                }
                if ("CHOICEGROUP".equals(recordType)) {
                    c = template.getClassification(data[3]);
                    if (c == null) continue;
                    Group g3 = new Group(c, data[1], "O" + c.getCode() + "-" + data[5], "OPT");
                    c.addGroup(g3);
                    sLog.info((Object)("  select one of (" + c + ")"));
                    continue;
                }
                if ("CLASSGROUP".equals(recordType)) {
                    g = template.getGroup(data[3]);
                    if (g == null) continue;
                    Group x = new Group(g.getClassification(), data[1], "X" + g.getClassification().getCode() + "-" + data[5], "REQ");
                    x.setParentId(g.getId());
                    g.getClassification().addGroup(x);
                    sLog.info((Object)("    all of (" + x.getClassification() + ")"));
                    continue;
                }
                if ("CLASS".equals(recordType)) {
                    g = template.getGroup(data[2]);
                    if (g == null) continue;
                    List<CourseOffering> courses = DegreeWorksImportTest.getCourses(hibSession, session, data[5], data[6]);
                    if (courses.isEmpty()) {
                        sLog.info((Object)("Course " + data[5] + " " + data[6] + " does not exist."));
                        continue;
                    }
                    for (CourseOffering course2 : courses) {
                        if (!course2.getInstructionalOffering().getNotOffered().booleanValue()) continue;
                        sLog.info((Object)("Course " + course2.getCourseNameWithTitle() + " is not offered."));
                    }
                    course = new Course(g, data[5], data[6]);
                    g.addCourse(course);
                    sLog.info((Object)("    " + course + " (" + g.getClassification() + ")"));
                    continue;
                }
                if ("CLASSGRP".equals(recordType)) {
                    g = template.getGroup(data[2]);
                    if (g == null) continue;
                    List<CourseOffering> courses = DegreeWorksImportTest.getCourses(hibSession, session, data[5], data[6]);
                    if (courses.isEmpty()) {
                        sLog.info((Object)("Course " + data[5] + " " + data[6] + " does not exist."));
                        continue;
                    }
                    course = new Course(g, data[5], data[6]);
                    g.addCourse(course);
                    sLog.info((Object)("        " + course + " (" + g.getClassification() + ")"));
                    continue;
                }
                if ("PLACEHOLDER".equals(recordType)) {
                    g = template.getGroup(data[2]);
                    if (g == null) continue;
                    sLog.info((Object)("    placeholder " + data[3] + " (" + data[4] + ", " + g.getClassification() + ")"));
                    continue;
                }
                if ("NONCOURSE".equals(recordType) || "GPA".equals(recordType) || "TEST".equals(recordType)) continue;
                sLog.error((Object)("  not recognized " + recordType));
            }
            in.close();
            Document document = DocumentHelper.createDocument();
            Element root = document.addElement("curricula");
            root.addAttribute("campus", session.getAcademicInitiative());
            root.addAttribute("term", session.getAcademicTerm());
            root.addAttribute("year", session.getAcademicYear());
            root.addAttribute("created", new Date().toString());
            DecimalFormat shareFormat = new DecimalFormat("0.000");
            for (Template t : templates) {
                Element curriculum = root.addElement("curriculum");
                curriculum.addElement("academicArea").addAttribute("abbreviation", t.getArea());
                curriculum.addElement("major").addAttribute("code", t.getMajor());
                curriculum.addAttribute("abbreviation", t.getArea() + "/" + t.getMajor());
                for (Classification c : t.getClassifications()) {
                    Element clasf = curriculum.addElement("classification");
                    clasf.addElement("academicClassification").addAttribute("code", c.getCode());
                    Integer enrollment = (Integer)counts.get(t.getMajor() + ":" + c.getCode());
                    if (enrollment == null) {
                        enrollment = 0;
                    }
                    clasf.addAttribute("enrollment", String.valueOf(enrollment));
                    for (Group g : c.getGroups()) {
                        int mIdx = 0;
                        if (g.hasParentId()) continue;
                        int total = 0;
                        HashMap<Long, Integer> enrollments = new HashMap<Long, Integer>();
                        HashMap<String, Integer> grtot = new HashMap<String, Integer>();
                        if ("OPT".equals(g.getType())) {
                            block9: for (Course r : g.getCourses()) {
                                List<CourseOffering> courses = DegreeWorksImportTest.getCourses(hibSession, session, r.getSubject(), r.getCourseNbr());
                                for (CourseOffering co : courses) {
                                    int e = DegreeWorksImportTest.guessEnrollmentFromReal(hibSession, co, t.getArea(), t.getMajor(), c.getCode());
                                    total += e;
                                    enrollments.put(co.getUniqueId(), e);
                                    if (!co.getCourseNbr().equals(r.getCourseNbr())) continue;
                                    continue block9;
                                }
                            }
                            for (Group h : c.getChildGroups(g)) {
                                int m = 0;
                                for (Course r : h.getCourses()) {
                                    int tot = 0;
                                    List<CourseOffering> courses = DegreeWorksImportTest.getCourses(hibSession, session, r.getSubject(), r.getCourseNbr());
                                    for (CourseOffering co : courses) {
                                        int e = DegreeWorksImportTest.guessEnrollmentFromReal(hibSession, co, t.getArea(), t.getMajor(), c.getCode());
                                        tot += e;
                                        enrollments.put(co.getUniqueId(), e);
                                        if (!co.getCourseNbr().equals(r.getCourseNbr())) continue;
                                        break;
                                    }
                                    if (m >= tot) continue;
                                    m = tot;
                                }
                                grtot.put(h.getId(), m);
                                total += m;
                            }
                        }
                        int size = g.getCourses().size();
                        for (Group h : c.getChildGroups(g)) {
                            if (h.getCourses().isEmpty()) continue;
                            ++size;
                        }
                        for (Course r : g.getCourses()) {
                            List<CourseOffering> courses = DegreeWorksImportTest.getCourses(hibSession, session, r.getSubject(), r.getCourseNbr());
                            if (courses.isEmpty()) {
                                sLog.info((Object)("Course " + r + " does not exist."));
                                Element ce = clasf.addElement("course").addAttribute("subject", r.getSubject()).addAttribute("courseNbr", r.getCourseNbr());
                                ce.addElement("group").addAttribute("id", g.getId().trim()).addAttribute("name", g.getName()).addAttribute("type", g.getType());
                                if ("REQ".equals(g.getType())) {
                                    ce.addAttribute("share", "1.0");
                                    continue;
                                }
                                if (total > 0) {
                                    ce.addAttribute("share", "0.0");
                                    continue;
                                }
                                ce.addAttribute("share", shareFormat.format(1.0 / (double)size));
                                continue;
                            }
                            if (courses.size() == 1 || courses.get(0).getCourseNbr().equals(r.getCourseNbr())) {
                                CourseOffering co = courses.get(0);
                                Element ce = clasf.addElement("course").addAttribute("subject", co.getSubjectAreaAbbv()).addAttribute("courseNbr", co.getCourseNbr());
                                ce.addElement("group").addAttribute("id", g.getId().trim()).addAttribute("name", g.getName()).addAttribute("type", g.getType());
                                if ("REQ".equals(g.getType())) {
                                    ce.addAttribute("share", "1.0");
                                    continue;
                                }
                                if (total > 0) {
                                    Integer e = (Integer)enrollments.get(co.getUniqueId());
                                    if (e == null) {
                                        ce.addAttribute("share", "0.0");
                                        continue;
                                    }
                                    ce.addAttribute("share", shareFormat.format((double)e.intValue() / (double)total));
                                    ce.addAttribute("enrollment", e.toString());
                                    continue;
                                }
                                ce.addAttribute("share", shareFormat.format(1.0 / (double)size));
                                continue;
                            }
                            sLog.info((Object)("Course " + r + " has multiple matches."));
                            ++mIdx;
                            if ("REQ".equals(g.getType())) {
                                total = 0;
                                for (CourseOffering co : courses) {
                                    int e = DegreeWorksImportTest.guessEnrollmentFromReal(hibSession, co, t.getArea(), t.getMajor(), c.getCode());
                                    total += e;
                                    enrollments.put(co.getUniqueId(), e);
                                }
                            }
                            for (int i = 0; i < courses.size(); ++i) {
                                CourseOffering co;
                                co = courses.get(i);
                                sLog.info((Object)("  -- " + co.getCourseNameWithTitle()));
                                Element ce = clasf.addElement("course").addAttribute("subject", co.getSubjectAreaAbbv()).addAttribute("courseNbr", co.getCourseNbr());
                                if (i == 0) {
                                    ce.addElement("group").addAttribute("id", g.getId().trim()).addAttribute("name", g.getName()).addAttribute("type", g.getType());
                                }
                                ce.addElement("group").addAttribute("id", g.getId().trim() + "-" + mIdx).addAttribute("name", g.getName() + "_" + mIdx).addAttribute("type", "OPT");
                                if (total > 0) {
                                    Integer e = (Integer)enrollments.get(co.getUniqueId());
                                    if (e == null) {
                                        ce.addAttribute("share", "0.0");
                                        continue;
                                    }
                                    ce.addAttribute("share", shareFormat.format((double)e.intValue() / (double)total));
                                    ce.addAttribute("enrollment", e.toString());
                                    continue;
                                }
                                if ("REQ".equals(g.getType())) {
                                    ce.addAttribute("share", shareFormat.format(1.0 / (double)courses.size()));
                                    continue;
                                }
                                ce.addAttribute("share", shareFormat.format(1.0 / (double)size / (double)courses.size()));
                            }
                        }
                        for (Group h : c.getChildGroups(g)) {
                            int tot = (Integer)grtot.get(h.getId());
                            for (int j = 0; j < h.getCourses().size(); ++j) {
                                Course r = h.getCourses().get(j);
                                List<CourseOffering> courses = DegreeWorksImportTest.getCourses(hibSession, session, r.getSubject(), r.getCourseNbr());
                                if (courses.isEmpty()) {
                                    sLog.info((Object)("Course " + r + " does not exist."));
                                    Element ce = clasf.addElement("course").addAttribute("subject", r.getSubject()).addAttribute("courseNbr", r.getCourseNbr());
                                    if (j == 0) {
                                        ce.addElement("group").addAttribute("id", g.getId().trim()).addAttribute("name", g.getName()).addAttribute("type", g.getType());
                                    }
                                    ce.addElement("group").addAttribute("id", h.getId().trim()).addAttribute("name", h.getName()).addAttribute("type", h.getType());
                                    if (total > 0) {
                                        ce.addAttribute("share", shareFormat.format((double)tot / (double)total));
                                        continue;
                                    }
                                    ce.addAttribute("share", shareFormat.format(1.0 / (double)size));
                                    continue;
                                }
                                if (courses.size() == 1 || courses.get(0).getCourseNbr().equals(r.getCourseNbr())) {
                                    CourseOffering co = courses.get(0);
                                    Element ce = clasf.addElement("course").addAttribute("subject", co.getSubjectAreaAbbv()).addAttribute("courseNbr", co.getCourseNbr());
                                    if (j == 0) {
                                        ce.addElement("group").addAttribute("id", g.getId().trim()).addAttribute("name", g.getName()).addAttribute("type", g.getType());
                                    }
                                    ce.addElement("group").addAttribute("id", h.getId().trim()).addAttribute("name", h.getName()).addAttribute("type", h.getType());
                                    if (total > 0) {
                                        ce.addAttribute("share", shareFormat.format((double)tot / (double)total));
                                        continue;
                                    }
                                    ce.addAttribute("share", shareFormat.format(1.0 / (double)size));
                                    continue;
                                }
                                sLog.info((Object)("Course " + r + " has multiple matches."));
                                ++mIdx;
                                for (int i = 0; i < courses.size(); ++i) {
                                    CourseOffering co;
                                    co = courses.get(i);
                                    sLog.info((Object)("  -- " + co.getCourseNameWithTitle()));
                                    Element ce = clasf.addElement("course").addAttribute("subject", co.getSubjectAreaAbbv()).addAttribute("courseNbr", co.getCourseNbr());
                                    if (j == 0 && i == 0) {
                                        ce.addElement("group").addAttribute("id", g.getId().trim()).addAttribute("name", g.getName()).addAttribute("type", g.getType());
                                    }
                                    if (i == 0) {
                                        ce.addElement("group").addAttribute("id", h.getId().trim()).addAttribute("name", h.getName()).addAttribute("type", h.getType());
                                    }
                                    ce.addElement("group").addAttribute("id", h.getId().trim() + "-" + mIdx).addAttribute("name", h.getName() + "_" + mIdx).addAttribute("type", "OPT");
                                    if (total > 0) {
                                        Integer e = (Integer)enrollments.get(co.getUniqueId());
                                        if (e == null) {
                                            ce.addAttribute("share", "0.0");
                                            continue;
                                        }
                                        ce.addAttribute("share", shareFormat.format((double)e.intValue() / (double)total));
                                        ce.addAttribute("enrollment", e.toString());
                                        continue;
                                    }
                                    ce.addAttribute("share", shareFormat.format(1.0 / (double)size / (double)courses.size()));
                                }
                            }
                        }
                    }
                }
            }
            FileWriter out = new FileWriter("/Users/muller/Test/DegreeWorks/curricula_" + bannerTerm + ".xml");
            new XMLWriter((Writer)out, OutputFormat.createPrettyPrint()).write(document);
            out.flush();
            out.close();
            HibernateUtil.closeHibernate();
            sLog.info((Object)"All done.");
        }
        catch (Exception e) {
            sLog.error((Object)("Test failed: " + e.getMessage()), (Throwable)e);
        }
    }

    static class Course {
        Group iGroup;
        String iSubject;
        String iCourseNbr;
        float iShare = 1.0f;

        Course(Group group, String subject, String courseNbr) {
            this.iGroup = group;
            this.iSubject = subject;
            this.iCourseNbr = courseNbr;
        }

        Group getGroup() {
            return this.iGroup;
        }

        String getSubject() {
            return this.iSubject;
        }

        String getCourseNbr() {
            return this.iCourseNbr;
        }

        void setShare(float share) {
            this.iShare = share;
        }

        float getShare() {
            return this.iShare;
        }

        public String toString() {
            return this.getSubject() + " " + this.getCourseNbr();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Group {
        Classification iClassification;
        String iId;
        String iName;
        String iType;
        String iParentId = null;
        List<Course> iCourses = new ArrayList<Course>();

        Group(Classification classification, String id, String name, String type) {
            this.iClassification = classification;
            this.iId = id;
            this.iName = name;
            this.iType = type;
        }

        Classification getClassification() {
            return this.iClassification;
        }

        String getId() {
            return this.iId;
        }

        String getName() {
            return this.iName;
        }

        String getType() {
            return this.iType;
        }

        boolean hasParentId() {
            return this.iParentId != null;
        }

        String getParentId() {
            return this.iParentId;
        }

        void setParentId(String parentId) {
            this.iParentId = parentId;
        }

        void addCourse(Course course) {
            this.iCourses.add(course);
        }

        List<Course> getCourses() {
            return this.iCourses;
        }

        public String toString() {
            return this.iName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Classification {
        Template iTemplate;
        String iId;
        String iCode;
        List<Group> iGroups = new ArrayList<Group>();
        int iEnrollment = 0;

        Classification(Template template, String id, String code) {
            this.iTemplate = template;
            this.iId = id;
            this.iCode = code;
        }

        Template getTemplate() {
            return this.iTemplate;
        }

        String getId() {
            return this.iId;
        }

        String getCode() {
            return this.iCode;
        }

        void addGroup(Group c) {
            this.iGroups.add(c);
        }

        Group getGroup(String id) {
            for (Group c : this.iGroups) {
                if (!c.getId().equals(id)) continue;
                return c;
            }
            return null;
        }

        List<Group> getGroups() {
            return this.iGroups;
        }

        List<Group> getChildGroups(Group group) {
            ArrayList<Group> ret = new ArrayList<Group>();
            for (Group g : this.iGroups) {
                if (!group.getId().equals(g.getParentId())) continue;
                ret.add(g);
            }
            return ret;
        }

        int getEnrollment() {
            return this.iEnrollment;
        }

        void setEnrollment(int enrollment) {
            this.iEnrollment = enrollment;
        }

        public String toString() {
            return this.iCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Template {
        String iId;
        String iArea;
        String iMajor;
        List<Classification> iClassifications = new ArrayList<Classification>();

        Template(String id) {
            this.iId = id;
        }

        String getId() {
            return this.iId;
        }

        String getArea() {
            return this.iArea;
        }

        void setArea(String area) {
            this.iArea = area;
        }

        String getMajor() {
            return this.iMajor;
        }

        void setMajor(String major) {
            this.iMajor = major;
        }

        void addClassification(Classification c) {
            this.iClassifications.add(c);
        }

        Classification getClassification(String id) {
            for (Classification c : this.iClassifications) {
                if (!c.getId().equals(id)) continue;
                return c;
            }
            return null;
        }

        List<Classification> getClassifications() {
            return this.iClassifications;
        }

        Group getGroup(String id) {
            for (Classification c : this.iClassifications) {
                for (Group g : c.getGroups()) {
                    if (!g.getId().equals(id)) continue;
                    return g;
                }
            }
            return null;
        }

        public String toString() {
            return this.iArea + "/" + this.iMajor;
        }
    }
}

