/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.tags;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.hibernate.criterion.Order;
import org.unitime.commons.Debug;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.dao.PreferenceLevelDAO;

public class PreferenceLegend
extends TagSupport {
    private static final long serialVersionUID = -8994474921509928721L;
    private boolean iNotAvailable = false;
    private boolean iPrefs = true;
    private boolean iDpBackgrounds = false;
    private boolean iDpAssign = false;
    private boolean iDpOffered = false;
    private String iSeparator = "top";

    public String getSeparator() {
        return this.iSeparator;
    }

    public void setSeparator(String separator) {
        this.iSeparator = separator;
    }

    public void setNotAvailable(boolean notAvailable) {
        this.iNotAvailable = notAvailable;
    }

    public boolean isNotAvailable() {
        return this.iNotAvailable;
    }

    public void setDpBackgrounds(boolean dpBackgrounds) {
        this.iDpBackgrounds = dpBackgrounds;
    }

    public boolean isDpBackgrounds() {
        return this.iDpBackgrounds;
    }

    public void setPrefs(boolean prefs) {
        this.iPrefs = prefs;
    }

    public boolean isPrefs() {
        return this.iPrefs;
    }

    public void setDpOffered(boolean dpOffered) {
        this.iDpOffered = dpOffered;
    }

    public boolean isDpOffered() {
        return this.iDpOffered;
    }

    public void setDpAssign(boolean dpAssign) {
        this.iDpAssign = dpAssign;
    }

    public boolean isDpAssign() {
        return this.iDpAssign;
    }

    public int doEndTag() throws JspException {
        return 6;
    }

    public int doStartTag() throws JspException {
        String border = "";
        if (this.iSeparator != null && this.iSeparator.length() > 0) {
            border = "border-" + this.iSeparator + ":1px dashed #9CB0CE";
        }
        if ("none".equals(this.iSeparator)) {
            border = null;
        }
        StringBuffer html = new StringBuffer(border == null ? "" : "<table width='100%' cellspacing='1' cellpadding='1' border='0' style='" + border + "'><tr><td align='center'>");
        html.append("<table cellspacing='1' cellpadding='1' border='0'><tr>");
        List prefLevels = (List)this.pageContext.getRequest().getAttribute(PreferenceLevel.PREF_LEVEL_ATTR_NAME);
        if (prefLevels == null) {
            PreferenceLevelDAO pdao = new PreferenceLevelDAO();
            prefLevels = pdao.findAll(Order.asc((String)"prefId"));
        }
        String imgFolder = ((HttpServletRequest)this.pageContext.getRequest()).getContextPath() + "/images/";
        if (this.isPrefs()) {
            for (PreferenceLevel pl : prefLevels) {
                html.append("<td style='font-size: 80%;'><img border='0' align='absmiddle' src='" + imgFolder + "pref" + pl.getUniqueId() + ".png'>" + "&nbsp;" + pl.getPrefName() + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + "</td>");
            }
        }
        if (this.isNotAvailable()) {
            html.append("<td style='font-size: 80%;'><img border='0' align='absmiddle'src='" + imgFolder + "prefna.png'>" + "&nbsp;Not Available&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + "</td>");
        }
        if (this.isDpOffered()) {
            html.append("<td style='font-size: 80%;'><img border='0' align='absmiddle' src='" + imgFolder + "dp-offered.png'>" + "&nbsp;Classes Offered&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + "</td>");
            html.append("<td style='font-size: 80%;'><img border='0' align='absmiddle' src='" + imgFolder + "dp-notoffered.png'>" + "&nbsp;Classes Not Offered&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + "</td>");
        }
        if (this.isDpBackgrounds()) {
            html.append("<td style='font-size: 80%;'><img border='0' align='absmiddle' src='" + imgFolder + "dp-start.png'>" + "&nbsp;Start / End&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + "</td>");
            html.append("<td style='font-size: 80%;'><img border='0' align='absmiddle' src='" + imgFolder + "dp-exam.png'>" + "&nbsp;Examination Start&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + "</td>");
            html.append("<td style='font-size: 80%;'><img border='0' align='absmiddle' src='" + imgFolder + "dp-holiday.png'>" + "&nbsp;Holiday&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + "</td>");
            html.append("<td style='font-size: 80%;'><img border='0' align='absmiddle' src='" + imgFolder + "dp-break.png'>" + "&nbsp;Break&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + "</td>");
        }
        if (this.isDpAssign()) {
            html.append("<td style='font-size: 80%;'><img border='0' align='absmiddle' src='" + imgFolder + "dp-assign.png'>" + "&nbsp;Assignment&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + "</td>");
        }
        html.append("</tr></table>");
        html.append(border == null ? "" : "</td></tr></table>");
        try {
            this.pageContext.getOut().print(html.toString());
        }
        catch (Exception e) {
            Debug.error("Could not display preference legend: " + e.getMessage());
        }
        return 0;
    }
}

