/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.remote;

import java.io.File;
import java.io.FileFilter;

public class BackupFileFilter
implements FileFilter {
    public static String sXmlExtension = ".backup.xml";
    public static String sPropertiesExtension = ".backup.properties";
    private boolean iAcceptXml = false;
    private boolean iAcceptProperties = false;
    private int iType = 0;

    public BackupFileFilter(boolean acceptXml, boolean acceptProperties, int type) {
        this.iAcceptXml = acceptXml;
        this.iAcceptProperties = acceptProperties;
        this.iType = type;
    }

    public BackupFileFilter(boolean acceptXml, boolean acceptProperties) {
        this(acceptXml, acceptProperties, -1);
    }

    public boolean accept(File file) {
        switch (this.iType) {
            case 0: {
                if (!file.getName().startsWith("exam_") && !file.getName().startsWith("sct_")) break;
                return false;
            }
            case 1: {
                if (file.getName().startsWith("exam_")) break;
                return false;
            }
            case 2: {
                if (file.getName().startsWith("sct_")) break;
                return false;
            }
        }
        return this.iAcceptXml && file.getName().endsWith(sXmlExtension) || this.iAcceptProperties && file.getName().endsWith(sPropertiesExtension);
    }

    public String getUser(File file) {
        if (this.accept(file)) {
            String name = file.getName();
            if (this.iType == 1) {
                name = name.substring("exam_".length());
            } else if (this.iType == 2) {
                name = name.substring("sct_".length());
            }
            if (this.iAcceptXml && name.endsWith(sXmlExtension)) {
                name = name.substring(0, name.length() - sXmlExtension.length());
            } else if (this.iAcceptProperties && name.endsWith(sPropertiesExtension)) {
                name = name.substring(0, name.length() - sPropertiesExtension.length());
            }
            return name;
        }
        return null;
    }
}

