/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.jgroups.Address;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.unitime.timetable.solver.jgroups.RemoteSolverContainer;
import org.unitime.timetable.solver.jgroups.ReplicatedSolverContainer;
import org.unitime.timetable.solver.jgroups.SolverContainer;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolverContainerWrapper<T>
implements SolverContainer<T> {
    private static Log sLog = LogFactory.getLog(SolverContainerWrapper.class);
    private RpcDispatcher iDispatcher;
    private RemoteSolverContainer<T> iContainer;
    private boolean iCheckLocal = true;

    public SolverContainerWrapper(RpcDispatcher dispatcher, RemoteSolverContainer<T> container, boolean checkLocal) {
        this.iDispatcher = dispatcher;
        this.iContainer = container;
        this.iCheckLocal = checkLocal;
    }

    @Override
    public Set<String> getSolvers() {
        HashSet<String> solvers = new HashSet<String>(this.iContainer.getSolvers());
        try {
            RspList ret = this.iContainer.getDispatcher().callRemoteMethods(null, "getSolvers", new Object[0], new Class[0], SolverServerImplementation.sAllResponses);
            for (Rsp rsp : ret) {
                if (rsp == null || rsp.getValue() == null) continue;
                solvers.addAll((Collection)rsp.getValue());
            }
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to retrieve solvers: " + e.getMessage()), (Throwable)e);
        }
        return solvers;
    }

    @Override
    public T getSolver(String user) {
        try {
            Object solver;
            if (this.iCheckLocal && (solver = this.iContainer.getSolver(user)) != null) {
                return solver;
            }
            RspList ret = this.iContainer.getDispatcher().callRemoteMethods(null, "hasSolver", new Object[]{user}, new Class[]{String.class}, SolverServerImplementation.sAllResponses);
            ArrayList<Address> senders = new ArrayList<Address>();
            for (Rsp rsp : ret) {
                if (rsp == null || rsp.getValue() == null || !((Boolean)rsp.getValue()).booleanValue()) continue;
                senders.add(rsp.getSender());
            }
            if (senders.isEmpty()) {
                return null;
            }
            if (senders.size() == 1) {
                return this.iContainer.createProxy((Address)senders.get(0), user);
            }
            if (this.iContainer instanceof ReplicatedSolverContainer) {
                return ((ReplicatedSolverContainer)this.iContainer).createProxy(senders, user);
            }
            return this.iContainer.createProxy((Address)ToolBox.random(senders), user);
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to retrieve solver " + user + ": " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @Override
    public long getMemUsage(String user) {
        try {
            if (this.iCheckLocal && this.iContainer.hasSolver(user)) {
                return this.iContainer.getMemUsage(user);
            }
            RspList ret = this.iContainer.getDispatcher().callRemoteMethods(null, "getMemUsage", new Object[]{user}, new Class[]{String.class}, SolverServerImplementation.sAllResponses);
            long total = 0L;
            long count = 0L;
            for (Rsp rsp : ret) {
                if (rsp == null || rsp.getValue() == null || (Long)rsp.getValue() <= 0L) continue;
                total += ((Long)rsp.getValue()).longValue();
                ++count;
            }
            return count == 0L ? 0L : total / count;
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to retrieve allocated memory " + user + ": " + e.getMessage()), (Throwable)e);
            return 0L;
        }
    }

    @Override
    public boolean hasSolver(String user) {
        try {
            if (this.iContainer.hasSolver(user)) {
                return true;
            }
            RspList ret = this.iContainer.getDispatcher().callRemoteMethods(null, "hasSolver", new Object[]{user}, new Class[]{String.class}, SolverServerImplementation.sAllResponses);
            for (Rsp rsp : ret) {
                if (!((Boolean)rsp.getValue()).booleanValue()) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to check solver " + user + ": " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Override
    public T createSolver(String user, DataProperties config) {
        try {
            Object bestAddress = null;
            int bestUsage = 0;
            RspList ret = this.iDispatcher.callRemoteMethods(null, "isAvailable", new Object[0], new Class[0], SolverServerImplementation.sAllResponses);
            for (Rsp rsp : ret) {
                if (!Boolean.TRUE.equals(rsp.getValue())) continue;
                Integer usage = (Integer)this.iDispatcher.callRemoteMethod(rsp.getSender(), "getUsage", new Object[0], new Class[0], SolverServerImplementation.sFirstResponse);
                if (bestAddress != null && bestUsage <= usage) continue;
                bestAddress = rsp.getSender();
                bestUsage = usage;
            }
            if (bestAddress == null) {
                throw new RuntimeException("Not enough resources to create a solver instance, please try again later.");
            }
            if (bestAddress.equals(this.iDispatcher.getChannel().getAddress())) {
                return this.iContainer.createSolver(user, config);
            }
            this.iContainer.getDispatcher().callRemoteMethod((Address)bestAddress, "createRemoteSolver", new Object[]{user, config, this.iDispatcher.getChannel().getAddress()}, new Class[]{String.class, DataProperties.class, Address.class}, SolverServerImplementation.sFirstResponse);
            return this.iContainer.createProxy((Address)bestAddress, user);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start the solver: " + e.getMessage(), e);
        }
    }

    @Override
    public void unloadSolver(String user) {
        try {
            if (this.iContainer.hasSolver(user)) {
                this.iContainer.unloadSolver(user);
            }
            RspList ret = this.iContainer.getDispatcher().callRemoteMethods(null, "hasSolver", new Object[]{user}, new Class[]{String.class}, SolverServerImplementation.sAllResponses);
            for (Rsp rsp : ret) {
                if (!((Boolean)rsp.getValue()).booleanValue()) continue;
                this.iContainer.getDispatcher().callRemoteMethod(rsp.getSender(), "unloadSolver", new Object[]{user}, new Class[]{String.class}, SolverServerImplementation.sFirstResponse);
            }
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to unload solver " + user + ": " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public int getUsage() {
        int usage = 0;
        try {
            RspList ret = this.iContainer.getDispatcher().callRemoteMethods(null, "getUsage", new Object[0], new Class[0], SolverServerImplementation.sAllResponses);
            for (Rsp rsp : ret) {
                usage += ((Integer)rsp.getValue()).intValue();
            }
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to check solver server usage: " + e.getMessage()), (Throwable)e);
        }
        return usage;
    }

    @Override
    public void start() {
        throw new RuntimeException("Method start is not supported on the solver container wrapper.");
    }

    @Override
    public void stop() {
        throw new RuntimeException("Method stop is not supported on the solver container wrapper.");
    }
}

