/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.coursett.TimetableLoader;
import org.cpsolver.coursett.constraint.ClassLimitConstraint;
import org.cpsolver.coursett.constraint.DepartmentSpreadConstraint;
import org.cpsolver.coursett.constraint.DiscouragedRoomConstraint;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.IgnoreStudentConflictsConstraint;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.constraint.MinimizeNumberOfUsedGroupsOfTime;
import org.cpsolver.coursett.constraint.MinimizeNumberOfUsedRoomsConstraint;
import org.cpsolver.coursett.constraint.RoomConstraint;
import org.cpsolver.coursett.constraint.SpreadConstraint;
import org.cpsolver.coursett.model.Configuration;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.RoomSharingModel;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.coursett.preference.MinMaxPreferenceCombination;
import org.cpsolver.coursett.preference.PreferenceCombination;
import org.cpsolver.coursett.preference.SumPreferenceCombination;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.BinaryConstraint;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.ifs.util.Progress;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LazyInitializationException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseReservation;
import org.unitime.timetable.model.CurriculumReservation;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.ExactTimeMins;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.TravelTime;
import org.unitime.timetable.model.base.BaseBuildingPref;
import org.unitime.timetable.model.base.BaseClass_;
import org.unitime.timetable.model.base.BaseCurriculumReservation;
import org.unitime.timetable.model.base.BaseDatePatternPref;
import org.unitime.timetable.model.base.BaseDistributionType;
import org.unitime.timetable.model.base.BasePreferenceGroup;
import org.unitime.timetable.model.base.BasePreferenceLevel;
import org.unitime.timetable.model.base.BaseRefTableEntry;
import org.unitime.timetable.model.base.BaseRoomGroupPref;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.dao.AssignmentDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.solver.EnrollmentCheck;
import org.unitime.timetable.solver.course.weights.ClassWeightProvider;
import org.unitime.timetable.solver.course.weights.DefaultClassWeights;
import org.unitime.timetable.solver.curricula.LastLikeStudentCourseDemands;
import org.unitime.timetable.solver.curricula.StudentCourseDemands;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.util.duration.DurationModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimetableDatabaseLoader
extends TimetableLoader {
    private static Log sLog = LogFactory.getLog(TimetableDatabaseLoader.class);
    private Session iSession;
    private Long iSessionId;
    private Long[] iSolverGroupId;
    private String iSolverGroupIds;
    private String iDepartmentIds = null;
    private SolverGroup[] iSolverGroup;
    private Long[] iSolutionId;
    private long iFakeLectureId = 0L;
    private Hashtable<Long, RoomConstraint> iRooms = new Hashtable();
    private Hashtable<Object, InstructorConstraint> iInstructors = new Hashtable();
    private Hashtable<Long, Lecture> iLectures = new Hashtable();
    private Hashtable<Long, SchedulingSubpart> iSubparts = new Hashtable();
    private Hashtable<Long, Student> iStudents = new Hashtable();
    private Hashtable<Long, String> iDeptNames = new Hashtable();
    private Hashtable<Long, Class_> iClasses = new Hashtable();
    private Set<DatePattern> iAllUsedDatePatterns = new HashSet<DatePattern>();
    private Set<Class_> iAllClasses = null;
    private Hashtable<InstructionalOffering, List<Configuration>> iAltConfigurations = new Hashtable();
    private Hashtable<InstructionalOffering, Hashtable<InstrOfferingConfig, Set<SchedulingSubpart>>> iOfferings = new Hashtable();
    private Hashtable<CourseOffering, Set<Student>> iCourse2students = new Hashtable();
    private boolean iDeptBalancing = true;
    private boolean iSubjectBalancing = false;
    private boolean iMppAssignment = true;
    private boolean iInteractiveMode = false;
    private boolean iSpread = true;
    private boolean iAutoSameStudents = true;
    private String iAutoPrecedence = null;
    private boolean iLoadCommittedAssignments = false;
    private double iFewerSeatsDisouraged = 0.01;
    private double iFewerSeatsStronglyDisouraged = 0.02;
    private double iNormalizedPrefDecreaseFactor = TimePatternModel.sDefaultDecreaseFactor;
    private double iAlterTimePatternWeight = 0.0;
    private double iAlterDatePatternWeight = 1.0;
    private TimePatternModel iAlterTimePatternModel = (TimePatternModel)TimePattern.getDefaultRequiredTimeTable().getModel();
    private boolean iWeakenTimePreferences = false;
    private Progress iProgress = null;
    private boolean iLoadStudentEnrlsFromSolution = false;
    private boolean iFixMinPerWeek = false;
    private boolean iAssignSingleton = true;
    private boolean iIgnoreRoomSharing = false;
    private boolean iLoadStudentInstructorConflicts = false;
    private int iMaxRoomCombinations = 100;
    private String iAutoSameStudentsConstraint = "SAME_STUDENTS";
    private String iInstructorFormat = null;
    private boolean iRoomAvailabilityTimeStampIsSet = false;
    private CommittedStudentConflictsMode iCommittedStudentConflictsMode = CommittedStudentConflictsMode.Load;
    private StudentCourseDemands iStudentCourseDemands = null;
    private ClassWeightProvider iClassWeightProvider = null;
    private boolean iUseAmPm = true;
    private Hashtable iRoomPreferences = null;

    public TimetableDatabaseLoader(TimetableModel model, Assignment<Lecture, Placement> assignment) {
        super(model, assignment);
        Progress.sTraceEnabled = false;
        this.iProgress = Progress.getInstance((Object)model);
        this.iSessionId = model.getProperties().getPropertyLong("General.SessionId", (Long)null);
        this.iSolverGroupId = model.getProperties().getPropertyLongArry("General.SolverGroupId", null);
        this.iSolutionId = model.getProperties().getPropertyLongArry("General.SolutionId", null);
        this.iIgnoreRoomSharing = model.getProperties().getPropertyBoolean("General.IgnoreRoomSharing", this.iIgnoreRoomSharing);
        this.iSolverGroupIds = "";
        if (this.iSolverGroupId != null) {
            for (int i = 0; i < this.iSolverGroupId.length; ++i) {
                if (i > 0) {
                    this.iSolverGroupIds = this.iSolverGroupIds + ",";
                }
                this.iSolverGroupIds = this.iSolverGroupIds + this.iSolverGroupId[i].toString();
            }
        }
        this.iDeptBalancing = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.DeptBalancing", this.iDeptBalancing);
        this.iSubjectBalancing = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.SubjectBalancing", this.iSubjectBalancing);
        this.iSpread = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.Spread", this.iSpread);
        this.iAutoSameStudents = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.AutoSameStudents", this.iAutoSameStudents);
        this.iAutoPrecedence = ((TimetableModel)this.getModel()).getProperties().getProperty("General.AutoPrecedence");
        this.iMppAssignment = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.MPP", this.iMppAssignment);
        this.iInteractiveMode = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.InteractiveMode", this.iInteractiveMode);
        this.iAssignSingleton = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.AssignSingleton", this.iAssignSingleton);
        this.iMaxRoomCombinations = ((TimetableModel)this.getModel()).getProperties().getPropertyInt("General.MaxRoomCombinations", this.iMaxRoomCombinations);
        this.iFewerSeatsDisouraged = ((TimetableModel)this.getModel()).getProperties().getPropertyDouble("Global.FewerSeatsDisouraged", this.iFewerSeatsDisouraged);
        this.iFewerSeatsStronglyDisouraged = ((TimetableModel)this.getModel()).getProperties().getPropertyDouble("Global.FewerSeatsStronglyDisouraged", this.iFewerSeatsStronglyDisouraged);
        this.iNormalizedPrefDecreaseFactor = ((TimetableModel)this.getModel()).getProperties().getPropertyDouble("General.NormalizedPrefDecreaseFactor", this.iNormalizedPrefDecreaseFactor);
        this.iLoadStudentEnrlsFromSolution = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("Global.LoadStudentEnrlsFromSolution", this.iLoadStudentEnrlsFromSolution);
        this.iLoadStudentInstructorConflicts = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("Global.LoadStudentInstructorConflicts", this.iLoadStudentInstructorConflicts);
        this.iFixMinPerWeek = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("Global.FixMinPerWeek", this.iFixMinPerWeek);
        this.iAlterTimePatternWeight = ((TimetableModel)this.getModel()).getProperties().getPropertyDouble("TimePreferences.Weight", this.iAlterTimePatternWeight);
        this.iAlterDatePatternWeight = ((TimetableModel)this.getModel()).getProperties().getPropertyDouble("General.AlternativeDatePatternWeight", this.iAlterDatePatternWeight);
        this.iAlterTimePatternModel.setPreferences(((TimetableModel)this.getModel()).getProperties().getProperty("TimePreferences.Pref", null));
        this.iWeakenTimePreferences = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("TimePreferences.Weaken", this.iWeakenTimePreferences);
        this.iAutoSameStudentsConstraint = ((TimetableModel)this.getModel()).getProperties().getProperty("General.AutoSameStudentsConstraint", this.iAutoSameStudentsConstraint);
        this.iInstructorFormat = ((TimetableModel)this.getModel()).getProperties().getProperty("General.InstructorFormat", DepartmentalInstructor.sNameFormatLastFist);
        try {
            String studentCourseDemandsClassName = ((TimetableModel)this.getModel()).getProperties().getProperty("Curriculum.StudentCourseDemadsClass", LastLikeStudentCourseDemands.class.getName());
            if (studentCourseDemandsClassName.indexOf(32) >= 0) {
                studentCourseDemandsClassName = studentCourseDemandsClassName.replace(" ", "");
            }
            if (studentCourseDemandsClassName.indexOf(46) < 0) {
                studentCourseDemandsClassName = "org.unitime.timetable.solver.curricula." + studentCourseDemandsClassName;
            }
            Class<?> studentCourseDemandsClass = Class.forName(studentCourseDemandsClassName);
            this.iStudentCourseDemands = (StudentCourseDemands)studentCourseDemandsClass.getConstructor(DataProperties.class).newInstance(((TimetableModel)this.getModel()).getProperties());
        }
        catch (Exception e) {
            this.iProgress.message(this.msglevel("badStudentCourseDemands", 5), "Failed to load custom student course demands class, using last-like course demands instead.", (Throwable)e);
            this.iStudentCourseDemands = new LastLikeStudentCourseDemands(((TimetableModel)this.getModel()).getProperties());
        }
        ((TimetableModel)this.getModel()).getProperties().setProperty("General.SaveStudentEnrollments", this.iStudentCourseDemands.isMakingUpStudents() ? "false" : "true");
        ((TimetableModel)this.getModel()).getProperties().setProperty("General.WeightStudents", this.iStudentCourseDemands.isWeightStudentsToFillUpOffering() ? "true" : "false");
        this.iCommittedStudentConflictsMode = CommittedStudentConflictsMode.valueOf(((TimetableModel)this.getModel()).getProperties().getProperty("General.CommittedStudentConflicts", this.iCommittedStudentConflictsMode.name()));
        this.iLoadCommittedAssignments = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.LoadCommittedAssignments", this.iLoadCommittedAssignments);
        if (this.iCommittedStudentConflictsMode == CommittedStudentConflictsMode.Load && this.iStudentCourseDemands.isMakingUpStudents()) {
            this.iCommittedStudentConflictsMode = CommittedStudentConflictsMode.Compute;
            ((TimetableModel)this.getModel()).getProperties().setProperty("General.CommittedStudentConflicts", this.iCommittedStudentConflictsMode.name());
        }
        if (this.iLoadStudentEnrlsFromSolution && this.iStudentCourseDemands.isMakingUpStudents()) {
            this.iLoadStudentEnrlsFromSolution = false;
            ((TimetableModel)this.getModel()).getProperties().setProperty("Global.LoadStudentEnrlsFromSolution", "false");
        }
        if (this.iLoadStudentInstructorConflicts && this.iStudentCourseDemands.isMakingUpStudents()) {
            this.iLoadStudentInstructorConflicts = false;
            ((TimetableModel)this.getModel()).getProperties().setProperty("Global.LoadStudentInstructorConflicts", "false");
        }
        try {
            String classWeightProviderClassName = ((TimetableModel)this.getModel()).getProperties().getProperty("ClassWeightProvider.Class", DefaultClassWeights.class.getName());
            if (classWeightProviderClassName.indexOf(32) >= 0) {
                classWeightProviderClassName = classWeightProviderClassName.replace(" ", "");
            }
            if (classWeightProviderClassName.indexOf(46) < 0) {
                classWeightProviderClassName = "org.unitime.timetable.solver.course.weights." + classWeightProviderClassName;
            }
            Class<?> classWeightProviderClass = Class.forName(classWeightProviderClassName);
            this.iClassWeightProvider = (ClassWeightProvider)classWeightProviderClass.getConstructor(DataProperties.class).newInstance(((TimetableModel)this.getModel()).getProperties());
        }
        catch (Exception e) {
            this.iProgress.message(this.msglevel("badClassWeightProvider", 5), "Failed to load custom class weight provider, using the default one instead.", (Throwable)e);
            this.iClassWeightProvider = new DefaultClassWeights(((TimetableModel)this.getModel()).getProperties());
        }
        this.iUseAmPm = ((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.UseAmPm", this.iUseAmPm);
    }

    public int msglevel(String type, int defaultLevel) {
        String level = ApplicationProperty.SolverLogLevel.value(type);
        if (level == null) {
            return defaultLevel;
        }
        if ("warn".equalsIgnoreCase(level)) {
            return 5;
        }
        if ("error".equalsIgnoreCase(level)) {
            return 6;
        }
        if ("fatal".equalsIgnoreCase(level)) {
            return 7;
        }
        if ("info".equalsIgnoreCase(level)) {
            return 3;
        }
        if ("debug".equalsIgnoreCase(level)) {
            return 1;
        }
        if ("trace".equalsIgnoreCase(level)) {
            return 0;
        }
        return defaultLevel;
    }

    private String getClassLabel(Class_ clazz) {
        return "<A href='classDetail.do?cid=" + clazz.getUniqueId() + "'>" + clazz.getClassLabel() + "</A>";
    }

    private String getClassLabel(Lecture lecture) {
        return "<A href='classDetail.do?cid=" + lecture.getClassId() + "'>" + lecture.getName() + "</A>";
    }

    private String getOfferingLabel(InstructionalOffering offering) {
        return "<A href='instructionalOfferingDetail.do?io=" + offering.getUniqueId() + "'>" + offering.getCourseName() + "</A>";
    }

    private String getOfferingLabel(CourseOffering offering) {
        return "<A href='instructionalOfferingDetail.do?io=" + offering.getInstructionalOffering().getUniqueId() + "'>" + offering.getCourseName() + "</A>";
    }

    private String getSubpartLabel(SchedulingSubpart subpart) {
        String suffix = subpart.getSchedulingSubpartSuffix();
        return "<A href='schedulingSubpartDetail.do?ssuid=" + subpart.getUniqueId() + "'>" + subpart.getCourseName() + " " + subpart.getItypeDesc().trim() + (suffix == null || suffix.length() == 0 ? "" : " (" + suffix + ")") + "</A>";
    }

    private PreferenceLevel getRoomPreference(Long deptId, Long locationId) {
        Hashtable roomPreferencesThisDept;
        if (this.iRoomPreferences == null) {
            this.iRoomPreferences = new Hashtable();
            for (int i = 0; i < this.iSolverGroup.length; ++i) {
                for (Department department : this.iSolverGroup[i].getDepartments()) {
                    Hashtable<Long, PreferenceLevel> roomPreferencesThisDept2 = new Hashtable<Long, PreferenceLevel>();
                    this.iRoomPreferences.put(department.getUniqueId(), roomPreferencesThisDept2);
                    for (RoomPref pref : department.getPreferences(RoomPref.class)) {
                        roomPreferencesThisDept2.put(pref.getRoom().getUniqueId(), pref.getPrefLevel());
                    }
                }
            }
        }
        if ((roomPreferencesThisDept = (Hashtable)this.iRoomPreferences.get(deptId)) == null) {
            return null;
        }
        return (PreferenceLevel)roomPreferencesThisDept.get(locationId);
    }

    public static List<RoomLocation> computeRoomLocations(Class_ clazz) {
        return TimetableDatabaseLoader.computeRoomLocations(clazz, false, 0.01, 0.02);
    }

    public static List<RoomLocation> computeRoomLocations(Class_ clazz, boolean interactiveMode, double fewerSeatsDisouraged, double fewerSeatsStronglyDisouraged) {
        int minClassLimit = clazz.getExpectedCapacity();
        int maxClassLimit = clazz.getMaxExpectedCapacity();
        if (maxClassLimit < minClassLimit) {
            maxClassLimit = minClassLimit;
        }
        float room2limitRatio = clazz.getRoomRatio().floatValue();
        int roomCapacity = Math.round(minClassLimit <= 0 ? room2limitRatio : room2limitRatio * (float)minClassLimit);
        int discouragedCapacity = (int)Math.round((1.0 - fewerSeatsStronglyDisouraged) * (double)roomCapacity);
        int stronglyDiscouragedCapacity = (int)Math.round((1.0 - fewerSeatsStronglyDisouraged) * (double)roomCapacity);
        ArrayList<RoomLocation> roomLocations = new ArrayList<RoomLocation>();
        boolean reqRoom = false;
        boolean reqBldg = false;
        boolean reqGroup = false;
        Set<Location> allRooms = clazz.getAvailableRooms();
        Set groupPrefs = clazz.effectivePreferences(RoomGroupPref.class);
        Set roomPrefs = clazz.effectivePreferences(RoomPref.class);
        Set bldgPrefs = clazz.effectivePreferences(BuildingPref.class);
        Set featurePrefs = clazz.effectivePreferences(RoomFeaturePref.class);
        for (Location room : allRooms) {
            boolean add = true;
            SumPreferenceCombination pref = new SumPreferenceCombination();
            PreferenceCombination groupPref = PreferenceCombination.getDefault();
            for (RoomGroupPref p : groupPrefs) {
                if (!p.getRoomGroup().getRooms().contains(room)) continue;
                groupPref.addPreferenceProlog(p.getPrefLevel().getPrefProlog());
            }
            if (groupPref.getPreferenceProlog().equals(PreferenceLevel.sProhibited)) {
                if (interactiveMode) {
                    pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                } else {
                    add = false;
                }
            }
            if (reqGroup && !groupPref.getPreferenceProlog().equals(PreferenceLevel.sRequired)) {
                if (interactiveMode) {
                    pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                } else {
                    add = false;
                }
            }
            if (!reqGroup && groupPref.getPreferenceProlog().equals(PreferenceLevel.sRequired)) {
                reqGroup = true;
                if (interactiveMode) {
                    for (RoomLocation r : roomLocations) {
                        r.setPreference(r.getPreference() + 100);
                    }
                } else {
                    roomLocations.clear();
                }
            }
            if (!groupPref.getPreferenceProlog().equals(PreferenceLevel.sProhibited) && !groupPref.getPreferenceProlog().equals(PreferenceLevel.sRequired)) {
                pref.addPreferenceProlog(groupPref.getPreferenceProlog());
            }
            String roomPref = null;
            BasePreferenceLevel roomPreference = null;
            for (RoomPref x : clazz.getManagingDept().getPreferences(RoomPref.class)) {
                if (!room.equals(x.getRoom())) continue;
                roomPreference = x.getPrefLevel();
            }
            if (roomPreference != null) {
                roomPref = roomPreference.getPrefProlog();
                if (PreferenceLevel.sProhibited.equals(roomPref)) {
                    add = false;
                }
                if (PreferenceLevel.sStronglyDiscouraged.equals(roomPref)) {
                    roomPref = PreferenceLevel.sProhibited;
                }
            }
            for (RoomPref p : roomPrefs) {
                if (!room.equals(p.getRoom())) continue;
                roomPref = p.getPrefLevel().getPrefProlog();
                break;
            }
            if (roomPref != null && roomPref.equals(PreferenceLevel.sProhibited)) {
                if (interactiveMode) {
                    pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                } else {
                    add = false;
                }
            }
            if (reqRoom && (roomPref == null || !roomPref.equals(PreferenceLevel.sRequired))) {
                if (interactiveMode) {
                    pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                } else {
                    add = false;
                }
            }
            if (!reqRoom && roomPref != null && roomPref.equals(PreferenceLevel.sRequired)) {
                reqRoom = true;
                if (interactiveMode) {
                    for (RoomLocation r : roomLocations) {
                        r.setPreference(r.getPreference() + 100);
                    }
                } else {
                    roomLocations.clear();
                }
            }
            if (roomPref != null && !roomPref.equals(PreferenceLevel.sProhibited) && !roomPref.equals(PreferenceLevel.sRequired)) {
                pref.addPreferenceProlog(roomPref);
            }
            Building bldg = room instanceof Room ? ((Room)room).getBuilding() : null;
            String bldgPref = null;
            for (BuildingPref p : bldgPrefs) {
                if (bldg == null || !bldg.equals(p.getBuilding())) continue;
                bldgPref = p.getPrefLevel().getPrefProlog();
                break;
            }
            if (bldgPref != null && bldgPref.equals(PreferenceLevel.sProhibited)) {
                if (interactiveMode) {
                    pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                } else {
                    add = false;
                }
            }
            if (reqBldg && (bldgPref == null || !bldgPref.equals(PreferenceLevel.sRequired))) {
                if (interactiveMode) {
                    pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                } else {
                    add = false;
                }
            }
            if (!reqBldg && bldgPref != null && bldgPref.equals(PreferenceLevel.sRequired)) {
                reqBldg = true;
                if (interactiveMode) {
                    for (RoomLocation r : roomLocations) {
                        r.setPreference(r.getPreference() + 100);
                    }
                } else {
                    roomLocations.clear();
                }
            }
            if (bldgPref != null && !bldgPref.equals(PreferenceLevel.sProhibited) && !bldgPref.equals(PreferenceLevel.sRequired)) {
                pref.addPreferenceProlog(bldgPref);
            }
            boolean acceptableFeatures = true;
            MinMaxPreferenceCombination featurePref = new MinMaxPreferenceCombination();
            for (RoomFeaturePref roomFeaturePref : featurePrefs) {
                RoomFeature feature = roomFeaturePref.getRoomFeature();
                String p = roomFeaturePref.getPrefLevel().getPrefProlog();
                boolean hasFeature = feature.getRooms().contains(room);
                if (p.equals(PreferenceLevel.sProhibited) && hasFeature) {
                    acceptableFeatures = false;
                }
                if (p.equals(PreferenceLevel.sRequired) && !hasFeature) {
                    acceptableFeatures = false;
                }
                if (p == null || !hasFeature || p.equals(PreferenceLevel.sProhibited) || p.equals(PreferenceLevel.sRequired)) continue;
                featurePref.addPreferenceProlog(p);
            }
            pref.addPreferenceInt(featurePref.getPreferenceInt());
            if (!acceptableFeatures) {
                if (interactiveMode) {
                    pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                } else {
                    add = false;
                }
            }
            if (room.getCapacity() < stronglyDiscouragedCapacity) {
                if (interactiveMode) {
                    pref.addPreferenceInt(1000);
                } else {
                    add = false;
                }
            } else if (room.getCapacity() < discouragedCapacity) {
                pref.addPreferenceProlog(PreferenceLevel.sStronglyDiscouraged);
            } else if (room.getCapacity() < roomCapacity) {
                pref.addPreferenceProlog(PreferenceLevel.sDiscouraged);
            }
            int prefInt = pref.getPreferenceInt();
            if (!add) continue;
            roomLocations.add(new RoomLocation(room.getUniqueId(), room.getLabel(), bldg == null ? null : bldg.getUniqueId(), prefInt, room.getCapacity().intValue(), room.getCoordinateX(), room.getCoordinateY(), room.isIgnoreTooFar() == null ? false : room.isIgnoreTooFar(), null));
        }
        return roomLocations;
    }

    private Lecture loadClass(Class_ clazz, org.hibernate.Session hibSession) {
        long estNrValues;
        if (clazz.isCancelled().booleanValue()) {
            this.iProgress.message(this.msglevel("cancelledClass", 5), "Class " + this.getClassLabel(clazz) + " is cancelled (class not loaded).");
            return null;
        }
        ArrayList<Object> timeLocations = new ArrayList<Object>();
        ArrayList<RoomLocation> roomLocations = new ArrayList<RoomLocation>();
        this.iProgress.message(this.msglevel("loadingClass", 1), "loading class " + this.getClassLabel(clazz));
        Department dept = clazz.getControllingDept();
        this.iDeptNames.put(dept.getUniqueId(), dept.getShortLabel());
        this.iProgress.trace("department: " + dept.getName() + " (id:" + dept.getUniqueId() + ")");
        int minClassLimit = clazz.getExpectedCapacity();
        int maxClassLimit = clazz.getMaxExpectedCapacity();
        if (maxClassLimit < minClassLimit) {
            maxClassLimit = minClassLimit;
        }
        if (clazz.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue()) {
            maxClassLimit = Integer.MAX_VALUE;
            minClassLimit = Integer.MAX_VALUE;
        }
        float room2limitRatio = clazz.getRoomRatio().floatValue();
        int roomCapacity = Math.round(minClassLimit <= 0 ? room2limitRatio : room2limitRatio * (float)minClassLimit);
        this.iProgress.trace("class limit: [" + minClassLimit + "," + maxClassLimit + "]");
        this.iProgress.trace("room2limitRatio: " + room2limitRatio);
        this.iProgress.trace("room capacity: " + roomCapacity);
        int discouragedCapacity = (int)Math.round((1.0 - this.iFewerSeatsDisouraged) * (double)roomCapacity);
        this.iProgress.trace("discouraged capacity: " + discouragedCapacity);
        int stronglyDiscouragedCapacity = (int)Math.round((1.0 - this.iFewerSeatsStronglyDisouraged) * (double)roomCapacity);
        this.iProgress.trace("strongly discouraged capacity: " + stronglyDiscouragedCapacity);
        Set timePrefs = clazz.effectivePreferences(TimePref.class);
        if (timePrefs.isEmpty()) {
            if (clazz.getSchedulingSubpart().getMinutesPerWk() != 0) {
                DurationModel dm = clazz.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
                this.iProgress.message(this.msglevel("noTimePattern", 5), "Class " + this.getClassLabel(clazz) + " has no time pattern selected (class not loaded). <i>If not changed, this class will be treated as Arrange " + dm.getArrangedHours(clazz.getSchedulingSubpart().getMinutesPerWk(), clazz.effectiveDatePattern()) + " Hours.</i>");
            }
            return null;
        }
        HashSet<TimePattern> patterns = new HashSet<TimePattern>();
        DatePattern datePattern = clazz.effectiveDatePattern();
        if (datePattern == null) {
            this.iProgress.message(this.msglevel("noDatePattern", 5), "Class " + this.getClassLabel(clazz) + " has no date pattern selected (class not loaded).");
            return null;
        }
        this.iAllUsedDatePatterns.add(datePattern);
        int nrRooms = clazz.getNbrRooms() == null ? 1 : clazz.getNbrRooms();
        Set groupPrefs = clazz.effectivePreferences(RoomGroupPref.class);
        Set roomPrefs = clazz.effectivePreferences(RoomPref.class);
        Set bldgPrefs = clazz.effectivePreferences(BuildingPref.class);
        Set featurePrefs = clazz.effectivePreferences(RoomFeaturePref.class);
        if (nrRooms > 0) {
            boolean reqRoom = false;
            boolean reqBldg = false;
            boolean reqGroup = false;
            Set<Location> allRooms = clazz.getAvailableRooms();
            for (Location room : allRooms) {
                this.iProgress.trace("checking room " + room.getLabel() + " ...");
                boolean add = true;
                SumPreferenceCombination pref = new SumPreferenceCombination();
                PreferenceCombination groupPref = PreferenceCombination.getDefault();
                for (Preference p : groupPrefs) {
                    if (!((BaseRoomGroupPref)p).getRoomGroup().getRooms().contains(room)) continue;
                    groupPref.addPreferenceProlog(p.getPrefLevel().getPrefProlog());
                }
                if (groupPref.getPreferenceProlog().equals(PreferenceLevel.sProhibited)) {
                    this.iProgress.trace("group is prohibited :-(");
                    if (this.iInteractiveMode) {
                        pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                    } else {
                        add = false;
                    }
                }
                if (reqGroup && !groupPref.getPreferenceProlog().equals(PreferenceLevel.sRequired)) {
                    this.iProgress.trace("building is not required :-(");
                    if (this.iInteractiveMode) {
                        pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                    } else {
                        add = false;
                    }
                }
                if (!reqGroup && groupPref.getPreferenceProlog().equals(PreferenceLevel.sRequired)) {
                    this.iProgress.trace("group is required, removing all previous rooms (they are not required)");
                    reqGroup = true;
                    if (this.iInteractiveMode) {
                        for (RoomLocation r : roomLocations) {
                            r.setPreference(r.getPreference() + 100);
                        }
                    } else {
                        roomLocations.clear();
                    }
                }
                if (!groupPref.getPreferenceProlog().equals(PreferenceLevel.sProhibited) && !groupPref.getPreferenceProlog().equals(PreferenceLevel.sRequired)) {
                    pref.addPreferenceProlog(groupPref.getPreferenceProlog());
                }
                String roomPref = null;
                PreferenceLevel roomPreference = this.getRoomPreference(clazz.getManagingDept().getUniqueId(), room.getUniqueId());
                if (roomPreference != null) {
                    roomPref = roomPreference.getPrefProlog();
                    if (!this.iInteractiveMode && PreferenceLevel.sProhibited.equals(roomPref)) {
                        this.iProgress.trace("room is prohibited (on room level) :-(");
                        add = false;
                    }
                    if (PreferenceLevel.sStronglyDiscouraged.equals(roomPref)) {
                        roomPref = PreferenceLevel.sProhibited;
                    }
                }
                for (RoomPref p : roomPrefs) {
                    if (!room.equals(p.getRoom())) continue;
                    roomPref = p.getPrefLevel().getPrefProlog();
                    this.iProgress.trace("room preference is " + p.getPrefLevel().getPrefName());
                    break;
                }
                if (roomPref != null && roomPref.equals(PreferenceLevel.sProhibited)) {
                    this.iProgress.trace("room is prohibited :-(");
                    if (this.iInteractiveMode) {
                        pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                    } else {
                        add = false;
                    }
                }
                if (reqRoom && (roomPref == null || !roomPref.equals(PreferenceLevel.sRequired))) {
                    this.iProgress.trace("room is not required :-(");
                    if (this.iInteractiveMode) {
                        pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                    } else {
                        add = false;
                    }
                }
                if (!reqRoom && roomPref != null && roomPref.equals(PreferenceLevel.sRequired)) {
                    this.iProgress.trace("room is required, removing all previous rooms (they are not required)");
                    reqRoom = true;
                    if (this.iInteractiveMode) {
                        for (RoomLocation r : roomLocations) {
                            r.setPreference(r.getPreference() + 100);
                        }
                    } else {
                        roomLocations.clear();
                    }
                }
                if (roomPref != null && !roomPref.equals(PreferenceLevel.sProhibited) && !roomPref.equals(PreferenceLevel.sRequired)) {
                    pref.addPreferenceProlog(roomPref);
                }
                Building bldg = room instanceof Room ? ((Room)room).getBuilding() : null;
                String bldgPref = null;
                for (Preference p : bldgPrefs) {
                    if (bldg == null || !bldg.equals(((BaseBuildingPref)p).getBuilding())) continue;
                    bldgPref = p.getPrefLevel().getPrefProlog();
                    this.iProgress.trace("building preference is " + p.getPrefLevel().getPrefName());
                    break;
                }
                if (bldgPref != null && bldgPref.equals(PreferenceLevel.sProhibited)) {
                    this.iProgress.trace("building is prohibited :-(");
                    if (this.iInteractiveMode) {
                        pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                    } else {
                        add = false;
                    }
                }
                if (reqBldg && (bldgPref == null || !bldgPref.equals(PreferenceLevel.sRequired))) {
                    this.iProgress.trace("building is not required :-(");
                    if (this.iInteractiveMode) {
                        pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                    } else {
                        add = false;
                    }
                }
                if (!reqBldg && bldgPref != null && bldgPref.equals(PreferenceLevel.sRequired)) {
                    this.iProgress.trace("building is required, removing all previous rooms (they are not required)");
                    reqBldg = true;
                    if (this.iInteractiveMode) {
                        for (RoomLocation r : roomLocations) {
                            r.setPreference(r.getPreference() + 100);
                        }
                    } else {
                        roomLocations.clear();
                    }
                }
                if (bldgPref != null && !bldgPref.equals(PreferenceLevel.sProhibited) && !bldgPref.equals(PreferenceLevel.sRequired)) {
                    pref.addPreferenceProlog(bldgPref);
                }
                boolean acceptableFeatures = true;
                MinMaxPreferenceCombination featurePref = new MinMaxPreferenceCombination();
                for (RoomFeaturePref roomFeaturePref : featurePrefs) {
                    RoomFeature feature = roomFeaturePref.getRoomFeature();
                    String p = roomFeaturePref.getPrefLevel().getPrefProlog();
                    boolean hasFeature = feature.getRooms().contains(room);
                    if (p.equals(PreferenceLevel.sProhibited) && hasFeature) {
                        this.iProgress.trace("present feature " + feature.getLabel() + " is prohibited :-(");
                        acceptableFeatures = false;
                    }
                    if (p.equals(PreferenceLevel.sRequired) && !hasFeature) {
                        this.iProgress.trace("not present feature " + feature.getLabel() + " is required :-(");
                        acceptableFeatures = false;
                    }
                    if (p == null || !hasFeature || p.equals(PreferenceLevel.sProhibited) || p.equals(PreferenceLevel.sRequired)) continue;
                    featurePref.addPreferenceProlog(p);
                }
                pref.addPreferenceInt(featurePref.getPreferenceInt());
                if (!acceptableFeatures) {
                    if (this.iInteractiveMode) {
                        pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                    } else {
                        add = false;
                    }
                }
                if (room.getCapacity() < stronglyDiscouragedCapacity) {
                    this.iProgress.trace("too small :-(");
                    if (this.iInteractiveMode) {
                        pref.addPreferenceInt(1000);
                    } else {
                        add = false;
                    }
                } else if (room.getCapacity() < discouragedCapacity) {
                    this.iProgress.trace("room of strongly discouraged size");
                    pref.addPreferenceProlog(PreferenceLevel.sStronglyDiscouraged);
                } else if (room.getCapacity() < roomCapacity) {
                    this.iProgress.trace("room of discouraged size");
                    pref.addPreferenceProlog(PreferenceLevel.sDiscouraged);
                }
                int prefInt = pref.getPreferenceInt();
                this.iProgress.trace("room preference is " + prefInt);
                if (!add) continue;
                roomLocations.add(new RoomLocation(room.getUniqueId(), room.getLabel(), bldg == null ? null : bldg.getUniqueId(), prefInt, room.getCapacity().intValue(), room.getCoordinateX(), room.getCoordinateY(), room.isIgnoreTooFar() == null ? false : room.isIgnoreTooFar(), this.getRoomConstraint(clazz.getManagingDept(), room, hibSession)));
            }
            if (roomLocations.isEmpty() || roomLocations.size() < (clazz.getNbrRooms() == null ? 1 : clazz.getNbrRooms())) {
                this.iProgress.message(this.msglevel("noRoom", 5), "Class " + this.getClassLabel(clazz) + " has no available room" + (clazz.getNbrRooms() != null && clazz.getNbrRooms() > 1 ? "s" : "") + " (class not loaded).");
                return null;
            }
        } else if (!(groupPrefs.isEmpty() && roomPrefs.isEmpty() && bldgPrefs.isEmpty() && featurePrefs.isEmpty())) {
            this.iProgress.message(this.msglevel("zeroRoomsButPref", 5), "Class " + this.getClassLabel(clazz) + " requires no room (number of rooms is set to zero), but it contains some room preferences.");
        }
        int minPerWeek = clazz.getSchedulingSubpart().getMinutesPerWk();
        boolean onlyReq = false;
        for (TimePref timePref : timePrefs) {
            TimePatternModel pattern = timePref.getTimePatternModel();
            if (!pattern.isExactTime() && pattern.countPreferences(PreferenceLevel.sRequired) <= 0) continue;
            onlyReq = true;
        }
        if (onlyReq) {
            this.iProgress.trace("time pattern has requred times");
        }
        ClassDurationType dtype = clazz.getSchedulingSubpart().getInstrOfferingConfig().getEffectiveDurationType();
        DurationModel dm = clazz.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
        for (TimePref timePref : timePrefs) {
            Object loc;
            TimeLocation loc2;
            int prVal;
            String pr;
            TimePatternModel pattern = timePref.getTimePatternModel();
            if (pattern.isExactTime()) {
                if (datePattern.getType() == 4) {
                    Set datePatternPrefs = clazz.effectivePreferences(DatePatternPref.class);
                    boolean hasReq = false;
                    for (Preference p : datePatternPrefs) {
                        if (!PreferenceLevel.sRequired.equals(p.getPrefLevel().getPrefProlog())) continue;
                        hasReq = true;
                        break;
                    }
                    for (DatePattern child : datePattern.findChildren()) {
                        int minsPerMeeting = dm.getExactTimeMinutesPerMeeting(clazz.getSchedulingSubpart().getMinutesPerWk(), child, pattern.getExactDays());
                        int length = ExactTimeMins.getNrSlotsPerMtg(minsPerMeeting);
                        int breakTime = ExactTimeMins.getBreakTime(minsPerMeeting);
                        pr = PreferenceLevel.sNeutral;
                        for (DatePatternPref p : datePatternPrefs) {
                            if (!p.getDatePattern().equals(child)) continue;
                            pr = p.getPrefLevel().getPrefProlog();
                        }
                        prVal = 0;
                        if (!PreferenceLevel.sNeutral.equals(pr) && !PreferenceLevel.sRequired.equals(pr)) {
                            prVal = PreferenceLevel.prolog2int(pr);
                        }
                        if (this.iInteractiveMode) {
                            if (hasReq && !PreferenceLevel.sRequired.equals(pr)) {
                                prVal += 100;
                            }
                            if (PreferenceLevel.sProhibited.equals(pr)) {
                                prVal += 100;
                            }
                        } else if (hasReq && !PreferenceLevel.sRequired.equals(pr) || PreferenceLevel.sProhibited.equals(pr)) continue;
                        loc2 = new TimeLocation(pattern.getExactDays(), pattern.getExactStartSlot(), length, PreferenceLevel.sIntLevelNeutral, 0.0, PreferenceLevel.prolog2int(pr), child.getUniqueId(), child.getName(), child.getPatternBitSet(), breakTime);
                        loc2.setTimePatternId(pattern.getTimePattern().getUniqueId());
                        if (!PreferenceLevel.sNeutral.equals(pr) && !PreferenceLevel.sRequired.equals(pr)) {
                            loc2.setNormalizedPreference(this.iAlterDatePatternWeight * (double)prVal);
                        }
                        timeLocations.add(loc2);
                    }
                    continue;
                }
                int minsPerMeeting = dm.getExactTimeMinutesPerMeeting(clazz.getSchedulingSubpart().getMinutesPerWk(), datePattern, pattern.getExactDays());
                int length = ExactTimeMins.getNrSlotsPerMtg(minsPerMeeting);
                int breakTime = ExactTimeMins.getBreakTime(minsPerMeeting);
                loc = new TimeLocation(pattern.getExactDays(), pattern.getExactStartSlot(), length, PreferenceLevel.sIntLevelNeutral, 0.0, datePattern.getUniqueId(), datePattern.getName(), datePattern.getPatternBitSet(), breakTime);
                loc.setTimePatternId(pattern.getTimePattern().getUniqueId());
                timeLocations.add(loc);
                continue;
            }
            patterns.add(pattern.getTimePattern());
            if (this.iWeakenTimePreferences) {
                pattern.weakenHardPreferences();
                onlyReq = false;
            }
            if (!dm.isValidCombination(clazz.getSchedulingSubpart().getMinutesPerWk(), datePattern, timePref.getTimePattern())) {
                this.iProgress.message(this.msglevel("noTimePattern", 5), "Class " + this.getClassLabel(clazz) + " has " + clazz.getSchedulingSubpart().getMinutesPerWk() + " " + (dtype == null ? "minutes per week" : dtype.getLabel()) + " , but " + pattern.getName() + " time pattern selected.");
                minPerWeek = pattern.getMinPerMtg() * pattern.getNrMeetings();
                if (this.iFixMinPerWeek) {
                    clazz.getSchedulingSubpart().setMinutesPerWk(new Integer(minPerWeek));
                }
            }
            for (int time = 0; time < pattern.getNrTimes(); ++time) {
                if (pattern.getStartSlot(time) + pattern.getSlotsPerMtg() > 288) {
                    this.iProgress.message(this.msglevel("timeOverMidnight", 5), "Time pattern " + pattern.getName() + " that is used by " + this.getClassLabel(clazz) + " has a time that goes over midnight. " + "This is not allowed and the time " + pattern.getStartTime(time) + " will be ignored.");
                    continue;
                }
                for (int day = 0; day < pattern.getNrDays(); ++day) {
                    String altPref;
                    String pref = pattern.getPreference(day, time);
                    this.iProgress.trace("checking time " + pattern.getDayHeader(day) + " " + pattern.getTimeHeaderShort(time) + " (" + pref + ")");
                    if (!dm.isValidSelection(clazz.getSchedulingSubpart().getMinutesPerWk(), datePattern, timePref.getTimePattern(), pattern.getDayCode(day))) {
                        this.iProgress.trace("time is not valid :-(");
                        continue;
                    }
                    if (!this.iInteractiveMode && pref.equals(PreferenceLevel.sProhibited)) {
                        this.iProgress.trace("time is prohibited :-(");
                        continue;
                    }
                    if (!this.iInteractiveMode && onlyReq && !pref.equals(PreferenceLevel.sRequired)) {
                        this.iProgress.trace("time is not required :-(");
                        continue;
                    }
                    if (datePattern.getType() == 4) {
                        Set datePatternPrefs = clazz.effectivePreferences(DatePatternPref.class);
                        boolean hasReq = false;
                        for (DatePatternPref p : datePatternPrefs) {
                            if (!PreferenceLevel.sRequired.equals(p.getPrefLevel().getPrefProlog())) continue;
                            hasReq = true;
                            break;
                        }
                        for (DatePattern child : datePattern.findChildren()) {
                            String altPref2;
                            if (!dm.isValidSelection(clazz.getSchedulingSubpart().getMinutesPerWk(), child, timePref.getTimePattern(), pattern.getDayCode(day))) continue;
                            pr = PreferenceLevel.sNeutral;
                            for (DatePatternPref p : datePatternPrefs) {
                                if (!p.getDatePattern().equals(child)) continue;
                                pr = p.getPrefLevel().getPrefProlog();
                            }
                            prVal = 0;
                            if (!PreferenceLevel.sNeutral.equals(pr) && !PreferenceLevel.sRequired.equals(pr)) {
                                prVal = PreferenceLevel.prolog2int(pr);
                            }
                            if (this.iInteractiveMode) {
                                if (hasReq && !PreferenceLevel.sRequired.equals(pr)) {
                                    prVal += 100;
                                }
                                if (PreferenceLevel.sProhibited.equals(pr)) {
                                    prVal += 100;
                                }
                            } else if (hasReq && !PreferenceLevel.sRequired.equals(pr) || PreferenceLevel.sProhibited.equals(pr)) continue;
                            loc2 = new TimeLocation(pattern.getDayCode(day), pattern.getStartSlot(time), pattern.getSlotsPerMtg(), PreferenceLevel.prolog2int(pattern.getPreference(day, time)), pattern.getNormalizedPreference(day, time, this.iNormalizedPrefDecreaseFactor), PreferenceLevel.prolog2int(pr), child.getUniqueId(), child.getName(), child.getPatternBitSet(), pattern.getBreakTime());
                            loc2.setTimePatternId(pattern.getTimePattern().getUniqueId());
                            if (this.iAlterTimePatternWeight != 0.0 && !(altPref2 = this.iAlterTimePatternModel.getCombinedPreference(loc2.getDayCode(), loc2.getStartSlot(), loc2.getLength(), 2)).equals(PreferenceLevel.sNeutral)) {
                                loc2.setNormalizedPreference(loc2.getNormalizedPreference() + this.iAlterTimePatternWeight * (double)PreferenceLevel.prolog2int(altPref2));
                            }
                            if (this.iInteractiveMode && onlyReq && !pref.equals(PreferenceLevel.sRequired)) {
                                loc2.setPreference(PreferenceLevel.sIntLevelProhibited);
                                loc2.setNormalizedPreference((double)PreferenceLevel.sIntLevelProhibited);
                            }
                            if (!PreferenceLevel.sNeutral.equals(pr) && !PreferenceLevel.sRequired.equals(pr)) {
                                loc2.setNormalizedPreference(loc2.getNormalizedPreference() + this.iAlterDatePatternWeight * (double)prVal);
                            }
                            timeLocations.add(loc2);
                        }
                        continue;
                    }
                    loc = new TimeLocation(pattern.getDayCode(day), pattern.getStartSlot(time), pattern.getSlotsPerMtg(), PreferenceLevel.prolog2int(pattern.getPreference(day, time)), pattern.getNormalizedPreference(day, time, this.iNormalizedPrefDecreaseFactor), datePattern.getUniqueId(), datePattern.getName(), datePattern.getPatternBitSet(), pattern.getBreakTime());
                    loc.setTimePatternId(pattern.getTimePattern().getUniqueId());
                    if (this.iAlterTimePatternWeight != 0.0 && !(altPref = this.iAlterTimePatternModel.getCombinedPreference(loc.getDayCode(), loc.getStartSlot(), loc.getLength(), 2)).equals(PreferenceLevel.sNeutral)) {
                        loc.setNormalizedPreference(loc.getNormalizedPreference() + this.iAlterTimePatternWeight * (double)PreferenceLevel.prolog2int(altPref));
                    }
                    if (this.iInteractiveMode && onlyReq && !pref.equals(PreferenceLevel.sRequired)) {
                        loc.setPreference(PreferenceLevel.sIntLevelProhibited);
                        loc.setNormalizedPreference((double)PreferenceLevel.sIntLevelProhibited);
                    }
                    timeLocations.add(loc);
                }
            }
        }
        if (this.iInteractiveMode) {
            for (TimePattern pattern : TimePattern.findApplicable(this.iSession, false, false, false, minPerWeek, datePattern, dm, clazz.getManagingDept())) {
                if (patterns.contains(pattern)) continue;
                TimePatternModel model = pattern.getTimePatternModel();
                this.iProgress.trace("adding prohibited pattern " + model.getName());
                for (int time = 0; time < model.getNrTimes(); ++time) {
                    for (int day = 0; day < model.getNrDays(); ++day) {
                        if (datePattern.getType() == 4) {
                            Set datePatternPrefs = clazz.effectivePreferences(DatePatternPref.class);
                            for (DatePattern child : datePattern.findChildren()) {
                                if (!dm.isValidSelection(clazz.getSchedulingSubpart().getMinutesPerWk(), child, pattern, model.getDayCode(day))) continue;
                                String pr = PreferenceLevel.sNeutral;
                                for (Preference p : datePatternPrefs) {
                                    if (!((BaseDatePatternPref)p).getDatePattern().equals(child)) continue;
                                    pr = p.getPrefLevel().getPrefProlog();
                                }
                                TimeLocation loc = new TimeLocation(model.getDayCode(day), model.getStartSlot(time), model.getSlotsPerMtg(), PreferenceLevel.prolog2int(model.getPreference(day, time)), model.getNormalizedPreference(day, time, this.iNormalizedPrefDecreaseFactor), PreferenceLevel.prolog2int(pr), child.getUniqueId(), child.getName(), child.getPatternBitSet(), model.getBreakTime());
                                loc.setTimePatternId(model.getTimePattern().getUniqueId());
                                loc.setPreference(1000);
                                loc.setNormalizedPreference(1000.0);
                                timeLocations.add(loc);
                            }
                            continue;
                        }
                        if (!dm.isValidSelection(clazz.getSchedulingSubpart().getMinutesPerWk(), datePattern, pattern, model.getDayCode(day))) continue;
                        TimeLocation loc = new TimeLocation(model.getDayCode(day), model.getStartSlot(time), model.getSlotsPerMtg(), PreferenceLevel.prolog2int(model.getPreference(day, time)), model.getNormalizedPreference(day, time, this.iNormalizedPrefDecreaseFactor), datePattern.getUniqueId(), datePattern.getName(), datePattern.getPatternBitSet(), model.getBreakTime());
                        loc.setTimePatternId(model.getTimePattern().getUniqueId());
                        loc.setPreference(1000);
                        loc.setNormalizedPreference(1000.0);
                        timeLocations.add(loc);
                    }
                }
            }
        }
        if (timeLocations.isEmpty()) {
            this.iProgress.message(this.msglevel("noTime", 5), "Class " + this.getClassLabel(clazz) + " has no available time (class not loaded).");
            return null;
        }
        List<DepartmentalInstructor> instructors = clazz.getLeadInstructors();
        String className = clazz.getClassLabel();
        Lecture lecture = new Lecture(clazz.getUniqueId(), clazz.getManagingDept().getSolverGroup().getUniqueId(), clazz.getSchedulingSubpart().getUniqueId(), className, timeLocations, roomLocations, nrRooms, null, minClassLimit, maxClassLimit, (double)room2limitRatio);
        lecture.setNote(clazz.getNotes());
        if (clazz.getManagingDept() != null) {
            lecture.setScheduler(clazz.getManagingDept().getUniqueId());
        }
        lecture.setDepartment(dept.getUniqueId());
        for (DepartmentalInstructor instructor : instructors) {
            this.getInstructorConstraint(instructor, hibSession).addVariable((Variable)lecture);
        }
        if (nrRooms > 1) {
            lecture.setMaxRoomCombinations(this.iMaxRoomCombinations);
        }
        if ((estNrValues = lecture.nrValues()) > 1000000L) {
            this.iProgress.message(this.msglevel("hugeDomain", 5), "Class " + this.getClassLabel(lecture) + " has too many possible placements (" + estNrValues + "). " + "The class was not loaded in order to prevent out of memory exception. " + "Please restrict the number of available rooms and/or times for this class.");
            for (DepartmentalInstructor instructor : instructors) {
                this.getInstructorConstraint(instructor, hibSession).removeVariable((Variable)lecture);
            }
            return null;
        }
        if (estNrValues > 10000L) {
            this.iProgress.message(this.msglevel("bigDomain", 5), "Class " + this.getClassLabel(lecture) + " has quite a lot of possible placements (" + estNrValues + "). " + "Solver may run too slow. " + "If possible, please restrict the number of available rooms and/or times for this class.");
        }
        if (lecture.values(this.getAssignment()).isEmpty()) {
            if (!this.iInteractiveMode) {
                this.iProgress.message(this.msglevel("noPlacement", 5), "Class " + this.getClassLabel(lecture) + " has no available placement (class not loaded).");
                for (DepartmentalInstructor instructor : instructors) {
                    this.getInstructorConstraint(instructor, hibSession).removeVariable((Variable)lecture);
                }
                return null;
            }
            this.iProgress.message(this.msglevel("noPlacement", 5), "Class " + this.getClassLabel(lecture) + " has no available placement.");
        }
        if (this.iClassWeightProvider != null) {
            lecture.setWeight(this.iClassWeightProvider.getWeight(lecture));
        }
        this.iLectures.put(clazz.getUniqueId(), lecture);
        ((TimetableModel)this.getModel()).addVariable((Variable)lecture);
        for (RoomLocation r : roomLocations) {
            r.getRoomConstraint().addVariable((Variable)lecture);
        }
        return lecture;
    }

    private void assignCommited() {
        if (!((TimetableModel)this.getModel()).hasConstantVariables()) {
            return;
        }
        this.iProgress.setPhase("Assigning committed classes ...", (long)((TimetableModel)this.getModel()).constantVariables().size());
        for (Lecture lecture : ((TimetableModel)this.getModel()).constantVariables()) {
            this.iProgress.incProgress();
            if (this.getAssignment().getValue((Variable)lecture) != null) continue;
            Placement placement = (Placement)lecture.getInitialAssignment();
            ((TimetableModel)this.getModel()).weaken(this.getAssignment(), (Value)placement);
            Map conflictConstraints = ((TimetableModel)this.getModel()).conflictConstraints(this.getAssignment(), (Value)placement);
            if (conflictConstraints.isEmpty()) {
                this.getAssignment().assign(0L, (Value)placement);
                continue;
            }
            String warn = "Unable to assign committed class " + this.getClassLabel(lecture) + " &larr; " + placement.getLongName(this.iUseAmPm);
            warn = warn + "<br>&nbsp;&nbsp;Reason:";
            for (Constraint c : conflictConstraints.keySet()) {
                Set vals = (Set)conflictConstraints.get(c);
                for (Placement v : vals) {
                    warn = warn + "<br>&nbsp;&nbsp;&nbsp;&nbsp;" + this.getClassLabel((Lecture)v.variable()) + " = " + v.getLongName(this.iUseAmPm);
                }
                warn = warn + "<br>&nbsp;&nbsp;&nbsp;&nbsp;    in constraint " + c;
                this.iProgress.message(this.msglevel("cannotAssignCommitted", 5), warn);
            }
        }
    }

    private void purgeInvalidValues() {
        this.iProgress.setPhase("Purging invalid placements ...", (long)((TimetableModel)this.getModel()).variables().size());
        for (Lecture lecture : new ArrayList(((TimetableModel)this.getModel()).variables())) {
            ArrayList oldValues = new ArrayList(lecture.values(this.getAssignment()));
            lecture.purgeInvalidValues(this.iInteractiveMode);
            if (lecture.values(this.getAssignment()).isEmpty()) {
                String warn = "Class " + this.getClassLabel(lecture) + " has no available placement (after enforcing consistency between the problem and committed solutions" + (this.iInteractiveMode ? "" : ", class not loaded") + ").";
                for (Placement p : oldValues) {
                    warn = warn + "<br>&nbsp;&nbsp;&nbsp;&nbsp;" + p.getNotValidReason(this.getAssignment(), this.iUseAmPm);
                }
                this.iProgress.message(this.msglevel("noPlacementAfterCommit", 5), warn);
                if (!this.iInteractiveMode) {
                    ((TimetableModel)this.getModel()).removeVariable((Variable)lecture);
                    for (Constraint c : new ArrayList(lecture.constraints())) {
                        c.removeVariable((Variable)lecture);
                        if (!c.variables().isEmpty() && !(c instanceof BinaryConstraint)) continue;
                        ((TimetableModel)this.getModel()).removeConstraint(c);
                    }
                    for (Student s : lecture.students()) {
                        s.getLectures().remove(lecture);
                    }
                }
            }
            this.iProgress.incProgress();
        }
    }

    private void loadAssignment(org.unitime.timetable.model.Assignment assignment) {
        Set vals;
        Lecture lecture = this.iLectures.get(assignment.getClazz().getUniqueId());
        int dayCode = assignment.getDays();
        int startSlot = assignment.getStartSlot();
        Long patternId = assignment.getTimePattern().getUniqueId();
        DatePattern datePattern = assignment.getDatePattern();
        Set<Location> rooms = assignment.getRooms();
        if (lecture == null) {
            return;
        }
        Object initialPlacement = null;
        for (Object placement : lecture.values(this.getAssignment())) {
            if (placement.getTimeLocation().getDayCode() != dayCode || placement.getTimeLocation().getStartSlot() != startSlot || !placement.getTimeLocation().getTimePatternId().equals(patternId) || datePattern != null && !placement.getTimeLocation().getDatePatternId().equals(datePattern.getUniqueId()) || rooms.size() != placement.getNrRooms()) continue;
            boolean sameRooms = true;
            Iterator<Location> i = rooms.iterator();
            while (sameRooms && i.hasNext()) {
                Location r = i.next();
                if (placement.hasRoomLocation(r.getUniqueId())) continue;
                sameRooms = false;
            }
            if (!sameRooms) continue;
            initialPlacement = placement;
            break;
        }
        if (initialPlacement == null) {
            TimeLocation timeLocation = null;
            for (TimeLocation t : lecture.timeLocations()) {
                if (t.getDayCode() != dayCode || t.getStartSlot() != startSlot || !t.getTimePatternId().equals(patternId) || datePattern != null && !t.getDatePatternId().equals(datePattern.getUniqueId())) continue;
                timeLocation = t;
                break;
            }
            ArrayList<RoomLocation> roomLocations = new ArrayList<RoomLocation>();
            for (Location room : rooms) {
                for (RoomLocation r : lecture.roomLocations()) {
                    if (!r.getId().equals(room.getUniqueId())) continue;
                    roomLocations.add(r);
                }
            }
            if (timeLocation != null && roomLocations.size() == lecture.getNrRooms()) {
                initialPlacement = new Placement(lecture, timeLocation, roomLocations);
            }
        }
        if (initialPlacement == null) {
            StringBuffer sb = new StringBuffer(assignment.getTimeLocation().getLongName(this.iUseAmPm) + " ");
            Iterator<Object> i = rooms.iterator();
            while (i.hasNext()) {
                sb.append(((Location)i.next()).getLabel());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
            if (!assignment.getInstructors().isEmpty()) {
                sb.append(" ");
                i = assignment.getInstructors().iterator();
                while (i.hasNext()) {
                    sb.append(((DepartmentalInstructor)i.next()).getName(this.iInstructorFormat));
                    if (!i.hasNext()) continue;
                    sb.append(", ");
                }
            }
            this.iProgress.message(this.msglevel("placementNotValid", 5), "Unable to assign " + this.getClassLabel(lecture) + " &larr; " + sb + " (placement not valid)");
            return;
        }
        if (!initialPlacement.isValid()) {
            Map conflictConstraints;
            String reason = "";
            for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                if (ic.isAvailable(lecture, initialPlacement)) continue;
                reason = reason + "<br>&nbsp;&nbsp;&nbsp;&nbsp;instructor " + ic.getName() + " not available";
            }
            if (lecture.getNrRooms() > 0) {
                if (initialPlacement.isMultiRoom()) {
                    for (RoomLocation roomLocation : initialPlacement.getRoomLocations()) {
                        if (roomLocation.getRoomConstraint().isAvailable(lecture, initialPlacement.getTimeLocation(), lecture.getScheduler())) continue;
                        reason = reason + "<br>&nbsp;&nbsp;&nbsp;&nbsp;room " + roomLocation.getName() + " not available";
                    }
                } else if (!initialPlacement.getRoomLocation().getRoomConstraint().isAvailable(lecture, initialPlacement.getTimeLocation(), lecture.getScheduler())) {
                    reason = reason + "<br>&nbsp;&nbsp;&nbsp;&nbsp;room " + initialPlacement.getRoomLocation().getName() + " not available";
                }
            }
            if (!(conflictConstraints = ((TimetableModel)this.getModel()).conflictConstraints(this.getAssignment(), initialPlacement)).isEmpty()) {
                for (Constraint c : conflictConstraints.keySet()) {
                    vals = (Set)conflictConstraints.get(c);
                    for (Placement p : vals) {
                        Lecture l = (Lecture)p.variable();
                        if (l.isCommitted()) {
                            reason = reason + "<br>&nbsp;&nbsp;&nbsp;&nbsp;conflict with committed assignment " + this.getClassLabel(l) + " = " + p.getLongName(this.iUseAmPm) + " (in constraint " + c + ")";
                        }
                        if (!p.equals(initialPlacement)) continue;
                        reason = reason + "<br>&nbsp;&nbsp;&nbsp;&nbsp;constraint " + c;
                    }
                }
            }
            this.iProgress.message(this.msglevel("cannotAssign", 5), "Unable to assign " + this.getClassLabel(lecture) + " &larr; " + initialPlacement.getLongName(this.iUseAmPm) + (reason.length() == 0 ? "." : ":" + reason));
        } else {
            if (this.iMppAssignment) {
                lecture.setInitialAssignment(initialPlacement);
            }
            ((TimetableModel)this.getModel()).weaken(this.getAssignment(), initialPlacement);
            Map conflictConstraints = ((TimetableModel)this.getModel()).conflictConstraints(this.getAssignment(), initialPlacement);
            if (conflictConstraints.isEmpty()) {
                this.getAssignment().assign(0L, initialPlacement);
            } else {
                String warn = "Unable to assign " + this.getClassLabel(lecture) + " &larr; " + initialPlacement.getLongName(this.iUseAmPm);
                warn = warn + "<br>&nbsp;&nbsp;Reason:";
                for (Constraint c : conflictConstraints.keySet()) {
                    vals = (Set)conflictConstraints.get(c);
                    for (Placement v : vals) {
                        warn = warn + "<br>&nbsp;&nbsp;&nbsp;&nbsp;" + this.getClassLabel((Lecture)v.variable()) + " = " + v.getLongName(this.iUseAmPm);
                    }
                    warn = warn + "<br>&nbsp;&nbsp;&nbsp;&nbsp;    in constraint " + c;
                    this.iProgress.message(this.msglevel("cannotAssign", 5), warn);
                }
            }
        }
    }

    private RoomConstraint getRoomConstraint(Department dept, Location location, org.hibernate.Session hibSession) {
        RoomConstraint rc = this.iRooms.get(location.getUniqueId());
        if (rc == null) {
            PreferenceLevel roomPreference = this.getRoomPreference(dept.getUniqueId(), location.getUniqueId());
            boolean discouraged = !this.iInteractiveMode && roomPreference != null && (roomPreference.getPrefProlog().equals(PreferenceLevel.sProhibited) || roomPreference.getPrefProlog().equals(PreferenceLevel.sStronglyDiscouraged) || roomPreference.getPrefProlog().equals(PreferenceLevel.sDiscouraged));
            org.unitime.timetable.model.RoomSharingModel sharingModel = location.getRoomSharingModel();
            if (sharingModel != null && this.iIgnoreRoomSharing) {
                for (int d = 0; d < sharingModel.getNrDays(); ++d) {
                    for (int t = 0; t < sharingModel.getNrTimes(); ++t) {
                        if (String.valueOf(org.unitime.timetable.model.RoomSharingModel.sNotAvailablePref).equals(sharingModel.getPreference(d, t))) continue;
                        sharingModel.setPreference(d, t, String.valueOf(org.unitime.timetable.model.RoomSharingModel.sFreeForAllPref));
                    }
                }
            }
            if (sharingModel != null && sharingModel.allAvailable(null)) {
                sharingModel = null;
            }
            Long buildingId = null;
            if (location instanceof Room) {
                buildingId = ((Room)location).getBuilding().getUniqueId();
            }
            rc = discouraged ? new DiscouragedRoomConstraint(((TimetableModel)this.getModel()).getProperties(), location.getUniqueId(), location.getLabel(), buildingId, location.getCapacity().intValue(), (RoomSharingModel)sharingModel, location.getCoordinateX(), location.getCoordinateY(), location.isIgnoreTooFar() == null ? false : location.isIgnoreTooFar(), location.isIgnoreRoomCheck() == null ? true : location.isIgnoreRoomCheck() == false) : new RoomConstraint(location.getUniqueId(), location.getLabel(), buildingId, location.getCapacity().intValue(), (RoomSharingModel)sharingModel, location.getCoordinateX(), location.getCoordinateY(), location.isIgnoreTooFar() == null ? false : location.isIgnoreTooFar(), location.isIgnoreRoomCheck() == null ? true : location.isIgnoreRoomCheck() == false);
            rc.setType(location instanceof Room ? ((Room)location).getRoomType().getUniqueId() : null);
            ((TimetableModel)this.getModel()).addConstraint((Constraint)rc);
            this.iRooms.put(location.getUniqueId(), rc);
        }
        return rc;
    }

    private InstructorConstraint getInstructorConstraint(DepartmentalInstructor instructor, org.hibernate.Session hibSession) {
        InstructorConstraint ic;
        if (instructor.getExternalUniqueId() != null && instructor.getExternalUniqueId().length() > 0 && (ic = this.iInstructors.get(instructor.getExternalUniqueId())) != null) {
            return ic;
        }
        ic = this.iInstructors.get(instructor.getUniqueId());
        if (ic == null) {
            boolean ignDist = instructor.isIgnoreToFar() != null && instructor.isIgnoreToFar() != false;
            ic = new InstructorConstraint(instructor.getUniqueId(), instructor.getExternalUniqueId(), instructor.getName(this.iInstructorFormat), ignDist);
            ic.setType(instructor.getPositionType() == null ? new Long(Long.MAX_VALUE) : new Long(instructor.getPositionType().getSortOrder().intValue()));
            ((TimetableModel)this.getModel()).addConstraint((Constraint)ic);
            this.iInstructors.put(instructor.getUniqueId(), ic);
            if (instructor.getExternalUniqueId() != null && instructor.getExternalUniqueId().length() > 0) {
                this.iInstructors.put(instructor.getExternalUniqueId(), ic);
            }
        }
        return ic;
    }

    private void loadInstructorAvailabilities(org.hibernate.Session hibSession, String puids) {
        Query q = hibSession.createQuery("select distinct i.externalUniqueId, a from ClassInstructor ci inner join ci.instructor i inner join ci.classInstructing.assignments a where ci.lead = true and i.externalUniqueId in (" + puids + ") and a.solution.owner.session.uniqueId=:sessionId and a.solution.commited=true and a.solution.owner.uniqueId not in (" + this.iSolverGroupIds + ")");
        q.setLong("sessionId", this.iSessionId.longValue());
        Iterator i = q.iterate();
        while (i.hasNext()) {
            Object[] x = (Object[])i.next();
            String puid = (String)x[0];
            org.unitime.timetable.model.Assignment a = (org.unitime.timetable.model.Assignment)x[1];
            InstructorConstraint ic = this.iInstructors.get(puid);
            Placement p = a.getPlacement();
            ic.setNotAvailable(p);
            if (this.iLectures.containsKey(a.getClassId())) continue;
            this.iLectures.put(a.getClassId(), (Lecture)p.variable());
            ((TimetableModel)this.getModel()).addVariable(p.variable());
        }
    }

    private void loadInstructorAvailabilities(org.hibernate.Session hibSession) {
        this.iProgress.setPhase("Loading instructor availabilities ...", 1L);
        StringBuffer puids = new StringBuffer();
        int idx = 0;
        Enumeration<InstructorConstraint> e = this.iInstructors.elements();
        while (e.hasMoreElements()) {
            InstructorConstraint ic = e.nextElement();
            if (ic.getPuid() == null) continue;
            if (puids.length() > 0) {
                puids.append(",");
            }
            puids.append("'" + ic.getPuid() + "'");
            if (++idx != 100) continue;
            this.loadInstructorAvailabilities(hibSession, puids.toString());
            puids = new StringBuffer();
            idx = 0;
        }
        if (puids.length() > 0) {
            this.loadInstructorAvailabilities(hibSession, puids.toString());
        }
        this.iProgress.incProgress();
    }

    private void loadInstructorStudentConflicts(org.hibernate.Session hibSession, String puids) {
        for (Object[] x : hibSession.createQuery("select s.uniqueId, s.externalUniqueId from Student s where s.session.uniqueId = :sessionId and s.externalUniqueId in (" + puids + ")").setLong("sessionId", this.iSessionId.longValue()).list()) {
            Long studentId = (Long)x[0];
            String puid = (String)x[1];
            InstructorConstraint ic = this.iInstructors.get(puid);
            Student s = this.iStudents.get(studentId);
            if (s == null || ic == null) continue;
            this.iProgress.debug("Instructor " + puid + " mapped with student " + s.getId());
            s.setInstructor(ic);
            for (Lecture lecture : ic.variables()) {
                s.addLecture(lecture);
                lecture.addStudent(this.getAssignment(), s);
            }
        }
    }

    private void loadInstructorStudentConflicts(org.hibernate.Session hibSession) {
        this.iProgress.setPhase("Loading instructor student conflicts ...", 1L);
        StringBuffer puids = new StringBuffer();
        int idx = 0;
        for (InstructorConstraint ic : this.iInstructors.values()) {
            if (ic.getPuid() == null) continue;
            if (puids.length() > 0) {
                puids.append(",");
            }
            puids.append("'" + ic.getPuid() + "'");
            if (++idx != 100) continue;
            this.loadInstructorStudentConflicts(hibSession, puids.toString());
            puids = new StringBuffer();
            idx = 0;
        }
        if (puids.length() > 0) {
            this.loadInstructorStudentConflicts(hibSession, puids.toString());
        }
        this.iProgress.incProgress();
    }

    private void loadRoomAvailabilities(org.hibernate.Session hibSession, String roomids) {
        Query q = hibSession.createQuery("select distinct r.uniqueId, a from Location r inner join r.assignments as a where r.uniqueId in (" + roomids + ") and a.solution.owner.session.uniqueId=:sessionId and a.solution.commited=true and a.solution.owner.uniqueId not in (" + this.iSolverGroupIds + ") and r.ignoreRoomCheck = false");
        q.setLong("sessionId", this.iSessionId.longValue());
        Iterator i = q.iterate();
        while (i.hasNext()) {
            Object[] x = (Object[])i.next();
            Long roomId = (Long)x[0];
            org.unitime.timetable.model.Assignment a = (org.unitime.timetable.model.Assignment)x[1];
            Placement p = a.getPlacement();
            RoomConstraint rc = this.iRooms.get(roomId);
            rc.setNotAvailable(p);
            if (this.iLectures.containsKey(a.getClassId())) continue;
            this.iLectures.put(a.getClassId(), (Lecture)p.variable());
            ((TimetableModel)this.getModel()).addVariable(p.variable());
        }
    }

    private void loadRoomAvailabilities(org.hibernate.Session hibSession) {
        this.iProgress.setPhase("Loading room availabilities ...", 1L);
        StringBuffer roomids = new StringBuffer();
        int idx = 0;
        Enumeration<RoomConstraint> e = this.iRooms.elements();
        while (e.hasMoreElements()) {
            RoomConstraint rc = e.nextElement();
            if (roomids.length() > 0) {
                roomids.append(",");
            }
            roomids.append(rc.getResourceId());
            if (++idx != 100) continue;
            this.loadRoomAvailabilities(hibSession, roomids.toString());
            roomids = new StringBuffer();
            idx = 0;
        }
        if (roomids.length() > 0) {
            this.loadRoomAvailabilities(hibSession, roomids.toString());
        }
        this.iProgress.incProgress();
    }

    private Constraint createGroupConstraint(DistributionPref pref) {
        return this.createGroupConstraint(pref.getUniqueId(), pref.getDistributionType(), pref.getPrefLevel(), pref.getOwner());
    }

    private Constraint createGroupConstraint(Long id, DistributionType type, PreferenceLevel pref, Object owner) {
        SpreadConstraint gc = null;
        if (type.getReference().matches("_(.+)_")) {
            for (FlexibleConstraint.FlexibleConstraintType fcType : FlexibleConstraint.FlexibleConstraintType.values()) {
                if (!type.getReference().matches(fcType.getPattern())) continue;
                try {
                    gc = fcType.create(id, owner.toString(), pref.getPrefProlog(), type.getReference());
                }
                catch (IllegalArgumentException e) {
                    this.iProgress.warn("Constraint " + type.getReference() + " was not loaded. Inconsistent values.", (Throwable)e);
                }
            }
            if (gc == null) {
                this.iProgress.warn("Constraint " + type.getReference() + " was not recognized.");
                return null;
            }
        } else if ("SAME_INSTR".equals(type.getReference())) {
            if (PreferenceLevel.sRequired.equals(pref.getPrefProlog())) {
                gc = new InstructorConstraint(new Long(-id.longValue()), null, type.getLabel(), false);
            }
        } else if ("SPREAD".equals(type.getReference())) {
            gc = new SpreadConstraint(((TimetableModel)this.getModel()).getProperties(), "spread");
        } else if ("MIN_ROOM_USE".equals(type.getReference())) {
            if (!this.iInteractiveMode) {
                gc = new MinimizeNumberOfUsedRoomsConstraint(((TimetableModel)this.getModel()).getProperties());
            } else {
                this.iProgress.message(this.msglevel("constraintNotUsed", 3), "Minimize number of used rooms constraint not loaded due to the interactive mode of the solver.");
            }
        } else if ("MIN_GRUSE(10x1h)".equals(type.getReference())) {
            if (!this.iInteractiveMode) {
                gc = new MinimizeNumberOfUsedGroupsOfTime(((TimetableModel)this.getModel()).getProperties(), "10x1h", MinimizeNumberOfUsedGroupsOfTime.sGroups10of1h);
            } else {
                this.iProgress.message(this.msglevel("constraintNotUsed", 3), "Minimize number of used groups of time constraint not loaded due to the interactive mode of the solver.");
            }
        } else if ("MIN_GRUSE(5x2h)".equals(type.getReference())) {
            if (!this.iInteractiveMode) {
                gc = new MinimizeNumberOfUsedGroupsOfTime(((TimetableModel)this.getModel()).getProperties(), "5x2h", MinimizeNumberOfUsedGroupsOfTime.sGroups5of2h);
            } else {
                this.iProgress.message(this.msglevel("constraintNotUsed", 3), "Minimize number of used groups of time constraint not loaded due to the interactive mode of the solver.");
            }
        } else if ("MIN_GRUSE(3x3h)".equals(type.getReference())) {
            if (!this.iInteractiveMode) {
                gc = new MinimizeNumberOfUsedGroupsOfTime(((TimetableModel)this.getModel()).getProperties(), "3x3h", MinimizeNumberOfUsedGroupsOfTime.sGroups3of3h);
            } else {
                this.iProgress.message(this.msglevel("constraintNotUsed", 3), "Minimize number of used groups of time constraint not loaded due to the interactive mode of the solver.");
            }
        } else if ("MIN_GRUSE(2x5h)".equals(type.getReference())) {
            if (!this.iInteractiveMode) {
                gc = new MinimizeNumberOfUsedGroupsOfTime(((TimetableModel)this.getModel()).getProperties(), "2x5h", MinimizeNumberOfUsedGroupsOfTime.sGroups2of5h);
            } else {
                this.iProgress.message(this.msglevel("constraintNotUsed", 3), "Minimize number of used groups of time constraint not loaded due to the interactive mode of the solver.");
            }
        } else if ("NO_CONFLICT".equals(type.getReference())) {
            if (PreferenceLevel.sRequired.equals(pref.getPrefProlog())) {
                gc = new IgnoreStudentConflictsConstraint();
            }
        } else {
            GroupConstraint.ConstraintType gcType = GroupConstraint.ConstraintType.get((String)type.getReference());
            if (gcType == null) {
                this.iProgress.error("Distribution constraint " + type.getReference() + " is not implemented.");
                return null;
            }
            gc = new GroupConstraint(id, gcType, pref.getPrefProlog());
        }
        return gc;
    }

    private void errorAddGroupConstraintNotFound(DistributionPref pref, Class_ clazz) {
        if (pref.getOwner() != null && pref.getOwner() instanceof DepartmentalInstructor) {
            this.iProgress.message(this.msglevel("notLoadedInInstrPref", 3), "Lecture " + this.getClassLabel(clazz) + " not found/loaded, but used in distribution preference " + pref.getLabel());
        } else {
            this.iProgress.message(this.msglevel("notLoadedInDistPref", 5), "Lecture " + this.getClassLabel(clazz) + " not found/loaded, but used in distribution preference " + pref.getLabel());
        }
    }

    private Lecture getLecture(Class_ clazz) {
        Lecture lecture;
        block5: {
            lecture = this.iLectures.get(clazz.getUniqueId());
            if (lecture != null) {
                return lecture;
            }
            if (this.iAllClasses.contains(clazz)) {
                return null;
            }
            try {
                org.unitime.timetable.model.Assignment assignment = clazz.getCommittedAssignment();
                if (assignment != null) {
                    Placement placement = assignment.getPlacement();
                    lecture = (Lecture)placement.variable();
                    ((TimetableModel)this.getModel()).addVariable((Variable)lecture);
                    this.iLectures.put(clazz.getUniqueId(), lecture);
                }
            }
            catch (LazyInitializationException e) {
                org.unitime.timetable.model.Assignment assignment = (org.unitime.timetable.model.Assignment)new AssignmentDAO().get(clazz.getCommittedAssignment().getUniqueId());
                if (assignment == null) break block5;
                Placement placement = assignment.getPlacement();
                lecture = (Lecture)placement.variable();
                ((TimetableModel)this.getModel()).addVariable((Variable)lecture);
                this.iLectures.put(clazz.getUniqueId(), lecture);
            }
        }
        return lecture;
    }

    private void addGroupConstraint(Constraint<Lecture, Placement> gc) {
        if (gc.variables().isEmpty()) {
            return;
        }
        boolean allVariablesAreCommitted = true;
        for (Lecture lecture : gc.variables()) {
            if (lecture.isCommitted()) continue;
            allVariablesAreCommitted = false;
            break;
        }
        if (allVariablesAreCommitted) {
            this.iProgress.debug("Not created constraint " + gc.getName() + " between " + gc.variables() + " (all variables are committed)");
            for (Lecture lecture : new ArrayList(gc.variables())) {
                gc.removeVariable((Variable)lecture);
            }
            return;
        }
        ((TimetableModel)this.getModel()).addConstraint(gc);
        this.iProgress.trace("Added constraint " + gc.getName() + " between " + gc.variables());
    }

    /*
     * WARNING - void declaration
     */
    private void loadGroupConstraint(DistributionPref pref) {
        DistributionPref.Structure structure = pref.getStructure();
        if (structure == null) {
            structure = DistributionPref.Structure.AllClasses;
        }
        if (structure == DistributionPref.Structure.Progressive) {
            void var8_30;
            int maxSize = 0;
            for (DistributionObject distributionObject : pref.getOrderedSetOfDistributionObjects()) {
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    maxSize = Math.max(maxSize, 1);
                    continue;
                }
                if (!(distributionObject.getPrefGroup() instanceof SchedulingSubpart)) continue;
                maxSize = Math.max(maxSize, ((SchedulingSubpart)distributionObject.getPrefGroup()).getClasses().size());
            }
            Constraint[] gc = new Constraint[maxSize];
            Set[] gcClasses = new Set[maxSize];
            for (int i = 0; i < gc.length; ++i) {
                gc[i] = this.createGroupConstraint(pref);
                if (gc[i] == null) {
                    return;
                }
                gcClasses[i] = new HashSet();
            }
            ArrayList<Lecture> allLectureOfCorrectOrder = new ArrayList<Lecture>();
            for (DistributionObject distributionObject : pref.getOrderedSetOfDistributionObjects()) {
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    Class_ clazz = (Class_)distributionObject.getPrefGroup();
                    Lecture lecture = this.getLecture(clazz);
                    if (lecture == null) continue;
                    allLectureOfCorrectOrder.add(lecture);
                    continue;
                }
                if (!(distributionObject.getPrefGroup() instanceof SchedulingSubpart)) continue;
                SchedulingSubpart subpart = (SchedulingSubpart)distributionObject.getPrefGroup();
                ArrayList<Class_> classes = new ArrayList<Class_>(subpart.getClasses());
                Collections.sort(classes, new ClassComparator(5));
                for (Class_ clazz : classes) {
                    Lecture lecture = this.getLecture(clazz);
                    if (lecture == null) continue;
                    allLectureOfCorrectOrder.add(lecture);
                }
            }
            ArrayList<DistributionObject> distributionObjects = new ArrayList<DistributionObject>(pref.getDistributionObjects());
            Collections.sort(distributionObjects, new ChildrenFirstDistributionObjectComparator());
            for (DistributionObject distributionObject : distributionObjects) {
                int j;
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    Class_ clazz = (Class_)distributionObject.getPrefGroup();
                    Lecture lecture = this.getLecture(clazz);
                    if (lecture == null) {
                        this.errorAddGroupConstraintNotFound(pref, clazz);
                        continue;
                    }
                    for (j = 0; j < gc.length; ++j) {
                        gc[j].addVariable((Variable)lecture);
                        gcClasses[j].add(clazz);
                    }
                    continue;
                }
                if (distributionObject.getPrefGroup() instanceof SchedulingSubpart) {
                    SchedulingSubpart subpart = (SchedulingSubpart)distributionObject.getPrefGroup();
                    ArrayList<Class_> classes = new ArrayList<Class_>(subpart.getClasses());
                    Collections.sort(classes, new ClassComparator(5));
                    if (classes.isEmpty()) {
                        this.iProgress.message(this.msglevel("badDistributionObj", 5), "Distribution preference " + pref.getLabel() + " refers to a scheduling subpart " + this.getSubpartLabel(subpart) + " with no classes.");
                        continue;
                    }
                    for (j = 0; j < gc.length; ++j) {
                        Lecture lecture;
                        Class_ clazz = null;
                        Iterator k = gcClasses[j].iterator();
                        while (k.hasNext() && clazz == null) {
                            clazz = TimetableDatabaseLoader.getParentClass((Class_)k.next(), subpart);
                        }
                        if (clazz == null) {
                            ArrayList<Class_> adepts = new ArrayList<Class_>();
                            block14: for (Class_ adept : classes) {
                                for (Class_ other : gcClasses[j]) {
                                    if (!TimetableDatabaseLoader.shareParent(other.getSchedulingSubpart(), adept.getSchedulingSubpart()) || TimetableDatabaseLoader.shareParent(other, adept)) continue;
                                    continue block14;
                                }
                                adepts.add(adept);
                            }
                            if (!adepts.isEmpty() && adepts.size() < classes.size()) {
                                int k2 = 0;
                                block16: for (int i = 0; i < j; ++i) {
                                    block17: for (Class_ adept : adepts) {
                                        for (Class_ other : gcClasses[i]) {
                                            if (!TimetableDatabaseLoader.shareParent(other.getSchedulingSubpart(), adept.getSchedulingSubpart()) || TimetableDatabaseLoader.shareParent(other, adept)) continue;
                                            continue block17;
                                        }
                                        ++k2;
                                        continue block16;
                                    }
                                }
                                clazz = (Class_)adepts.get(k2 % adepts.size());
                            }
                        }
                        if (clazz == null) {
                            clazz = (Class_)classes.get(j % classes.size());
                        }
                        if ((lecture = this.getLecture(clazz)) == null) {
                            this.errorAddGroupConstraintNotFound(pref, clazz);
                            continue;
                        }
                        gc[j].addVariable((Variable)lecture);
                        gcClasses[j].add(clazz);
                    }
                    continue;
                }
                this.iProgress.message(this.msglevel("badDistributionObj", 5), "Distribution preference " + pref.getLabel() + " refers to unsupported object " + distributionObject.getPrefGroup());
            }
            boolean bl = false;
            while (var8_30 < gc.length) {
                ObjectsByGivenOrderComparator cmp = new ObjectsByGivenOrderComparator(allLectureOfCorrectOrder);
                if (!gc[var8_30].variables().isEmpty()) {
                    Collections.sort(gc[var8_30].variables(), cmp);
                    this.addGroupConstraint((Constraint<Lecture, Placement>)gc[var8_30]);
                }
                ++var8_30;
            }
        } else if (structure == DistributionPref.Structure.Pairwise) {
            ArrayList<Lecture> lectures = new ArrayList<Lecture>();
            for (DistributionObject distributionObject : pref.getOrderedSetOfDistributionObjects()) {
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    Class_ clazz = (Class_)distributionObject.getPrefGroup();
                    Lecture lecture = this.getLecture(clazz);
                    if (lecture == null) {
                        this.errorAddGroupConstraintNotFound(pref, clazz);
                        continue;
                    }
                    lectures.add(lecture);
                    continue;
                }
                if (distributionObject.getPrefGroup() instanceof SchedulingSubpart) {
                    SchedulingSubpart subpart = (SchedulingSubpart)distributionObject.getPrefGroup();
                    ArrayList<Class_> classes = new ArrayList<Class_>(subpart.getClasses());
                    Collections.sort(classes, new ClassComparator(5));
                    for (Class_ clazz : classes) {
                        Lecture lecture = this.getLecture(clazz);
                        if (lecture == null) {
                            this.errorAddGroupConstraintNotFound(pref, clazz);
                            continue;
                        }
                        lectures.add(lecture);
                    }
                    continue;
                }
                this.iProgress.message(this.msglevel("badDistributionObj", 5), "Distribution preference " + pref.getLabel() + " refers to unsupported object " + distributionObject.getPrefGroup());
            }
            if (lectures.size() < 2) {
                this.iProgress.message(this.msglevel("distrPrefIncomplete", 5), "Distribution preference " + pref.getLabel() + " refers to less than two classes");
            } else {
                for (int idx1 = 0; idx1 < lectures.size() - 1; ++idx1) {
                    Lecture l1 = (Lecture)lectures.get(idx1);
                    for (int idx2 = idx1 + 1; idx2 < lectures.size(); ++idx2) {
                        Lecture l2 = (Lecture)lectures.get(idx2);
                        Constraint constraint = this.createGroupConstraint(pref);
                        if (constraint == null) {
                            return;
                        }
                        constraint.addVariable((Variable)l1);
                        constraint.addVariable((Variable)l2);
                        this.addGroupConstraint((Constraint<Lecture, Placement>)constraint);
                    }
                }
            }
        } else if (structure == DistributionPref.Structure.OneOfEach) {
            ArrayList<Lecture> lectures = new ArrayList<Lecture>();
            ArrayList<Integer> counts = new ArrayList<Integer>();
            for (DistributionObject distributionObject : pref.getOrderedSetOfDistributionObjects()) {
                int count = 0;
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    Class_ class_ = (Class_)distributionObject.getPrefGroup();
                    Lecture lecture = this.getLecture(class_);
                    if (lecture == null) {
                        this.errorAddGroupConstraintNotFound(pref, class_);
                        continue;
                    }
                    lectures.add(lecture);
                    ++count;
                } else if (distributionObject.getPrefGroup() instanceof SchedulingSubpart) {
                    SchedulingSubpart schedulingSubpart = (SchedulingSubpart)distributionObject.getPrefGroup();
                    ArrayList<Class_> classes = new ArrayList<Class_>(schedulingSubpart.getClasses());
                    Collections.sort(classes, new ClassComparator(5));
                    for (Class_ clazz : classes) {
                        Lecture lecture = this.getLecture(clazz);
                        if (lecture == null) {
                            this.errorAddGroupConstraintNotFound(pref, clazz);
                            continue;
                        }
                        lectures.add(lecture);
                        ++count;
                    }
                } else {
                    this.iProgress.message(this.msglevel("badDistributionObj", 5), "Distribution preference " + pref.getLabel() + " refers to unsupported object " + distributionObject.getPrefGroup());
                }
                if (count <= 0) continue;
                counts.add(count);
            }
            if (counts.size() > 1) {
                Enumeration e = DistributionPref.permutations(lectures, counts);
                while (e.hasMoreElements()) {
                    Collection perm = e.nextElement();
                    Constraint gc = this.createGroupConstraint(pref);
                    if (gc == null) {
                        return;
                    }
                    for (Lecture lecture : perm) {
                        gc.addVariable((Variable)lecture);
                    }
                    this.addGroupConstraint((Constraint<Lecture, Placement>)gc);
                    this.iProgress.debug("Posted " + gc.getName() + " between " + gc.variables());
                }
            }
        } else {
            Integer grouping = null;
            switch (structure) {
                case GroupsOfTwo: {
                    grouping = 2;
                    break;
                }
                case GroupsOfThree: {
                    grouping = 3;
                    break;
                }
                case GroupsOfFour: {
                    grouping = 4;
                    break;
                }
                case GroupsOfFive: {
                    grouping = 5;
                }
            }
            Constraint gc = this.createGroupConstraint(pref);
            if (gc == null) {
                return;
            }
            for (DistributionObject distributionObject : pref.getOrderedSetOfDistributionObjects()) {
                if (distributionObject.getPrefGroup() instanceof Class_) {
                    Class_ clazz = (Class_)distributionObject.getPrefGroup();
                    Lecture lecture = this.getLecture(clazz);
                    if (lecture == null) {
                        this.errorAddGroupConstraintNotFound(pref, clazz);
                        continue;
                    }
                    gc.addVariable((Variable)lecture);
                    if (grouping == null || gc.variables().size() != grouping.intValue()) continue;
                    this.addGroupConstraint((Constraint<Lecture, Placement>)gc);
                    gc = this.createGroupConstraint(pref);
                    if (gc != null) continue;
                    return;
                }
                if (distributionObject.getPrefGroup() instanceof SchedulingSubpart) {
                    SchedulingSubpart subpart = (SchedulingSubpart)distributionObject.getPrefGroup();
                    ArrayList<Class_> arrayList = new ArrayList<Class_>(subpart.getClasses());
                    Collections.sort(arrayList, new ClassComparator(5));
                    for (Class_ clazz : arrayList) {
                        Lecture lecture = this.getLecture(clazz);
                        if (lecture == null) {
                            this.errorAddGroupConstraintNotFound(pref, clazz);
                            continue;
                        }
                        gc.addVariable((Variable)lecture);
                        if (grouping == null || gc.variables().size() != grouping.intValue()) continue;
                        this.addGroupConstraint((Constraint<Lecture, Placement>)gc);
                        gc = this.createGroupConstraint(pref);
                        if (gc != null) continue;
                        return;
                    }
                    continue;
                }
                this.iProgress.message(this.msglevel("badDistributionObj", 5), "Distribution preference " + pref.getLabel() + " refers to unsupported object " + distributionObject.getPrefGroup());
            }
            this.addGroupConstraint((Constraint<Lecture, Placement>)gc);
        }
    }

    private void loadInstructorGroupConstraint(DepartmentalInstructor instructor, DistributionPref pref) {
        Class_ clazz;
        Constraint gc = this.createGroupConstraint(pref);
        if (gc == null) {
            return;
        }
        boolean loadConstraint = false;
        for (ClassInstructor classInstructor : instructor.getClasses()) {
            clazz = classInstructor.getClassInstructing();
            if (!classInstructor.isLead().booleanValue() || !clazz.getManagingDept().isInheritInstructorPreferences().booleanValue()) continue;
            loadConstraint = true;
            break;
        }
        if (!loadConstraint) {
            return;
        }
        for (ClassInstructor classInstructor : instructor.getClasses()) {
            if (!classInstructor.isLead().booleanValue()) continue;
            clazz = classInstructor.getClassInstructing();
            Lecture lecture = this.getLecture(clazz);
            if (lecture == null) {
                this.errorAddGroupConstraintNotFound(pref, clazz);
                continue;
            }
            gc.addVariable((Variable)lecture);
        }
        this.addGroupConstraint((Constraint<Lecture, Placement>)gc);
    }

    private void loadInstructorGroupConstraints(DepartmentalInstructor instructor, Set<Long> checkedDistPrefIds) {
        Set prefs = instructor.getPreferences(DistributionPref.class);
        if (prefs == null || prefs.isEmpty()) {
            return;
        }
        for (DistributionPref pref : prefs) {
            if (!checkedDistPrefIds.add(pref.getUniqueId())) continue;
            this.loadInstructorGroupConstraint(instructor, pref);
        }
    }

    private void loadInstructorGroupConstraints(Department department, Set<Long> checkedDistPrefIds, org.hibernate.Session hibSession) {
        if (!department.isInheritInstructorPreferences().booleanValue()) {
            return;
        }
        List instructors = null;
        instructors = department.isExternalManager() != false ? hibSession.createQuery("select distinct i.instructor from Class_ as c inner join c.classInstructors i where i.lead = true and (c.managingDept=:deptId or (c.managingDept is null and c.controllingDept=:deptId))").setLong("deptId", department.getUniqueId().longValue()).list() : hibSession.createQuery("select distinct di from DepartmentalInstructor di inner join di.department d where d.uniqueId=:deptId").setLong("deptId", department.getUniqueId().longValue()).list();
        if (instructors == null || instructors.isEmpty()) {
            return;
        }
        this.iProgress.setPhase("Loading instructor distr. constraints for " + department.getShortLabel() + " ...", (long)instructors.size());
        for (DepartmentalInstructor instructor : instructors) {
            this.loadInstructorGroupConstraints(instructor, checkedDistPrefIds);
            this.iProgress.incProgress();
        }
    }

    private static Class_ getParentClass(Class_ clazz, SchedulingSubpart parentSubpart) {
        if (clazz == null) {
            return null;
        }
        if (parentSubpart.getClasses().contains(clazz)) {
            return clazz;
        }
        return TimetableDatabaseLoader.getParentClass(clazz.getParentClass(), parentSubpart);
    }

    private static boolean shareParent(Class_ c1, Class_ c2) {
        if (c1.getParentClass() == null) {
            return false;
        }
        for (Class_ p = c2.getParentClass(); p != null; p = p.getParentClass()) {
            if (!c1.getParentClass().equals(p)) continue;
            return true;
        }
        return TimetableDatabaseLoader.shareParent(c1.getParentClass(), c2);
    }

    private static boolean shareParent(SchedulingSubpart s1, SchedulingSubpart s2) {
        if (s1.getParentSubpart() == null) {
            return false;
        }
        for (SchedulingSubpart p = s2.getParentSubpart(); p != null; p = p.getParentSubpart()) {
            if (!s1.getParentSubpart().equals(p)) continue;
            return true;
        }
        return TimetableDatabaseLoader.shareParent(s1.getParentSubpart(), s2);
    }

    private String getClassLimitConstraitName(SchedulingSubpart subpart) {
        if (subpart == null) {
            return "class-limit";
        }
        String name = subpart.getCourseName() + " " + subpart.getItypeDesc().trim();
        String sufix = subpart.getSchedulingSubpartSuffix();
        if (sufix != null && sufix.length() > 0) {
            name = name + " (" + sufix + ")";
        }
        return name;
    }

    private String getClassLimitConstraitName(Lecture lecture) {
        SchedulingSubpart subpart = this.iSubparts.get(lecture.getSchedulingSubpartId());
        if (subpart == null) {
            subpart = (SchedulingSubpart)SchedulingSubpartDAO.getInstance().get(lecture.getSchedulingSubpartId());
        }
        return this.getClassLimitConstraitName(subpart);
    }

    private void createChildrenClassLimitConstraits(Lecture parentLecture) {
        if (!parentLecture.hasAnyChildren()) {
            return;
        }
        for (Long subpartId : parentLecture.getChildrenSubpartIds()) {
            List children = parentLecture.getChildren(subpartId);
            ClassLimitConstraint clc = new ClassLimitConstraint(parentLecture, this.getClassLimitConstraitName(parentLecture));
            boolean isMakingSense = false;
            for (Lecture lecture : children) {
                this.createChildrenClassLimitConstraits(lecture);
                if (lecture.isCommitted() || lecture.minClassLimit() == lecture.maxClassLimit()) continue;
                isMakingSense = true;
            }
            if (!isMakingSense) continue;
            for (Lecture lecture : children) {
                if (!lecture.isCommitted()) {
                    clc.addVariable((Variable)lecture);
                    continue;
                }
                clc.setClassLimitDelta(clc.getClassLimitDelta() - this.iClasses.get(lecture.getClassId()).getClassLimit());
            }
            if (clc.variables().isEmpty()) continue;
            SchedulingSubpart subpart = this.iSubparts.get(subpartId);
            if (subpart == null) {
                subpart = (SchedulingSubpart)SchedulingSubpartDAO.getInstance().get(subpartId);
            }
            for (Class_ clazz : subpart.getClasses()) {
                if (this.iLectures.get(clazz.getUniqueId()) != null) continue;
                clc.setClassLimitDelta(clc.getClassLimitDelta() - clazz.getClassLimit());
            }
            this.iProgress.trace("Added constraint " + clc.getName() + " between " + clc.variables());
            ((TimetableModel)this.getModel()).addConstraint((Constraint)clc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load() {
        org.hibernate.Session hibSession = null;
        Transaction tx = null;
        try {
            try {
                hibSession = TimetableManagerDAO.getInstance().getSession();
                hibSession.setCacheMode(CacheMode.IGNORE);
                hibSession.setFlushMode(FlushMode.COMMIT);
                tx = hibSession.beginTransaction();
                this.load(hibSession);
                tx.commit();
            }
            catch (Exception e) {
                this.iProgress.message(this.msglevel("loadFailed", 7), "Unable to load input data, reason:" + e.getMessage(), (Throwable)e);
                tx.rollback();
                Object var5_4 = null;
                if (hibSession == null) return;
                if (!hibSession.isOpen()) return;
                hibSession.close();
                return;
            }
            Object var5_3 = null;
            if (hibSession == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (hibSession == null) throw throwable;
            if (!hibSession.isOpen()) throw throwable;
            hibSession.close();
            throw throwable;
        }
        if (!hibSession.isOpen()) return;
        hibSession.close();
    }

    private boolean postSameStudentConstraint(Class_ clazz, String type) {
        boolean posted = false;
        if (!clazz.getChildClasses().isEmpty()) {
            for (Class_ c : clazz.getChildClasses()) {
                if (!this.postSameStudentConstraint(c, type)) continue;
                posted = true;
            }
        }
        if (posted) {
            return true;
        }
        Lecture lecture = this.getLecture(clazz);
        if (lecture == null) {
            return false;
        }
        ArrayList<Lecture> variables = new ArrayList<Lecture>();
        variables.add(lecture);
        Class_ parent = clazz;
        while ((parent = parent.getParentClass()) != null) {
            Lecture parentLecture = this.getLecture(parent);
            if (parentLecture == null) continue;
            variables.add(parentLecture);
        }
        for (SchedulingSubpart subpart : clazz.getSchedulingSubpart().getInstrOfferingConfig().getSchedulingSubparts()) {
            Class_ singleClazz;
            Lecture singleLecture;
            if (subpart.getParentSubpart() != null || subpart.getClasses().size() != 1 || (singleLecture = this.getLecture(singleClazz = subpart.getClasses().iterator().next())) == null || variables.contains(singleLecture)) continue;
            variables.add(singleLecture);
        }
        if (variables.size() == 1) {
            return false;
        }
        GroupConstraint gc = new GroupConstraint(null, GroupConstraint.ConstraintType.get((String)type), PreferenceLevel.sRequired);
        for (Lecture var : variables) {
            gc.addVariable(var);
        }
        this.addGroupConstraint((Constraint<Lecture, Placement>)gc);
        return true;
    }

    private boolean postPrecedenceConstraint(Class_ clazz, String preference) {
        boolean posted = false;
        if (!clazz.getChildClasses().isEmpty()) {
            for (Class_ c : clazz.getChildClasses()) {
                if (!this.postPrecedenceConstraint(c, preference)) continue;
                posted = true;
            }
        }
        if (posted) {
            return true;
        }
        Lecture lecture = this.getLecture(clazz);
        if (lecture == null) {
            return false;
        }
        ArrayList<Lecture> variables = new ArrayList<Lecture>();
        variables.add(lecture);
        HashSet<Integer> itypes = new HashSet<Integer>();
        itypes.add(clazz.getSchedulingSubpart().getItype().getItype());
        Class_ parent = clazz;
        while ((parent = parent.getParentClass()) != null) {
            Lecture parentLecture = this.getLecture(parent);
            if (parentLecture == null) continue;
            variables.add(0, parentLecture);
            itypes.add(parent.getSchedulingSubpart().getItype().getItype());
        }
        if (variables.size() <= 1 || itypes.size() <= 1) {
            return false;
        }
        GroupConstraint gc = new GroupConstraint(null, GroupConstraint.ConstraintType.PRECEDENCE, preference);
        String info = "";
        for (Lecture var : variables) {
            gc.addVariable(var);
            if (!info.isEmpty()) {
                info = info + ", ";
            }
            info = info + this.getClassLabel(var);
        }
        this.iProgress.info("Posted precedence constraint between " + info + " (" + PreferenceLevel.prolog2string(preference) + ")");
        this.addGroupConstraint((Constraint<Lecture, Placement>)gc);
        return true;
    }

    private void propagateCommittedAssignment(HashSet students, org.unitime.timetable.model.Assignment assignment) {
        Class_ clazz = assignment.getClazz();
        Lecture parentLecture = null;
        Class_ c = clazz;
        while ((parentLecture == null || parentLecture.isCommitted()) && c.getParentClass() != null) {
            c = c.getParentClass();
            parentLecture = this.iLectures.get(c.getUniqueId());
        }
        if (parentLecture != null && !parentLecture.isCommitted()) {
            for (Lecture lecture : parentLecture.sameSubpartLectures()) {
                if (lecture.equals((Object)parentLecture) || lecture.isCommitted()) continue;
                for (Student student : students) {
                    student.addCanNotEnroll(lecture);
                }
            }
        }
        if (!clazz.getSchedulingSubpart().getChildSubparts().isEmpty()) {
            for (SchedulingSubpart subpart : clazz.getSchedulingSubpart().getChildSubparts()) {
                for (Class_ child : subpart.getClasses()) {
                    if (clazz.equals(child.getParentClass())) continue;
                    this.propagateCommittedAssignment(students, clazz, child);
                }
            }
        }
    }

    private void propagateCommittedAssignment(HashSet students, Class_ parent, Class_ clazz) {
        Lecture lecture = this.iLectures.get(clazz.getUniqueId());
        if (lecture != null && !lecture.isCommitted()) {
            for (Student student : students) {
                student.addCanNotEnroll(lecture);
            }
        } else {
            for (Class_ child : clazz.getChildClasses()) {
                this.propagateCommittedAssignment(students, parent, child);
            }
        }
    }

    private void loadCommittedStudentConflicts(org.hibernate.Session hibSession, Set<Long> offeringsToAvoid) {
        org.unitime.timetable.model.Assignment assignment;
        List assignmentEnrollments = hibSession.createQuery("select distinct a, e.studentId, io.uniqueId from Solution s inner join s.assignments a inner join s.studentEnrollments e inner join a.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering io where s.commited=true and s.owner.session.uniqueId=:sessionId and s.owner not in (" + this.iSolverGroupIds + ") and " + "a.clazz=e.clazz").setLong("sessionId", this.iSessionId.longValue()).list();
        Hashtable<org.unitime.timetable.model.Assignment, HashSet<Student>> assignments = new Hashtable<org.unitime.timetable.model.Assignment, HashSet<Student>>();
        for (Object[] objectArray : assignmentEnrollments) {
            Student student;
            assignment = (org.unitime.timetable.model.Assignment)objectArray[0];
            Long studentId = (Long)objectArray[1];
            Long offeringId = (Long)objectArray[2];
            if (offeringsToAvoid.contains(offeringId) || (student = this.iStudents.get(studentId)) == null) continue;
            HashSet<Student> students = (HashSet<Student>)assignments.get(assignment);
            if (students == null) {
                students = new HashSet<Student>();
                assignments.put(assignment, students);
            }
            students.add(student);
        }
        for (Object[] objectArray : assignmentEnrollments) {
            assignment = (org.unitime.timetable.model.Assignment)objectArray[0];
            if (assignments.containsKey(assignment)) continue;
            hibSession.evict((Object)assignment);
        }
        this.iProgress.setPhase("Loading student conflicts with commited solutions ...", (long)assignments.size());
        for (Map.Entry entry : assignments.entrySet()) {
            assignment = (org.unitime.timetable.model.Assignment)entry.getKey();
            HashSet students = (HashSet)entry.getValue();
            Placement committedPlacement = assignment.getPlacement();
            for (Student student : students) {
                student.addCommitedPlacement(committedPlacement);
            }
            if (!this.iLectures.containsKey(assignment.getClassId())) {
                this.iLectures.put(assignment.getClassId(), (Lecture)committedPlacement.variable());
                ((TimetableModel)this.getModel()).addVariable(committedPlacement.variable());
            }
            this.propagateCommittedAssignment(students, assignment);
            this.iProgress.incProgress();
        }
    }

    private boolean somehowEnroll(Student student, CourseOffering course, float weight, Double priority) {
        if (course.getInstructionalOffering().isNotOffered().booleanValue()) {
            return false;
        }
        boolean hasSomethingCommitted = false;
        block0: for (InstrOfferingConfig config : course.getInstructionalOffering().getInstrOfferingConfigs()) {
            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                for (Class_ clazz : subpart.getClasses()) {
                    if (clazz.getCommittedAssignment() == null) continue;
                    hasSomethingCommitted = true;
                    break block0;
                }
            }
        }
        if (!hasSomethingCommitted) {
            return false;
        }
        if (!this.iOfferings.containsKey(course.getInstructionalOffering())) {
            this.iOfferings.put(course.getInstructionalOffering(), this.loadOffering(course.getInstructionalOffering(), true));
        }
        student.addOffering(course.getInstructionalOffering().getUniqueId(), (double)weight, priority);
        Set<Student> students = this.iCourse2students.get(course);
        if (students == null) {
            students = new HashSet<Student>();
            this.iCourse2students.put(course, students);
        }
        students.add(student);
        return true;
    }

    private void makeupCommittedStudentConflicts(Set<Long> offeringsToAvoid) {
        this.iProgress.setPhase("Creating student conflicts with commited solutions ...", (long)this.iStudents.size());
        for (Student student : this.iStudents.values()) {
            Set<StudentCourseDemands.WeightedCourseOffering> courses = this.iStudentCourseDemands.getCourses(student.getId());
            this.iProgress.incProgress();
            if (courses == null) continue;
            for (StudentCourseDemands.WeightedCourseOffering course : courses) {
                if (offeringsToAvoid.contains(course.getCourseOffering().getInstructionalOffering().getUniqueId()) || this.somehowEnroll(student, course.getCourseOffering(), course.getWeight(), this.iStudentCourseDemands.getEnrollmentPriority(student.getId(), course.getCourseOfferingId()))) continue;
                offeringsToAvoid.add(course.getCourseOffering().getInstructionalOffering().getUniqueId());
            }
        }
    }

    private void propagateReservedClasses(Class_ clazz, Set<Long> reservedClasses) {
        reservedClasses.add(clazz.getUniqueId());
        for (Class_ child : clazz.getChildClasses()) {
            this.propagateReservedClasses(child, reservedClasses);
        }
    }

    private boolean canAttend(Set<Lecture> cannotAttendLectures, Collection<Lecture> lectures) {
        for (Lecture lecture : lectures) {
            if (cannotAttendLectures.contains(lecture)) continue;
            boolean canAttend = true;
            if (lecture.hasAnyChildren()) {
                for (Long subpartId : lecture.getChildrenSubpartIds()) {
                    if (this.canAttend(cannotAttendLectures, lecture.getChildren(subpartId))) continue;
                    canAttend = false;
                    break;
                }
            }
            if (!canAttend) continue;
            return true;
        }
        return false;
    }

    private boolean canAttendConfigurations(Set<Lecture> cannotAttendLectures, List<Configuration> configurations) {
        for (Configuration cfg : configurations) {
            boolean canAttend = true;
            for (Long subpartId : cfg.getTopSubpartIds()) {
                if (this.canAttend(cannotAttendLectures, cfg.getTopLectures(subpartId))) continue;
                canAttend = false;
                break;
            }
            if (!canAttend) continue;
            return true;
        }
        return false;
    }

    private void checkReservation(CourseOffering course, Set<Lecture> cannotAttendLectures, List<Configuration> configurations) {
        if (this.canAttendConfigurations(cannotAttendLectures, configurations)) {
            return;
        }
        this.iProgress.message(this.msglevel("badCourseReservation", 5), "Inconsistent course reservations for course " + this.getOfferingLabel(course));
    }

    private Collection<InstrOfferingConfig> sortedConfigs(InstructionalOffering offering) {
        if (offering.getInstrOfferingConfigs().size() <= 1) {
            return offering.getInstrOfferingConfigs();
        }
        TreeSet<InstrOfferingConfig> configs = new TreeSet<InstrOfferingConfig>(new InstrOfferingConfigComparator(offering.getControllingCourseOffering().getSubjectArea().getUniqueId()));
        configs.addAll(offering.getInstrOfferingConfigs());
        return configs;
    }

    private Hashtable<InstrOfferingConfig, Set<SchedulingSubpart>> loadOffering(InstructionalOffering offering, boolean assignCommitted) {
        HashSet<Long> solverGroupIds = new HashSet<Long>();
        for (Long solverGroupId : this.iSolverGroupId) {
            solverGroupIds.add(solverGroupId);
        }
        Hashtable<InstrOfferingConfig, Set<SchedulingSubpart>> cfg2topSubparts = new Hashtable<InstrOfferingConfig, Set<SchedulingSubpart>>();
        ArrayList<Configuration> altCfgs = new ArrayList<Configuration>();
        this.iAltConfigurations.put(offering, altCfgs);
        for (InstrOfferingConfig config : this.sortedConfigs(offering)) {
            Configuration cfg = new Configuration(offering.getUniqueId(), config.getUniqueId(), config.getLimit().intValue());
            HashSet<SchedulingSubpart> topSubparts = new HashSet<SchedulingSubpart>();
            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                for (Class_ clazz : subpart.getClasses()) {
                    Lecture lecture = this.iLectures.get(clazz.getUniqueId());
                    if (lecture != null) continue;
                    if (clazz.getManagingDept().getSolverGroup() == null) {
                        this.iProgress.message(this.msglevel("noSolverGroup", 5), "Manager of class " + this.getClassLabel(clazz) + " has no solver group (" + clazz.getManagingDept().getManagingDeptAbbv() + ").");
                        continue;
                    }
                    if (solverGroupIds.contains(clazz.getManagingDept().getSolverGroup().getUniqueId()) || clazz.getCommittedAssignment() == null || this.iLectures.containsKey(clazz.getUniqueId())) continue;
                    Placement committedPlacement = clazz.getCommittedAssignment().getPlacement();
                    lecture = (Lecture)committedPlacement.variable();
                    this.iLectures.put(clazz.getUniqueId(), lecture);
                    this.iClasses.put(lecture.getClassId(), clazz);
                    this.iSubparts.put(subpart.getUniqueId(), subpart);
                    ((TimetableModel)this.getModel()).addVariable((Variable)lecture);
                    if (!assignCommitted) continue;
                    ((TimetableModel)this.getModel()).weaken(this.getAssignment(), (Value)committedPlacement);
                    Map conflictConstraints = ((TimetableModel)this.getModel()).conflictConstraints(this.getAssignment(), (Value)committedPlacement);
                    if (conflictConstraints.isEmpty()) {
                        this.getAssignment().assign(0L, (Value)committedPlacement);
                        continue;
                    }
                    String warn = "Unable to assign committed class " + this.getClassLabel(lecture) + " &larr; " + committedPlacement.getLongName(this.iUseAmPm);
                    warn = warn + "<br>&nbsp;&nbsp;Reason:";
                    for (Constraint c : conflictConstraints.keySet()) {
                        Set vals = (Set)conflictConstraints.get(c);
                        for (Placement v : vals) {
                            warn = warn + "<br>&nbsp;&nbsp;&nbsp;&nbsp;" + this.getClassLabel((Lecture)v.variable()) + " = " + v.getLongName(this.iUseAmPm);
                        }
                        warn = warn + "<br>&nbsp;&nbsp;&nbsp;&nbsp;    in constraint " + c;
                        this.iProgress.message(this.msglevel("cannotAssignCommitted", 5), warn);
                    }
                }
            }
            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                ArrayList<Lecture> sameSubpart = new ArrayList<Lecture>();
                for (Class_ clazz : subpart.getClasses()) {
                    Lecture lecture = this.iLectures.get(clazz.getUniqueId());
                    if (lecture == null) continue;
                    Class_ parentClazz = clazz.getParentClass();
                    if (parentClazz != null) {
                        Lecture parentLecture = null;
                        Class_ c = clazz;
                        while (parentLecture == null && c.getParentClass() != null) {
                            c = c.getParentClass();
                            parentLecture = this.iLectures.get(c.getUniqueId());
                        }
                        if (parentLecture != null) {
                            lecture.setParent(parentLecture);
                        }
                    }
                    sameSubpart.add(lecture);
                    lecture.setSameSubpartLectures(sameSubpart);
                    if (lecture.getParent() != null) continue;
                    lecture.setConfiguration(cfg);
                    topSubparts.add(subpart);
                }
            }
            if (cfg.getTopLectures().isEmpty()) continue;
            altCfgs.add(cfg);
            cfg.setAltConfigurations(altCfgs);
            cfg2topSubparts.put(config, topSubparts);
        }
        return cfg2topSubparts;
    }

    /*
     * WARNING - void declaration
     */
    private void load(org.hibernate.Session hibSession) throws Exception {
        Date[] startEnd;
        void var9_45;
        int i;
        this.iProgress.setStatus("Loading input data ...");
        TravelTime.populateTravelTimes(((TimetableModel)this.getModel()).getDistanceMetric(), this.iSessionId, hibSession);
        this.iSolverGroup = null;
        this.iSession = null;
        if (this.iSolverGroup == null) {
            this.iSolverGroup = new SolverGroup[this.iSolverGroupId.length];
            for (int i2 = 0; i2 < this.iSolverGroupId.length; ++i2) {
                this.iSolverGroup[i2] = (SolverGroup)SolverGroupDAO.getInstance().get(this.iSolverGroupId[i2], hibSession);
                if (this.iSolverGroup[i2] == null) {
                    this.iProgress.message(this.msglevel("loadFailed", 7), "Unable to load solver group " + this.iSolverGroupId[i2] + ".");
                    return;
                }
                this.iProgress.debug("solver group[" + (i2 + 1) + "]: " + this.iSolverGroup[i2].getName());
            }
        }
        if (this.iSolverGroup == null || this.iSolverGroup.length == 0) {
            this.iProgress.message(this.msglevel("loadFailed", 7), "No solver group loaded.");
            return;
        }
        this.iDepartmentIds = "";
        for (int j = 0; j < this.iSolverGroup.length; ++j) {
            for (Department d : this.iSolverGroup[j].getDepartments()) {
                if (this.iDepartmentIds.length() > 0) {
                    this.iDepartmentIds = this.iDepartmentIds + ",";
                }
                this.iDepartmentIds = this.iDepartmentIds + d.getUniqueId().toString();
            }
        }
        ((TimetableModel)this.getModel()).getProperties().setProperty("General.DepartmentIds", this.iDepartmentIds);
        Hashtable<Long, Solution> solutions = null;
        if (this.iSolutionId != null && this.iSolutionId.length > 0) {
            solutions = new Hashtable<Long, Solution>();
            String note = "";
            for (int i3 = 0; i3 < this.iSolutionId.length; ++i3) {
                Solution solution = (Solution)new SolutionDAO().get(this.iSolutionId[i3], hibSession);
                if (solution == null) {
                    this.iProgress.message(this.msglevel("loadFailed", 7), "Unable to load solution " + this.iSolutionId[i3] + ".");
                    return;
                }
                this.iProgress.debug("solution[" + (i3 + 1) + "] version: " + solution.getUniqueId() + " (created " + solution.getCreated() + ", solver group " + solution.getOwner().getName() + ")");
                if (solution.getNote() != null) {
                    if (note.length() > 0) {
                        note = note + "\n";
                    }
                    note = note + solution.getNote();
                }
                solutions.put(solution.getOwner().getUniqueId(), solution);
            }
            ((TimetableModel)this.getModel()).getProperties().setProperty("General.Note", note);
            String solutionIdStr = "";
            for (i = 0; i < this.iSolverGroupId.length; ++i) {
                Solution solution = (Solution)solutions.get(this.iSolverGroupId[i]);
                if (solution == null) continue;
                if (solutionIdStr.length() > 0) {
                    solutionIdStr = solutionIdStr + ",";
                }
                solutionIdStr = solutionIdStr + solution.getUniqueId().toString();
            }
            ((TimetableModel)this.getModel()).getProperties().setProperty("General.SolutionId", solutionIdStr);
        }
        if (this.iSession == null) {
            this.iSession = (Session)new SessionDAO().get(this.iSessionId, hibSession);
        }
        if (this.iSession == null) {
            this.iProgress.message(this.msglevel("loadFailed", 7), "No session loaded.");
            return;
        }
        this.iProgress.debug("session: " + this.iSession.getLabel());
        ((TimetableModel)this.getModel()).getProperties().setProperty("Data.Term", this.iSession.getAcademicYearTerm());
        ((TimetableModel)this.getModel()).getProperties().setProperty("Data.Initiative", this.iSession.getAcademicInitiative());
        ((TimetableModel)this.getModel()).setYear(this.iSession.getSessionStartYear());
        ((TimetableModel)this.getModel()).getProperties().setProperty("DatePattern.DayOfWeekOffset", String.valueOf(Constants.getDayOfWeek(DateUtils.getDate(1, this.iSession.getPatternStartMonth(), this.iSession.getSessionStartYear()))));
        if (this.iSession.getDefaultDatePattern() != null) {
            BitSet pattern = this.iSession.getDefaultDatePattern().getPatternBitSet();
            String patternStr = "";
            for (i = 0; i < pattern.length(); ++i) {
                patternStr = patternStr + (pattern.get(i) ? "1" : "0");
            }
            ((TimetableModel)this.getModel()).getProperties().setProperty("DatePattern.Default", patternStr);
        }
        this.iAllClasses = new TreeSet<Class_>(new ClassComparator(5));
        for (int i4 = 0; i4 < this.iSolverGroup.length; ++i4) {
            for (Department d : this.iSolverGroup[i4].getDepartments()) {
                this.iAllClasses.addAll(d.getClassesFetchWithStructure());
            }
        }
        if (this.iAllClasses == null || this.iAllClasses.isEmpty()) {
            this.iProgress.message(this.msglevel("noClasses", 7), "No classes to load.");
            return;
        }
        this.iProgress.debug("classes to load: " + this.iAllClasses.size());
        this.iProgress.setPhase("Loading classes ...", (long)this.iAllClasses.size());
        int ord = 0;
        HashSet<SchedulingSubpart> subparts = new HashSet<SchedulingSubpart>();
        for (Class_ class_ : this.iAllClasses) {
            Lecture lecture = this.loadClass(class_, hibSession);
            subparts.add(class_.getSchedulingSubpart());
            if (lecture != null) {
                lecture.setOrd(ord++);
            }
            this.iClasses.put(class_.getUniqueId(), class_);
            this.iProgress.incProgress();
        }
        this.loadInstructorAvailabilities(hibSession);
        this.loadRoomAvailabilities(hibSession);
        this.iProgress.setPhase("Loading offerings ...", (long)this.iAllClasses.size());
        HashSet<Long> loadedOfferings = new HashSet<Long>();
        for (Class_ clazz : this.iAllClasses) {
            InstructionalOffering instructionalOffering;
            Lecture lecture = this.iLectures.get(clazz.getUniqueId());
            this.iProgress.incProgress();
            if (lecture == null || !loadedOfferings.add((instructionalOffering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering()).getUniqueId())) continue;
            this.iOfferings.put(instructionalOffering, this.loadOffering(instructionalOffering, false));
        }
        ArrayList arrayList = new ArrayList();
        for (int i5 = 0; i5 < this.iSolverGroup.length; ++i5) {
            arrayList.addAll(this.iSolverGroup[i5].getDistributionPreferences());
        }
        this.iProgress.setPhase("Loading distribution preferences ...", (long)arrayList.size());
        for (DistributionPref distributionPref : arrayList) {
            if (!PreferenceLevel.sNeutral.equals(distributionPref.getPrefLevel().getPrefProlog())) {
                this.loadGroupConstraint(distributionPref);
            }
            this.iProgress.incProgress();
        }
        HashSet<Long> checkedDistPrefIds = new HashSet<Long>();
        for (int i6 = 0; i6 < this.iSolverGroup.length; ++i6) {
            Iterator<Department> iterator = this.iSolverGroup[i6].getDepartments().iterator();
            while (iterator.hasNext()) {
                this.loadInstructorGroupConstraints(iterator.next(), checkedDistPrefIds, hibSession);
            }
        }
        if (this.iAutoSameStudents) {
            this.iProgress.setPhase("Posting automatic same_students constraints ...", (long)this.iAllClasses.size());
            for (Class_ class_ : this.iAllClasses) {
                Lecture lecture = this.iLectures.get(class_.getUniqueId());
                if (lecture == null) continue;
                if (!lecture.hasAnyChildren()) {
                    this.postSameStudentConstraint(class_, this.iAutoSameStudentsConstraint);
                }
                this.iProgress.incProgress();
            }
        }
        if (this.iAutoPrecedence != null) {
            PreferenceLevel pref = PreferenceLevel.getPreferenceLevel(this.iAutoPrecedence);
            if (pref == null) {
                for (PreferenceLevel p : PreferenceLevel.getPreferenceLevelList()) {
                    if (!this.iAutoPrecedence.equalsIgnoreCase(p.getPrefProlog()) && !this.iAutoPrecedence.equalsIgnoreCase(p.getPrefName()) && !this.iAutoPrecedence.equals(p.getAbbreviation())) continue;
                    pref = p;
                    break;
                }
            }
            if (pref == null) {
                this.iProgress.message(this.msglevel("autoPrecedence", 5), "Preference " + this.iAutoPrecedence + " not recognized.");
            } else if (!PreferenceLevel.sNeutral.equals(pref.getPrefProlog())) {
                this.iProgress.setPhase("Posting automatic precedence constraints ...", (long)this.iAllClasses.size());
                for (Class_ clazz : this.iAllClasses) {
                    Lecture lecture = this.iLectures.get(clazz.getUniqueId());
                    if (lecture == null) continue;
                    if (!lecture.hasAnyChildren()) {
                        this.postPrecedenceConstraint(clazz, pref.getPrefProlog());
                    }
                    this.iProgress.incProgress();
                }
            }
        }
        this.postAutomaticHierarchicalConstraints(hibSession);
        this.assignCommited();
        this.iProgress.setPhase("Posting class limit constraints ...", (long)this.iOfferings.size());
        for (Map.Entry<InstructionalOffering, Hashtable<InstrOfferingConfig, Set<SchedulingSubpart>>> entry : this.iOfferings.entrySet()) {
            Hashtable<InstrOfferingConfig, Set<SchedulingSubpart>> topSubparts = entry.getValue();
            for (Map.Entry<InstrOfferingConfig, Set<SchedulingSubpart>> entry2 : topSubparts.entrySet()) {
                InstrOfferingConfig config = entry2.getKey();
                Set<SchedulingSubpart> set = entry2.getValue();
                for (SchedulingSubpart subpart : set) {
                    Lecture lecture;
                    boolean isMakingSense = false;
                    for (Class_ clazz : subpart.getClasses()) {
                        Lecture lecture2 = this.iLectures.get(clazz.getUniqueId());
                        if (lecture2 == null) continue;
                        this.createChildrenClassLimitConstraits(lecture2);
                        if (lecture2.isCommitted() || lecture2.minClassLimit() == lecture2.maxClassLimit()) continue;
                        isMakingSense = true;
                    }
                    if (!isMakingSense) continue;
                    if (subpart.getParentSubpart() == null) {
                        ClassLimitConstraint clc = new ClassLimitConstraint(config.getLimit().intValue(), this.getClassLimitConstraitName(subpart));
                        for (Class_ clazz : subpart.getClasses()) {
                            lecture = this.iLectures.get(clazz.getUniqueId());
                            if (lecture == null || lecture.isCommitted()) {
                                clc.setClassLimitDelta(clc.getClassLimitDelta() - clazz.getClassLimit());
                                continue;
                            }
                            clc.addVariable((Variable)lecture);
                        }
                        if (clc.variables().isEmpty()) continue;
                        this.iProgress.trace("Added constraint " + clc.getName() + " between " + clc.variables());
                        ((TimetableModel)this.getModel()).addConstraint((Constraint)clc);
                        continue;
                    }
                    Hashtable<Long, ClassLimitConstraint> clcs = new Hashtable<Long, ClassLimitConstraint>();
                    for (Class_ clazz : subpart.getClasses()) {
                        lecture = this.iLectures.get(clazz.getUniqueId());
                        Class_ parentClazz = clazz.getParentClass();
                        ClassLimitConstraint clc = (ClassLimitConstraint)clcs.get(parentClazz.getUniqueId());
                        if (clc == null) {
                            clc = new ClassLimitConstraint(parentClazz.getClassLimit(), parentClazz.getClassLabel());
                            clcs.put(parentClazz.getUniqueId(), clc);
                        }
                        if (lecture == null || lecture.isCommitted()) {
                            clc.setClassLimitDelta(clc.getClassLimitDelta() - clazz.getClassLimit());
                            continue;
                        }
                        clc.addVariable((Variable)lecture);
                    }
                    for (ClassLimitConstraint clc : clcs.values()) {
                        if (clc.variables().isEmpty()) continue;
                        this.iProgress.trace("Added constraint " + clc.getName() + " between " + clc.variables());
                        ((TimetableModel)this.getModel()).addConstraint((Constraint)clc);
                    }
                }
            }
            this.iProgress.incProgress();
        }
        this.iStudentCourseDemands.init(hibSession, this.iProgress, this.iSession, this.iOfferings.keySet());
        this.iProgress.setPhase("Loading students ...", (long)this.iOfferings.size());
        for (InstructionalOffering instructionalOffering : this.iOfferings.keySet()) {
            boolean unlimitedOffering = false;
            int n = 0;
            for (InstrOfferingConfig config : instructionalOffering.getInstrOfferingConfigs()) {
                if (config.isUnlimitedEnrollment().booleanValue()) {
                    unlimitedOffering = true;
                    continue;
                }
                n += config.getLimit().intValue();
            }
            Object var12_76 = null;
            if (!unlimitedOffering) {
                int totalCourseLimit = 0;
                for (CourseOffering courseOffering : instructionalOffering.getCourseOfferings()) {
                    int courseLimit = -1;
                    if (courseOffering.getReservation() != null) {
                        courseLimit = courseOffering.getReservation();
                    }
                    if (courseLimit < 0) {
                        if (instructionalOffering.getCourseOfferings().size() == 1) {
                            courseLimit = n;
                        } else {
                            this.iProgress.message(this.msglevel("crossListWithoutReservation", 3), "Cross-listed course " + this.getOfferingLabel(courseOffering) + " does not have any course reservation.");
                            courseLimit = courseOffering.getProjectedDemand() != null && instructionalOffering.getProjectedDemand() > 0 ? courseOffering.getProjectedDemand() : (courseOffering.getDemand() != null && instructionalOffering.getDemand() > 0 ? courseOffering.getDemand() : n / instructionalOffering.getCourseOfferings().size());
                        }
                    }
                    totalCourseLimit += courseLimit;
                }
                if (totalCourseLimit < n) {
                    this.iProgress.message(this.msglevel("courseReservationsBelowLimit", totalCourseLimit == 0 ? 3 : 5), "Total number of course reservations is below the offering limit for instructional offering " + this.getOfferingLabel(instructionalOffering) + " (" + totalCourseLimit + "<" + n + ").");
                }
                if (totalCourseLimit > n) {
                    this.iProgress.message(this.msglevel("courseReservationsOverLimit", 3), "Total number of course reservations exceeds the offering limit for instructional offering " + this.getOfferingLabel(instructionalOffering) + " (" + totalCourseLimit + ">" + n + ").");
                }
                if (totalCourseLimit == 0) continue;
                if (totalCourseLimit != n) {
                    Double d = new Double((double)n / (double)totalCourseLimit);
                }
            }
            for (CourseOffering courseOffering : instructionalOffering.getCourseOfferings()) {
                Object lecture;
                void var12_78;
                Set<StudentCourseDemands.WeightedStudentId> set = this.iStudentCourseDemands.getDemands(courseOffering);
                float studentWeight = 0.0f;
                if (set != null) {
                    for (StudentCourseDemands.WeightedStudentId studentId : set) {
                        studentWeight += studentId.getWeight();
                    }
                }
                int courseLimit = -1;
                if (courseOffering.getReservation() != null) {
                    courseLimit = courseOffering.getReservation();
                }
                if (courseLimit < 0) {
                    courseLimit = instructionalOffering.getCourseOfferings().size() == 1 && !unlimitedOffering ? n : Math.round(studentWeight);
                }
                if (var12_78 != null) {
                    courseLimit = (int)Math.round((double)courseLimit * var12_78.doubleValue());
                }
                if (set == null || set.isEmpty()) {
                    this.iProgress.message(this.msglevel("offeringWithoutDemand", 3), "No student enrollments for course " + this.getOfferingLabel(courseOffering) + ".");
                    continue;
                }
                if (courseLimit == 0 && instructionalOffering.getCourseOfferings().size() > 1) {
                    this.iProgress.message(this.msglevel("noCourseReservation", 5), "No reserved space for students of course " + this.getOfferingLabel(courseOffering) + ".");
                }
                double weight = this.iStudentCourseDemands.isWeightStudentsToFillUpOffering() && courseLimit != 0 ? (double)courseLimit / (double)studentWeight : 1.0;
                HashSet<Lecture> cannotAttendLectures = null;
                if (instructionalOffering.getCourseOfferings().size() > 1) {
                    HashSet reservedClasses = new HashSet();
                    int limit = 0;
                    boolean unlimited = false;
                    for (Reservation r : instructionalOffering.getReservations()) {
                        Object parent;
                        if (!(r instanceof CourseReservation) || !courseOffering.equals(((CourseReservation)r).getCourse())) continue;
                        for (Class_ class_ : r.getClasses()) {
                            limit += class_.getMaxExpectedCapacity().intValue();
                            this.propagateReservedClasses(class_, reservedClasses);
                            for (parent = class_.getParentClass(); parent != null; parent = ((BaseClass_)parent).getParentClass()) {
                                reservedClasses.add(((BasePreferenceGroup)parent).getUniqueId());
                            }
                        }
                        for (InstrOfferingConfig instrOfferingConfig : r.getConfigurations()) {
                            if (instrOfferingConfig.isUnlimitedEnrollment().booleanValue()) {
                                unlimited = true;
                            } else {
                                limit += instrOfferingConfig.getLimit().intValue();
                            }
                            parent = instrOfferingConfig.getSchedulingSubparts().iterator();
                            while (parent.hasNext()) {
                                SchedulingSubpart subpart = (SchedulingSubpart)parent.next();
                                for (Class_ clazz3 : subpart.getClasses()) {
                                    reservedClasses.add(clazz3.getUniqueId());
                                }
                            }
                        }
                    }
                    if (!reservedClasses.isEmpty()) {
                        this.iProgress.debug("Course requests for course " + this.getOfferingLabel(courseOffering) + " are " + reservedClasses);
                        if (!unlimited && courseLimit > limit) {
                            this.iProgress.message(this.msglevel("insufficientCourseReservation", 5), "Too little space reserved in for course " + this.getOfferingLabel(courseOffering) + " (" + limit + "<" + courseLimit + ").");
                        }
                        cannotAttendLectures = new HashSet<Lecture>();
                        for (InstrOfferingConfig config : courseOffering.getInstructionalOffering().getInstrOfferingConfigs()) {
                            boolean hasConfigReservation = false;
                            block36: for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                                for (Class_ class_ : subpart.getClasses()) {
                                    if (!reservedClasses.contains(class_.getUniqueId())) continue;
                                    hasConfigReservation = true;
                                    break block36;
                                }
                            }
                            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                                boolean hasSubpartReservation = false;
                                for (Class_ clazz : subpart.getClasses()) {
                                    if (!reservedClasses.contains(clazz.getUniqueId())) continue;
                                    hasSubpartReservation = true;
                                    break;
                                }
                                if (hasConfigReservation && !hasSubpartReservation) continue;
                                for (Class_ clazz : subpart.getClasses()) {
                                    if (reservedClasses.contains(clazz.getUniqueId()) || (lecture = this.iLectures.get(clazz.getUniqueId())) == null || lecture.isCommitted()) continue;
                                    cannotAttendLectures.add((Lecture)lecture);
                                }
                            }
                        }
                        if (!cannotAttendLectures.isEmpty()) {
                            this.iProgress.debug("Prohibited lectures for course " + this.getOfferingLabel(courseOffering) + " are " + cannotAttendLectures);
                            this.checkReservation(courseOffering, cannotAttendLectures, this.iAltConfigurations.get(instructionalOffering));
                        }
                    }
                }
                for (StudentCourseDemands.WeightedStudentId studentId : set) {
                    Student student = this.iStudents.get(studentId.getStudentId());
                    if (student == null) {
                        student = new Student(Long.valueOf(studentId.getStudentId()));
                        student.setAcademicArea(studentId.getArea());
                        student.setAcademicClassification(studentId.getClasf());
                        student.setMajor(studentId.getMajor());
                        student.setCurriculum(studentId.getCurriculum());
                        ((TimetableModel)this.getModel()).addStudent(student);
                        this.iStudents.put(studentId.getStudentId(), student);
                    }
                    student.addOffering(instructionalOffering.getUniqueId(), weight * (double)studentId.getWeight(), this.iStudentCourseDemands.getEnrollmentPriority(studentId.getStudentId(), courseOffering.getUniqueId()));
                    Set<Student> students = this.iCourse2students.get(courseOffering);
                    if (students == null) {
                        students = new HashSet<Student>();
                        this.iCourse2students.put(courseOffering, students);
                    }
                    students.add(student);
                    student.addCanNotEnroll(instructionalOffering.getUniqueId(), cannotAttendLectures);
                    HashSet<Long> reservedClasses = new HashSet<Long>();
                    for (Reservation reservation : instructionalOffering.getReservations()) {
                        boolean match;
                        if (reservation.getClasses().isEmpty() && reservation.getConfigurations().isEmpty() || reservation instanceof CourseReservation || !(reservation instanceof CurriculumReservation)) continue;
                        Iterator<InstrOfferingConfig> cr = (CurriculumReservation)reservation;
                        if (studentId.getArea() == null || !studentId.hasArea(((BaseCurriculumReservation)((Object)cr)).getArea().getAcademicAreaAbbreviation())) continue;
                        if (!((BaseCurriculumReservation)((Object)cr)).getClassifications().isEmpty()) {
                            match = false;
                            for (AcademicClassification clasf : ((BaseCurriculumReservation)((Object)cr)).getClassifications()) {
                                if (!studentId.hasClassification(((BaseCurriculumReservation)((Object)cr)).getArea().getAcademicAreaAbbreviation(), clasf.getCode())) continue;
                                match = true;
                                break;
                            }
                            if (!match) continue;
                        }
                        if (!((BaseCurriculumReservation)((Object)cr)).getMajors().isEmpty()) {
                            if (studentId.getMajor() == null) continue;
                            match = false;
                            for (PosMajor major : ((BaseCurriculumReservation)((Object)cr)).getMajors()) {
                                if (!studentId.hasMajor(((BaseCurriculumReservation)((Object)cr)).getArea().getAcademicAreaAbbreviation(), major.getCode())) continue;
                                match = true;
                                break;
                            }
                            if (!match) continue;
                        }
                        for (Class_ clazz5 : reservation.getClasses()) {
                            void var30_260;
                            this.propagateReservedClasses(clazz5, reservedClasses);
                            Class_ class_ = clazz5.getParentClass();
                            while (var30_260 != null) {
                                reservedClasses.add(var30_260.getUniqueId());
                                Class_ class_2 = var30_260.getParentClass();
                            }
                        }
                        for (InstrOfferingConfig config : reservation.getConfigurations()) {
                            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                                lecture = subpart.getClasses().iterator();
                                while (lecture.hasNext()) {
                                    Class_ clazz = (Class_)lecture.next();
                                    reservedClasses.add(clazz.getUniqueId());
                                }
                            }
                        }
                    }
                    if (reservedClasses.isEmpty()) continue;
                    this.iProgress.debug(courseOffering.getCourseName() + ": Student " + student.getId() + " has reserved classes " + reservedClasses);
                    HashSet<Lecture> prohibited = new HashSet<Lecture>();
                    for (InstrOfferingConfig config : courseOffering.getInstructionalOffering().getInstrOfferingConfigs()) {
                        boolean hasConfigReservation = false;
                        block51: for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                            for (Class_ clazz6 : subpart.getClasses()) {
                                if (!reservedClasses.contains(clazz6.getUniqueId())) continue;
                                hasConfigReservation = true;
                                break block51;
                            }
                        }
                        for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                            boolean hasSubpartReservation = false;
                            for (Class_ clazz7 : subpart.getClasses()) {
                                if (!reservedClasses.contains(clazz7.getUniqueId())) continue;
                                hasSubpartReservation = true;
                                break;
                            }
                            if (hasConfigReservation && !hasSubpartReservation) continue;
                            for (Class_ clazz : subpart.getClasses()) {
                                Lecture lecture3;
                                if (reservedClasses.contains(clazz.getUniqueId()) || (lecture3 = this.iLectures.get(clazz.getUniqueId())) == null || lecture3.isCommitted()) continue;
                                prohibited.add(lecture3);
                            }
                        }
                    }
                    this.iProgress.debug(courseOffering.getCourseName() + ": Student " + student.getId() + " cannot attend classes " + prohibited);
                    student.addCanNotEnroll(instructionalOffering.getUniqueId(), prohibited);
                }
            }
            this.iProgress.incProgress();
        }
        this.iProgress.debug(this.iStudents.size() + " students loaded.");
        if (!hibSession.isOpen()) {
            this.iProgress.message(this.msglevel("hibernateFailure", 7), "Hibernate session not open.");
        }
        if (this.iCommittedStudentConflictsMode == CommittedStudentConflictsMode.Load && !this.iStudentCourseDemands.isMakingUpStudents()) {
            this.loadCommittedStudentConflicts(hibSession, loadedOfferings);
        } else if (this.iCommittedStudentConflictsMode != CommittedStudentConflictsMode.Ignore) {
            this.makeupCommittedStudentConflicts(loadedOfferings);
        }
        if (!hibSession.isOpen()) {
            this.iProgress.message(this.msglevel("hibernateFailure", 7), "Hibernate session not open.");
        }
        Hashtable<Student, HashSet<Lecture>> iPreEnrollments = new Hashtable<Student, HashSet<Lecture>>();
        if (this.iLoadStudentEnrlsFromSolution) {
            if (this.iStudentCourseDemands.canUseStudentClassEnrollmentsAsSolution()) {
                List list = hibSession.createQuery("select distinct e.student.uniqueId, e.clazz.uniqueId from StudentClassEnrollment e, Class_ c where e.courseOffering.instructionalOffering = c.schedulingSubpart.instrOfferingConfig.instructionalOffering and c.managingDept.solverGroup.uniqueId in (" + this.iSolverGroupIds + ")").list();
                this.iProgress.setPhase("Loading current student enrolments  ...", (long)list.size());
                int totalEnrollments = 0;
                for (Object[] objectArray : list) {
                    Long studentId = (Long)objectArray[0];
                    Long l = (Long)objectArray[1];
                    Student student = this.iStudents.get(studentId);
                    if (student == null) continue;
                    Lecture lecture = this.iLectures.get(l);
                    if (lecture != null) {
                        HashSet<Lecture> preEnrollments = (HashSet<Lecture>)iPreEnrollments.get(student);
                        if (preEnrollments == null) {
                            preEnrollments = new HashSet<Lecture>();
                            iPreEnrollments.put(student, preEnrollments);
                        }
                        preEnrollments.add(lecture);
                        if (student.hasOffering(lecture.getConfiguration().getOfferingId()) && student.canEnroll(lecture)) {
                            student.addLecture(lecture);
                            lecture.addStudent(this.getAssignment(), student);
                            ++totalEnrollments;
                        }
                    }
                    this.iProgress.incProgress();
                }
                this.iProgress.message(this.msglevel("enrollmentsLoaded", 3), "Loaded " + totalEnrollments + " enrollments of " + iPreEnrollments.size() + " students.");
            } else {
                void var9_40;
                boolean bl = false;
                while (var9_40 < this.iSolverGroupId.length) {
                    void var11_61;
                    Solution solution = solutions == null ? null : (Solution)solutions.get(this.iSolverGroupId[var9_40]);
                    Object var11_58 = null;
                    if (solution != null) {
                        List list = hibSession.createQuery("select distinct e.studentId, e.clazz.uniqueId from StudentEnrollment e where e.solution.uniqueId=:solutionId").setLong("solutionId", solution.getUniqueId().longValue()).list();
                    } else {
                        List list = hibSession.createQuery("select distinct e.studentId, e.clazz.uniqueId from StudentEnrollment e where e.solution.owner.uniqueId=:sovlerGroupId and e.solution.commited = true").setLong("sovlerGroupId", this.iSolverGroupId[var9_40].longValue()).list();
                    }
                    this.iProgress.setPhase("Loading student enrolments [" + (int)(var9_40 + true) + "] ...", (long)var11_61.size());
                    for (Object[] o : var11_61) {
                        Long l = (Long)o[0];
                        Long l2 = (Long)o[1];
                        Student student = this.iStudents.get(l);
                        if (student == null) continue;
                        Lecture lecture = this.iLectures.get(l2);
                        if (lecture != null && lecture.getConfiguration() != null) {
                            HashSet<Lecture> preEnrollments = (HashSet<Lecture>)iPreEnrollments.get(student);
                            if (preEnrollments == null) {
                                preEnrollments = new HashSet<Lecture>();
                                iPreEnrollments.put(student, preEnrollments);
                            }
                            preEnrollments.add(lecture);
                            if (student.hasOffering(lecture.getConfiguration().getOfferingId()) && student.canEnroll(lecture)) {
                                student.addLecture(lecture);
                                lecture.addStudent(this.getAssignment(), student);
                            }
                        }
                        this.iProgress.incProgress();
                    }
                    ++var9_40;
                }
                if (((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("Global.LoadOtherCommittedStudentEnrls", true)) {
                    List list = hibSession.createQuery("select distinct e.studentId, e.clazz.uniqueId from StudentEnrollment e, Class_ c where e.solution.commited = true and e.solution.owner.uniqueId not in (" + this.iSolverGroupIds + ") and " + "e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering = c.schedulingSubpart.instrOfferingConfig.instructionalOffering and " + "c.managingDept.solverGroup.uniqueId in (" + this.iSolverGroupIds + ")").list();
                    this.iProgress.setPhase("Loading other committed student enrolments  ...", (long)list.size());
                    for (Object[] objectArray : list) {
                        Long l = (Long)objectArray[0];
                        Long clazzId = (Long)objectArray[1];
                        Student student = this.iStudents.get(l);
                        if (student == null) continue;
                        Lecture lecture = this.iLectures.get(clazzId);
                        if (lecture != null && lecture.getConfiguration() != null) {
                            HashSet<Lecture> preEnrollments = (HashSet<Lecture>)iPreEnrollments.get(student);
                            if (preEnrollments == null) {
                                preEnrollments = new HashSet<Lecture>();
                                iPreEnrollments.put(student, preEnrollments);
                            }
                            preEnrollments.add(lecture);
                            if (student.hasOffering(lecture.getConfiguration().getOfferingId()) && student.canEnroll(lecture)) {
                                student.addLecture(lecture);
                                lecture.addStudent(this.getAssignment(), student);
                            }
                        }
                        this.iProgress.incProgress();
                    }
                }
            }
        }
        if (!hibSession.isOpen()) {
            this.iProgress.message(this.msglevel("hibernateFailure", 7), "Hibernate session not open.");
        }
        Object var9_42 = null;
        if (SolverServerImplementation.getInstance() != null) {
            RoomAvailabilityInterface roomAvailabilityInterface = SolverServerImplementation.getInstance().getRoomAvailability();
        } else {
            RoomAvailabilityInterface roomAvailabilityInterface = RoomAvailability.getInstance();
        }
        if (var9_45 != null && (startEnd = this.initializeRoomAvailability((RoomAvailabilityInterface)var9_45)) != null) {
            this.loadRoomAvailability((RoomAvailabilityInterface)var9_45, startEnd);
            this.loadInstructorAvailability((RoomAvailabilityInterface)var9_45, startEnd);
        }
        if (!hibSession.isOpen()) {
            this.iProgress.message(this.msglevel("hibernateFailure", 7), "Hibernate session not open.");
        }
        this.iProgress.setPhase("Initial sectioning ...", (long)this.iOfferings.size());
        for (InstructionalOffering instructionalOffering : this.iOfferings.keySet()) {
            HashSet<Student> hashSet = new HashSet<Student>();
            for (CourseOffering courseOffering : instructionalOffering.getCourseOfferings()) {
                Set<Student> set = this.iCourse2students.get(courseOffering);
                if (set == null) continue;
                hashSet.addAll(set);
            }
            if (hashSet.isEmpty()) continue;
            ((TimetableModel)this.getModel()).getStudentSectioning().initialSectioning(this.getAssignment(), instructionalOffering.getUniqueId(), instructionalOffering.getCourseName(), hashSet, (Collection)this.iAltConfigurations.get(instructionalOffering));
            this.iProgress.incProgress();
        }
        Enumeration<Student> e = this.iStudents.elements();
        while (e.hasMoreElements()) {
            e.nextElement().clearDistanceCache();
        }
        if (!iPreEnrollments.isEmpty()) {
            this.iProgress.setPhase("Checking loaded enrollments ....", (long)iPreEnrollments.size());
            for (Map.Entry entry : iPreEnrollments.entrySet()) {
                this.iProgress.incProgress();
                Student student = (Student)entry.getKey();
                Set lectures = (Set)entry.getValue();
                for (Lecture lecture : lectures) {
                    if (lecture.students().contains(student)) continue;
                    this.iProgress.message(this.msglevel("studentNotEnrolled", 5), "Student " + student.getId() + " is supposed to be enrolled to " + this.getClassLabel(lecture));
                }
                for (Lecture lecture : student.getLectures()) {
                    if (lectures.contains(lecture)) continue;
                    Lecture instead = null;
                    if (lecture.sameStudentsLectures() != null) {
                        for (Lecture other : lecture.sameStudentsLectures()) {
                            if (!lectures.contains(other)) continue;
                            instead = other;
                        }
                    }
                    if (instead != null) {
                        this.iProgress.message(this.msglevel("studentEnrolled", 5), "Student " + student.getId() + " is NOT supposed to be enrolled to " + this.getClassLabel(lecture) + ", he/she should have " + this.getClassLabel(instead) + " instead.");
                        continue;
                    }
                    this.iProgress.message(this.msglevel("studentEnrolled", 3), "Student " + student.getId() + " is NOT supposed to be enrolled to " + this.getClassLabel(lecture) + ".");
                }
            }
        }
        if (!hibSession.isOpen()) {
            this.iProgress.message(this.msglevel("hibernateFailure", 7), "Hibernate session not open.");
        }
        if (this.iLoadStudentInstructorConflicts) {
            this.loadInstructorStudentConflicts(hibSession);
        }
        this.iProgress.setPhase("Computing jenrl ...", (long)this.iStudents.size());
        Hashtable jenrls = new Hashtable();
        for (Student student : this.iStudents.values()) {
            for (Lecture lecture : student.getLectures()) {
                for (Lecture l2 : student.getLectures()) {
                    JenrlConstraint jenrl;
                    if (lecture.getId() >= l2.getId()) continue;
                    Hashtable<Lecture, JenrlConstraint> x = (Hashtable<Lecture, JenrlConstraint>)jenrls.get(lecture);
                    if (x == null) {
                        x = new Hashtable<Lecture, JenrlConstraint>();
                        jenrls.put(lecture, x);
                    }
                    if ((jenrl = (JenrlConstraint)x.get(l2)) == null) {
                        jenrl = new JenrlConstraint();
                        ((TimetableModel)this.getModel()).addConstraint((Constraint)jenrl);
                        jenrl.addVariable((Variable)lecture);
                        jenrl.addVariable((Variable)l2);
                        x.put(l2, jenrl);
                    }
                    jenrl.incJenrl(this.getAssignment(), student);
                }
            }
            this.iProgress.incProgress();
        }
        if (!hibSession.isOpen()) {
            this.iProgress.message(this.msglevel("hibernateFailure", 7), "Hibernate session not open.");
        }
        if (!((TimetableModel)this.getModel()).getStudentSectioning().hasFinalSectioning()) {
            this.postAutomaticStudentConstraints(hibSession);
        }
        if (solutions != null) {
            void var11_67;
            boolean bl = false;
            while (var11_67 < this.iSolverGroupId.length) {
                Solution solution = (Solution)solutions.get(this.iSolverGroupId[var11_67]);
                if (solution != null) {
                    this.iProgress.setPhase("Creating initial assignment [" + (int)(var11_67 + true) + "] ...", (long)solution.getAssignments().size());
                    for (org.unitime.timetable.model.Assignment assignment : solution.getAssignments()) {
                        this.loadAssignment(assignment);
                        this.iProgress.incProgress();
                    }
                }
                ++var11_67;
            }
        } else if (this.iLoadCommittedAssignments) {
            this.iProgress.setPhase("Creating initial assignment ...", (long)((TimetableModel)this.getModel()).variables().size());
            for (Lecture lecture : ((TimetableModel)this.getModel()).variables()) {
                if (lecture.isCommitted()) continue;
                Class_ clazz = this.iClasses.get(lecture.getClassId());
                if (clazz != null && clazz.getCommittedAssignment() != null) {
                    this.loadAssignment(clazz.getCommittedAssignment());
                }
                this.iProgress.incProgress();
            }
        }
        if (!hibSession.isOpen()) {
            this.iProgress.message(this.msglevel("hibernateFailure", 7), "Hibernate session not open.");
        }
        if (this.iSpread) {
            this.iProgress.setPhase("Posting automatic spread constraints ...", (long)subparts.size());
            for (SchedulingSubpart schedulingSubpart : subparts) {
                if (schedulingSubpart.getClasses().size() <= 1) {
                    this.iProgress.incProgress();
                    continue;
                }
                if (!schedulingSubpart.isAutoSpreadInTime().booleanValue()) {
                    this.iProgress.debug("Automatic spread constraint disabled for " + this.getSubpartLabel(schedulingSubpart));
                    this.iProgress.incProgress();
                    continue;
                }
                SpreadConstraint spread = new SpreadConstraint(((TimetableModel)this.getModel()).getProperties(), schedulingSubpart.getCourseName() + " " + schedulingSubpart.getItypeDesc().trim());
                for (Class_ class_ : schedulingSubpart.getClasses()) {
                    Lecture lecture = this.getLecture(class_);
                    if (lecture == null) continue;
                    spread.addVariable(lecture);
                }
                if (spread.variables().isEmpty()) {
                    this.iProgress.message(this.msglevel("courseWithNoClasses", 5), "No class for course " + this.getSubpartLabel(schedulingSubpart));
                } else {
                    ((TimetableModel)this.getModel()).addConstraint((Constraint)spread);
                }
                this.iProgress.incProgress();
            }
        }
        if (this.iDeptBalancing) {
            this.iProgress.setPhase("Creating dept. spread constraints ...", (long)((TimetableModel)this.getModel()).variables().size());
            Hashtable<Long, DepartmentSpreadConstraint> hashtable = new Hashtable<Long, DepartmentSpreadConstraint>();
            for (Lecture lecture : ((TimetableModel)this.getModel()).variables()) {
                void var14_146;
                if (lecture.getDepartment() == null) continue;
                DepartmentSpreadConstraint departmentSpreadConstraint = (DepartmentSpreadConstraint)hashtable.get(lecture.getDepartment());
                if (departmentSpreadConstraint == null) {
                    DepartmentSpreadConstraint departmentSpreadConstraint2 = new DepartmentSpreadConstraint(((TimetableModel)this.getModel()).getProperties(), lecture.getDepartment(), this.iDeptNames.get(lecture.getDepartment()));
                    hashtable.put(lecture.getDepartment(), departmentSpreadConstraint2);
                    ((TimetableModel)this.getModel()).addConstraint((Constraint)departmentSpreadConstraint2);
                }
                var14_146.addVariable(lecture);
                this.iProgress.incProgress();
            }
        }
        if (this.iSubjectBalancing) {
            this.iProgress.setPhase("Creating subject spread constraints ...", (long)((TimetableModel)this.getModel()).variables().size());
            Hashtable<Long, SpreadConstraint> hashtable = new Hashtable<Long, SpreadConstraint>();
            for (Lecture lecture : ((TimetableModel)this.getModel()).variables()) {
                Class_ class_ = this.iClasses.get(lecture.getClassId());
                if (class_ == null) continue;
                for (CourseOffering co : class_.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings()) {
                    Long subject = co.getSubjectArea().getUniqueId();
                    SpreadConstraint subjectSpreadConstr = (SpreadConstraint)hashtable.get(subject);
                    if (subjectSpreadConstr == null) {
                        subjectSpreadConstr = new SpreadConstraint(((TimetableModel)this.getModel()).getProperties(), co.getSubjectArea().getSubjectAreaAbbreviation());
                        hashtable.put(subject, subjectSpreadConstr);
                        ((TimetableModel)this.getModel()).addConstraint((Constraint)subjectSpreadConstr);
                    }
                    subjectSpreadConstr.addVariable(lecture);
                }
                this.iProgress.incProgress();
            }
        }
        if (((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.PurgeInvalidPlacements", true)) {
            this.purgeInvalidValues();
        }
        this.iProgress.setPhase("Checking for inconsistencies...", (long)((TimetableModel)this.getModel()).variables().size());
        for (Lecture lecture : ((TimetableModel)this.getModel()).variables()) {
            Placement p2;
            this.iProgress.incProgress();
            for (Student student : lecture.students()) {
                if (student.canEnroll(lecture)) continue;
                this.iProgress.message(this.msglevel("badStudentEnrollment", 3), "Invalid student enrollment of student " + student.getId() + " in class " + this.getClassLabel(lecture) + " found.");
            }
            if (!lecture.values(this.getAssignment()).isEmpty() && lecture.timeLocations().size() == 1 && !lecture.getInstructorConstraints().isEmpty()) {
                for (Lecture lecture2 : ((TimetableModel)this.getModel()).variables()) {
                    if (lecture2.values(this.getAssignment()).isEmpty() || lecture2.timeLocations().size() != 1 || lecture.getClassId().compareTo(lecture2.getClassId()) <= 0) continue;
                    Placement placement = (Placement)lecture.values(this.getAssignment()).get(0);
                    p2 = (Placement)lecture2.values(this.getAssignment()).get(0);
                    if (lecture2.getInstructorConstraints().isEmpty()) continue;
                    for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                        if (!lecture2.getInstructorConstraints().contains(ic) || placement.canShareRooms(p2) && placement.sameRooms(p2)) continue;
                        if (placement.getTimeLocation().hasIntersection(p2.getTimeLocation())) {
                            this.iProgress.message(this.msglevel("reqInstructorOverlap", 5), "Same instructor and overlapping time required:<br>&nbsp;&nbsp;&nbsp;&nbsp;" + this.getClassLabel(lecture) + " &larr; " + placement.getLongName(this.iUseAmPm) + "<br>&nbsp;&nbsp;&nbsp;&nbsp;" + this.getClassLabel(lecture2) + " &larr; " + p2.getLongName(this.iUseAmPm));
                            continue;
                        }
                        if (ic.getDistancePreference(placement, p2) != PreferenceLevel.sIntLevelProhibited || lecture.roomLocations().size() != 1 || lecture2.roomLocations().size() != 1) continue;
                        this.iProgress.message(this.msglevel("reqInstructorBackToBack", 5), "Same instructor, back-to-back time and rooms too far (distance=" + Math.round(10.0 * Placement.getDistanceInMeters((DistanceMetric)((TimetableModel)this.getModel()).getDistanceMetric(), (Placement)placement, (Placement)p2)) + "m) required:" + "<br>&nbsp;&nbsp;&nbsp;&nbsp;" + this.getClassLabel(lecture) + " &larr; " + placement.getLongName(this.iUseAmPm) + "<br>&nbsp;&nbsp;&nbsp;&nbsp;" + this.getClassLabel(lecture2) + " &larr; " + p2.getLongName(this.iUseAmPm));
                    }
                }
            }
            if (!lecture.isSingleton()) continue;
            for (Lecture lecture3 : ((TimetableModel)this.getModel()).variables()) {
                Placement placement;
                if (!lecture3.isSingleton() || lecture.getClassId().compareTo(lecture3.getClassId()) <= 0 || !(placement = new Placement(lecture, (TimeLocation)lecture.timeLocations().get(0), lecture.roomLocations())).shareRooms(p2 = new Placement(lecture3, (TimeLocation)lecture3.timeLocations().get(0), lecture3.roomLocations())) || !placement.getTimeLocation().hasIntersection(p2.getTimeLocation()) || placement.canShareRooms(p2)) continue;
                this.iProgress.message(this.msglevel("reqRoomOverlap", 5), "Same room and overlapping time required:<br>&nbsp;&nbsp;&nbsp;&nbsp;" + this.getClassLabel(lecture) + " &larr; " + placement.getLongName(this.iUseAmPm) + "<br>&nbsp;&nbsp;&nbsp;&nbsp;" + this.getClassLabel(lecture3) + " &larr; " + p2.getLongName(this.iUseAmPm));
            }
            if (this.getAssignment().getValue((Variable)lecture) != null) continue;
            Placement placement = new Placement(lecture, (TimeLocation)lecture.timeLocations().get(0), lecture.roomLocations());
            if (!placement.isValid()) {
                void var14_160;
                Map map;
                void var14_154;
                String string = "";
                for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                    if (ic.isAvailable(lecture, placement)) continue;
                    String string2 = (String)var14_154 + "<br>&nbsp;&nbsp;&nbsp;&nbsp;instructor " + ic.getName() + " not available";
                }
                if (lecture.getNrRooms() > 0) {
                    if (placement.isMultiRoom()) {
                        for (RoomLocation roomLocation : placement.getRoomLocations()) {
                            void var14_156;
                            if (roomLocation.getRoomConstraint().isAvailable(lecture, placement.getTimeLocation(), lecture.getScheduler())) continue;
                            String string3 = (String)var14_156 + "<br>&nbsp;&nbsp;&nbsp;&nbsp;room " + roomLocation.getName() + " not available";
                        }
                    } else if (!placement.getRoomLocation().getRoomConstraint().isAvailable(lecture, placement.getTimeLocation(), lecture.getScheduler())) {
                        String string4 = (String)var14_154 + "<br>&nbsp;&nbsp;&nbsp;&nbsp;room " + placement.getRoomLocation().getName() + " not available";
                    }
                }
                if (!(map = ((TimetableModel)this.getModel()).conflictConstraints(this.getAssignment(), (Value)placement)).isEmpty()) {
                    for (Constraint c : map.keySet()) {
                        Set vals = (Set)map.get(c);
                        for (Placement p : vals) {
                            Lecture l = (Lecture)p.variable();
                            if (l.isCommitted()) {
                                String string5 = (String)var14_160 + "<br>&nbsp;&nbsp;&nbsp;&nbsp;conflict with committed assignment " + this.getClassLabel(l) + " = " + p.getLongName(this.iUseAmPm) + " (in constraint " + c + ")";
                            }
                            if (!p.equals((Object)placement)) continue;
                            String string6 = (String)var14_160 + "<br>&nbsp;&nbsp;&nbsp;&nbsp;constraint " + c;
                        }
                    }
                }
                this.iProgress.message(this.msglevel("reqInvalidPlacement", 5), "Class " + this.getClassLabel(lecture) + " requires an invalid placement " + placement.getLongName(this.iUseAmPm) + (var14_160.length() == 0 ? "." : ":" + (String)var14_160));
                continue;
            }
            if (!this.iAssignSingleton || !((TimetableModel)this.getModel()).conflictValues(this.getAssignment(), (Value)placement).isEmpty()) continue;
            this.getAssignment().assign(0L, (Value)placement);
        }
        ((TimetableModel)this.getModel()).createAssignmentContexts(this.getAssignment(), true);
        if (((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.EnrollmentCheck", true)) {
            new EnrollmentCheck((TimetableModel)this.getModel(), (Assignment<Lecture, Placement>)this.getAssignment(), this.msglevel("enrollmentCheck", 5)).checkStudentEnrollments(this.iProgress);
        }
        if (((TimetableModel)this.getModel()).getProperties().getPropertyBoolean("General.SwitchStudents", true) && this.getAssignment().nrAssignedVariables() != 0 && !this.iLoadStudentEnrlsFromSolution) {
            ((TimetableModel)this.getModel()).switchStudents(this.getAssignment());
        }
        this.iProgress.setPhase("Done", 1L);
        this.iProgress.incProgress();
        this.iProgress.message(this.msglevel("allDone", 3), "Model successfully loaded.");
    }

    public void roomAvailabilityActivate(RoomAvailabilityInterface availability, Date startTime, Date endTime) {
        try {
            availability.activate((Session)new SessionDAO().get(this.iSessionId), startTime, endTime, RoomAvailabilityInterface.sClassType, ApplicationProperty.RoomAvailabilitySolverWaitForSync.isTrue());
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            this.iProgress.message(this.msglevel("roomAvailabilityFailure", 5), "Unable to access room availability service, reason:" + e.getMessage());
        }
    }

    public Date[] initializeRoomAvailability(RoomAvailabilityInterface availability) {
        Date startDate = null;
        Date endDate = null;
        for (DatePattern dp : this.iAllUsedDatePatterns) {
            if (startDate == null || startDate.compareTo(dp.getStartDate()) > 0) {
                startDate = dp.getStartDate();
            }
            if (endDate != null && endDate.compareTo(dp.getEndDate()) >= 0) continue;
            endDate = dp.getEndDate();
        }
        if (startDate == null || endDate == null) {
            this.iProgress.message(this.msglevel("roomAvailabilityFailure", 5), "Unable to load room availability, reason: no dates");
            return null;
        }
        Calendar startDateCal = Calendar.getInstance(Locale.US);
        startDateCal.setTime(startDate);
        startDateCal.set(11, 0);
        startDateCal.set(12, 0);
        startDateCal.set(13, 0);
        Calendar endDateCal = Calendar.getInstance(Locale.US);
        endDateCal.setTime(endDate);
        endDateCal.set(11, 23);
        endDateCal.set(12, 59);
        endDateCal.set(13, 59);
        this.roomAvailabilityActivate(availability, startDateCal.getTime(), endDateCal.getTime());
        return new Date[]{startDateCal.getTime(), endDateCal.getTime()};
    }

    public void loadRoomAvailability(RoomAvailabilityInterface availability, Date[] startEnd) {
        this.iProgress.setPhase("Loading room availability...", (long)this.iRooms.size());
        int firstDOY = this.iSession.getDayOfYear(1, this.iSession.getPatternStartMonth());
        int lastDOY = this.iSession.getDayOfYear(0, this.iSession.getPatternEndMonth() + 1);
        int size = lastDOY - firstDOY;
        Calendar c = Calendar.getInstance(Locale.US);
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_PATTERN);
        int sessionYear = this.iSession.getSessionStartYear();
        Enumeration<RoomConstraint> e = this.iRooms.elements();
        while (e.hasMoreElements()) {
            Collection<RoomAvailabilityInterface.TimeBlock> times;
            RoomConstraint room = e.nextElement();
            this.iProgress.incProgress();
            if (!room.getConstraint() || (times = this.getRoomAvailability(availability, room, startEnd[0], startEnd[1])) == null) continue;
            for (RoomAvailabilityInterface.TimeBlock time : times) {
                int length;
                this.iProgress.debug(room.getName() + " not available due to " + time);
                int dayCode = 0;
                c.setTime(time.getStartTime());
                int m = c.get(2);
                int d = c.get(5);
                if (c.get(1) < sessionYear) {
                    m -= 12 * (sessionYear - c.get(1));
                }
                if (c.get(1) > sessionYear) {
                    m += 12 * (c.get(1) - sessionYear);
                }
                BitSet weekCode = new BitSet(size);
                int offset = this.iSession.getDayOfYear(d, m) - firstDOY;
                if (offset < 0 || offset >= size) continue;
                weekCode.set(offset);
                switch (c.get(7)) {
                    case 2: {
                        dayCode = Constants.DAY_CODES[0];
                        break;
                    }
                    case 3: {
                        dayCode = Constants.DAY_CODES[1];
                        break;
                    }
                    case 4: {
                        dayCode = Constants.DAY_CODES[2];
                        break;
                    }
                    case 5: {
                        dayCode = Constants.DAY_CODES[3];
                        break;
                    }
                    case 6: {
                        dayCode = Constants.DAY_CODES[4];
                        break;
                    }
                    case 7: {
                        dayCode = Constants.DAY_CODES[5];
                        break;
                    }
                    case 1: {
                        dayCode = Constants.DAY_CODES[6];
                    }
                }
                int startSlot = (c.get(11) * 60 + c.get(12) - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
                c.setTime(time.getEndTime());
                int endSlot = (c.get(11) * 60 + c.get(12) - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
                if (endSlot == 0 && c.get(5) != d) {
                    endSlot = 288;
                }
                if ((length = endSlot - startSlot) <= 0) continue;
                TimeLocation timeLocation = new TimeLocation(dayCode, startSlot, length, 0, 0.0, null, df.format(time.getStartTime()), weekCode, 0);
                ArrayList<TimeLocation> timeLocations = new ArrayList<TimeLocation>(1);
                timeLocations.add(timeLocation);
                RoomLocation roomLocation = new RoomLocation(room.getResourceId(), room.getName(), room.getBuildingId(), 0, room.getCapacity(), room.getPosX(), room.getPosY(), room.getIgnoreTooFar(), room);
                ArrayList<RoomLocation> roomLocations = new ArrayList<RoomLocation>(1);
                roomLocations.add(roomLocation);
                Lecture lecture = new Lecture(new Long(--this.iFakeLectureId), null, null, time.getEventName(), timeLocations, roomLocations, 1, new Placement(null, timeLocation, roomLocations), 0, 0, 1.0);
                lecture.setNote(time.getEventType());
                Placement p = (Placement)lecture.getInitialAssignment();
                lecture.setBestAssignment((Value)p, 0L);
                lecture.setCommitted(true);
                room.setNotAvailable(p);
                ((TimetableModel)this.getModel()).addVariable(p.variable());
            }
        }
    }

    public Collection<RoomAvailabilityInterface.TimeBlock> getRoomAvailability(RoomAvailabilityInterface availability, RoomConstraint room, Date startTime, Date endTime) {
        Collection<RoomAvailabilityInterface.TimeBlock> ret = null;
        String ts = null;
        try {
            ret = availability.getRoomAvailability(room.getResourceId(), startTime, endTime, RoomAvailabilityInterface.sClassType);
            if (!this.iRoomAvailabilityTimeStampIsSet) {
                ts = availability.getTimeStamp(startTime, endTime, RoomAvailabilityInterface.sClassType);
            }
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            this.iProgress.message(this.msglevel("roomAvailabilityFailure", 5), "Unable to access room availability service, reason:" + e.getMessage());
        }
        if (!this.iRoomAvailabilityTimeStampIsSet) {
            this.iRoomAvailabilityTimeStampIsSet = true;
            if (ts != null) {
                ((TimetableModel)this.getModel()).getProperties().setProperty("RoomAvailability.TimeStamp", ts);
                this.iProgress.message(this.msglevel("roomAvailabilityUpdated", 3), "Using room availability that was updated on " + ts + ".");
            } else {
                this.iProgress.message(this.msglevel("roomAvailabilityFailure", 6), "Room availability is not available.");
            }
        }
        return ret;
    }

    public void loadInstructorAvailability(RoomAvailabilityInterface availability, Date[] startEnd) {
        this.iProgress.setPhase("Loading instructor availability...", (long)((TimetableModel)this.getModel()).getInstructorConstraints().size());
        int firstDOY = this.iSession.getDayOfYear(1, this.iSession.getPatternStartMonth());
        int lastDOY = this.iSession.getDayOfYear(0, this.iSession.getPatternEndMonth() + 1);
        int size = lastDOY - firstDOY;
        Calendar c = Calendar.getInstance(Locale.US);
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_PATTERN);
        int sessionYear = this.iSession.getSessionStartYear();
        for (InstructorConstraint instructor : ((TimetableModel)this.getModel()).getInstructorConstraints()) {
            this.iProgress.incProgress();
            Collection<RoomAvailabilityInterface.TimeBlock> times = this.getInstructorAvailability(availability, instructor, startEnd[0], startEnd[1]);
            if (times == null) continue;
            for (RoomAvailabilityInterface.TimeBlock time : times) {
                int length;
                this.iProgress.debug(instructor.getName() + " not available due to " + time);
                int dayCode = 0;
                c.setTime(time.getStartTime());
                int m = c.get(2);
                int d = c.get(5);
                if (c.get(1) < sessionYear) {
                    m -= 12 * (sessionYear - c.get(1));
                }
                if (c.get(1) > sessionYear) {
                    m += 12 * (c.get(1) - sessionYear);
                }
                BitSet weekCode = new BitSet(size);
                int offset = this.iSession.getDayOfYear(d, m) - firstDOY;
                if (offset < 0 || offset >= size) continue;
                weekCode.set(offset);
                switch (c.get(7)) {
                    case 2: {
                        dayCode = Constants.DAY_CODES[0];
                        break;
                    }
                    case 3: {
                        dayCode = Constants.DAY_CODES[1];
                        break;
                    }
                    case 4: {
                        dayCode = Constants.DAY_CODES[2];
                        break;
                    }
                    case 5: {
                        dayCode = Constants.DAY_CODES[3];
                        break;
                    }
                    case 6: {
                        dayCode = Constants.DAY_CODES[4];
                        break;
                    }
                    case 7: {
                        dayCode = Constants.DAY_CODES[5];
                        break;
                    }
                    case 1: {
                        dayCode = Constants.DAY_CODES[6];
                    }
                }
                int startSlot = (c.get(11) * 60 + c.get(12) - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
                c.setTime(time.getEndTime());
                int endSlot = (c.get(11) * 60 + c.get(12) - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
                if (endSlot == 0 && c.get(5) != d) {
                    endSlot = 288;
                }
                if ((length = endSlot - startSlot) <= 0) continue;
                TimeLocation timeLocation = new TimeLocation(dayCode, startSlot, length, 0, 0.0, null, df.format(time.getStartTime()), weekCode, 0);
                ArrayList<TimeLocation> timeLocations = new ArrayList<TimeLocation>(1);
                timeLocations.add(timeLocation);
                Lecture lecture = new Lecture(new Long(--this.iFakeLectureId), null, null, time.getEventName(), timeLocations, new ArrayList(), 0, new Placement(null, timeLocation, (RoomLocation)null), 0, 0, 1.0);
                lecture.setNote(time.getEventType());
                Placement p = (Placement)lecture.getInitialAssignment();
                lecture.setBestAssignment((Value)p, 0L);
                lecture.setCommitted(true);
                instructor.setNotAvailable(p);
                ((TimetableModel)this.getModel()).addVariable(p.variable());
            }
        }
    }

    public Collection<RoomAvailabilityInterface.TimeBlock> getInstructorAvailability(RoomAvailabilityInterface availability, InstructorConstraint instructor, Date startTime, Date endTime) {
        Collection<RoomAvailabilityInterface.TimeBlock> ret = null;
        String ts = null;
        try {
            ret = availability.getInstructorAvailability(instructor.getResourceId(), startTime, endTime, RoomAvailabilityInterface.sClassType);
            if (!this.iRoomAvailabilityTimeStampIsSet) {
                ts = availability.getTimeStamp(startTime, endTime, RoomAvailabilityInterface.sClassType);
            }
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            this.iProgress.message(this.msglevel("roomAvailabilityFailure", 5), "Unable to access room availability service, reason:" + e.getMessage());
        }
        if (!this.iRoomAvailabilityTimeStampIsSet) {
            this.iRoomAvailabilityTimeStampIsSet = true;
            if (ts != null) {
                ((TimetableModel)this.getModel()).getProperties().setProperty("RoomAvailability.TimeStamp", ts);
                this.iProgress.message(this.msglevel("roomAvailabilityUpdated", 3), "Using room availability that was updated on " + ts + ".");
            } else {
                this.iProgress.message(this.msglevel("roomAvailabilityFailure", 6), "Room availability is not available.");
            }
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    protected void postAutomaticHierarchicalConstraints(org.hibernate.Session hibSession) {
        String constraints = ((TimetableModel)this.getModel()).getProperties().getProperty("General.AutomaticHierarchicalConstraints");
        if (constraints == null || constraints.isEmpty()) {
            return;
        }
        List types = hibSession.createQuery("from DistributionType where examPref = false").list();
        List patterns = hibSession.createQuery("from DatePattern where session.uniqueId = :sessionId").setLong("sessionId", this.iSessionId.longValue()).list();
        for (String term : constraints.split("[,;][ ]?(?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
            void var12_19;
            String constraint = term.trim().toLowerCase();
            if (constraint.isEmpty()) continue;
            PreferenceLevel pref = null;
            for (PreferenceLevel preferenceLevel : PreferenceLevel.getPreferenceLevelList()) {
                if (constraint.startsWith(preferenceLevel.getPrefName().toLowerCase() + " ") || constraint.startsWith(preferenceLevel.getPrefName().toLowerCase() + ":")) {
                    pref = preferenceLevel;
                    constraint = constraint.substring(preferenceLevel.getPrefName().length() + 1).trim();
                    break;
                }
                if (constraint.startsWith(preferenceLevel.getPrefProlog().toLowerCase() + " ") || constraint.startsWith(preferenceLevel.getPrefProlog().toLowerCase() + ":")) {
                    pref = preferenceLevel;
                    constraint = constraint.substring(preferenceLevel.getPrefProlog().length() + 1).trim();
                    break;
                }
                if (preferenceLevel.getPrefAbbv() != null && (constraint.startsWith(preferenceLevel.getPrefAbbv().toLowerCase() + " ") || constraint.startsWith(preferenceLevel.getPrefAbbv().toLowerCase() + ":"))) {
                    pref = preferenceLevel;
                    constraint = constraint.substring(preferenceLevel.getPrefAbbv().length() + 1).trim();
                    break;
                }
                if (PreferenceLevel.sRequired.equals(preferenceLevel.getPrefProlog()) && (constraint.startsWith("required ") || constraint.startsWith("required:"))) {
                    pref = preferenceLevel;
                    constraint = constraint.substring("required ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sStronglyPreferred.equals(preferenceLevel.getPrefProlog()) && (constraint.startsWith("strongly preferred ") || constraint.startsWith("strongly preferred:"))) {
                    pref = preferenceLevel;
                    constraint = constraint.substring("strongly preferred ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sPreferred.equals(preferenceLevel.getPrefProlog()) && (constraint.startsWith("preferred ") || constraint.startsWith("preferred:"))) {
                    pref = preferenceLevel;
                    constraint = constraint.substring("preferred ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sNeutral.equals(preferenceLevel.getPrefProlog()) && (constraint.startsWith("neutral ") || constraint.startsWith("neutral:"))) {
                    pref = preferenceLevel;
                    constraint = constraint.substring("neutral ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sDiscouraged.equals(preferenceLevel.getPrefProlog()) && (constraint.startsWith("discouraged ") || constraint.startsWith("discouraged:"))) {
                    pref = preferenceLevel;
                    constraint = constraint.substring("discouraged ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sStronglyDiscouraged.equals(preferenceLevel.getPrefProlog()) && (constraint.startsWith("strongly discouraged ") || constraint.startsWith("strongly discouraged:"))) {
                    pref = preferenceLevel;
                    constraint = constraint.substring("strongly discouraged ".length()).trim();
                    break;
                }
                if (!PreferenceLevel.sProhibited.equals(preferenceLevel.getPrefProlog()) || !constraint.startsWith("prohibited ") && !constraint.startsWith("prohibited:")) continue;
                pref = preferenceLevel;
                constraint = constraint.substring("prohibited ".length()).trim();
                break;
            }
            if (pref == null) {
                this.iProgress.message(this.msglevel("automaticHierarchicalConstraints", 5), "Failed to parse automatic hierarchical constraint preference " + term);
                continue;
            }
            Object type = null;
            for (Object t : types) {
                if (constraint.equalsIgnoreCase(((BaseRefTableEntry)t).getReference()) || constraint.equalsIgnoreCase(((BaseDistributionType)t).getAbbreviation()) || constraint.equalsIgnoreCase(((BaseRefTableEntry)t).getLabel())) {
                    type = t;
                    constraint = "";
                    break;
                }
                if (constraint.startsWith(((BaseRefTableEntry)t).getReference().toLowerCase() + " ") || constraint.startsWith(((BaseRefTableEntry)t).getReference().toLowerCase() + ":")) {
                    type = t;
                    constraint = constraint.substring(((BaseRefTableEntry)t).getReference().length() + 1).trim();
                    break;
                }
                if (constraint.startsWith(((BaseDistributionType)t).getAbbreviation().toLowerCase() + " ") || constraint.startsWith(((BaseDistributionType)t).getAbbreviation().toLowerCase() + ":")) {
                    type = t;
                    constraint = constraint.substring(((BaseDistributionType)t).getAbbreviation().length() + 1).trim();
                    break;
                }
                if (!constraint.startsWith(((BaseRefTableEntry)t).getLabel().toLowerCase() + " ") && !constraint.startsWith(((BaseRefTableEntry)t).getLabel().toLowerCase() + ":")) continue;
                type = t;
                constraint = constraint.substring(((BaseRefTableEntry)t).getLabel().length() + 1).trim();
                break;
            }
            if (type == null) {
                for (GroupConstraint.ConstraintType t : GroupConstraint.ConstraintType.values()) {
                    if (constraint.equalsIgnoreCase(t.reference()) || constraint.equalsIgnoreCase(t.getName())) {
                        type = new DistributionType();
                        ((BaseRefTableEntry)type).setReference(t.reference());
                        ((BaseRefTableEntry)type).setLabel(t.getName());
                        ((BaseDistributionType)type).setAbbreviation(t.getName());
                        constraint = "";
                        break;
                    }
                    if (constraint.startsWith(t.reference().toLowerCase() + " ") || constraint.startsWith(t.reference().toLowerCase() + ":")) {
                        type = new DistributionType();
                        ((BaseRefTableEntry)type).setReference(t.reference());
                        ((BaseRefTableEntry)type).setLabel(t.getName());
                        ((BaseDistributionType)type).setAbbreviation(t.getName());
                        constraint = constraint.substring(t.reference().length() + 1).trim();
                        break;
                    }
                    if (!constraint.startsWith(t.getName().toLowerCase() + " ") && !constraint.startsWith(t.getName().toLowerCase() + ":")) continue;
                    type = new DistributionType();
                    ((BaseRefTableEntry)type).setReference(t.reference());
                    ((BaseRefTableEntry)type).setLabel(t.getName());
                    ((BaseDistributionType)type).setAbbreviation(t.getName());
                    constraint = constraint.substring(t.getName().length() + 1).trim();
                    break;
                }
            }
            if (type == null) {
                this.iProgress.message(this.msglevel("automaticHierarchicalConstraints", 5), "Failed to parse automatic hierarchical constraint preference " + term);
                continue;
            }
            Object var12_17 = null;
            if (!constraint.isEmpty()) {
                Object t;
                t = patterns.iterator();
                while (t.hasNext()) {
                    DatePattern p3 = (DatePattern)t.next();
                    if (!constraint.equalsIgnoreCase(p3.getName()) && !constraint.equalsIgnoreCase("\"" + p3.getName() + "\"")) continue;
                    DatePattern datePattern = p3;
                    break;
                }
                if (var12_19 == null) {
                    this.iProgress.message(this.msglevel("automaticHierarchicalConstraints", 5), "Failed to parse automatic hierarchical constraint preference: unknown date pattern " + constraint);
                    continue;
                }
            }
            this.iProgress.setPhase("Posting automatic " + pref.getPrefName() + " " + ((BaseRefTableEntry)type).getLabel() + " constraints" + (var12_19 == null ? "" : " between classes of pattern " + var12_19.getName()) + "...", (long)this.iAllClasses.size());
            for (Class_ clazz : this.iAllClasses) {
                Lecture lecture = this.iLectures.get(clazz.getUniqueId());
                if (lecture == null) continue;
                if (!lecture.hasAnyChildren()) {
                    this.postAutomaticHierarchicalConstraint(clazz, (DistributionType)type, pref, (DatePattern)var12_19);
                }
                this.iProgress.incProgress();
            }
        }
    }

    protected boolean postAutomaticHierarchicalConstraint(Class_ clazz, DistributionType type, PreferenceLevel preference, DatePattern pattern) {
        boolean posted = false;
        if (!clazz.getChildClasses().isEmpty()) {
            for (Class_ c : clazz.getChildClasses()) {
                if (!this.postAutomaticHierarchicalConstraint(c, type, preference, pattern)) continue;
                posted = true;
            }
        }
        if (posted) {
            return true;
        }
        if (this.getLecture(clazz) == null) {
            return false;
        }
        if (pattern != null && !pattern.equals(clazz.effectiveDatePattern())) {
            return false;
        }
        ArrayList<Lecture> variables = new ArrayList<Lecture>();
        for (Class_ parent = clazz; parent != null; parent = parent.getParentClass()) {
            Lecture lecture;
            if (pattern != null && !pattern.equals(parent.effectiveDatePattern()) || (lecture = this.getLecture(parent)) == null) continue;
            variables.add(0, lecture);
        }
        if (variables.size() <= 1) {
            return false;
        }
        Constraint gc = this.createGroupConstraint(clazz.getUniqueId(), type, preference, clazz);
        if (gc == null) {
            return false;
        }
        String info = "";
        for (Lecture var : variables) {
            gc.addVariable((Variable)var);
            if (!info.isEmpty()) {
                info = info + ", ";
            }
            info = info + this.getClassLabel(var);
        }
        this.iProgress.info("Posted " + type.getLabel() + " constraint between " + info + " (" + preference.getPrefName() + ")");
        this.addGroupConstraint((Constraint<Lecture, Placement>)gc);
        return true;
    }

    protected void postAutomaticStudentConstraints(org.hibernate.Session hibSession) {
        String constraints = ((TimetableModel)this.getModel()).getProperties().getProperty("General.AutomaticStudentConstraints");
        if (constraints == null || constraints.isEmpty()) {
            return;
        }
        HashMap<String, Integer> classes2counts = new HashMap<String, Integer>();
        HashMap<String, Student> firstStudent = new HashMap<String, Student>();
        for (Student student : ((TimetableModel)this.getModel()).getAllStudents()) {
            Object lecture22;
            TreeSet<Long> idSet = new TreeSet<Long>();
            for (Object lecture22 : student.getLectures()) {
                idSet.add(lecture22.getClassId());
            }
            String ids = "";
            lecture22 = idSet.iterator();
            while (lecture22.hasNext()) {
                Long id = (Long)lecture22.next();
                ids = ids + (ids.isEmpty() ? "" : ",") + id;
            }
            Integer count = (Integer)classes2counts.get(ids);
            classes2counts.put(ids, 1 + (count == null ? 0 : count));
            if (count != null) continue;
            firstStudent.put(ids, student);
        }
        int limit = ((TimetableModel)this.getModel()).getProperties().getPropertyInt("General.AutomaticStudentConstraints.StudentLimit", 5);
        List types = hibSession.createQuery("from DistributionType where examPref = false").list();
        for (String term : constraints.split("[,;][ ]?(?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
            String constraint = term.trim().toLowerCase();
            if (constraint.isEmpty()) continue;
            PreferenceLevel pref = null;
            for (PreferenceLevel p : PreferenceLevel.getPreferenceLevelList()) {
                if (constraint.startsWith(p.getPrefName().toLowerCase() + " ") || constraint.startsWith(p.getPrefName().toLowerCase() + ":")) {
                    pref = p;
                    constraint = constraint.substring(p.getPrefName().length() + 1).trim();
                    break;
                }
                if (constraint.startsWith(p.getPrefProlog().toLowerCase() + " ") || constraint.startsWith(p.getPrefProlog().toLowerCase() + ":")) {
                    pref = p;
                    constraint = constraint.substring(p.getPrefProlog().length() + 1).trim();
                    break;
                }
                if (p.getPrefAbbv() != null && constraint.startsWith(p.getPrefAbbv().toLowerCase() + " ") || constraint.startsWith(p.getPrefAbbv().toLowerCase() + ":")) {
                    pref = p;
                    constraint = constraint.substring(p.getPrefAbbv().length() + 1).trim();
                    break;
                }
                if (PreferenceLevel.sRequired.equals(p.getPrefProlog()) && (constraint.startsWith("required ") || constraint.startsWith("required:"))) {
                    pref = p;
                    constraint = constraint.substring("required ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sStronglyPreferred.equals(p.getPrefProlog()) && (constraint.startsWith("strongly preferred ") || constraint.startsWith("strongly preferred:"))) {
                    pref = p;
                    constraint = constraint.substring("strongly preferred ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sPreferred.equals(p.getPrefProlog()) && (constraint.startsWith("preferred ") || constraint.startsWith("preferred:"))) {
                    pref = p;
                    constraint = constraint.substring("preferred ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sNeutral.equals(p.getPrefProlog()) && (constraint.startsWith("neutral ") || constraint.startsWith("neutral:"))) {
                    pref = p;
                    constraint = constraint.substring("neutral ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sDiscouraged.equals(p.getPrefProlog()) && (constraint.startsWith("discouraged ") || constraint.startsWith("discouraged:"))) {
                    pref = p;
                    constraint = constraint.substring("discouraged ".length()).trim();
                    break;
                }
                if (PreferenceLevel.sStronglyDiscouraged.equals(p.getPrefProlog()) && (constraint.startsWith("strongly discouraged ") || constraint.startsWith("strongly discouraged:"))) {
                    pref = p;
                    constraint = constraint.substring("strongly discouraged ".length()).trim();
                    break;
                }
                if (!PreferenceLevel.sProhibited.equals(p.getPrefProlog()) || !constraint.startsWith("prohibited ") && !constraint.startsWith("prohibited:")) continue;
                pref = p;
                constraint = constraint.substring("prohibited ".length()).trim();
                break;
            }
            if (pref == null) {
                this.iProgress.message(this.msglevel("automaticStudentConstraints", 5), "Failed to parse automatic hierarchical constraint preference " + term);
                continue;
            }
            DistributionType type = null;
            for (DistributionType distributionType : types) {
                if (constraint.equalsIgnoreCase(distributionType.getReference()) || constraint.equalsIgnoreCase(distributionType.getAbbreviation()) || constraint.equalsIgnoreCase(distributionType.getLabel())) {
                    type = distributionType;
                    constraint = "";
                    break;
                }
                if (constraint.startsWith(distributionType.getReference().toLowerCase() + " ") || constraint.startsWith(distributionType.getReference().toLowerCase() + ":")) {
                    type = distributionType;
                    constraint = constraint.substring(distributionType.getReference().length() + 1).trim();
                    break;
                }
                if (constraint.startsWith(distributionType.getAbbreviation().toLowerCase() + " ") || constraint.startsWith(distributionType.getAbbreviation().toLowerCase() + ":")) {
                    type = distributionType;
                    constraint = constraint.substring(distributionType.getAbbreviation().length() + 1).trim();
                    break;
                }
                if (!constraint.startsWith(distributionType.getLabel().toLowerCase() + " ") && !constraint.startsWith(distributionType.getLabel().toLowerCase() + ":")) continue;
                type = distributionType;
                constraint = constraint.substring(distributionType.getLabel().length() + 1).trim();
                break;
            }
            if (type == null) {
                for (GroupConstraint.ConstraintType constraintType : GroupConstraint.ConstraintType.values()) {
                    if (!constraint.equalsIgnoreCase(constraintType.reference()) && !constraint.equalsIgnoreCase(constraintType.getName())) continue;
                    type = new DistributionType();
                    type.setReference(constraintType.reference());
                    type.setLabel(constraintType.getName());
                    type.setAbbreviation(constraintType.getName());
                }
            }
            if (type == null) {
                this.iProgress.message(this.msglevel("automaticStudentConstraints", 5), "Failed to parse automatic hierarchical constraint preference " + term);
                continue;
            }
            this.iProgress.setPhase("Posting automatic " + pref.getPrefName() + " " + type.getLabel() + " constraints for students...", (long)classes2counts.size());
            for (Map.Entry entry : classes2counts.entrySet()) {
                Constraint gc;
                this.iProgress.incProgress();
                if ((Integer)entry.getValue() < limit) continue;
                ArrayList<Lecture> variables = new ArrayList<Lecture>();
                for (String id : ((String)entry.getKey()).split(",")) {
                    Lecture lecture = this.iLectures.get(Long.valueOf(id));
                    if (lecture == null) continue;
                    variables.add(lecture);
                }
                Student student = (Student)firstStudent.get(entry.getKey());
                if (variables.size() <= 1 || (gc = this.createGroupConstraint(student.getId(), type, pref, student)) == null) continue;
                String info = "";
                for (Lecture var : variables) {
                    gc.addVariable((Variable)var);
                    if (!info.isEmpty()) {
                        info = info + ", ";
                    }
                    info = info + this.getClassLabel(var);
                }
                this.iProgress.info("Posted " + type.getLabel() + " constraint between " + info + " (" + pref.getPrefName() + ")");
                this.addGroupConstraint((Constraint<Lecture, Placement>)gc);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectsByGivenOrderComparator
    implements Comparator {
        List<?> iOrderedSet = null;

        public ObjectsByGivenOrderComparator(List<?> orderedSetOfLectures) {
            this.iOrderedSet = orderedSetOfLectures;
        }

        public int compare(Object o1, Object o2) {
            int idx2;
            int idx1 = this.iOrderedSet.indexOf(o1);
            int cmp = Double.compare(idx1, idx2 = this.iOrderedSet.indexOf(o2));
            if (cmp != 0) {
                return cmp;
            }
            return ((Comparable)o1).compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChildrenFirstDistributionObjectComparator
    implements Comparator<DistributionObject> {
        @Override
        public int compare(DistributionObject d1, DistributionObject d2) {
            if (d1.getPrefGroup() instanceof Class_) {
                if (d2.getPrefGroup() instanceof Class_) {
                    return d1.compareTo(d2);
                }
                return 1;
            }
            if (d2.getPrefGroup() instanceof Class_) {
                return -1;
            }
            if (!(d1.getPrefGroup() instanceof SchedulingSubpart) || !(d2.getPrefGroup() instanceof SchedulingSubpart)) {
                return d1.compareTo(d2);
            }
            SchedulingSubpart s1 = (SchedulingSubpart)d1.getPrefGroup();
            SchedulingSubpart s2 = (SchedulingSubpart)d2.getPrefGroup();
            if (s1.getClasses().size() <= 1) {
                if (s2.getClasses().size() <= 1) {
                    return d1.compareTo(d2);
                }
                return 1;
            }
            if (s2.getClasses().size() <= 1) {
                return -1;
            }
            if (TimetableDatabaseLoader.getParentClass(s1.getClasses().iterator().next(), s2) != null) {
                return -1;
            }
            if (TimetableDatabaseLoader.getParentClass(s2.getClasses().iterator().next(), s1) != null) {
                return 1;
            }
            if (TimetableDatabaseLoader.shareParent(s1, s2)) {
                if (s1.getClasses().size() < s2.getClasses().size()) {
                    return 1;
                }
                if (s1.getClasses().size() > s2.getClasses().size()) {
                    return -1;
                }
            }
            return d1.compareTo(d2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommittedStudentConflictsMode {
        Ignore,
        Load,
        Compute;

    }
}

