/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import java.text.DecimalFormat;
import java.util.TreeSet;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.AttachmentType;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.LocationPicture;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.dao.BuildingDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.server.rooms.RoomDetailsBackend;
import org.unitime.timetable.server.rooms.RoomPicturesBackend;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=RoomInterface.RoomHintRequest.class)
public class RoomHintBackend
implements GwtRpcImplementation<RoomInterface.RoomHintRequest, RoomInterface.RoomHintResponse> {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    @Override
    public RoomInterface.RoomHintResponse execute(RoomInterface.RoomHintRequest request, SessionContext context) {
        RoomInterface.RoomHintResponse response = new RoomInterface.RoomHintResponse();
        if (request.getLocationId() >= 0L) {
            Location location = (Location)LocationDAO.getInstance().get(request.getLocationId());
            if (location == null) {
                return null;
            }
            response.setId(location.getUniqueId());
            response.setLabel(location.getLabel());
            response.setDisplayName(location.getDisplayName());
            response.setRoomTypeLabel(location.getRoomTypeLabel());
            String minimap = ApplicationProperty.RoomHintMinimapUrl.value();
            if (minimap != null && location.getCoordinateX() != null && location.getCoordinateY() != null) {
                minimap = minimap.replace("%x", location.getCoordinateX().toString()).replace("%y", location.getCoordinateY().toString()).replace("%n", location.getLabel()).replace("%i", location.getExternalUniqueId() == null ? "" : location.getExternalUniqueId());
                String apikey = ApplicationProperty.RoomMapStaticApiKey.value();
                if (apikey != null && !apikey.isEmpty()) {
                    minimap = minimap + "&key=" + (String)apikey;
                    String secret = ApplicationProperty.RoomMapStaticSecret.value();
                    if (secret != null && !secret.isEmpty()) {
                        try {
                            minimap = minimap + "&signature=" + new RoomDetailsBackend.UrlSigner(secret).signRequest(minimap);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                response.setMiniMapUrl(minimap);
            }
            response.setCapacity(location.getCapacity());
            if (location.getExamCapacity() != null && location.getExamCapacity() > 0 && !location.getExamCapacity().equals(location.getCapacity()) && !location.getExamTypes().isEmpty()) {
                response.setExamCapacity(location.getExamCapacity());
                if (location.getExamTypes().size() == 1) {
                    response.setExamType(location.getExamTypes().iterator().next().getLabel().toLowerCase());
                }
            }
            if (location.getArea() != null) {
                response.setArea(new DecimalFormat(CONSTANTS.roomAreaFormat()).format(location.getArea()) + " " + (ApplicationProperty.RoomAreaUnitsMetric.isTrue() ? MSG.roomAreaMetricUnitsShort() : MSG.roomAreaUnitsShort()));
            }
            for (GlobalRoomFeature f : location.getGlobalRoomFeatures()) {
                String string = f.getFeatureType() == null ? MESSAGES.roomFeatures() : f.getFeatureType().getReference();
                response.addFeature(string, f.getLabel());
            }
            String groups = "";
            for (RoomGroup roomGroup : location.getGlobalRoomGroups()) {
                if (!groups.isEmpty()) {
                    groups = groups + ", ";
                }
                groups = groups + roomGroup.getName();
            }
            if (!groups.isEmpty()) {
                response.setGroups(groups);
            }
            response.setEventStatus(location.getEventDepartment() == null ? null : location.getEffectiveEventStatus().toString());
            response.setEventDepartment(location.getEventDepartment() == null ? MESSAGES.noEventDepartment() : location.getEventDepartment().getDeptCode() + " - " + location.getEventDepartment().getName());
            response.setNote(location.getEventMessage());
            if (ApplicationProperty.RoomHintShowBreakTime.isTrue()) {
                response.setBreakTime(location.getEffectiveBreakTime());
            }
            response.setIgnoreRoomCheck(location.isIgnoreRoomCheck());
            for (LocationPicture locationPicture : new TreeSet<LocationPicture>(location.getPictures())) {
                if (locationPicture.getType() != null && (!AttachmentType.VisibilityFlag.IS_IMAGE.in(locationPicture.getType().getVisibility()) || !AttachmentType.VisibilityFlag.SHOW_ROOM_TOOLTIP.in(locationPicture.getType().getVisibility()))) continue;
                response.addPicture(new RoomInterface.RoomPictureInterface(locationPicture.getUniqueId(), locationPicture.getFileName(), locationPicture.getContentType(), locationPicture.getTimeStamp().getTime(), RoomPicturesBackend.getPictureType(locationPicture.getType())));
            }
            return response;
        }
        Building building = (Building)BuildingDAO.getInstance().get(-request.getLocationId().longValue());
        if (building == null) {
            return null;
        }
        response.setId(-building.getUniqueId().longValue());
        response.setLabel(building.getName());
        String minimap = ApplicationProperty.RoomHintMinimapUrl.value();
        if (minimap != null && building.getCoordinateX() != null && building.getCoordinateY() != null) {
            response.setMiniMapUrl(minimap.replace("%x", building.getCoordinateX().toString()).replace("%y", building.getCoordinateY().toString()).replace("%n", building.getAbbreviation()).replace("%i", building.getExternalUniqueId() == null ? "" : building.getExternalUniqueId()));
        }
        return response;
    }
}

