/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.server;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.online.expectations.AvoidUnbalancedWhenNoExpectations;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.cpsolver.studentsct.online.selection.StudentSchedulingAssistantWeights;
import org.hibernate.CacheMode;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jgroups.blocks.locking.LockService;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverParameter;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverPredefinedSetting;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.TravelTime;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.CacheElement;
import org.unitime.timetable.onlinesectioning.HasCacheMode;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningActionFactory;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLogger;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServerContext;
import org.unitime.timetable.onlinesectioning.custom.CourseDetailsProvider;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XTime;
import org.unitime.timetable.onlinesectioning.server.SimpleActionFactory;
import org.unitime.timetable.onlinesectioning.updates.CheckAllOfferingsAction;
import org.unitime.timetable.onlinesectioning.updates.PersistExpectedSpacesAction;
import org.unitime.timetable.onlinesectioning.updates.ReloadAllData;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.MemoryCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServer
implements OnlineSectioningServer {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    protected Log iLog = LogFactory.getLog(AbstractServer.class);
    private DistanceMetric iDistanceMetric = null;
    private DataProperties iConfig = null;
    private OnlineSectioningActionFactory iActionFactory = null;
    protected AsyncExecutor iExecutor = null;
    private Queue<Runnable> iExecutorQueue = new LinkedList<Runnable>();
    private HashSet<CacheElement<Long>> iOfferingsToPersistExpectedSpaces = new HashSet();
    private static ThreadLocal<LinkedList<OnlineSectioningHelper>> sHelper = new ThreadLocal();
    protected Map<String, Object> iProperties = new HashMap<String, Object>();
    private MasterAcquiringThread iMasterThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractServer(OnlineSectioningServerContext context) throws SectioningException {
        this.iConfig = new ServerConfig();
        this.iDistanceMetric = new DistanceMetric(this.iConfig);
        TravelTime.populateTravelTimes(this.iDistanceMetric, context.getAcademicSessionId());
        try {
            this.iActionFactory = (OnlineSectioningActionFactory)Class.forName(ApplicationProperty.CustomizationOnlineSectioningActionFactory.value()).newInstance();
        }
        catch (Exception e) {
            LogFactory.getLog(OnlineSectioningServer.class).warn((Object)"Failed to initialize online sectioning action factory, using the default one.", (Throwable)e);
            this.iActionFactory = new SimpleActionFactory();
        }
        org.hibernate.Session hibSession = SessionDAO.getInstance().createNewSession();
        try {
            Session session = (Session)SessionDAO.getInstance().get(context.getAcademicSessionId(), hibSession);
            if (session == null) {
                throw new SectioningException(MSG.exceptionSessionDoesNotExist(context.getAcademicSessionId() == null ? "null" : context.getAcademicSessionId().toString()));
            }
            AcademicSessionInfo academicSession = new AcademicSessionInfo(session);
            this.iLog = LogFactory.getLog((String)(OnlineSectioningServer.class.getName() + ".server[" + academicSession.toCompactString() + "]"));
            this.iProperties.put("AcademicSession", academicSession);
            this.iExecutor = new AsyncExecutor(academicSession);
            this.iExecutor.start();
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            hibSession.close();
            throw throwable;
        }
        hibSession.close();
        this.iLog.info((Object)("Config: " + ToolBox.dict2string((Map)this.iConfig, (int)2)));
        this.load(context);
    }

    protected AbstractServer(AcademicSessionInfo session, boolean allowAsyncCalls) {
        this.iConfig = new ServerConfig();
        this.iDistanceMetric = new DistanceMetric(this.iConfig);
        TravelTime.populateTravelTimes(this.iDistanceMetric, session.getUniqueId());
        try {
            this.iActionFactory = (OnlineSectioningActionFactory)Class.forName(ApplicationProperty.CustomizationOnlineSectioningActionFactory.value()).newInstance();
        }
        catch (Exception e) {
            LogFactory.getLog(OnlineSectioningServer.class).warn((Object)"Failed to initialize online sectioning action factory, using the default one.", (Throwable)e);
            this.iActionFactory = new SimpleActionFactory();
        }
        this.iLog = LogFactory.getLog((String)(OnlineSectioningServer.class.getName() + ".server[" + session.toCompactString() + "]"));
        this.iProperties.put("AcademicSession", session);
        if (allowAsyncCalls) {
            this.iExecutor = new AsyncExecutor(session);
            this.iExecutor.start();
        }
    }

    protected void load(OnlineSectioningServerContext context) throws SectioningException {
        if (context.getLockService() != null) {
            this.iMasterThread = new MasterAcquiringThread(context);
            this.iMasterThread.start();
        } else {
            this.loadOnMaster(context);
        }
    }

    protected void loadOnMaster(OnlineSectioningServerContext context) throws SectioningException {
        block9: {
            try {
                this.setProperty("ReloadIsNeeded", Boolean.FALSE);
                final OnlineSectioningLog.Entity user = OnlineSectioningLog.Entity.newBuilder().setExternalId(StudentClassEnrollment.SystemChange.SYSTEM.name()).setName(StudentClassEnrollment.SystemChange.SYSTEM.getName()).setType(OnlineSectioningLog.Entity.EntityType.OTHER).build();
                if (context.isWaitTillStarted()) {
                    try {
                        this.execute(this.createAction(ReloadAllData.class), user);
                    }
                    catch (Throwable exception) {
                        this.iLog.error((Object)("Failed to load server: " + exception.getMessage()), exception);
                        throw exception;
                    }
                    if (this.getAcademicSession().isSectioningEnabled()) {
                        try {
                            this.execute(this.createAction(CheckAllOfferingsAction.class), user);
                        }
                        catch (Throwable exception) {
                            this.iLog.error((Object)("Failed to check all offerings: " + exception.getMessage()), exception);
                            throw exception;
                        }
                    }
                    this.setReady(true);
                    this.getMemUsage();
                    break block9;
                }
                this.execute(this.createAction(ReloadAllData.class), user, new OnlineSectioningServer.ServerCallback<Boolean>(){

                    @Override
                    public void onSuccess(Boolean result) {
                        if (AbstractServer.this.getAcademicSession().isSectioningEnabled()) {
                            AbstractServer.this.execute(AbstractServer.this.createAction(CheckAllOfferingsAction.class), user, new OnlineSectioningServer.ServerCallback<Boolean>(){

                                @Override
                                public void onSuccess(Boolean result) {
                                    AbstractServer.this.setReady(true);
                                    AbstractServer.this.getMemUsage();
                                }

                                @Override
                                public void onFailure(Throwable exception) {
                                    AbstractServer.this.iLog.error((Object)("Failed to check all offerings: " + exception.getMessage()), exception);
                                }
                            });
                        } else {
                            AbstractServer.this.setReady(true);
                            AbstractServer.this.getMemUsage();
                        }
                    }

                    @Override
                    public void onFailure(Throwable exception) {
                        AbstractServer.this.iLog.error((Object)("Failed to load server: " + exception.getMessage()), exception);
                    }
                });
            }
            catch (Throwable t) {
                if (t instanceof SectioningException) {
                    throw (SectioningException)t;
                }
                throw new SectioningException(MSG.exceptionUnknown(t.getMessage()), t);
            }
        }
    }

    @Override
    public long getMemUsage() {
        Runtime rt = Runtime.getRuntime();
        MemoryCounter mc = new MemoryCounter();
        DecimalFormat df = new DecimalFormat("#,##0.00");
        long total = 0L;
        HashMap<String, String> info = new HashMap<String, String>();
        for (Class<?> clazz = this.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (Modifier.isStatic(fields[i].getModifiers()) || fields[i].getType().isPrimitive()) continue;
                fields[i].setAccessible(true);
                try {
                    Object obj = fields[i].get(this);
                    if (obj == null) continue;
                    long est = this.estimate(mc, obj);
                    if (est > 1024L) {
                        info.put(clazz.getSimpleName() + "." + fields[i].getName(), df.format((double)est / 1024.0) + " kB" + (obj instanceof Map ? " (" + ((Map)obj).size() + " records)" : (obj instanceof Collection ? "(" + ((Collection)obj).size() + " records)" : "")));
                    }
                    total += est;
                    continue;
                }
                catch (IllegalAccessException ex) {
                    continue;
                }
                catch (ConcurrentModificationException ex) {
                    // empty catch block
                }
            }
        }
        this.iLog.info((Object)("Total Allocated " + df.format((double)total / 1024.0) + " kB (of " + df.format((double)(rt.totalMemory() - rt.freeMemory()) / 1048576.0) + " MB), details: " + ToolBox.dict2string(info, (int)2)));
        return total;
    }

    private long estimate(MemoryCounter mc, Object obj) {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            if (map.size() <= 1000) {
                return mc.estimate(obj);
            }
            long total = 0L;
            int limit = map.size() / 5;
            Iterator it = map.entrySet().iterator();
            for (int i = 0; i < limit; ++i) {
                Map.Entry e = it.next();
                total += mc.estimate(e.getKey()) + mc.estimate(e.getValue());
            }
            return (long)map.size() * total / (long)limit;
        }
        if (obj instanceof Collection) {
            Collection col = (Collection)obj;
            if (col.size() <= 1000) {
                return mc.estimate(obj);
            }
            long total = 0L;
            int limit = col.size() / 5;
            Iterator it = col.iterator();
            for (int i = 0; i < limit; ++i) {
                Object val = it.next();
                total += mc.estimate(val);
            }
            return (long)col.size() * total / (long)limit;
        }
        return mc.estimate(obj);
    }

    @Override
    public boolean isMaster() {
        return this.iMasterThread != null ? this.iMasterThread.isMaster() : true;
    }

    protected void setReady(boolean ready) {
        this.setProperty("ReadyToServe", Boolean.TRUE);
    }

    @Override
    public boolean isReady() {
        return Boolean.TRUE.equals(this.getProperty("ReadyToServe", Boolean.FALSE));
    }

    @Override
    public void releaseMasterLockIfHeld() {
        if (this.iMasterThread != null) {
            this.iMasterThread.release();
        } else if (Boolean.TRUE.equals(this.getProperty("ReloadIsNeeded", Boolean.FALSE))) {
            this.iLog.info((Object)"Reloading server...");
            final Long sessionId = this.getAcademicSession().getUniqueId();
            this.loadOnMaster(new OnlineSectioningServerContext(){

                public Long getAcademicSessionId() {
                    return sessionId;
                }

                public boolean isWaitTillStarted() {
                    return false;
                }

                public EmbeddedCacheManager getCacheManager() {
                    return null;
                }

                public LockService getLockService() {
                    return null;
                }
            });
        }
    }

    @Override
    public DistanceMetric getDistanceMetric() {
        return this.iDistanceMetric;
    }

    @Override
    public OverExpectedCriterion getOverExpectedCriterion() {
        try {
            Class<?> overExpectedCriterionClass = Class.forName(this.getConfig().getProperty("OverExpectedCriterion.Class", AvoidUnbalancedWhenNoExpectations.class.getName()));
            return (OverExpectedCriterion)overExpectedCriterionClass.getConstructor(DataProperties.class).newInstance(this.getConfig());
        }
        catch (Exception e) {
            this.iLog.error((Object)("Unable to create custom over-expected criterion (" + e.getMessage() + "), using default."), (Throwable)e);
            return new AvoidUnbalancedWhenNoExpectations(this.getConfig());
        }
    }

    @Override
    public AcademicSessionInfo getAcademicSession() {
        return this.getProperty("AcademicSession", null);
    }

    @Override
    public String getCourseDetails(Long courseId, CourseDetailsProvider provider) {
        XCourse course = this.getCourse(courseId);
        return course == null ? null : course.getDetails(this.getAcademicSession(), provider);
    }

    protected OnlineSectioningHelper getCurrentHelper() {
        LinkedList<OnlineSectioningHelper> h = sHelper.get();
        if (h == null || h.isEmpty()) {
            return new OnlineSectioningHelper(null);
        }
        return h.peek();
    }

    protected void setCurrentHelper(OnlineSectioningHelper helper) {
        LinkedList<OnlineSectioningHelper> h = sHelper.get();
        if (h == null) {
            h = new LinkedList();
            sHelper.set(h);
        }
        h.push(helper);
    }

    protected void releaseCurrentHelper() {
        LinkedList<OnlineSectioningHelper> h = sHelper.get();
        h.poll();
        if (h.isEmpty()) {
            sHelper.remove();
        }
    }

    protected OnlineSectioningLog.Entity getSystemUser() {
        return OnlineSectioningLog.Entity.newBuilder().setExternalId(StudentClassEnrollment.SystemChange.SYSTEM.name()).setName(StudentClassEnrollment.SystemChange.SYSTEM.getName()).setType(OnlineSectioningLog.Entity.EntityType.OTHER).build();
    }

    @Override
    public <X extends OnlineSectioningAction> X createAction(Class<X> clazz) {
        return this.iActionFactory.createAction(clazz);
    }

    @Override
    public <E> E execute(OnlineSectioningAction<E> action, OnlineSectioningLog.Entity user) throws SectioningException {
        E e;
        OnlineSectioningHelper h;
        block26: {
            long c0 = OnlineSectioningHelper.getCpuTime();
            String cacheMode = this.getConfig().getProperty(action.name() + ".CacheMode", this.getConfig().getProperty("CacheMode"));
            h = new OnlineSectioningHelper(user, cacheMode != null ? CacheMode.valueOf((String)cacheMode) : (action instanceof HasCacheMode ? ((HasCacheMode)((Object)action)).getCacheMode() : CacheMode.IGNORE));
            try {
                this.setCurrentHelper(h);
                h.addMessageHandler(new OnlineSectioningHelper.DefaultMessageLogger(LogFactory.getLog((String)(action.getClass().getName() + "." + action.name() + "[" + this.getAcademicSession().toCompactString() + "]"))));
                h.addAction(action, this.getAcademicSession());
                E ret = action.execute(this, h);
                if (h.getAction() != null && !h.getAction().hasResult()) {
                    if (ret == null) {
                        h.getAction().setResult(OnlineSectioningLog.Action.ResultType.NULL);
                    } else if (ret instanceof Boolean) {
                        h.getAction().setResult((Boolean)ret != false ? OnlineSectioningLog.Action.ResultType.TRUE : OnlineSectioningLog.Action.ResultType.FALSE);
                    } else {
                        h.getAction().setResult(OnlineSectioningLog.Action.ResultType.SUCCESS);
                    }
                }
                e = ret;
                Object var10_9 = null;
                if (h.getAction() == null) break block26;
                h.getAction().setEndTime(System.currentTimeMillis()).setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
            }
            catch (Exception e2) {
                try {
                    if (e2 instanceof SectioningException) {
                        if (e2.getCause() == null) {
                            h.info("Execution failed: " + e2.getMessage());
                        } else {
                            h.warn("Execution failed: " + e2.getMessage(), e2.getCause());
                        }
                    } else {
                        h.error("Execution failed: " + e2.getMessage(), e2);
                    }
                    if (h.getAction() != null) {
                        h.getAction().setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                        if (e2.getCause() != null && e2 instanceof SectioningException) {
                            h.getAction().addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e2.getCause().getClass().getName() + ": " + e2.getCause().getMessage()));
                        } else {
                            h.getAction().addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e2.getMessage() == null ? "null" : e2.getMessage()));
                        }
                    }
                    if (e2 instanceof SectioningException) {
                        throw (SectioningException)e2;
                    }
                    throw new SectioningException(MSG.exceptionUnknown(e2.getMessage()), e2);
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (h.getAction() != null) {
                        h.getAction().setEndTime(System.currentTimeMillis()).setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                        if ((!h.getAction().hasStudent() || !h.getAction().getStudent().hasExternalId()) && user != null && user.hasExternalId() && user.hasType() && user.getType() == OnlineSectioningLog.Entity.EntityType.STUDENT) {
                            if (h.getAction().hasStudent()) {
                                h.getAction().getStudentBuilder().setExternalId(user.getExternalId());
                            } else {
                                h.getAction().setStudent(OnlineSectioningLog.Entity.newBuilder().setExternalId(user.getExternalId()));
                            }
                        }
                    }
                    if (this.iLog.isDebugEnabled()) {
                        this.iLog.debug((Object)("Executed: " + h.getLog() + " (" + h.getLog().toByteArray().length + " bytes)"));
                    }
                    OnlineSectioningLogger.getInstance().record(h.getLog());
                    this.releaseCurrentHelper();
                    throw throwable;
                }
            }
            if ((!h.getAction().hasStudent() || !h.getAction().getStudent().hasExternalId()) && user != null && user.hasExternalId() && user.hasType() && user.getType() == OnlineSectioningLog.Entity.EntityType.STUDENT) {
                if (h.getAction().hasStudent()) {
                    h.getAction().getStudentBuilder().setExternalId(user.getExternalId());
                } else {
                    h.getAction().setStudent(OnlineSectioningLog.Entity.newBuilder().setExternalId(user.getExternalId()));
                }
            }
        }
        if (this.iLog.isDebugEnabled()) {
            this.iLog.debug((Object)("Executed: " + h.getLog() + " (" + h.getLog().toByteArray().length + " bytes)"));
        }
        OnlineSectioningLogger.getInstance().record(h.getLog());
        this.releaseCurrentHelper();
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> void execute(final OnlineSectioningAction<E> action, final OnlineSectioningLog.Entity user, final OnlineSectioningServer.ServerCallback<E> callback) throws SectioningException {
        if (this.iExecutor == null) {
            try {
                callback.onSuccess(this.execute(action, user));
            }
            catch (Throwable t) {
                callback.onFailure(t);
            }
            return;
        }
        final String locale = Localization.getLocale();
        Queue<Runnable> queue = this.iExecutorQueue;
        synchronized (queue) {
            this.iExecutorQueue.offer(new Runnable(){

                public void run() {
                    Localization.setLocale(locale);
                    try {
                        callback.onSuccess(AbstractServer.this.execute(action, user));
                    }
                    catch (Throwable t) {
                        callback.onFailure(t);
                    }
                }

                public String toString() {
                    return action.name();
                }
            });
            this.iExecutorQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unload() {
        if (this.iExecutor != null) {
            this.iExecutor.iStop = true;
            Queue<Runnable> queue = this.iExecutorQueue;
            synchronized (queue) {
                this.iExecutorQueue.notify();
            }
        }
        if (this.iMasterThread != null) {
            this.iMasterThread.dispose();
        }
    }

    @Override
    public DataProperties getConfig() {
        return this.iConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistExpectedSpaces(Long offeringId) {
        HashSet<CacheElement<Long>> hashSet = this.iOfferingsToPersistExpectedSpaces;
        synchronized (hashSet) {
            this.iOfferingsToPersistExpectedSpaces.add(new CacheElement<Long>(offeringId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getOfferingsToPersistExpectedSpaces(long minimalAge) {
        ArrayList<Long> offeringIds = new ArrayList<Long>();
        long current = JProf.currentTimeMillis();
        HashSet<CacheElement<Long>> hashSet = this.iOfferingsToPersistExpectedSpaces;
        synchronized (hashSet) {
            Iterator<CacheElement<Long>> i = this.iOfferingsToPersistExpectedSpaces.iterator();
            while (i.hasNext()) {
                CacheElement<Long> c = i.next();
                if (current - c.created() < minimalAge) continue;
                offeringIds.add(c.element());
                i.remove();
            }
        }
        return offeringIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean needPersistExpectedSpaces(Long offeringId) {
        HashSet<CacheElement<Long>> hashSet = this.iOfferingsToPersistExpectedSpaces;
        synchronized (hashSet) {
            return this.iOfferingsToPersistExpectedSpaces.remove(offeringId);
        }
    }

    @Override
    public boolean checkDeadline(Long courseId, XTime sectionTime, OnlineSectioningServer.Deadline type) {
        if (!ApplicationProperty.OnlineSchedulingCheckDeadlines.isTrue()) {
            return true;
        }
        XCourse info = this.getCourse(courseId);
        int deadline = 0;
        switch (type) {
            case NEW: {
                if (info != null && info.getLastWeekToEnroll() != null) {
                    deadline = info.getLastWeekToEnroll();
                    break;
                }
                deadline = this.getAcademicSession().getLastWeekToEnroll();
                break;
            }
            case CHANGE: {
                if (info != null && info.getLastWeekToChange() != null) {
                    deadline = info.getLastWeekToChange();
                    break;
                }
                deadline = this.getAcademicSession().getLastWeekToChange();
                break;
            }
            case DROP: {
                deadline = info != null && info.getLastWeekToDrop() != null ? info.getLastWeekToDrop().intValue() : this.getAcademicSession().getLastWeekToDrop();
            }
        }
        long start = this.getAcademicSession().getSessionBeginDate().getTime();
        long now = new Date().getTime();
        int week = 0;
        week = now >= start ? (int)((now - start) / 604800000L) + 1 : -((int)((start - now) / 604800000L));
        if (sectionTime == null) {
            return week <= deadline;
        }
        int offset = 0;
        long time = this.getAcademicSession().getDatePatternFirstDate().getTime() + (long)sectionTime.getWeeks().nextSetBit(0) * 86400000L;
        offset = time >= start ? (int)((time - start) / 604800000L) : -((int)((start - time) / 604800000L)) - 1;
        return week <= deadline + offset;
    }

    @Override
    public String getHost() {
        return "local";
    }

    @Override
    public String getUser() {
        return this.getAcademicSession().getUniqueId().toString();
    }

    @Override
    public XEnrollments getEnrollments(Long offeringId) {
        return new XEnrollments(offeringId, this.getRequests(offeringId));
    }

    @Override
    public <E> E getProperty(String name, E defaultValue) {
        Object ret = this.iProperties.get(name);
        return (E)(ret == null ? defaultValue : ret);
    }

    @Override
    public <E> void setProperty(String name, E value) {
        if (value == null) {
            this.iProperties.remove(name);
        } else {
            this.iProperties.put(name, value);
        }
    }

    private class MasterAcquiringThread
    extends Thread {
        private Lock iLock;
        private AtomicBoolean iMaster = new AtomicBoolean(false);
        private boolean iStop = false;
        private OnlineSectioningServerContext iContext;

        private MasterAcquiringThread(OnlineSectioningServerContext context) {
            this.iContext = context;
            this.setName("AcquiringMasterLock[" + AbstractServer.this.getAcademicSession() + "]");
            this.setDaemon(true);
            this.iLock = context.getLockService().getLock(AbstractServer.this.getAcademicSession().toCompactString() + "[master]");
        }

        public boolean isMaster() {
            return this.iMaster.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeLoadOnMaster() {
            Queue queue = AbstractServer.this.iExecutorQueue;
            synchronized (queue) {
                AbstractServer.this.iExecutorQueue.offer(new Runnable(){

                    public void run() {
                        AbstractServer.this.loadOnMaster(MasterAcquiringThread.this.iContext);
                    }

                    public String toString() {
                        return "load-on-master";
                    }
                });
                AbstractServer.this.iExecutorQueue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.iLock.tryLock()) {
                this.iMaster.set(true);
                AbstractServer.this.iLog.info((Object)"Loading server...");
                this.executeLoadOnMaster();
            }
            while (!this.iStop) {
                try {
                    if (!this.iMaster.get()) {
                        AbstractServer.this.iLog.info((Object)"Waiting for a master lock...");
                        this.iLock.lockInterruptibly();
                    }
                    AtomicBoolean atomicBoolean = this.iMaster;
                    synchronized (atomicBoolean) {
                        AbstractServer.this.iLog.info((Object)"I am the master.");
                        this.iMaster.set(true);
                        if (Boolean.TRUE.equals(AbstractServer.this.getProperty("ReloadIsNeeded", Boolean.FALSE))) {
                            AbstractServer.this.iLog.info((Object)"Reloading server...");
                            this.executeLoadOnMaster();
                        }
                        this.iMaster.wait();
                        this.iMaster.set(false);
                        this.iLock.unlock();
                        AbstractServer.this.iLog.info((Object)"I am no longer the master.");
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            if (this.iMaster.get()) {
                this.iMaster.set(false);
                this.iLock.unlock();
                AbstractServer.this.iLog.info((Object)"I am no longer the master.");
            }
            AbstractServer.this.iLog.info((Object)"No longer looking for a master.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean release() {
            AtomicBoolean atomicBoolean = this.iMaster;
            synchronized (atomicBoolean) {
                if (this.iMaster.get()) {
                    AbstractServer.this.iLog.info((Object)"Releasing master lock...");
                    List<Long> offeringIds = AbstractServer.this.getOfferingsToPersistExpectedSpaces(0L);
                    if (!offeringIds.isEmpty()) {
                        AbstractServer.this.iLog.info((Object)("There are " + offeringIds.size() + " offerings that need expected spaces persisted."));
                        AbstractServer.this.execute(AbstractServer.this.createAction(PersistExpectedSpacesAction.class).forOfferings(offeringIds), AbstractServer.this.getSystemUser());
                    }
                    this.iMaster.notify();
                    return true;
                }
                return false;
            }
        }

        public void dispose() {
            this.iStop = true;
            if (!this.release()) {
                this.interrupt();
            }
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class ServerConfig
    extends DataProperties {
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServerConfig() {
            this.setProperty("Neighbour.BranchAndBoundTimeout", "1000");
            this.setProperty("Suggestions.Timeout", "1000");
            this.setProperty("Extensions.Classes", DistanceConflict.class.getName() + ";" + TimeOverlapsCounter.class.getName());
            this.setProperty("StudentWeights.Class", StudentSchedulingAssistantWeights.class.getName());
            this.setProperty("StudentWeights.PriorityWeighting", "true");
            this.setProperty("StudentWeights.LeftoverSpread", "true");
            this.setProperty("StudentWeights.BalancingFactor", "0.0");
            this.setProperty("StudentWeights.MultiCriteria", "true");
            this.setProperty("Reservation.CanAssignOverTheLimit", "true");
            this.setProperty("General.SaveDefaultProperties", "false");
            this.setProperty("General.StartUpDate", String.valueOf(new Date().getTime()));
            this.setProperty("check-assignment.ExcludeLockedOfferings", "false");
            this.setProperty("check-offering.ExcludeLockedOfferings", "false");
            this.setProperty("approve-enrollments.ExcludeLockedOfferings", "false");
            this.setProperty("reject-enrollments.ExcludeLockedOfferings", "false");
            this.setProperty("status-change.LockOfferings", "false");
            this.setProperty("student-email.LockOfferings", "false");
            this.setProperty("eligibility.LockOfferings", "false");
            org.hibernate.Session hibSession = SessionDAO.getInstance().createNewSession();
            try {
                for (SolverParameterDef def : hibSession.createQuery("from SolverParameterDef x where x.group.type = :type and x.default is not null").setInteger("type", 2).list()) {
                    this.setProperty(def.getName(), def.getDefault());
                }
                SolverPredefinedSetting settings = (SolverPredefinedSetting)hibSession.createQuery("from SolverPredefinedSetting x where x.name = :reference").setString("reference", "StudentSct.Online").setMaxResults(1).uniqueResult();
                if (settings != null) {
                    for (SolverParameter param : settings.getParameters()) {
                        if (!param.getDefinition().isVisible().booleanValue() || param.getDefinition().getGroup().getType() != 2) continue;
                        this.setProperty(param.getDefinition().getName(), param.getValue());
                    }
                    this.setProperty("General.SettingsId", settings.getUniqueId().toString());
                }
                if (this.getProperty("Distances.Ellipsoid") == null || "DEFAULT".equals(this.getProperty("Distances.Ellipsoid"))) {
                    this.setProperty("Distances.Ellipsoid", ApplicationProperty.DistanceEllipsoid.value());
                }
                if ("Priority".equals(this.getProperty("StudentWeights.Mode"))) {
                    this.setProperty("StudentWeights.PriorityWeighting", "true");
                } else if ("Equal".equals(this.getProperty("StudentWeights.Mode"))) {
                    this.setProperty("StudentWeights.PriorityWeighting", "false");
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
        }

        public String getProperty(String key) {
            String value = ApplicationProperty.OnlineSchedulingParameter.value(key);
            return value == null ? super.getProperty(key) : value;
        }

        public String getProperty(String key, String defaultValue) {
            String value = ApplicationProperty.OnlineSchedulingParameter.value(key);
            return value == null ? super.getProperty(key, defaultValue) : value;
        }
    }

    public class AsyncExecutor
    extends Thread {
        private boolean iStop = false;

        public AsyncExecutor(AcademicSessionInfo session) {
            this.setName("AsyncExecutor[" + session + "]");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ApplicationProperties.setSessionId(AbstractServer.this.getAcademicSession().getUniqueId());
                while (!this.iStop) {
                    Runnable job;
                    Queue queue = AbstractServer.this.iExecutorQueue;
                    synchronized (queue) {
                        job = (Runnable)AbstractServer.this.iExecutorQueue.poll();
                        if (job == null) {
                            try {
                                AbstractServer.this.iLog.info((Object)"Executor is waiting for a new job...");
                                AbstractServer.this.iExecutorQueue.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    job.run();
                    if (!_RootDAO.closeCurrentThreadSessions()) continue;
                    AbstractServer.this.iLog.debug((Object)("Job " + job + " did not close current-thread hibernate session."));
                }
                AbstractServer.this.iLog.info((Object)"Executor stopped.");
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                ApplicationProperties.setSessionId(null);
                Localization.removeLocale();
                Formats.removeFormats();
                throw throwable;
            }
            ApplicationProperties.setSessionId(null);
            Localization.removeLocale();
            Formats.removeFormats();
        }
    }
}

