/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.restlet.Client;
import org.restlet.Uniform;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.DegreePlanInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CourseRequestsProvider;
import org.unitime.timetable.onlinesectioning.custom.DegreePlansProvider;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.GsonRepresentation;
import org.unitime.timetable.onlinesectioning.custom.purdue.XEInterface;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DegreeWorksCourseRequests
implements CourseRequestsProvider,
DegreePlansProvider {
    private static Logger sLog = Logger.getLogger(DegreeWorksCourseRequests.class);
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;

    public DegreeWorksCourseRequests() {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
    }

    protected String getDegreeWorksApiSite() {
        return ApplicationProperties.getProperty("banner.dgw.site");
    }

    protected String getDegreeWorksApiUser() {
        return ApplicationProperties.getProperty("banner.dgw.user");
    }

    protected String getDegreeWorksApiPassword() {
        return ApplicationProperties.getProperty("banner.dgw.password");
    }

    protected String getDegreeWorksApiEffectiveOnly() {
        return ApplicationProperties.getProperty("banner.dgw.effectiveOnly", "false");
    }

    protected String getDegreeWorksErrorPattern() {
        return ApplicationProperties.getProperty("banner.dgw.errorPattern", "<div class=\"exceptionMessage\">\n(.*)\n\n</div>");
    }

    protected boolean getDegreeWorksActiveOnly() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.dgw.activeOnly", "true"));
    }

    protected String getDegreeWorksNoPlansMessage() {
        return ApplicationProperties.getProperty("banner.dgw.noPlansMessage", "No active degree plan is available.");
    }

    protected int getDegreeWorksNrAttempts() {
        return Integer.parseInt(ApplicationProperties.getProperty("banner.dgw.nrAttempts", "3"));
    }

    protected String getBannerId(XStudent student) {
        String id = student.getExternalId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected String getBannerTerm(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalTerm(session);
    }

    protected Gson getGson(OnlineSectioningHelper helper) {
        GsonBuilder builder = new GsonBuilder();
        if (helper.isDebugEnabled()) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }

    protected XCourseId getCourse(OnlineSectioningServer server, XEInterface.Course course) {
        Collection<? extends XCourseId> courses = server.findCourses(course.courseDiscipline + " " + course.courseNumber, -1, null);
        for (XCourseId xCourseId : courses) {
            if (!xCourseId.matchTitle(course.title)) continue;
            return xCourseId;
        }
        Iterator<? extends XCourseId> iterator = courses.iterator();
        if (iterator.hasNext()) {
            XCourseId xCourseId = iterator.next();
            return xCourseId;
        }
        return new XCourseId(null, null, course.courseDiscipline + " " + course.courseNumber);
    }

    protected OnlineSectioningLog.Entity toEntity(XEInterface.Course course, XCourseId courseId) {
        OnlineSectioningLog.Entity.Builder builder = OnlineSectioningLog.Entity.newBuilder();
        if (courseId.getCourseId() != null) {
            builder.setUniqueId(courseId.getCourseId());
        }
        builder.setName(courseId.getCourseName());
        builder.setExternalId(course.courseDiscipline + " " + course.courseNumber + (course.title != null && !course.title.isEmpty() ? " - " + course.title : ""));
        return builder.build();
    }

    protected boolean hasSelection(XEInterface.Group group) {
        if ("CH".equals(group.groupType.code)) {
            for (XEInterface.Course course : group.plannedClasses) {
                if (!course.isGroupSelection) continue;
                return true;
            }
            for (XEInterface.Group g : group.groups) {
                if (!this.hasSelection(g)) continue;
                return true;
            }
            return false;
        }
        return group.isGroupSelection;
    }

    protected void fillInRequests(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request, XEInterface.Group group) {
        block11: {
            block10: {
                if (!"CH".equals(group.groupType.code)) break block10;
                boolean hasSelection = false;
                for (XEInterface.Course course : group.plannedClasses) {
                    Object cid;
                    if (!course.isGroupSelection || (cid = this.getCourse(server, course)) == null) continue;
                    helper.getAction().addRequestBuilder().setPriority(request.getCourses().size()).setAlternative(false).addCourse(this.toEntity(course, (XCourseId)cid));
                    CourseRequestInterface.Request r = new CourseRequestInterface.Request();
                    r.setRequestedCourse(((XCourseId)cid).getCourseName());
                    request.getCourses().add(r);
                    hasSelection = true;
                }
                for (XEInterface.Group g : group.groups) {
                    if (!this.hasSelection(g)) continue;
                    this.fillInRequests(server, helper, request, g);
                    hasSelection = true;
                }
                if (hasSelection) break block11;
                CourseRequestInterface.Request r = new CourseRequestInterface.Request();
                OnlineSectioningLog.Request.Builder b = OnlineSectioningLog.Request.newBuilder().setPriority(request.getCourses().size()).setAlternative(false);
                for (XEInterface.Course course : group.plannedClasses) {
                    XCourseId cid = this.getCourse(server, course);
                    if (cid == null) continue;
                    if (!r.hasRequestedCourse()) {
                        r.setRequestedCourse(cid.getCourseName());
                    } else if (!r.hasFirstAlternative()) {
                        r.setFirstAlternative(cid.getCourseName());
                    } else if (!r.hasSecondAlternative()) {
                        r.setSecondAlternative(cid.getCourseName());
                        break;
                    }
                    b.addCourse(this.toEntity(course, cid));
                }
                if (!r.hasRequestedCourse()) break block11;
                helper.getAction().addRequest(b);
                request.getCourses().add(r);
                break block11;
            }
            for (XEInterface.Course course : group.plannedClasses) {
                XCourseId cid = this.getCourse(server, course);
                if (cid == null) continue;
                helper.getAction().addRequestBuilder().setPriority(request.getCourses().size()).setAlternative(false).addCourse(this.toEntity(course, cid));
                CourseRequestInterface.Request r = new CourseRequestInterface.Request();
                r.setRequestedCourse(cid.getCourseName());
                request.getCourses().add(r);
            }
            for (XEInterface.Group g : group.groups) {
                this.fillInRequests(server, helper, request, g);
            }
        }
    }

    protected String toString(Reader reader) throws IOException {
        char[] buffer = new char[8192];
        StringBuilder out = new StringBuilder();
        int read = 0;
        while ((read = reader.read(buffer, 0, buffer.length)) > 0) {
            out.append(buffer, 0, read);
        }
        reader.close();
        return out.toString();
    }

    @Override
    public CourseRequestInterface getCourseRequests(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student) throws SectioningException {
        try {
            List<XEInterface.DegreePlan> current;
            String effectiveOnly;
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String studentId = this.getBannerId(student);
            if (helper.isDebugEnabled()) {
                helper.debug("Retrieving student plan for " + student.getName() + " (term: " + term + ", id:" + studentId + ")");
            }
            if ((effectiveOnly = this.getDegreeWorksApiEffectiveOnly()) != null) {
                helper.getAction().addOptionBuilder().setKey("effectiveOnly").setValue(effectiveOnly);
            }
            if ((current = this.getDegreePlans(term, studentId, effectiveOnly, this.getDegreeWorksNrAttempts())) != null && !current.isEmpty()) {
                Gson gson = this.getGson(helper);
                helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson(current));
                for (XEInterface.DegreePlan plan : current) {
                    if (plan.isActive == null || !plan.isActive.value || plan.years == null) continue;
                    for (XEInterface.Year y : plan.years) {
                        if (y.terms == null) continue;
                        for (XEInterface.Term t : y.terms) {
                            if (t.term == null || !term.equals(t.term.code) || t.group == null) continue;
                            if (helper.isDebugEnabled()) {
                                helper.debug("Current degree plan: " + gson.toJson((Object)t.group));
                            }
                            CourseRequestInterface request = new CourseRequestInterface();
                            request.setAcademicSessionId(server.getAcademicSession().getUniqueId());
                            request.setStudentId(student.getStudentId());
                            this.fillInRequests(server, helper, request, t.group);
                            if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.dgw.includePlaceHolders", "true"))) {
                                for (XEInterface.PlaceHolder ph : t.group.plannedPlaceholders) {
                                    CourseRequestInterface.Request r = new CourseRequestInterface.Request();
                                    r.setRequestedCourse(ph.placeholderValue.trim());
                                    request.getCourses().add(r);
                                }
                            }
                            if (helper.isDebugEnabled()) {
                                helper.debug("Course Requests: " + request);
                            }
                            return request;
                        }
                    }
                }
            }
            if (helper.isDebugEnabled()) {
                helper.debug("No degree plan has been returned.");
            }
            return null;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SectioningException(e.getMessage());
        }
    }

    @Override
    public void dispose() {
        try {
            this.iClient.stop();
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected DegreePlanInterface.DegreeGroupInterface toGroup(OnlineSectioningServer server, XEInterface.Group g) {
        DegreePlanInterface.DegreeGroupInterface group = new DegreePlanInterface.DegreeGroupInterface();
        group.setChoice(g.groupType != null && "CH".equals(g.groupType.code));
        group.setDescription(g.summaryDescription);
        group.setId(g.id);
        if (g.plannedClasses != null) {
            for (XEInterface.Course c : g.plannedClasses) {
                if (c.courseDiscipline == null || c.courseNumber == null) continue;
                DegreePlanInterface.DegreeCourseInterface course = new DegreePlanInterface.DegreeCourseInterface();
                if (group.isChoice()) {
                    course.setSelected(c.isGroupSelection);
                }
                course.setSubject(c.courseDiscipline);
                course.setCourse(c.courseNumber);
                course.setTitle(c.title);
                course.setId(c.id);
                Collection<? extends XCourseId> ids = server.findCourses(c.courseDiscipline + " " + c.courseNumber, -1, null);
                if (ids != null) {
                    for (XCourseId xCourseId : ids) {
                        XCourse xc;
                        XCourse xCourse = xc = xCourseId instanceof XCourse ? (XCourse)xCourseId : server.getCourse(xCourseId.getCourseId());
                        if (xc == null) continue;
                        ClassAssignmentInterface.CourseAssignment ca = new ClassAssignmentInterface.CourseAssignment();
                        ca.setCourseId(xc.getCourseId());
                        ca.setSubject(xc.getSubjectArea());
                        ca.setCourseNbr(xc.getCourseNumber());
                        ca.setTitle(xc.getTitle());
                        ca.setNote(xc.getNote());
                        ca.setCreditAbbv(xc.getCreditAbbv());
                        ca.setCreditText(xc.getCreditText());
                        ca.setTitle(xc.getTitle());
                        ca.setHasUniqueName(xc.hasUniqueName());
                        ca.setLimit(xc.getLimit());
                        Collection<XCourseRequest> requests = server.getRequests(xCourseId.getOfferingId());
                        if (requests != null) {
                            int enrl = 0;
                            for (XCourseRequest r : requests) {
                                if (r.getEnrollment() == null || !r.getEnrollment().getCourseId().equals(xCourseId.getCourseId())) continue;
                                ++enrl;
                            }
                            ca.setEnrollment(enrl);
                        }
                        course.addCourse(ca);
                    }
                }
                if (course.hasCourses()) {
                    for (ClassAssignmentInterface.CourseAssignment courseAssignment : course.getCourses()) {
                        if (!courseAssignment.getSubject().equals(course.getSubject()) || !courseAssignment.getCourseNbr().equals(course.getCourse())) continue;
                        course.setCourseId(courseAssignment.getCourseId());
                    }
                }
                group.addCourse(course);
            }
        }
        if (g.plannedPlaceholders != null) {
            for (XEInterface.PlaceHolder ph : g.plannedPlaceholders) {
                DegreePlanInterface.DegreePlaceHolderInterface placeHolder = new DegreePlanInterface.DegreePlaceHolderInterface();
                placeHolder.setType(ph.placeholderType == null ? null : ph.placeholderType.description);
                placeHolder.setName(ph.placeholderValue);
                placeHolder.setId(ph.id);
                group.addPlaceHolder(placeHolder);
            }
        }
        if (g.groups != null) {
            for (XEInterface.Group ch : g.groups) {
                DegreePlanInterface.DegreeGroupInterface childGroup = this.toGroup(server, ch);
                if (childGroup.countItems() <= 1 || childGroup.isChoice() == group.isChoice()) {
                    group.merge(childGroup);
                    continue;
                }
                if (group.isChoice()) {
                    childGroup.setSelected(this.hasSelection(ch));
                }
                group.addGroup(childGroup);
            }
        }
        return group;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<XEInterface.DegreePlan> getDegreePlans(String term, String studentId, String effectiveOnly) throws SectioningException {
        List exception2;
        ClientResource resource = null;
        try {
            try {
                resource = new ClientResource(this.getDegreeWorksApiSite());
                resource.setNext((Uniform)this.iClient);
                resource.addQueryParameter("terms", term);
                resource.addQueryParameter("studentId", studentId);
                if (effectiveOnly != null) {
                    resource.addQueryParameter("effectiveOnly", effectiveOnly);
                }
                resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.getDegreeWorksApiUser(), this.getDegreeWorksApiPassword());
                try {
                    resource.get(MediaType.APPLICATION_JSON);
                }
                catch (ResourceException exception2) {
                    try {
                        String response = this.toString(resource.getResponseEntity().getReader());
                        Pattern pattern = Pattern.compile(this.getDegreeWorksErrorPattern(), 11);
                        Matcher match = pattern.matcher(response);
                        if (match.find()) {
                            throw new SectioningException(match.group(1));
                        }
                    }
                    catch (SectioningException e) {
                        throw e;
                    }
                    finally {
                        throw exception2;
                    }
                }
                exception2 = (List)new GsonRepresentation(resource.getResponseEntity(), XEInterface.DegreePlan.TYPE_LIST).getObject();
                Object var10_14 = null;
                if (resource == null) return exception2;
            }
            catch (SectioningException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SectioningException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            if (resource == null) throw throwable;
            if (resource.getResponse() != null) {
                resource.getResponse().release();
            }
            resource.release();
            throw throwable;
        }
        if (resource.getResponse() != null) {
            resource.getResponse().release();
        }
        resource.release();
        return exception2;
    }

    protected List<XEInterface.DegreePlan> getDegreePlans(String term, String studentId, String effectiveOnly, int nrAttempts) throws SectioningException {
        SectioningException exception = null;
        if (nrAttempts > 1) {
            for (int i = 0; i < nrAttempts; ++i) {
                try {
                    return this.getDegreePlans(term, studentId, effectiveOnly);
                }
                catch (SectioningException e) {
                    sLog.warn((Object)("Failed to retrieve degree plans for " + studentId + " [" + (1 + i) + ". attempt]: " + e.getMessage()));
                    exception = e;
                    continue;
                }
            }
            if (exception != null) {
                throw exception;
            }
            return null;
        }
        return this.getDegreePlans(term, studentId, effectiveOnly);
    }

    @Override
    public List<DegreePlanInterface> getDegreePlans(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student) throws SectioningException {
        try {
            List<XEInterface.DegreePlan> current;
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String studentId = this.getBannerId(student);
            if (helper.isDebugEnabled()) {
                helper.debug("Retrieving degree plans for " + student.getName() + " (term: " + term + ", id:" + studentId + ")");
            }
            String effectiveOnly = this.getDegreeWorksApiEffectiveOnly();
            helper.getAction().addOptionBuilder().setKey("terms").setValue(term);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(studentId);
            if (effectiveOnly != null) {
                helper.getAction().addOptionBuilder().setKey("effectiveOnly").setValue(effectiveOnly);
            }
            if ((current = this.getDegreePlans(term, studentId, effectiveOnly, this.getDegreeWorksNrAttempts())) == null) {
                throw new SectioningException(this.getDegreeWorksNoPlansMessage()).withTypeInfo();
            }
            Gson gson = this.getGson(helper);
            helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson(current));
            if (helper.isDebugEnabled()) {
                helper.debug("Current degree plans: " + gson.toJson(current));
            }
            ArrayList<DegreePlanInterface> plans = new ArrayList<DegreePlanInterface>();
            for (XEInterface.DegreePlan p : current) {
                if (this.getDegreeWorksActiveOnly() && (p.isActive == null || !p.isActive.value)) continue;
                DegreePlanInterface plan = new DegreePlanInterface();
                plan.setSessionId(server.getAcademicSession().getUniqueId());
                plan.setStudentId(student.getStudentId());
                plan.setId(p.id);
                plan.setDegree(p.degree == null ? null : p.degree.description);
                plan.setName(p.description);
                plan.setSchool(p.school == null ? null : p.school.description);
                plan.setLastModified(p.modifyDate);
                plan.setModifiedWho(p.modifyWho == null ? null : p.modifyWho.name);
                plan.setTrackingStatus(p.officialTrackingStatus == null ? null : p.officialTrackingStatus.description);
                plan.setActive(p.isActive != null && p.isActive.value);
                plan.setLocked(p.isLocked != null && p.isLocked.value);
                if (p.years != null) {
                    for (XEInterface.Year y : p.years) {
                        if (y.terms == null) continue;
                        for (XEInterface.Term t : y.terms) {
                            if (t.term == null || !term.equals(t.term.code) || t.group == null) continue;
                            plan.setGroup(this.toGroup(server, t.group));
                        }
                    }
                }
                if (plan.getGroup() == null) continue;
                plans.add(plan);
            }
            if (plans.isEmpty()) {
                throw new SectioningException(this.getDegreeWorksNoPlansMessage()).withTypeInfo();
            }
            return plans;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SectioningException(e.getMessage());
        }
    }
}

