/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom;

import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.custom.StudentEnrollmentProvider;

public class CustomStudentEnrollmentHolder {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static StudentEnrollmentProvider sProvider = null;

    public static synchronized StudentEnrollmentProvider getProvider() {
        if (sProvider == null) {
            try {
                sProvider = (StudentEnrollmentProvider)Class.forName(ApplicationProperty.CustomizationStudentEnrollments.value()).newInstance();
            }
            catch (Exception e) {
                throw new SectioningException(MSG.exceptionStudentEnrollmentProvider(e.getMessage()), e);
            }
        }
        return sProvider;
    }

    public static synchronized void release() {
        if (sProvider != null) {
            sProvider.dispose();
            sProvider = null;
        }
    }

    public static synchronized boolean hasProvider() {
        return sProvider != null || ApplicationProperty.CustomizationStudentEnrollments.value() != null;
    }

    public static synchronized boolean isAllowWaitListing() {
        return !CustomStudentEnrollmentHolder.hasProvider() || CustomStudentEnrollmentHolder.getProvider().isAllowWaitListing();
    }

    public static synchronized boolean isCanRequestUpdates() {
        return !CustomStudentEnrollmentHolder.hasProvider() || CustomStudentEnrollmentHolder.getProvider().isCanRequestUpdates();
    }
}

