/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseRequestsHolder;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetRequest
implements OnlineSectioningAction<CourseRequestInterface> {
    protected static StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    protected static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static final long serialVersionUID = 1L;
    private Long iStudentId;

    public GetRequest forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CourseRequestInterface execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        CourseRequestInterface request;
        XStudent student;
        OnlineSectioningLog.Action.Builder action;
        OnlineSectioningServer.Lock lock;
        block27: {
            block26: {
                if (this.iStudentId == null) {
                    CourseRequestInterface request2;
                    if (CustomCourseRequestsHolder.hasProvider() && (request2 = CustomCourseRequestsHolder.getProvider().getCourseRequests(server, helper, new XStudent(null, helper.getStudentExternalId(), helper.getUser().getName()))) != null) {
                        return request2;
                    }
                    throw new SectioningException(MSG.exceptionNoStudent());
                }
                lock = server.readLock();
                action = helper.getAction();
                action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.iStudentId));
                student = server.getStudent(this.iStudentId);
                if (student != null) break block26;
                CourseRequestInterface courseRequestInterface = null;
                Object var18_9 = null;
                lock.release();
                return courseRequestInterface;
            }
            action.getStudentBuilder().setExternalId(student.getExternalId());
            action.getStudentBuilder().setName(student.getName());
            if (!student.getRequests().isEmpty() || !CustomCourseRequestsHolder.hasProvider() || (request = CustomCourseRequestsHolder.getProvider().getCourseRequests(server, helper, student)) == null) break block27;
            CourseRequestInterface courseRequestInterface = request;
            Object var18_10 = null;
            lock.release();
            return courseRequestInterface;
        }
        try {
            request = new CourseRequestInterface();
            request.setStudentId(this.iStudentId);
            request.setSaved(true);
            request.setAcademicSessionId(server.getAcademicSession().getUniqueId());
            CourseRequestInterface.Request lastRequest = null;
            int lastRequestPriority = -1;
            boolean setReadOnly = ApplicationProperty.OnlineSchedulingMakeAssignedRequestReadOnly.isTrue();
            if (!setReadOnly && helper.getUser() != null && helper.getUser().getType() == OnlineSectioningLog.Entity.EntityType.MANAGER) {
                setReadOnly = ApplicationProperty.OnlineSchedulingMakeAssignedRequestReadOnlyIfAdmin.isTrue();
            }
            for (XRequest cd : student.getRequests()) {
                CourseRequestInterface.Request r = null;
                if (cd instanceof XFreeTimeRequest) {
                    XFreeTimeRequest ftr = (XFreeTimeRequest)cd;
                    CourseRequestInterface.FreeTime ft = new CourseRequestInterface.FreeTime();
                    ft.setStart(ftr.getTime().getSlot());
                    ft.setLength(ftr.getTime().getLength());
                    for (DayCode day : DayCode.toDayCodes(ftr.getTime().getDays())) {
                        ft.addDay(day.getIndex());
                    }
                    if (lastRequest != null && lastRequestPriority == cd.getPriority()) {
                        r = lastRequest;
                        lastRequest.addRequestedFreeTime(ft);
                        lastRequest.setRequestedCourse(lastRequest.getRequestedCourse() + ", " + ft.toString());
                    } else {
                        r = new CourseRequestInterface.Request();
                        r.addRequestedFreeTime(ft);
                        r.setRequestedCourse(ft.toString());
                        if (cd.isAlternative()) {
                            request.getAlternatives().add(r);
                        } else {
                            request.getCourses().add(r);
                        }
                    }
                } else if (cd instanceof XCourseRequest) {
                    r = new CourseRequestInterface.Request();
                    int order = 0;
                    for (XCourseId courseId : ((XCourseRequest)cd).getCourseIds()) {
                        XCourse c = server.getCourse(courseId.getCourseId());
                        if (c == null) continue;
                        switch (order) {
                            case 0: {
                                r.setRequestedCourse(c.getSubjectArea() + " " + c.getCourseNumber() + (c.hasUniqueName() && !CONSTANTS.showCourseTitle() ? "" : " - " + c.getTitle()));
                                break;
                            }
                            case 1: {
                                r.setFirstAlternative(c.getSubjectArea() + " " + c.getCourseNumber() + (c.hasUniqueName() && !CONSTANTS.showCourseTitle() ? "" : " - " + c.getTitle()));
                                break;
                            }
                            case 2: {
                                r.setSecondAlternative(c.getSubjectArea() + " " + c.getCourseNumber() + (c.hasUniqueName() && !CONSTANTS.showCourseTitle() ? "" : " - " + c.getTitle()));
                            }
                        }
                        ++order;
                    }
                    r.setWaitList(((XCourseRequest)cd).isWaitlist());
                    if (setReadOnly) {
                        r.setReadOnly(((XCourseRequest)cd).getEnrolledCourseIndex());
                    }
                    if (r.hasRequestedCourse()) {
                        if (cd.isAlternative()) {
                            request.getAlternatives().add(r);
                        } else {
                            request.getCourses().add(r);
                        }
                    }
                    lastRequest = r;
                    lastRequestPriority = cd.getPriority();
                }
                action.addRequest(OnlineSectioningHelper.toProto(cd));
            }
            CourseRequestInterface courseRequestInterface = request;
            Object var18_11 = null;
            lock.release();
            return courseRequestInterface;
        }
        catch (Throwable throwable) {
            Object var18_12 = null;
            lock.release();
            throw throwable;
        }
    }

    @Override
    public String name() {
        return "get-request";
    }
}

