/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import org.hibernate.Session;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.onlinesectioning.updates.ReloadStudent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class CheckEligibility
implements OnlineSectioningAction<OnlineSectioningInterface.EligibilityCheck> {
    private static final long serialVersionUID = 1L;
    protected static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    protected Long iStudentId;
    protected OnlineSectioningInterface.EligibilityCheck iCheck;
    protected boolean iCustomCheck = true;

    public CheckEligibility forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    public CheckEligibility withCheck(OnlineSectioningInterface.EligibilityCheck check) {
        this.iCheck = check;
        return this;
    }

    public CheckEligibility includeCustomCheck(boolean customCheck) {
        this.iCustomCheck = customCheck;
        return this;
    }

    private void logCheck(OnlineSectioningLog.Action.Builder action, OnlineSectioningInterface.EligibilityCheck check) {
        for (OnlineSectioningInterface.EligibilityCheck.EligibilityFlag f : OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.values()) {
            if (!check.hasFlag(f)) continue;
            action.addOptionBuilder().setKey(f.name().replace('_', ' ')).setValue("true");
        }
        if (check.hasMessage()) {
            action.addMessageBuilder().setText(check.getMessage()).setLevel(OnlineSectioningLog.Message.Level.WARN);
        }
        if (check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL)) {
            action.setResult(OnlineSectioningLog.Action.ResultType.TRUE);
        } else {
            action.setResult(OnlineSectioningLog.Action.ResultType.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OnlineSectioningInterface.EligibilityCheck execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (this.iCheck == null) {
            this.iCheck = new OnlineSectioningInterface.EligibilityCheck();
        }
        OnlineSectioningLog.Action.Builder action = helper.getAction();
        OnlineSectioningServer.Lock lock = this.iStudentId == null ? null : server.lockStudent(this.iStudentId, null, this.name());
        try {
            OnlineSectioningInterface.EligibilityCheck eligibilityCheck;
            try {
                boolean noenrl;
                Student student;
                XStudent xstudent;
                Session hibSession;
                block30: {
                    OnlineSectioningInterface.EligibilityCheck eligibilityCheck2;
                    block31: {
                        this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_USE_ASSISTANT, true);
                        if (this.iStudentId != null) {
                            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.iStudentId));
                        }
                        this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST, server.getAcademicSession().isSectioningEnabled() && CustomStudentEnrollmentHolder.isAllowWaitListing());
                        hibSession = StudentDAO.getInstance().createNewSession();
                        xstudent = null;
                        try {
                            Student student2 = student = this.iStudentId == null ? null : (Student)StudentDAO.getInstance().get(this.iStudentId, hibSession);
                            if (student != null) break block30;
                            if (!this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN) && !this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR) && !this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_GUEST) && server.getAcademicSession().isSectioningEnabled()) {
                                this.iCheck.setMessage(MSG.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
                                if (CustomStudentEnrollmentHolder.hasProvider() && CustomStudentEnrollmentHolder.getProvider().isCanRequestUpdates()) {
                                    hibSession.close();
                                    hibSession = null;
                                    CustomStudentEnrollmentHolder.getProvider().checkEligibility(server, helper, this.iCheck, new XStudent(null, helper.getUser().getExternalId(), helper.getUser().getName()));
                                }
                            }
                            this.logCheck(action, this.iCheck);
                            action.setResult(OnlineSectioningLog.Action.ResultType.NULL);
                            eligibilityCheck2 = this.iCheck;
                            Object var12_12 = null;
                            if (hibSession == null) break block31;
                        }
                        catch (Throwable throwable) {
                            Object var12_14 = null;
                            if (hibSession == null) throw throwable;
                            hibSession.close();
                            throw throwable;
                        }
                        hibSession.close();
                    }
                    Object var14_15 = null;
                    if (lock == null) return eligibilityCheck2;
                    lock.release();
                    return eligibilityCheck2;
                }
                action.getStudentBuilder().setExternalId(student.getExternalUniqueId());
                action.getStudentBuilder().setName(helper.getStudentNameFormat().format(student));
                StudentSectioningStatus status = student.getSectioningStatus();
                if (status == null) {
                    status = student.getSession().getDefaultSectioningStatus();
                }
                boolean disabled = status != null && !status.hasOption(StudentSectioningStatus.Option.enabled);
                boolean bl = noenrl = status != null && !status.hasOption(StudentSectioningStatus.Option.enrollment);
                if (noenrl && status.hasOption(StudentSectioningStatus.Option.admin) && this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN)) {
                    noenrl = false;
                }
                if (noenrl && status.hasOption(StudentSectioningStatus.Option.advisor) && this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR)) {
                    noenrl = false;
                }
                if (status != null && !status.hasOption(StudentSectioningStatus.Option.waitlist)) {
                    this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST, false);
                }
                if (disabled) {
                    this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_USE_ASSISTANT, false);
                }
                if (server.getAcademicSession().isSectioningEnabled()) {
                    if (!noenrl) {
                        this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, true);
                    }
                } else {
                    this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, false);
                }
                if (status != null && status.getMessage() != null) {
                    this.iCheck.setMessage(status.getMessage());
                } else if (disabled) {
                    this.iCheck.setMessage(MSG.exceptionAccessDisabled());
                } else if (noenrl) {
                    this.iCheck.setMessage(MSG.exceptionEnrollmentDisabled());
                }
                xstudent = server.getStudent(this.iStudentId);
                Object var12_13 = null;
                if (hibSession != null) {
                    hibSession.close();
                }
                if (xstudent == null && this.iStudentId != null) {
                    server.createAction(ReloadStudent.class).forStudents(this.iStudentId).execute(server, helper);
                    xstudent = server.getStudent(this.iStudentId);
                }
                if (xstudent == null) {
                    if (!this.iCheck.hasMessage()) {
                        this.iCheck.setMessage(MSG.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
                    }
                    this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, false);
                } else if (this.iCustomCheck && CustomStudentEnrollmentHolder.hasProvider()) {
                    CustomStudentEnrollmentHolder.getProvider().checkEligibility(server, helper, this.iCheck, xstudent);
                }
                this.logCheck(action, this.iCheck);
                eligibilityCheck = this.iCheck;
                Object var14_16 = null;
                if (lock == null) return eligibilityCheck;
            }
            catch (SectioningException e) {
                this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, false);
                this.iCheck.setMessage(MSG.exceptionFailedEligibilityCheck(e.getMessage()));
                helper.info(MSG.exceptionFailedEligibilityCheck(e.getMessage()));
                this.logCheck(action, this.iCheck);
                action.setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                OnlineSectioningInterface.EligibilityCheck eligibilityCheck3 = this.iCheck;
                Object var14_17 = null;
                if (lock == null) return eligibilityCheck3;
                lock.release();
                return eligibilityCheck3;
            }
            lock.release();
            return eligibilityCheck;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            if (lock == null) throw throwable;
            lock.release();
            throw throwable;
        }
    }

    @Override
    public String name() {
        return "eligibility";
    }
}

