/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassAssignmentInterface
implements IsSerializable,
Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<CourseAssignment> iAssignments = new ArrayList();
    private ArrayList<String> iMessages = null;
    private boolean iCanEnroll = true;
    private double iValue = 0.0;
    private CourseRequestInterface iRequest = null;

    public ArrayList<CourseAssignment> getCourseAssignments() {
        return this.iAssignments;
    }

    public void add(CourseAssignment a) {
        this.iAssignments.add(a);
    }

    public void clear() {
        this.iAssignments.clear();
        if (this.iMessages != null) {
            this.iMessages.clear();
        }
    }

    public void addMessage(String message) {
        if (this.iMessages == null) {
            this.iMessages = new ArrayList();
        }
        this.iMessages.add(message);
    }

    public boolean hasMessages() {
        return this.iMessages != null && !this.iMessages.isEmpty();
    }

    public ArrayList<String> getMessages() {
        return this.iMessages;
    }

    public String getMessages(String delim) {
        String ret = "";
        if (this.iMessages == null) {
            return ret;
        }
        for (String message : this.iMessages) {
            if (!ret.isEmpty()) {
                ret = ret + delim;
            }
            ret = ret + message;
        }
        return ret;
    }

    public boolean isCanEnroll() {
        return this.iCanEnroll;
    }

    public void setCanEnroll(boolean canEnroll) {
        this.iCanEnroll = canEnroll;
    }

    public double getValue() {
        return this.iValue;
    }

    public void setValue(double value) {
        this.iValue = value;
    }

    public boolean hasRequest() {
        return this.iRequest != null;
    }

    public void setRequest(CourseRequestInterface request) {
        this.iRequest = request;
    }

    public CourseRequestInterface getRequest() {
        return this.iRequest;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IdValue
    implements IsSerializable,
    Serializable,
    Comparable<IdValue> {
        private static final long serialVersionUID = 1L;
        private Long iId;
        private String iValue;

        public IdValue() {
        }

        public IdValue(Long id, String value) {
            this.iId = id;
            this.iValue = value;
        }

        public Long getId() {
            return this.iId;
        }

        public String getValue() {
            return this.iValue;
        }

        @Override
        public int compareTo(IdValue other) {
            return this.getValue().compareTo(other.getValue());
        }

        public String toString() {
            return this.getValue();
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof IdValue)) {
                return false;
            }
            return this.getId().equals(((IdValue)o).getId());
        }
    }

    public static class SectioningAction
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Student iStudent;
        private Date iTimeStamp;
        private String iOperation;
        private String iUser;
        private String iMessage;
        private String iProto;
        private String iResult;
        private Long iCpuTime;

        public Student getStudent() {
            return this.iStudent;
        }

        public void setStudent(Student student) {
            this.iStudent = student;
        }

        public Date getTimeStamp() {
            return this.iTimeStamp;
        }

        public void setTimeStamp(Date timeStamp) {
            this.iTimeStamp = timeStamp;
        }

        public String getOperation() {
            return this.iOperation;
        }

        public void setOperation(String operation) {
            this.iOperation = operation;
        }

        public String getUser() {
            return this.iUser;
        }

        public void setUser(String user) {
            this.iUser = user;
        }

        public String getMessage() {
            return this.iMessage;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public String getResult() {
            return this.iResult;
        }

        public void setResult(String result) {
            this.iResult = result;
        }

        public Long getCpuTime() {
            return this.iCpuTime;
        }

        public void setCpuTime(Long cpuTime) {
            this.iCpuTime = cpuTime;
        }

        public String getProto() {
            return this.iProto;
        }

        public void setProto(String proto) {
            this.iProto = proto;
        }
    }

    public static class StudentInfo
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Student iStudent;
        private Integer iEnrollment;
        private Integer iWaitlist;
        private Integer iReservation;
        private Integer iRequested;
        private Integer iUnassigned;
        private Integer iTotalEnrollment;
        private Integer iTotalWaitlist;
        private Integer iTotalReservation;
        private Integer iTotalUnassigned;
        private Integer iConsentNeeded;
        private Integer iTotalConsentNeeded;
        private Integer iTopWaitingPriority;
        private Date iRequestedDate = null;
        private Date iEnrolledDate = null;
        private Date iApprovedDate = null;
        private Date iEmailDate = null;
        private String iStatus;
        private Float iCredit;
        private Float iTotalCredit;

        public Student getStudent() {
            return this.iStudent;
        }

        public void setStudent(Student student) {
            this.iStudent = student;
        }

        public Integer getRequested() {
            return this.iRequested;
        }

        public void setRequested(Integer requested) {
            this.iRequested = requested;
        }

        public boolean hasRequested() {
            return this.iRequested != null;
        }

        public Integer getEnrollment() {
            return this.iEnrollment;
        }

        public void setEnrollment(Integer enrollment) {
            this.iEnrollment = enrollment;
        }

        public boolean hasEnrollment() {
            return this.iEnrollment != null;
        }

        public Integer getWaitlist() {
            return this.iWaitlist;
        }

        public void setWaitlist(Integer waitlist) {
            this.iWaitlist = waitlist;
        }

        public boolean hasWaitlist() {
            return this.iWaitlist != null;
        }

        public Integer getUnassigned() {
            return this.iUnassigned;
        }

        public void setUnassigned(Integer unassigned) {
            this.iUnassigned = unassigned;
        }

        public boolean hasUnassigned() {
            return this.iUnassigned != null;
        }

        public Integer getReservation() {
            return this.iReservation;
        }

        public void setReservation(Integer reservation) {
            this.iReservation = reservation;
        }

        public boolean hasReservation() {
            return this.iReservation != null;
        }

        public Integer getTotalEnrollment() {
            return this.iTotalEnrollment;
        }

        public void setTotalEnrollment(Integer enrollment) {
            this.iTotalEnrollment = enrollment;
        }

        public boolean hasTotalEnrollment() {
            return this.iTotalEnrollment != null;
        }

        public Integer getTotalWaitlist() {
            return this.iTotalWaitlist;
        }

        public void setTotalWaitlist(Integer waitlist) {
            this.iTotalWaitlist = waitlist;
        }

        public boolean hasTotalWaitlist() {
            return this.iTotalWaitlist != null;
        }

        public Integer getTotalUnassigned() {
            return this.iTotalUnassigned;
        }

        public void setTotalUnassigned(Integer unassigned) {
            this.iTotalUnassigned = unassigned;
        }

        public boolean hasTotalUnassigned() {
            return this.iTotalUnassigned != null;
        }

        public Integer getTotalReservation() {
            return this.iTotalReservation;
        }

        public void setTotalReservation(Integer reservation) {
            this.iTotalReservation = reservation;
        }

        public boolean hasTotalReservation() {
            return this.iTotalReservation != null;
        }

        public Integer getConsentNeeded() {
            return this.iConsentNeeded;
        }

        public void setConsentNeeded(Integer consentNeeded) {
            this.iConsentNeeded = consentNeeded;
        }

        public int hasConsentNeeded() {
            return this.iConsentNeeded;
        }

        public Integer getTotalConsentNeeded() {
            return this.iTotalConsentNeeded;
        }

        public void setTotalConsentNeeded(Integer totalConsentNeeded) {
            this.iTotalConsentNeeded = totalConsentNeeded;
        }

        public int hasTotalConsentNeeded() {
            return this.iTotalConsentNeeded;
        }

        public Integer getTopWaitingPriority() {
            return this.iTopWaitingPriority;
        }

        public void setTopWaitingPriority(Integer topWaitingPriority) {
            this.iTopWaitingPriority = topWaitingPriority;
        }

        public int hasTopWaitingPriority() {
            return this.iTopWaitingPriority;
        }

        public Date getRequestedDate() {
            return this.iRequestedDate;
        }

        public void setRequestedDate(Date ts) {
            this.iRequestedDate = ts;
        }

        public Date getEnrolledDate() {
            return this.iEnrolledDate;
        }

        public void setEnrolledDate(Date ts) {
            this.iEnrolledDate = ts;
        }

        public Date getApprovedDate() {
            return this.iApprovedDate;
        }

        public void setApprovedDate(Date ts) {
            this.iApprovedDate = ts;
        }

        public Date getEmailDate() {
            return this.iEmailDate;
        }

        public void setEmailDate(Date ts) {
            this.iEmailDate = ts;
        }

        public String getStatus() {
            return this.iStatus;
        }

        public void setStatus(String status) {
            this.iStatus = status;
        }

        public boolean hasCredit() {
            return this.iCredit != null && this.iCredit.floatValue() > 0.0f;
        }

        public void setCredit(Float credit) {
            this.iCredit = credit;
        }

        public Float getCredit() {
            return this.iCredit;
        }

        public boolean hasTotalCredit() {
            return this.iTotalCredit != null && this.iTotalCredit.floatValue() > 0.0f;
        }

        public void setTotalCredit(Float totalCredit) {
            this.iTotalCredit = totalCredit;
        }

        public Float getTotalCredit() {
            return this.iTotalCredit;
        }
    }

    public static class EnrollmentInfo
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iArea;
        private String iMajor;
        private String iClassification;
        private String iSubject;
        private String iCourseNbr;
        private String iConfig;
        private String iSubpart;
        private String iClazz;
        private String iTitle;
        private String iConsent;
        private Long iCourseId;
        private Long iOfferingId;
        private Long iSubjectId;
        private Long iConfigId;
        private Long iSubpartId;
        private Long iClazzId;
        private Integer iLimit;
        private Integer iOther;
        private Integer iProjection;
        private Integer iEnrollment;
        private Integer iWaitlist;
        private Integer iReservation;
        private Integer iAvailable;
        private Integer iUnassigned;
        private Integer iTotalEnrollment;
        private Integer iTotalWaitlist;
        private Integer iTotalReservation;
        private Integer iTotalUnassigned;
        private Integer iConsentNeeded;
        private Integer iTotalConsentNeeded;
        private ClassAssignment iAssignment;
        private int iLevel = 0;

        public String getArea() {
            return this.iArea;
        }

        public void setArea(String area) {
            this.iArea = area;
        }

        public String getMajor() {
            return this.iMajor;
        }

        public void setMajor(String major) {
            this.iMajor = major;
        }

        public String getClassification() {
            return this.iClassification;
        }

        public void setClassification(String classification) {
            this.iClassification = classification;
        }

        public String getSubject() {
            return this.iSubject;
        }

        public void setSubject(String subject) {
            this.iSubject = subject;
        }

        public String getCourseNbr() {
            return this.iCourseNbr;
        }

        public void setCourseNbr(String courseNbr) {
            this.iCourseNbr = courseNbr;
        }

        public String getTitle() {
            return this.iTitle;
        }

        public void setTitle(String title) {
            this.iTitle = title;
        }

        public String getConsent() {
            return this.iConsent;
        }

        public void setConsent(String consent) {
            this.iConsent = consent;
        }

        public Long getCourseId() {
            return this.iCourseId;
        }

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }

        public Long getOfferingId() {
            return this.iOfferingId;
        }

        public void setOfferingId(Long offeringId) {
            this.iOfferingId = offeringId;
        }

        public Long getSubjectId() {
            return this.iSubjectId;
        }

        public void setSubjectId(Long subjectId) {
            this.iSubjectId = subjectId;
        }

        public String getConfig() {
            return this.iConfig;
        }

        public void setConfig(String config) {
            this.iConfig = config;
        }

        public Long getConfigId() {
            return this.iConfigId;
        }

        public void setConfigId(Long configId) {
            this.iConfigId = configId;
        }

        public String getSubpart() {
            return this.iSubpart;
        }

        public void setSubpart(String subpart) {
            this.iSubpart = subpart;
        }

        public Long getSubpartId() {
            return this.iSubpartId;
        }

        public void setSubpartId(Long subpartId) {
            this.iSubpartId = subpartId;
        }

        public String getClazz() {
            return this.iClazz;
        }

        public void setClazz(String clazz) {
            this.iClazz = clazz;
        }

        public Long getClazzId() {
            return this.iClazzId;
        }

        public void setClazzId(Long clazzId) {
            this.iClazzId = clazzId;
        }

        public Integer getLimit() {
            return this.iLimit;
        }

        public void setLimit(Integer limit) {
            this.iLimit = limit;
        }

        public boolean hasLimit() {
            return this.iLimit != null;
        }

        public Integer getOther() {
            return this.iOther;
        }

        public void setOther(Integer other) {
            this.iOther = other;
        }

        public boolean hasOther() {
            return this.iOther != null;
        }

        public Integer getEnrollment() {
            return this.iEnrollment;
        }

        public void setEnrollment(Integer enrollment) {
            this.iEnrollment = enrollment;
        }

        public boolean hasEnrollment() {
            return this.iEnrollment != null;
        }

        public Integer getProjection() {
            return this.iProjection;
        }

        public void setProjection(Integer projection) {
            this.iProjection = projection;
        }

        public boolean hasProjection() {
            return this.iProjection != null;
        }

        public Integer getWaitlist() {
            return this.iWaitlist;
        }

        public void setWaitlist(Integer waitlist) {
            this.iWaitlist = waitlist;
        }

        public boolean hasWaitlist() {
            return this.iWaitlist != null;
        }

        public Integer getUnassigned() {
            return this.iUnassigned;
        }

        public void setUnassigned(Integer unassigned) {
            this.iUnassigned = unassigned;
        }

        public boolean hasUnassigned() {
            return this.iUnassigned != null;
        }

        public Integer getReservation() {
            return this.iReservation;
        }

        public void setReservation(Integer reservation) {
            this.iReservation = reservation;
        }

        public boolean hasReservation() {
            return this.iReservation != null;
        }

        public Integer getTotalEnrollment() {
            return this.iTotalEnrollment;
        }

        public void setTotalEnrollment(Integer enrollment) {
            this.iTotalEnrollment = enrollment;
        }

        public boolean hasTotalEnrollment() {
            return this.iTotalEnrollment != null;
        }

        public Integer getTotalWaitlist() {
            return this.iTotalWaitlist;
        }

        public void setTotalWaitlist(Integer waitlist) {
            this.iTotalWaitlist = waitlist;
        }

        public boolean hasTotalWaitlist() {
            return this.iTotalWaitlist != null;
        }

        public Integer getTotalUnassigned() {
            return this.iTotalUnassigned;
        }

        public void setTotalUnassigned(Integer unassigned) {
            this.iTotalUnassigned = unassigned;
        }

        public boolean hasTotalUnassigned() {
            return this.iTotalUnassigned != null;
        }

        public Integer getTotalReservation() {
            return this.iTotalReservation;
        }

        public void setTotalReservation(Integer reservation) {
            this.iTotalReservation = reservation;
        }

        public boolean hasTotalReservation() {
            return this.iTotalReservation != null;
        }

        public Integer getAvailable() {
            return this.iAvailable;
        }

        public void setAvailable(Integer available) {
            this.iAvailable = available;
        }

        public boolean hasAvailable() {
            return this.iAvailable != null;
        }

        public void setAssignment(ClassAssignment assignment) {
            this.iAssignment = assignment;
        }

        public ClassAssignment getAssignment() {
            return this.iAssignment;
        }

        public Integer getConsentNeeded() {
            return this.iConsentNeeded;
        }

        public void setConsentNeeded(Integer consentNeeded) {
            this.iConsentNeeded = consentNeeded;
        }

        public int hasConsentNeeded() {
            return this.iConsentNeeded;
        }

        public Integer getTotalConsentNeeded() {
            return this.iTotalConsentNeeded;
        }

        public void setTotalConsentNeeded(Integer totalConsentNeeded) {
            this.iTotalConsentNeeded = totalConsentNeeded;
        }

        public int hasTotalConsentNeeded() {
            return this.iTotalConsentNeeded;
        }

        public int getLevel() {
            return this.iLevel;
        }

        public void setLevel(int level) {
            this.iLevel = level;
        }

        public void incLevel() {
            ++this.iLevel;
        }

        public String getIndent() {
            String indent = "";
            for (int i = 0; i < this.iLevel; ++i) {
                indent = indent + "&nbsp;&nbsp;";
            }
            return indent;
        }
    }

    public static class Conflict
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iName;
        private String iType;
        private String iDate;
        private String iTime;
        private String iRoom;
        private String iStyle;

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getType() {
            return this.iType;
        }

        public void setType(String type) {
            this.iType = type;
        }

        public String getDate() {
            return this.iDate;
        }

        public void setDate(String date) {
            this.iDate = date;
        }

        public String getTime() {
            return this.iTime;
        }

        public void setTime(String time) {
            this.iTime = time;
        }

        public String getRoom() {
            return this.iRoom;
        }

        public void setRoom(String room) {
            this.iRoom = room;
        }

        public boolean hasStyle() {
            return this.iStyle != null && !this.iStyle.isEmpty();
        }

        public String getStyle() {
            return this.iStyle;
        }

        public void setStyle(String style) {
            this.iStyle = style;
        }

        public String toString() {
            return this.getName() + " " + this.getType() + " " + this.getDate() + " " + this.getTime() + " " + this.getRoom();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Enrollment
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Student iStudent;
        private CourseAssignment iCourse = null;
        private int iPriority = 0;
        private String iAlternative = null;
        private Date iRequestedDate = null;
        private Date iEnrolledDate = null;
        private Date iApprovedDate = null;
        private String iReservation = null;
        private String iApprovedBy = null;
        private List<Conflict> iConflicts = null;
        private Boolean iWaitList = null;
        private String iEnrollmentMessage = null;

        public Student getStudent() {
            return this.iStudent;
        }

        public void setStudent(Student student) {
            this.iStudent = student;
        }

        public CourseAssignment getCourse() {
            return this.iCourse;
        }

        public void setCourse(CourseAssignment course) {
            this.iCourse = course;
        }

        public int getPriority() {
            return this.iPriority;
        }

        public void setPriority(int priority) {
            this.iPriority = priority;
        }

        public boolean isAlternative() {
            return this.iAlternative != null;
        }

        public void setAlternative(String course) {
            this.iAlternative = course;
        }

        public String getAlternative() {
            return this.iAlternative == null ? "" : this.iAlternative;
        }

        public Date getRequestedDate() {
            return this.iRequestedDate;
        }

        public void setRequestedDate(Date ts) {
            this.iRequestedDate = ts;
        }

        public Date getEnrolledDate() {
            return this.iEnrolledDate;
        }

        public void setEnrolledDate(Date ts) {
            this.iEnrolledDate = ts;
        }

        public Date getApprovedDate() {
            return this.iApprovedDate;
        }

        public void setApprovedDate(Date ts) {
            this.iApprovedDate = ts;
        }

        public String getApprovedBy() {
            return this.iApprovedBy;
        }

        public void setApprovedBy(String approvedBy) {
            this.iApprovedBy = approvedBy;
        }

        public boolean hasWaitList() {
            return this.iWaitList != null;
        }

        public boolean isWaitList() {
            return this.iWaitList != null && this.iWaitList != false;
        }

        public void setWaitList(Boolean waitList) {
            this.iWaitList = waitList;
        }

        public String getClasses(String subpart, String delim, boolean showClassNumbers) {
            if (this.getCourse() == null || this.getCourse().getClassAssignments().isEmpty()) {
                return "";
            }
            String ret = "";
            TreeSet<String> sections = new TreeSet<String>();
            for (ClassAssignment c : this.getCourse().getClassAssignments()) {
                if (!subpart.equals(c.getSubpart())) continue;
                sections.add(showClassNumbers && c.getClassNumber() != null ? c.getClassNumber() : c.getSection());
            }
            for (String section : sections) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + section;
            }
            return ret;
        }

        public boolean hasClasses() {
            return this.getCourse() != null && !this.getCourse().getClassAssignments().isEmpty();
        }

        public List<ClassAssignment> getClasses() {
            return this.getCourse() == null ? null : this.getCourse().getClassAssignments();
        }

        public Long getCourseId() {
            return this.getCourse() == null ? null : this.getCourse().getCourseId();
        }

        public String getCourseName() {
            return this.getCourse() == null ? null : this.getCourse().getCourseName();
        }

        public String getReservation() {
            return this.iReservation;
        }

        public void setReservation(String reservation) {
            this.iReservation = reservation;
        }

        public boolean hasConflict() {
            return this.iConflicts != null && !this.iConflicts.isEmpty();
        }

        public void addConflict(Conflict conflict) {
            if (this.iConflicts == null) {
                this.iConflicts = new ArrayList<Conflict>();
            }
            this.iConflicts.add(conflict);
        }

        public List<Conflict> getConflicts() {
            return this.iConflicts;
        }

        public String getEnrollmentMessage() {
            return this.iEnrollmentMessage;
        }

        public boolean hasEnrollmentMessage() {
            return this.iEnrollmentMessage != null && !this.iEnrollmentMessage.isEmpty();
        }

        public void setEnrollmentMessage(String message) {
            this.iEnrollmentMessage = message;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Student
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private long iId;
        private Long iSessionId = null;
        private String iExternalId;
        private String iName;
        private List<String> iArea;
        private List<String> iClassification;
        private List<String> iMajor;
        private List<String> iGroup;
        private List<String> iAccommodation;
        private boolean iCanShowExternalId = false;
        private boolean iCanUseAssitant = false;
        private boolean iCanRegister = false;

        public void setId(long id) {
            this.iId = id;
        }

        public long getId() {
            return this.iId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public String getExternalId() {
            return this.iExternalId;
        }

        public void setExternalId(String externalId) {
            this.iExternalId = externalId;
        }

        public void setCanShowExternalId(boolean canShowExternalId) {
            this.iCanShowExternalId = canShowExternalId;
        }

        public boolean isCanShowExternalId() {
            return this.iExternalId != null && this.iCanShowExternalId;
        }

        public void setCanUseAssistant(boolean canUseAssistant) {
            this.iCanUseAssitant = canUseAssistant;
        }

        public boolean isCanUseAssistant() {
            return this.iCanUseAssitant;
        }

        public void setCanRegister(boolean canRegister) {
            this.iCanRegister = canRegister;
        }

        public boolean isCanRegister() {
            return this.iCanRegister;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public boolean hasArea() {
            return this.iArea != null && !this.iArea.isEmpty();
        }

        public String getArea(String delim) {
            if (this.iArea == null) {
                return "";
            }
            String ret = "";
            for (String area : this.iArea) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + area;
            }
            return ret;
        }

        public void addArea(String area) {
            if (this.iArea == null) {
                this.iArea = new ArrayList<String>();
            }
            this.iArea.add(area);
        }

        public List<String> getAreas() {
            return this.iArea;
        }

        public boolean hasClassification() {
            return this.iClassification != null && !this.iClassification.isEmpty();
        }

        public String getClassification(String delim) {
            if (this.iClassification == null) {
                return "";
            }
            String ret = "";
            for (String classification : this.iClassification) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + classification;
            }
            return ret;
        }

        public void addClassification(String classification) {
            if (this.iClassification == null) {
                this.iClassification = new ArrayList<String>();
            }
            this.iClassification.add(classification);
        }

        public List<String> getClassifications() {
            return this.iClassification;
        }

        public boolean hasMajor() {
            return this.iMajor != null && !this.iMajor.isEmpty();
        }

        public String getMajor(String delim) {
            if (this.iMajor == null) {
                return "";
            }
            String ret = "";
            for (String major : this.iMajor) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + major;
            }
            return ret;
        }

        public void addMajor(String major) {
            if (this.iMajor == null) {
                this.iMajor = new ArrayList<String>();
            }
            this.iMajor.add(major);
        }

        public List<String> getMajors() {
            return this.iMajor;
        }

        public boolean hasGroup() {
            return this.iGroup != null && !this.iGroup.isEmpty();
        }

        public String getGroup(String delim) {
            if (this.iGroup == null) {
                return "";
            }
            String ret = "";
            for (String group : this.iGroup) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + group;
            }
            return ret;
        }

        public void addGroup(String group) {
            if (this.iGroup == null) {
                this.iGroup = new ArrayList<String>();
            }
            this.iGroup.add(group);
        }

        public List<String> getGroups() {
            return this.iGroup;
        }

        public boolean hasAccommodation() {
            return this.iAccommodation != null && !this.iAccommodation.isEmpty();
        }

        public String getAccommodation(String delim) {
            if (this.iAccommodation == null) {
                return "";
            }
            String ret = "";
            for (String accommodation : this.iAccommodation) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + accommodation;
            }
            return ret;
        }

        public void addAccommodation(String accommodation) {
            if (this.iAccommodation == null) {
                this.iAccommodation = new ArrayList<String>();
            }
            this.iAccommodation.add(accommodation);
        }

        public List<String> getAccommodations() {
            return this.iAccommodation;
        }

        public String getCurriculum(String delim) {
            if (!this.hasArea()) {
                return "";
            }
            String ret = "";
            for (int i = 0; i < this.iArea.size(); ++i) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + this.iArea.get(i) + " " + this.iClassification.get(i);
                if (this.iMajor == null || i >= this.iMajor.size()) continue;
                ret = ret + " " + this.iMajor.get(i);
            }
            return ret;
        }

        public String getAreaClasf(String delim) {
            if (!this.hasArea()) {
                return "";
            }
            String ret = "";
            for (int i = 0; i < this.iArea.size(); ++i) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + this.iArea.get(i) + " " + this.iClassification.get(i);
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassAssignment
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private boolean iCourseAssigned = true;
        private Long iCourseId;
        private Long iClassId;
        private Long iSubpartId;
        private ArrayList<Integer> iDays = new ArrayList();
        private int iStart;
        private int iLength;
        private int iBreakTime = 0;
        private ArrayList<String> iInstructos = new ArrayList();
        private ArrayList<String> iInstructoEmails = new ArrayList();
        private ArrayList<IdValue> iRooms = new ArrayList();
        private boolean iAlternative = false;
        private boolean iHasAlternatives = true;
        private boolean iDistanceConflict = false;
        private String iDatePattern = null;
        private String iSubject;
        private String iCourseNbr;
        private String iSubpart;
        private String iSection;
        private String iParentSection;
        private String iNumber;
        private String iTitle;
        private int[] iLimit = null;
        private boolean iPin = false;
        private int iBackToBackDistance = 0;
        private String iBackToBackRooms = null;
        private boolean iSaved = false;
        private boolean iDummy = false;
        private boolean iCancelled = false;
        private Integer iExpected = null;
        private String iOverlapNote = null;
        private String iNote = null;
        private String iCredit = null;
        private String iError = null;
        private Date iEnrolledDate = null;

        public ClassAssignment() {
        }

        public ClassAssignment(CourseAssignment course) {
            this.iCourseId = course.getCourseId();
            this.iSubject = course.getSubject();
            this.iCourseNbr = course.getCourseNbr();
            this.iCourseAssigned = course.isAssigned();
            this.iTitle = course.getTitle();
        }

        public Long getCourseId() {
            return this.iCourseId;
        }

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }

        public boolean isFreeTime() {
            return this.iCourseId == null;
        }

        public boolean isCourseAssigned() {
            return this.iCourseAssigned;
        }

        public void setCourseAssigned(boolean courseAssigned) {
            this.iCourseAssigned = courseAssigned;
        }

        public String getSubject() {
            return this.iSubject;
        }

        public void setSubject(String subject) {
            this.iSubject = subject;
        }

        public String getCourseNbr() {
            return this.iCourseNbr;
        }

        public void setCourseNbr(String courseNbr) {
            this.iCourseNbr = courseNbr;
        }

        public String getCourseNbr(boolean includeTitle) {
            return this.getCourseNbr() + (includeTitle & this.hasTitle() ? " - " + this.getTitle() : "");
        }

        public String getTitle() {
            return this.iTitle;
        }

        public void setTitle(String title) {
            this.iTitle = title;
        }

        public boolean hasTitle() {
            return this.iTitle != null && !this.iTitle.isEmpty();
        }

        public String getSubpart() {
            return this.iSubpart;
        }

        public void setSubpart(String subpart) {
            this.iSubpart = subpart;
        }

        public String getSection() {
            return this.iSection;
        }

        public void setSection(String section) {
            this.iSection = section;
        }

        public String getParentSection() {
            return this.iParentSection;
        }

        public void setParentSection(String parentSection) {
            this.iParentSection = parentSection;
        }

        public boolean isAlternative() {
            return this.iAlternative;
        }

        public void setAlternative(boolean alternative) {
            this.iAlternative = alternative;
        }

        public Long getClassId() {
            return this.iClassId;
        }

        public void setClassId(Long classId) {
            this.iClassId = classId;
        }

        public Long getSubpartId() {
            return this.iSubpartId;
        }

        public void setSubpartId(Long subpartId) {
            this.iSubpartId = subpartId;
        }

        public void addDay(int day) {
            if (this.iDays == null) {
                this.iDays = new ArrayList();
            }
            this.iDays.add(day);
        }

        public ArrayList<Integer> getDays() {
            return this.iDays;
        }

        public String getDaysString(String[] shortDays, String separator) {
            if (this.iDays == null) {
                return "";
            }
            String ret = "";
            for (int day : this.iDays) {
                ret = ret + (ret.isEmpty() ? "" : separator) + shortDays[day];
            }
            return ret;
        }

        public String getDaysString(String[] shortDays) {
            return this.getDaysString(shortDays, "");
        }

        public boolean isAssigned() {
            return this.iDays != null && !this.iDays.isEmpty();
        }

        public int getStart() {
            return this.iStart;
        }

        public void setStart(int start) {
            this.iStart = start;
        }

        public String getStartString(boolean useAmPm) {
            if (!this.isAssigned()) {
                return "";
            }
            int h = this.iStart / 12;
            int m = 5 * (this.iStart % 12);
            if (useAmPm) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public String getStartStringAria(boolean useAmPm) {
            if (!this.isAssigned()) {
                return "";
            }
            int h = this.iStart / 12;
            int m = 5 * (this.iStart % 12);
            if (useAmPm) {
                return (h > 12 ? h - 12 : h) + (m == 0 ? "" : (m < 10 ? " 0" : " ") + m) + (h == 24 ? " AM" : (h >= 12 ? " PM" : " AM"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public int getLength() {
            return this.iLength;
        }

        public void setLength(int length) {
            this.iLength = length;
        }

        public String getEndString(boolean useAmPm) {
            if (!this.isAssigned()) {
                return "";
            }
            int h = (5 * (this.iStart + this.iLength) - this.iBreakTime) / 60;
            int m = (5 * (this.iStart + this.iLength) - this.iBreakTime) % 60;
            if (useAmPm) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public String getEndStringAria(boolean useAmPm) {
            if (!this.isAssigned()) {
                return "";
            }
            int h = (5 * (this.iStart + this.iLength) - this.iBreakTime) / 60;
            int m = (5 * (this.iStart + this.iLength) - this.iBreakTime) % 60;
            if (useAmPm) {
                return (h > 12 ? h - 12 : h) + (m == 0 ? "" : (m < 10 ? " 0" : " ") + m) + (h == 24 ? " AM" : (h >= 12 ? " PM" : " AM"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public String getTimeString(String[] shortDays, boolean useAmPm, String arrangeHours) {
            if (!this.isAssigned()) {
                return this.iClassId == null ? "" : arrangeHours;
            }
            return this.getDaysString(shortDays) + " " + this.getStartString(useAmPm) + " - " + this.getEndString(useAmPm);
        }

        public String getTimeStringAria(String[] longDays, boolean useAmPm, String arrangeHours) {
            if (!this.isAssigned()) {
                return this.iClassId == null ? "" : arrangeHours;
            }
            int h = this.iStart / 12;
            int m = 5 * (this.iStart % 12);
            String ret = this.getDaysString(longDays, " ") + " from ";
            ret = useAmPm ? ret + (h > 12 ? h - 12 : h) + (m == 0 ? "" : (m < 10 ? " 0" : " ") + m) + (h == 24 ? " AM" : (h >= 12 ? " PM" : " AM")) : ret + h + " " + (m < 10 ? "0" : "") + m;
            h = (this.iStart + this.iLength) / 12;
            m = 5 * ((this.iStart + this.iLength) % 12);
            ret = ret + " to ";
            ret = useAmPm ? ret + (h > 12 ? h - 12 : h) + (m == 0 ? "" : (m < 10 ? " 0" : " ") + m) + (h == 24 ? " AM" : (h >= 12 ? " PM" : " AM")) : ret + h + " " + (m < 10 ? "0" : "") + m;
            return ret;
        }

        public int getBreakTime() {
            return this.iBreakTime;
        }

        public void setBreakTime(int breakTime) {
            this.iBreakTime = breakTime;
        }

        public boolean hasDatePattern() {
            return this.iDatePattern != null && !this.iDatePattern.isEmpty();
        }

        public String getDatePattern() {
            return this.iDatePattern;
        }

        public void setDatePattern(String datePattern) {
            this.iDatePattern = datePattern;
        }

        public boolean hasInstructors() {
            return this.iInstructos != null && !this.iInstructos.isEmpty();
        }

        public void addInstructor(String instructor) {
            if (this.iInstructos == null) {
                this.iInstructos = new ArrayList();
            }
            this.iInstructos.add(instructor);
        }

        public ArrayList<String> getInstructors() {
            return this.iInstructos;
        }

        public String getInstructors(String delim) {
            if (this.iInstructos == null) {
                return "";
            }
            String ret = "";
            for (String instructor : this.iInstructos) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + instructor;
            }
            return ret;
        }

        public String getInstructorWithEmails(String delim) {
            if (this.iInstructos == null) {
                return "";
            }
            String ret = "";
            for (int i = 0; i < this.iInstructos.size(); ++i) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                String email = this.iInstructoEmails != null && i < this.iInstructoEmails.size() ? this.iInstructoEmails.get(i) : null;
                ret = email != null && !email.isEmpty() ? ret + "<A class=\"unitime-SimpleLink\" href=\"mailto:" + email + "\">" + this.iInstructos.get(i) + "</A>" : ret + this.iInstructos.get(i);
            }
            return ret;
        }

        public boolean hasInstructorEmails() {
            return this.iInstructoEmails != null && !this.iInstructoEmails.isEmpty();
        }

        public void addInstructoEmail(String instructorEmail) {
            if (this.iInstructoEmails == null) {
                this.iInstructoEmails = new ArrayList();
            }
            this.iInstructoEmails.add(instructorEmail == null ? "" : instructorEmail);
        }

        public ArrayList<String> getInstructorEmails() {
            return this.iInstructoEmails;
        }

        public boolean hasRoom() {
            return this.iRooms != null && !this.iRooms.isEmpty();
        }

        public void addRoom(Long id, String name) {
            if (this.iRooms == null) {
                this.iRooms = new ArrayList();
            }
            this.iRooms.add(new IdValue(id, name));
        }

        public ArrayList<IdValue> getRooms() {
            return this.iRooms;
        }

        public String getRooms(String delim) {
            if (this.iRooms == null) {
                return "";
            }
            String ret = "";
            for (IdValue room : this.iRooms) {
                if (!ret.isEmpty()) {
                    ret = ret + delim;
                }
                ret = ret + room.getValue();
            }
            return ret;
        }

        public boolean isUnlimited() {
            return this.iLimit != null && this.iLimit[1] >= 9999;
        }

        public int[] getLimit() {
            return this.iLimit;
        }

        public void setLimit(int[] limit) {
            this.iLimit = limit;
        }

        public String getLimitString() {
            if (this.iLimit == null) {
                return "";
            }
            if (this.iLimit[1] >= 9999 || this.iLimit[1] < 0) {
                return "&infin;";
            }
            if (this.iLimit[0] < 0) {
                return String.valueOf(this.iLimit[1]);
            }
            return (this.iLimit[1] > this.iLimit[0] ? this.iLimit[1] - this.iLimit[0] : 0) + " / " + this.iLimit[1];
        }

        public boolean isAvailable() {
            if (this.iLimit == null) {
                return true;
            }
            if (this.iLimit[0] < 0) {
                return this.iLimit[1] != 0;
            }
            return this.iLimit[0] < this.iLimit[1];
        }

        public int getAvailableLimit() {
            if (this.iLimit == null) {
                return 9999;
            }
            if (this.iLimit[0] < 0) {
                return 9999;
            }
            return this.iLimit[1] - this.iLimit[0];
        }

        public boolean isPinned() {
            return this.iPin;
        }

        public void setPinned(boolean pin) {
            this.iPin = pin;
        }

        public boolean hasAlternatives() {
            return this.iHasAlternatives;
        }

        public void setHasAlternatives(boolean alternatives) {
            this.iHasAlternatives = alternatives;
        }

        public boolean hasDistanceConflict() {
            return this.iDistanceConflict;
        }

        public void setDistanceConflict(boolean distanceConflict) {
            this.iDistanceConflict = distanceConflict;
        }

        public int getBackToBackDistance() {
            return this.iBackToBackDistance;
        }

        public void setBackToBackDistance(int backToBackDistance) {
            this.iBackToBackDistance = backToBackDistance;
        }

        public String getBackToBackRooms() {
            return this.iBackToBackRooms;
        }

        public void setBackToBackRooms(String backToBackRooms) {
            this.iBackToBackRooms = backToBackRooms;
        }

        public boolean isSaved() {
            return this.iSaved;
        }

        public void setSaved(boolean saved) {
            this.iSaved = saved;
        }

        public boolean isDummy() {
            return this.iDummy;
        }

        public void setDummy(boolean dummy) {
            this.iDummy = dummy;
        }

        public boolean isCancelled() {
            return this.iCancelled;
        }

        public void setCancelled(boolean cancelled) {
            this.iCancelled = cancelled;
        }

        public void setError(String error) {
            this.iError = error;
        }

        public boolean hasError() {
            return this.iError != null && !this.iError.isEmpty();
        }

        public String getError() {
            return this.iError;
        }

        public void setExpected(Integer expected) {
            this.iExpected = expected;
        }

        public boolean hasExpected() {
            return this.iExpected != null;
        }

        public int getExpected() {
            return this.iExpected == null ? 0 : this.iExpected;
        }

        public boolean isOfHighDemand() {
            return this.isAvailable() && !this.isUnlimited() && this.hasExpected() && this.getExpected() + (this.isSaved() ? -1 : 0) >= this.getAvailableLimit();
        }

        public String toString() {
            return (this.isFreeTime() ? "Free Time" : this.getSubpart() + " " + this.getSection()) + (this.isAssigned() ? " " + this.getTimeString(new String[]{"M", "T", "W", "R", "F", "S", "X"}, true, "") : "") + (this.hasRoom() ? " " + this.getRooms(",") : "") + (this.isSaved() || this.isPinned() || this.isOfHighDemand() || this.hasAlternatives() || this.hasDistanceConflict() || this.isUnlimited() ? "[" + (this.isSaved() ? "s" : "") + (this.isPinned() ? "p" : "") + (this.isOfHighDemand() ? "h" : "") + (this.hasAlternatives() ? "a" : "") + (this.hasDistanceConflict() ? "d" : "") + (this.isUnlimited() ? "u" : "") + (this.isCancelled() ? "c" : "") + "]" : "");
        }

        public String getClassNumber() {
            return this.iNumber;
        }

        public void setClassNumber(String number) {
            this.iNumber = number;
        }

        public boolean hasNote() {
            return this.iNote != null && !this.iNote.isEmpty();
        }

        public String getNote() {
            return this.iNote == null ? "" : this.iNote;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public void addNote(String note) {
            this.addNote(note, "\n");
        }

        public void addNote(String note, String separator) {
            if (note == null || note.isEmpty()) {
                return;
            }
            if (this.iNote == null || this.iNote.isEmpty()) {
                this.iNote = note;
            } else {
                this.iNote = separator == null ? (this.iNote.endsWith(".") || this.iNote.endsWith(",") ? this.iNote + " " : this.iNote + "; ") : this.iNote + separator;
                this.iNote = this.iNote + note;
            }
        }

        public void setOverlapNote(String note) {
            this.iOverlapNote = note;
        }

        public boolean hasOverlapNote() {
            return this.iOverlapNote != null && !this.iOverlapNote.isEmpty();
        }

        public String getOverlapNote() {
            return this.iOverlapNote;
        }

        public String getOverlapAndNote(String overlapStyle) {
            String ret = "";
            if (this.hasOverlapNote()) {
                ret = ret + (overlapStyle != null ? "<span class='" + overlapStyle + "'>" + this.getOverlapNote() + "</span>" : this.getOverlapNote());
            }
            if (this.hasNote()) {
                if (!ret.isEmpty()) {
                    ret = ret + (overlapStyle == null ? "\n" : "<br>");
                }
                ret = ret + (overlapStyle == null ? this.getNote() : this.getNote().replace("\n", "<br>"));
            }
            return ret;
        }

        public boolean hasCredit() {
            return this.iCredit != null && !this.iCredit.isEmpty();
        }

        public String getCredit() {
            return this.iCredit == null ? "" : this.iCredit;
        }

        public void setCredit(String credit) {
            this.iCredit = credit;
        }

        public float guessCreditCount() {
            if (!this.hasCredit()) {
                return 0.0f;
            }
            MatchResult m = RegExp.compile((String)"\\d+\\.?\\d*").exec(this.getCredit());
            if (m != null) {
                return Float.parseFloat(m.getGroup(0));
            }
            return 0.0f;
        }

        public String getCourseName() {
            return this.isFreeTime() ? "Free Time" : this.getSubject() + " " + this.getCourseNbr();
        }

        public String getCourseNameWithTitle() {
            return this.isFreeTime() ? "Free Time" : (this.hasTitle() ? this.getSubject() + " " + this.getCourseNbr() + " - " + this.getTitle() : this.getSubject() + " " + this.getCourseNbr());
        }

        public boolean equalsIgnoreCase(String requestedCourse) {
            return this.getCourseName().equalsIgnoreCase(requestedCourse) || this.getCourseNameWithTitle().equalsIgnoreCase(requestedCourse);
        }

        public Date getEnrolledDate() {
            return this.iEnrolledDate;
        }

        public void setEnrolledDate(Date ts) {
            this.iEnrolledDate = ts;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CourseAssignment
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iCourseId = null;
        private boolean iAssigned = true;
        private String iSubject;
        private String iCourseNbr;
        private String iTitle;
        private String iNote;
        private String iCreditText = null;
        private String iCreditAbbv = null;
        private boolean iHasUniqueName = true;
        private Integer iLimit = null;
        private Integer iProjected = null;
        private Integer iEnrollment = null;
        private Integer iLastLike = null;
        private ArrayList<String> iOverlaps = null;
        private boolean iNotAvailable = false;
        private boolean iFull = false;
        private boolean iLocked = false;
        private String iInstead;
        private boolean iWaitListed = false;
        private String iEnrollmentMessage = null;
        private Date iRequestedDate = null;
        private ArrayList<ClassAssignment> iAssignments = new ArrayList();

        public Long getCourseId() {
            return this.iCourseId;
        }

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }

        public boolean isFreeTime() {
            return this.iCourseId == null;
        }

        public boolean isAssigned() {
            return this.iAssigned;
        }

        public void setAssigned(boolean assigned) {
            this.iAssigned = assigned;
        }

        public String getSubject() {
            return this.iSubject;
        }

        public void setSubject(String subject) {
            this.iSubject = subject;
        }

        public String getCourseNbr() {
            return this.iCourseNbr;
        }

        public void setCourseNbr(String courseNbr) {
            this.iCourseNbr = courseNbr;
        }

        public String getCourseNbr(boolean includeTitle) {
            return this.getCourseNbr() + (includeTitle & this.hasTitle() ? " - " + this.getTitle() : "");
        }

        public String getCourseName() {
            return this.isFreeTime() ? "Free Time" : this.getSubject() + " " + this.getCourseNbr();
        }

        public String getCourseNameWithTitle() {
            return this.isFreeTime() ? "Free Time" : (this.hasTitle() ? this.getSubject() + " " + this.getCourseNbr() + " - " + this.getTitle() : this.getSubject() + " " + this.getCourseNbr());
        }

        public boolean equalsIgnoreCase(String requestedCourse) {
            return this.getCourseName().equalsIgnoreCase(requestedCourse) || this.getCourseNameWithTitle().equalsIgnoreCase(requestedCourse);
        }

        public String getTitle() {
            return this.iTitle;
        }

        public void setTitle(String title) {
            this.iTitle = title;
        }

        public boolean hasTitle() {
            return this.iTitle != null && !this.iTitle.isEmpty();
        }

        public String getNote() {
            return this.iNote;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public boolean hasCredit() {
            return this.iCreditAbbv != null && !this.iCreditAbbv.isEmpty();
        }

        public String getCreditText() {
            return this.iCreditText;
        }

        public void setCreditText(String creditText) {
            this.iCreditText = creditText;
        }

        public String getCreditAbbv() {
            return this.iCreditAbbv;
        }

        public void setCreditAbbv(String creditAbbv) {
            this.iCreditAbbv = creditAbbv;
        }

        public String getCredit() {
            return this.hasCredit() ? this.getCreditAbbv() + "|" + this.getCreditText() : null;
        }

        public float guessCreditCount() {
            if (!this.hasCredit()) {
                return 0.0f;
            }
            MatchResult m = RegExp.compile((String)"\\d+\\.?\\d*").exec(this.getCreditAbbv());
            if (m != null) {
                return Float.parseFloat(m.getGroup(0));
            }
            return 0.0f;
        }

        public boolean hasUniqueName() {
            return this.iHasUniqueName;
        }

        public void setHasUniqueName(boolean hasUniqueName) {
            this.iHasUniqueName = hasUniqueName;
        }

        public void addOverlap(String overlap) {
            if (this.iOverlaps == null) {
                this.iOverlaps = new ArrayList();
            }
            if (!this.iOverlaps.contains(overlap)) {
                this.iOverlaps.add(overlap);
            }
        }

        public ArrayList<String> getOverlaps() {
            return this.iOverlaps;
        }

        public boolean isNotAvailable() {
            return this.iNotAvailable;
        }

        public void setNotAvailable(boolean notAvailable) {
            this.iNotAvailable = notAvailable;
        }

        public boolean isFull() {
            return this.iFull;
        }

        public void setFull(boolean full) {
            this.iFull = full;
        }

        public boolean isLocked() {
            return this.iLocked;
        }

        public void setLocked(boolean locked) {
            this.iLocked = locked;
        }

        public void setInstead(String instead) {
            this.iInstead = instead;
        }

        public String getInstead() {
            return this.iInstead;
        }

        public ArrayList<ClassAssignment> getClassAssignments() {
            return this.iAssignments;
        }

        public ClassAssignment addClassAssignment() {
            ClassAssignment a = new ClassAssignment(this);
            this.iAssignments.add(a);
            return a;
        }

        public Integer getLimit() {
            return this.iLimit;
        }

        public void setLimit(Integer limit) {
            this.iLimit = limit;
        }

        public String getLimitString() {
            if (this.iLimit == null) {
                return "";
            }
            if (this.iLimit < 0) {
                return "&infin;";
            }
            return this.iLimit.toString();
        }

        public Integer getProjected() {
            return this.iProjected;
        }

        public void setProjected(Integer projected) {
            this.iProjected = projected;
        }

        public String getProjectedString() {
            if (this.iProjected == null || this.iProjected == 0) {
                return "";
            }
            if (this.iProjected < 0) {
                return "&infin;";
            }
            return this.iProjected.toString();
        }

        public Integer getLastLike() {
            return this.iLastLike;
        }

        public void setLastLike(Integer lastLike) {
            this.iLastLike = lastLike;
        }

        public String getLastLikeString() {
            if (this.iLastLike == null || this.iLastLike == 0) {
                return "";
            }
            if (this.iLastLike < 0) {
                return "&infin;";
            }
            return this.iLastLike.toString();
        }

        public Integer getEnrollment() {
            return this.iEnrollment;
        }

        public void setEnrollment(Integer enrollment) {
            this.iEnrollment = enrollment;
        }

        public String getEnrollmentString() {
            if (this.iEnrollment == null || this.iEnrollment == 0) {
                return "";
            }
            if (this.iEnrollment < 0) {
                return "&infin;";
            }
            return this.iEnrollment.toString();
        }

        public boolean isWaitListed() {
            return this.iWaitListed;
        }

        public void setWaitListed(boolean waitListed) {
            this.iWaitListed = waitListed;
        }

        public String getEnrollmentMessage() {
            return this.iEnrollmentMessage;
        }

        public boolean hasEnrollmentMessage() {
            return this.iEnrollmentMessage != null && !this.iEnrollmentMessage.isEmpty();
        }

        public void setEnrollmentMessage(String message) {
            this.iEnrollmentMessage = message;
        }

        public String toString() {
            return (this.isFreeTime() ? "Free Time" : this.getSubject() + " " + this.getCourseNbr()) + ": " + (this.isAssigned() ? this.getClassAssignments() : "NOT ASSIGNED");
        }

        public Date getRequestedDate() {
            return this.iRequestedDate;
        }

        public void setRequestedDate(Date ts) {
            this.iRequestedDate = ts;
        }
    }
}

