/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeTextBox;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;

public class UniTimeConfirmationDialog
extends UniTimeDialogBox {
    protected static GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private String iAnswer = null;
    private UniTimeTextBox iTextBox = null;
    private AriaButton iYes;
    private AriaButton iNo;
    private Command iCommand;
    private P iError = null;

    protected UniTimeConfirmationDialog(boolean alert, String message, String question, String answer, Command command) {
        super(true, true);
        this.setText(alert ? MESSAGES.dialogAlert() : MESSAGES.dialogConfirmation());
        this.iAnswer = answer;
        this.iCommand = command;
        P panel = new P("unitime-ConfirmationPanel");
        this.setEscapeToHide(true);
        this.setEnterToSubmit(new Command(){

            public void execute() {
                if (UniTimeConfirmationDialog.this.iNo != null && UniTimeConfirmationDialog.this.iNo.isFocused()) {
                    return;
                }
                UniTimeConfirmationDialog.this.submit();
            }
        });
        P bd = new P("body-panel");
        panel.add((Widget)bd);
        P ic = new P("icon-panel");
        bd.add((Widget)ic);
        ic.add((Widget)new Image(alert ? RESOURCES.alert() : RESOURCES.confirm()));
        P cp = new P("content-panel");
        bd.add((Widget)cp);
        if (message != null && !message.isEmpty()) {
            P mp = new P("message-panel");
            cp.add((Widget)mp);
            P m = new P("message");
            m.setText(message);
            mp.add((Widget)m);
        }
        if (question != null) {
            P qp = new P("question-panel");
            cp.add((Widget)qp);
            P q = new P("question");
            q.setText(question);
            qp.add((Widget)q);
            this.iError = new P("error");
            this.iTextBox = new UniTimeTextBox();
            this.iTextBox.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    UniTimeConfirmationDialog.this.iError.setText("");
                }
            });
            this.iTextBox.addStyleName("answer");
            qp.add((Widget)this.iTextBox);
        }
        if (this.iError != null) {
            P ep = new P("error-panel");
            cp.add((Widget)ep);
            ep.add((Widget)this.iError);
        }
        P bp = new P("buttons-panel");
        panel.add((Widget)bp);
        this.iYes = new AriaButton(alert ? MESSAGES.buttonConfirmOK() : MESSAGES.buttonConfirmYes());
        this.iYes.addStyleName("yes");
        bp.add((Widget)this.iYes);
        this.iYes.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                UniTimeConfirmationDialog.this.submit();
            }
        });
        if (!alert) {
            this.iNo = new AriaButton(MESSAGES.buttonConfirmNo());
            this.iNo.addStyleName("no");
            bp.add((Widget)this.iNo);
            this.iNo.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    UniTimeConfirmationDialog.this.hide();
                }
            });
        }
        this.setWidget((Widget)panel);
    }

    public void center() {
        super.center();
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                if (UniTimeConfirmationDialog.this.iTextBox != null) {
                    UniTimeConfirmationDialog.this.iTextBox.setFocus(true);
                    UniTimeConfirmationDialog.this.iTextBox.selectAll();
                } else {
                    UniTimeConfirmationDialog.this.iYes.setFocus(true);
                }
            }
        });
    }

    protected void submit() {
        if (this.iTextBox != null) {
            if (this.iTextBox.getText().equalsIgnoreCase(this.iAnswer)) {
                this.hide();
                if (this.iCommand != null) {
                    this.iCommand.execute();
                }
            } else {
                this.iError.setText(MESSAGES.confirmationWrongAnswer(this.iAnswer));
            }
        } else {
            this.hide();
            if (this.iCommand != null) {
                this.iCommand.execute();
            }
        }
    }

    public static void alert(String message) {
        new UniTimeConfirmationDialog(true, message, null, null, null).center();
    }

    public static void alert(boolean useDefault, String message) {
        if (useDefault) {
            Window.alert((String)message);
        } else {
            UniTimeConfirmationDialog.alert(message);
        }
    }

    public static void confirm(String message, Command callback) {
        new UniTimeConfirmationDialog(false, message, null, null, callback).center();
    }

    public static void confirm(boolean useDefault, String message, Command callback) {
        if (useDefault) {
            if (Window.confirm((String)message)) {
                callback.execute();
            }
        } else {
            UniTimeConfirmationDialog.confirm(message, callback);
        }
    }

    public static void confirm(String message, String question, String answer, Command callback) {
        new UniTimeConfirmationDialog(false, message, question, answer, callback).center();
    }

    public static native void fireCallback(JavaScriptObject var0);

    public static void _confirm(String message, final JavaScriptObject callback, String question, String answer) {
        new UniTimeConfirmationDialog(callback == null, message, question, answer, callback == null ? null : new Command(){

            public void execute() {
                UniTimeConfirmationDialog.fireCallback(callback);
            }
        }).center();
    }

    public static native void createTriggers();
}

