/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.reservations;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.reservations.ReservationCookie;
import org.unitime.timetable.gwt.client.widgets.ServerDateTimeFormat;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.services.ReservationService;
import org.unitime.timetable.gwt.services.ReservationServiceAsync;
import org.unitime.timetable.gwt.shared.ReservationInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReservationTable
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    public static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private final ReservationServiceAsync iReservationService = (ReservationServiceAsync)GWT.create(ReservationService.class);
    private static DateTimeFormat sDF = ServerDateTimeFormat.getFormat(CONSTANTS.eventDateFormat());
    private Long iOfferingId = null;
    private SimpleForm iReservationPanel;
    private UniTimeTable<ReservationInterface> iReservations;
    private UniTimeHeaderPanel iHeader;
    private AsyncCallback<List<ReservationInterface>> iLoadCallback = null;
    private List<ReservationClickHandler> iReservationClickHandlers = new ArrayList<ReservationClickHandler>();
    private ReservationInterface.ReservationFilterRpcRequest iLastQuery = null;

    public ReservationTable(boolean editable, boolean showHeader) {
        this.iReservationPanel = new SimpleForm();
        this.iReservationPanel.removeStyleName("unitime-NotPrintableBottomLine");
        this.iHeader = new UniTimeHeaderPanel(showHeader ? MESSAGES.sectReservations() : "");
        this.iHeader.setCollapsible(showHeader ? Boolean.valueOf(ReservationCookie.getInstance().getReservationCoursesDetails()) : null);
        this.iHeader.setTitleStyleName("unitime3-HeaderTitle");
        this.iHeader.addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                ReservationCookie.getInstance().setReservationCoursesDetails((Boolean)event.getValue());
                if (ReservationTable.this.iReservations.getRowCount() == 0) {
                    ReservationTable.this.refresh();
                } else if (ReservationTable.this.iReservations.getRowCount() > 2) {
                    for (int row = 1; row < ReservationTable.this.iReservations.getRowCount() - 1; ++row) {
                        ReservationTable.this.iReservations.getRowFormatter().setVisible(row, ((Boolean)event.getValue()).booleanValue());
                    }
                }
            }
        });
        if (showHeader) {
            this.iReservationPanel.addHeaderRow((Widget)this.iHeader);
            this.iHeader.getElement().getStyle().setMarginTop(10.0, Style.Unit.PX);
            if (editable) {
                this.iHeader.addButton("add", MESSAGES.buttonAddReservation(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "gwt.jsp?page=reservation&offering=" + ReservationTable.this.iOfferingId);
                    }
                });
            }
        }
        this.iReservations = new UniTimeTable();
        this.iReservationPanel.addRow((Widget)this.iReservations);
        if (!showHeader) {
            this.iReservationPanel.addRow((Widget)this.iHeader);
        }
        this.initWidget((Widget)this.iReservationPanel);
        if (editable) {
            this.iReservations.addMouseClickListener(new UniTimeTable.MouseClickListener<ReservationInterface>(){

                @Override
                public void onMouseClick(UniTimeTable.TableEvent<ReservationInterface> event) {
                    if (event.getData() != null && event.getData().isEditable()) {
                        ReservationClickedEvent e = new ReservationClickedEvent(event.getData());
                        for (ReservationClickHandler h : ReservationTable.this.iReservationClickHandlers) {
                            h.onClick(e);
                        }
                    }
                }
            });
        }
    }

    private void initCallbacks() {
        if (this.iLoadCallback == null) {
            this.iLoadCallback = new AsyncCallback<List<ReservationInterface>>(){

                public void onFailure(Throwable caught) {
                    ReservationTable.this.iHeader.setErrorMessage(MESSAGES.failedToLoadReservations(caught.getMessage()));
                    ReservationTable.this.iHeader.setCollapsible(null);
                    ReservationCookie.getInstance().setReservationCoursesDetails(false);
                }

                public void onSuccess(List<ReservationInterface> result) {
                    if (result.isEmpty()) {
                        ReservationTable.this.iHeader.setMessage(MESSAGES.hintOfferingHasNoReservations());
                        ReservationTable.this.iHeader.setCollapsible(null);
                    } else {
                        ReservationTable.this.populate(result);
                        if (ReservationTable.this.iReservations.getRowCount() > 2) {
                            for (int row = 1; row < ReservationTable.this.iReservations.getRowCount() - 1; ++row) {
                                ReservationTable.this.iReservations.getRowFormatter().setVisible(row, ReservationCookie.getInstance().getReservationCoursesDetails());
                            }
                        }
                        ReservationTable.this.iHeader.clearMessage();
                    }
                }
            };
        }
    }

    private void refresh() {
        this.clear(true);
        if (this.iOfferingId != null) {
            this.iReservationService.getReservations(this.iOfferingId, this.iLoadCallback);
        } else {
            this.query(this.iLastQuery, null);
        }
    }

    private void clear(boolean loading) {
        for (int row = this.iReservations.getRowCount() - 1; row >= 0; --row) {
            this.iReservations.removeRow(row);
        }
        this.iReservations.clear(true);
        if (loading) {
            this.iHeader.showLoading();
        } else {
            this.iHeader.clearMessage();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void populate(List<ReservationInterface> reservations) {
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        for (final ReservationColumn column : ReservationColumn.values()) {
            if (column == ReservationColumn.OFFERING && this.iOfferingId != null) continue;
            final UniTimeTableHeader h = new UniTimeTableHeader(this.getColumnName(column));
            h.setWidth(this.getColumnWidth(column));
            final Comparator<ReservationInterface> cmp = column.getComparator();
            if (cmp != null) {
                h.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        ReservationTable.this.iReservations.sort(h, cmp);
                        ReservationCookie.getInstance().setSortBy(h.getOrder() != false ? 1 + column.ordinal() : -1 - column.ordinal());
                    }

                    public boolean isApplicable() {
                        return true;
                    }

                    public boolean hasSeparator() {
                        return false;
                    }

                    public String getName() {
                        return MESSAGES.opSortBy(ReservationTable.this.getFieldName(column));
                    }
                });
            }
            header.add(h);
        }
        this.iReservations.addRow(null, header);
        int total = 0;
        int lastLike = 0;
        int projection = 0;
        int enrollment = 0;
        boolean unlimited = false;
        for (ReservationInterface reservation : reservations) {
            ArrayList<Object> line = new ArrayList<Object>();
            if (this.iOfferingId == null) {
                VerticalPanel courses = new VerticalPanel();
                courses.add((Widget)new Label(reservation.getOffering().getAbbv(), false));
                for (ReservationInterface.Course course : reservation.getOffering().getCourses()) {
                    if (course.getAbbv().equals(reservation.getOffering().getAbbv())) continue;
                    Label l = new Label(course.getAbbv(), false);
                    l.getElement().getStyle().setMarginLeft(10.0, Style.Unit.PX);
                    l.getElement().getStyle().setColor("gray");
                    courses.add((Widget)l);
                }
                if (reservation.isExpired()) {
                    courses.addStyleName("unitime-Disabled");
                }
                if (reservation.isEditable()) {
                    courses.addStyleName("unitime-Editable");
                }
                line.add(courses);
            }
            Integer limit = reservation.getLimit();
            if (reservation instanceof ReservationInterface.CourseReservation) {
                line.add(new Label(MESSAGES.reservationCourseAbbv()));
                ReservationInterface.Course course = ((ReservationInterface.CourseReservation)reservation).getCourse();
                limit = course.getLimit();
                line.add(new Label(course.getAbbv(), false));
            } else if (reservation instanceof ReservationInterface.IndividualReservation) {
                if (reservation instanceof ReservationInterface.OverrideReservation) {
                    line.add(new Label(CONSTANTS.reservationOverrideTypeAbbv()[((ReservationInterface.OverrideReservation)reservation).getType().ordinal()]));
                } else {
                    line.add(new Label(MESSAGES.reservationIndividualAbbv()));
                }
                VerticalPanel students = new VerticalPanel();
                limit = ((ReservationInterface.IndividualReservation)reservation).getStudents().size();
                for (Iterator<ReservationInterface.IdName> student : ((ReservationInterface.IndividualReservation)reservation).getStudents()) {
                    students.add((Widget)new Label(((ReservationInterface.IdName)((Object)student)).getName(), false));
                }
                if (reservation.isExpired()) {
                    students.addStyleName("unitime-Disabled");
                }
                if (reservation.isEditable()) {
                    students.addStyleName("unitime-Editable");
                }
                line.add(students);
            } else if (reservation instanceof ReservationInterface.GroupReservation) {
                line.add(new Label(MESSAGES.reservationStudentGroupAbbv()));
                ReservationInterface.IdName group = ((ReservationInterface.GroupReservation)reservation).getGroup();
                line.add(new Label(group.getAbbv() + " - " + group.getName() + " (" + group.getLimit() + ")", false));
            } else if (reservation instanceof ReservationInterface.CurriculumReservation) {
                Label l;
                Iterator<ReservationInterface.IdName> student;
                line.add(new Label(MESSAGES.reservationCurriculumAbbv()));
                ReservationInterface.Area curriculum = ((ReservationInterface.CurriculumReservation)reservation).getCurriculum();
                VerticalPanel verticalPanel = new VerticalPanel();
                verticalPanel.add((Widget)new Label(curriculum.getAbbv() + " - " + curriculum.getName()));
                for (ReservationInterface.IdName clasf : curriculum.getClassifications()) {
                    l = new Label(clasf.getAbbv() + " - " + clasf.getName());
                    l.getElement().getStyle().setMarginLeft(10.0, Style.Unit.PX);
                    verticalPanel.add((Widget)l);
                }
                student = curriculum.getMajors().iterator();
                while (student.hasNext()) {
                    ReservationInterface.IdName major = student.next();
                    l = new Label(major.getAbbv() + " - " + major.getName());
                    l.getElement().getStyle().setMarginLeft(10.0, Style.Unit.PX);
                    verticalPanel.add((Widget)l);
                }
                if (reservation.isExpired()) {
                    verticalPanel.addStyleName("unitime-Disabled");
                }
                if (reservation.isEditable()) {
                    verticalPanel.addStyleName("unitime-Editable");
                }
                line.add(verticalPanel);
            } else {
                line.add(new Label(MESSAGES.reservationUnknownAbbv()));
                line.add(new Label());
            }
            VerticalPanel restrictions = new VerticalPanel();
            for (ReservationInterface.Config config : reservation.getConfigs()) {
                restrictions.add((Widget)new Label(MESSAGES.selectionConfiguration(config.getName(), config.getLimit() == null ? MESSAGES.configUnlimited() : config.getLimit().toString())));
            }
            for (ReservationInterface.Clazz clazz : reservation.getClasses()) {
                restrictions.add((Widget)new Label(clazz.getName() + " (" + clazz.getLimit() + ")", false));
            }
            line.add(restrictions);
            if (reservation.isExpired()) {
                restrictions.addStyleName("unitime-Disabled");
            }
            if (reservation.isEditable()) {
                restrictions.addStyleName("unitime-Editable");
            }
            line.add(new Number(limit == null ? MESSAGES.infinity() : String.valueOf(limit)));
            if (limit == null) {
                unlimited = true;
            } else {
                total += limit.intValue();
            }
            if (reservation.getLastLike() != null) {
                line.add(new Number(reservation.getLastLike().toString()));
                lastLike += reservation.getLastLike().intValue();
            } else {
                line.add(new Label(""));
            }
            if (reservation.getProjection() != null) {
                line.add(new Number(reservation.getProjection().toString()));
                projection += reservation.getProjection().intValue();
            } else {
                line.add(new Label(""));
            }
            if (reservation.getEnrollment() != null) {
                line.add(new Number(reservation.getEnrollment().toString()));
                enrollment += reservation.getEnrollment().intValue();
            } else {
                line.add(new Label(""));
            }
            if (reservation instanceof ReservationInterface.OverrideReservation && !((ReservationInterface.OverrideReservation)reservation).getType().isCanHaveExpirationDate()) {
                line.add(new Label(MESSAGES.reservationOverrideAbbv()));
            } else {
                line.add(new Label(reservation.getExpirationDate() == null ? "" : sDF.format(reservation.getExpirationDate())));
            }
            this.iReservations.addRow(reservation, line);
            this.iReservations.getRowFormatter().setVerticalAlign(this.iReservations.getRowCount() - 1, HasVerticalAlignment.ALIGN_TOP);
            if (reservation.isExpired()) {
                this.iReservations.getRowFormatter().addStyleName(this.iReservations.getRowCount() - 1, "unitime-Disabled");
            }
            if (!reservation.isEditable()) continue;
            this.iReservations.getRowFormatter().addStyleName(this.iReservations.getRowCount() - 1, "unitime-Editable");
        }
        if (this.iOfferingId != null) {
            ArrayList<HTML> footer = new ArrayList<HTML>();
            footer.add(new TotalLabel(MESSAGES.totalReservedSpace(), 3));
            footer.add(new TotalNumber(unlimited ? MESSAGES.infinity() : String.valueOf(total)));
            footer.add(new TotalNumber(lastLike <= 0 ? "" : String.valueOf(lastLike)));
            footer.add(new TotalNumber(projection <= 0 ? "" : String.valueOf(projection)));
            footer.add(new TotalNumber(enrollment <= 0 ? "" : String.valueOf(enrollment)));
            footer.add(new TotalLabel("&nbsp;", 1));
            this.iReservations.addRow(null, footer);
        } else if (reservations.isEmpty()) {
            this.iHeader.setErrorMessage(MESSAGES.errorNoMatchingReservation());
        }
        int sortBy = ReservationCookie.getInstance().getSortBy();
        if (sortBy != 0) {
            int col = Math.abs(sortBy) - 1;
            ReservationColumn column = ReservationColumn.values()[col];
            Comparator<ReservationInterface> cmp = column.getComparator();
            if (cmp != null) {
                void var13_29;
                boolean asc = sortBy > 0;
                Object var13_26 = null;
                if (this.iOfferingId == null) {
                    UniTimeTableHeader uniTimeTableHeader = (UniTimeTableHeader)header.get(col);
                } else if (Math.abs(sortBy) > 1) {
                    UniTimeTableHeader uniTimeTableHeader = (UniTimeTableHeader)header.get(col - 1);
                }
                this.iReservations.sort((UniTimeTableHeader)var13_29, cmp, asc);
            }
        }
    }

    public void insert(RootPanel panel) {
        this.initCallbacks();
        this.iOfferingId = Long.valueOf(panel.getElement().getInnerText());
        if (ReservationCookie.getInstance().getReservationCoursesDetails()) {
            this.refresh();
        } else {
            this.clear(false);
            this.iHeader.clearMessage();
            this.iHeader.setCollapsible(false);
        }
        panel.getElement().setInnerText(null);
        panel.add((Widget)this);
        panel.setVisible(true);
        this.addReservationClickHandler(new ReservationClickHandler(){

            public void onClick(ReservationClickedEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "gwt.jsp?page=reservation&id=" + evt.getReservation().getId() + "&reservations=" + ReservationTable.this.getReservationIds());
            }
        });
    }

    public void scrollIntoView(Long reservationId) {
        for (int r = 1; r < this.iReservations.getRowCount(); ++r) {
            if (this.iReservations.getData(r) == null || !this.iReservations.getData(r).getId().equals(reservationId)) continue;
            this.iReservations.getRowFormatter().getElement(r).scrollIntoView();
        }
    }

    public void addReservationClickHandler(ReservationClickHandler h) {
        this.iReservationClickHandlers.add(h);
    }

    public void query(ReservationInterface.ReservationFilterRpcRequest filter, final AsyncCallback<List<ReservationInterface>> callback) {
        this.iLastQuery = filter;
        this.clear(true);
        this.iReservationService.findReservations(filter, new AsyncCallback<List<ReservationInterface>>(){

            public void onSuccess(List<ReservationInterface> result) {
                ReservationTable.this.populate(result);
                ReservationTable.this.iHeader.clearMessage();
                if (callback != null) {
                    callback.onSuccess(result);
                }
            }

            public void onFailure(Throwable caught) {
                ReservationTable.this.iHeader.setErrorMessage(MESSAGES.failedToLoadReservations(caught.getMessage()));
                ToolBox.checkAccess(caught);
                if (callback != null) {
                    callback.onFailure(caught);
                }
            }
        });
    }

    public void select(Long curriculumId) {
        for (int i = 0; i < this.iReservations.getRowCount(); ++i) {
            ReservationInterface r = this.iReservations.getData(i);
            if (r == null) continue;
            if (r.getId().equals(curriculumId)) {
                this.iReservations.getRowFormatter().setStyleName(i, "unitime-TableRowSelected");
                continue;
            }
            if (!"unitime-TableRowSelected".equals(this.iReservations.getRowFormatter().getStyleName(i))) continue;
            this.iReservations.getRowFormatter().removeStyleName(i, "unitime-TableRowSelected");
        }
    }

    public void setErrorMessage(String message) {
        this.iHeader.setErrorMessage(message);
    }

    public ReservationInterface getNext(Long reservationId) {
        for (int row = 1; row < this.iReservations.getRowCount() - 1; ++row) {
            ReservationInterface r = this.iReservations.getData(row);
            if (r == null || !r.getId().equals(reservationId)) continue;
            return this.iReservations.getData(row + 1);
        }
        return null;
    }

    public ReservationInterface getPrevious(Long reservationId) {
        for (int row = 2; row < this.iReservations.getRowCount(); ++row) {
            ReservationInterface r = this.iReservations.getData(row);
            if (r == null || !r.getId().equals(reservationId)) continue;
            return this.iReservations.getData(row - 1);
        }
        return null;
    }

    public String getReservationIds() {
        String ret = "";
        for (int row = 1; row < this.iReservations.getRowCount(); ++row) {
            ReservationInterface r = this.iReservations.getData(row);
            if (r == null || r.getId() == null) continue;
            ret = ret + (ret.isEmpty() ? "" : ",") + r.getId();
        }
        return ret;
    }

    public String getColumnWidth(ReservationColumn column) {
        switch (column) {
            case OFFERING: 
            case TYPE: {
                return "100px";
            }
            case OWNER: {
                return "250px";
            }
            case RESTRICTIONS: {
                return "160px";
            }
            case RESERVED_SPACE: 
            case LAST_LIKE: 
            case PROJECTED_BY_RULE: 
            case CURRENT_ENROLLMENT: 
            case EXPIRATION_DATE: {
                return "80px";
            }
        }
        return null;
    }

    public String getColumnName(ReservationColumn column) {
        switch (column) {
            case OFFERING: {
                return MESSAGES.colInstructionalOffering();
            }
            case TYPE: {
                return MESSAGES.colReservationType();
            }
            case OWNER: {
                return MESSAGES.colOwner();
            }
            case RESTRICTIONS: {
                return MESSAGES.colRestrictions();
            }
            case RESERVED_SPACE: {
                return MESSAGES.colReservedSpace();
            }
            case LAST_LIKE: {
                return MESSAGES.colLastLikeEnrollment();
            }
            case PROJECTED_BY_RULE: {
                return MESSAGES.colProjectedByRule();
            }
            case CURRENT_ENROLLMENT: {
                return MESSAGES.colCurrentEnrollment();
            }
            case EXPIRATION_DATE: {
                return MESSAGES.colExpirationDate();
            }
        }
        return null;
    }

    public String getFieldName(ReservationColumn column) {
        switch (column) {
            case OFFERING: {
                return MESSAGES.fieldInstructionalOffering();
            }
            case TYPE: {
                return MESSAGES.fieldReservationType();
            }
            case OWNER: {
                return MESSAGES.fieldOwner();
            }
            case RESTRICTIONS: {
                return MESSAGES.colRestrictions();
            }
            case RESERVED_SPACE: {
                return MESSAGES.fieldReservedSpace();
            }
            case LAST_LIKE: {
                return MESSAGES.fieldLastLikeEnrollment();
            }
            case PROJECTED_BY_RULE: {
                return MESSAGES.fieldProjectedByRule();
            }
            case CURRENT_ENROLLMENT: {
                return MESSAGES.fieldCurrentEnrollment();
            }
            case EXPIRATION_DATE: {
                return MESSAGES.fieldExpirationDate();
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReservationColumn implements IsSerializable
    {
        OFFERING,
        TYPE,
        OWNER,
        RESTRICTIONS,
        RESERVED_SPACE,
        LAST_LIKE,
        PROJECTED_BY_RULE,
        CURRENT_ENROLLMENT,
        EXPIRATION_DATE;


        public Comparator<ReservationInterface> getComparator() {
            switch (this) {
                case OFFERING: {
                    return new Comparator<ReservationInterface>(){

                        @Override
                        public int compare(ReservationInterface r1, ReservationInterface r2) {
                            return r1.compareTo(r2);
                        }
                    };
                }
                case TYPE: {
                    return new Comparator<ReservationInterface>(){

                        @Override
                        public int compare(ReservationInterface r1, ReservationInterface r2) {
                            int cmp = new Integer(r1.getPriority()).compareTo(r2.getPriority());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return r1.compareTo(r2);
                        }
                    };
                }
                case OWNER: {
                    return new Comparator<ReservationInterface>(){

                        @Override
                        public int compare(ReservationInterface r1, ReservationInterface r2) {
                            int cmp = new Integer(r1.getPriority()).compareTo(r2.getPriority());
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = r1.toString().compareTo(r2.toString());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return r1.compareTo(r2);
                        }
                    };
                }
                case RESTRICTIONS: {
                    return new Comparator<ReservationInterface>(){

                        @Override
                        public int compare(ReservationInterface r1, ReservationInterface r2) {
                            int cmp = r1.getOffering().getAbbv().compareTo(r2.getOffering().getAbbv());
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = r1.getConfigs().toString().compareTo(r2.getConfigs().toString());
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = r1.getClasses().toString().compareTo(r2.getClasses().toString());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return r1.compareTo(r2);
                        }
                    };
                }
                case RESERVED_SPACE: {
                    return new Comparator<ReservationInterface>(){

                        @Override
                        public int compare(ReservationInterface r1, ReservationInterface r2) {
                            int cmp = new Integer(r1.getLimit() == null ? Integer.MAX_VALUE : r1.getLimit()).compareTo(r2.getLimit() == null ? Integer.MAX_VALUE : r2.getLimit());
                            if (cmp != 0) {
                                return -cmp;
                            }
                            return r1.compareTo(r2);
                        }
                    };
                }
                case LAST_LIKE: {
                    return new Comparator<ReservationInterface>(){

                        @Override
                        public int compare(ReservationInterface r1, ReservationInterface r2) {
                            int cmp = new Integer(r1.getLastLike() == null ? -1 : r1.getLastLike()).compareTo(r2.getLastLike() == null ? -1 : r2.getLastLike());
                            if (cmp != 0) {
                                return -cmp;
                            }
                            return r1.compareTo(r2);
                        }
                    };
                }
                case PROJECTED_BY_RULE: {
                    return new Comparator<ReservationInterface>(){

                        @Override
                        public int compare(ReservationInterface r1, ReservationInterface r2) {
                            int cmp = new Integer(r1.getProjection() == null ? -1 : r1.getProjection()).compareTo(r2.getProjection() == null ? -1 : r2.getProjection());
                            if (cmp != 0) {
                                return -cmp;
                            }
                            return r1.compareTo(r2);
                        }
                    };
                }
                case CURRENT_ENROLLMENT: {
                    return new Comparator<ReservationInterface>(){

                        @Override
                        public int compare(ReservationInterface r1, ReservationInterface r2) {
                            int cmp = new Integer(r1.getEnrollment() == null ? -1 : r1.getEnrollment()).compareTo(r2.getEnrollment() == null ? -1 : r2.getEnrollment());
                            if (cmp != 0) {
                                return -cmp;
                            }
                            return r1.compareTo(r2);
                        }
                    };
                }
                case EXPIRATION_DATE: {
                    return new Comparator<ReservationInterface>(){

                        @Override
                        public int compare(ReservationInterface r1, ReservationInterface r2) {
                            int cmp = new Long(r1.getExpirationDate() == null ? Long.MAX_VALUE : r1.getExpirationDate().getTime()).compareTo(r2.getExpirationDate() == null ? Long.MAX_VALUE : r2.getExpirationDate().getTime());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return r1.compareTo(r2);
                        }
                    };
                }
            }
            return null;
        }
    }

    public static interface ReservationClickHandler {
        public void onClick(ReservationClickedEvent var1);
    }

    public static class ReservationClickedEvent {
        private ReservationInterface iReservation;

        public ReservationClickedEvent(ReservationInterface reservation) {
            this.iReservation = reservation;
        }

        public ReservationInterface getReservation() {
            return this.iReservation;
        }
    }

    private static class TotalLabel
    extends HTML
    implements UniTimeTable.HasColSpan,
    UniTimeTable.HasStyleName {
        private int iColSpan;

        public TotalLabel(String text, int colspan) {
            super(text, false);
            this.iColSpan = colspan;
        }

        public int getColSpan() {
            return this.iColSpan;
        }

        public String getStyleName() {
            return "unitime-TotalRow";
        }
    }

    private static class TotalNumber
    extends Number
    implements UniTimeTable.HasStyleName {
        public TotalNumber(String text) {
            super(text);
        }

        public String getStyleName() {
            return "unitime-TotalRow";
        }
    }

    private static class Number
    extends HTML
    implements UniTimeTable.HasCellAlignment {
        public Number(String text) {
            super(text, false);
        }

        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }
    }
}

