/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.admin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;

public class PasswordPage
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimpleForm iForm = new SimpleForm();
    private TextBox iUser = null;
    private TextBox iEmail = null;
    private UniTimeHeaderPanel iHeader = new UniTimeHeaderPanel(MESSAGES.headerChangePassword());
    private UniTimeHeaderPanel iFooter = this.iHeader.clonePanel("");
    private int iFooterRow;
    private PasswordTextBox iOldPassword;
    private PasswordTextBox iNewPassword;
    private PasswordTextBox iRetypePassword;

    public PasswordPage() {
        this.iForm.addHeaderRow((Widget)this.iHeader);
        if ("1".equals(Window.Location.getParameter((String)"reset"))) {
            this.iHeader.setHeaderTitle(MESSAGES.headerResetPassword());
            this.iFooter.addButton("reset", MESSAGES.buttonReset(), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    PasswordPage.this.iFooter.clearMessage();
                    if (PasswordPage.this.iEmail.getValue().isEmpty() || !PasswordPage.this.iEmail.getValue().contains("@")) {
                        PasswordPage.this.iFooter.setErrorMessage(MESSAGES.errorEmailNotValid());
                    } else {
                        LoadingWidget.getInstance().show(MESSAGES.waitPasswordReset());
                        PasswordPage.this.RPC.execute(PasswordChangeRequest.resetPassword(PasswordPage.this.iEmail.getValue()), new AsyncCallback<PasswordChangeResponse>(){

                            public void onFailure(Throwable caught) {
                                LoadingWidget.getInstance().hide();
                                PasswordPage.this.iFooter.setErrorMessage(caught.getMessage());
                            }

                            public void onSuccess(PasswordChangeResponse result) {
                                LoadingWidget.getInstance().hide();
                                PasswordPage.this.iFooter.setMessage(MESSAGES.messagePasswordReset());
                                PasswordPage.this.iFooter.setEnabled("reset", false);
                                for (int i = 1; i < PasswordPage.this.iFooterRow; ++i) {
                                    PasswordPage.this.iForm.getRowFormatter().setVisible(i, false);
                                }
                            }
                        });
                    }
                }
            });
            this.iEmail = new TextBox();
            this.iEmail.setStyleName("gwt-SuggestBox");
            this.iForm.addRow(MESSAGES.fieldEmail(), (Widget)this.iEmail);
        } else {
            this.iFooter.addButton("change", MESSAGES.buttonChange(), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    PasswordPage.this.iFooter.clearMessage();
                    if (PasswordPage.this.iOldPassword.getValue().isEmpty()) {
                        PasswordPage.this.iFooter.setErrorMessage(MESSAGES.errorOldPasswordNotValid());
                    } else if (PasswordPage.this.iNewPassword.getValue().isEmpty()) {
                        PasswordPage.this.iFooter.setErrorMessage(MESSAGES.errorEnterNewPassword());
                    } else if (!PasswordPage.this.iNewPassword.getValue().equals(PasswordPage.this.iRetypePassword.getValue())) {
                        PasswordPage.this.iFooter.setErrorMessage(MESSAGES.errorNewPasswordMismatch());
                    } else {
                        PasswordPage.this.iFooter.setEnabled("change", false);
                        PasswordPage.this.RPC.execute(PasswordChangeRequest.changePassword(PasswordPage.this.iUser == null ? null : PasswordPage.this.iUser.getValue(), PasswordPage.this.iOldPassword.getValue(), PasswordPage.this.iNewPassword.getValue()), new AsyncCallback<PasswordChangeResponse>(){

                            public void onFailure(Throwable caught) {
                                PasswordPage.this.iFooter.setEnabled("change", true);
                                PasswordPage.this.iFooter.setErrorMessage(caught.getMessage());
                            }

                            public void onSuccess(PasswordChangeResponse result) {
                                PasswordPage.this.iOldPassword.setValue((Object)"");
                                PasswordPage.this.iNewPassword.setValue((Object)"");
                                PasswordPage.this.iRetypePassword.setValue((Object)"");
                                PasswordPage.this.iFooter.setMessage(MESSAGES.messagePasswordChanged());
                                PasswordPage.this.iFooter.setEnabled("change", false);
                                for (int i = 1; i < PasswordPage.this.iFooterRow; ++i) {
                                    PasswordPage.this.iForm.getRowFormatter().setVisible(i, false);
                                }
                            }
                        });
                    }
                }
            });
            if (Window.Location.getParameter((String)"user") != null) {
                this.iUser = new TextBox();
                this.iUser.setStyleName("gwt-SuggestBox");
                this.iUser.setValue((Object)Window.Location.getParameter((String)"user"));
                this.iForm.addRow(MESSAGES.fieldUsername(), (Widget)this.iUser);
            }
            this.iOldPassword = new PasswordTextBox();
            this.iOldPassword.setStyleName("gwt-SuggestBox");
            this.iForm.addRow(MESSAGES.fieldOldPassword(), (Widget)this.iOldPassword);
            if (Window.Location.getParameter((String)"key") != null) {
                this.iOldPassword.setValue((Object)Window.Location.getParameter((String)"key"));
            }
            this.iNewPassword = new PasswordTextBox();
            this.iNewPassword.setStyleName("gwt-SuggestBox");
            this.iForm.addRow(MESSAGES.fieldNewPassword(), (Widget)this.iNewPassword);
            this.iRetypePassword = new PasswordTextBox();
            this.iRetypePassword.setStyleName("gwt-SuggestBox");
            this.iForm.addRow(MESSAGES.fieldRetypePassword(), (Widget)this.iRetypePassword);
        }
        this.iFooterRow = this.iForm.addBottomRow((Widget)this.iFooter);
        this.initWidget((Widget)this.iForm);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PasswordChangeRequest
    implements GwtRpcRequest<PasswordChangeResponse> {
        private String iUsername;
        private String iEmail;
        private String iOldPassword;
        private String iNewPassword;
        private boolean iReset = false;

        public void setUsername(String username) {
            this.iUsername = username;
        }

        public boolean hasUsername() {
            return this.iUsername != null && !this.iUsername.isEmpty();
        }

        public String getUsername() {
            return this.iUsername;
        }

        public void setEmail(String email) {
            this.iEmail = email;
        }

        public boolean hasEmail() {
            return this.iEmail != null && !this.iEmail.isEmpty();
        }

        public String getEmail() {
            return this.iEmail;
        }

        public void setOldPassword(String passwd) {
            this.iOldPassword = passwd;
        }

        public String getOldPassword() {
            return this.iOldPassword;
        }

        public void setNewPassword(String passwd) {
            this.iNewPassword = passwd;
        }

        public String getNewPassword() {
            return this.iNewPassword;
        }

        public void setReset(boolean reset) {
            this.iReset = reset;
        }

        public boolean isReset() {
            return this.iReset;
        }

        public static PasswordChangeRequest changePassword(String username, String oldPasswd, String newPasswd) {
            PasswordChangeRequest req = new PasswordChangeRequest();
            req.setUsername(username);
            req.setOldPassword(oldPasswd);
            req.setNewPassword(newPasswd);
            return req;
        }

        public static PasswordChangeRequest resetPassword(String email) {
            PasswordChangeRequest req = new PasswordChangeRequest();
            req.setEmail(email);
            req.setReset(true);
            return req;
        }

        @Override
        public String toString() {
            return "";
        }
    }

    public static class PasswordChangeResponse
    implements GwtRpcResponse {
    }
}

