/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverPredefinedSetting;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.solver.ui.LogInfo;
import org.unitime.timetable.solver.ui.PropertiesInfo;
import org.unitime.timetable.util.Formats;

public class ListSolutionsForm
extends ActionForm {
    private static final long serialVersionUID = 632293328433911455L;
    private static Formats.Format<Date> sDF = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
    private Vector iMessages = new Vector();
    private String iOp = null;
    private Long iEmptySetting = null;
    private Vector iSettings = null;
    private SolverProxy iSolver = null;
    private String iHost = null;
    private String iHostEmpty = null;
    private Long iOwnerId = null;
    private Vector iSolutionBeans = new Vector();
    private int iSelectedSolutionBean = -1;
    private Long iSetting = null;
    private String iNote = null;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.iSelectedSolutionBean < 0 || this.iSelectedSolutionBean >= this.iSolutionBeans.size()) {
            errors.add("selectedSolutionBean", new ActionMessage("errors.general", (Object)"No solution selected"));
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.iOp = null;
        this.iNote = null;
        this.iSolutionBeans.clear();
        this.iSelectedSolutionBean = -1;
        this.iSettings = SolverPredefinedSetting.getIdValueList(0);
        this.iEmptySetting = null;
        this.iSetting = null;
        if (this.iSettings != null && !this.iSettings.isEmpty()) {
            this.iSetting = this.iEmptySetting = ((SolverPredefinedSetting.IdValue)this.iSettings.firstElement()).getId();
        }
        this.iSolver = WebSolver.getSolver(request.getSession());
        this.iMessages.clear();
        SolverProxy solver = WebSolver.getSolver(request.getSession());
        this.iHostEmpty = this.iHost = solver == null ? "auto" : solver.getHost();
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public String getOp() {
        return this.iOp;
    }

    public void setNote(String note) {
        this.iNote = note;
    }

    public String getNote() {
        return this.iNote;
    }

    public Vector getSettings() {
        return this.iSettings;
    }

    public void setSettings(Vector settings) {
        this.iSettings = settings;
    }

    public Long getEmptySetting() {
        return this.iEmptySetting;
    }

    public void setEmptySetting(Long setting) {
        this.iEmptySetting = setting;
    }

    public boolean getHasSettings() {
        return this.iSettings != null && !this.iSettings.isEmpty();
    }

    public void setSolver(SolverProxy solver) {
        this.iSolver = solver;
    }

    public SolverProxy getSolver() {
        return this.iSolver;
    }

    public String getSolverNote() throws Exception {
        if (this.iSolver == null) {
            return null;
        }
        return this.iSolver.getNote();
    }

    public void setSolverNote(String note) throws Exception {
        if (this.iSolver != null) {
            this.iSolver.setNote(note);
        }
    }

    public Vector getMessages() {
        return this.iMessages;
    }

    public String getHost() {
        return this.iHost;
    }

    public void setHost(String host) {
        this.iHost = host;
    }

    public String getHostEmpty() {
        return this.iHostEmpty;
    }

    public void setHostEmpty(String hostEmpty) {
        this.iHostEmpty = hostEmpty;
    }

    public Long getOwnerId() {
        return this.iOwnerId;
    }

    public void setOwnerId(Long ownerId) {
        this.iOwnerId = ownerId;
    }

    public Long getSetting() {
        return this.iSetting;
    }

    public void setSetting(Long setting) {
        this.iSetting = setting;
    }

    public Vector getSolutionBeans() {
        return this.iSolutionBeans;
    }

    public void setSolutionBeans(Vector solutionBeans) {
        this.iSolutionBeans = solutionBeans;
    }

    public int getSelectedSolutionBean() {
        return this.iSelectedSolutionBean;
    }

    public void setSelectedSolutionBean(int selectedSolutionBean) {
        this.iSelectedSolutionBean = selectedSolutionBean;
    }

    public void addSolution(Solution solution) throws Exception {
        SolutionBean solutionBean = null;
        Enumeration e = this.iSolutionBeans.elements();
        while (e.hasMoreElements()) {
            SolutionBean sb = (SolutionBean)e.nextElement();
            if (!sb.getOwnerId().equals(solution.getOwner().getUniqueId())) continue;
            solutionBean = sb;
            break;
        }
        if (solutionBean != null) {
            this.iSolutionBeans.remove(solutionBean);
        }
        this.iSolutionBeans.addElement(new SolutionBean(solution));
    }

    public String getSolutionId() {
        String solutionId = "";
        Enumeration e = this.iSolutionBeans.elements();
        while (e.hasMoreElements()) {
            SolutionBean sb = (SolutionBean)e.nextElement();
            solutionId = solutionId + sb.getUniqueId().toString();
            if (!e.hasMoreElements()) continue;
            solutionId = solutionId + ",";
        }
        return solutionId;
    }

    public void setSolutionId(String solutionId) throws Exception {
        this.iSolutionBeans.clear();
        if (solutionId == null || solutionId.length() == 0) {
            return;
        }
        StringTokenizer s = new StringTokenizer(solutionId, ",");
        while (s.hasMoreTokens()) {
            Long id = Long.valueOf(s.nextToken());
            Solution solution = (Solution)new SolutionDAO().get(id);
            if (solution == null) continue;
            this.iSolutionBeans.addElement(new SolutionBean(solution));
        }
    }

    public void removeSolution(Long solutionId) {
        SolutionBean solutionBean = null;
        Enumeration e = this.iSolutionBeans.elements();
        while (e.hasMoreElements()) {
            SolutionBean sb = (SolutionBean)e.nextElement();
            if (!sb.getUniqueId().equals(solutionId)) continue;
            solutionBean = sb;
            break;
        }
        if (solutionBean != null) {
            this.iSolutionBeans.remove(solutionBean);
        }
    }

    public SolutionBean getSolutionBean() {
        if (this.iSelectedSolutionBean < 0) {
            return null;
        }
        try {
            return (SolutionBean)this.iSolutionBeans.elementAt(this.iSelectedSolutionBean);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public SolutionBean getSolutionBean(Long solutionId) {
        Enumeration e = this.iSolutionBeans.elements();
        while (e.hasMoreElements()) {
            SolutionBean sb = (SolutionBean)e.nextElement();
            if (!sb.getUniqueId().equals(solutionId)) continue;
            return sb;
        }
        return null;
    }

    public Long[] getOwnerIds() {
        Long[] ret = new Long[this.iSolutionBeans.size()];
        for (int i = 0; i < this.iSolutionBeans.size(); ++i) {
            ret[i] = ((SolutionBean)this.iSolutionBeans.elementAt(i)).getOwnerId();
        }
        return ret;
    }

    public static class SolutionBean
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long iUniqueId = null;
        private String iCreated = null;
        private String iCommited = null;
        private String iOwner = null;
        private String iNote = null;
        private boolean iValid = false;
        private String iLog = null;
        private Properties iGlobalInfo = null;
        private Long iOwnerId = null;

        public SolutionBean() {
        }

        public SolutionBean(Solution solution) throws Exception {
            this();
            this.setSolution(solution);
        }

        public void setSolution(Solution solution) throws Exception {
            this.iUniqueId = solution.getUniqueId();
            this.iGlobalInfo = (PropertiesInfo)solution.getInfo("GlobalInfo");
            LogInfo logInfo = (LogInfo)solution.getInfo("LogInfo");
            this.iLog = logInfo == null ? null : logInfo.getHtmlLog(5, false, "Loading input data ...");
            this.iCreated = sDF.format(solution.getCreated());
            this.iCommited = solution.isCommited() != false ? sDF.format(solution.getCommitDate()) : "";
            this.iNote = solution.getNote();
            this.iOwner = solution.getOwner().getName();
            this.iOwnerId = solution.getOwner().getUniqueId();
            this.iValid = solution.isValid();
        }

        public void setUniqueId(Long uniqueId) {
            this.iUniqueId = uniqueId;
        }

        public Long getUniqueId() {
            return this.iUniqueId;
        }

        public void setCreated(String created) {
            this.iCreated = created;
        }

        public String getCreated() {
            return this.iCreated;
        }

        public void setCommited(String commited) {
            this.iCommited = commited;
        }

        public String getCommited() {
            return this.iCommited;
        }

        public void setOwner(String owner) {
            this.iOwner = owner;
        }

        public String getOwner() {
            return this.iOwner;
        }

        public void setOwnerId(Long ownerId) {
            this.iOwnerId = ownerId;
        }

        public Long getOwnerId() {
            return this.iOwnerId;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public String getNote() {
            return this.iNote;
        }

        public void setValid(boolean valid) {
            this.iValid = valid;
        }

        public boolean getValid() {
            return this.iValid;
        }

        public String getLog() {
            return this.iLog;
        }

        public void setLog(String log) {
            this.iLog = log;
        }

        public void setGlobalInfo(Properties globalInfo) {
            this.iGlobalInfo = globalInfo;
        }

        public Properties getGlobalInfo() {
            return this.iGlobalInfo;
        }

        public String getInfo(String key) {
            try {
                return this.iGlobalInfo.getProperty(key);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public void setInfo(String key, String value) {
            this.iGlobalInfo.setProperty(key, value);
        }

        public Collection getInfos() {
            if (this.iGlobalInfo == null) {
                return new Vector();
            }
            Vector<Object> infos = new Vector<Object>(this.iGlobalInfo.keySet());
            Collections.sort(infos, new InfoComparator());
            return infos;
        }

        public int hashCode() {
            return this.iUniqueId.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof SolutionBean)) {
                return false;
            }
            return this.getUniqueId().equals(((SolutionBean)o).getUniqueId());
        }
    }

    public static class InfoComparator
    implements Comparator {
        private static Vector sInfoKeys = null;

        public int compare(Object o1, Object o2) {
            String key1 = (String)o1;
            String key2 = (String)o2;
            int i1 = sInfoKeys.indexOf(key1);
            int i2 = sInfoKeys.indexOf(key2);
            if (i1 < 0) {
                if (i2 < 0) {
                    return key1.compareTo(key2);
                }
                return 1;
            }
            if (i2 < 0) {
                return -1;
            }
            return i1 < i2 ? -1 : 1;
        }

        static {
            sInfoKeys = new Vector();
            sInfoKeys.add("Assigned variables");
            sInfoKeys.add("Overall solution value");
            sInfoKeys.add("Time preferences");
            sInfoKeys.add("Student conflicts");
            sInfoKeys.add("Room preferences");
            sInfoKeys.add("Distribution preferences");
            sInfoKeys.add("Back-to-back instructor preferences");
            sInfoKeys.add("Too big rooms");
            sInfoKeys.add("Useless half-hours");
            sInfoKeys.add("Same subpart balancing penalty");
            sInfoKeys.add("Department balancing penalty");
            sInfoKeys.add("Direct Conflicts");
            sInfoKeys.add("More Than 2 A Day Conflicts");
            sInfoKeys.add("Back-To-Back Conflicts");
            sInfoKeys.add("Distance Back-To-Back Conflicts");
            sInfoKeys.add("Instructor Direct Conflicts");
            sInfoKeys.add("Instructor More Than 2 A Day Conflicts");
            sInfoKeys.add("Instructor Back-To-Back Conflicts");
            sInfoKeys.add("Instructor Distance Back-To-Back Conflicts");
            sInfoKeys.add("Period Penalty");
            sInfoKeys.add("Period&times;Size Penalty");
            sInfoKeys.add("Exam Rotation Penalty");
            sInfoKeys.add("Average Period");
            sInfoKeys.add("Room Penalty");
            sInfoKeys.add("Room Split Penalty");
            sInfoKeys.add("Room Split Distance Penalty");
            sInfoKeys.add("Room Size Penalty");
            sInfoKeys.add("Not-Original Room Penalty");
            sInfoKeys.add("Distribution Penalty");
            sInfoKeys.add("Large Exams Penalty");
            sInfoKeys.add("Perturbation Penalty");
            sInfoKeys.add("Perturbation penalty");
            sInfoKeys.add("Room Perturbation Penalty");
            sInfoKeys.add("Perturbation variables");
            sInfoKeys.add("Perturbations: Total penalty");
            sInfoKeys.add("Time");
            sInfoKeys.add("Iteration");
            sInfoKeys.add("Memory usage");
            sInfoKeys.add("Speed");
        }
    }
}

